<div class="github-widget" data-repo="MyHoneyBadger/awesome-github-wiki"></div>
## Awesome GitHub Wikis [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) [![Awesome Lint](https://github.com/MyHoneyBadger/awesome-github-wiki/actions/workflows/action.yml/badge.svg?branch=main)](https://github.com/MyHoneyBadger/awesome-github-wiki/actions/workflows/action.yml?query=branch%3Amain) [![Track Awesome List](https://www.trackawesomelist.com/badge.svg)](https://www.trackawesomelist.com/MyHoneyBadger/awesome-github-wiki/)
> A curated list of awesome GitHub Wikis

Every repository on [GitHub.com](https://github.com/) comes equipped with a section for hosting documentation, called a [Wiki](https://docs.github.com/en/communities/documenting-your-project-with-wikis/about-wikis). Repository's Wiki shares long-form content about project, such as how to use it, how you designed it, or its core principles. A README file quickly tells what project can do, while use a Wiki to provide additional documentation.


## Examples
Wiki should be detail, up to date and well structured. It should be easy to find required information and navigate through the pages. Use rich possibilities of Markdown in Wiki formatting. Wiki doesn't fully repeat information which is already presented at README. The following list of examples represents mentioned good practices:    
- [Netflix/Hystrix](https://github.com/Netflix/Hystrix/wiki)
- [aws/aws-parallelcluster](https://github.com/aws/aws-parallelcluster/wiki)
- [facebook/hhvm](https://github.com/facebook/hhvm/wiki)
- [thinkaurelius/titan](https://github.com/thinkaurelius/titan/wiki)
- [guard/guard](https://github.com/guard/guard/wiki/Guard-2.10.3-exits-when-Guardfile-is-changed)
- [apple/foundationdb](https://github.com/apple/foundationdb/wiki)
- [google/guava](https://github.com/google/guava/wiki)
- [hyperledger/cacti](https://github.com/hyperledger/cacti/wiki)
- [facebook/react-native](https://github.com/facebook/react-native/wiki)
- [FortAwesome/Font-Awesome](https://github.com/FortAwesome/Font-Awesome/wiki)
- [uber/NullAway](https://github.com/uber/NullAway/wiki)
- [internetarchive/openlibrary](https://github.com/internetarchive/openlibrary/wiki)

## Useful links with tips & tricks
- [Learning GitHub - Making Wikis](https://www.youtube.com/watch?v=bnMl0d-RcPQ)
- [Creating a GitHub Wiki documentation for your repository](https://carldesouza.com/creating-a-github-wiki-documentation-for-your-repository/)
- [Git Tutorial - 24 - GitHub Wiki](https://www.youtube.com/watch?v=4B0XNThjO0E)
- [Search wiki of the repository on GitHub](https://github.com/linyows/github-wiki-search)
- [How To Add Images To A GitHub Wiki](http://mikehadlow.blogspot.com/2014/03/how-to-add-images-to-github-wiki.html)
- [GitHub Wiki Markdown tips and examples](https://medium.com/@apcoyne100/github-wiki-markdown-tips-and-examples-1bab1f0c0d25)
- [GitHub Projects, Teams, Fork & Wiki For Documenting Projects](https://www.softwaretestinghelp.com/github-projects-teams-fork-wiki)
- [Using GitHub Wiki for Software Development Documentation](https://sparkbox.com/foundry/github_wiki_tutorial_for_technical_wiki_documentation)
- [GitHub Wiki by Nimble](https://nimblehq.co/compass/development/documentation/github-wiki/)
- [Building a better GitHub Wiki](https://bugherd.com/blog/building-a-better-github-wiki/)
- [Hack GitHub to build your own wiki in five steps](https://ably.com/blog/hacking-github-to-build-your-own-wiki)
- [Upload images to Wiki pages](https://github.blog/changelog/2022-02-14-upload-images-to-wiki-pages/)
- [Git And GitHub Course - Master Git And GitHub - GitHub Wiki](https://www.learnvern.com/git-and-github-tutorial/wiki)
- [How to Use GitHub as a Wiki: Examples & Templates](https://almanac.io/blog/github-wiki-examples-templates)
- [How To Use GitHub Wikis For Collaborative Documentation](https://labs.inn.org/2014/05/19/applying-git-to-github-wikis/)
- [GitHub Wiki Action. Keep your dev docs in sync with your code](https://github.com/marketplace/actions/github-wiki-action)

## Useful Stack Overflow questions & answers
- [How can I embed a YouTube video on GitHub Wiki pages?](https://stackoverflow.com/questions/11804820/how-can-i-embed-a-youtube-video-on-github-wiki-pages)
- [Resize image in the wiki of GitHub using Markdown](https://stackoverflow.com/questions/24383700/resize-image-in-the-wiki-of-github-using-markdown)
- [Linking to other Wiki pages on GitHub?](https://stackoverflow.com/questions/6474045/linking-to-other-wiki-pages-on-github)
- [How do I clone a GitHub Wiki?](https://stackoverflow.com/questions/15080848/how-do-i-clone-a-github-wiki)
- [How do I create some kind of table of content in GitHub Wiki?](https://stackoverflow.com/questions/18244417/how-do-i-create-some-kind-of-table-of-content-in-github-wiki)
- [GitHub Wiki directories](https://stackoverflow.com/questions/11088285/github-wiki-directories)
- [GitHub Wiki - Source code syntax highlighting](https://stackoverflow.com/questions/11505503/github-wiki-source-code-syntax-highlighting)
- [How to structure GitHub Wiki files?](https://stackoverflow.com/questions/24236829/how-to-structure-github-wiki-files)
- [How do I prevent auto-generated links in the GitHub Wiki?](https://stackoverflow.com/questions/25706012/how-do-i-prevent-auto-generated-links-in-the-github-wiki)
- [How HTML5 Boilerplate converts GitHub Wiki to its website?](https://stackoverflow.com/questions/8624865/how-html5-boilerplate-converts-github-wiki-to-its-website)
- [Effortless export from GitHub Wiki](https://stackoverflow.com/questions/18759738/effortless-export-from-github-wiki)
- [ToC or Sidebar in GitHub Wiki](https://stackoverflow.com/questions/9239588/toc-or-sidebar-in-github-wiki)
- [GitHub Wiki doesn't support HTML tables anymore?](https://stackoverflow.com/questions/45657579/github-wiki-doesnt-support-html-tables-anymore)
- [How to style a JSON block in GitHub Wiki?](https://stackoverflow.com/questions/14901245/how-to-style-a-json-block-in-github-wiki)
- [Render package documentation into GitHub wiki](https://stackoverflow.com/questions/27451937/render-package-documentation-into-github-wiki)
- [How to make "spoiler" text in GitHub Wiki pages](https://stackoverflow.com/questions/32814161/how-to-make-spoiler-text-in-github-wiki-pages)
- [How to integrate a GitHub wiki into the main project](https://stackoverflow.com/questions/6941688/how-to-integrate-a-github-wiki-into-the-main-project)
- [How can I make a pull request for a Wiki page on GitHub?](https://stackoverflow.com/questions/10642928/how-can-i-make-a-pull-request-for-a-wiki-page-on-github)

## Contributing
Contributions are very welcome! Please read the [contribution guideline](https://github.com/MyHoneyBadger/awesome-github-wiki/blob/master/contributing.md) first.
