<div class="github-widget" data-repo="davisonio/awesome-gif"></div>
## Awesome GIF [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

&gt; 精选清单 [GIF](https://en.wikipedia.org/wiki/GIF) 资源.

与图形交换格式 (GIF) 相关的工具、脚本、库、示例和其他资源的列表.


<!--lint disable awesome-toc-->

## General Tools

- [FFmpeg](https://www.ffmpeg.org)
- [ImageMagick](http://www.imagemagick.org/script/index.php)
- [GraphicsMagick](http://www.graphicsmagick.org/) - GraphicsMagick 通常比 ImageMagick 快.
- [MoviePy](https://zulko.github.io/moviepy/) - 用于视频编辑的 Python 模块.

## Utilities

- [Gifgen](https://github.com/lukechilds/gifgen) - 简单的高质量 GIF 编码.
- [Gifify](https://github.com/jclem/gifify) - 将屏幕录制转换为 GIF.
- [Gifs](https://github.com/jglovier/gifs) - GIF 的存储位置.
- [Gifshot](https://github.com/yahoo/gifshot)  - 从 Yahoo 的媒体创建动画 GIF.  ([demo](http://yahoo.github.io/gifshot/))
- [Gifsockets](https://github.com/videlalvaro/gifsockets) - 使用动画 GIF 作为传输的实时通信库.
- [X-gif](https://github.com/geelen/x-gif) - 用于灵活 GIF 播放的 Web 组件.
- [GifW00t](https://github.com/yaronn/GifW00t) - JavaScript 网络记录器.
- [gif-machine](https://github.com/lelandbatey/gif-machine) - 从 YouTube 视频创建 GIF.
- [gifstreaming](https://github.com/jbochi/gifstreaming) - Live video streaming server.
- [Screengif](https://github.com/dergachev/screengif) - 创建动画 GIF 截屏视频.
- [vnc-over-gif](https://github.com/sidorares/vnc-over-gif) - 通过 http 将屏幕更新作为动画 GIF 提供.
- [gifdeck](https://github.com/jaipandya/gifdeck) - 将您的 SlideShares 转换为动画 GIF.
- [Gifbot](https://github.com/schuyler/gifbot) - GIF 搜索 Slack.
- [Gif-camera](https://github.com/FuzzyWobble/GIF-Camera) - 使用网络摄像头创建动画 GIF.
- [Gifline](https://github.com/zehfernandes/gifline) - 将 GIF 放入您的电子邮件中的 Chrome 扩展.
- [Gifdrop](https://github.com/markjaquith/gifdrop) - 为您的 GIF 图像集合创建存储库.
- [Gh-gif](https://github.com/node-gh/gh-gif) - NodeGH 插件，用于使用 GIF 反应评论拉取请求/问题.
- [Tty2gif](https://github.com/z24/tty2gif) - 将脚本及其输出记录为二进制和 GIF 格式.
- [Giftoppr](https://github.com/desktoppr/giftoppr) - 将您最喜爱的 GIF 与 Dropbox 同步.
- [Gifit](https://github.com/Fauntleroy/GIFit) - 从 YouTube 视频制作 GIF 的 Chrome 扩展.
- [Ccapture.js](https://github.com/spite/ccapture.js) - 捕获使用 HTML5 画布创建的动画.
- [Kap](https://getkap.co/) - 漂亮的开源应用程序，可捕获您的屏幕并导出为 GIF.
- [Gifit (the other one)](https://github.com/rotblauer/gifit) - 在 stdout 的降价中获取搜索结果 giphy GIF，ala `$ gifit kittens`.
- [gifski](https://github.com/ImageOptim/gifski) - 基于 libimagequant 的高质量 GIF 编码器.
- [Gifcurry](https://github.com/lettier/gifcurry) - 为 GIF 制作者打造的开源 Haskell 编辑器.

## Libraries

### ActionScript

- [Flash Animated GIF Library](https://github.com/theturtle32/Flash-Animated-GIF-Library) - 用于在 Flash 中播放动画 GIF 的 AS3 库.

### C++

- [Node-gif](https://github.com/pkrumins/node-gif) - 制作 GIF 的 C++ 库.
- [Gif-h](https://github.com/charlietangora/gif-h) - 用于创建动画 GIF 的 C++ 单头库.
- [msf_gif](https://github.com/notnullnotvoid/msf_gif) - 用于创建动画 GIF 的 C/C++ 单头文件库.

<h3 id="c-sharp">C#</h2>

- [dot-screencap](https://github.com/Speiser/dot-screencap) - 一个简单的库来记录您的屏幕并将其保存为动画 GIF.
- [WpfAnimatedGif](https://github.com/XamlAnimatedGif/WpfAnimatedGif) - 在 WPF 中显示动画 GIF 图像的简单库.
- [XamlAnimatedGif](https://github.com/XamlAnimatedGif/XamlAnimatedGif) - 在 XAML 应用程序（WPF、WinRT、Windows Phone）中显示动画 GIF 图像的简单库.
- [AnimatedGif](https://github.com/mrousavy/AnimatedGif) - 用于读取和创建动画 GIF 的高性能 .NET 库.

### Haxe

- [Gif](https://github.com/snowkit/gif) - Haxe GIF 编码器.

### Java

- [Android-gif-drawable](https://github.com/koral--/android-gif-drawable) - 用于在 Android 上显示动画 GIF 的视图和可绘制对象.
- [gifanimateddrawable](https://github.com/Hipmob/gifanimateddrawable) - 使用动画 GIF 作为 Android Drawable.
- [GifView](https://github.com/RoiSoleil/GifView) - 处理 GIF 的 Android 库.
- [Gif Movie View](https://github.com/sbakhtiarov/gif-movie-view) - 用于显示 GIF 动画的 Android 视图小部件.
- [GifImageView](https://github.com/felipecsl/GifImageView) - 处理动画 GIF 图像的 Android ImageView.
- [Gif-animation](https://github.com/extrapixel/gif-animation) - 播放和导出 GIF 的处理库.
- [Android-gif-encoder](https://github.com/nbadal/android-gif-encoder) - 适用于 Android 的动画 GIF 编码器.
- [GIFDroid](https://github.com/curtislarson/GIFDroid) - Android 视频到 GIF 转换器.
- [Android-GifStitch](https://github.com/CaptPhunkosis/Android-GifStitch) - 创建和分享动画 GIF.

### JavaScript

- [Gif.js](https://github.com/jnordberg/gif.js) - 从 DOM 创建 GIF.
- [Omggif](https://github.com/deanm/omggif) - GIF 89a 编码器和解码器.
- [Animated_GIF](https://github.com/sole/Animated_GIF) - 用于创建动画 GIF 的 JavaScript 库.
- [Gifffer](https://github.com/krasimir/gifffer) - 防止动画 GIF 自动播放的 JavaScript 库.
- [Gifplayer](https://github.com/rubentd/gifplayer) - 用于播放和停止动画 GIF 的 JQuery 插件.
- [Jsgif](https://github.com/shachaf/jsgif) - JavaScript GIF 解析器和播放器.
- [node-gify](https://github.com/tj/node-gify) - JavaScript 使用 ffmpeg 和 gifsicle 将视频转换为 GIF.
- [Gifencoder](https://github.com/eugeneware/gifencoder) - 为 Node.js 生成服务器端动画 GIF.
- [Gif-video](https://github.com/hughsk/gif-video) - JavaScript 将 GIF 图像转换为支持 HTML5 的视频.
- [Gif-player](https://github.com/apankrat/gif-player) - JavaScript 中的点播 GIF 加载器/播放器.
- [GifgifLab-face](https://github.com/Viral-MediaLab/gifgifLab-face) - 面部情绪检测器.
- [node-youtube](https://github.com/javascipt/node-youtube) - YouTube 到快照和 GIF.

### PHP

- [GifCreator](https://github.com/Sybio/GifCreator) - 从多个图像创建动画 GIF 的 PHP 类.
- [Spacer.gif](https://github.com/msng/spacer.gif) - 提供 spacer.gif 1x1 的 PHP 脚本.
- [GifFrameExtractor](https://github.com/Sybio/GifFrameExtractor) - 分隔动画 GIF 的所有帧的 PHP 类.

### Objective-C

- [UIimage from GIF](https://github.com/mayoff/uiimage-from-animated-gif) - 加载动画 GIF 的 UIImage 类别.
- [GIFRefreshControl](https://github.com/cyndibaby905/GIFRefreshControl) - “Twitter 音乐”和“Yahoo! Weather”等下拉刷新控件.
- [UIImageView-PlayGIF](https://github.com/yfme/UIImageView-PlayGIF) - 用于播放 GIF 的 UIImageView 类别/子类.
- [FLAnimatedImage](https://github.com/Flipboard/FLAnimatedImage) - FlipBoard 的 iOS GIF 引擎.
- [Animated-GIF-iPhone](https://github.com/arturogutierrez/Animated-GIF-iPhone) - 支持 iOS 上的动画 GIF.
- [UzysAnimatedGifPullToRefresh](https://github.com/uzysjung/UzysAnimatedGifPullToRefresh) - PullToRefresh 使用动画 GIF 到任何滚动视图.
- [SvGifView](https://github.com/smileEvday/SvGifView) - iOS 加载和显示 GIF.
- [GifHUD](https://github.com/cemolcay/GiFHUD) - 仅显示动画 GIF 图像的 iOS 进度 HUD.
- [Video-Background GIF](https://github.com/ElvinJin/Video-Background-GIF) - iOS 视频背景 GIF.
- [AnimatedGifExample](https://github.com/kasatani/AnimatedGifExample) - iOS 动画和透明 GIF.

### Swift

- [SwiftyGif](https://github.com/kirualex/SwiftyGif) - 高性能且易于使用的 Gif 引擎.
- [Gifu](https://github.com/kaishin/gifu) - Swift 中对 iOS 的动画 GIF 支持.

## GUI

- [Glyph](http://www.glyph.video/) - 用于从视频生成无缝循环 GIF 和动态图片的工具.
- [Qgifer](https://sourceforge.net/projects/qgifer/)
- [GifPro](https://github.com/unixpickle/GifPro) - 适用于 Mac 的 GIF 编码器.

## Hosting

- [Gfycat](https://gfycat.com)  - 最大 GIF/视频长度：15 秒. 最大文件上传为 300Mb.
- [Imgur](https://imgur.com) - 最大文件上传为 50MB.

## Online Tools

- [Vid2gif](https://imgur.com/vidgif) - imgur 将视频转为 GIF.
- [EzGif](https://ezgif.com/) - 在线 GIF 制作器和图像编辑器.
- [Giflr](https://giflr.com/) - 用于制作或重新混合动画 GIF 的网络应用程序.

## Community

- [Giphy.com](https://giphy.com)
- [/r/educationalgifs](https://www.reddit.com/r/educationalgifs/)

## Scripts

### Frames to GIF

FFmpeg
```bash
ffmpeg -f image2 -i image%d.jpg 动画.gif
```

Imagemagick
```bash
转换 -delay 20 -loop 0 frames*.png animated.gif
```
用于 GraphicsMagick、ImageMagick、FFmpeg 的 Bash 脚本（```frames2gif.sh&#39;&#39;`）
```bash
#!/bin/bash
if [ $# -ne 5 ]; then
    echo &quot;请提供电影名称和存储帧的目录&quot;
    echo &quot;./frames2gif.sh [目录] [movie.mp4] [文件名.gif] [gm|im|ffmpeg] [png|jpg]&quot;
    出口 1
fi
    如果 [ &quot;png&quot; == &quot;$5&quot; ]; 然后
        后缀=“PNG”
    别
        后缀=“jpg”
    是

    CONVERT=$(哪个转换)
    通用汽车=$（哪个通用汽车）
    FFMPEG=$(哪个ffmpeg)
    FFPROBE=$（哪个 ffprobe）
    FPS=$($FFPROBE -show_streams -select_streams v -i &quot;$2&quot; 2&gt;/dev/null | grep &quot;r_frame_rate&quot; | cut -d&#39;=&#39; -f2 | cut -d&#39;/&#39; -f1)
    回声“每秒帧数：${FPS}”
if [ "im" == "$4" ]; then # use imagemagick
    FPS=$(echo &quot;1 / ${FPS} * 100&quot; |bc -l)
    $CONVERT &quot;$1/*.${suffix}&quot; -delay ${FPS} -loop 0 &quot;$3&quot;
elif [ "gm" == "$4" ]; then # use graphicsmagick
    FPS=$(echo &quot;1 / ${FPS} * 100&quot; |bc -l)
    $GM convert &quot;$1/*.${suffix}&quot; -delay ${FPS} -loop 0 &quot;$3&quot;
else # use crappy gif-algorithm from ffmpeg
    $FFMPEG -f image2 -framerate ${FPS} -i &quot;$1/%08d.${suffix}&quot; &quot;$3&quot;
fi
```
From [DeepDreamVideo](https://github.com/graphific/DeepDreamVideo), [source](https://github.com/graphific/DeepDreamVideo/blob/master/frames2gif.sh)


### GIF to frames

```bash
ffmpeg -i video.mpg 图片%d.jpg
```
```bash
转换 -coalesce animated.gif image%05d.png
```

### High quality GIF

使用 ffmpeg / 基于此 [article](http://blog.pkh.me/p/21-high-quality-gif-with-ffmpeg.html)

- 生成调色板：

```bash
#!/bin/sh
start_time=30
duration=3
ffmpeg -y -ss $start_time -t $duration -i input.avi \
-vf fps=10,scale=320:-1:flags=lanczos,palettegen palette.png
```
- 使用调色板输出 GIF：

```bash
#!/bin/sh
start_time=30
duration=3
ffmpeg -ss $start_time -t $duration -i input.avi -i palette.png -filter_complex \
&quot;fps=10,scale=320:-1:flags=lanczos[x];[x][1:v]paletteuse&quot; output.gif
```

### Optimize GIF

```
convert -layers 优化 output.gif output_optimized.gif
```

### Lossy GIF Compressor

```bash
./gifsicle -O3 --lossy=80 -o lossy-compressed.gif input.gif

```
[Lossy Gif](https://kornel.ski/lossygif)


### Making GIF from video

```python
从 moviepy.editor 导入 *

剪辑 = (VideoFileClip(&quot;input.avi&quot;)
        .subclip((4,00.00),(5,00.00))
        .resize(0.3))
clip.write_gif("output.gif")

```
<!--lint ignore double-link-->
[article](http://zulko.github.io/blog/2014/01/23/making-animated-gifs-from-video-files-with-python/#converting-a-video-excerpt-into-a-gif)

### Cinemagraphs

冻结区域

```python
从 moviepy.editor 导入 *

剪辑 = (VideoFileClip(&quot;input.avi&quot;)
        .subclip((4,00.00),(5,00.00))
        .resize(0.3)
        .fx(vfx.freeze_region, outside_region=(170, 230, 380, 320)))
clip.write_gif(&quot;输出.gif&quot;, fps=15)
```
<!--lint ignore double-link-->
[article](http://zulko.github.io/blog/2014/01/23/making-animated-gifs-from-video-files-with-python/#freezing-a-region)

```bash
ffmpeg \
-ss ${starttime} -t ${duration} -i ${vidfile}                         `# body of loop` \
-ss TODO ${starttime} MINUS ${duration} -t ${fadetime} -i ${vidfile}  `# lead-in for crossfade` \
-loop 1 -i ${stillfile}                                               `# masked still image` \
-filter_complex“
  [0:v]setpts=PTS-STARTPTS[vid];                                      `# speed adjustment - not needed here, so noop`
  color=white,scale=3840x2160,fade=in:st=0:d=${fadetime}[alpha];      `# crossfade alpha, double length ahead of speed change`
  [1:v][alpha]alphamerge[am];                                         `# apply alpha to lead-in`
  [am]setpts=PTS+(${duration}-${fadetime})/TB[layer2];                  `# speed adjustment and offset for lead-in`
  [vid][layer2]overlay[oo];                                           `# overlay for crossfade`
  [oo][2:v]overlay=shortest=1[out1];                                  `# overlay still image`
  [out1]crop=w=${cropfactor}*iw:h=${cropfactor}*ih:y=${yoffset}*ih,scale=${outputwidth}:-1, `# crop and scale`
  eq=gamma=${gamma}:contrast=${contrast}:saturation=${saturation},unsharp                   `# final adjustments`
“-一个输出.mp4
```

### Perfect Loop

```python
将 moviepy.editor 导入为 mp
从 moviepy.video.tools.cuts 导入 FramesMatches

clip = mp.VideoFileClip(&quot;input.avi&quot;).resize(0.3)
场景 = FramesMatches.from_clip(clip, 10, 3)

selected_scenes = scenes.select_scenes(2, 1, 4, 0.5)
selected_scenes.write_gifs(clip.resize(width=450), &quot;./outputs_directory&quot;)

```
[article](http://zulko.github.io/blog/2015/02/01/extracting-perfectly-looping-gifs-from-videos-with-python-and-moviepy/)

### YouTube video to GIF

- 通过 youtube-dl 下载然后转换.

```
youtube-dl https://www.youtube.com/watch?v=V2XpsaLqXc8
```

[Youtube-dl](https://rg3.github.io/youtube-dl/)

### Grabbing each frame of an HTML5 Canvas

Using [PhantomJS](https://phantomjs.org).

以此为例 [canvas](http://www.effectgames.com/demos/canvascycle/?sound=0).

```javascript
var webPage = require(&#39;网页&#39;);
var fs = require(&#39;fs&#39;);
var page = webPage.create();

变种 NB_FRAME = 100;
无功电流= 0;

page.open('http://www.effectgames.com/demos/canvascycle/?sound=0',
功能（状态）{
  如果（状态===“成功”）{
      无功电流= 0;
      var grabber = setInterval(函数(){
          var frame = page.evaluate(函数() {
           返回 document.getElementById(&#39;mycanvas&#39;).toDataURL(&quot;image/png&quot;).split(&quot;,&quot;)[1];
          });
          fs.write(&quot;./frame-&quot; + current + &quot;.png&quot;,atob(frame), &#39;wb&#39;);
      如果（++当前=== NB_FRAME）{
         window.clearInterval（抓取器）；
         phantom.exit(0);
      }
    }, 1000);
  }
});
```

## Miscellaneous

- [Why is the GIF I created so slow?](https://superuser.com/questions/569924/why-is-the-gif-i-created-so-slow/569967) - 使用ImageMagick 解决GIF 速度问题.

## Use

使用此列表的最佳方法是：

- 通过浏览 [contents](#contents).
- 通过使用<kbd>command</kbd> + <kbd>F</kbd>来搜索内容

## Credits

By [Craig Davison](https://davison.io) 和贡献者.

基于 [recovered list](https://github.com/sindresorhus/awesome/issues/872) 经过 [Ismail Baaj](https://ismailbaaj.fr).
