<div class="github-widget" data-repo="bakke92/awesome-gdpr"></div>
## Awesome GDPR [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/bakke92/awesome-gdpr/master/GDPR.png" align="right" width="300">](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=CELEX%3A32016R0679)

The General Data Protection Regulation (GDPR) is a regulation on data protection and privacy for all individuals within the European Union and the European Economic Area. The regulation has increased the focus on privacy in companies and strengthened the data subjects influence.


## Legal text
* [GDPR-info](https://gdpr-info.eu/) - GDPR linked to relevant articles and section in the preamble (Non-official site).
* [GDPR-expert](https://www.gdpr-expert.com/home.html?mid=5) - Compare the Regulation, Directive and National legislation. Linked to relevant section in preamble (Non-official site).
* [GDPRhub -> GDPR Articles](https://gdprhub.eu/index.php?title=Category:GDPR_Articles) - GDPR articles included commentary.
  
## Guidelines
* [Guidelines](https://edpb.europa.eu/our-work-tools/general-guidance/gdpr-guidelines-recommendations-best-practices_en) & [Opinions](https://edpb.europa.eu/our-work-tools/consistency-findings/opinions_en) from the European Data Protection Board (EDPB).
* [ICO: Guide to GDPR](https://ico.org.uk/for-organisations/guide-to-data-protection/guide-to-the-general-data-protection-regulation-gdpr/)
* [Handbook on European data protection law ](https://publications.europa.eu/en/publication-detail/-/publication/5b0cfa83-63f3-11e8-ab9c-01aa75ed71a1) - Handbook issued by EU.
* [Factsheets](https://edps.europa.eu/data-protection/our-work/our-work-by-type/factsheets_en) - Factsheets from EU Data Protection Supervisor.
  
## Rights of the data subject (art. 12 - 23)
* [Open source privacy notice template (Juro)](https://github.com/juro-privacy/free-privacy-notice)

## Privacy by Design - Guides for developers (art. 25)
* [CNIL - GDPR Developer Guide](https://github.com/LINCnil/GDPR-Developer-Guide)
* [Norwegian DPA - Software development with Data Protection by Design and by Default](https://www.datatilsynet.no/en/about-privacy/virksomhetenes-plikter/data-protection-by-design-and-by-default/)
* [Data Pseudonymisation: Advanced Techniques and Use Cases](https://www.enisa.europa.eu/publications/data-pseudonymisation-advanced-techniques-and-use-cases/) - Report on pseudonymisation techniques from ENISA.
* [Anonymisation, pseudonymisation and privacy enhancing technologies guidance - ICO](https://ico.org.uk/about-the-ico/ico-and-stakeholder-consultations/ico-call-for-views-anonymisation-pseudonymisation-and-privacy-enhancing-technologies-guidance/)

## Records of Processing (art. 30)
* [Iubenda - Register of data processing activities](https://www.iubenda.com/en/internal-privacy-management)

## Security (art. 32)
* [OWASP Top 10](https://owasp.org/www-project-top-ten/) - Top 10 Web Application Security Risks.
* [OWASP Cheat Sheet Series](https://cheatsheetseries.owasp.org/) - Concise collection of high value information on specific application security topics.
* [Anonymisation, pseudonymisation and privacy enhancing technologies guidance](https://ico.org.uk/about-the-ico/ico-and-stakeholder-consultations/ico-call-for-views-anonymisation-pseudonymisation-and-privacy-enhancing-technologies-guidance/)

## Incident management (art. 33 and 34)
* [ENISA: Recommendations for a methodology of the assessment of severity of personal data breaches](https://www.enisa.europa.eu/publications/dbn-severity)
* [Google, SRE: Managing Incidents](https://landing.google.com/sre/sre-book/chapters/managing-incidents/)
* [Troy Hunt: Data breach disclosure 101](https://www.troyhunt.com/data-breach-disclosure-101-how-to-succeed-after-youve-failed/)
* [Awesome Incident Response](https://github.com/meirwah/awesome-incident-response)
* [GDPR Enforcement Tracker](http://www.enforcementtracker.com/) - Overview of fines and penalties.

## Data Protection Impact Assessments (DPIA, art. 35)
* [Open-source DPIA software from the French DPA](https://www.cnil.fr/en/open-source-pia-software-helps-carry-out-data-protection-impact-assesment)
* [Guidelines on Data Protection Impact Assessment (WP29)](https://ec.europa.eu/newsroom/article29/item-detail.cfm?item_id=611236)
* [ISO-standard: Guidelines for privacy impact assessment](https://www.iso.org/standard/86012.html)
* [DPIA template from ICO](https://iapp.org/resources/article/sample-dpia-template/)
* [Public DPIA Teams OneDrive SharePoint and Azure AD](https://www.rijksoverheid.nl/documenten/publicaties/2022/02/21/public-dpia-teams-onedrive-sharepoint-and-azure-ad) -  DPIA of Microsoft Teams in combination with OneDrive, SharePoint Online and the Azure Active Directory.

## Tools
* [Website Evidence Collector (WEC)](https://github.com/EU-EDPS/website-evidence-collector) - EDPS Inspection Software.
* [Data protection around the world](https://www.cnil.fr/en/data-protection-around-the-world) - (CNIL) Map of the level of data protection in each country. 
* [Data Protection Laws of the world](https://www.dlapiperdataprotection.com/) - (DLA Piper) Compare data protection laws around the world.
 
## Data Protection Authorities (art. 51 -59)
* [European Data Protection Board](https://edpb.europa.eu/) - EDPB.
* [European Data Protection Supervisor](https://edps.europa.eu/) - EDPS.
* [European Union Agency for Network and Information Security (ENISA)](https://www.enisa.europa.eu/topics/data-protection) - ENISA.
* [List of Data Protection Authorities](https://pdpecho.com/the-list/)
  
## Organisations / Projects
* [Electronic Frontier Foundation](https://www.eff.org/) - Nonprofit defending digital privacy, free speech, and innovation.
* [International Association of Privacy Professionals](https://iapp.org/) - A resource for privacy professionals.
* [Privacy International](https://www.privacyinternational.org) - Charity that challenges the governments and companies that want to know everything about individuals, groups, and whole societies.
* [NOYB](https://noyb.eu/) - Organisation that brings important issues to the attention of DPAs, enforces the law in civil court or directly engages with companies.
* [GDPR.eu](https://gdpr.eu/) - Resource for organisations and individuals researching the GDPR (Not official website).
* [CyLab Usable Privacy and Security Laboratory](https://cups.cs.cmu.edu/) - Research related to understand and improving the usability of privacy and security.
* [EPIC](https://epic.org/) - Electronic Privacy Information Center.
* [Future of Privacy Forum](https://fpf.org/) - Catalyst for privacy leadership and scholarship, advancing principled data practices in support of emerging technologies.
* [W3C Privacy Interest Group](https://www.w3.org/Privacy/) - Leading the web to its full potential.
* [CISPE Code of Conduct](https://www.codeofconduct.cloud/) - Pan-European sector-specific code for cloud infrastructure service providers under Article 40.

## Publications
* [GDPR Today](https://www.gdprtoday.org/) - Privacy news from the Open Rights Group.
* [Spread Privacy](https://spreadprivacy.com/) - DuckDuckGo Blog.
* [Freedom To Tinker](https://freedom-to-tinker.com/) - Blog from Princeton's CITP, a research center that studies digital technologies in public life.
* [pdpEcho](https://pdpecho.com/) - All about personal data protection and privacy, by Gabriela Zanfir-Fortuna.
* [GDPRhub](https://gdprhub.eu/) - Free and open wiki that allows anyone to find and share GDPR insights across Europe.
    
## Related
* [Privacy Respecting](https://github.com/nikitavoloboev/privacy-respecting)
* [Awesome: Security](https://github.com/sindresorhus/awesome#security)
* [Awesome: Humane Tech](https://github.com/humanetech-community/awesome-humane-tech#readme)
* [Awesome: Privacy](https://github.com/pluja/awesome-privacy#readme) - List of free, open source and privacy respecting services and alternatives to privative services.
* [Developers Guide to HIPAA Compliance](https://github.com/truevault/hipaa-compliance-developers-guide)
* [Analytics without cookies](https://www.gocookieless.com/)
* [European web analytics services](https://european-alternatives.eu/category/web-analytics-services)
* [EU Alternatives](https://dasprive.be/eu-alternatives/)

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, Harald O. Bakke has waived all copyright and related or neighboring rights to this work.
