<div class="github-widget" data-repo="michelpereira/awesome-games-of-coding"></div>
## Games of Coding [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of games that teach you a programming language.




## Language Independent

- [Lambda Spellcrafting Academy](https://www.bittwiddlegames.com/lambda-spellcrafting-academy/) - A visual programming / puzzle game where you build spells to solve puzzles. Covers introductory programming, as well as some data structures and algorithms. The language is inspired by Lisp, but the game focuses on programming fundamentals that apply to most languages.
- [Codingame](https://www.codingame.com/home) - A platform to learn and compete. Proposes a variety of multiplayer games and contests as well as optimisation challenges and solo puzzles. You can contribute your own too. Choose your language, enjoy the graphics. 
- [CodeCombat](https://codecombat.com) - Choose your hero and code your way through the ogre patrols, lava pits, and laser beams of Kithgard Dungeon. Level up, earn gems, and loot magic items to unlock new programming powers. Join millions of players and go from a total beginner to writing advanced multiplayer AI in Python, JavaScript, CoffeeScript, or Lua in this open-source programming game.
- [Vindinium](https://www.codingame.com/multiplayer/bot-programming/vindinium) - Players write scripts in the programming language of their choice (optionally using one of the many starter packs) to control a 16-bit hero through HTTP requests, guiding him to collect gold, do battle with other players, and even visit the tavern.
- [RealTimeBattle](http://realtimebattle.sourceforge.net) - A programming game in which robots controlled by programs are fighting each other. The goal is to destroy the enemies, using the radar to examine the environment and the cannon to shoot. 
- [Battlesnake](https://play.battlesnake.com) - Join a community of developers from around the world as you compete for fame and glory in Battlesnake, a multi-player programming competition based on the classic game - snake! All you need to play is a live web server that implements the Battlesnake API and the language of your choice to begin battling to find food, avoid other Battlesnakes, and stay alive as long as possible.
- [Coder One](https://www.gocoder.one) - Annual AI programming tournament featuring a multiplayer 'Bomberman'-like game, cash prizes, and a casted finale livestream. Create an AI player that can navigate a 2D grid world collecting power-ups and placing explosives with the goal of taking your opponent down. Submit your AI in the form of a Docker image using one of our Python or TypeScript starter kits (community-contributed starter kits are also available in Go, C++, and Rust).

## Python

- [Robocode](https://github.com/turkishviking/Python-Robocode) - The goal is to develop a robot battle tank to battle against other tanks. The robot battles are running in real-time and on-screen.
- [Robot Rumble](https://robotrumble.org/) - A free and open source AI competition platform. Code an algorithm for a team of robots battling in 1x1 grid-based arenas, and test your skills against others on the site. Robots can move and attack in one of four directions, and the team with more robots after 100 turns wins. Supports Python and Javascript, and comes with a desktop-based command line tool. 

## Java

- [Robocode](https://robocode.sourceforge.io) - The goal is to develop a robot battle tank to battle against other tanks. The robot battles are running in real-time and on-screen.


## JavaScript

- [Screeps](https://screeps.com) - No point and clicking any longer! You write real JavaScript which controls your units autonomously. Any time, everywhere, even while you are offline.
- [JavaScript Fight Club](https://jsfight.club) - The Red King and the Blue King are at war! Your JavaScript skills are needed to determine the victor: Can you code an effective AI for honor and glory?
- [Elevator Saga](http://play.elevatorsaga.com) - Write JavaScript directly in the browser to program an elevator, such that it reaches its efficiency goals. Start with simple "getting started" scripts, and ramp up to much more complex situations with many floors and multiple elevators.
- [Untrusted](https://alexnisnevich.github.io/untrusted) - The game presents you with a roguelike-like playing environment and a console window with the JavaScript code generating each level. As loaded, each level is unbeatable, and most of the JavaScript is blocked from editing. The challenge is to open a path to the next level using only the limited tools left open to you.
- [Robot Rumble](https://robotrumble.org/) - A free and open source AI competition platform. Code an algorithm for a team of robots battling in 1x1 grid-based arenas, and test your skills against others on the site. Robots can move and attack in one of four directions, and the team with more robots after 100 turns wins. Supports Python and Javascript, and comes with a desktop-based command line tool.
- [DeepestWorld](https://deepestworld.com/) - A browser MMORPG where you can code your character with JavaScript. Explore a boundless, persistent open world devoid of loading screens, where a multitude of biomes and creatures come together to form a living, breathing world.

## C Sharp

- [Robocode](http://robocode.sourceforge.io/robocode.dotnet) - The goal is to develop a robot battle tank to battle against other tanks. The robot battles are running in real-time and on-screen.
- [Code Hero](http://www.codehero.org) - A first-person coding puzzle platformer that equips you with a code ray that casts C# at your target.


## Ruby

- [RubyWarrior](https://www.bloc.io/ruby-warrior) - A browser based game where you control your avatar through various levels filled with enemies using Ruby.

## Assembly

- [Embedded Security CTF](https://microcorruption.com) - The purpose is to bypass a series of locks, essentially hacking them, in order to get through a series of warehouses.
- [Box-256](http://box-256.com) - Write assembly code to match a shown graphic.


## Scala

- [Robocode](https://github.com/d6y/scala-robot-dev) - The goal is to develop a robot battle tank to battle against other tanks in Java or .NET. The robot battles are running in real-time and on-screen.
- [Scalatron](http://scalatron.github.io) - Coders pit bot programs (written in Scala) against each other. It is an educational resource for groups of programmers or individuals that want to learn more about the Scala programming language or want to hone their Scala programming skills.


## Miscellaneous

- [Generals IO](http://generals.io) - A fast-paced strategy game where you expand your land and battle with enemies over theirs. You lose when your general is taken, but capturing an opponent's general gives you control of their entire empire.
- [Robo Dojo](http://robodojo.club) - You build robots that build, corrupt and destroy other robots in an attempt to eliminate all competitors.
- [Corewars](http://www.corewars.org) - A game of warrior vs warrior, programmed by two opponents, and placed into a virtual 'ring' to fight to the death.
- [TIS-100](http://www.zachtronics.com/tis-100) - Open-ended programming game by Zachtronics, the creators of SpaceChem and Infinifactory, in which you rewrite corrupted code segments to repair the TIS-100 and unlock its secrets. It's the assembly language programming game you never asked for!
- [Shenzhen I/O](http://www.zachtronics.com/shenzhen-io) - You build circuits using a variety of components from different manufacturers, like microcontrollers, memory, and logic gates, and then write code in a compact and powerful assembly language where every instruction can be conditionally executed.
- [MHRD](http://store.steampowered.com/app/576030) - Hardware design game, in which you design various hardware circuits in a hardware description language. The hardware circuits you design get more complex as you go until you create a fully functional CPU design.
- [Colobot](https://colobot.info) - 3D video game where you program your bots to ride, fly, find, bring, refuel and destroy. Game is using a language called CBOT, similar to C++ and Java. Colobot offers tutorialed campaign with gradually harder tasks or you can play scenarios to challenge your skill.
- [Code Games](http://codegames.io/en) - Real time programming game where you compete against other players by coding the behaviour of a space ship. The programming language is easy to learn and the game is super fun. Subscribe to one of our tournaments and compete for the prize.
- [Mudlet](http://www.mudlet.org) - Game client that allows you to play MUDs (text-only MMORPGs). You can write Lua code in Mudlet to help you play MUDs.
- [CSS Diner](http://flukeout.github.io) - A CSS item arrangement game, teaching the concepts and use of CSS selectors and layout. You modify CSS to arrange HTML elements representing plates and bento boxes on a dining table.
- [Guido van Robot](http://gvr.sourceforge.net) - Programming language and free software application designed to introduce beginners to the fundamentals of programming. GvR runs on Windows, Macintosh, and GNU/Linux, in a variety of languages! It's great in both the classroom and the home as a way of introducing people to the basic concepts of programming.
- [CSSBattle](https://cssbattle.dev) -  Online CSS Code Golfing battleground. Here, players from all around the world try to visually replicate "Targets" in smallest possible CSS code and battle it out to get to the top of the leaderboard.
- [The Command Line Murders](https://github.com/veltman/clmystery) - There's been a murder in Terminal City, and TCPD needs your help.
- [SQL Murder Mystery](https://mystery.knightlab.com/) - The SQL Murder Mystery is designed to be both a self-directed lesson to learn S
QL concepts and commands and a fun game for experienced SQL users to solve an intriguing crime.
- [S3 Game](http://s3game-level1.s3-website.us-east-2.amazonaws.com/) - You are the treasure hunter. Your task is to get as many secret
codes and open as many chests as possible.
- [Learn Git Branching](https://learngitbranching.js.org/) - is the most visual and interactive way to learn Git on the web; where you'l
l be challenged with exciting levels.
- [Oh my Git](https://ohmygit.org/) - An open source game about learning Git!



## Contribute

Contributions welcome! Read the [contribution guidelines](https://github.com/michelpereira/awesome-games-of-coding/blob/master/contributing.md) first.
