<div class="github-widget" data-repo="vhladiienko/awesome-game-production"></div>
## Awesome Game Production [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[![Awesome Game Production](https://raw.githubusercontent.com/vhladiienko/awesome-game-production/master/media/production_team.jpg)](https://github.com/vhladiienko/awesome-game-production)

> A curated list of **awesome** resources, related to game production process - books, articles, tools, project management, methodologies - aimed to help game producers deliver their games.

[Video game development](https://en.wikipedia.org/wiki/Video_game_development) (or production) is a process of developing a video game by a single person or a team of developers, not necessarily professionals or employed by someone to do so. This list is focused on [game producer's](https://en.wikipedia.org/wiki/Video_game_producer) role - a person, who manages and orchestrates the game production process in multitude of ways. Hence the shortened list name.

This list does not cover specific disciplines like game design, quality assurance, programming. Refer to the [Gaming section](https://github.com/sindresorhus/awesome#gaming) of the "master" awesome list for other gamedev stuff.

Majority of the provided resources are in English, but I might include items in other languages too, if you help me by [creating a pull request](https://github.com/vhladiienko/awesome-game-production/blob/main/contributing.md). Look for a flag next to the link.

- 🔥 - awesomeness over 9000: highly practical and easy to use
- 🎓 - absolute basics
- 🤯 - a complex topic, that might be hard to understand


## 📚 Books

Some books might not be as good as the others, but still hold some value to producers. Refer to the [Articles](#articles) section for more practical resources, and consider below books for your next evening reading session.

- [Agile Game Development with SCRUM](https://amazon.com/dp/0321618521) - The book provides detailed explanations and real-world examples of how SCRUM can be used to increase productivity, improve communication, and deliver high-quality games on time and within budget.
- [Agile Game Development: Build, Play, Repeat](https://amazon.com/dp/0136527817) - Comprehensive guide to implementing agile methodologies in game development, covering topics from team dynamics to production processes. The book features case studies, practical tips, and exercises that provide readers with a hands-on approach to creating successful games with agility.
- [Blood, Sweat, and Pixels: The Triumphant, Turbulent Stories Behind How Video Games Are Made](https://amazon.com/dp/0062651234) - A behind-the-scenes look at the making of several popular video games, detailing the challenges faced by game developers and the intense pressures of the industry.
- [Disrupting the Game: From the Bronx to the Top of Nintendo](https://amazon.com/dp/1400226678) - Highlights the challenges Garcia faced as a woman of color in a male-dominated industry, and provides valuable insights into leadership, innovation, and diversity in the tech industry.
- [The Art of Game Design: A Book of Lenses](https://amazon.com/dp/1138632058) - If<a name="art-of-gd"></a> you're transitioning to a management role from game design, chances are you've read this one. If not, still consider it as it will help to understand the why's behind design decisions and challenge your team or your client. 
- [The Game Production Handbook](https://amazon.com/dp/1449688098) - Comprehensive guide to game production, covering topics such as project management, team building, and production processes. The book includes real-world examples and case studies from successful game studios, and provides practical tips and advice for game developers at all levels.
- [Practical Project Initiation: A Handbook with Tools](https://amazon.com/dp/0735625212) - It is what it says. Can't get more practical than this. It is not gamedev related, but you might want to pick up a few tricks for your next pre-production.
- [The Game Producer's Handbook](https://amazon.com/dp/1592006175) - Practical guide to game production, covering all aspects of game development from initial concept to final release. The book provides insights into production methodologies, team management, and project planning, and includes tips and advice from experienced game producers.
- 🎓 [Producing Games: From Business and Budgets to Creativity and Design](https://amazon.com/dp/0240810708) - Read if you don't know a thing about how games are made, or skip otherwise. This book is old, but the production process hasn't fundamentally changed.
- [User Story Mapping: Discover the Whole Story, Build the Right Product](https://amazon.com/dp/1491904909) - This<a name="story-mapping"></a> book is about way more than just how to do story mapping. What stories are really about? How do you actually use them to change the world? If you're not using stories like it is described in this book, then you're not using stories at all.


## 📰 Articles

Links to articles, hosted elsewhere. These may disappear or change location overtime, which is when you might want to ask [Wayback Machine](https://archive.org/web/) for help.

### Game Producer Role and Skills

- 🎓 [What A Video Game Producer Actually Does](https://kotaku.com/what-a-video-game-producer-actually-does-1772519753) - A nice summary by Jason Schreier - the dude, who you should probably follow.
- 🎓 [So, You Want To Be a Video Game Producer?](https://www.linkedin.com/pulse/so-you-want-video-game-producer-pauliina-tornqvist/) - The article explains what a video game producer does, their career path and title development, and the key skills required to become one.
- 🎓 [So, You Want To Be a Video Game Producer? Part #2](https://www.linkedin.com/pulse/so-you-want-video-game-producer-part-2-pauliina-tornqvist/) - Focuses on the skillset of a video game producer, which includes project management methods and tools, communication and people skills, problem solving, technical skills, and a genuine interest in playing and knowing about video games.
- 🎓 [So, You Want To Be a Video Game Producer? Part #3](https://www.linkedin.com/pulse/so-you-want-video-game-producer-part-3-pauliina-tornqvist/) - Provides five steps for landing a job as a video game producer, including identifying your realistic career level, optimizing your resume and cover letter, applying to multiple companies, preparing for interviews, and networking with recruiters.
- [What Makes a Good Game Producer? Part 1](https://www.gamedeveloper.com/production/what-makes-a-good-game-producer-part-1) - Explores the qualities and skills that make for a successful game producer, including leadership, communication, and adaptability, with insights from experienced industry professionals.
- [What Makes a Good Game Producer? Part 2](https://www.gamedeveloper.com/production/what-makes-a-good-game-producer-part-2) - Delves deeper into the role of a game producer, including project management, risk assessment, and team coordination, and provides tips for aspiring producers on how to develop their skills and excel in the role.
- [Five tips on being a better producer](https://www.gamesindustry.biz/five-tips-on-being-a-better-producer) - The title might feel gimicky, but there are a few very important pieces of advice, which are worth considering.
- 🎓 [Production Pipeline: a Design Tool?](https://gdkeys.com/production-pipeline-a-design-tool/) - A broad overview of a common production timeline: milestones, deliverables, dos and don'ts. Beware though, as presented pipeline is just one of the many: different studios tend to flavor this pipeline with their own set of adjustments.

### Game Production Best Practices and Tips

- 🔥 [Breaking The Wheel](https://www.breakingthewheel.com/getting-started-breaking-wheel/) - Justin Fischer's absolutely awesome collection of best practices and tips to leading game production. Must read.

### Agile Project Management

- [User Story Mapping for Games - An Example](https://web.archive.org/web/20230201152834/https://blog.agilegamedevelopment.com/2016/04/user-story-mapping-for-games-example.html) - If using Agile on your project, User Story Mapping can greatly help prioritize and plan releases. This article gives a _very brief_ explanation and provides and example. Replaced original link with Web Archive version, as it became unavailable.
- 🤯 [AgileEVM – Earned Value Management in Scrum Projects](https://www.projectmanagement.com/content/attachments/itstratpm_080812105311.pdf) - Thesis (theoretical) on the AgileEVM - adaptation of the classic <a name="agile-evm" href="#evm">EVM</a>, that uses Scrum's key values.
- 🤯 [Measuring Integrated Progress on Agile Software Development Projects](https://www.methodsandtools.com/archive/archive.php?id=61) - A little bit more practical article on how to actually calculate AgileEVM.
- 🎓 [Writing Good User Stories](https://www.easyagile.com/training/writing-good-user-stories.pdf) - A concise and easy to understand explanation of the user story and acceptance criteria concepts. Some theses might be arguable, but still worth bookmarking as a hands-on  (PDF).
- [Basics of User Story Mapping](https://www.easyagile.com/training/introduction-to-user-story-mapping.pdf) - Same as above, a very concise and well explained user story mapping technique (PDF).
- [Building an Agile User Story Map](https://www.easyagile.com/training/building-user-story-maps.pdf) - Hands-on guide to building a user story map (PDF).

### Open Minimalist Modules

If you're new to project management and/or production role, I strongly recommend you familirize yourself with these super practical and easy to understand project management systems and set of principles.

- 🎓 [Nearly Universal Principles of Projects](https://nupp.guide/) - NUPP is a collection of nearly universal principles of projects: those we’d do well to follow in all projects, regardless of the methodologies and approaches that we use, to maximize our success.
- 🎓 [P3.express](https://p3.express/) - P3.express is a minimalist, practical project management system. It’s easy to learn, easy to use, and easy to teach.
- 🎓 [micro.P3.express](https://micro.p3.express/) - micro.P3.express is a flavor of P3.express designed for micro-projects with approximately 1 to 7 team members.

### Designing a Production Process

- [Designing a Production Process: Part 1](https://www.ryandarcey.com/making-moves/2016/6/30/designing-a-production-process-part-1) - Provides an introduction to designing a production process for game development studios, covering topics such as team structure, workflow, and asset management.
- [Designing a Production Process: Part 2](https://www.ryandarcey.com/making-moves/2016/7/14/designing-a-production-process-part-2) - Delves deeper into the components of a production process, including milestone planning, risk management, and quality assurance.
- [Designing a Production Process: Part 3](https://www.ryandarcey.com/making-moves/2016/8/4/designing-a-production-process-part-3) - Focuses on production methodologies, providing an overview of popular approaches such as Agile, Waterfall, and Scrum, and discussing the advantages and disadvantages of each.

### Schedule Management

- [Evidence-Based Scheduling](https://www.joelonsoftware.com/2007/10/26/evidence-based-scheduling/) - A system, that produces reliable shipping schedules, based on the past performance of the team. It uses Monte Carlo simulation to generate distributions of possible ship dates, and then combines them with the team's availability to give a reliable date range.
- [When will the Agile Project be done?](https://failfastmoveon.blogspot.com/2019/07/when-will-agile-project-be-done.html) - How to make an educated forecast of the project's end date, based on the team's velocity.

### Post-mortems

Many post-mortems here are back from the day, and might seem outdated and not useful. But after reading through them you'll quickly realize the teams back then had the same issues. Use these articles as a lense to look at your problems.

- [Ensemble Studio's Age of Empires II: Age of Kings](https://www.gamedeveloper.com/design/postmortem-ensemble-studio-s-age-of-empires-ii-age-of-kings) - Age of Empires II: Age of Kings was developed by Ensemble Studios with the aim of improving upon the original game in every aspect, from graphics to user interface. Modern game developers can learn from Ensemble's dedication to innovation within the genre and their use of tools and automated testing to streamline their development process.
- [Baldur's Gate II: The Anatomy of a Sequel](https://www.gamedeveloper.com/design/-i-baldur-s-gate-ii-i-the-anatomy-of-a-sequel) - Baldur's Gate II, developed by BioWare, focused on improving upon the original game by refining the development process, learning from past mistakes, and incorporating player feedback. Modern game developers can apply these lessons by prioritizing features, establishing clear development guidelines, and fostering open communication between team members to create an even better sequel.
- [Blizzard's Diablo II](https://www.gamedeveloper.com/design/postmortem-blizzard-s-i-diablo-ii-i-) - Diablo II, developed by Blizzard Entertainment, focused on refining and expanding the gameplay mechanics of the original Diablo, while also addressing player feedback and criticisms. Modern game developers can learn from this approach by continually iterating on their game's core elements and incorporating player feedback to create a sequel that captures the essence of the original while offering fresh and engaging experiences.
- [Irrational Games' System Shock 2](https://www.gamedeveloper.com/design/postmortem-irrational-games-i-system-shock-2-i-) - System Shock 2, developed by Irrational Games, was a sequel created under challenging circumstances, including inexperienced developers, tight deadlines, and a small budget. Modern game developers can learn from the team's ability to adapt to these constraints and design within their technological limitations, as well as their focus on simple, reusable gameplay elements and cooperative development to create a worthy sequel.
- [Epic Games' Unreal Tournament](https://www.gamedeveloper.com/programming/postmortem-epic-games-i-unreal-tournament-i-) - Unreal Tournament, released in 1999, was developed by Epic Games and Digital Extremes, who had an unusual development cycle and a very loose development process. The game managed to evolve from a single-player game into a deathmatch-oriented design and ultimately earned more than five "Game of the Year" awards and is consistently rated in the top ninetieth percentile in reviews.

## 📺 Videos

- [Producer Bootcamp: High Performance Producers](https://www.youtube.com/watch?v=0yyeLmjQGFg&t=null) - Gearbox Software's Aaron Thibault helps viewers build personalized progress charts in the pursuit of improving their production mastery.
- [My To-Do List: Organizing a Producer's Work](https://www.youtube.com/watch?v=zW8gKpEP-rs&t=null) - Oculus' Bernard Yee provides a suggested to-do list for people who manage a team and project's to-do list, why they are important and how to be effective on a daily basis.
- [Taming the Chaos: Lessons in Project Management](https://www.youtube.com/watch?v=M0uuDsjy4b0&t=null) - Clinton Keith explains how to deliver great games on schedule without breaking the bank or the backs of your team.
- [Up Sh\*t Creek: Pro Tips for Managing the Unmanageable Project](https://www.youtube.com/watch?v=dNlEZZlmIcw&t=null) - Amy Dallas explores a mindset for producers that can help one be successful when faced with managing a seemingly impossible project and shares some survival tips to keep you focused when everything seems to be going sideways.
- [User Story Mapping: Developing a Shared Understanding](https://www.youtube.com/watch?v=UDHW525sCOo&t=null) - Jamie Winsor shares how user story mapping is used to cut development waste and align team members behind a single, well-defined goal.
- [Anatomy of Modern Game Design Documents](https://youtu.be/vU302sLgMyM) - Your game will start with a GDD and the production process will stem from the design documentation regardless of the production pipeline. Making sure you're having right documentation at the right time can help you avoid overhead during development big time (slides are [here](https://www.slideshare.net/RalfCAdam/anatomy-of-a-modern-game-design-document-ralf-adam-vera-frisch-4ckyiv)).
- 🎓 [How to prepare yourself for Game Production](https://youtu.be/DZADPKnK6_8) - A detailed and very well explained summary of what a producer's job is about, but it contains a few gamedev specific terms.
- 🎓 [So You Want To Be a Producer](https://youtu.be/WUkcz2taCiw) - We'll put summary for newcomers. Consider watching other Extra Credits videos about game development (they used to focus on those back in the day).
- [Embracing Ambiguity: How to Do Good Work When You Don't Know What to Do](https://youtu.be/4DWdnoLosZ8) - Ruth Tomandl discusses the concept of ambiguity and methods for determining whether it's a problem or not in game production.
- 🤯 [What is Earned Value Management? EVM in a nutshell](https://youtu.be/qbVDfQjpRho) - EVM<a name="evm"></a> explained in 3 minutes. Hopefully, will whet your appetite for the EVM topic.
- [How The Witcher Devs Turn Great Ideas Into Game Features](https://youtu.be/moW8-MXjivs?t=2092) - Timestamped video, where Lead Game Designer from CD Project Red talks about their approach to breaking down the game into features and **prioritizing** them. Can be used as a framework as-is in your production.
- 🔥 [One-Page Designs](https://www.youtube.com/watch?v=GXmsxYm0Mk0) - You know how in agile you want to make sure your user stories are concise and _not_ too detailed to incentivize communication? This video explains how you could apply the same principle to game design documents. Visualizing to make sure everyone discussing the design is on the same page also reminded me of the [User Story Mapping](#story-mapping) book. Watch, because it might just change your GD pipeline.
- [Game Development Caution](https://www.youtube.com/watch?v=LMVQ30c7TcA) - Timothy Cain discusses the shift towards a culture of caution in game development, contrasting his experiences with project management and creative processes during the development of titles like Fallout and The Outer Worlds. He reflects on how this caution impacts creativity, innovation, and the overall charm of games, urging a return to passion-driven development.
- 🔥 [This Problem Changes Your Perspective On Game Dev](https://www.youtube.com/watch?v=o5K0uqhxgsE) - An interesting perspective on game development: design process is a search algorithm in pursuit of the deepest point in a lake, symbolizing the best possible game. This metaphor serves to illustrate the importance of strategic experimentation and exploration in game design, emphasizing the balance between speed and accuracy, the dangers of local minima, and the value of daring to explore new ideas. A very simple way to explain how one should prototype a game.
- 🔥 [The Red & Green Flags of Studio Leadership](https://www.youtube.com/watch?v=_KnsCh2HjWA) - While Rami Ismail is talking about studio leadership in general, I actually think he describes the very essence of how a producer needs to lead in order to gain trust of their team and become their best friend. A must-watch.

### Courses
- [Deeply Practical Project Management](https://www.udemy.com/course/deeply-practical-project-management/) - This is what you'd call a "no BS" course on project management. Concise, to the point, and highly practical. It is not focused on game development, but I think you should still take it, because it closes many (if not all) gaps with just one course (~9 hours). Once completed, just adapt to your needs or just use some of the principles. It also includes numerous document templates and examples.

## 🔧 Tools and templates

As a producer, you might need a few tools to help you deliver the damn thing. Some of these may not be useful to you directly, but I might have include one if I think you should at least know such a tool exists. This is to help you gain a few credits in your team.

### Tools

- [Machinations](https://machinations.io/) - A tool, that helps prototyping game mechanics, economy flow and states either for production or for demo purposes. This tool has been mentioned by Jesse Schell in his [Book of Lenses](#art-of-gd), so its old but it has transformed over the years. Not necessarily a tool for a producer to use, but it is often overlook, so go ahead and give your game designers a tip.
- [Excalidraw](https://excalidraw.com/) - A free and [open source](https://github.com/excalidraw/excalidraw) online drawing tool. Neither gamedev or project management related, but is so versatile, I find myself using it quite often.
- 🎓 [ChatGPT](https://chat.openai.com/) - Every time you are about to Google something, I would strongly advice first to ask ChatGPT your question. We, producers, might often need to reference or look up a term or a concept, which is where ChatGPT shines.
- [GPT for Google Sheets and Docs](https://gptforwork.com/) - An awesome Google Workspace extension, that allows querying ChatGPT from within sheets or docs. You can generate data and modify any data tables or just text in any way using forumulas and functions directly in the documents.
- [SteamDB](https://steamdb.info/) - As they say, database of everything on Steam. Very useful to follow your competitors and compare the numbers.
- [VG Insights](https://vginsights.com/) - One of the better analytics tools and sources of estimated sales data. They also have some unique tools other similar services don't, e.g. revenue calculator, unit sales estimator and some others.
- [Steam Wishlists To Sales Calculator](https://impress.games/steam-wishlists-sales-calculator) - Simple tool to help you ballpark sales numbers based on the wishlists count on Steam. It is not as accurate, as some other tools are, but is the simplest one.

### Templates

- [Art Asset List template](https://docs.google.com/spreadsheets/d/1G7X_Xzx9P8TONQewx8FDgBgF06pQcRPzz3COvWiHn2U/edit?usp=sharing) - A basic and process agnostic template to keep track of all in-game assets, that need to be produced, their status (high-level) and naming. Should be adjusted to your production pipeline.
- [GameDiscoverCo - BASIC net revenue predictions](https://docs.google.com/spreadsheets/d/11tNEABOKuJxX9kTLJ08DyEMf1UC3cbLdejRtmjgLBDI/edit?gid=0#gid=0) - A simple template to calculate your sales projections. As the name implies, it is very basic.
- [Forecasting model by Fellow Traveler](https://docs.google.com/spreadsheets/d/1_cG9zDn_fzy6EhClcCpxKAWDVyb_SNaARCKsXChAvKo/edit?gid=0#gid=0) - A solid template to use when forecasting sales numbers for your game.
- [Altshift Steam Market Study template](https://docs.google.com/spreadsheets/d/1tcfsNVI4x-T-Fq8gNCjiNVutB-pol2Awn6fscoZ2c-Q/edit?gid=0#gid=0) - Another template to help you analyze your competitors and calculate your potential sales numbers. Ideally, use this in combination with other templates mentioned aboe to refine your guesstimations.

## 📨 Subscriptions

To stay up-to-date, consider subscribing to all or some of the below resources. These are not production related (as in Project Management), but as a producer, you kinda want to know a little bit about everything in gamedev. So pick your poison.

### YouTube

- [GDC](https://www.youtube.com/@Gdconf) - Game Developers Conference YouTube channel, all sorts of talks on anything game development related. It's huge and is updated frequently, but you'll have to filter the information you need.
- [Noclip - Video Game Documentaries](https://www.youtube.com/@NoclipDocs) - Crowdfunded documentaries about the production process of different kinds of games. Kind of a peek behind the curtains, sometimes with interesting "post-mortem" type of insights.
- [Game Production Academy](https://www.youtube.com/@game-production-academy) - Videos on agile topics for Game Producers. Check out their [web-site](https://www.game-production.com/) for extra articles.
- [Timothy Cain](https://www.youtube.com/@CainOnGames) - I've listed one Tim's video in the Videos section above, but I strongly suggest to subscribe to his channel, it's just full of stories and experience, that will help you have good context on game development all around.

### Newsletters

- [Deconstructor of Fun](https://www.deconstructoroffun.com/) - Not directly production related, but offers in-depth analysis on recent gamedev events, e.g. Brawl Stars ditching lootboxes: why, how and what was the outcome. You want to know about things like this when leading the production of your next mobile action game. And they also have a [podcast](https://pca.st/5tK0).
- [The GameDiscoverCo Newsletter](https://newsletter.gamediscover.co/) - Focused on the business side of game production and game discoverability, their in-depth analysis on Steam-related topics is gold. Must-read.

### Podcasts

- [The Art of LiveOps](https://pca.st/ywLc6I) - This show seems to have ended, but some (if not all) episodes are still relevant in 2023. If you're managing a live mobile game, give it a listen.
- [Deconstructor of Fun](https://podcasters.spotify.com/pod/show/deconstructoroffun/) - The difference with the newsletter is that it has more stuff to read, like industry news, new game releases, in-depth articles on some general gamedev topics. Still, their podcast is great if you're on the go.
  - [Diablo Boss Rod Fergusson On What Makes a World Class Video game Producer](https://podcasters.spotify.com/pod/show/deconstructoroffun/episodes/Diablo-Boss-Rod-Fergusson-On-What-Makes-a-World-Class-Videogame-Producer-e1peebp/a-a8n77qu) - Rod drops some knowledge on us as we talk about how to be a world-class game producer. Whether you've been making games for 2 years or 20, there is plenty to learn in enlightening episode.

### RSS feeds and other sources

- [fedoruk.works](https://t.me/beardpm) - Quality project management content, not game development specific (<img src="https://raw.githubusercontent.com/lipis/flag-icons/blob/main/flags/4x3/ua.svg" width="16">).
- [Kryuchkov about outsourcing](https://t.me/KPOutsourcing) - Software Delivery Management Consultant Alexander Kryuchkov shares his advice about managing projects. I like him a lot because basically every post is highly practical and is packed with experience. Must read for any Project Manager (<img src="https://raw.githubusercontent.com/lipis/flag-icons/blob/main/flags/4x3/ua.svg" width="16">).
- [Game Developer](https://www.gamedeveloper.com/rss.xml) - RSS feed of the gamedeveloper.com (ex. gamasutra.com) - both news and articles, all about game development (including production).
- [Naavik](https://naavik.co/feed) - A very high-quality business-focused blog to stay up-to-date on the industry. Check out their "Deep Dives" series for case studies on the failures and successes of pupular titles and studios.

## 🌐 Websites and other resources

- [Global GameDev Salaries 2020-2021](https://docs.google.com/spreadsheets/d/1cM3_iBGF8IXZfLS5GKvC0-JWh0tS6TVYJJ-HxlguinA/edit?usp=sharing) - A Google Sheet with salarie statistics, put together by Evva Karr <sup><a name="eva-karr" href="#eva-karr-fn">*</a></sup>
- [H1B Salary Database](https://h1bdata.info/index.php?em=&job=game+producer&city=&year=all+years) - Not sure how accurate this data is, as I'm not from USA.
- [Seyed's Publisher Database](https://docs.google.com/spreadsheets/d/15AN1I1mB67AJkpMuUUfM5ZUALkQmrvrznnPYO5QbqD0/edit?gid=1783327951#gid=1783327951) - A very detailed list of game publishers with some extra notes on most of them. Go-to resource for finding yourself a publisher.
- [How To Market A Game](https://howtomarketagame.com/) - Chris knows a thing or two about game marketing and discoverability. As a Game Producer, you will cross paths with marketing quite often, so go follow him.

## Contributing

Contributions welcome! Read the [contribution guidelines](https://github.com/vhladiienko/awesome-game-production/blob/master/contributing.md) first.

## Footnotes
<a name="eva-karr-fn" href="#eva-karr">*</a> [Evva Karr](https://www.evvakarr.com/)
