<div class="github-widget" data-repo="lucasviola/awesome-functional-programming"></div>
## Awesome Functional Programming [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

Based on the [Awesome](https://github.com/sindresorhus/awesome/) project

## What is this about?

On the last decade, functional programming has gained a new found power due to its
declarative characteristics which, some would say, are very effective for parallel computing
and for the whole usage of [Moores Law](https://en.wikipedia.org/wiki/Moore%27s_law).

This repo gathers some material on Functional Programming such as blog posts, papers, videos,
tools, etc. and also aims to clarify some of the theoretical subjects behind it.

Want to contribute? Please refer to [this](https://github.com/lucasviola/awesome-functional-programming/blob/master/contributing.md) first.


### Blog posts
- [Personal thoughts on the current functional programming bandwagon](http://www.akitaonrails.com/2015/10/28/personal-thoughts-on-the-current-functional-programming-bandwagon) 
Despite the name, this post actually clarifies some baisc concepts on Functional Programming, explains some of the History of FP and the implementation of FPs features on imperative languages and talks about all the fuss on declarative programming and why it has become so popular in the last few years.
- [A Monad in Practicality - Controlling Time](http://robotlolita.me/2014/03/20/a-monad-in-practicality-controlling-time.html)
- [A Monad in Practicality - First Class Failures](http://robotlolita.me/2013/12/08/a-monad-in-practicality-first-class-failures.html)
- [How to desugar Haskell Code](http://www.haskellforall.com/2014/10/how-to-desugar-haskell-code.html)
- [Functors, Applicatives, And Monads In Pictures](http://adit.io/posts/2013-04-17-functors,_applicatives,_and_monads_in_pictures.html)
- [Monads Made Difficult](http://www.stephendiehl.com/posts/monads.html)
- [Your easy guide to Monads, Applicatives, & Functors](https://medium.com/@lettier/your-easy-guide-to-monads-applicatives-functors-862048d61610)
- [Async Streams in C#](https://freecontent.manning.com/async-streams-in-c/)
- [How to leverage functional programming in Kotlin to write better, cleaner code](https://doordash.engineering/2022/03/22/how-to-leverage-functional-programming-in-kotlin-to-write-better-cleaner-code/)

### Papers
- [Tradeoffs between Unique Types and Monads](http://lambda-the-ultimate.org/node/1180) 
- [The implementation of Functional Programming Languages](http://research.microsoft.com/en-us/um/people/simonpj/papers/slpj-book-1987/start.htm) - A paper by Simon Peyton Jones
- [Sound and Decidable Type Inference for Functional Dependencies](http://research.microsoft.com/en-us/um/people/simonpj/papers/fd-chr/esop04.pdf) - Another very famous paper on Type Inference by the main creator of Haskell and GHC
- [Template Meta-Programming for Haskell](http://research.microsoft.com/en-us/um/people/simonpj/papers/meta-haskell/meta-haskell.pdf) - Paper about generating code at compile-time in Haskell
- [Why Functional Programming Matters](http://www.cs.kent.ac.uk/people/staff/dat/miranda/whyfp90.pdf)
- [From Higher-Order Logic to Haskell: There and Back Again](http://isabelle.in.tum.de/~haftmann/pdf/from_hol_to_haskell_haftmann.pdf)
- [Translating Haskell to Isabelle](http://es.cs.uni-kl.de/events/TPHOLs-2007/proceedings/B-178.pdf)

### Wikis
- [nLab](http://ncatlab.org/nlab/show/HomePage) - A wiki-lab with articles, discussion and tools from the point of view of category theory, which is the main math behind FP.
- [Haskell/Category Theory](https://en.wikibooks.org/wiki/Haskell/Category_theory) - A good overview on Category Theory applied to Haskell from Wikibooks.
- [Haskell Wiki](https://wiki.haskell.org/Haskell)

### Books
- [Learn you a Haskell](http://learnyouahaskell.com/) - Book, but you can read it online for free as well. Very beginner friendly.
- [The Little Prover](https://books.google.com.br/books?id=I9E_CgAAQBAJ&pg=PR13#v=onepage&q&f=false) - Talks about
a theorem prover called JBob for writing proofs in LISP.
- [Isabelle/HOL - A Proof Assistant for Higher-Order Logic](http://isabelle.in.tum.de/doc/tutorial.pdf) - A Book on implementing logical formalisms in Isabelle/HOL.
- [The Little MLer](http://www.ccs.neu.edu/home/matthias/BTML/) - A book focused on teaching types, recursive thinking and other important subjects in Standard ML. 
- [Introduction to Programming using SML](http://catalogue.pearsoned.co.uk/educator/product/Introduction-to-Programming-using-SML/9780201398205.page) - Introduces you to programming design in a very mathematical way. 
- [How to Design Programs](http://www.htdp.org/) / [Second Edition](http://www.ccs.neu.edu/home/matthias/HtDP2e/)
- [Introduction to Functional Programming](http://www.amazon.com/Introduction-Functional-Programming-International-Computing/dp/0134841891)
- [Haskell in Depth](https://www.manning.com/books/haskell-in-depth) - the perfect second book on Haskell which dives into examples and application scenarios designed to teach how Haskell works and how to apply it correctly. 
- [Grokking Simplicity: Taming complex software with functional thinking](https://www.manning.com/books/grokking-simplicity) - Teaches functional programming from first principles using real-world scenarios.
- [Functional Programming in Scala, Second Edition](https://www.manning.com/books/functional-programming-in-scala-second-edition) - International bestseller revised with new exercises, annotations, and full coverage of Scala 3.
- [Functional Programming in C#, Second Edition](https://www.manning.com/books/functional-programming-in-c-sharp-second-edition) - Real world examples and practical techniques for functional programming in C#.
- [Grokking Functional Programming](https://www.manning.com/books/grokking-functional-programming) - Introduction to functional programming.
- [Functional Programming in Kotlin](https://www.manning.com/books/functional-programming-in-kotlin) - Master techniques and concepts of functional programming to deliver safer, simpler, and more effective Kotlin code.
- [Functional Design and Architecture](https://www.manning.com/books/functional-design-and-architecture) - Design patterns and architectures for building production quality applications using functional programming, with examples in Haskell and other FP languages.
- [Haskell Bookcamp](https://www.manning.com/books/haskell-bookcamp) - In this book, you’ll get practical experience writing Haskell code and applying functional programming to actual development challenges.
- [Mastering Functional Programming](https://www.perlego.com/book/800653/mastering-functional-programming-functional-techniques-for-sequential-and-parallel-programming-with-scala-pdf) - If you are from an imperative and OOP background, this book will guide you through the world of functional programming, irrespective of which programming language you use.
- [Jax in Action](https://www.manning.com/books/jax-in-action) - A book about The JAX numerical computing library.
- [Learn PowerShell Scritping in a Month of Lunches](https://www.manning.com/books/learn-powershell-scripting-in-a-month-of-lunches-second-edition) - Automate complex tasks and processes with PowerShell scripts.
- [F# in Action](https://www.manning.com/books/f-sharp-in-action) - Book about practical F# development skills needed to create professional applications.
- [Elixir in Action, Third Edition](https://www.manning.com/books/elixir-in-action-third-edition) - Fully updated to Elixir 1.14, this authoritative bestseller reveals how Elixir tackles problems of scalability, fault tolerance, and high availability.

### Communities
- [Lambda the Ultimate](http://lambda-the-ultimate.org/) - Community focused on discussing researches, papers
and hot topic on academia. Very high tech discussion level.
- [FP Complete](https://www.fpcomplete.com/) - Community focused on helping companies and students on learning and implementing Functional Programming in Haskell. Hosters of one of the most famous Haskell learning centers: [School of Haskell](https://www.schoolofhaskell.com/school)
- [Haskellers](http://www.haskellers.com/) - The meeting point for Haskell Programmers
- [ElixirLangMoscow](http://elixir-lang.moscow/) - Russian Elixir community

### Discussions (Quora, Stack Overflow, Reddit, etc)
- [Why dont more programmers use Haskell](https://www.quora.com/Why-dont-more-programmers-use-Haskell)
- [Hidden complexities of tail-call/tail-recursion optimization](http://lambda-the-ultimate.org/classic/message1532.html)

### Videos
- [Dont fear the Monad](https://www.youtube.com/watch?v=ZhuHCtR3xq8) - Explanation on
one of the most obscure topics of Functional Programming by Microsoft researcher Brian Beckman.
- [Haskell is useless](https://www.youtube.com/watch?v=iSmkqocn0oQ) - Simon Peyton Jones being
just too humble about his creation.
- [Brian Beckman: The Zen of Stateless State](https://www.youtube.com/watch?v=XxzzJiXHOJs)
- [Erik Meijer: Functional Programming](https://www.youtube.com/watch?v=z0N1aZ6SnBk)
- [Scala Monads: Declutter Your Code With Monadic Design](https://www.youtube.com/watch?v=Mw_Jnn_Y5iA)
- [Philip Wadler and Erik Meijer: On Programming Language Theory and Practice](https://www.youtube.com/watch?v=9SBR_SnrEiI)
- [Kotlin for Android & Java Developers](https://www.manning.com/livevideo/kotlin-for-android-and-java-developers) - LiveVideo course about Kotlin: functional programming, object orientation and building an Android app in Kotlin.
- [Do we really need OOD and FDD?](https://www.youtube.com/watch?v=KW9U6HMKEgk) - Functional Declarative Design (FDD) opposed to Object-Oriented Design (OOD
* [Functional Programming with TypeScript](https://www.youtube.com/playlist?list=PLuPevXgCPUIMbCxBEnc1dNwboH6e2ImQo) - Discover functional programming with Typescript and create a library like fp-ts alongside Sahand Javid in this beginner-friendly YouTube playlist.

### Lectures
- [C9 Lectures: Dr. Erik Meijer - Functional Programming Fundamentals](https://www.youtube.com/playlist?list=PLTA0Ta9Qyspa5Nayx0VCHj5AHQJqp1clD) - Series of Lectures from one of the creators of Haskell
- [Adventure with types in Haskell - Simon Peyton Jones](https://www.youtube.com/watch?v=6COvD8oynmI&list=RD6COvD8oynmI#t=0) - Lectures about Haskells strong Type System by Simon Peyton Jones.
- [The Algebra of Algebraic Data Types](https://www.youtube.com/watch?v=YScIPA8RbVE) - Very good explanation
on the relationship between math and Algebraic Data Types, which is the Type System of some very common FP Languages such as Haskell and ML.

### Platforms

- [Paqmind.com] – Guides and challenges to learn and improve in programming. All content is CS and FP oriented.

### Tools
- [Isabelle/HOL](https://www.cl.cam.ac.uk/research/hvg/Isabelle/) - Generic proof assistant based on Higher Order Logic	

### Repos
- [Idris Koans](https://github.com/idris-hackers/idris-koans) - Project for teaching Idris. A General Purpose Functional Programming with Dependent Types
- [Functional Javascript Workshop](https://github.com/timoxley/functional-javascript-workshop) - A functional Javascript workshop.
- [J-Bob](https://github.com/the-little-prover/j-bob) - The proof assistant from the book `The Little Prover`
- [Haskell Must Watch](https://github.com/olehkuchuk/haskell-must-watch) - A list of videos, talks and courses on Haskell.
- [Intro SML](http://www.it.dtu.dk/introSML/) - Code, corrections and info on the book: `Introduction to Programming using SML`
- [Functional Programming In JavaScript](https://github.com/busypeoples/functional-programming-javascript) - List of functional programming resources in JavaScript.
- [Functional Programming Jargon](https://github.com/hemanth/functional-programming-jargon) - Project for providing a glossary for FP, and make learning FP easier.
- [Bow](https://github.com/bow-swift/bow) - Companion library for Typed Functional Programming in Swift.
- [Parsing With Haskell Parser Combinators](https://github.com/lettier/parsing-with-haskell-parser-combinators) - A step-by-step guide to parsing using Haskell parser combinators.
- [Functional Programming Learning Path](https://github.com/imteekay/functional-programming-learning-path.git) - A Learning Path for Functional Programming
### People

- [Simon Peyton Jones](http://research.microsoft.com/en-us/people/simonpj/) - One of the creators of the Haskell Language and the Glasgow Haskell Compiler. Microsoft Researcher.
- [Philip Wadler](http://homepages.inf.ed.ac.uk/wadler/) - Professor of Theoretical Computer Science at the University of Edinburgh, author of the famous paper Propositions as Types. One of the main people behind Java Generics Types.
- [Matthias Felleisen](http://www.ccs.neu.edu/home/matthias/) - Author of many books such as How to Design Programs, and The Little Schemer.
- [Erik Meijer](https://www.linkedin.com/pub/erik-meijer/0/5ba/924) - Former software architect for Microsoft, Functional Programming researcher, gives lectures on	FP, Software Design and Reactive programming.
- [Brian Beckman](https://www.linkedin.com/in/brianbeckman) - Former Microsoft Researcher, actual Software Engineer at Amazon. Contributed to implementing FP features to inumerous Microsoft technologies such as C#, LINQ and F#

### License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Lucas Viola](http://lucasviola.github.io) has waived all copyright and related or neighboring rights to this work.
