<div class="github-widget" data-repo="johnjago/awesome-free-software"></div>
## Awesome Free Software [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

此列表中的软件是根据允许任何人出于任何目的使用、修改和共享该软件的条款分发的. 两个最流行的许可证是 [MIT License](https://choosealicense.com/licenses/mit/) 和 [GNU GPL](https://choosealicense.com/licenses/gpl-3.0/)， 但是这里有 [many other licenses](https://choosealicense.com/appendix/) 授予这些权限.



## Software

### Audio

- [Audacity](http://www.audacityteam.org/) - Sound recording and post-processing. ([GNU GPLv2+](http://www.audacityteam.org/about/license/))
- [Ardour](https://ardour.org/)  - 数字音频工作站（DAW）.  （[GNU GPLv2](https://ardour.org/copying.html))
- [Libre.fm](https://libre.fm/)  - 免费串流、下载、混音和分享音乐.  （[GNU AGPLv3](https://git.gnu.io/gnu/gnu-fm/blob/master/COPYING))
- [LMMS](https://lmms.io/)  - 完整的数字音频工作站.  （[GNU GPLv2+](https://github.com/LMMS/lmms/blob/master/LICENSE.txt))
- [mStream](http://mstream.io/)  - 用于跨多个设备同步和流式传输音乐的软件套件.  （[GNU GPLv3](https://github.com/IrosTheBeggar/mStream/blob/master/LICENSE))
- [Nuclear Music Player](https://nuclear.js.org/)  - 流媒体音乐播放器，自动从免费来源查找音乐.  （[GNU AGPLv3](https://github.com/nukeop/nuclear/blob/master/LICENSE))

### Command Line Tools

- [asciinema](https://asciinema.org/)  - 终端会话记录器.  （[GNU GPLv3](https://github.com/asciinema/asciinema/blob/develop/LICENSE))
- [Clipboard](https://github.com/Slackadays/Clipboard)  - 随时随地通过命令行剪切、复制和粘贴任何内容.  （[GNU GPLv3](https://github.com/Slackadays/Clipboard/blob/main/LICENSE))
- [Cygwin](http://cygwin.com/)  - 适用于 Windows 的类 Unix 环境，提供对 Linux 系统上常见的许多工具的访问.  （[GNU GPLv3](https://cygwin.com/COPYING))
- [Logdissect](https://github.com/dogoncouch/logdissect/)  - 用于分析日志文件和其他数据的 CLI 实用程序和 Python API.  （[MIT](https://github.com/dogoncouch/logdissect/blob/master/LICENSE))
- [PuTTY](http://www.chiark.greenend.org.uk/~sgtatham/putty/)  - 通过 SSH、Telnet、SCP 和 rlogin 协议以及原始套接字连接进行连接的远程终端仿真器.  （[MIT](http://www.chiark.greenend.org.uk/~sgtatham/putty/licence.html))
- [ranger](https://ranger.github.io/)  - 适用于 GNU/Linux 的最小、轻量且美观的文件浏览器. 它在终端窗口中运行，因此非常适合 i3 等窗口管理器.  vi 键绑定允许执行快速操作，包括重命名和删除.  （[GNU GPLv3](https://github.com/ranger/ranger/blob/master/README.md))
- [GNU stow](https://www.gnu.org/software/stow/)  - GNU Stow 是一个符号链接场管理器，它采用位于文件系统上不同目录中的不同软件和/或数据包，并使它们看起来安装在同一位置.  （[GNU GPLv3](https://github.com/ranger/ranger/blob/master/README.md))
- [SimpleLocalize](https://github.com/simplelocalize/simplelocalize-cli) - 用于管理软件项目中的 i18n 密钥的开源工具.

### Communication

- [Conversations](https://conversations.im/)  - 适用于 Android 的 XMPP/Jabber 客户端.  （[GNU GPLv3](https://github.com/siacs/Conversations/blob/master/LICENSE))
- [Gajim](https://gajim.org/)  - 桌面版 XMPP/Jabber 客户端.  （[GNU GPLv3](https://dev.gajim.org/gajim/gajim/blob/master/COPYING))
- [Jitsi Meet](https://jitsi.org/jitsi-meet/)  - 使用 WebRTC 保护视频会议和桌面共享.  （[Apache License 2.0](https://github.com/jitsi/jitsi-meet/blob/master/LICENSE))
- [Mail-in-a-Box](https://mailinabox.email/)  - 易于部署的云计算机邮件服务器包.  （[CC0](https://github.com/mail-in-a-box/mailinabox/blob/master/LICENSE))
- [Matrix](https://matrix.org/)  - 分散、持久和可互操作通信的开放标准.  （[Apache License 2.0](https://github.com/matrix-org/synapse/blob/master/LICENSE))
- [Mattermost](https://mattermost.com/)  - Slack 的开源私有云替代方案.  （[Licensing](https://www.mattermost.org/licensing/))
- [ProtonMail](https://protonmail.com/)  - 基于网络的安全电子邮件服务.  （[MIT](https://github.com/ProtonMail/WebClient/blob/public/license.md))
- [Ring](https://ring.cx/)  - 通过分布式服务进行电话、电话会议和媒体共享.  （[GNU GPLv3](https://ring.cx/en/about/practical))
- [Signal](https://signal.org/)  - 适用于桌面、Android 和 iOS 的私人消息传递和通话.  （[GNU GPLv3](https://github.com/WhisperSystems/Signal-Android/blob/master/LICENSE))
- [Tox](https://tox.chat/)  - 具有语音、视频和屏幕共享功能的加密分布式消息传递平台.  （[GNU GPLv3](https://github.com/TokTok/c-toxcore/blob/master/COPYING))
- [Tutanota](https://tutanota.com/)  - 免费加密电子邮件，支持企业帐户.  （[GNU GPLv3](https://github.com/tutao/tutanota/blob/master/LICENSE.txt))

### File Management

- [7-Zip](http://7-zip.org/)  - 用于创建和打开压缩文件的文件存档器.  （[GNU LGPLv2.1+](http://www.7-zip.org/faq.html))
- [Filestash](http://www.filestash.app)  - 类似 Dropbox 的 Web 客户端，用户可以自带自己的后端（FTP、SFTP、Webdav、S3、Minio 等）.  （[GNU AGPLv3](https://github.com/mickael-kerjean/filestash/blob/master/LICENSE))
- [FileZilla](https://filezilla-project.org/)  - 通用 FTP 解决方案.  （[GNU GPLv2+](https://filezilla-project.org/license.php))
- [WinSCP](https://github.com/winscp/winscp) - 适用于 Windows 的 SFTP 和 FTP 客户端（[GNU GPLv3](https://github.com/winscp/winscp/blob/master/license.txt))


### File Sharing

- [qBittorrent](https://www.qbittorrent.org/)  - 易于使用的 BitTorrent 客户端.  （[GNU GPLv2+](https://raw.githubusercontent.com/qbittorrent/qBittorrent/master/COPYING))
- [Sharry](https://eikek.github.io/sharry/)  - 方便的文件共享 Web 应用程序，允许您上传文件并获取可共享的 URL.  （[GNU GPLv3+](https://github.com/eikek/sharry/blob/master/LICENSE.txt))

### Graphics

- [Blender](https://www.blender.org/)  - 用于建模、模拟和动画的 3D 创建套件.  （[GNU GPLv2+](https://www.blender.org/about/license/))
- [ExifCleaner](https://exifcleaner.com/)  - GUI 应用程序可通过简单的拖放从图像和视频中删除 exif 元数据.  （[MIT](https://github.com/szTheory/exifcleaner/blob/master/LICENSE))
- [GIMP](http://www.gimp.org/)  - 图像处理软件.  （[GNU GPLv3](https://www.gimp.org/about/COPYING))
- [Inkscape](https://inkscape.org)  - 适用于所有平台的专业矢量图形编辑器.  （[GNU GPL](https://bazaar.launchpad.net/~inkscape.dev/inkscape/trunk/view/head:/COPYING))
- [Krita](https://krita.org)  - 艺术家制作的绘画程序.  （[GNU GPLv3](https://phabricator.kde.org/source/krita/browse/master/COPYING))
- [Pinta](https://pinta-project.com/) - Gtk# clone of Paint.NET. ([MIT](https://github.com/PintaProject/Pinta/blob/master/license-mit.txt))
- [Piskel](http://www.piskelapp.com/)  - 在线精灵编辑器.  （[Apache License 2.0](https://github.com/juliandescottes/piskel/blob/master/LICENSE))

### IDEs

- [Eclipse](https://www.eclipse.org/eclipseide/)  - 可扩展的 IDE，支持最新的 Java 版本以及其他语言.  （[EPL](http://www.eclipse.org/legal/epl-v10.html))
- [IntelliJ IDEA Community Edition](https://github.com/JetBrains/intellij-community)  - Java/Android IDE，目标是最大限度地提高开发人员的生产力.  （[Apache License 2.0](https://github.com/JetBrains/intellij-community/blob/master/LICENSE.txt))

### Office

- [LibreOffice](https://www.libreoffice.org/)  - 带有文字处理程序、电子表格和演示程序的办公套件.  （[MPLv2](https://www.libreoffice.org/about-us/licenses/))
- [Open Office](https://github.com/apache/openoffice)  - 提供基于开放标准的全功能办公生产力套件.  （[Apache License 2.0](https://github.com/apache/openoffice/blob/trunk/LICENSE))
- [Zathura](https://git.pwmt.org/pwmt/zathura)  - 高度可定制且功能齐全的文档查看器. 它提供了简约且节省空间的界面以及主要侧重于键盘交互的简单使用.  （[zlib License](https://git.pwmt.org/pwmt/zathura/raw/master/LICENSE))

### Operating Systems

- [Debian](https://www.debian.org/)  - 最早的类 UNIX 操作系统之一，致力于将非自由软件排除在其系统之外.  （[DFSG](https://en.wikipedia.org/wiki/Debian_Free_Software_Guidelines))
- [Devuan](https://devuan.org/)  - 没有 systemd 的 Debian 分支.  （[Licenses](https://devuan.org/os/source-code))
- [PureOS](https://pureos.net/)  - FSF 认可 Debian 的衍生版本.  （多个许可证）
- [LineageOS](https://lineageos.org/)  - 适用于手机和平板电脑的 Android 发行版以及 CyanogenMod 的后继者.  （多个许可证）

### Other

- [Disroot](https://disroot.org/)  - 此列表中许多服务的托管版本.  （多个许可证）
- [OpenMapTiles](https://openmaptiles.org/)  - 用于自行托管 50 多种语言的 OpenStreetMap 地图的开源工具集. 它提供栅格和矢量切片、GIS 程序的 WMS 和 WMTS 服务、JavaScript 查看器和移动 SDK 的支持.  （[BSD](https://github.com/openmaptiles/openmaptiles/blob/master/LICENSE.md))
- [ZeroNet](https://zeronet.io/)  - 使用比特币加密和 BitTorrent 网络的去中心化网站.  （[GNU GPLv2](https://raw.githubusercontent.com/HelloZeroNet/ZeroNet/master/LICENSE))
- [Simple Mobile Tools](https://simplemobiletools.github.io/) - 带有可自定义小部件的 Android 应用程序，没有烦人的广告和不必要的权限.
- [IP2Trace](https://github.com/ip2location/ip2location-traceroute)  - 使用 IP2Location 数据库显示地理位置信息的跟踪路由工具.  （[MIT](https://github.com/ip2location/ip2location-traceroute/blob/master/LICENSE))

### Payments

- [Electrum](https://electrum.org)  - 轻量级比特币客户端，提供钱包恢复、去中心化服务器和离线存储.  （[MIT](https://github.com/spesmilo/electrum/blob/master/LICENCE))
- [GNU Taler](https://taler.net)  - 类似现金的在线支付系统.  （[GNU GPL](https://taler.net/en/developers.html))

### Scientific Work

- [DocEar](http://www.docear.org/)  - 使用思维导图技术进行文献管理.  （[GNU GPLv2+](https://github.com/Docear/Desktop/blob/master/docear_framework/license.txt))
- [JabRef](https://www.jabref.org)  - 使用 BibTeX/BibLaTeX 管理参考文献和附加的 PDF. 包括对 LibreOffice 的支持.  （[MIT](https://github.com/JabRef/jabref/blob/master/LICENSE.md))

### Screencasting

- [OBS Studio](https://obsproject.com/)  - 适用于所有平台的屏幕录像机和视频流应用程序.  （[GNU GPLv2](https://github.com/jp9000/obs-studio/blob/master/COPYING))
- [ShareX](https://getsharex.com/)  - 屏幕截图、文件共享和生产力工具.  （[GNU GPLv3](https://github.com/ShareX/ShareX/blob/master/LICENSE.txt))
- [SimpleScreenRecorder](http://www.maartenbaert.be/simplescreenrecorder/)  - 高度可定制的 GUI 截屏程序.  （[GNU GPLv3](http://www.maartenbaert.be/simplescreenrecorder/#license))

### Text Editors

- [Atom](https://atom.io/)  - 可破解的文本和源代码编辑器.  （已存档）（[MIT](https://raw.githubusercontent.com/atom/atom/master/LICENSE.md))
- [Pulsar](https://pulsar-edit.dev/)  - 社区主导的超级可破解文本编辑器. 从 Atom 分叉.  （[MIT](https://raw.githubusercontent.com/pulsar-edit/pulsar/master/LICENSE.md))
- [Emacs](https://www.gnu.org/software/emacs/)  - 可扩展、可定制、免费/自由的文本编辑器 - 等等.  （[GNU GPL](http://www.free-soft.org/gpl_history/emacs_gpl.html))
- [GNU nano](https://www.nano-editor.org/)  - 命令行的简单文本编辑器.  （[GNU GPL](https://www.nano-editor.org/dist/v2.7/README))
- [vim](https://www.vim.org/)  - Vim 是一个高度可配置的文本编辑器，旨在非常高效地创建和更改任何类型的文本.  （[GNU GPL compatible](https://vimhelp.org/uganda.txt.html#license))
- [VS Code](https://github.com/microsoft/vscode) - Microsoft 制作的源代码编辑器（[MIT](https://github.com/microsoft/vscode/blob/main/LICENSE.txt))
- [Notepad++](https://notepad-plus-plus.org/)  - 可扩展的文本和源代码编辑器.  （[GNU GPLv2+](https://raw.githubusercontent.com/notepad-plus-plus/notepad-plus-plus/master/LICENSE))

### Utilities

- [Grayscale Mode](https://github.com/rkbhochalya/grayscale-mode)  - 一款开源 macOS 应用程序，可让您直接从菜单栏或使用键盘快捷键 (⌥⌘G) 快速切换灰度滤镜.  （[MIT](https://github.com/rkbhochalya/grayscale-mode/blob/master/LICENSE))
- [Markdownify](https://markdownify.js.org)  - 一个最小的 Markdown 编辑器.  （[MIT](https://github.com/amitmerchant1990/electron-markdownify/blob/master/LICENSE.md))
- [Sandman](https://alexanderepstein.github.io/Sandman/)  - 让您知道何时关闭计算机并根据计算的睡眠周期进行睡眠.  （[MIT](https://github.com/alexanderepstein/Sandman/blob/master/License.md))
- [Search Deflector](https://spikespaz.com/search-deflector)  - 一个小程序，可将从 Windows 开始菜单或 Cortana 进行的搜索重定向到您喜欢的任何浏览器和搜索引擎.  （[MIT](https://github.com/spikespaz/search-deflector/blob/master/LICENSE))
- [Wireshark](https://www.wireshark.org/)  - 用于网络故障排除和分析的数据包分析器.  （[GNU GPLv2](https://code.wireshark.org/review/gitweb?p=wireshark.git;a=blob_plain;f=COPYING;hb=HEAD))
- [Espanso](https://github.com/federico-terzi/espanso) - 跨游戏形式的文本扩展器（[GNU GPLv3](https://github.com/federico-terzi/espanso/blob/master/LICENSE))

### Video

- [NewPipe](https://newpipe.schabi.org/)  - 适用于 Android 的轻量级 YouTube 前端.  （[GNU GPLv3](https://github.com/TeamNewPipe/NewPipe/blob/master/LICENSE))
- [Kodi](https://kodi.tv/)  - 家庭影院软件和娱乐中心.  （[GNU GPLv2](https://github.com/xbmc/xbmc/blob/master/README.md))
- [VLC](http://www.videolan.org/vlc/)  - 支持多种音频和视频格式的多媒体播放器.  （[GNU GPLv3](http://www.videolan.org/videolan/))
- [youtube-dl](https://rg3.github.io/youtube-dl/)  - 功能丰富的命令行程序，用于从 YouTube 和其他视频网站下载视频.  （[Unlicense](https://github.com/rg3/youtube-dl/blob/master/LICENSE))
- [MPV](https://mpv.io/)  - 具有脚本支持的可定制多媒体播放器.  （[GNU GPLv2](https://github.com/mpv-player/mpv/blob/master/LICENSE.GPL/))

### Virtualization

- [QEMU](http://www.qemu-project.org/)  - QEMU 是一个通用的开源机器模拟器和虚拟器.  （[GNU GPLv2](http://wiki.qemu-project.org/License))
- [VirtualBox](https://www.virtualbox.org/)  - 功能丰富的虚拟化工具，支持多种操作系统.  （[GNU GPLv2](https://www.virtualbox.org/wiki/GPL))

### Web Applications

- [Cloverleaf](https://cloverleaf.app)  - 一个开源应用程序，可替代您的密码管理器，而无需在任何地方存储您的密码.  （[MIT](https://github.com/cloverleaf/web/blob/master/LICENSE))
- [Dnote](https://www.getdnote.com/)  - 一个简单的命令行笔记本，具有多设备同步和网络界面.  （[GNU AGPLv3](https://github.com/dnote/dnote/blob/master/licenses/AGPLv3.txt))
- [Etherpad](http://etherpad.org/)  - 实时协作文档编辑.  （[Apache License 2.0](https://github.com/ether/etherpad-lite/blob/develop/LICENSE))
- [Ghost](https://ghost.org/)  - 用于构建和运行在线出版物的可破解平台.  （[MIT](https://github.com/TryGhost/Ghost/blob/master/LICENSE))
- [GitLab](https://about.gitlab.com/installation/)  - 整个代码生命周期的 Git 存储库管理器.  （[MIT](https://gitlab.com/gitlab-org/gitlab-ce/raw/master/LICENSE))
- [GNU social](https://gnu.io/social/)  - 用PHP编写的微博服务器.  （[GNU GPLv3](https://git.gnu.io/gnu/gnu-social/blob/master/COPYING))
- [Gogs](https://gogs.io/)  - 轻量级、跨平台、自托管的 Git 服务.  （[MIT](https://github.com/gogits/gogs/blob/master/LICENSE))
- [Healthchecks](https://healthchecks.io/)  - Cron 作业监控服务.  （[BSD 3-clause](https://github.com/healthchecks/healthchecks/blob/master/LICENSE))
- [Inventaire](https://inventaire.io/welcome)  - 与朋友和社区分享书籍.  （[GNU AGPLv3](https://github.com/inventaire/inventaire/blob/master/LICENSE.md))
- [Lobsters](https://lobste.rs/)  - 链接聚合和讨论以及否决解释.  （[BSD 3-clause](https://github.com/lobsters/lobsters/blob/master/LICENSE))
- [Mastodon](https://joinmastodon.org/)  - 去中心化的社交网络服务器.  （[GNU AGPLv3](https://github.com/tootsuite/mastodon/blob/master/LICENSE))
- [MediaGoblin](http://mediagoblin.org/)  - 各类媒体的发布平台.  （[GNU AGPLv3](http://mediagoblin.org/))
- [MediaWiki](https://www.mediawiki.org)  - Wiki 软件可以组织和提供大量经常访问的数据.  （[GNU GPLv2+](https://www.mediawiki.org/wiki/Copyright))
- [MetaGer](https://metager.de/en)  - 由非营利组织创建的私人搜索引擎，其服务器使用绿色电力.  （[GNU AGPLv3](https://gitlab.metager3.de/open-source/MetaGer/blob/development/LICENSE))
- [Neocities](https://neocities.org/)  - 现代世界的地理城市.  （[BSD 2-clause](https://github.com/neocities/neocities/blob/master/LICENSE.txt))
- [NotABug.org](https://notabug.org/)  - 免费许可项目的协作平台.  （[MIT](https://notabug.org/hp/gogs/src/master/LICENSE))
- [OpenStreetMap](https://www.openstreetmap.org)  - 由用户创建并在开放许可下发布的世界地图.  （[GNU GPLv2](https://git.openstreetmap.org/rails.git/blob/HEAD:/LICENSE))
- [PeerTube](https://framagit.org/chocobozzz/PeerTube)  - 去中心化视频流服务.  （[GNU AGPLv3](https://framagit.org/chocobozzz/PeerTube/blob/develop/LICENSE))
- [Phabricator](https://phacility.com/phabricator/)  - 使用 PHP 构建的代码管理平台（类似于 GitLab）.  （[Apache License 2.0](https://github.com/phacility/phabricator/blob/master/LICENSE))
- [Wallabag](https://wallabag.org/en)  - 保存和分类文章. 稍后再读. 自由自在.  （[MIT](https://github.com/wallabag/wallabag/blob/master/COPYING.md))
- [Weblate](https://weblate.org)  - 具有版本控制集成的翻译管理系统.  （[GNU GPLv3](https://github.com/WeblateOrg/weblate/blob/master/COPYING))
- [WordPress](https://wordpress.org/)  - 博客发布平台和内容管理系统.  （[GNU GPLv2+](https://wordpress.org/about/gpl/))

### Web Servers

- [Apache HTTP Server](https://httpd.apache.org/)  - 安全、高效且可扩展的 Web 服务器.  （[Apache License 2.0](http://www.apache.org/licenses/))
- [lighttpd](http://www.lighttpd.net/)  - 针对速度关键的环境进行了优化，同时保持符合标准、安全和灵活.  （[Revised BSD license](http://www.lighttpd.net/assets/COPYING))
- [nginx](https://nginx.org/)  - HTTP 和反向代理服务器、邮件代理服务器和通用 TCP/UDP 代理服务器.  （[2-clause BSD-like license](https://nginx.org/LICENSE))

## Hardware

### Companies

- [Aleph Objects](https://www.alephobjects.com/) - 采用自由硬件和软件构建的尊重您的自由 (RYF) 认证的 3D 打印机.
- [Libiquity](http://www.libiquity.com/) - 设计和开发嵌入式软件和固件系统.
- [Purism](https://puri.sm/) - 注重隐私、安全和自由的计算机和软件.
- [Raptor Computing Systems](https://raptorcs.com/) - 使用 IBM POWER9 处理器和 OpenBMC 固件的台式机、主板和其他部件.
- [Technoethical](https://tehnoetic.com/) - 与免费操作系统兼容的笔记本电脑、适配器和移动设备.
- [ThinkPenguin](https://www.thinkpenguin.com/) - 不包含专有软件的现代笔记本电脑、台式机和打印机.
- [Vikings](https://vikings.net/) - 由 Libreboot 固件、libre 软件和绿色能源提供支持的托管公司，同时也销售硬件.

### Hardware Resources

- [disaster.radio](https://disaster.radio/) - 基于免费软件和经济实惠的开放硬件构建的离网、太阳能供电、远程网状网络.
- [h-node](https://h-node.org/) - 与完全免费的操作系统配合使用的硬件数据库.
- [Linux Preloaded](https://linuxpreloaded.com/) - 来自许多地区的精心挑选的销售预装免费软件的计算机的供应商列表.
- [Respects Your Freedom Hardware Certification](https://www.fsf.org/resources/hw/endorsement/criteria) - 获得自由软件基金会 RYF 认证资格的要求.

## Resources

### Articles

- [Free Software](https://en.wikipedia.org/wiki/Free_software) - 关于自由软件主题的维基百科条目.
- ['Libre' Software: Turning Fads into Institutions?](https://www.sciencedirect.com/science/article/pii/S0048733302000033) - 学术文章介绍了自由软件及其可持续性的经济分析.
- [Software Freedom](https://devuan.org/os/free-software) - Devuan 简短、简单地解释了为什么自由软件很重要.

### Blogs

- [BrainBlasted's Privacy and Free Software Blog](https://brainblasted.gitlab.io/) - 实际考察涉及自由软件和隐私的问题.

### Businesses

- [Bytemark](https://www.bytemark.co.uk/company/manifesto/) - 透明的英国托管公司，为任何发布免费软件的人提供 50% 的折扣.

### Discovery

- [Free Software Directory](https://directory.fsf.org/wiki/Main_Page) - 超过 15,000 个免费软件包.
- [Free GNU/Linux Distributions](https://www.gnu.org/distros/free-distros.html) - 完全免费的发行版.
- [freepost](https://freepo.st/) - 与自由文化相关的一切.

### Events

- [LibrePlanet](https://libreplanet.org/) - 自由软件年会.
- [Software Freedom Day](https://en.wikipedia.org/wiki/Software_Freedom_Day) - 每年一度的全球自由软件庆祝活动，旨在提高人们对自由软件及其优点的认识.

### Licensing

- [FOSSology](https://www.fossology.org/) - 软件项目的许可证合规性工具包.
- [gplenforced.org](https://gplenforced.org/) - 以社区为导向的 GPL 实施.

### Organizations

- [April](https://www.april.org/) - 推广和捍卫自由软件.
- [Digital Freedom Foundation](https://en.wikipedia.org/wiki/Digital_Freedom_Foundation) - 通过技术促进获取知识.
- [Framasoft](https://framasoft.org/) - 致力于在全球范围内推广自由软件、创新项目以及共享与合作的世界的网络.
- [Free Software Foundation](https://www.fsf.org/) - 以促进计算机用户自由为全球使命的非营利组织.
- [Free Software Movement Karnataka](https://fsmk.org/) - 印度班加罗尔的一个团体，致力于传播自由软件的意识.
- [Free Software Movement of India](http://fsmi.in/) - 印度自由软件组织联盟.
- [FSF India](http://gnu.org.in/) - FSF 的印度姐妹网站.
- [FSFE](https://fsfe.org/) - FSF 的欧洲姊妹网站.
- [FSFLA](http://www.fsfla.org/ikiwiki/) - FSF 的拉丁美洲姊妹网站.
- [GNU](https://www.gnu.org/) - GNU/Linux 操作系统的主页.
- [Open Source Hardware Association](https://www.oshwa.org/) - 推广尊重用户自由的硬件.
- [Outreachy](https://www.outreachy.org/) - 帮助来自弱势群体的人们在 FOSS 软件公司找到实习机会.
- [Peers](https://peers.community/) - 帮助支持和发展免费项目的社区.
- [Software Freedom Conservancy](https://sfconservancy.org/) - 帮助促进、改进、开发和捍卫自由、开源软件项目的慈善机构.
- [Software Freedom Law Center](https://www.softwarefreedom.org/) - 为免费、自由和开源软件创建者提供免费法律服务.
- [Snowdrift.coop](https://snowdrift.coop/) - 公共产品的众筹.
- [TuxFamily](https://www.tuxfamily.org/) - 自由项目的免费托管和其他服务.

### Other Lists

- [Awesome Humane Tech](https://github.com/engagingspaces/awesome-humane-tech) - 关注道德、透明度和隐私的项目列表.
- [Awesome Self-Hosted](https://github.com/Kickball/awesome-selfhosted) - 可本地托管的 FLOSS 网络服务和 Web 应用程序列表.
- [Awesome Sysadmin](https://github.com/n1trux/awesome-sysadmin) - 免费软件系统管理工具列表.

### People

- [Maxime Lathuilière](https://maxlath.eu/) - 通过自由软件重组信息和资源，以实现自由社会.

### Talks

- [Agustín Benito: Free Software, Beyond Software (TEDxLaLaguna)](https://www.youtube.com/watch?v=_2Qq072wIDk) (Español)
- [Eben Moglen: How I Discovered Free Software](https://www.youtube.com/watch?v=uKxzK9xtSXM)
- [Prof. Nagarjuna G: Free Software for Digital India](https://www.youtube.com/watch?v=O1A4UZqPtMQ)
- [Richard Stallman: Free Software, Free Society (TEDxGeneva 2014)](https://www.youtube.com/watch?v=Ag1AKIl_2GM)
- [Stephen Fry: Free Software](https://www.youtube.com/watch?v=YGbMbF0mdPU)
- [Wrishiraj Kaushik: I Am Not a Free Software Guy](https://www.youtube.com/watch?v=KQCC5oSfAYo)

### Documentaries
- 2019: [Hacking for the Commons, by Philippe Borrel](https://vimeo.com/channels/1540870/393778517).

## License

[CC0 1.0](https://creativecommons.org/publicdomain/zero/1.0/)
