<div class="github-widget" data-repo="andrewda/awesome-frc"></div>
## Awesome FRC [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/andrewda/awesome-frc/master/media/first.svg?sanitize=true" align="right" width="150">](https://www.firstinspires.org/robotics/frc)

&gt; 与 FIRST 机器人竞赛相关的 _awesome_ 软件包和资源的精选列表.

[FRC](https://www.firstinspires.org/robotics/frc) 是一项全球高中机器人竞赛，学生们竞相在短短六周内建造出最好的机器人. 这些工具、资源、社区和学习材料将帮助您的 FRC 赛季精彩纷呈.



## General

- [The Blue Alliance](https://www.thebluealliance.com/) - FRC 领先的赛事、球队和比赛追踪器.
- [The Compass Alliance](https://www.thecompassalliance.org/) - 用于学习所有 FRC 主题的资源，适合任何级别的经验.
- [State Space Guide](https://github.com/calcmogul/state-space-guide) - 状态空间控制实用指南：高中生研究生水平的控制理论.
- [GradleRIO](https://github.com/wpilibsuite/GradleRIO) - 一个强大的 Gradle 插件，允许参加 FIRST 机器人竞赛的团队生成和构建他们的代码.

## Suppliers

- [CTR Electronics](http://www.ctr-electronics.com/) - 许多经 FRC 使用认证的流行零件的供应商，包括 Talon SRX 和 Victor SPX.
- [AndyMark](https://www.andymark.com/) - 教育机器人市场的供应商，特别关注 FIRST.
- [VEXpro](https://www.vexrobotics.com/vexpro) - 由 FIRST 校友组成的 FRC、FTC 和 VEX 零件分销商.
- [McMaster-Carr](https://www.mcmaster.com/) - 从紧固件到气动装置等多种应用的零件综合索引.
- [REV Robotics](http://www.revrobotics.com/) - 许多 FIRST Legal 机械和电气零件的经销商，包括 NEO 无刷电机和 Spark MAX 电机控制器.
- [West Coast Products](http://www.wcproducts.net) - 一家由 FIRST 校友创立的公司，旨在分销可靠且高品质的零件.

## Programming

- [WPILib ScreenSteps](https://wpilib.screenstepslive.com)  - 硬件和官方支持的软件语言的旧且不受支持的文档. 如需了解最新信息，请查看以下内容.
- [WPILib Docs](https://docs.wpilib.org/en/latest/) - 2020 年及以后的 FRC 硬件和软件的最新文档.

## Vision

- [CSCore](https://github.com/wpilibsuite/cscore) - WPI 的 CScore 相机视觉库.
- [254 2016 Vision Talk](https://www.youtube.com/watch?v=rLwOkAJqImo) - 关于视觉追踪的最完整的课程.
- [2729 Storm Robotics Vision](https://github.com/2729StormRobotics/StormCV2017) - 使用 OpenCV 和 GRIP 创建视觉系统的示例.
- [Limelight](https://limelightvision.io/) - 专为 FRC 打造的即插即用视觉解决方案.
- [ChickenVision](https://github.com/team3997/ChickenVision) - 由 Team 3997 创建的易于实施的视觉系统.
- [SERT Vision](https://github.com/SouthEugeneRoboticsTeam/vision) - Jetson 支持的 OpenCV 视觉跟踪解决方案，配有状态 GUI 和 NetworkTable 挂钩.
- [GRIP](https://github.com/WPIRoboticsProjects/GRIP) - 用于快速原型设计和部署计算机视觉算法的应用程序.

## Scouting

- [Robot Scouter](https://github.com/SUPERCILEX/Robot-Scouter) - 华丽而强大的 Android 侦察应用程序.
- [VictiScout](https://github.com/FRCScout/FRCScout) - Team 1418 开发的 Light Electron 侦察应用程序.

## Driving

- [QDriverStation](https://github.com/FRC-Utilities/QDriverStation)  - 适用于所有桌面平台的流行开源驱动程序站克隆. 虽然不允许参加比赛，但对于希望在另一个平台上行驶或提高开源信誉的团队来说至关重要.
- [FRCDashboard](https://github.com/FRCDashboard/FRCDashboard) - 强大而灵活的样板，用于使用网络技术创建复杂的驾驶仪表板.
- [SmartDashboard.js](https://github.com/erikuhlmann/SmartDashboard.js) - SmartDashboard 端口用 JavaScript 和 `nw.js` 编写.

## Community

- [/r/FRC](https://www.reddit.com/r/FRC/) - 唯一的 FRC Reddit 子版块.
- [Chief Delphi](https://www.chiefdelphi.com/forums/portal.php) - 有关 FRC 一切的重要论坛.
- [Discord Server](http://discord.gg/frc)  - 聊天社区，提供机器人技术建议并与其他 FRC 学生、导师和校友进行社交活动. 绝对是进行 FRC 讨论的最佳场所.
- [Discord Server List](https://docs.google.com/spreadsheets/d/1rm6C_hHhPmiIBZxrQT-xGag2Kv9RTpEdENYSKNYB7iI/edit#gid=1112789586) - FRC 非官方区域、组织和社区服务器列表.

## Repositories

### Java/Kotlin

- [WPILib](https://github.com/wpilibsuite/allwpilib) - 官方 WPILib 存储库，包含 Java 和 C++ 库的代码.
- [SmartDashboard](https://github.com/wpilibsuite/SmartDashboard) - 官方 SmartDashboard 存储库包含 Java Driver Station 仪表板的代码.
- [Shuffleboard](https://github.com/wpilibsuite/Shuffleboard) - 为 FIRST 团队提供干净的驾驶员站仪表板.
- [Sertain](https://github.com/SouthEugeneRoboticsTeam/sertain) - 一个基于 WPILib 构建的框架，使 Kotlin 中的机器人编程更加美观.
- [ROOSTER](https://github.com/flamingchickens1540/ROOSTER) - FIRST 有用类和系统的公共库.
- [FalconLibrary](https://github.com/FRC5190/FalconLibrary) - 由 Team 5190 制作的 Kotlin 机器人编程库.
- [SnobotSim](https://github.com/snobotsim/SnobotSim) - 一个用Java编写的可以模拟FRC机器人的程序.
- [Lib5K](https://github.com/frc5024/lib5k) - 5024团队开发的机器人库 

### C++

- [WPILib (Java/C++)](https://github.com/wpilibsuite/allwpilib) - 官方 WPILib 存储库，包含 Java 和 C++ 库的代码.
- [BaseBot](https://github.com/frc5024/basebot) - 对 barebonesFRC 的完全重写，经过严格优化，可以尽可能快地运行，并在定期函数期间使用最少的资源.

### C#

- [WPILib (C#)](https://github.com/robotdotnet/WPILib) - Unofficial WPILib port for writing robot code in C#.
- [NetworkTables (C#)](https://github.com/robotdotnet/NetworkTables) - Unofficial NetworkTables port for C#.
- [FRC-Extension (Visual Studio)](https://github.com/robotdotnet/FRC-Extension) - Visual Studio extension to make writing C# robots a breeze.

### Python

- [RobotPy-WPILib](https://github.com/robotpy/robotpy-wpilib) - 非官方 WPILib 端口允许您用 Python 编写机器人代码.
- [pyrobottraining](https://github.com/robotpy/pyrobottraining) - 使用 Python 进行 FRC 机器人编码的基础教程.
- [pynetworktables](https://github.com/robotpy/pynetworktables) - 允许在 Python 中访问 NetworkTables 的端口.
- [TBApi](https://github.com/PlasmaRobotics2403/TBApi) - 用于与蓝色联盟 API 交互的 Python 库.

### CSS

- [banners.css](https://github.com/ErikBoesen/banners.css)  - 用于创建纯 CSS FRC 横幅的库. 团队网站的实用且漂亮的装饰.

### Ruby

- [tba.rb](https://github.com/frc1418/tba.rb) - 简单的 Ruby 库，可轻松与蓝色联盟 API 进行交互.

### JavaScript

- [TBA Node API](https://github.com/Team2537/tba-api-node) - 用于与蓝色联盟 API 交互的 Node.js 库.

## Videos

- [FIRST on YouTube](https://www.youtube.com/user/FIRSTWorldTube) - FIRST 的官方 YouTube 频道.
- [Game Animations](https://www.youtube.com/watch?v=uYNu9cQac1o&list=PLOPIDgAYFKaQmz6aznEMAbewtqqT7FCqY) - 自 2003 年以来每个游戏发行视频的播放列表.
- [Reveal Videos](https://www.youtube.com/watch?v=2zu1EzyKRRE&list=PLocx3vY5mUKNSVfiI1kEjZ9AXtMu1N7-B) - 最佳机器人展示视频的播放列表.

## Miscellaneous

- [FIRST Map](https://firstmap.github.io) - 精美的世界 FRC 球队地图.
- [FRC New Tab](https://chrome.google.com/webstore/detail/frc-new-tab/agmoglelphhinnadfmbfodhkdagibkop) - Chrome 扩展程序可以用随机的 FRC 团队填充您的新标签页，或向该团队显示与当前时间相对应的号码.
- [FRC Bot](https://github.com/FRC-Bot/FRCBot-ChatBot) - Facebook Messenger 机器人，用于获取有关 FRC 团队、活动和比赛的信息.
