<div class="github-widget" data-repo="podo/awesome-framer"></div>
## Awesome Framer [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://raw.githubusercontent.com/podo/awesome-framer/master/logo.png" align="right" width="75">](https://framer.com/)

&gt; 精选清单 [Framer](http://framer.com) 原型设计工具文章、资源、教程和其他相关内容.

[Framer](http://framer.com) 是创建动画和交互式原型的工具. 它使用 JavaScript、HTML 和 CSS 等现代网络技术来扩展高级用户的功能，并使用自动更正、直观的错误消息或应用程序内文档来降低初学者的学习曲线.



---

## General
* [Official Site](http://framer.com)
* [Official Examples](http://framer.com/examples)
* [Documentation](http://framer.com/docs)
* [Facebook Group](https://www.facebook.com/groups/framerjs/)

## Articles
* [Designer / coder, and not the other way around](https://medium.com/road-to-infinity/designer-coder-and-not-the-other-way-around-4288098986e1#.a1ks034fn) - Paul Cotton 谈到他是如何开始使用 Framer 的.
* [Why Framer.js Matters](https://medium.com/@drocarmo/why-framer-js-matters-93eb1206e606#.846k6rca6) - Pedro Carmo 关于为什么 Framer 是设计师应该开始使用的工具.

## Videos
* [Stripe Speaker Series: Designing with Framer](https://www.youtube.com/watch?v=mqk9Fw8FKLY) - Koen Bok 和 Jorn van Dijk 就 Framer 进行了简短的演讲和问答，其中还涵盖了一般的原型制作以及对市场上可用的各种设计工具的讨论.
* [FORM SF 2014: Panel - Design Tooling](https://www.youtube.com/watch?v=gX0n4JUl18g) - 流行设计工具（包括来自 Framer 的 Koen Bok）的创造者之间关于原型制作价值的讨论、在为设计师制作产品时吸取的经验教训以及 UX 工具的未来.

## Tutorials
* [Framer.js Official Basics](http://framerjs.com/learn/basics) - 开始使用 Framer 制作原型的地方.
* [Framer Video Tutorials](https://www.youtube.com/playlist?list=PL9p5auxyrweMB6JVO24jFvW4NZufHacjz) - 直接由 Framer 团队提供的视频教程.
* [New to Framer? Just 3 Things to Get You Started](https://medium.com/@designforhuman/new-to-framer-just-3-things-to-get-you-started-47397f27c71e#.uk7q8mqts) - David Lee 的入门指南.
* [Framer.js for people who think things like Framer.js are weird and hard](https://medium.com/@sean_mateer/framer-js-for-people-who-think-things-like-framer-js-are-weird-and-hard-add2068c8114#.epx95tg0t) - Sean Mateer 让奇怪而困难的事情看起来很简单.
* [Prototyping & Working with Framer](http://humaan.com/prototyping-with-framer/) - Dan Moore 的简单入门指南.
* [Prototyping with Framer.js](http://blog.tackmobile.com/article/prototyping-framer-js/) - Tackmobile 团队的 Framer 基础知识.
* [Getting Started with Framer](http://www.cutandfold.co/blog/2015/9/7/making-you-first-framer-prototype) - Andrew Nalband 编写的非常基本的 Framer 入门指南.
* [Building Your First Prototype](http://www.cutandfold.co/blog/2015/9/8/building-your-first-prototype) - Andrew Nalband 的第二个指南，您可以从中开始从 Sketch 文件构建真实原型.
* [Creating Your First Prototype with Framer](https://medium.com/@kennycheny/creating-your-first-prototype-with-framer-c39221da7668#.3jcem1x61) - Kenny Chen 的动画教程.
* [Framer.js Workshop](http://codepen.io/collection/nRzzaZ/) - Framer 示例的集合 [Jay Stakelon](https://twitter.com/stakelon).
* [Motion is Emotion: Prototyping Microinteractions for Apple Watch with Framer Studio](https://web.archive.org/web/20160304015511/https://blog.grandcentrix.net/motion-is-emotion/) - Apple Watch 温度计原型教程.
* [Periscope Heart Animation Demo at the Seattle FramerJS Meetup](https://www.youtube.com/watch?v=qFUXxqzZytU) - 演讲者 [Jordan Dobson](https://twitter.com/jordandobson) 关于如何使用 Framer 创建 Periscope 心脏动画.
* [Using Parse to power up your Framer prototypes](https://medium.com/facebook-design/using-parse-to-power-up-your-framer-prototypes-88cb87009d00#.8noe6r2wb) - George Kedenburg III 将 Framer 与真实数据结合使用第 1 部分.
* [Give your Framer prototypes a better memory](https://medium.com/facebook-design/give-your-framer-prototypes-a-better-memory-212b26e0f934#.6ws4983e7) - George Kedenburg III 将 Framer 与真实数据结合使用第 2 部分.
* [Working with SVG Paths in Framer](https://medium.com/framer-prototyping/working-with-svg-paths-in-framer-43d3c2d08adc) - Josh Puckett 的 Framer 中 SVG 路径的起点.
* [Managing Styles and CSS in Framer](http://martenbjork.com/2016/05/managing-styles-and-css-in-framer/) - Mårten Björk 谈 Framer 中的样式管理.
* [Developing a Framer Module](https://medium.com/bpxl-craft/developing-a-framer-module-dbf6a7d6ffc9#.ju0gck7hd) - John Marstall 教授如何创建成帧器模块.
* [Prototyping for Virtual Reality using Framer JS](https://uxdesign.cc/vr-based-viewmaster-in-framer-js-72858df6570f#.r8ylyzbks) - Keyur Jain 在 Framer 中为虚拟现实体验制作原型时学到的一些交互注意事项的摘录.
* [Prototyping Speech Recognition in Framer.js](https://medium.com/framer-prototyping/prototyping-speech-recognition-in-framer-js-9cbbbd01757#.dkwuowqwy) - Brian Bailey 简要介绍了 Framer 中的语音识别原型.
* [Power your Framer prototypes with real location data](https://www.mapbox.com/blog/power-framer-prototype-with-mapbox/) - Maya Gao 在 Framer 原型上使用 Mapbox API 的真实位置数据.
* [How to Create High‑Quality GIFs](https://framer.com/blog/posts/how-to-create-high-quality-gifs) - 如何创建高质量 GIF，我们的指南使用一些我们最喜欢的工具制作惊人的 GIF：ScreenFlow 和 Claquette.

## Video Courses
* [Mobile App Prototyping: Designing Custom Interactions](https://www.skillshare.com/classes/design/Mobile-App-Prototyping-Designing-Custom-Interactions/382444545) - 50 分钟的 Skillshare 课程，介绍如何使用移动应用程序原型制作来传达您的想法并执行您的愿景 [Noah Levin](https://twitter.com/nlevin).
* [Framerjs: Innovative prototyping and design with interaction](https://www.udemy.com/framerjs-prototyping-design-interaction-animation/?couponCode=FRAMER) - 54 个部分，6 小时课程 [Adria Jimenez](https://twitter.com/ajimix).
* [Prototyping with Framer](http://www.sketchcasts.net/episodes/prototyping-with-framer-part-1) - 由三部分组成的原型制作课程 [Rafael Conde](https://twitter.com/rafahari).
* [Rapid Prototyping with Framer](https://player.oreilly.com/videos/9781771374620) - 5 小时的原型制作课程 [Kenny Chen](https://twitter.com/kennycheny).
* [Prototyping With Framer.js](https://generalassemb.ly/education/prototyping-with-framerjs) - 现场课程由 [Jay Stakelon](https://twitter.com/stakelon), [Noah Levin](https://twitter.com/nlevin) 和 [Cemre Güngör](https://twitter.com/gem_ray).
* [UI Prototyping with Framer.js](https://www.pluralsight.com/courses/ui-prototyping-framer-js) - 将近 5 小时的课程 [Jay Stakelon](https://twitter.com/stakelon).
* [Framercasts](http://www.framercasts.com/) - 通过由 [Mike Johnson](https://twitter.com/failsafedesign).
* [Framer for UX Design](https://www.lynda.com/FramerJS-tutorials/UX-Design-Tools-Framer/562923-2.html) - Emmanuel Henri 展示了如何使用非编码 Framer 工具以及如何将编程的使用融入 UX 设计过程.
* [Framer Crash Course](https://www.youtube.com/playlist?list=PLWlUJU11tp4f41p4dzizVkjjTQ38kA0wG) - 学习 Framer 设计和代码基础知识的速成课程.
* [designers.how Framer Courses](https://designers.how/topics/framer) - 基本和更高级的 Framer 课程列表.
* [Framer Studio for Beginners: A Comprehensive Guide](https://www.youtube.com/playlist?list=PLIZVb6Yuw91yGUNbSNEHvWWHkdol6SJUW) - 一系列视频，引导您使用动手项目在 Framer 中进行设计和编码 [Cordova Putra](https://twitter.com/cordova)

## Books
* [CoffeeScript for Framer](http://coffeescript-for-framerjs.com) 经过 [Tessa Thornton](https://twitter.com/tessthornton)
* [The Framer book](https://framerbook.com) 经过 [Tes Mat](https://twitter.com/cptv8)

## Examples
* [Framer Experiments by Ed Chao](http://thatedchao.com/published/2014/10/27/framer.html) - 几个很棒的例子，带有来自 Dropbox 设计师的下载链接.
* [HSL Color Picker](http://share.framerjs.com/ft0uwf1jweid/) - Framer 团队的 HSL 颜色选择器.
* [iOS Toggle](http://share.framerjs.com/mraze47eux9w/) - iOS 切换使用颜色类 [Jorn van Dijk](https://twitter.com/jornvandijk).

## Modules
* [framer-googlefonts](https://github.com/peteschaffner/framer-googlefonts) - 用于 Framer 原型的 Google 字体加载器模块.
* [tabBarModule](https://github.com/petterheterjag/tabBarModule) - 复制 iOS 标签栏的 Framer 模块.
* [framer-animation-collections](https://github.com/isaacw/framer-animation-collections) - 用于管理大量动画的成帧器类.
* [framer.iosnotification](https://github.com/leinerud/framer.iosnotification) - 模仿 iOS 通知的成帧器模块.
* [shortcuts-for-framer](https://github.com/facebook/shortcuts-for-framer) - 收集有用的功能，使使用 Framer 进行移动原型制作更加容易.
* [framer.placehold](https://github.com/cupofjoakim/framer.placehold) - 这是一个 framer 模块，提供不同图像占位符服务的库.
* [FramerNavigationComponent](https://github.com/jchavarri/FramerNavigationComponent) - 基于 iOS 的 Framer 可重用和可定制的导航组件.
* [RippleTransition.framer](https://github.com/offirg75/framer.RippleTransition) - 用于材料设计的成帧器模块，如波纹过渡.
* [framer-icon](https://github.com/peteschaffner/framer-icon) - Framer 基于模板图像动态着色图标.
* [framer.makeGradient](https://github.com/cupofjoakim/framer.makeGradient)  - Framer 模块，可以轻松创建静态线性/径向渐变. 想让他们动起来吗？ 我欢迎请求请求.
* [WatchKit-Framer](https://github.com/ajimix/WatchKit-Framer) - 适用于 Framer 的 Apple Watch 套件模块.
* [Framer-AudioPlayer](https://github.com/benjaminnathan/Framer-AudioPlayer) - Framer 的 AudioPlayer 模块.
* [Framer-VideoPlayer](https://github.com/stakes/Framer-VideoPlayer) - Framer Studio 和 Framer 的视频播放器模块.
* [Framer-Module-ShakeEvent](https://github.com/RayPS/Framer-Module-ShakeEvent) - Framer 的 ShakeEvent 模块.
* [Framer-Module-UISound](https://github.com/RayPS/Framer-Module-UISound/) - 用于 Framer 的 UISound 模块.
* [CameraLayer](https://github.com/ktcy/CameraLayer) - 显示相机图像的成帧层.
* [ios-keyboard-for-framer](https://github.com/supsupmo/ios-keyboard-for-framer) - 适用于 Framer 的 iOS 键盘模块.
* [textLayer-for-Framer](https://github.com/awt2542/textLayer-for-Framer) - Framer 模块，可简化向原型添加文本的过程.
* [Kinetics](https://github.com/joshmtucker/Kinetics) - 在 Framer Studio 项目的任何层上测试弹簧动画，而无需重新加载.
* [framer-flip-card-module](https://github.com/aboutjax/framer-flip-card-module) - Framer 模块可快速创建具有两个图像层的翻转卡片效果.
* [Input-Framer](https://github.com/ajimix/Input-Framer) - 成帧器模块可轻松将您的设计输入转化为实际输入.
* [StickyHeaders-for-Framer](https://github.com/72/StickyHeaders-for-Framer) - Module to create scroll components with sticky stamps in Framer.
* [OrientationEvents](https://github.com/joshmtucker/OrientationEvents) - Framer 处理设备方向事件的模块.
* [ScaleFrame](https://github.com/joshmtucker/ScaleFrame) - 用于 Framer 的模块，用于使用新尺寸计算缩放图层的属性.
* [framer-label](https://github.com/peteschaffner/framer-label) - 为 Framer 提供多行截断支持的标签模块.
* [framer-equally-rotate-images](https://github.com/aboutjax/framer-equally-rotate-images) - 给这个模块一个图像数组，它会在圆形路径中均匀地旋转它们.
* [framer-colour-transition](https://github.com/nickmangos/framer-colour-transition) - 转换图层背景颜色的成帧器模块.
* [framer-webview](https://github.com/peteschaffner/framer-webview) - Framer 的 Web 视图模块.
* [framer-uistatusbar](https://github.com/peteschaffner/framer-uistatusbar) - iOS status bar module for Framer.
* [framer.module.ajax](https://github.com/karlerikjonatan/framer.module.ajax) - Framer 的 Ajax 模块.
* [framer.module.fill](https://github.com/karlerikjonatan/framer.module.fill) - Framer 的填充模块.
* [SpeechSynth](https://github.com/joshmtucker/SpeechSynth) - Web SpeechSynthesis 的成帧器模块.
* [Comment-for-Framer](https://github.com/awt2542/Comment-for-Framer) - 用于在原型中发表评论的 Framer 模块.
* [framer-viewNavigationController](https://github.com/chriscamargo/framer-viewNavigationController) - FramerJS 的简单控制器，让您只需几行代码即可在视图之间进行转换.
* [Layers-for-Framer](https://github.com/awt2542/Layers-for-Framer) - Framer 模块，可让您更轻松地在项目中查找图层.
* [Framer-Highlightr](https://github.com/jonahvsweb/Framer-Highlightr) - 自定义 Framer 模块，显示原型中可点击层上的热点.
* [SVGLayer](https://github.com/joshpuckett/FramerModules/tree/master/SVGLayer) - 模块和相应的 Sketch 插件使在 Framer 中使用 SVG 路径变得简单.
* [VRComponent](https://github.com/jonastreub/VRComponent) - Framer 的虚拟现实组件.
* [3D Touch Module](http://jrdn.io/dO4r) - iOS 3D Touch 支持模块 [Jordan Dobson](https://twitter.com/jordandobson).
* [Simple Android Ripple](https://github.com/imaaronjames/Simple-Android-Ripple) - 用于向任何层添加触摸波纹动画的成帧器模块.
* [Simple Android Keyboards](https://github.com/imaaronjames/Simple-Android-Keyboards) - 只需一行代码，即可轻松将静态 Android 键盘添加到您的 Framer Studio 项目中.
* [Simple Android Toast](https://github.com/imaaronjames/Simple-Android-Toast) - 使用此模块可以轻松地将 Android toasts 添加到您的 Framer Studio 项目中.
* [Simple Android Snackbar](https://github.com/imaaronjames/Simple-Android-Snackbar) - 用于将 Android Material Design Snackbars 添加到您的项目的 Framer 模块.
* [Framer Path](https://github.com/vladimirshlygin/framer-path) - 创建自定义 SVG 形状并分别为每个点设置动画.
* [Material Kit for FramerJS](https://github.com/k-vyn/framer-material-kit) - 在不影响质量或定制的情况下，使用 Material Design 快速轻松地制作原型.
* [iOS Kit for FramerJS](https://github.com/k-vyn/framer-ios-kit) - 在不影响质量或定制的情况下，快速轻松地制作 iOS 原型.
* [framer-Firebase](https://github.com/marckrenn/framer-Firebase) - Firebase 模块允许您的 Framer 原型在多个会话和设备之间毫不费力地加载、保存和同步数据.
* [spotifyApiFramer](https://github.com/mamezito/spotifyApiFramer) - 允许在使用 Spotify API 查询时获取 JSON 对象的 Framer 模块.
* [ViewController-for-Framer](https://github.com/awt2542/ViewController-for-Framer) - Framer 模块可帮助您使用“淡入”、“放大”和“滑入”等预制转换创建多步骤用户流程.
* [Gridddle](https://github.com/Volorf/Gridddle) - FramerJS 的网格模块.
* [SliderLibrary](https://github.com/floludwig/SliderLibrary) - 用于创建滑块的成帧器库.
* [StickyHeaders-for-Framer](https://github.com/72/StickyHeaders-for-Framer) - 在 Framer 的滚动组件中启用粘性标头的模块.
* [framer-view-stack](https://github.com/alandickinson/framer-view-stack) - 用于创建彼此堆叠的视图的成帧器模块.
* [RemoteLayer](https://github.com/bpxl-labs/RemoteLayer) - RemoteLayer 模块允许您立即为您的 tvOS 应用程序原型生成交互式 Apple TV 遥控器.
* [distribute-layers](https://github.com/martenbjork/distribute-layers) - 此软件包可帮助您轻松定位多个 Framer 层.
* [Framer-ValueLayer](https://github.com/tjphilli/Framer-ValueLayer) - ValueLayer 是一个 Layer 子类，致力于帮助您管理原型中的数字，并在它们之间制作动画.
* [perspective-view](https://github.com/mrrocks/perspective-view) - 用于 FramerJS 的模块，用于启用原型的透视图.
* [Pair](https://github.com/IanBellomy/Pair) - Framer 的拖放模块.
* [Cloudstitch Framer Module](https://github.com/cloudstitch/framer.module.cloudstitch) - 模块让您可以将 Google Spreadsheets 和 Microsoft Excel 中的数据直接加载到您的 Framer 项目中.
* [framer-QueryInterface](https://github.com/marckrenn/framer-QueryInterface) - 允许 Framer 原型从其 URL 的最后部分（查询）读取变量并将变量写入变量的模块.
* [Framer StatusBarLayer](https://github.com/bpxl-labs/StatusBarLayer) - 用于为 iOS 应用程序原型生成准确、可自定义状态栏的模块.
* [Loading Placeholder](https://github.com/zehfernandes/framer-loadingplaceholder) - 根据您的图层样式立即创建加载占位符的模块.
* [lottie-framer](https://github.com/72/lottie-framer) - 使用 AirBnb 的 Lottie-Web 渲染从 After Effects（JSON 文件）导出的动画的 Framer 模块.
* [ControlPanelLayer](https://github.com/bpxl-labs/ControlPanelLayer) - 用于创建开发人员面板以从原型内部控制原型各个方面的 Framer 模块.
* [GradientHelper](https://github.com/bpxl-labs/GradientHelper) - 简化将渐变应用于 Framer 层的过程甚至启用动画渐变的模块.
* [FocusEngine](https://github.com/bpxl-labs/FocusEngine) - 用于模拟 Apple TV 和 Roku 上的网格焦点行为的模块.
* [MapboxLayer](https://github.com/bpxl-labs/MapboxLayer) - 用于在原型中创建强大的 Mapbox 地图的模块.
* [Framer Sheet](https://github.com/andrewliebchen/framer-sheet) - 将信息从 Google 表格导入 Framer.
* [FramerAudio](https://github.com/benjamindenboer/FramerAudio) — 允许您在 Framer 中设计音频接口的模块.
* [Framer Slider](https://github.com/benjamindenboer/FramerSlider)  - 允许您设计滑块然后将它们变为现实的模块，而不会失去可定制性. 外观和逻辑分离.
* [iOS-11-Framer](https://github.com/brentcas/iOS-11-Framer) - 适用于 Framer 的 iOS 11 设计系统 GUI.
* [framer-Symbols](https://github.com/der-lukas/framer-Symbols) - 在 Framer 中创建符号的模块.
* [framer-moreutils](https://github.com/steveruizok/framer-moreutils) - 使用一些方便的辅助函数扩展 Utils.
* [framer keyboardEvents](https://github.com/marckrenn/framer-keyboardEvents)  - Framer 的无障碍键盘绑定：无需查找 keyCodes； 支持 100 多个键，对性能的影响最小.
* [Framer Joystick](https://github.com/emilwidlund/framer-joystick) - 游戏手柄驱动的 UI 原型模块.
* [Framer Feedback](https://github.com/aboutjax/Framer-Feedback) - Framer 反馈模块使您可以更轻松地使用反馈消息进行原型制作.
* [Framer-Bottom-Navigation](https://github.com/johnmpsherwin/Framer-Bottom-Navigation) - Framer 模块，用于将 Android 的底部导航添加到您的项目中.
* [Framer Device Rotator](https://github.com/josephxbrick/DeviceRotator) - 一个 Framer 模块，当在桌面浏览器或 Framer Studio 中（但不在设备上）显示时，它会向手机/平板电脑添加旋转按钮.
* [Keyboard Input for Framer](https://github.com/Skinny-Malinky/Keyboard-Input-for-Framer) - 一个允许您轻松管理键盘输入的模块.
* [Framer DesignComponents](https://github.com/sebcglbailey/framer-DesignComponents) - 用于将设计模式下的设计转换为完全可扩展的代码类的模块，无需一行代码！
* [Framer Web Audio API Module](https://github.com/raulibanez/framer-audio) - 为您的 Framer 项目提供更好的音频支持的 Framer 模块.
* [Framer Status Bar Module](https://github.com/walnuttea/statusBar-module) - 在 Framer 应用程序中初始化状态栏的模块.
* [Framer Android Picker](https://github.com/johnmpsherwin/Framer-Android-Picker) - Android 选择器模块.
* [Yummy Framer](https://github.com/janwagner/yummyFramer) - Yummy 提供自定义图层功能，如 LoadViews、LoadNextView、Fade &amp; Move Layer.  
* [Framer Font Loader](https://github.com/steveruizok/fontloader) - 轻松、可靠地将本地和网络字体加载到 Framer 原型中.
* [Framer Form](https://github.com/emilwidlund/framer-form) - 为您的 Framer 原型提供三维空间.
* [FramerMapboxJS](https://github.com/NocheVolta/FramerMapboxJS) - 另一个将 Mapbox 地图集成到 Framer 原型上的模块.



## UI Libraries
* [iOS 11 iPhone GUI](https://github.com/facebookincubator/ios-11-gui-for-framer) - iOS 11 公开发行版中的 GUI 元素模板.
* [Framework](https://github.com/steveruizok/framework) - Framer 的通用组件套件.

## Sites
* [Prototyping With Framer](http://www.prototypingwithframer.com) - Kenny Chen 的博客，其中包含许多出色的示例和教程.
* [Framer Code](http://framerco.de) - Framer 模块、代码示例、片段和提示的集合.

## Other
* [framer-modules](https://github.com/kysely/framer-modules) - 在一处发现、安装和保存您最喜欢的模块.
* [Framer Snippets](https://github.com/robotdestroy/Framer-Snippets-Library) - Framer 片段库有助于加快工作流程.
* [Stitch](https://github.com/mattsjohnston/stitch) - 用于直接从 Sketch 设计向 Framer 原型添加交互的轻量级框架.
* [framer-bootstrap](https://github.com/alexchantastic/framer-bootstrap) - 在您喜欢的编辑器和环境中使用 Framer Library.
* [Fiber](https://framer.com/fiber/) - 带有 15 个屏幕的免费交互式 UI 工具包.
* [Voyage](https://framer.com/voyage/) - 一个免费的旅行主题 UI 工具包，完全交互并为 Framer 制作.
* [iOS Kit](https://framer.com/assets/static/downloads/kits/ios-kit.zip)  - 用于启动您的下一个 iOS 应用程序的现成元素. 直接链接.
* [Android Kit](https://framer.com/assets/static/downloads/kits/android-kit.zip)  - 为您的下一个 Android 应用程序设计的材料设计元素. 直接链接.
* [Web Kit](https://framer.com/assets/static/downloads/kits/web-kit.zip)  - 开始下一个 Web 项目所需的所有元素. 直接链接.
* [Wireframe Kit](https://framer.com/assets/static/downloads/kits/wireframe-kit.zip)  - 用于绘制下一个大项目蓝图的基本线框元素. 直接链接.

---

## License
![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)
