<div class="github-widget" data-repo="brabadu/awesome-fonts"></div>
## Awesome fonts [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A curated list of fonts and typography resources.



## General
* [27 fonts (give or take) that explain your world](https://www.vox.com/2015/2/8/7475667/27-fonts-give-or-take-that-explain-your-world)
* [Fontjoy](http://fontjoy.com/) - Generate font combinations with deep learning
* [Fonts In Use](https://fontsinuse.com/) - A public archive of typography
* [Typewolf](https://www.typewolf.com/)

## Free fonts

#### Collections
* [Crella](https://crella.net/free-fonts/) - Fonts offered for free for commercial use.
* [Fontshare](https://www.fontshare.com/) - A free fonts service launched by the Indian Type Foundry (ITF)
* [Font Squirrel](https://www.fontsquirrel.com/) - A curated collection of free fonts from a variety of foundries
* [Gidole](http://gidole.github.io/) - Open source, modern DIN
* [Google Fonts](https://fonts.google.com/)
  * [Downloader for Google Fonts](https://github.com/qrpike/Web-Font-Load)
  * [Files of Google Fonts](https://github.com/google/fonts) ([sources](https://github.com/googlefonts))
  * [Noto Fonts](https://github.com/googlei18n/noto-fonts) - Internationalized font for all languages, with rich support for CJK and emoji
  * [Roboto](https://github.com/google/roboto) - Default font on Android & ChromeOS, and the recommended typeface for Material Design
* [Indestructible Type](https://github.com/indestructible-type) - An open-source font foundry
* [The League of Moveable Type](https://www.theleagueofmoveabletype.com/) - The Open-Source Type Movement
  * [Chunk](https://www.theleagueofmoveabletype.com/chunk)
  * [Junction](https://www.theleagueofmoveabletype.com/junction)
  * [League Gothic](https://www.theleagueofmoveabletype.com/league-gothic)
  * ... And more
* [Overpass](http://overpassfont.org/) - An open source font family inspired by Highway Gothic
* [Zilla Slab](https://github.com/mozilla/zilla-slab) - Mozilla font
* [Plex](https://github.com/IBM/plex) - IBM's open source font
* [The Ultimate Oldschool PC Font Pack](http://int10h.org/oldschool-pc-fonts/) - A collection of text mode fonts, system fonts and BIOS fonts from DOS-era PCs
* [USWDS](https://github.com/uswds) - U.S. Web Design System
  * [Public Sans](https://public-sans.digital.gov/)
* [FontsKey](https://www.fontskey.com) - Provides free fonts for personal use and commercial paid fonts, and can enter text for quick filtering.

#### Fonts
* [Amstelvar](https://github.com/TypeNetwork/Amstelvar) - A parametric variable font
* [AtF Spark](https://github.com/aftertheflood/sparks) - Font designed to create sparklines
* [Barlow](https://github.com/jpt/barlow) - A grotesk variable font superfamily
* [Inter](https://github.com/rsms/inter) - A typeface specially designed for user interfaces
* [Libre Franklin](https://github.com/impallari/Libre-Franklin) - An interpretation and expansion based on Morris Fuller Benton’s 1912 classic.
* [Manrope](https://github.com/sharanda/manrope) - Modern geometric sans-serif
* [Martian Mono](https://github.com/evilmartians/mono) - Free and open-source monospaced font from Evil Martians
* [Monaspace](https://github.com/githubnext/monaspace) - An innovative superfamily of fonts for code
* [Open Baskerville](http://klepas.org/openbaskerville/)
* [Redacted](https://github.com/christiannaths/Redacted-Font) - Keep your wireframes free of distracting Lorem Ipsum
* [SansBullshitSans](https://github.com/RoelN/SansBullshitSans)
* [Urbanist](https://github.com/coreyhu/Urbanist) - Geometric sans-serif variable font
* [WorkSans](https://github.com/weiweihuanghuang/Work-Sans)


## Emojis
* [alfred-emoji-workflow](https://github.com/carlosgaldino/alfred-emoji-workflow) - Alfred 2 workflow for searching emoji codes
* [Crypto Puzzles](https://github.com/2d4d/crypto_puzzles) - Includes e
moji font: ᵺ ༐ 💰     ༐ ⑀     🅰️ И     € ❎ ㏂ 𝔭 ᇉ     𝔬 🎏     ᵺ €     モ Ⓜ️ 🍩 🃛 ï     ℉ 𝔬 ♑ 𝔱  (Online demo: http://rupp.de/crypto_puzzles/crypto_puzzles_web.py)
* [emoji-cheat-sheet.com](https://github.com/WebpageFX/emoji-cheat-sheet.com) - A one pager for emojis on Campfire and GitHub
* [emoji-data-js](https://github.com/mroth/emoji-data-js) - Emoji encoding swiss army knife for NodeJS
* [emoji-minesweeper](https://github.com/muan/emoji-minesweeper) - Minesweeper game made with emojis
* [emoji-regex](https://github.com/mathiasbynens/emoji-regex) - A regular expression to match all Emoji-only symbols as per the Unicode Standard
* [emoji-rspec](https://github.com/cupakromer/emoji-rspec) - Custom Emoji Formatters for RSpec
* [emoji-translate](https://github.com/notwaldorf/emoji-translate) - Translate text to emoji
* [emoji](https://github.com/leereilly/emoji) - All of the emoji supported on GitHub pull requests, issues, comments, commit messages, markdown files, etc
* [emoji](https://github.com/muan/emoji) - Find the emoji that echoes your mind
* [emoji](https://github.com/wpeterson/emoji) - A gem. For Emoji. For everyone.
* [emojidex](https://github.com/emojidex/emojidex) - Emoji-as-a-service provider and set of tools and assets
* [emojify.js](https://github.com/emojione/emojify.js) - A Javascript module to convert Emoji keywords to images
* [emojify](https://github.com/mrowa44/emojify) - Emoji on the command line
* [emojilib](https://github.com/muan/emojilib) - Emoji keyword library
* [emojillate](https://github.com/notwaldorf/emojillate) - Pixellate an image into emoji
* [emojione](https://github.com/emojione/emojione) - EmojiOne™ is the open emoji standard
* [emojistatic](https://github.com/mroth/emojistatic) - CDN static asset generation for emoji
* [emojitracker](https://github.com/mroth/emojitracker) - Track ALL the emoji
* [emojize](https://github.com/ded/emojize) - High resolution, unicode (emoji) to html conversion utility
* [gemoji](https://github.com/github/gemoji) - Emoji images and names
* [gh-emoji](https://github.com/zzarcon/gh-emoji) - Github emoji parsing done right
* [node-emoji](https://github.com/omnidan/node-emoji) - Simple emoji support for Node.js
* [megamoji](https://github.com/muan/megamoji) - Making megamojis like a pro
* [mojibar](https://github.com/muan/mojibar) - Emoji searcher but as a menubar app
* [mojime](https://github.com/JuanitoFatas/mojime) - Outputs random emojis
* [php-emoji](https://github.com/iamcal/php-emoji) - A PHP Emoji conversion library
* [twemoji](https://github.com/twitter/twemoji) - Twitter Emoji for Everyone
* [vim-emoji](https://github.com/junegunn/vim-emoji) - Emoji in Vim

## Iconic fonts
* [Appa Sariicon](https://github.com/sariina/appa-sariicon) - 147 8-bit retro style webfont icons form web and mobile
* [Country Icons](https://github.com/lipis/flag-icon-css) - A collection of all country flags in SVG and CSS
* [Crypto animal font](https://github.com/ariassd/crypto-animal-font) - This font translates alphabet characters into symbols. The english ordered version uses animals matching the first letter of their name.
* [Evil Icons](http://evil-icons.io/) Simple and clean SVG icon pack with the code to support Rails, Sprockets, Node.js, Gulp, Grunt and CDN
* [Font Custom](https://github.com/FontCustom/fontcustom) - Icon font generator
* [Font-Awesome](https://fontawesome.com) - The iconic font and CSS toolkit
* [font-mfizz](https://github.com/fizzed/font-mfizz) - Vector Icons for Technology and Software Geeks
* [FontAwesomeKit](https://github.com/PrideChung/FontAwesomeKit) - Icon font library for iOS. Currently supports Font-Awesome, Foundation icons, Zocial, and ionicons.
* [fontello](http://fontello.com) - Iconic fonts scissors
  * [brandico.font](http://fontello.github.io/brandico.font/demo.html) - Font with logos of social services & messagers
  * [fontelico.font](http://fontello.github.io/fontelico.font/demo.html) - Open Source iconic font from Fontello project
  * [typicons.font](http://fontello.github.io/typicons.font/demo.html) - Transformed Typicons
* [IcoMoon-Free](https://icomoon.io) - A package of flat vector icons together with an installable ligature font
* [Iconic](https://github.com/somerandomdude/Iconic) - Icon set in raster, vector and font formats
* [icono](https://saeedalipoor.github.io/icono/) - One tag One icon, no font or svg, Pure CSS
* [ionicons](http://ionicons.com/) - The premium icon font for Ionic
* [Map Icons](https://github.com/scottdejonge/map-icons) - Font for use with Google Maps API and Google Places API using SVG markers and icon labels
* [Material design icons](https://github.com/google/material-design-icons) - Official icon set from Google
* [mfglabs-iconset](http://mfglabs.github.io/mfglabs-iconset/) - Awesome web font icon by MFG Labs
* [Micon](https://github.com/xtoolkit/Micon) - Iconic Windows 10 font and CSS toolkit
* [octicons](https://octicons.github.com/) - GitHub's icon font
* [openwebicons](https://pfefferle.github.io/openwebicons/) - Because Font Awesome had no RSS-icon and a font with only one icon would be a bit boring
* [PaymentFont](https://paymentfont.com/) - A sleek webfont containing 94 icons of all main payment operators and methods
* [PE-Analog-Clock-icon-font](https://github.com/jhogue/PE-Analog-Clock-icon-font) - A set of icons for displaying a visual ("analog") representation of time stamps
* [Picon](https://yne.fr/picon) ~666 Pico-sized and ligature based icons + online font generator.
* [Simple Icons](https://simpleicons.org/) - 2287+ free SVG icons for popular brands
* [stackicons](https://github.com/parkerbennett/stackicons) - Icon font and Sass-based construction kit for Stackicons-Social, which supports multiple button shapes and a unique "multi-color" option in CSS for over 60 social brands
* [svg-icon](https://leungwensen.github.io/svg-icon/) - An ultimate SVG icons collection done right
* [typicons.font](http://s-ings.com/typicons/) - 336 pixel perfect, all-purpose vector icons in a web-font kit
* [weather-icons](http://erikflowers.github.io/weather-icons/) - 189 weather themed icons inspired by Font Awesome and ready for Bootstrap
* [WebHostingHub Glyphs](https://github.com/whhglyphs/webhostinghub-glyphs)
* [Zocial](https://github.com/adamstac/zocial) - Sass and Compass CSS3 social buttons framework
  * [CSS social buttons](https://github.com/smcllns/css-social-buttons) - Entirely vector-based social buttons

## Programming fonts
* [Adobe Fonts](https://github.com/adobe-fonts)
  * [Source Code Pro](http://adobe-fonts.github.io/source-code-pro/)
  * [Source Han Serif](https://github.com/adobe-fonts/source-han-serif)
  * [Source Sans Pro](https://github.com/adobe-fonts/source-sans-pro)
  * [Source Serif Pro](https://github.com/adobe-fonts/source-serif-pro)
* [agave](https://github.com/blobject/agave) - Fixed-width outline typeface, designed and produced by type agaric
* [Anonymous Pro](https://www.marksimonson.com/fonts/view/anonymous-pro)
* [Codeface](https://github.com/chrissimpkins/codeface) - Gallery of monospaced fonts for developers
* [Fantasque Sans Mono](https://github.com/belluzj/fantasque-sans)
* [Go Fonts](https://blog.golang.org/go-fonts) - Open source fonts from Golang Project
* [Hack](https://github.com/source-foundry/Hack)
* [Inconsolata](http://levien.com/type/myfonts/inconsolata.html)
* [Input](http://input.fontbureau.com) - Flexible system of fonts designed specifically for code
* [Lab Mono](https://github.com/hatsumatsu/Lab-Mono) - Geometric monospaced typeface
* [Meslo-Font](https://github.com/andreberg/Meslo-Font) - Customized version of Apple's Menlo font
* [Mononoki](http://madmalik.github.io/mononoki/)
* [Nerd Fonts](https://github.com/ryanoasis/nerd-fonts) - Collection of over 20 patched fonts for Powerline, Font Awesome, Octicons, Devicons, and Vim Devicons
* [Operator Mono](https://www.typography.com/fonts/operator/styles/) — A $200 premium programming typeface inspired by traditions of typewriting
* [Recursive Sans & Mono](https://github.com/arrowtype/recursive/) - A variable font family for code & UI
* [Iconic Fonts](https://github.com/iconicFonts/if) - Over 50 Patched Fonts with 60,000+ Icons for Terminal, Window Managers, and More!

#### Programming fonts with ligatures
* [Cascadia Code](https://github.com/microsoft/cascadia-code) - Monospaced font by Miscrosoft designed to enhance the modern look and feel of the Windows Terminal
* [FiraCode](https://github.com/tonsky/FiraCode) - Monospaced font with programming ligatures
* [Fixedsys Excelsior](https://github.com/kika/fixedsys)
* [Hasklig](https://github.com/i-tu/Hasklig)
* [Iosevka](https://github.com/be5invis/Iosevka) - Spatially efficient monospace font family for programming. Built from code.
* [JetBrains Mono](https://www.jetbrains.com/lp/mono/)
* [Lilex](https://github.com/mishamyrt/Lilex) - Modern programming font containing a set of ligatures for common programming multi-character combinations
* [Monoid](https://github.com/larsenwork/monoid)
* [PragmataPro](https://www.fsd.it/shop/fonts/pragmatapro/) - Proprietary font with special ligatures for Haskell, Agda, APL, etc
* [Dank Mono](https://dank.sh/) — A premium programming font with Delightful ligatures and an italic variant
* [Victor Mono](https://rubjo.github.io/victor-mono/) - A free programming font with semi-connected cursive italics, symbol ligatures and Latin, Cyrillic and Greek characters

## JavaScript libs
* [Beatrix](https://github.com/funbox/beatrix) - A tool to chop off useless fonts glyphs and convert TTF/OTF into WOFF & WOFF2
* [Font.js](http://pomax.nihongoresources.com/pages/Font.js/)
* [fontkit](https://github.com/devongovett/fontkit) - An advanced font engine for Node and the browser ([demo](https://fontkit-demo.now.sh/))
* [fontmin](https://github.com/ecomfe/fontmin) - Font minifier
* [Fontsource](https://github.com/fontsource/fontsource) - Self-host Open Source fonts in neatly bundled NPM packages
* [Lettering.js](https://github.com/davatron5000/Lettering.js)
* [localFont](https://github.com/jaicab/localFont) - Save fonts in localStorage
* [opentype.js](https://github.com/nodebox/opentype.js) - Parser and writer for TrueType and OpenType fonts
* [Typefont](https://github.com/Sir-Vasile/Typefont) - Algorithm that tries to recognize the font of a text in a photo
* [Typeset.js](https://github.com/davidmerfield/typeset) - HTML pre-processor for web typography
* [Typr.js](https://github.com/photopea/Typr.js) - Parser and utility for working with fonts (TTF, OTF)

#### Event listeners for fonts loading on a web page
* [Font Face Observer](https://github.com/bramstein/fontfaceobserver)
* [Web Font Loader](https://github.com/typekit/webfontloader)

## Awesome lists
* [Awesome Icons](https://github.com/vkarampinis/awesome-icons)
* [Awesome Typography](https://github.com/Jolg42/awesome-typography)

## GitHub Showcases
* [Fonts](https://github.com/showcases/fonts)
* [Icon Fonts](https://github.com/showcases/icon-fonts)
* [Design Essentials](https://github.com/collections/design-essentials)

## Other
* [Command line font-manager](https://github.com/alyssais/font)
* [fnt](https://github.com/alexmyczko/fnt) - Apt for fonts, the missing font manager for macOS/linux
* [Easy Fonts](https://pagecdn.com/lib/easyfonts) - Makes webfonts easy to use for developers
* [Font Squirrel Webfont Generator](https://www.fontsquirrel.com/tools/webfont-generator) - Upload OTF or TTF fonts, receive webfonts
* [FontForge](https://github.com/fontforge/fontforge) - Cross-platform font editor
* [Powerline Fonts](https://github.com/powerline/fonts) - Patched fonts for Powerline users
* [TruFont](https://github.com/trufont/trufont) - a streamlined and hackable font editor

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

## Contribution

Feel free to make a pull request. [Click here to read the guidelines](https://github.com/willianjusten/awesome-svg/blob/master/contributing.md).
