<div class="github-widget" data-repo="afonsopacifer/awesome-flexbox"></div>
[![awesome flexbox](https://raw.githubusercontent.com/afonsopacifer/awesome-flexbox/master/awesome-flexbox.jpg)](https://github.com/afonsopacifer/awesome-flexbox/)

[![Build Status](https://travis-ci.org/afonsopacifer/awesome-flexbox.svg?branch=master)](https://travis-ci.org/afonsopacifer/awesome-flexbox)
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; CSS Flexible Box Layout Module 或仅 Flexbox 的精选列表.
灵感来自 [awesome-webcomponents](https://github.com/obetomuniz/awesome-webcomponents) 和 [awesome-svg](https://github.com/willianjusten/awesome-svg).


## W3C Specification
*该规范描述了为用户界面设计优化的 CSS 框模型.*
* [CSS Flexible Box Layout Module Level 1](http://www.w3.org/TR/css3-flexbox/)

## Newsletter
* [CSS Layout News](http://csslayout.news/)
* [CSS Weekly](http://css-weekly.com/)
* [Responsive Design Weekly](http://responsivedesignweekly.com/)
* [Web Design Weekly](https://web-design-weekly.com/)


## Books
* [CSS3 Layout Modules 2nd Edition - Rachel Andrew](http://rachelandrew.co.uk/books/css3-layout-modules)

## Guides
*开发人员或设计人员的指南，开始他们研究这项奇妙的技术.*
* [A guide to flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/):metal:
* [A visual guide to CSS3 flexbox properties](https://scotch.io/tutorials/a-visual-guide-to-css3-flexbox-properties)
* [flexbox (pt-br)](http://desenvolvimentoparaweb.com/css/flexbox/)
* [Dive into flexbox](http://bocoup.com/weblog/dive-into-flexbox/)
* [How Flexbox works — explained with big, colorful, animated gifs](https://medium.freecodecamp.com/an-animated-guide-to-flexbox-d280cf6afc35)
* [How Flexbox works — explained with big, colorful, animated gifs (pt-br)](https://medium.com/@lucasjs/como-o-flexbox-funciona-explicado-com-gifs-grandes-e-coloridos-26c42a0bcdc)
* [Learn layout - flexbox (pt-br)](http://pt-br.learnlayout.com/flexbox.html)
* [Learn layout - flexbox](http://learnlayout.com/flexbox.html)
* [Reference of flexbox](http://tympanus.net/codrops/css_reference/flexbox/)
* [Responsive design of the future with flexbox](http://blog.teamtreehouse.com/responsive-design-of-the-future-with-flexbox)
* [The Flexbox Reading List: Techniques and Tools](https://www.smashingmagazine.com/author/cosima-mielke/)
* [Um guia visual para Flexbox (pt-br)](http://edsonjunior.com/um-guia-visual-para-flexbox/)
* [Usando caixas flexiveis CSS (pt-br)](https://developer.mozilla.org/pt-BR/docs/CSS/Usando_caixas_flexiveis_css)
* [Using CSS flexible boxes](https://developer.mozilla.org/en-US/docs/Web/Guide/CSS/Flexible_boxes)
* [What IS Flexbox?](https://medium.com/@spaceninja/what-is-flexbox-6aed968555ef)
* [Desarrollo de aplicaciones web Flexibles (es-es)](http://nucliweb.github.io/flexbox/)
* [Webflow Flexbox](https://flexbox.webflow.com/)

## Cross Browser
*适用于您的项目的提示和技巧在任何地方都适用 :D*

#### Articles
* [6 Reasons to Start Using Flexbox](http://bitsofco.de/6-reasons-to-start-using-flexbox/?utm_campaign=CSS%2BLayout%2BNews&utm_medium=email&utm_source=CSS_Layout_News_31)
* [Advanced cross-browser flexbox](https://dev.opera.com/articles/advanced-cross-browser-flexbox/)
* [Are we ready to use flexbox?](http://www.sitepoint.com/are-we-ready-to-use-flexbox/)
* [CSS Flexbox Is Entirely Logical (Almost)](https://paulrobertlloyd.com/2016/03/logical_flexbox)
* [Designing A Product Page Layout with Flexbox](https://css-tricks.com/designing-a-product-page-layout-with-flexbox/)
* [Normalizando bugs no flexbox em diversos navegadores (pt-br)](http://imasters.com.br/front-end/css/normalizando-bugs-no-flexbox-em-diversos-navegadores/?trace=1519021197&source=single)
* [Normalizing cross-browser Flexbox bugs](http://philipwalton.com/articles/normalizing-cross-browser-flexbox-bugs/)
* [Using flexbox: mixing old and new for the best browser support](https://css-tricks.com/using-flexbox/)
* [Using Modernizr with Flexbox](http://zomigi.com/blog/using-modernizr-with-flexbox/?utm_campaign=CSS%2BLayout%2BNews&utm_medium=email&utm_source=CSS_Layout_News_8)

#### Support
* [Caniuse](http://caniuse.com/flexbox)

#### Preprocessors in action
* [Compass Flexbox](http://compass-style.org/reference/compass/css3/flexbox/)
* [Sass flex mixin](https://github.com/mastastealth/sass-flex-mixin)
* [Stylus flex mixin](https://github.com/differui/stylus-flex-mixin)

#### Polyfills
* [Flexibility](https://github.com/10up/flexibility):metal:
* [Flexie](https://github.com/doctyper/flexie)
* [Reflexie](https://github.com/doctyper/reflexie)

## Other Interesting Articles
*与 flexbox 相关的问题列表.*
* [Almost complete guide to flexbox (without flexbox)](http://kyusuf.com/post/almost-complete-guide-to-flexbox-without-flexbox?utm_campaign=CSS%2BLayout%2BNews&utm_medium=email&utm_source=CSS_Layout_News_36):metal:
* [Designing CSS layouts with flexbox is as easy as pie](http://www.smashingmagazine.com/2015/03/02/harnessing-flexbox-for-todays-web-apps/)
* [Flexbox For Interfaces All The Way: Tracks Case Study](http://www.smashingmagazine.com/2015/11/flexbox-interfaces-tracks-case-study/?utm_source=html5weekly&utm_medium=email)
* [Flexbox’s Best-Kept Secret](https://medium.com/@samserif/flexbox-s-best-kept-secret-bd3d892826b6#.i0v3krqo0)
* [Grid, Flexbox, Box Alignment: Our New System for Layout](https://24ways.org/2015/grid-flexbox-box-alignment-our-new-system-for-layout/?utm_campaign=CSS%2BLayout%2BNews&utm_medium=email&utm_source=CSS_Layout_News_20)
* [Old flexbox and new flexbox](https://css-tricks.com/old-flexbox-and-new-flexbox/)
* [Using flexbox today](https://chriswrightdesign.com/experiments/using-flexbox-today/)
* [Laying Out A Flexible Future For Web Design With Flexbox](https://www.smashingmagazine.com/2015/08/flexible-future-for-web-design-with-flexbox/)
* [Flexbox Cheatsheet](http://jonibologna.com/flexbox-cheatsheet/)

## Presentations
 *厌倦了阅读？ 立即观看交互式演示并学习 flexbox.*

#### Videos
* [CSS Layout o ontem, o hoje e o depois (pt-br)](https://www.youtube.com/watch?v=MjK1MCjqmpU&list=PLnjYA3TxpDpgWE9cXwT5H7wEsG6ql-Q59&index=15)
* [CSS FlexBox Essentials](https://www.youtube.com/watch?v=G7EIAgfkhmg)
* [CSS FlexBox Practical Examples (Rebuilding Dribbble.com using FlexBox)](https://www.youtube.com/watch?v=H1lREysgdgc)
* [Exploring CSS Layout Techniques While Trying To Get a Subtitle to Wrap](https://css-tricks.com/video-screencasts/140-exploring-css-layout-techniques-while-trying-to-get-a-subtitle-to-wrap/)
* [Enhancing Responsiveness With Flexbox](https://www.youtube.com/watch?v=_98SE8WUvLk)
* [Flexbox - CSS Day](https://vimeo.com/131664957)
* [Guía Completa de Flexbox desde 0 (ESP)](https://www.youtube.com/watch?v=F-KCncXMPk0)
* [HTML5. Desenvolvimento avançado](https://www.youtube.com/watch?v=b9ZrOdTFkNk)
* [Introduction to Flexbox](https://mijingo.com/lessons/guide-to-flexbox/?utm_campaign=CSS%2BLayout%2BNews&utm_medium=email&utm_source=CSS_Layout_News_34)
* [Leveling up with flexbox](https://vimeo.com/96406277)
* [What the flexbox?](http://flexbox.io) - 一个简单的 20 个视频课程，将帮助您掌握
* [Flexbox Fundamentals](https://egghead.io/lessons/misc-flexbox-fundamentals)


### [Sketching with CSS](http://www.sketchingwithcss.com) Flexbox Guide by [@sfioritto](https://github.com/sfioritto)

#### Read Materials
* [Access 20+ Page Guide on Flexbox](http://www.sketchingwithcss.com/flexbox-tutorial/)

#### Video Materials
* [Flex-Container Pt. 1: Position Items within a flexbox container](http://www.sketchingwithcss.com/flex-container)
* [Flex-Container Pt. 2: Rows and Columns](http://www.sketchingwithcss.com/flex-container-2/)
* [Grow and Shrink Flex Items](http://www.sketchingwithcss.com/grow-shrink/)
* [Implementing the Sticky Footer and Holy Grail layout](http://www.sketchingwithcss.com/flex-layouts/)

#### Slides and Notes
* [Building responsive layouts presentation](http://zomigi.com/blog/responsive-layouts-css-dev-conf/)
* [CSS Flexbox: Estruturando layouts sem gambiarras (pr-br)](https://speakerdeck.com/afonsopacifer/flexbox)
* [CSS3 layout](http://zomigi.com/blog/css3-layout/)
* [Flexbox](http://zomigi.com/blog/flexbox-presentation/)
* [Flexbox and Grid Layout](http://pt.slideshare.net/diegoeis/flexbox-to-the-people)
* [Future css layout fowd](http://zomigi.com/blog/future-css-layout-fowd/)
* [Leveling up with flexbox](http://zomigi.com/blog/leveling-up-with-flexbox/)
* [RWD flexbox](http://zomigi.com/blog/rwd-flexbox/)
* [CSS Layout: from Table to Flexbox](https://speakerdeck.com/diogomoretti/css-layout-from-table-to-flexbox)

## Tools
*对创建他们的项目有一点帮助：D*
* [Build with Flexbox](http://flexbox.buildwithreact.com/)
* [CSS flexbox please](http://demo.agektmr.com/flexbox/)
* [CSS Flexbox snippets for Atom](https://github.com/brenopolanski/css-flexbox-atom-snippets)
* [CSS Flexbox snippets for Sublime Text 2/3](https://github.com/brenopolanski/css-flexbox-sublime-snippets)
* [Fibonacci](https://github.com/maxsteenbergen/Fibonacci)
* [Flexbox in 5 minutes](https://cvan.io/flexboxin5/)
* [Flexbox playground](https://web.archive.org/web/20151207135410/http://flexiejs.com/playground/)
* [Flexbox property manipulator](http://codepen.io/enxaneta/full/adLPwv/)
* [Flexplorer](http://bennettfeely.com/flexplorer/)
* [Flexyboxes](http://the-echoplex.net/flexyboxes/)
* [Test CSS Flexbox Rules Live](http://flexbox.help/)
* [Try Flexbox](https://zyxneo.github.io/flexbox/try-flexbox)

## Libraries and Frameworks
*基于 flexbox 的令人难以置信的库列表.*
* [Bem grid](https://github.com/bem-incubator/bem-grid)
* [Flexboxgrid](https://github.com/kristoferjoseph/flexboxgrid):metal:
* [Flex Grid Framework](https://afonsopacifer.github.io/flex-grid-framework/):metal:
* [Flexbox Grid for Stylus](http://stylusgrid.com)
* [Fuux](https://github.com/henriquecustodia/fuux) - Fuux 是一个 Flexbox 库，它使用与类相同的 flexbox 接口.
* [Ginger Grid](https://github.com/erwstout/ginger/) - 以一只可爱的小狗命名的 Flexbox 网格框架.
* [Bulma](http://bulma.io/) - 基于 Flexbox 的现代 CSS 框架
* [Milligram](http://milligram.github.io/) - 一个极简的 CSS 框架
* [RolleiFLEX](http://kaisermann.github.io/rolleiflex/) - 只是一个响应式 flexbox 网格
* [Waffle Grid](https://lucasgruwez.github.io/waffle-grid) - 易于使用的 flexbox 网格系统

## Featured Projects
*关于 flexbox 的很棒的项目.*
* [Cool examples of flexbox layout](http://codepen.io/collection/KegmA/) - 一个codepen一个集合.
* [flex-box](https://github.com/potch/flex-box) - 一个自定义元素，使 flexbox 的基础知识更易于使用.
* [Flexbugs](https://github.com/philipwalton/flexbugs) - 社区策划的 flexbox 问题列表和针对这些问题的跨浏览器解决方法.
* [Flexbox Froggy](http://flexboxfroggy.com/) - 学习 CSS flexbox 的游戏.
* [Flexbox Patterns](http://www.flexboxpatterns.com/)  - 示例和源代码将教您如何使用 CSS flexbox 构建 UI 组件！ 什么是弹性盒子？
* [Flexbox Defense](http://www.flexboxdefense.com/) - 塔防有一个转折点：所有塔都必须使用 CSS Flexbox 定位.
* [Flexbox tester](http://madebymike.com.au/demos/flexbox-tester/) - 了解如何计算弹性项目的宽度.
* [Flexbox layout](https://github.com/google/flexbox-layout) - FlexboxLayout 是一个库项目，它将 CSS Flexible Box Layout Module 的类似功能带到 Android.
* [FlexLayout for iOS](https://github.com/lucdion/FlexLayout)  - FlexLayout 使用 Swift 将 flexbox 引入 iOS. 简洁、直观和可链接的语法.
* [grid-styled](https://github.com/jxnblk/grid-styled) - 基于 Flexbox 的响应式 ReactJS 网格系统，使用样式化组件构建
* [iron-flex-layout](https://www.webcomponents.org/element/PolymerElements/iron-flex-layout) - 用于跨平台 flex-box 布局的样式混合
* [Post Apocalypse Flexbox](https://github.com/afonsopacifer/post-apocalypse-flexbox)
* [React-flexbox](https://github.com/tcoopman/react-flexbox) - 实现 css flexbox 以响应内联样式.
* [Reflexbox](https://github.com/jxnblk/reflexbox) - 响应式 React flexbox 网格系统高阶组件.
* [Solved by flexbox](https://github.com/philipwalton/solved-by-flexbox) - 展示曾经很难或无法单独使用 CSS 解决的问题，现在使用 Flexbox 变得非常容易.:metal:
* [Visualizing Flexbox](http://codepen.io/paultrone/pen/xwxNmQ?utm_campaign=CSS%2BLayout%2BNews&utm_medium=email&utm_source=CSS_Layout_News_6) - 一个简洁的小 CodePen 演示，可以使用 Flex 属性.
* [ZEEF CSS Flexbox](https://css-flexbox.zeef.com/afonso.pacifer) - zeef.:metal 上很棒的 flexbox：
* [Flexbox Zombies](http://flexboxzombies.com/p/flexbox-zombies) - 学习 CSS flexbox 的游戏.

## Courses
* [CSS Flexbox Layout](https://teamtreehouse.com/library/css-flexbox-layout?utm_source=Responsive+Design+Weekly&utm_campaign=e4dbc18ebc-Responsive_Design_Weekly_184&utm_medium=email&utm_term=0_df65b6d7c8-e4dbc18ebc-59080665&goal=0_df65b6d7c8-e4dbc18ebc-59080665) - 树屋
* [Learn Flexbox for free](https://scrimba.com/g/gflexbox) - 斯克里巴

## Who to Follow
*谈论它的人.*
* 阿方索·帕西弗 [@afonsopacifer](https://twitter.com/afonsopacifer)
*布拉德弗罗斯特 [@brad_frost](https://twitter.com/brad_frost)
* 克里斯·科耶 [@chriscoyier](https://twitter.com/chriscoyier)
* 利亚维鲁 [@LeaVerou](https://twitter.com/leaverou)
*米克利吉伦沃特 [@zomigi](https://twitter.com/zomigi)
*尼古拉斯 [@necolas](https://twitter.com/necolas)
* 菲利普沃尔顿 [@philwalton](https://twitter.com/philwalton)
*雷切尔·安德鲁 [@rachelandrew](https://twitter.com/rachelandrew)
* 理查德·埃雷拉 [@doctyper](https://twitter.com/doctyper)
* 萨拉苏伊丹 [@SaraSoueidan](https://twitter.com/SaraSoueidan)
*肖恩·菲奥里托 [@sfioritto](https://twitter.com/sfioritto)

## Contributing
想贡献吗？ [Follow these recommendations](https://github.com/afonsopacifer/awesome-flexbox/blob/master/contributing.md).

## License
[MIT License](https://github.com/afonsopacifer/awesome-flexbox/blob/master/license.md) © [Afonso Pacifer](https://afonsopacifer.github.io/)
