<div class="github-widget" data-repo="flame-engine/awesome-flame"></div>
<div align="center">
	<div>
    <a href="https://flame-engine.org/">
		<img width="300" src="https://raw.githubusercontent.com/flame-engine/awesome-flame/master/media/logo.png" alt="Awesome Flame">
    </a>
	</div>
  <p style="margin-top:30px;" align="center">
    <a href="https://github.com/sindresorhus/awesome">
      <img alt="Awesome" src="https://awesome.re/badge-flat.svg" />
    </a>
    <a href="http://creativecommons.org/publicdomain/zero/1.0">
      <img alt="License: CC0" src="https://img.shields.io/badge/license-CC0-lightgray?style=flat-square" />
    </a>
    <a href="https://flame-engine.org">
      <img alt="Powered by Flame" src="https://img.shields.io/badge/Powered%20by-%F0%9F%94%A5-orange.svg?style=flat-square" />
    </a>
    <a href="https://github.com/flame-engine/awesome-flame/blob/master/CONTRIBUTING.md">
      <img alt="Add your project" src="https://img.shields.io/badge/-Add%20your%20project-blue?style=flat-square" />
    </a>
  </p>
</div>

## Awesome Flame

&gt; 与用于 Flutter 的 Flame 引擎相关的游戏、库和文章的精选列表.

[Flame](https://flame-engine.org/) 是用于 Flutter 的极简主义 2D 游戏引擎，它提供了一组不错的独立模块，您可以从中选择来构建游戏.



## Articles & Tutorials

### Beginner Tutorial Series by [Alekhin](https://github.com/japalekhin)

- [Create a Mobile Game with Flutter and Flame - Beginner Tutorial (Introduction)](https://jap.alekhin.io/create-mobile-game-flutter-flame-beginner-tutorial)
- [2D Casual Mobile Game Tutorial - Step by Step with Flame and Flutter (Part 1 of 5)](https://jap.alekhin.io/2d-casual-mobile-game-tutorial-flame-flutter-part-1)
- [Game Graphics and Animation Tutorial - Step by Step with Flame and Flutter (Part 2 of 5)](https://jap.alekhin.io/game-graphics-and-animation-tutorial-flame-flutter-part-2)
- [Views and Dialog Boxes Tutorial - Step by Step with Flame and Flutter (Part 3 of 5)](https://jap.alekhin.io/views-dialog-boxes-tutorial-flame-flutter-part-3)
- [Scoring, Storage, and Sound Tutorial - Step by Step with Flame and Flutter (Part 4 of 5)](https://jap.alekhin.io/scoring-storage-sound-tutorial-flame-flutter-part-4)
- [Game Finishing and Packaging Tutorial - Step by Step with Flame and Flutter (Part 5 of 5)](https://jap.alekhin.io/game-finishing-packaging-tutorial-flame-flutter-part-5)

### Articles by [Fireslime](https://fireslime.xyz/)

- [Creating a virtual controller with Stack on Flame](https://fireslime.xyz/articles/20190902_Flame_Virtual_Controller_With_Stack.html)
- [Basic Camera usage on Flame](https://fireslime.xyz/articles/20190911_Basic_Camera_Usage_In_Flame.html)

### Other Articles & Tutorials

- [Killing gnats with Flutter and Flame](https://medium.com/flutter-community/killing-gnats-with-flutter-and-flame-77fa9224ccaa)  - 使用广告和国际化构建您的第一款游戏. 经过 [Bo Hellgren](https://medium.com/@bo.hellgren)
- [Flutter Web and Flame](https://github.com/AseemWangoo/experiments_with_web)  - 动手使用 Flame for web. 经过 [Aseem Wangoo](https://flatteredwithflutter.com/how-to-create-game-in-flutter-web-using-flame/)

## Plugins & Libraries

### Official

- [flame_gamepad](https://github.com/flame-engine/flame_gamepad)  - Flutter 游戏手柄支持. 经过 [Flame Team](https://github.com/flame-engine)
- [flame_geom](https://github.com/flame-engine/flame_geom)  - 使用用于处理形状和几何操作的 API 补充 Flame. 经过 [Flame Team](https://github.com/flame-engine)
- [flame_scrolling_sprite](https://github.com/flame-engine/flame_scrolling_sprite)  - 易于使用的精灵在一个区域重复出现. 经过 [Flame Team](https://github.com/flame-engine)
- [flame_splash_screen](https://github.com/flame-engine/flame_splash_screen)  - 可定制的火焰启动画面. 经过 [Flame Team](https://github.com/flame-engine)
- [play_games](https://github.com/flame-engine/play_games)  - 一个基于 Google Play 游戏服务 (GPGS) 的简单包装器，包括身份验证、成就等. 经过 [Flame Team](https://github.com/flame-engine)

### Community

- [bonfire](https://github.com/RafaelBarbosatec/bonfire)  - 角色扮演游戏制造商. 经过 [rafaelbarbosatec](https://github.com/RafaelBarbosatec)
- [flame_texturepacker](https://github.com/Brixto/flame_texturepacker)  - 从 TexturePacker 导入 spritesheet. 经过 [Brixto](https://github.com/Brixto/flame_texturepacker)

## Projects

### Open Source

#### Casual

- [Bob Box](https://github.com/fireslime/bounce_box)  - 一个简单的休闲游戏，你可以用一根手指玩. 点击停止，避开障碍物！ 经过 [FireSlime](https://fireslime.xyz)
- [Snaake!](https://github.com/lucasnlm/snaake-flutter)  - 一款简单的休闲贪吃蛇游戏. 经过 [lucasnlm](https://github.com/lucasnlm)

#### Endless Runner

- [BGUG](https://github.com/fireslime/bgug)  - Break Guns Using Gems 是一款快节奏的横向卷轴平台游戏，具有创新的控制和与枪支相关的转折. 经过 [FireSlime](https://fireslime.xyz)

#### Platform

- [Flutters](https://github.com/impulse/flutters)  - Flappy Bird 和 Doodle Jump 的混合体. 经过 [impulse](https://github.com/impulse)

#### RPG

- [Darkness Dungeon](https://github.com/RafaelBarbosatec/darkness_dungeon)  - 简单的角色扮演游戏. 经过 [rafaelbarbosatec](http://rafaelbarbosatec.github.io/)

### App Releases

#### Metroidvania

- [Tales of a Lost Mine](https://fireslime.xyz/games/tales.html) - [Android](https://play.google.com/store/apps/details?id=xyz.fireslime.tales&pcampaignid=MKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1)  - 很棒的平台冒险类银河战士恶魔城. 扮演勇敢的探险家，揭开久违时光的秘密. 经过 [FireSlime](https://fireslime.xyz)

#### Tower Defense

- [Xtrike](http://www.xtrike.online/) - [Android](https://play.google.com/store/apps/details?id=online.xtrike.xtrike)  - 一款很棒的战略塔防游戏. 建立你的战斗单位并消灭敌人. 经过 [White Wood City](http://www.xtrike.online/)

#### Board

- 四连胜 - [Android](https://play.google.com/store/apps/details?id=com.ignacemaes.fourinarow), [iOS](https://apps.apple.com/us/app/four-in-a-row-classic/id1495540053)  - 玩经典的“四连胜”棋盘游戏！ 你会第一个连接你的 4 个芯片吗？ 挑战 AI，或与您的朋友和家人对战. 经过 [Ignace Maes](https://ignacemaes.com/)

#### Casual

- 保护 - [Android](https://play.google.com/store/apps/details?id=com.knoeyes.games.kinga), [iOS](https://apps.apple.com/us/app/kinga/id1506422810)  - 保护饼干免受讨厌的苍蝇的侵害. 经过 [Kevin Omyonga](https://kevinomyonga.com)

 - 恐龙快跑！  - [Android](https://play.google.com/store/apps/details?id=io.github.epsi95.dinorun) , - 你已经很熟悉这个游戏了，你可以在没有网络的情况下在 Chrome 中玩. 我只是给它加了一点颜色. 还可以大喊让可爱的小恐龙跳起来，是不是很酷. 经过 [Probhakar Sarkar](https://github.com/epsi95)

## Contributing

[Please read the contribution guidelines](https://github.com/flame-engine/awesome-flame/blob/master/CONTRIBUTING.md)
