<div class="github-widget" data-repo="transitive-bullshit/awesome-ffmpeg"></div>
## Awesome FFmpeg [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> [FFmpeg](http://ffmpeg.org) 是一个跨平台解决方案，用于记录、转换和流式传输音频和视频.

<p align="center">
  <img width="400" src="https://cdn.rawgit.com/transitive-bullshit/awesome-ffmpeg/master/ffmpeg-logo.svg">
</p>





## Docs

由于 FFmpeg 功能的范围和复杂性，FFmpeg 的官方文档对于初学者来说是出了名的难以理解. 话虽如此，它们作为参考仍然非常有用.

- [FFmpeg.org](http://ffmpeg.org) - 一切开始的地方.
- [Filters](https://ffmpeg.org/ffmpeg-filters.html)  - FFmpeg 强大的过滤器链（缩放、裁剪、连接、合并等）的文档. 这是我在使用 FFmpeg 时访问最多的链接之一.
- [Man page](https://man.cx/ffmpeg) - 官方 FFmpeg 手册页.
- [Wiki & Bug Tracker](https://trac.ffmpeg.org) - 这里有很多很棒的信息.
- [CLI flags](https://github.com/transitive-bullshit/ffmpeg-cli-flags/blob/master/readme.md)  - 所有 FFmpeg 命令行标志的综合列表. 对于搜索您在野外遇到的随机标志非常有用.


## JavaScript

- [fluent-ffmpeg](https://github.com/fluent-ffmpeg/node-fluent-ffmpeg) - 一个流畅的API [FFmpeg](http://www.ffmpeg.org) . 如果您只使用此列表中的一种工具，那么它应该是这个.
- [ffmpeg-probe](https://github.com/transitive-bullshit/ffmpeg-probe) - 包装 ffprobe 以获取有关媒体文件的信息.
- [ffmpeg-concat](https://github.com/transitive-bullshit/ffmpeg-concat) - 使用带有性感 OpenGL 转换的 FFmpeg 将视频列表连接在一起.
- [editly](https://github.com/mifi/editly) - 具有流畅动画和过渡效果的声明式视频编辑工具和库.
- [ffmpeg-generate-video-preview](https://github.com/transitive-bullshit/ffmpeg-generate-video-preview) - 从视频中生成有吸引力的图像条或 GIF 预览.
- [ffmpeg-extract-frame](https://github.com/transitive-bullshit/ffmpeg-extract-frame) - 从视频中提取单帧.
- [ffmpeg-extract-frames](https://github.com/transitive-bullshit/ffmpeg-extract-frames) - 使用 FFmpeg 从视频中提取屏幕截图.
- [gif-extract-frames](https://github.com/transitive-bullshit/gif-extract-frames) - 从 GIF 中提取帧，包括帧间合并.
- [ffmpeg-extract-audio](https://github.com/transitive-bullshit/ffmpeg-extract-audio) - 从媒体文件中提取音频流.
- [ffmpeg-on-progress](https://github.com/transitive-bullshit/ffmpeg-on-progress) - 使用 fluent-ffmpeg 可靠地报告进度的实用程序.
- [ffmpeg.js](https://github.com/Kagami/ffmpeg.js)  - 通过 Emscripten 将 FFmpeg 移植到 JavaScript. 允许在客户端使用有限的 FFmpeg.
- [ffmpeg-static](https://github.com/eugeneware/ffmpeg-static)  - 为 macOS、Linux 和 Windows 提供静态 FFmpeg 二进制文件. 对 CI 测试非常有用.
- [tangerine](https://github.com/niftylettuce/tangerine) - 使用 Node.js、FFmpeg、WebSockets 和 Lad 的网络摄像头流媒体服务.
- [ffparser](https://github.com/NiKlimenko/FFParser) - 将输入流按帧直接解析到您的代码中作为缓冲区.


## Native

- [ffmpeg-gl-transition](https://github.com/transitive-bullshit/ffmpeg-gl-transition) - 用于在视频流之间应用 GLSL 转换的 FFmpeg 过滤器（[gl-transitions](https://gl-transitions.com/)).


## Mobile

- [simplest ffmpeg mobile](https://github.com/leixiaohua1020/simplest_ffmpeg_mobile) - 适用于 Android 和 iOS 的 FFmpeg 示例.
- [ijkplayer](https://github.com/Bilibili/ijkplayer) - 基于 FFmpeg 的 Android / iOS 视频播放器.


## Tutorials

- [How to Write a Video Player in Less Than 1k Lines](http://dranger.com/ffmpeg)
- [Learn FFmpeg libav the Hard Way](https://github.com/leandromoreira/ffmpeg-libav-tutorial)
- [Applying OpenGL Shaders with FFmpeg](https://nervous.io/ffmpeg/opengl/2017/01/31/ffmpeg-opengl) - 和 [follow-up](https://nervous.io/ffmpeg/opengl/2017/05/15/ffmpeg-pbo-yuv).


## Community

- [Stack Overflow](https://superuser.com/questions/tagged/ffmpeg)
- [Mailing Lists](https://www.ffmpeg.org/contact.html#MailingLists)
- [IRC](https://www.ffmpeg.org/contact.html#IRCChannels)


## Contribute

欢迎投稿！ 请阅读 [contributing guideline](https://github.com/transitive-bullshit/awesome-ffmpeg/blob/master/contributing.md) 第一的.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

在法律允许的范围内， [Travis Fischer](https://github.com/transitive-bullshit) 已放弃该作品的所有版权和相关或邻接权.

通过<a href="https://twitter.com/transitive_bs">在 Twitter 上关注我</a>来支持我的 OSS 工作 <img src="https://storage.googleapis.com/saasify-assets/twitter-logo.svg" alt="twitter" height="24px" align="center"></a>
