<div class="github-widget" data-repo="kareniel/awesome-evm-security"></div>
## Awesome EVM Security [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[![Awesome EVM Security](https://raw.githubusercontent.com/kareniel/awesome-evm-security/master/awesome-evm-security.png)](https://github.com/kareniel/awesome-evm-security#readme)

[EVM](https://ethereum.org/en/developers/docs/evm/) 代表“以太坊虚拟机”.  EVM 为以太坊主网提供动力，也为第 2 层协议、侧链和 EVM 兼容链提供动力.

此列表是从信息安全管理角度对 EVM 生态系统的概述.



## Guides
- [CryptoSec.info](https://cryptosec.info/) - 帮助初学者了解如何保护资金免受黑客和诈骗者侵害的信息.
- [Simplified Roadmap for Blockchain Security](https://devansh.xyz/blockchain-security/2021/09/17/genesis-0x01.html) - 涵盖进入区块链安全领域所需了解的所有基本主题.
- [How to become a smart contract auditor](https://cmichel.io/how-to-become-a-smart-contract-auditor/) - 与审计和审计师有关的常见问题可以得到他们的第一份工作.

## Governance
- [A beginner's guide to DAOs](https://linda.mirror.xyz/Vh8K4leCGEO06_qSGx-vS5lvgUqhqkCz9ut81WwCP2o) - 对 DAO 是什么、它们为何有趣以及它们的一些用例进行了高层次的概述.
- [Deep DAO](https://deepdao.io/#/deepdao/dashboard) - 跨多个指标列出、排名和分析顶级 DAO.
- [SAFT Agreements](https://saftproject.com/) - 一种商业工具，用于在代币功能开发之前转让代币权利.
- [Voting Options in DAOs](https://medium.com/daostack/voting-options-in-daos-b86e5c69a3e3) - DAO 中的投票选项.
- [The Wyoming DAO bill](https://twitter.com/awrigh01/status/1369328856260354051) - 关于怀俄明州 DAO 的话题.
- [It Takes a Cryptonetwork](https://medium.com/primedao/it-takes-a-cryptonetwork-2ae9ab541c17) - Prime 的 DAO 与 DAO 关系战略.
- [DAOs, Democracy and Governance](https://merkle.com/papers/DAOdemocracyDraft.pdf) - Ralph Merkle 的一篇关于 DAO 的论文.

## Architecture
- [Shelling Out: The Origins of Money](https://nakamotoinstitute.org/shelling-out/) - 说明收藏品在降低社会交易成本方面的价值.
- [Foundations of Cryptoeconomic Systems](https://epub.wu.ac.at/7309/8/Foundations%20of%20Cryptoeconomic%20Systems.pdf) - 本文探讨了为什么这个词
“加密经济学”依赖于上下文，并提出了该术语的补充性微观、中观和宏观定义.
- [Towards a Practice of Token Engineering](https://blog.oceanprotocol.com/towards-a-practice-of-token-engineering-b02feeeff7ca) - 我们如何设计代币化生态系统、它们的激励机制以及我们如何分析或验证它们？
- [A Crash Course in Mechanism Design for Cryptoeconomic Applications](https://medium.com/blockchannel/a-crash-course-in-mechanism-design-for-cryptoeconomic-applications-a9f06ab6a976) - 介绍机制设计的基本概念，并体验它们在加密货币世界中的实用性.
- [WTF Is QF](https://wtfisqf.com/?grant=&grant=&grant=&grant=&match=1000) - 二次融资的简单解释.
- [Bonding Curves Explained](https://yos.io/2018/11/10/bonding-curves) - 什么是结合曲线及其潜在应用.

## Standards
- [DeFi Safety](https://www.defisafety.com/) - 最佳实践安全评分审查.
- [DASP Top 10 of 2018](https://dasp.co/) - 分散式应用程序安全项目前 10 大漏洞.
- [IVSCS](https://immunefi.com/severity-updated/) - Immunefi 漏洞严重性分类系统.
- [Smart Contract Security Verification Standard](https://securing.github.io/SCSVS/) - 一个由 14 部分组成的免费清单，旨在为开发人员、架构师、安全审查人员和供应商标准化智能合约的安全性.
- [Secureth guidelines](https://guidelines.secureth.org/) - 通过全面描述软件项目中的所有不同关注点和期望，帮助您制定自己的软件工程过程.
- [CryptoCurrency Security Standard (CCSS)](https://cryptoconsortium.github.io/CCSS/) - 对所有使用加密货币的信息系统的一组要求，包括交易所、网络应用程序和加密货币存储解决方案.
- [The Solcurity Standard](https://github.com/Rari-Capital/solcurity) - Solidity 智能合约的固定安全和代码质量标准.

## System Assets
- [Security Considerations in the Solidity documentation](https://docs.soliditylang.org/en/v0.8.6/security-considerations.html) - 列出一些陷阱和一般安全建议.
- [Ethereum 2.0 Specifications Security Audit Report](https://leastauthority.com/static/publications/LeastAuthority-Ethereum-2.0-Specifications-Audit-Report.pdf) - Least Authority 对 Eth2.0 规范的安全审计报告.
- [Getting Deep Into EVM](https://hackernoon.com/getting-deep-into-evm-how-ethereum-works-backstage-ac7efa1f0015) - 对 EVM 工作原理的终极、深入的解释.
- [Ethereum EVM illustrated](https://takenobu-hs.github.io/downloads/ethereum_evm_illustrated.pdf) - 探索一些心智模型和实现.
- [Ethereum Blockspace: Who Gets What and Why](https://www.aniccaresearch.tech/blog/ethereum-blockspace-who-gets-what-and-why) - 以太坊区块空间市场结构.
- [What Is Uniswap and How Does It Work?](https://academy.binance.com/en/articles/what-is-uniswap-and-how-does-it-work) - Uniswap 是什么，它是如何工作的，以及如何使用以太坊钱包简单地交换代币.
- [Scaling EVM (Ethereum Virtual Machine)](https://capitalgram.com/posts/scaling-evm/) - 基于 EVM 的区块链架构还能带我们走多远.
- [L2Beat](https://l2beat.com/) - 对新兴第二层 (L2) 技术的透明且可验证的见解.
- [The Non-Fungible Token Bible](https://opensea.io/blog/guides/non-fungible-tokens) - 您需要了解的有关 NFT 的一切.
- [KEVM](https://github.com/kframework/evm-semantics) - K 框架中 EVM 的正式模型.

## Threats
- [Blockchain Graveyard](https://magoo.github.io/Blockchain-Graveyard/) - 涉及区块链的所有大规模安全漏洞或盗窃的清单.
- [List of Bitcoin Heists](https://bitcointalk.org/index.php?topic=576337) - 研究先前与比特币相关的盗窃案.
- [Blockchain Threat Intelligence](https://www.blockthreat.io/) - 最新的区块链、DeFi 和加密货币威胁情报、漏洞、安全工具和事件.
- [Rekt News](https://rekt.news/) - 调查性新闻、创意评论和事件分析.
- [DeFiYield's REKT db](https://defiyield.app/rekt-database) - 加密黑客、漏洞利用、诈骗数据库.
- [CryptoScamDB](https://cryptoscamdb.org/scams) - 在开源数据库中跟踪加密货币诈骗.
- [Mudit Gupta's Twitter threads](https://mudit.blog/twitter-threads/) - Twitter 上的早期分析和教育内容.
- [Flash Boys 2.0 Paper](https://ieeexplore.ieee.org/document/9152675) - 在去中心化交易所、矿工可提取价值和共识不稳定性方面处于领先地位.
- [MEV-explore](https://explore.flashbots.net/) - 帮助社区理解和量化“黑森林活动”的意义及其对以太坊网络的影响.
- [Flashloan monitor](https://monitor.blocksecteam.com/) - 帮助您监控闪贷交易的仪表板.
- [Known Attacks](https://consensys.github.io/smart-contract-best-practices/known_attacks/) - 来自 Consensys 的您应该注意的已知攻击列表.
- [Solidity Security](https://blog.sigmaprime.io/solidity-security.html) - 已知攻击向量和常见反模式的综合列表.

## Vulnerabilities
- [SWC Registry](https://swcregistry.io/) - 智能合约弱点分类和测试用例.
- [246 Findings](https://blog.trailofbits.com/2019/08/08/246-findings-from-our-smart-contract-audits-an-executive-summary/) - 来自 Trail of Bits 智能合约审计的 246 个发现.
- [A Survey of Security Vulnerabilities in Ethereum Smart Contracts](https://arxiv.org/pdf/2105.06974.pdf) - 通过分析这些安全漏洞的过往利用案例场景，对8个针对区块链技术应用层面的漏洞进行了说明.
- [List of Security Vulnerabilities](https://github.com/runtimeverification/verified-smart-contracts/wiki/List-of-Security-Vulnerabilities) - 从各种来源编制的常见智能合约安全漏洞的综合列表.
- [List of Known Bugs](https://docs.soliditylang.org/en/v0.8.1/bugs.html) - Solidity 编译器中一些已知的安全相关错误的 JSON 格式列表.

## Controls
- [Simple Security Toolkit](https://github.com/nascentxyz/simple-security-toolkit) - Nascent 团队认为合适的意见建议，特别是对于开发和管理协议早期版本的团队.
- [Gnosis Safe](https://docs.gnosis-safe.io)  - 多重签名. 要求多个团队成员确认每笔交易才能执行，这有助于防止未经授权访问公司加密货币.
- [List of DeFi auditors](https://www.defisafety.com/auditors) - DeFiSafety 维护的 DeFi 审计员名单.
- [State of DeFi Audits](https://medium.com/conflux-network/the-overlooked-element-of-defi-adoption-e3b29829e3da) - 文章通过适当保护新的 DeFi 协议来审视审计空间及其在引导用户方面的重要性.
- [Building Secure Contracts](https://github.com/crytic/building-secure-contracts/) - 关于如何编写安全智能合约的 Trail of Bits 指南和最佳实践.
- [Solidity Patterns](https://fravoll.github.io/solidity-patterns/) - 智能合约编程语言 Solidity 的模式和最佳实践汇编.
- [Security Pattern for Ethereum and Solidity](https://docs.google.com/spreadsheets/d/1PF4QZudW6Z7EV4hqQfwPo3A43AVqPrsuzzzey5yRYcs/edit#gid=0) - 谷歌表格清单.
- [Solidity Best Practices for Smart Contract Security](https://consensys.net/blog/developers/solidity-best-practices-for-smart-contract-security/) - 来自 Consensys 的专业提示，以确保您的以太坊智能合约得到强化.
- [CERtified](https://cer.live/) - 按网络安全评级排名前 100 的交易所.
- [Smart Contract Security Registry](https://github.com/ethereum-lists/contracts) - 通过列出它们所属的项目，努力在给定链和地址的情况下识别已部署的合约实例.
- [Forta](https://docs.forta.network/) - 用于智能合约的基于社区的运行时安全网络.

## Ecosystem
- [People to follow on Twitter](https://twitter.com/i/lists/1453086258436128770) - Twitter 列表以概述 web3 生态系统和安全人员.
- [Videos to watch on YouTube](https://www.youtube.com/playlist?list=PLox242_JhiuEe64LzW1M8XpiQ2-N5bZsX) - web3 安全视频的 YouTube 播放列表.


## Footnotes

### See Also

其他很棒的清单：

- [Awesome BlockSec CTF](https://github.com/0xjeffsec/awesome-blocksec-ctf) - 区块链安全夺旗 (CTF) 比赛.
- [Awesome Buggy ERC20 Tokens](https://github.com/sec-bit/awesome-buggy-erc20-tokens) - 涉及代币的 ERC20 智能合约中的漏洞.
- [Awesome Cryptoeconomics](https://github.com/jpantunes/awesome-cryptoeconomics) - 加密经济学研究和学习材料.
- [Awesome Zero-Knowledge Proofs (ZKP)](https://github.com/matter-labs/awesome-zero-knowledge-proofs) - 与学习零知识证明 (ZKP) 相关的精选清单.
- [Officer CIA's Ultimate DeFi Research Base](https://github.com/OffcierCia/ultimate-defi-research-base) - Curated DeFI & Blockchain research papers and tools.
- [Awesome MEV resources](https://github.com/0xalpharush/awesome-MEV-resources)
