<div class="github-widget" data-repo="sfischer13/awesome-eta"></div>
<!--lint disable double-link-->

## Awesome Eta [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

&gt; 有用的资源 [Eta](https://eta-lang.org/) 编程语言

你可能还喜欢 [awesome-haskell](https://github.com/krispo/awesome-haskell).

*请阅读 [contribution guidelines](https://github.com/sfischer13/awesome-eta/blob/master/contributing.md) 在贡献之前.*


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Introduction

### Overview

- [Eta](https://eta-lang.org/) - 官方网站.
- [GitHub](https://github.com/typelead/eta) - GitHub 上的 Eta.
- [Philosophy](http://blog.ezyang.com/2018/09/hiw18-lets-go-mainstream-with-eta/) - 关于 Eta 开发背后哲学的采访.

### First Steps

- [Getting Started](https://eta-lang.org/docs/user-guides/eta-user-guide/introduction/what-is-eta) - 与 Eta 的第一步.
- [Prelude](https://github.com/eta-lang/eta-prelude) - 更容易开始的默认模块.

### Comparisons

- [Eta vs. Haskell](https://eta-lang.org/docs/faq#eta-not-haskell) - Eta 和 Haskell 之间的区别.
- [Eta vs. Frege](https://eta-lang.org/docs/faq#eta-vs-frege) - Eta 和 Frege 之间的差异.

### Compatibility

- [Etlas Packages](https://github.com/typelead/eta-hackage#supported-packages) - 与 Eta 一起使用的 Hackage 包.
- [Template Haskell](https://eta-lang.org/docs/faq#eta-repl-support) - 模板 Haskell 的状态.
- [GHC 8](https://eta-lang.org/docs/faq#is-eta-compatible-ghc8) - 与 GHC 8 的兼容性.

### Official Resources

- [Tutorials](https://eta-lang.org/docs/tutorials) - 和教程.
- [FAQ](https://eta-lang.org/docs/faq) - 经常问的问题.
- [Eta Cheatsheets](https://eta-lang.org/docs/cheatsheets) - 和参考.
- [Eta Blog: Java I](https://blog.eta-lang.org/https-medium-com-jyothsnasrinivas-the-best-of-both-the-worlds-eta-and-java-part-1-336d181de89d) - 在 Java 中使用 Eta，第一部分.
- [Eta Blog: Java II](https://blog.eta-lang.org/the-best-of-both-the-worlds-eta-and-java-part-2-d7cf27acdef7) - 在 Java 中使用 Eta，第二部分.
- [Eta Blog: Haskell](https://blog.eta-lang.org/eta-in-practice-working-with-haskell-packages-5dfa3dc0c98a) - 在 Eta 代码中使用 Haskell 包.
- [Eta Blog: Scala](https://blog.eta-lang.org/integrating-eta-into-your-scala-projects-a8d494a2c5b0) - 在 Scala 项目中使用 Eta 代码.
- [Docker Hub](https://hub.docker.com/r/typelead/eta/) - Eta 的 Docker 回购.

## Community

- [Google Group](https://groups.google.com/forum/#!forum/eta-discuss) - 埃塔谷歌集团.
- [Gitter](https://gitter.im/typelead/eta) - 网格通道.
- [IRC](https://kiwiirc.com/client/irc.freenode.net/#eta-lang) - IRC频道.

## Twitter

- [Eta](https://twitter.com/eta_lang) - 官方推特账号.
- [TypeLead](https://twitter.com/typelead) - Eta 背后的公司.
- [Rahul Muttineni](https://twitter.com/rahulmutt) - Eta 的创建者和 TypeLead 的首席技术官.

## Information

### Articles

- [InfoWorld](https://www.infoworld.com/article/3157373/java/new-jvm-language-stands-apart-from-scala-clojure.html) - 关于 Eta 的短文.
- [Jaxenter](https://jaxenter.com/eta-pirates-of-the-jvm-133518.html) - 函数式编程变得简单：Eta 来了.

### Blogs

- [Eta programming language](https://blog.eta-lang.org/) - 官方博客.
- [Eta on Android](https://brianmckenna.org/blog/eta_android) - 发布关于在 Android 上使用 Eta 的信息.

### Conferences

- [ICFP](http://www.icfpconference.org/) - 函数式编程国际会议.

### Courses

- [FP101x](https://www.edx.org/course/introduction-functional-programming-delftx-fp101x-0) - edX 上的函数式编程简介.

### Talks

- [Introduction to Eta](https://www.youtube.com/watch?v=hmDLNO7Gkxs) - Eta 的创建者介绍.
- [Introduction to Eta](https://brianmckenna.org/files/presentations/lambdajam-2017-eta.pdf) - 介绍语言及其起源.
- [Haskell for JVM](https://www.youtube.com/watch?v=P1dmHKJ2vak) - 在 LambdaConf 上谈论将语言移植到 JVM.
- [Using Eta](https://speakerdeck.com/filippovitale/using-eta-for-what-you-dont-like-writing-in-scala) - Eta 和 Scala 的比较.
- [Eta Fibers](https://rahulmutt.github.io/slides/fuconf17-eta-fibers/slides.html#1) - JVM 上的并发.
- [ICFP Videos](https://www.youtube.com/channel/UCwRL68qZFfub1Ep1EScfmBw) - 关于函数式编程的视频.
- [Functional Conf - 2016](https://www.youtube.com/watch?v=CscBSNF6qnE) - 将 Haskell 的强大功能引入 JVM.
- [Functional Conf - 2017](https://www.youtube.com/watch?v=ZuJg2cfmSmw) - Eta Fibers：在 JVM 上实现更好的并发性.

## Tools

- [IntelliJ Eta](https://github.com/typelead/intellij-eta) - IntelliJ 插件.
- [sbt](https://github.com/typelead/sbt-eta) - 用于将 Eta 集成到 Scala 中的插件.
- [gradle](https://github.com/typelead/gradle-eta) - Eta 项目的 Gradle 插件.

## Sample Applications

### Android

- [eta-android](https://github.com/puffnfresh/eta-android) - Android 上的 Eta 示例.
- [eta-android-2048](https://github.com/Jyothsnasrinivas/eta-android-2048) - 适用于 Android 的 2048 游戏.

### Web

- [eta-todo](https://github.com/Jyothsnasrinivas/eta-todo) - 用 Eta 编写的 Spock Web 应用程序示例.
- [eta-yesod-minimal](https://github.com/Jyothsnasrinivas/eta-yesod-minimal) - Eta 中的 Yesod 网络应用程序示例.

### Miscellaneous

- [eta-examples](https://github.com/typelead/eta-examples) - Eta代码的例子.
- [eta-2048](https://github.com/rahulmutt/eta-2048) - 用 Eta 编写的 2048 游戏.
