<div class="github-widget" data-repo="strift/awesome-esports"></div>
## Awesome Esports [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> A curated list of open-source projects related to esports.

[Esports](https://en.wikipedia.org/wiki/Esports) (also known as electronic sports or e-sports) is a form of competition using video games. It often takes the form of organized, multiplayer video game competitions, particularly between professional players, individually or as teams.

Unmaintained projects, now only relevant for educational purposes, are in the [Archive](https://github.com/strift/awesome-esports/blob/master/ARCHIVE.md).



## Libraries

> Programming libraries organized per use cases.

### APIs & Web Services

- [Blizzard.js](https://github.com/benweier/blizzard.js) - A Node.js library for interacting with the Blizzard Community Platform API.
- [Discord.js](https://github.com/discordjs/discord.js) - A Node.js library for interacting with the Discord API.
- [HLTV](https://github.com/gigobyte/HLTV) - A Node.js library for interacting with the HLTV API.
- [liquipediapy](https://github.com/c00kie17/liquipediapy) - A Python library for interacting with the Liquipedia API.
- [steam](https://github.com/ValvePython/steam/) - A Python library for interacting with various parts of Steam.
- [Steam Community](https://github.com/DoctorMcKay/node-steamcommunity) - A Node.js library for interacting with the Steam Community website.
- SteamID - A library for manipulating Steam IDs.
  - [Node.js](https://github.com/DoctorMcKay/node-steamid)
  - [PHP](https://github.com/DoctorMcKay/php-steamid)
- [SteamUser](https://github.com/DoctorMcKay/node-steam-user) - A Node.js library for interacting with the Steam network via the Steam client protocol.
- [Steam TOTP](https://github.com/DoctorMcKay/node-steam-totp) - A Node.js library for generating Steam-style 2FA codes.
- [valorant.js](https://github.com/liamcottle/valorant.js) - A Node.js library for interacting with the VALORANT APIs used in game.

### Authentication

- [Passport-Steam](https://github.com/liamcurry/passport-steam) - A Node.js passport authentication strategy for Steam.

### Data parsing and analysis

- [awpy](https://github.com/pnxenopoulos/awpy) - A Python library for parsing, analyzing, and visualizing CS:GO data.
- [Boxcars](https://github.com/nickbabcock/boxcars) - A Rust library for parsing Rocket League replays.
- [Cassiopeia](https://github.com/meraki-analytics/cassiopeia) - A Python framework for interacting with and analyzing data from the Riot Games League of Legends API.
- [Clarity](https://github.com/skadistats/clarity) - A Java library for parsing CS:GO and Dota 2 replays.
- [demoinfocs-golang](https://github.com/markus-wa/demoinfocs-golang) - A Go library for parsing and analyzing CS:GO demos (ie. replays.)
- [Rattletrap](https://github.com/tfausak/rattletrap) - A Haskell library for parsing and generating Rocket League replays.

### Team management

- [LoL in-house bot](https://github.com/mrtolkien/inhouse_bot) - A Discord bot handling role queue, matchmaking, and rankings for League of Legends in-house games.

### Tournaments management

- [brackets-manager.js](https://github.com/Drarig29/brackets-manager.js) - A JavaScript library to manage tournament brackets.
- [brackets-viewer.js](https://github.com/Drarig29/brackets-viewer.js) - A JavaScript library to display tournament brackets.

## Developer tools

> Tooling for developers.

- [Fortnite VSCode Theme](https://github.com/sdras/fortnite-vscode-theme) - A Visual Studio Code theme inspired by Fortnite.

## Unofficial documentation

> Community-maintained documentation of editor APIs.

- [BNETDocs](https://github.com/BNETDocs/bnetdocs-web) - A documentation and discussion website for Blizzard and Battle.net protocols.
- [Rift Explorer](https://github.com/Pupix/rift-explorer) - An automatically generated documentation of Riot Games LCU API.
- [valorant-api-docs](https://github.com/techchrism/valorant-api-docs) - An automatically generated documentation of Valorant internal API.

## Applications & Tools

> Applications and general-purpose tooling.

- [Esport Team Logos](https://github.com/lootmarket/esport-team-logos) - A database of Esports teams logos.

**Counter-Strike: Global Offensive**

- [Boltobserv](https://github.com/boltgolt/boltobserv) - An external Counter-Strike: Global Offensive radar for observers.

**Dota 2**

- [Open Dota](https://github.com/odota/core) - A website for Dota 2 esports stats.

**League of Legends**

- [Foldy Sheet](https://github.com/chhopsky/foldysheet) - A Python script to determine whether teams can make playoffs or not.
- [LeagueDirector](https://github.com/RiotGames/leaguedirector) - A desktop application for staging and recording videos from League of Legends replays.
- [LeagueStats](https://github.com/vkaelin/LeagueStats) - A website for League of Legends summoners' stats.

## Education

- [League of Legends Analytics](https://github.com/FloPrm/lol_analytics) - A collection of League of Legends data-related guides, libraries, and learning materials for Data Analysts.

## Contributing

Contributions welcome! Read the [contribution guidelines](https://github.com/strift/awesome-esports/blob/master/CONTRIBUTING.md) first.
