<div class="github-widget" data-repo="angrykoala/awesome-esolangs"></div>
## Awesome Esolangs [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

<img src="https://raw.githubusercontent.com/angrykoala/awesome-esolangs/master/logo_piet.png" align="right">

Curated list of awesome esoteric programming languages, resources and related projects.


> "An esoteric programming language, or esolang, is a computer programming language designed to experiment with weird ideas, to be hard to program in, or as a joke, rather than for practical use."  
> ***esolang.org***




## Languages

* [><>](https://esolangs.org/wiki/fish) - A stack-based 2d language with support for reflection.
* [1+](https://esolangs.org/wiki/1%2B) - A surprisingly user-friendly language with a highly-limited instruction set.
* [78](https://github.com/oatmealine/78) - A single-character command language focused around the numbers 7 and 8.
* [ajsone](https://www.quaxio.com/ajsone) - Language defined completely in JSON.
* [AlmostBinary](https://github.com/wsdt/AlmostBinary) - Code in binary and run on any platform.
* [ArnoldC](http://lhartikk.github.io/ArnoldC) - Based on the best one-liners of Arnold Schwarzenegger.
* [Befunge](https://esolangs.org/wiki/Befunge) - Two-dimensional language.
* [Brackets](https://github.com/kvbc/brackets) - Language made of brackets, a lot of brackets.
* [Brainfuck](https://esolangs.org/wiki/Brainfuck) - Minimalist language using only 8 single-character commands.
* [C Flat](https://github.com/NicksterSand/Cflat) - Musical language focused on sound rather than notation with creative freedom in mind.
* [CellTail](https://github.com/mousetail/celltail) - A 1d celular automata based language, supports a complex pattern matching syntax.
* [Charcoal](https://github.com/somebody1234/Charcoal) - Concise language for sketching ASCII art.
* [Chef](http://www.dangermouse.net/esoteric/chef.html) - Programs that look like cooking recipes.
* [Chicken](https://esolangs.org/wiki/Chicken) - Only 1 valid symbol: 'chicken'.
* [ChuckScript](https://github.com/angrykoala/chuckscript) - Unary-based language, where the code is a single number.
* [COW](https://esolangs.org/wiki/COW) - Brainfuck variant using twelve variations of *moos* as instructions.
* [DNA#](https://esolangs.org/wiki/DNA-Sharp) - Language based on the structure of the DNA.
* [Dots](https://github.com/josconno/dots) - A turing-complete language using "." symbol only.
* [Electra](https://github.com/DolphyWind/Electra-Lang) - Code like an electrician.
* [Emojicode](http://www.emojicode.org) - Full-blown programming language consisting of emojis.
* [Enterprise™](https://github.com/joaomilho/Enterprise) - Non deterministic unnecessarily statically typed language.
* [False](http://strlen.com/false-language) - Heavily obfuscated language with a minimal implementation.
* [Fetlang](https://github.com/Property404/fetlang) - Designed such that source code looks like poorly written fetish erotica.
* [FlipJump](https://github.com/tomhea/flip-jump) - 1 instruction: Flip a bit, then Jump. The simplest OISC.
* [Folders](https://github.com/rottytooth/Folders) - Code written with folders.
* [Fugue](https://esolangs.org/wiki/Fugue) - Music as source code.
* [Golfscript](http://www.golfscript.com/golfscript) - Stack oriented, aimed at solving problems in as few keystrokes as possible.
* [Haifu](http://www.dangermouse.net/esoteric/haifu.html) - Designed with the core values of Eastern philosophy in mind.
* [INTERCAL](http://www.catb.org/~esr/intercal) - Parody language intended to be completely different from other languages.
* [Japt](https://github.com/ETHproductions/japt) - Reduced JavaScript for golfing.
* [Jelly](https://github.com/DennisMitchell/jellylanguage) - Golfing language based on J.
* [JellyScript](https://github.com/nguyenphuminh/Jellyscript) - Brainfuck-based with delicious jelly.
* [JSFuck](https://github.com/aemkei/jsfuck) - Esoteric programming style based on the atomic parts of JavaScript.
* [Lazy K](https://tromp.github.io/cl/lazy-k.html) - Minimal, turing-complete pure functional language without extra features.
* [LolCode](http://lolcode.org) - Language with keywords based on the lolcat meme expressions.
* [Malbolge](https://esolangs.org/wiki/Malbolge) - Named after the 8th level of hell, is designed to be as difficult as possible to program.
* [Monicelli](https://github.com/esseks/monicelli) - Programming using Italian-like gibberish.
* [Ni](https://github.com/DeybisMelendez/ni) - Brainfuck-based with more helpful instructions.
* [Omgrofl](https://esolangs.org/wiki/Omgrofl) - Syntax resembling Internet slang.
* [Ook!](http://www.dangermouse.net/esoteric/ook.html) - Brainfuck-based language, where the commands are orangutan words.
* [Orca](https://hundredrabbits.itch.io/orca) - Livecoding environment to quickly create procedural audio sequencers.
* [Piet](http://www.dangermouse.net/esoteric/piet.html) -  Language in which programs look like abstract paintings using colors as code. Named after Piet Mondrian.
* [RASEL](https://github.com/Nakilon/rasel) - Fungeoid with no limits on program space, float precision, and with a bit of random access to stack.
* [reMorse](http://esolangs.org/wiki/reMorse) - Morse-styled language.
* [Rockstar](https://github.com/dylanbeattie/rockstar) - Designed for creating computer programs that are also song lyrics.
* [Shakespeare](http://shakespearelang.sourceforge.net) - Language where the code appear to be Shakespearean plays.
* [Spooky](https://spookylang.com) - The scariest programming language  :jack_o_lantern: :skull:.
* [Suzy](https://github.com/gvx/suzy) - 3D language inspired in Befunge.
* [Technologic](https://esolangs.org/wiki/Technologic) - Language in which programs look like the lyrics to the Daft Punk song Technologic.
* [Thue](https://github.com/jcolag/Thue) - *Matrioshka* language based on nondeterministic string rewriting of a semi-Thue grammar.
* [Tru](https://github.com/sungwoncho/tru) - A stack-based language with prefix-free brackets.
* [TrumpScript](https://github.com/samshadwell/TrumpScript) - Make Python great again.
* [Turtle](https://github.com/TypeMonkey/Turtle) - Uses long-term storage for memory use.
* [Unary](https://esolangs.org/wiki/Unary) - Brainfuck-based language where all the commands are 0.
* [Unlambda](http://www.madore.org/~david/programs/unlambda) - Obfuscated functional programming.
* [Velato](http://velato.net) - Language that uses MIDI files as source, programs are defined by the pitch and order of notes.
* [Vigil](https://github.com/munificent/vigil) - Only Vigil is truly vigilant about not allowing code that fails to pass programmatic specifications.
* [Watson](https://github.com/genkami/watson) - Stack-based Turing-incomplete configuration files.
* [文言 (Wenyan)](http://wenyan-lang.lingdong.works) - Closely follows the grammar and tone of classical Chinese literature.
* [Whenever](http://www.dangermouse.net/esoteric/whenever.html) - Language that does things whenever it wants.
* [Whitespace](http://web.archive.org/web/20150623025348/http://compsoc.dur.ac.uk/whitespace) - Use only white-characters (space, tabs and newlines).
* [WordLang](https://github.com/WilliamRagstad/WordLang) - A language based on meaning-like grammar that produces output.
* [Z](https://esolangs.org/wiki/Z) - Use only the letter z.
* [ZOMBIE](https://www.dangermouse.net/esoteric/zombie.html) - Inherently evil multithreaded language designed for Necromancers.

## Algorithms

* [πfs](https://github.com/philipl/pifs) - Pi-based storage system, store your data by searching a matching sequence in pi.
* [Stacksort](https://gkoberger.github.io/stacksort) - Sorts a list by searching answers in Stack Overflow and executing code snippets until is sorted.

## Others

* [asmbf](https://github.com/kspalaiologos/asmbf) - The only true brainfuck assembler toolkit.
* [CSS-only-chat](https://github.com/kkuchta/css-only-chat) - A truly monstrous async web chat using no JS whatsoever on the frontend.
* [FizzBuzzEnterpriseEdition](https://github.com/EnterpriseQualityCoding/FizzBuzzEnterpriseEdition) - Simple FizzBuzz game implemented under the most strict enterprise standards.
* [MalbolgeLisp](https://github.com/kspalaiologos/malbolge-lisp) - A Lisp interpreter in Malbolge Unshackled.
* [NoCode](https://github.com/kelseyhightower/nocode) - Secure and reliable applications. Write nothing; deploy nowhere.
* [Petrovich](http://www.dangermouse.net/esoteric/petrovich.html) - Operating System concept based on random actions and rewards/punishments.
* [vapor.js](https://github.com/madrobby/vapor.js) - The World's Smallest & Fastest JavaScript Library.

## Resources

* [DM's Esoteric Programming Languages](http://www.dangermouse.net/esoteric) - List of esoteric languages and algorithms written by dangermouse.
* [Esofiles](https://github.com/graue/esofiles) - The Esoteric Files Archive, an archive of implementations of esoteric programming languages and examples.
* [Esolang](https://esolangs.org) - Wiki of esoteric programming languages and related Resources.
* [Esoteric Codes](https://esoteric.codes) - Articles and documents collection.
* [Rosettacode](http://rosettacode.org/wiki/Rosetta_Code) - Provides examples in different languages, including esoteric languages.
* [Wikipedia/Esoteric programming languages](https://en.wikipedia.org/wiki/Esoteric_programming_language) - Wikipedia list of esoteric languages.
* [Esolang List of ideas](https://esolangs.org/wiki/List_of_ideas) - Compilation of ideas for esoteric languages and related.

## Articles

* [Let's Build a Basic Interpreter (Ruslan's Blog)](https://ruslanspivak.com/lsbasi-part1) - Series of articles explaining the basics of compilers and interpreters and how to build one.
* [Six programming paradigms that will change how you think about coding](http://www.ybrikman.com/writing/2014/04/09/six-programming-paradigms-that-will) - Post by Yevgeniy Brikman describing different programming paradigms that are not commonly applied.
* [The Fun (and Madness) of Esoteric Programming Languages](https://tomassetti.me/discovering-arcane-world-esoteric-programming-languages) - Straightforward introduction to esoteric languages with examples.
* [On the Turing Completeness Of MS PowerPoint](http://www.andrew.cmu.edu/user/twildenh/PowerPointTM/Paper.pdf) - Turing Machine on PowerPoint.

## Community

* [Anarchy Golf](http://golf.shinh.org) - Informal [golfing](https://en.wikipedia.org/wiki/Code_golf) problems server.
* [Code Golf Stack Exchange](https://codegolf.stackexchange.com) - Golfing problems and answers.
* [Freenode IRC Channel](http://webchat.freenode.net/?channels=esoteric&uio=d4) - The #esoteric IRC channel on freenode.
* [Reddit Esolangs](https://www.reddit.com/r/esolangs) - Reddit community on esolangs.
* [Esolangs Discord Server](https://discord.gg/SdFJQmd4QJ) - A Discord community about esoteric languages.


> Logo used with permission of [David Morgan-Mar](http://www.dangermouse.net/esoteric/piet/samples.html)
