<div class="github-widget" data-repo="DanailMinchev/awesome-eosio"></div>
## Awesome EOSIO [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/DanailMinchev/awesome-eosio/master/eos-logo.png" alt="EOSIO" align="right" width="100">](https://eos.io/)

&gt; 为用户和开发人员精选的 **EOSIO** 资源列表.

<p>
  EOSIO 是去中心化应用程序和开源智能合约平台最强大的基础设施.
  EOSIO 软件使企业能够快速构建和部署高性能和高安全性的基于区块链的应用程序.
</p>

<p>欢迎投稿. 通过拉取请求添加链接或创建问题以开始讨论. 请先阅读<a href="https://github.com/DanailMinchev/awesome-eosio/blob/main/contributing.md">贡献指南</a>.</p>



## Official

官方资源.

- [EOS Community](https://eoscommunity.org/)
- [EOS Network Foundation](https://www.eosn.foundation/)
- [GitHub](https://github.com/EOSIO)
- [Technical White Paper](https://github.com/EOSIO/Documentation)
- [Bug Bounty Program](https://hackerone.com/eosio)
- [Blog](https://medium.com/eosio)
- [StackExchange for Q&A](https://eosio.stackexchange.com/)
- [YouTube](https://www.youtube.com/c/eosio)
- [Block.one](https://block.one/)

## EdenOS

EdenOS 资源.

- [Website](http://edeneos.org/) - 官方网站.
- [eoscommunity](https://github.com/eoscommunity) - 官方 GitHub.
- [More Equal Animals Book](https://moreequalanimals.com/posts/book-launch) - 丹尼尔·拉里默 (Daniel Larimer) 的书.

## Mandel

曼德尔资源.

- [eosnetworkfoundation/mandel](https://github.com/eosnetworkfoundation/mandel) - 官方 GitHub.
- [gofractally](https://github.com/gofractally) - 带有新 Mandel 资源和工具的 Eden 团队存储库.

## Learn

EOSIO 学习资源.

### Websites

- [EOSIO Developer Portal](https://developers.eos.io/) - 开始您的 EOSIO 区块链之旅的好地方.
- [EOS Smart Contract Development Security Best Practices](https://github.com/slowmist/eos-smart-contract-security-best-practices/blob/master/README_EN.md)
- [EOS Learning Resources - EOS Costa Rica](https://guide.eoscostarica.io/)
- [ESC - EOS Study Center](https://eosvenezuela.io/esc.html)

### Books

- [Learn EOS Development](https://learneos.dev/) - EOS 区块链上 dapps 的最新、深入、完整的指南.

### Interactive learning, labs

- [Elemental Battles](https://battles.eos.io/)  - 构建区块链游戏. 学习 EOSIO.
  - [Announcing Elemental Battles: Block.one's New Tutorial for On-boarding Aspiring Blockchain Developers](https://medium.com/eosio/announcing-elemental-battles-block-ones-3215a8e2cdee)
- [Block.one: Getting Started with the EOSIO Blockchain and Smart Contracts](https://google.qwiklabs.com/catalog_lab/3743) - 谷歌云培训实验室.

### Courses, workshops, webinars, videos and others

- [EOSIO Training & Certification](https://training.eos.io/) - 官方 EOSIO 培训和认证.
- [EOSIO Webinars](https://eos.io/event-category/webinar/) - 官方 EOSIO 网络研讨会.
- [EOSIO Resource Library](https://eos.io/resources/)  - 官方 EOSIO 资源. 帮助您使用 EOSIO 学习和成长的视频、案例研究和其他资源.
- [Learning Blockchain Development with EOS and C++](https://www.udemy.com/learning-blockchain-development-with-eos-and-cpp/) - Udemy 课程.
- [Starting with EOS Blockchain for Developers](https://www.udemy.com/starting-with-eos/) - Udemy 课程.
- [Learn EOS Blockchain Smart Contracts & DApps with C++, EOSJS](https://www.udemy.com/course/learn-eos-blockchain-smart-contracts-dapps-with-c-eosjs/) - Udemy 课程.
- [Building DApps on EOS: A Hands-On Workshop](https://objectcomputing.com/services/training/catalog/blockchain/building-dapps-with-eos-workshop) - 作坊.
- [EOSIO Blockchain Developer Workshop](https://medium.com/@theblockstalk/the-eosio-blockchain-developer-workshop-now-available-on-youtube-ddeba54f0d94) - YouTube 上的免费课程.
- [EOS Programming 101](https://academy.moralis.io/courses/eos-programming-101) - Ivan 的技术视频课程.
- [Introduction to EOSIO for Developers](https://academy.b9lab.com/courses/course-v1:B9lab+EOSIO-FREE+2018-09/about) - 免费的 B1 实验室视频课程.

## Tools

各种软件和工具.

### Wallets and Toolkits

#### Desktop

- [cleos](https://developers.eos.io/eosio-cleos/docs)
  - [EOSIO/eos](https://github.com/EOSIO/eos/tree/master/programs/cleos) - 官方 GitHub（EOSIO 的一部分）.
- [Anchor Wallet](https://greymass.com/en/anchor/)
  - [greymass/anchor](https://github.com/greymass/anchor) - 官方 GitHub.
- [Scatter](https://get-scatter.com/)
  - [GetScatter/ScatterDesktop](https://github.com/GetScatter/ScatterDesktop) - 官方 GitHub.
- [EOS Toolkit](https://eostoolkit.io/)
  - [eostoolkit/eostoolkit](https://github.com/eostoolkit/eostoolkit) - 官方 GitHub.
- [SimplEOS](https://eosrio.io/simpleos/)
  - [eosrio/simpleos](https://github.com/eosrio/simpleos) - 官方 GitHub.
- [EOS Authority Web Wallet](https://eosauthority.com/dashboard)
- [eoscanada/eosc](https://github.com/eoscanada/eosc)
- [Wax Cloud Wallet](https://all-access.wax.io/)

#### Mobile

- [OracleChain/PocketEOS-Android](https://github.com/OracleChain/PocketEOS-Android)
- [OracleChain/PocketEOS-IOS](https://github.com/OracleChain/PocketEOS-IOS)
- [Android client for EOS.IO](https://github.com/playerone-id/EosCommander)

### Account services

- [Get alerts for transactions on an account - EOS Authority](https://eosauthority.com/alerts)
- [EOS PowerUp](https://eospowerup.io/)

### Block explorers, Voting portals

- [EOS Network Monitor](http://eosnetworkmonitor.io/)  - “CryptoLions”的 EOSIO 网络监视器. 对开发者有用. 分散友好.
- [eosflare](https://eosflare.io/) - 流行的区块浏览器包括资源统计数据、最新的配置文件操作以及有关“最高名称出价”和“最高选民”的统计数据.
- [EOS Tracker](https://eostracker.io/) - 开源区块浏览器包括生产者信息和账户信息.
  - [EOSEssentials/EOSTracker](https://github.com/EOSEssentials/EOSTracker) - 官方 GitHub.
- [Bloks](https://bloks.io/)  - 快速区块浏览器，可用于投票. 包括有关块生产者和令牌的信息.
<!--lint disable awesome-spell-check-->
- [EOSX](https://www.eosx.io/)  - 区块浏览器. 支持各种侧链.
<!--lint enable awesome-spell-check-->
- [EOS Vote Proxy Research Portal](https://www.alohaeos.com/vote/proxy) - 投票代理浏览器.
- [EOS GO](https://www.eosgo.io/)
- [bdata.one](https://bdata.one/) - 关于多个 EOSIO 链的帐户和令牌的区块链数据.

### General

- [All Things EOS](http://allthingseos.com)
- [Tools from EOS Authority](https://eosauthority.com/tools)
- [EOSIO Tools and Info](https://www.alohaeos.com/tools)

## Block Producers

区块生产者相关的软件和资源.

- [GLASS](https://glass.cypherglass.com/) - EOSIO 区块生产者地图.
  - [cypherglassdotcom/glass](https://github.com/cypherglassdotcom/glass) - 官方 GitHub.
- [EOS Block Producer Research Portal](https://www.alohaeos.com/vote)

## Developers

关于 EOSIO 平台上的开发.

### Environment

- [EOS Studio](https://www.eosstudio.io/) - 用于 EOSIO 开发的图形 IDE
- [EOSIO Web IDE](https://github.com/EOSIO/eosio-web-ide) - Web IDE 为开发者提供了一个用于开发和测试目的的个人单节点 EOSIO 区块链，运行在 [Gitpod.io](https://www.gitpod.io/) 云 - 并可从您的网络浏览器访问.
- [Helm charts for EOSIO](https://github.com/EOSIO/eosio.helm) - EOSIO Nodeos Helm 图表.

### Testnets

- [The EOSIO Testnet](https://testnet.eos.io/)  - Block.one 的官方 EOSIO 测试网. 在功能齐全的 EOSIO 稳定版本上进行测试.
- [Jungle Testnet](https://jungletestnet.io/) - 自 EOSIO 诞生以来，Jungle TestNet 由许多开发团队和 EOS 区块生产者发起并作为沙箱服务.
- [CryptoKylin Testnet](https://www.cryptokylin.io/) - CryptoKylin Testnet 是由一组 EOS 主网区块生产者维护的对开发人员友好的测试网.
- [Wax Testnet](https://wax-testnet.eosio.online/) - Wax 的官方测试网. 
  - [Account Creation and Faucet](https://waxsweden.org/testnet/) - 完善瑞典的测试网页面.

### Libraries and Frameworks

#### Core

- [EOSIO/eos](https://github.com/EOSIO/eos) - 官方 EOSIO GitHub 存储库.
- [EOSIO/eos-vm](https://github.com/EOSIO/eos-vm) - 低延迟、高性能和可扩展的 WebAssembly 后端库.

#### API libraries

- [EOSIO/eosjs](https://github.com/EOSIO/eosjs) - 官方 JavaScript SDK.
- [EOSIO/eosio-java](https://github.com/EOSIO/eosio-java) - 官方 Java SDK.
  - [eosiojava API](https://eosio.github.io/eosio-java/) - API 文档.
  - [EOSIO™ Software Release: Native SDKs for Swift and Java](https://eos.io/news/eosio-software-release-native-sdks-for-swift-and-java/) - 文章.
- [EOSIO/eosio-swift](https://github.com/EOSIO/eosio-swift) - 官方 Swift SDK.
  - [EOSIO SDK for Swift](https://eosio.github.io/eosio-swift/) - API 文档.
- [EOS.IO Go API library](https://github.com/eoscanada/eos-go) - 去图书馆.
- [EOS Java API Wrapper](https://github.com/EOSEssentials/eos-java-rpc-wrapper) - Java 库.
- [memtrip/eosreach-android](https://github.com/memtrip/eosreach-android) - 科特林/安卓库.
- [eosnet](https://github.com/SNIKO/eosnet) - .NET 库.
- [EOSRPC API Wrapper for Elixir](https://github.com/cambiatus/eosrpc-elixir-wrapper) - 长生不老药图书馆.
- [React Native EOS](https://github.com/EvaCoop/react-native-eos) - 客户端到 eos 区块链通信的本机实现.
- [Transit API for EOS](https://www.eostransit.com/) - 通过基于 EOSIO 的区块链的开源、模块化和简单标准连接签名提供者和 dApp.
  - [eosnewyork/eos-transit](https://github.com/eosnewyork/eos-transit) - 官方 GitHub.
  - [The Transit API: Connecting dApps & Signature Providers](https://medium.com/eos-new-york/the-transit-api-connecting-dapps-signature-providers-5d816c056f7f) - 文章.
- [greymass/eosio](https://github.com/greymass/eosio-core/) - Strongly typed JavaScript library.
- [greymass/swift-eosio](https://github.com/greymass/swift-eosio) - 支持 ESR 的 Swift SDK.
- [SwiftyEOS](https://github.com/ProChain/SwiftyEOS) - 与 EOS 交互的框架，用 Swift 编写.

#### Authentication and Wallet Signing libraries

- [EOSIO/universal-authenticator-library](https://github.com/EOSIO/universal-authenticator-library) - 一个允许应用程序轻松使用不同身份验证提供程序的库.
  - [EOSIO Labs™ Release: The Universal Authenticator Library (UAL) — Increasing the Accessibility of Blockchain Applications](https://eos.io/news/eosio-labs-release-the-universal-authenticator-library-ual%e2%80%8a-%e2%80%8aincreasing-the-accessibility-of-blockchain-applications/) - 文章.
- [EOSIO/eosio-webauthn-example-app](https://github.com/EOSIO/eosio-webauthn-example-app) - 演示通过 WebAuthn 进行 EOSIO 签名的示例 Web 应用程序.
  - [EOSIO Labs™ Release: WebAuthn Example Web App for EOSIO YubiKey Support](https://eos.io/news/eosio-labs-release-webauthn-example-web-app-for-eosio-yubikey-support/) - 文章.
- [EOSIO/eosio-reference-chrome-extension-authenticator-app](https://github.com/EOSIO/eosio-reference-chrome-extension-authenticator-app) - Chrome 扩展参考应用程序演示用户如何使用各种 EOSIO 实验室工具签署交易.
  - [EOSIO Labs™ Release: iOS and Chrome Extension Authenticator Reference Applications](https://eos.io/news/eosio-labs-release-ios-and-chrome-extension-authenticator-reference-applications/) - 文章.
- [EOSIO/eosio-reference-ios-authenticator-app](https://github.com/EOSIO/eosio-reference-ios-authenticator-app) - iOS 参考应用程序演示 EOSIO 区块链应用程序的应用程序间交易签名.
- [EOSIO/ual-scatter](https://github.com/EOSIO/ual-scatter) - Authenticator 旨在与 Scatter 和 Universal Authenticator Library 一起使用.
- [greymass/ual-anchor](https://github.com/greymass/ual-anchor) - Authenticator 旨在与 Anchor 和 Universal Authenticator Library 一起使用.
- [greymass/anchor-link](https://github.com/greymass/anchor-link) - 建立在 EOSIO 签名请求 (EEP-7) 之上的 EOSIO 链的持久、快速和安全的签名提供者.
- [greymass/eosio-signing-request](https://github.com/greymass/eosio-signing-request) - 协助创建和消化 EOSIO 签名请求 (ESR) 的库.
- [greymass/eosio-signing-request-java](https://github.com/greymass/eosio-signing-request-java) - EOSIO 签名请求协议的 Java 包装器.
- [eosdac/ual-wax](https://github.com/eosdac/ual-wax) - Wax 云钱包的 UAL 验证器.

#### History

[Intro blog by @cc32d9](https://cc32d9.medium.com/history-and-notifications-in-eosio-blockchain-8255194af93)

- [EOSIO/history-tools](https://github.com/EOSIO/history-tools) - 官方 EOSIO 历史 API 插件.
- [Hyperion History API](https://github.com/eosrio/Hyperion-History-API) - 用于基于 EOSIO 的区块链的可扩展的完整历史 API 解决方案.
- [EOSIO Light API](https://github.com/cc32d9/eosio_light_api) - 关于 EOSIO 区块链账户和代币余额的历史信息.

#### Testing
- [EOSIO/eosio.contracts](https://github.com/EOSIO/eosio.contracts/tree/master/tests) - 官方 C++ 系统合同测试套件（众所周知难以使用）.
- [tokenika/eosfactory](https://github.com/tokenika/eosfactory) - 基于 Python 的 EOSIO 智能合约开发和单元测试框架.
- [infeos](https://github.com/infiniteXLabs/infeos) - 基于 JavaScript 的框架，用于开发、构建、部署和单元测试 EOSIO dApp.
- [EOSLIME](https://github.com/LimeChain/eoslime) - 用于在 EOS 区块链上开发、部署和测试的类似松露的框架.
- [Hydra](https://docs.klevoya.com/hydra/about/getting-started/) - 用于测试 EOSIO 智能合约的 JavaScript 框架.
- [haderech/vert](https://github.com/haderech/vert)  - 用于基于 WASM 的区块链合约的 JavaScript EOS-VM 仿真运行时. 运行和测试智能合约.

#### Services
- [Demux](https://github.com/EOSIO/demux-js) - Demux 是一种后端基础架构模式，用于采购区块链事件以确定性地更新可查询数据存储并触发副作用.
- [Introducing Demux — Deterministic Databases Off-Chain Verified by the EOSIO Blockchain](https://medium.com/eosio/introducing-demux-deterministic-databases-off-chain-verified-by-the-eosio-blockchain-bd860c49b017) - 文章.
- [Liquid Apps](https://docs.liquidapps.io) - 智能合约服务 vRAM、oracles、cron、IPFS 和 ICB.
- [WAX Random Number Generator](https://developer.wax.io/es/tutorials/wax-rng)
- [DelphiOracle](https://github.com/eostitan/delphioracle) - 多方真实来源，旨在向其他智能合约或外部用户提供资产对的近实时价格.

### Developer Tools

- [EOSIO/eosio.cdt](https://github.com/EOSIO/eosio.cdt) - EOSIO.CDT（合约开发工具包）是一套用于构建 EOSIO 合约的工具.
- [Blanc](https://github.com/haderech/blanc)  - 用于构建基于 WebAssembly 的区块链合约的工具链. 目前，Blanc 支持 EOSIO 和 CosmWasm（实验性）.
- [EOSIO/ricardian-template-toolkit](https://github.com/EOSIO/ricardian-template-toolkit) - Ricardian 合约规范的渲染器.
- [EOSIO Ethereum Virtual Machine (EVM)](https://github.com/jafri/eosio.evm) - EOSIO 上的以太坊虚拟机.
- [Elliptic curve cryptography functions (ECC)](https://github.com/EOSIO/eosjs-ecc) - 私钥、公钥、签名、AES、加密/解密.
  - [Securely Generating an EOS Key Pair Using Official EOS.IO Code](https://www.youtube.com/watch?v=G1GUpjc5hkw) - YouTube.
- [EOSEssentials/EOSDrops](https://github.com/EOSEssentials/EOSDrops) - EOSIO 区块链的空投工具.
- [Octopus](https://github.com/pventuzelo/octopus) - WebAssembly 和区块链智能合约 (BTC/ETH/NEO/EOS) 的安全分析工具.
- [greymass/eosio-resources](https://github.com/greymass/eosio-resources) - 协助网络资源计算的工具.
- [greymass/abi2core](https://github.com/greymass/abi2core) - 用于将 ABI 定义转换为 greymass/eosio 类型定义的命令行实用程序.
- [maxifom/eos-abigen](https://github.com/maxifom/eos-abigen) - 用于为 EOS 兼容合约生成类型安全客户端和表的 Typescript 和 Golang 代码生成器.
- [manh-vv/eosjs-name](https://github.com/manh-vv/eosjs-name) - 将 Eosio 名称转换为 uint64 并返回.
- [blockchain-etl/eos-etl](https://github.com/blockchain-etl/eos-etl) - 谷歌 BigQuery 公共数据集的连接器.

### Code examples

- [EOSIO/eosio.contracts](https://github.com/EOSIO/eosio.contracts) - 提供 EOSIO 区块链一些基本功能的智能合约.
- [Eosfinex Custody Smart Contract](https://github.com/bitfinexcom/eosfinex-custody-contract) - Eosfinex 交易所智能合约.
  - [Bitfinex blog post about eosfinex](https://www.bitfinex.com/posts/616) - 文章.
- [EOSIO/eosio-java-android-example-app](https://github.com/EOSIO/eosio-java-android-example-app) - 演示使用 EOSIO SDK for Java 与基于 EOSIO 的区块链集成的应用程序.
- [poorman.token](https://github.com/generEOS/poorman.token) - 具有燃烧和注册功能的 EOSIO 令牌（使令牌 RAM 便宜）.
- [EOSEssentials/Scatter-Demos](https://github.com/EOSEssentials/Scatter-Demos) - 一组使用 eosjs 和 Scatter 的集成演示.
- [ping-eos](https://github.com/eosasia/ping-eos) - 在 EOSIO / React.js 之间实现 ping.
- [ipfs-eos-demo](https://github.com/wpuricz/ipfs-eos-demo) - 演示将文本和图像保存到 ipfs 并将哈希存储在 EOSIO 区块链上.
- [eosnewyork/erp](https://github.com/eosnewyork/erp) - EOS 资源规划器.
- [greymass/anchor-link-demo](https://github.com/greymass/anchor-link-demo) - 集成 greymass/anchor-link 的示例 VueJS 应用程序.
- [greymass/anchor-link-demo-multipass](https://github.com/greymass/anchor-link-demo-multipass) - 集成 greymass/anchor-link 的示例 ReactJS 应用程序.
- [greymass/ual-anchor-demo](https://github.com/greymass/ual-anchor-demo) - 集成 greymass/ual-anchor 的示例 ReactJS 应用程序.
- [greymass/eosio-signing-request-demo](https://github.com/greymass/eosio-signing-request-demo) - 使用 greymass/eosio-signing-request 生成交易的示例.
- [theblockstalk/eosio-contracts](https://github.com/theblockstalk/eosio-contracts) - 示例智能合约、dapps 和系统合约模板.

### Block Producer tools

- [GoogleCloudPlatform/eos-block-producer](https://github.com/GoogleCloudPlatform/eos-block-producer) - 用于在谷歌云平台（GCP）上创建 EOS 区块生产者（BP）节点的 Terraform 模块.
- [Patroneos](https://github.com/EOSIO/patroneos) - EOSIO 节点的 RPC 检查点.
- [Cypherglass WINDSHIELD](https://github.com/cypherglassdotcom/windshield) - 用于监控内部区块生产者基础设施的仪表板工具.
- [pete001/eos-bp-failover](https://github.com/pete001/eos-bp-failover) - EOSIO 区块生产者故障转移脚本.
- [eosdetroit/bp-playbook](https://github.com/eosdetroit/bp-playbook) - 一组使管理 EOS.IO 节点更容易的剧本.
- [eoseoul/eos-ramcost](https://github.com/eoseoul/eos-ramcost) - 在引导的最后阶段调整 bancor 的令牌和连接器平衡的供应.
- [eosdetroit/nodesuite](https://github.com/eosdetroit/nodesuite) - Nodesuite 是一种通过使用 Ansible 剧本来简化 eosio 节点管理和配置的工具.

### Other in Developers

- [Community Developer Tools](https://developers.eos.io/welcome/latest/community-developer-tools/index) - 官方 EOSIO“社区开发者工具”页面.
- [cleos-auto-completion](https://github.com/hexlant/cleos-auto-completion) - EOSIO cleos 的命令自动完成.
- [EOS-Sync](https://github.com/EOSpace/eos-sync) - 将 EOSIO 区块链数据同步到 mongodb 数据库.
- [OracleChain/EOSBenchTool](https://github.com/OracleChain/EOSBenchTool) - 用于 EOS 性能测试的客户端工具.
- [breakstring/savemyeosram](https://github.com/breakstring/savemyeosram) - 在 EOS 上节省 RAM.
- [clsdk](https://github.com/gofractally/Eden/releases?q=clsdk&expanded=true) - EOSIO 智能合约 C++ 测试框架，包括使用 VS 代码执行 wasm 期间的合约内调试.

## Community

### Blogs

- [Daniel Larimer](https://moreequalanimals.com/) - EOSIO 创始人 Daniel Larimer 的博客.
- [cc32d9](https://medium.com/@cc32d9) - cc32d9 博客，EOSIO 开发者相关出版物.
- [cmichel](https://cmichel.io/categories/EOS) - Christoph Michel 博客，EOSIO 开发人员相关出版物.
- [Blockgenic](https://medium.com/@blockgenic)  - Blockgenic 博客，专注于企业采用区块链技术的公司. 学习资源.
- [Dallas Rushing](https://steemit.com/@dallasrushing) - Dallas Rushing 博客，EOSIO 用户相关内容.
- [Iang](https://steemit.com/@iang) - Iang、EOSIO 用户和开发者相关内容的博客.
- [EOS Canada](https://steemit.com/@eos-canada) - EOS 加拿大博客、用户相关内容和视频.
- [Cypherglass](https://steemit.com/@cypherglass)  - Cypherglass 博客、用户相关内容和视频. 消息.
- [EOS New York](https://medium.com/@eosnewyork) - EOS 纽约博客、用户和开发人员相关内容.
- [Jack Tanner](https://theblockstalk.medium.com) - Jack Tanner 博客、EOSIO 开发人员、教育和相关内容.
- [David Williamson](https://www.varilink.co.uk/) - David Williamson 博客，EOSIO 节点管理文章.

### YouTube Channels

- [EOS Nation](https://www.youtube.com/channel/UCXgAY9DyooykrubRXw3xK1g) - EOS Hot Sauce、ENF、技术和社区内容.
- [Helios](https://www.youtube.com/c/HeliosEOSIO) - 致力于发展 EOS、采访和聚光灯.
- [EOS Go](https://www.youtube.com/c/EOSGo)  - ESO Go 社区会议、播客、直播. 新闻和讨论.
- [Investing with a difference](https://www.youtube.com/channel/UC6SxkB3kM4uNs_yIU0Lqo_w) - EOSIO 生态系统概述、新闻和市场讨论.
- [nsjames](https://www.youtube.com/user/grandmoren1) - 散布相关内容.
- [Crypto Dunker](https://www.youtube.com/user/clamantfever)  - 加密 Dunker 频道.  EOSIO DApps 相关内容和新闻.
- [EOS Authority](https://www.youtube.com/channel/UCCBylil96ibgcBC1FDcMouw)  - EOS 权威. 有用的教程，开发人员相关.
- [Jackson Kelley](https://www.youtube.com/user/jackodwhacko) - 开发者相关内容.
- [CodingWithCrypto](https://www.youtube.com/user/magicmanxpress) - 开发者相关内容.
- [Filip Martinsson](https://www.youtube.com/channel/UCyZyNVYEN-54HPYkVVHnRTA) - 开发者相关内容.

### Forums

- [EOSCommunity.org Forums](https://forums.eoscommunity.org/)
- [EOS - Reddit](https://www.reddit.com/r/eos/)
- [EOSDev - Reddit](https://www.reddit.com/r/EOSDev/)
- [EOSIO Developers Telegram](https://t.me/joinchat/0uhWYfXVpPlkNTA1)
- [WAX developers Telegram](https://t.me/waxdevelopers)
- [Teloso developers Telegram](https://t.me/dappstelos)

## EOSIO Ecosystem

- [EOS infographic](https://twitter.com/EOS_Bees/status/1518996327664918531/photo/1) - EOS 生态系统信息图.
- [Public EOSIO chains and their telegram chats](https://github.com/eosio-ecosystem/chains)
- [EOSIO Ecosystem](https://github.com/eosio-ecosystem/eosio-ecosystem-resources) - EOSIO 多链生态信息.

## DApps

去中心化应用资源.

### DApp directories

- [EOSindex](https://eosindex.io/)
- [DappRadar](https://dappradar.com/eos-dapps)
- [State of the Dapps](https://www.stateofthedapps.com/platforms/eos)

### Leasing platforms

- [Chintai](https://chintai.io/)

### Games

- [King Of EOS](https://kingofeos.com/)
  - [MrToph/KingOfEos](https://github.com/MrToph/KingOfEos) - 官方 GitHub.
  - [Introducing King of EOS](https://cmichel.io/introducing-king-of-eos) - 文章.
  - [Learnings from building my first dapp on EOS blockchain](https://cmichel.io/releasing-my-first-eos-dapp) - 文章.
- [MonsterEOS](https://monstereos.io/)
  - [MonsterEOS/monstereos](https://github.com/MonsterEOS/monstereos) - 官方 GitHub.

### Other in DApps

- [EveripediaNetwork/Everipedia](https://github.com/EveripediaNetwork/Everipedia) - Everipedia 网络协议.
- [eosfilestore](https://github.com/grigio/eosfilestore) - EOSIO 区块链上不可变的、抗审查的、廉价的文件存储.
- [kesar/decentwitter](https://github.com/kesar/decentwitter) - EOS 上的去中心化 Twitter.
