<div class="github-widget" data-repo="ember-community-russia/awesome-ember"></div>
## Awesome Ember.js [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome)

<div align="center">
  <a href="https://emberjs.com"><img width="300" src="https://raw.githubusercontent.com/ember-community-russia/awesome-ember/master/media/ember-logo.svg?sanitize=true" alt="Ember.js"></a>
  <br>
</div>

<p align="center">A curated list of delightful Ember.js <a href="#packages">packages</a> and <a href="#resources">resources</a>.</p>

<br>
  
<p align="center">
  <a href="ember-myths.md">Ember.js Myths</a>&nbsp;&nbsp;&nbsp;
  <a href="ember-questions.md">Readers Questions</a>&nbsp;&nbsp;&nbsp;
  <a href="https://help-wanted.emberjs.com/core">Contribute to Ember.js</a>
</p>

<br>

<p align="center">
  <sub>Just type <a href="https://ember.cool"><code>ember.cool</code></a> OR <a href="https://ember-community-russia.github.io/awesome-ember/"><code>https://ember-community-russia.github.io/awesome-ember/</code></a> to go here.</sub>
</p>

---

[Ember.js](https://emberjs.com) is a JavaScript framework that greatly reduces the time, effort and resources needed
to build any web application. It is focused on making you, the developer, as productive as possible by doing all the common, repetitive, yet essential, tasks involved in most web development projects.

[Ember.js](https://emberjs.com) also provides access to the most advanced features of JavaScript, HTML and the Browser giving you everything you need to create your next killer web app.

---

*You might also like [awesome-javascript](https://github.com/sorrycc/awesome-javascript).*
*Please read the [contribution guidelines](https://github.com/ember-community-russia/awesome-ember/blob/master/contributing.md) before contributing.*

---

- Awesome Ember.js [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome)


## Packages
### AST

- [ember-ast-helpers](https://github.com/cibernox/ember-ast-helpers) - This library is a utility belt to make AST transforms and shield users as much as possible from the nuances of the AST, as it is still private API.
- [ember-template-recast](https://github.com/ember-template-lint/ember-template-recast) - Non-destructive template transformer.
- [jscodeshift](https://github.com/facebook/jscodeshift) - A JavaScript codemod toolkit.
- [dyfactor](https://github.com/dyfactor/dyfactor) - A platform for running codemods based on runtime information.

### a11y

- [ember-accessibility](https://github.com/coyote-labs/ember-accessibility) - Addon to help identify accessibility violations during development.
- [e-a11y-modal](https://github.com/MelSumner/e-a11y-modal) - A simple modal for accessible Ember.js applications.
- [ember-a11y-landmarks](https://github.com/ember-a11y/ember-a11y-landmarks) - Ember.js addon to help with landmark roles for better accessibility.
- [ember-a11y](https://github.com/ember-a11y/ember-a11y) - A collection of tools to build accessible Ember.js applications.
- [ember-component-focus](https://github.com/ember-a11y/ember-component-focus) - A mixin for adding methods to your Ember.js components that help you manage the currently focused element.
- [ember-gestures](https://github.com/html-next/ember-gestures) - Ember.js gestures provides an easy way to use gestures by making it simple to define and use HammerJS managers and recognizers throughout your app.
- [ember-steps](https://github.com/rwjblue/ember-steps) - Declarative create wizards, tabbed UIs, and more.
- [ember-page-title](https://github.com/tim-evans/ember-page-title) - Page title management for Ember.js Apps.
- [ember-self-focused](https://github.com/linkedin/self-focused/tree/master/packages/ember-self-focused) - Focus on route on transition.
- [ember-keyboard](https://github.com/patience-tema-baron/ember-keyboard) - An Ember.js addon for the painless support of keyboard events.
- [ember-a11y-testing](https://github.com/ember-a11y/ember-a11y-testing) - A suite of accessibility tests that can be run within the Ember.js testing framework.
- [a11y-announcer](https://github.com/ember-a11y/a11y-announcer) - An accessible ember route change announcer.
- [ember-a11y-refocus](https://github.com/MelSumner/ember-a11y-refocus) - Provides an unobtrusive navigation narration element for Ember applications.

### Adapters

- [ember-cli-markdown-resolver](https://github.com/willviles/ember-cli-markdown-resolver) - Ember CLI addon for resolving markdown files in custom folders and retrieving content via a service.
- [ember-cloud-firestore-adapter](https://github.com/rmmmp/ember-cloud-firestore-adapter) - Unofficial Ember Data Adapter and Serializer for Cloud Firestore.
- [ember-data-hal-9000](https://github.com/201-created/ember-data-hal-9000) - An ember-data compatible ember-cli addon that provides a HAL adapter (HATEOAS).
- [ember-django-adapter](https://github.com/dustinfarris/ember-django-adapter) - Ember CLI addon adapter for Django REST Framework.
- [ember-graphql-adapter](https://github.com/alphasights/ember-graphql-adapter) - GraphQL adapter for Ember Data.
- [ember-indexeddb](https://github.com/mydea/ember-indexeddb) - Utilities & adapter to work with IndexedDB in ember & ember-data.
- [ember-localforage-adapter](https://github.com/genkgo/ember-localforage-adapter) - Offline usage for Ember Data.
- [ember-local-storage](https://github.com/funkensturm/ember-local-storage) - The addon provides a storage for computed property that returns a proxy and persists the changes to localStorage or sessionStorage.
- [ember-pouch](https://github.com/pouchdb-community/ember-pouch) - PouchDB/CouchDB adapter for Ember Data.
- [ember-wordpress](https://github.com/oskarrough/ember-wordpress) - The bridge between Ember.js and WordPress.
- [emberfire](https://github.com/firebase/emberfire) - Official Ember Data adapter for Firebase.
- [ninjafire](https://github.com/lineupninja/ninjafire) - An ORM for Firebase written in Typescript.

### Animations

- [ember-animated](https://github.com/ember-animation/ember-animated) - [Web Animations with Ember js](https://www.youtube.com/watch?v=TSvnutA9PUE)
- [liquid-fire](https://github.com/ember-animation/liquid-fire) - Animations & transitions for ambitious Ember.js applications.

### Authentication

- [ember-cli-simple-auth-extensions](https://emberobserver.com/categories/ember-cli-simple-auth-extensions)
- [ember-simple-auth](https://github.com/simplabs/ember-simple-auth) - A library for implementing authentication/authorization in Ember.js applications.
- [tori](https://github.com/Vestorly/torii) - A set of clean abstractions for authentication in Ember.js.

### Automation

- [ember-cli-deploy](https://github.com/ember-cli-deploy/ember-cli-deploy) - A deployment pipeline for Ember CLI apps.
- [ember-cli-deploy-webhooks](https://github.com/simplabs/ember-cli-deploy-webhooks) - Ember CLI Deploy plugin for calling webhooks during deployments.
- [ember-cli-release](https://github.com/shipshapecode/ember-cli-release) - Ember CLI addon for versioned release management.
- [ember-cli-sri](https://github.com/jonathanKingston/ember-cli-sri) - This plugin is used to generate Subresource Integrity (SRI) hashes for ember applications.
- [ember-cli-dependency-lint](https://github.com/salsify/ember-cli-dependency-lint) - Lint your app's addon dependencies, making sure you only have one version of each.

### Benchmarking

- [ember-macro-benchmark](https://github.com/krisselden/ember-macro-benchmark) - Benchmark recording of an ember app with running with 2 versions of Ember.js.
- [ember-performance](https://github.com/eviltrout/ember-performance) - A suite of tests for Ember.js to help with performance.
- [emberperf](http://emberperf.eviltrout.com) - Ember.js Performance (Between versions).

### Blogging

- [empress-blog](https://github.com/empress/empress-blog) - Fully-functional, SEO friendly static site implementation of a blog system built on Ember.js.
- [ember-cli-blog](https://github.com/broerse/ember-cli-blog) - Tom Dale's blog example updated for the Ember CLI.
- [ember-tumblr](https://github.com/elwayman02/ember-tumblr) - Ember.js Addon for integrating a Tumblr blog.

### Babel

- [ember-cli-babel-plugin-helpers](https://github.com/dfreeman/ember-cli-babel-plugin-helpers) - Utilities for managing Babel plugins in Ember CLI apps and addons.

### Boilerplating

- [ember-boilerplate](https://github.com/mirego/ember-boilerplate) -  The stable base upon which we build our Ember.js projects at Mirego. 


### Broccoli

- [broccoli-concat-analyser](https://github.com/stefanpenner/broccoli-concat-analyser) - Assets profiling.
- [broccoli-debug](https://github.com/broccolijs/broccoli-debug) - Utility for build pipeline authors to allow trivial debugging of the Broccoli pipelines they author.
- [broccoli-stew](https://github.com/stefanpenner/broccoli-stew) - Provides commonly used convenience functions for developing broccoli based build pipelines.
- [broccolijs-tutorial](https://github.com/oligriffiths/broccolijs-tutorial) - Broccoli.js Tutorial repository.
- [broccoli-rollup](https://github.com/chadhietala/broccoli-rollup) - Broccoli Plugin For "Rollup".
- [broccoli-manifest](https://github.com/racido/broccoli-manifest) - HTML5 cache-manifest compilation for broccoli.
- [broccoli-glow](https://github.com/locks/broccoli-glow) - Dynamic component creation from single file, etc.

### Broccoli read

- [Debugging a Broccoli Tree](https://dockyard.com/blog/2015/02/02/debugging-a-broccoli-tree)
- [Debugging Broccoli and Ember-CLI](https://mfeckie.github.io/Debugging-Broccoli-And-Ember/)
- [Debugging Ember-cli Build Times](https://medium.com/@Dhaulagiri/debugging-ember-cli-build-times-38bd1b0f55f9)
- [Eat Your Greens - A Broccoli.js tutorial](http://www.oligriffiths.com/broccolijs/)
- [Ember.js Lazy Assets: Fingerprinting & loading static/dynamic assets on demand](https://codeburst.io/ember-js-lazy-assets-fingerprinting-loading-static-dynamic-assets-on-demand-f09cd7568155)
- [Thoughts on how to write faster broccoli plugins](https://gist.github.com/Gaurav0/c1eb3a00670eed28e57c2cf92d3f7668)

### Build tools

- [Broccoli](https://github.com/broccolijs/broccoli) - Fast, reliable asset pipeline, supporting constant-time rebuilds and compact build definitions.

### Charts

- [ember-charts](https://github.com/Addepar/ember-charts) - A charting library built with the Ember.js and d3.js frameworks. 
- [ember-sparkles](https://github.com/LocusEnergy/ember-sparkles) - Collection of composable D3 components built with ember-d3-helpers.
- [ember-highcharts](https://github.com/ahmadsoe/ember-highcharts) - A Highcharts, HighStock and HighMaps components for ember-cli.
- [ember-c3](https://github.com/Glavin001/ember-c3) - An addon library for C3, a D3-based reusable chart library and more compatible.

### CI/CD

- [ember-cli-server-variables](https://github.com/blimmer/ember-cli-server-variables) - An Ember CLI add-on to support adding variables to the generated index.html file's head tag.
- [ember-ci](https://github.com/mike-north/ember-ci) - Continuous integration goodies for ember.js apps.
- [CI with GitHub Actions for Ember Apps](https://crunchingnumbers.live/2020/03/17/ci-with-github-actions-for-ember-apps/) - Reducing CI runtimes with GitHub Actions
- [CI with GitHub Actions for Ember Apps: Part 2](https://crunchingnumbers.live/2020/08/31/ci-with-github-actions-for-ember-apps-part-2/) - Migrating to v2 actions, lowering runtime cost and continuously deployment

### Code Splitting

- [ember-engines](https://github.com/ember-engines/ember-engines) - This Ember.js addon implements the functionality described in the Ember.js Engines RFC. Engines allow multiple logical applications to be composed together into a single application from the user's perspective.
- [ember-lazy-mount](https://github.com/buschtoens/ember-lazy-mount) - Allow {{mount}} lazy loading route-less engines.
- [ember-cli-bundle-loader](https://github.com/MiguelMadero/ember-cli-bundle-loader) - Addon to allow for multiple bundles and do lazy loading.
- [ember-cli-lazy-load](https://github.com/duizendnegen/ember-cli-lazy-load) - Support lazily loading your Ember.js app via splitting it up into Bundles.

### Codestyle

- [ember-cli-template-lint](https://github.com/ember-template-lint/ember-cli-template-lint) - Ember CLI integration for `ember-template-lint`.
- [ember-cli-alex](https://github.com/yohanmishkin/ember-cli-alex) - Alex for Ember.js apps.
- [ember-prop-types](https://github.com/ciena-blueplanet/ember-prop-types) - Improved property management for Ember.js apps and addons.

### Command-line apps

- [ember-cli-create](https://github.com/gossi/ember-cli-create) - CLI wizard to create a new ember project.
- [@ember/optional-features](https://github.com/emberjs/ember-optional-features) - This addon allows you to easily enable/disable optional features in ember-source. To clarify what we mean by optional, these are features that will be opt-in/opt-out and optional for the foreseeable future, not features that will be enabled by default. It is intended for use with apps only not addons.
- [ember-cli-rename](https://github.com/trabus/ember-cli-rename) - Addon for ember-cli that provides an `ember rename` command.

### Command-line utilities

- [ember-cli-update](https://github.com/ember-cli/ember-cli-update) - Update Ember CLI Ember.js apps, addons and Glimmer.js apps.
- [ember-cli-deprecation-workflow](https://github.com/mixonic/ember-cli-deprecation-workflow) - An addon geared towards making Ember.js upgrades easier by allowing you to work through deprecations without massive console noise.

### Component addons

- [ember-diff-attrs](https://github.com/workmanw/ember-diff-attrs)
- [ember-compatibility-helpers](https://github.com/pzuraq/ember-compatibility-helpers) - Helpers that allow you to write backwards compatible Ember.js addons.

### Compression

- [ember-cli-deploy-brotli](https://github.com/mfeckie/ember-cli-deploy-brotli) - Ember.js deploy plugin to support brotli compression.



- [ember-admin](https://github.com/DockYard/ember-admin) - Automatically discover your models and interact with all model data in a simple CRUD interface.
- [https://authmaker.com/](https://authmaker.com/) -  Go from zero to fully functioning and live MVP in 3 days.

### Control flow

- Promises
	- [ember-computed-promise-monitor](https://github.com/NullVoxPopuli/ember-computed-promise-monitor) - Enable computed properties to be async-aware.
- Observables
	- [ember-rx](https://github.com/alexlafroscia/ember-rx) - RxJS 6 integration for Ember.js.
- Generators
	- [ember-concurrency](https://github.com/machty/ember-concurrency) - Ember.js Addon that enables you to write concise, worry-free, cancelable, restartable, asynchronous tasks.
  - [ember-master-tab](https://github.com/rhyek/ember-master-tab) - A library that provides a service which helps running a function on only one tab of an Ember application.

### CSS & etc

- [ember-cli-stylelint](https://github.com/billybonks/ember-cli-stylelint) - Adds styleint to your ember app, to lint all kinds of css.
- [ember-cli-autoprefixer](https://github.com/kimroen/ember-cli-autoprefixer) - Automatically run your styles through autoprefixer.
- [ember-cli-sass](https://github.com/aexmachina/ember-cli-sass) - Use node-sass to preprocess your ember-cli app's files, with support for sourceMaps and include paths.
- [ember-cli-sass-pods](https://github.com/justtal/ember-cli-sass-pods) - Enjoy styling your pods with the sass style file in the pod directory.
- [ember-component-css](https://github.com/ebryn/ember-component-css) - An Ember CLI addon which allows you to specify styles for individual components.
- [ember-cli-postcss](https://github.com/jeffjewiss/ember-cli-postcss) - A PostCSS integration for ember-cli.
- [ember-css-modules](https://github.com/salsify/ember-css-modules) - CSS Modules for ambitious applications.
- [ember-cli-tailwind](https://github.com/embermap/ember-cli-tailwind) - Tailwind is a utility-first CSS framework for rapidly building custom user interfaces.
- [ember-emotion](https://github.com/alexlafroscia/ember-emotion) - Use emotion styling in Ember.js.
- [css-blocks](https://github.com/linkedin/css-blocks) - High performance, maintainable stylesheets.
- [ember-cli-eyeglass](https://github.com/linkedin/eyeglass/tree/master/packages/ember-cli-eyeglass) - This Ember CLI Addon makes it trivial to compile your sass files with eyeglass support via node-sass.

### Fonts
- [ember-cli-webfont](https://github.com/vitch/ember-cli-webfont) - Easily generate webfonts from svg files as part of your ember-cli build process.

### State management

- [ember-buffered-proxy](https://github.com/yapplabs/ember-buffered-proxy)
- [ember-changeset](https://github.com/poteto/ember-changeset)
- [ember-cerebraljs](https://github.com/lifeart/ember-cerebraljs) - Enhanced state management for complex Ember.js apps using Cerebral.
- [ember-redux](http://www.ember-redux.com/) - Predictable state management for ember apps.
- [ember-state-services](https://github.com/stefanpenner/ember-state-services)
- [ember-time-machine](https://github.com/offirgolan/ember-time-machine)


### Styling kits

- [ember-cli-tailwind](https://github.com/embermap/ember-cli-tailwind) - Adds Tailwind CSS to your app or addon.

### Data Management

- [ember-apollo-client](https://github.com/bgentry/ember-apollo-client) - An ember-cli addon for Apollo Client and GraphQL.
- [ember-cli-sofa](https://github.com/ampatspell/ember-cli-sofa) - CouchDB persistence library for Ember.js.
- [ember-orbit](https://github.com/orbitjs/ember-orbit) - Ember.js data layer built with Orbit.js.
- [ember-data-storefront](https://github.com/embermap/ember-data-storefront) - A collection of APIs that address common data-loading issues.
- [ember-m3](https://github.com/hjdivad/ember-m3) - This addon provides an alternative model implementation to DS.Model.
- [ember-cli-zuglet](https://www.ember-cli-zuglet.com/) - Ember.js addon for effortless Firebase integration.

### Data manipulation & Computed

- [ember-awesome-macros](https://github.com/kellyselden/ember-awesome-macros) - A collection of Ember.js computed macros.
- [ember-cpm](https://github.com/cibernox/ember-cpm) - Computed property Macros for Ember.js.
- [ember-macaroni](https://github.com/poteto/ember-macaroni) - Keep your app code DRY and copypasta free with computed property macaronis (macros).

### Data validation

- [ember-cp-validations](https://github.com/offirgolan/ember-cp-validations) - Ember.js computed property based validations.
- [ember-changeset-validations](https://github.com/poteto/ember-changeset-validations/) - Validations for ember-changeset.
- [ember-model-validator](https://github.com/esbanarango/ember-model-validator) - Add validations to your Ember Data models on an explicit and easy way, without a bunch a validations files around or complicated structure.
- [ember-validated-form](https://github.com/adfinis-sygroup/ember-validated-form) - Easily create forms with client side validations.
- [ember-line-graph](https://astronomersiva.github.io/ember-line-graph/) - Zero-dependency ember-addon to draw line-charts.

### Database

- [ember-indexeddb](https://github.com/mydea/ember-indexeddb) - Utilities & adapter to work with IndexedDB in ember & ember-data.

### Date

- [ember-moment](https://github.com/stefanpenner/ember-moment) - Template helpers and computed property macros for moment.js and Ember.js.


### Debugging / Profiling

- [ember-debug-logger](https://github.com/salsify/ember-debug-logger) - Exposes the visionmedia/debug library for use in your Ember.js application.
- [ember-devtools](https://github.com/aexmachina/ember-devtools) - A collection of useful Ember.js debugging functions.
- [ember-chrome-devtools](https://github.com/dwickern/ember-chrome-devtools) - Chrome DevTools addon for Ember.js.
- [ember-cli-bundle-analyzer](https://github.com/kaliber5/ember-cli-bundle-analyzer) - An Ember CLI addon to analyze the size and contents of your app's bundled output, using an interactive zoomable treemap.
- [ember-perf-timeline](https://github.com/ember-best-practices/ember-perf-timeline) - Add performance information to Chrome's Timeline for Ember.js applications.
- [ember-cli-route-map](https://github.com/BBVAEngineering/ember-cli-route-map) - Command to generate a route map of your Ember.js application.
- [heimdalljs-visualizer](https://github.com/rwjblue/heimdalljs-visualizer) - Visualizer for heimdalljs data.
- [source-map-explorer](https://github.com/danvk/source-map-explorer) - Analyze and debug space usage through source maps.
- [ember-dead-code](https://github.com/buschtoens/ember-dead-code) - Detect dead code with confidence via real user monitoring.

### Decorators

- [Macro Decorators](https://pzuraq.github.io/macro-decorators/) - DRY your code by creating decorators that duplicated getter/setter's functionality

### Documentation

- [ember-cli-addon-docs](https://github.com/ember-learn/ember-cli-addon-docs) - Easy, beautiful docs for your Ember.js addon.
- [ember-cli-jsdoc](https://github.com/softlayer/ember-cli-jsdoc) - An Ember.js CLI addon to generate HTML documentation from JSDoc comments in the source code.
- [ember-freestyle](https://github.com/chrislopresto/ember-freestyle) - Ember-freestyle is an Ember.js addon that allows you to quickly create a component explorer for your Ember.js app.

### Ember-inspector roadmaps & overview

- [Ember Inspector Pairing](https://www.youtube.com/watch?v=rFNR_Fj1G84)
- [Ember Inspector Sync](https://www.youtube.com/watch?v=PvsfQrKxl_8)

### End-user customization
- [ember-asset-loader](https://github.com/ember-engines/ember-asset-loader) - Asset loading support for Ember.js applications.
- [ember-experiments](https://github.com/outdoorsy/ember-experiments) - Experimentation, A/B Split Testing addon for Ember.js.
- [ember-cli-hot-loader](https://github.com/toranb/ember-cli-hot-loader) - An early look at what hot reloading might be like in the ember ecosystem.
- [ember-ast-hot-load](https://github.com/lifeart/ember-ast-hot-load) - Universal hot-load addon.
- [ember-cli-build-notifications](https://github.com/pdud/ember-cli-build-notifications) - Notifications when ember-cli has a build error.
- [ember-feature-flags](https://github.com/kategengler/ember-feature-flags) - An ember-cli addon to provide feature flags.
- [ember-named-yields](https://github.com/knownasilya/ember-named-yields) - Named Yields for Ember.js Components.
- [ember-islands](https://github.com/mitchlloyd/ember-islands) - Render Ember.js components anywhere on a server-rendered page to create "Islands of Richness".
- [ember-wormhole](https://github.com/yapplabs/ember-wormhole) - Render a child view somewhere else in the DOM.
- [ember-stargate](https://github.com/kaliber5/ember-stargate) - A modern take on using so called "portals" to render things in a different place of the DOM tree than they are logically defined in the app.

### ES6

- [ember-concurrency-decorators](https://github.com/machty/ember-concurrency-decorators) -  Decorator syntax for declaring/configuring ember-concurrency tasks.
- [ember-decorators](https://github.com/ember-decorators/ember-decorators) - Useful decorators for Ember.js applications.
- [@ember-decorators/argument](https://github.com/ember-decorators/argument) - Decorators for Component and Object arguments in Ember.js.
- [sparkles-decorators](https://github.com/gossi/sparkles-decorators) - Decorators for Sparkles/Glimmer.js Components.

### External Components Integration

- [ember-glimmer-component](https://github.com/smfoote/ember-glimmer-component) - Glimmer.js-like components in Ember.js.
- [sparkles-component](https://github.com/rwjblue/sparkles-component) - Addon used to experiment with @glimmer.js/component style APIs in Ember.js apps via existing public APIs.
- [hooked-components](https://github.com/lifeart/hooked-components) - Custom components for Ember.js, inspired by React Hooks approach.
- [ember-functional-component](https://github.com/rwjblue/ember-functional-component) - Attempting to use "pure functions" as components.
- [ember-lifecycle-component](https://github.com/NullVoxPopuli/ember-lifecycle-component) - A component with additional lifecycles for times when you may need need a template.
- [ember-vue-components](https://github.com/lifeart/ember-vue-components) - Vue.JS component API for Ember.
- [@alexlafroscia/ember-cli-react](https://github.com/alexlafroscia/ember-cli-react) - Render React components in Ember.js.
- [@AltSchool/ember-cli-react](https://github.com/AltSchool/ember-cli-react) - Use React component hierarchies in your Ember.js app.

### Forms

- [ember-cli-crudities](https://ember-cli-crudities.readthedocs.io) - Form and editable list builder that works from json config which can be either statically or dynamically loaded.
- [ember-form-for](https://github.com/martndemus/ember-form-for) - This Ember.js addon will give you an easy way to build good forms.

### Functional programming

- [Bacon.js](http://baconjs.github.io) - Functional reactive programming.
- [Folktale](http://folktale.origamitower.com) - Suite of libraries for generic functional programming in JavaScript that allows you to write elegant, modular applications with fewer bugs, and more reuse.
- [immutable](https://github.com/facebook/immutable-js) - Immutable data collections.
- [Kefir.js](https://github.com/rpominov/kefir) - Reactive library with focus on high performance and low memory usage.
- [Lazy.js](https://github.com/dtao/lazy.js) - Utility library similar to lodash/Underscore but with lazy evaluation, which can translate to superior performance in many cases.
- [lodash](https://lodash.com) - Utility library delivering consistency, customization, performance, & extras. A better and faster Underscore.js.
- [mori](http://swannodette.github.io/mori/) - Library for using ClojureScript's persistent data structures and supporting API from the comfort of vanilla JavaScript.
- [Mout](http://moutjs.com) - Utility library with the biggest difference between other existing solutions is that you can choose to load only the modules/functions that you need, no extra overhead.
- [Ramda](http://ramdajs.com) - Utility library with a focus on flexible functional composition enabled by automatic currying and reversed argument order. Avoids mutating data.
- [RxJS](http://reactivex.io) - Functional reactive library for transforming, composing, and querying various kinds of data.
- [underscore-contrib](http://documentcloud.github.io/underscore-contrib/) - The brass buckles on Underscore's utility belt.

### HTTP

- [ember-ajax](https://github.com/ember-cli/ember-ajax) - Service for making AJAX requests in Ember.js 1.13+ applications.
- [ember-socket-guru](https://github.com/netguru/ember-socket-guru) - Addon for easy integration with Pusher.js, Action Cable, Socket.io and Phoenix Channels.

### Helpers

- [ember-event-helpers](https://github.com/buschtoens/ember-event-helpers) - Complimentary event template helpers to the `{{on}}` modifier.
- [ember-render-helpers](https://github.com/buschtoens/ember-render-helpers) - `@ember/render-modifiers` as template helpers.
- [ember-element-helper](https://github.com/tildeio/ember-element-helper) - Dynamic element helper for Glimmer templates.
- [ember-composable-helpers](https://github.com/DockYard/ember-composable-helpers) - Composable helpers for declarative templating in Ember.js.
- [ember-helpers](https://github.com/abcum/ember-helpers) - A collection of handlebars helpers for Ember.js.
- [ember-d3-helpers](https://github.com/LocusEnergy/ember-d3-helpers) - Collection of Ember.js helpers for building composable D3 charts.
- [ember-math-helpers](https://github.com/shipshapecode/ember-math-helpers) - Ember.js HTMLBars helpers for basic arithmetic.
- [ember-promise-helpers](https://github.com/fivetanley/ember-promise-helpers) - Promise-y sugar for your Ember.js templates.
- [ember-route-action-helper](https://github.com/DockYard/ember-route-action-helper) - Bubble closure actions in routes.
- [ember-root-url](https://github.com/ef4/ember-root-url) - A template helper to keep your URLs relative to the app's rootURL.
- [ember-store-helpers](https://github.com/ember-sapporo/ember-store-helpers) - This add-on provides helpers related to ember-data.
- [ember-truth-helpers](https://github.com/jmurphyau/ember-truth-helpers) - Ember.js HTMLBars Helpers for `{{if}}` & `{{unless}}`: not, and, or, eq & is-array.
- [ember-awesome-macros](https://github.com/kellyselden/ember-awesome-macros) - A collection of Ember.js computed macros.
- [ember-macro-helpers](https://github.com/kellyselden/ember-macro-helpers) - Ember.js macro helpers for making your own fancy macros!
- [ember-cli-string-helpers](https://github.com/romulomachado/ember-cli-string-helpers) - Set of the String helpers extracted from DockYard's ember-composable-helpers.

### Image

- [ember-svg-jar](https://github.com/ivanvotti/ember-svg-jar) - The best way to embed SVG images into your Ember.js application.

### Include external JS code

- [ember-auto-import](https://github.com/ef4/ember-auto-import) - Zero config import from npm packages.
- [ember-cli-cjs-transform](https://github.com/rwjblue/ember-cli-cjs-transform) - CommonJS imports.
- [ember-cli-es6-transform](https://github.com/sandydoo/ember-cli-es6-transform) - Import ES6 modules from npm, bower or anywhere else in your app.
- [ember-browserify](https://github.com/ef4/ember-browserify) - Addon for easily loading CommonJS packages from npm via browserify.

### Infinite Scroll

- [ember-infinity](https://github.com/ember-infinity/ember-infinity) - Simple, flexible Infinite Scroll for Ember CLI Apps.
- [vertical-collection](https://github.com/html-next/vertical-collection) - Infinite Scroll and Occlusion at > 60 FPS.
- [smoke-and-mirrors](https://github.com/html-next/smoke-and-mirrors) - Ambitious infinite-scroll and svelte rendering for ambitious applications.

### Internalization & Localization

- [ember-intl](https://github.com/ember-intl/ember-intl) - Translate complex messages string. Localized formatting for date/time, number, and relative time.
- [ember-intl-analyzer](https://github.com/simplabs/ember-intl-analyzer) - Find unused translations in your Ember.js projects.

### Inputs

- [ember-autoresize](https://github.com/tim-evans/ember-autoresize) - Autoresize for Ember.js Components.


### Job queues

- [ember-data-tasks](https://github.com/knownasilya/ember-data-tasks)
- [ember-concurrency](http://ember-concurrency.com)
- [ember-custom-actions](https://github.com/Exelord/ember-custom-actions) - Custom API actions for Ember.js applications.
- [ember-pipeline](https://github.com/poteto/ember-pipeline)
- [ember-lifeline](https://github.com/ember-lifeline/ember-lifeline) - An ember addon for managing the life cycle of asynchronous behavior in your objects.

### Logging

- [console.re](https://console.re/)
- [ember-debug-logger](https://emberobserver.com/addons/ember-debug-logger) - An Ember.js addon to expose the Visionmedia debug logger.
- [ember-logging-service](https://github.com/acquia/ember-logging-service/) - This addon provides a general and extensible logging service that can be used throughout your application.
- [raygun](https://raygun.com/)

### Mad science

- [ember-elm](https://github.com/nucleartide/ember-elm) - Write Elm in your Ember.js app.
- [javascript-algorithms](https://github.com/trekhleb/javascript-algorithms) - Algorithms and data structures implemented in JavaScript with explanations and links to further readings.

### Math

- [ember-katex](https://github.com/firecracker/ember-katex) - Render your LaTeX formulas using KaTeX.
- [ember-math-helpers](https://github.com/shipshapecode/ember-math-helpers) - Ember.js HTMLBars helpers for basic arithmetic.

### Metrics

- [ember-user-activity](https://github.com/elwayman02/ember-user-activity) - Ember.js Addon for tracking user activity & idling.
- [ember-metrics](https://github.com/poteto/ember-metrics) - Send data to multiple analytics services without re-implementing new API.

### Minifiers
- [ember-hbs-minifier](https://github.com/simplabs/ember-hbs-minifier) - Stripping whitespace out of your Handlebars templates.
- [ember-cli-template-trimmer](https://github.com/lifeart/ember-cli-template-trimmer) - This addon removes newlines on compile stage.

### Miscellaneous

- [diagonal routes](https://alexspeller.com/ember-diagonal/) - See what route structure, templates and route hooks are for a given ember route definition.
- [ember data model maker](https://github.com/andycrum/ember-data-model-maker/) - Ember Data Model Maker (EDMM).

### Mobile

- [corber](https://github.com/isleofcode/corber) - Tooling for cordova and crosswalk hybrid applications built with Ember.js.
- [glimmer-native](https://github.com/bakerac4/glimmer-native) - Have you ever wanted to use Ember.js/Glimmer.js to create a native mobile app? Well now you can!
- [ember-mobile-bar](https://github.com/nickschot/ember-mobile-bar) - Managed fixed (tool)bars with mobile app-like behaviour.
- [ember-mobile-core](https://github.com/nickschot/ember-mobile-core) - Provides a pan recognizer and some utils for the ember-mobile-* addons.
- [ember-mobile-menu](https://github.com/nickschot/ember-mobile-menu) - Draggable sidebar specifically tailored to mobile devices.
- [ember-mobile-pane](https://github.com/nickschot/ember-mobile-pane) - Mobile layout ember-mobile-pane.
- [ember-responsive](https://github.com/freshbooks/ember-responsive) - Easy responsive layouts with Ember.js.

### Modifiers
- [ember-css-vars](https://github.com/luxferresum/ember-css-vars) - A ember modifier to apply css variables. This gives a save way to expose data from JavaScript to css.
- [ember-on-modifier](https://github.com/buschtoens/ember-on-modifier) - An implementation of the `{{on}}` element modifier shown in the Modifiers RFC #353.
- [ember-ref-modifier](https://github.com/lifeart/ember-ref-modifier) - An implementation of the `{{ref}}` element modifier.
- [ember-render-modifiers](https://github.com/emberjs/ember-render-modifiers) - Implements did-insert / did-update / will-destroy modifiers for RFC #415.
- [ember-functional-modifiers](https://github.com/spencer516/ember-functional-modifiers) - Functional Modifiers for Ember.js.
- [ember-style-modifier](https://github.com/jelhan/ember-style-modifier) - This addon provides a {{style}} element modifier to set element's style. 
- [ember-simple-animate](https://github.com/abhilashlr/ember-simple-animate) - Simple ember animate addon for CSS based animations.

### Parcel

- [ember-parcel-example](https://github.com/rtablada/ember-parcel-example) - Ember.js + Parcel.js Example.
- [todomvc-demo](https://github.com/devongovett/todomvc-demo) - Glimmer.js + Parcel.js Example.

### Payments

- [ember-credit-card](https://github.com/esbanarango/ember-credit-card) - "make your credit card form dreamy in one line of code".

### Polyfills

- [ember-modifier-manager-polyfill](https://github.com/rwjblue/ember-modifier-manager-polyfill) - Polyfill element modifiers for Ember.js 2.12 through 3.7.
- [ember-angle-bracket-invocation-polyfill](https://github.com/rwjblue/ember-angle-bracket-invocation-polyfill) - This addon provides a polyfill for angle bracket invocation syntax as described in RFC 311.
- [ember-named-arguments-polyfill](https://github.com/rwjblue/ember-named-arguments-polyfill) - Polyfills support for named arguments for Ember.js 2.10 through 3.0.
- [ember-native-class-polyfill](https://github.com/pzuraq/ember-native-class-polyfill) - This addon provides a polyfill for the native class behavior that was proposed in Ember.js RFCs #240 and #337.
- [ember-router-service-polyfill](https://github.com/rwjblue/ember-router-service-polyfill) - This addon provides a best effort polyfill for the ember-routing-router-service feature added in Ember.js 2.15.
- [ember-fn-helper-polyfill](https://github.com/rwjblue/ember-fn-helper-polyfill) - This addon provides a polyfill for the {{fn}} helper as described in RFCs #470.
- [ember-named-blocks-polyfill](https://github.com/ember-polyfills/ember-named-blocks-polyfill) - This addon provides a polyfill for the Yieldable Named Blocks feature.

### PWA

- [ember-service-worker-asset-cache](https://github.com/DockYard/ember-service-worker-asset-cache)
- [ember-service-worker-cache-fallback](https://github.com/DockYard/ember-service-worker-cache-fallback)
- [ember-service-worker-cache-first](https://github.com/DockYard/ember-service-worker-cache-first)
- [ember-service-worker-index](https://github.com/DockYard/ember-service-worker-index)
- [ember-service-worker-prember](https://github.com/shipshapecode/ember-service-worker-prember)
- [ember-service-worker](https://github.com/DockYard/ember-service-worker) - A pluggable approach to Service Workers for Ember.js.
- [ember-web-app](https://github.com/san650/ember-web-app) - This Ember.js addon helps you configure and manage the manifest.json and meta tags needed to create progressive web applications.

### Query Params

- [ember-query-params-service](https://github.com/NullVoxPopuli/ember-query-params-service) - Do you have controllers that *only* parse query params?
- [ember-parachute](https://github.com/offirgolan/ember-parachute) - Improved Query Params for Ember.js.
- [ember-href-to](https://github.com/intercom/ember-href-to) - A lightweight alternative to {{link-to}}.

### Real-time

- [ember-cli-flash](https://github.com/poteto/ember-cli-flash) - Simple, highly configurable flash messages for ember-cli.

### Routing addons
- [ember-component-routes](https://github.com/wongpeiyi/ember-component-routes) - Render components directly from routes in Ember.js.
- [ember-redirect](https://github.com/thoov/ember-redirect) - This addon aims to be a simple and easy way to preform route based redirects with minimal effort.
- [ember-router-scroll](https://github.com/dollarshaveclub/ember-router-scroll) - Scroll to top with preserved browser history scroll position.

### Resolver customization
- [ember-cli-extended-resolver](https://www.npmjs.com/package/ember-cli-extended-resolver) - This addons allows to modify default files structure to be more feature-grouped.

### Security

- [ember-can](https://github.com/minutebase/ember-can) - Simple [authorisation addon](http://ember-can.com) for Ember.js apps.
- [ember-permissions](https://github.com/Bagaar/ember-permissions) - Permission management for Ember applications.

### Service Workers

- [ember-cli-workbox](https://github.com/BBVAEngineering/ember-cli-workbox/) - Offline caching as a progressive enhancement using service workers.
- [ember-service-worker](https://github.com/DockYard/ember-service-worker) - A pluggable approach to Service Workers for Ember.js.
- [ember-service-worker-index](https://github.com/DockYard/ember-service-worker-index) - An Ember.js Service Worker plugin that caches the index.html file.
- [ember-service-worker-asset-cache](https://github.com/DockYard/ember-service-worker-asset-cache) - An Ember.js Service Worker plugin that caches an Ember.js app's asset files.
- [ember-service-worker-cache-first](https://github.com/DockYard/ember-service-worker-cache-first) - A cache first Ember.js Service Worker plugin.
- [ember-service-worker-cache-fallback](https://github.com/DockYard/ember-service-worker-cache-fallback) - An Ember.js Service Worker plugin that resorts to a cached fallback version when the network request fails.
- [ember-service-worker-emberfire-messaging](https://github.com/Matt-Jensen/ember-service-worker-emberfire-messaging) - Firebase Cloud Messaging service worker support for Emberfire apps.
- [ember-service-worker-unregistration](https://github.com/GreatWizard/ember-service-worker-unregistration) - An Ember.js plugin that unregister service workers when ember-service-worker is disabled.
- [ember-service-worker-request-chaos](https://github.com/maxfierke/ember-service-worker-request-chaos) - Like Netflix's Chaos Monkey but for your Ember.js SPA's API requests.
- [ember-service-worker-project-entagled-registration](https://github.com/rwjblue/ember-service-worker-project-entagled-registration) - This addon is to be used along with ember-service-worker to ensure that the service worker being used is paired properly to the project.
- [ember-service-worker-cache-rendered](https://github.com/PrinceCornNM/ember-service-worker-cache-rendered) - Ember.js service worker plugin for storing rendered html in cache, really useful for fastboot.
- [ember-service-worker-update-notify](https://github.com/topaxi/ember-service-worker-update-notify) - Update notification for service workers.
- [ember-service-worker-enqueue](https://github.com/The-Don-Himself/ember-service-worker-enqueue) - An Ember.js Service Worker plugin that catches failed mutation requests e.g POST, PUT, DELETE and queues them for background processing.
- [ember-service-worker-prember](https://github.com/shipshapecode/ember-service-worker-prember) - An Ember.js Service Worker plugin that caches the index.html files for each prember route.

### SSR / Server Side Rendering

- [ember-fastboot](https://github.com/ember-fastboot/ember-cli-fastboot) - Server-side rendering for Ember.js apps.
- [glimmer-ssr-test](https://github.com/josemarluedke/glimmer-ssr-test) - Making a Glimmer.js app be rendered in the server.

### Static site generators & SEO

- [ember-meta](https://github.com/shipshapecode/ember-meta) - Setup meta for your Prember/Ember.js blog to support opengraph, microdata, Facebook, Twitter, Slack etc.
- [prember-rss-feed](https://github.com/shipshapecode/prember-rss-feed) - Ship RSS feeds for your Prember site.
- [prember](https://github.com/ef4/prember) - Prerender Ember.js apps with Fastboot at build time.

### Styling

- [ember-cli-sass](https://github.com/aexmachina/ember-cli-sass) - Use node-sass to preprocess your ember-cli app's files, with support for sourceMaps and include paths.

### Templating

- [ember-template-component-import](https://github.com/crashco/ember-template-component-import) - This addon allows you to use import-style syntax to create local bindings to a component within a template file.
- [ember-cli-jsx-templates](https://github.com/lifeart/ember-cli-jsx-templates) - TSX/JSX support for ember templates.
- [Emblem.js](https://github.com/machty/emblem.js/) - Ember.js-friendly, indented syntax alternative for Handlebars.js.

### Testing

- [ember-qunit-decorators](https://github.com/mike-north/ember-qunit-decorators) - Use ES6 or TypeScript decorators for QUnit tests in your Ember.js app.
- [ember-cli-addon-tests](https://github.com/tomdale/ember-cli-addon-tests) - Test helpers for testing Ember CLI addons inside the context of a real Ember.js app.
- [ember-cli-code-coverage](https://github.com/kategengler/ember-cli-code-coverage) - Code coverage for ember apps using Istanbul.
- [ember-cli-mirage](http://www.ember-cli-mirage.com/) - Build, test and demo your app using a [JSON API](http://jsonapi.org/)-compliant client-side server.
- [ember-cli-mocha](https://github.com/ember-cli/ember-cli-mocha) - Mocha and Chai tests for ember-cli applications.
- [ember-cli-page-object](https://github.com/san650/ember-cli-page-object) - This ember-cli addon eases the construction of page objects on your acceptance and integration tests.
- [ember-cli-yadda](https://github.com/albertjan/ember-cli-yadda) - Write cucumber specs for ember-cli applications.
- [ember-concurrency-test-waiter](https://github.com/bendemboski/ember-concurrency-test-waiter) - Easily enable test waiters for ember-concurrency tasks.
- [ember-exam](https://github.com/trentmwillis/ember-exam) - Run your tests with randomization, splitting, and parallelization for beautiful tests.
- [ember-percy](https://github.com/percy/ember-percy) - Ember.js addon for visual regression testing with Percy.
- [ember-qunit](https://github.com/emberjs/ember-qunit) - QUnit test helpers for Ember.js.
- [ember-test-friendly-error-handler](https://github.com/rwjblue/ember-test-friendly-error-handler) - Build testable error handlers that don't throw in production...
- [ember-test-selectors](https://github.com/simplabs/ember-test-selectors) - Enabling better element selectors in Ember.js tests.
- [ember-test-setup](https://github.com/kellyselden/ember-test-setup) - Testing shorthands to reduce duplication.
- [ember-window-mock](https://github.com/kaliber5/ember-window-mock) - Use window global as an Ember.js service that can be mocked in tests.
- [mirage-glue](https://github.com/izelnakri/mirage-glue) - This program reads your API endpoint and creates or appends response to relevant mirage fixture file(s).
- [ember-sinon](https://github.com/csantero/ember-sinon) - Ember CLI addon adding support for sinon.js.

### Text

- [ember-text-measurer](https://github.com/cibernox/ember-text-measurer) - Simple Ember.js Service to measure the width of a string in a performant way.


### Tree Shaking
- [ember-cli-tree-shaker](https://github.com/kellyselden/ember-cli-tree-shaker) - This is a testbed for the new tree-shaking and code splitting work from Kelly Selden and Alex Navasardyan.

### TypeScript

- [ember-cli-typescript](https://github.com/typed-ember/ember-cli-typescript) - Use TypeScript in your Ember.js apps!
- [ember-typings](https://github.com/typed-ember/ember-typings) - Typescript type definitions for ember.js.
- [ember-typescript-utils](https://github.com/happycollision/ember-typescript-utils) - Utility functions built around Typescript and Ember.js.


### UI libs

- [ember-bootstrap](http://www.ember-bootstrap.com/) - Provides a collection of native Ember.js components that mimic the original Bootstrap plugins and components in an ember friendly way.
- [Frontile](https://github.com/josemarluedke/frontile) - Frontile aims to provide the legos (components, helpers, modifiers, and styles) necessary for building consistent and powerful Ember.js apps.
- [ember-cli-uniq](https://github.com/uniplaces/ember-cli-uniq/) - Default components for Ember.js that implement the Uniplaces Design System.
- [ember-element-ui](https://github.com/aalasolutions/ember-element-ui) - Provides element-ui for ember.
- [ember-elements](https://github.com/dunkinbase/ember-elements) - [a UI toolkit in Ember](https://dunkinbase.github.io/ember-elements/)
- [ember-ghost-casper-template](https://github.com/stonecircle/ember-ghost-casper-template) - A static site version of the default personal blogging theme for Ghost.
- [ember-paper](https://github.com/miguelcobain/ember-paper) - The Ember.js approach to Material Design.
- [ember-radical](https://github.com/healthsparq/ember-radical) - Feather light, fully accessible DDAU component library for your Ember.js apps.
- [Nomad UI](https://github.com/hashicorp/nomad/tree/master/ui)
- [Semantic-UI-Ember](https://github.com/Semantic-Org/Semantic-UI-Ember) - This is the official Ember.js library for the Semantic-UI modules.
- [Flexi](https://github.com/html-next/flexi)

### UI components

- [ember-attacher](https://kybishop.github.io/ember-attacher/) - Tooltips & popovers made easy.
- [ember-burger-menu](https://github.com/offirgolan/ember-burger-menu) - An off-canvas sidebar component with a collection of animations and styles using CSS transitions.
- [ember-flatpickr](https://github.com/shipshapecode/ember-flatpickr) - An Ember.js addon that wraps the Flatpickr date picker.
- [ember-power-select](https://github.com/cibernox/ember-power-select) - The extensible select component built for ember.
- [ember-basic-dropdown](https://github.com/cibernox/ember-basic-dropdown) - The basic dropdown you ember app needs.
- [ember-drag-sort](https://github.com/kaliber5/ember-drag-sort) - A sortable list component with support for multiple and nested lists.
- [ember-perfect-scroll](https://github.com/imanhodjaev/ember-perfect-scroll) - Perfect scroll component as an Ember cli addon.

### UX

- [ember-onbeforeunload](https://github.com/jasonmit/ember-onbeforeunload) - Invoke logic when transitioning between routes or closing window.

### VR

- [ember-vr](https://github.com/ember-vr)

### VS Code addons

- [Ember Syntax](https://marketplace.visualstudio.com/items?itemName=dhedgecock.ember-syntax) - Syntax highlighting for Ember.js template files AND syntax highlighting for inline template definitions with tagged templates!
- [Glimmer Templates Syntax for VS Code](https://marketplace.visualstudio.com/items?itemName=lifeart.vscode-glimmer-syntax) - Glimmer syntax highlighting for Ember.js.
- [ember-language-server](https://github.com/emberwatch/ember-language-server) - Language Server Protocol implementation for Ember.js projects.
- [unstable-ember-language-server](https://marketplace.visualstudio.com/items?itemName=lifeart.vscode-ember-unstable) - Language Server Protocol implementation for Ember.js projects (Unstable, including experimental features).
- [vscode-ember-colorizer](https://github.com/ciena-blueplanet/vscode-ember-colorizer) - VSCode extension that colorizes/tokeninzes Ember.js .hbs, Controllers, and Routes files.
- [ember-module-snippets](https://github.com/candidmetrics/ember-module-snippets) - Snippets to make importing Ember.js modules a snap in VSCode.

### Atom addons	

- [Atom Ember Snippets](https://github.com/mattmcmanus/atom-ember-snippets)
 
### VIM

- [Unstable language server for neovim](https://gist.github.com/meirish/639e6def0f352f63fef662dce3ca2f98)

### Web Components

- [ember-cli-web-components](https://github.com/BBVAEngineering/ember-cli-web-components) - Use your Ember.js components in other framework as Web Components!	
- [shadow-dom](https://github.com/knownasilya/ember-shadow-dom) - Write templates for your components inside of a Shadow DOM root.

### Webpack

- [glimmer-compiler-webpack-plugin](https://github.com/tomdale/glimmer-compiler-webpack-plugin)

### Weird

- [ember-dynamic-render-template](https://github.com/miguelcobain/ember-dynamic-render-template) - Render DOM from a template string.

### Resources

- [Front-End Performance Checklist](https://github.com/thedaviddias/Front-End-Performance-Checklist)
- [Ember.js approval requirements](https://gist.github.com/PoslinskiNet/2d7a05944ca3c468440a0faea153062b)

### Articles

- [An Elementary Guide to Ember.js Build Performance](http://hangaroundtheweb.com/2018/02/an-elementary-guide-to-ember-build-performance/)
- [Ember.js 2019 Roadmap Posts](https://github.com/abhilashlr/emberjs2019-posts)
- [How to Actually Build Superior Web Apps for Free](https://medium.com/@devotox/zero-cost-web-apps-part-1-b2d6b46916f1)
- [Getting Started With Glimmer-Native](https://codingitwrong.com/2019/06/26/glimmer-native-tutorial.html)
- [The case for Embeddable Ember.js](https://dev.to/dustinsoftware/the-case-for-embeddable-ember-4120)
- [The State of the Ember.js Addon Ecosystem in 2019](https://0xadada.pub/2019/06/17/essential-ember-addons/)
- [Static Types in Ember.js?](https://dev.to/jamesbyrne/static-types-in-emberjs-26b7)
- [How does Ember Boot?](https://hackernoon.com/how-does-ember-boot-5e1f9e7a1117)
- [The Ember.js testing guide, I made for myself](https://medium.com/@sarbbottam/the-ember-js-testing-guide-i-made-for-myself-c9a073a0c718)
- [Using Lerna to manage multiple Ember.js apps](https://cenchat.com/blog/2019/05/25/using-lerna-to-manage-multiple-ember-apps.html)
- [How to translate your Ember.js application with ember-intl](https://www.codeandweb.com/babeledit/tutorials/how-to-translate-your-ember-app-with-ember-intl)
- [Using ember-animated to re-sort a list](https://devjournal.balinterdi.com/using-ember-animated-to-resort-a-list/)
- [Throttling Ember-Data with Ember-Concurrency](https://medium.com/@mudflye/throttling-ember-data-with-ember-concurrency-ff30d804a1b)
- [Animation and Predictable Data Loading in Ember.js](https://crunchingnumbers.live/2019/04/02/animation-and-predictable-data-loading-in-ember/)
- [Make your deprecated CSS stand out](https://ondrejsevcik.com/deprecate-css/)
- [Ember.js ❤Angle Brackets. A Migration Guide & Cheat Sheet](https://medium.com/@AveryBloom/ff309d6effdf)
- [Coming Soon in Ember Octane - Part 1: Native Classes](https://www.pzuraq.com/coming-soon-in-ember-octane-part-1-native-classes/)
- [Coming Soon in Ember Octane - Part 2: Angle Brackets Syntax & Named Arguments](https://www.pzuraq.com/coming-soon-in-ember-octane-part-2-angle-brackets-and-named-arguments/)
- [Coming Soon in Ember Octane - Part 3: Tracked Properties](https://www.pzuraq.com/coming-soon-in-ember-octane-part-3-tracked-properties/)
- [Coming Soon in Ember Octane - Part 4: Modifiers](https://www.pzuraq.com/coming-soon-in-ember-octane-part-4-modifiers/)
- [Coming Soon in Ember Octane - Part 5: Glimmer Components](https://www.pzuraq.com/coming-soon-in-ember-octane-part-5-glimmer-components/)
- [Ember Octane Update: What's up with `@action`?](https://www.pzuraq.com/ember-octane-update-action/)
- [Ember Octane Update: Landing Decorators](https://www.pzuraq.com/ember-octane-update-landing-decorators/)
- [Ember Octane Update: Async Observers](https://www.pzuraq.com/ember-octane-update-async-observers/)
- [Confirming Actions in Ember.js](https://medium.com/@chrsmllr/confirming-actions-in-ember-362b19a0c01f)
- [Async Computed Properties in Ember.js](https://www.barelyknown.com/posts/async-computed-properties-in-ember)
- [Ember.js Native Class Update: 2019 Edition](https://www.pzuraq.com/emberjs-native-class-update-2019-edition/)
- [Ember.js Route Hooks — A Complete Look](https://alexdiliberto.com/posts/ember-route-hooks-a-complete-look/)
- [Understanding unknownProperty in Ember.js](https://wyeworks.com/blog/2015/11/24/understanding-unknownproperty-in-ember)
- [An Introduction to Ember.js for Angular Developers](https://davidtang.io/2016/02/10/introduction-to-ember-for-angular-developers.html)
- [Debugging Ember.js with VScode](https://dev.to/michalbryxi/debugging-emberjs-with-vscode-2p5g)
- [Staging environments with ember-cli-deploy](http://blog.firstiwaslike.com/staging-environments-with-ember-cli-deploy/)
- [Higher-Order Components in Ember.js](https://www.chriskrycho.com/2018/higher-order-components-in-emberjs.html)
- [How to handle async properties in Ember.js](https://medium.com/macsour/how-to-handle-async-abilities-with-ember-can-22d90df056ed)
- [8 Top Ember.js Interview Questions in 2018](http://blog.honeypot.io/emberjs-interview-questions-2018/)
- [Ember.js community, meet CodeSandbox!](https://medium.com/@mikenorth/ember-community-meet-codesandbox-10a43076b3fa)
- [Fuel up your Ember.js with Octane](https://clark.engineering/fuel-up-your-ember-with-octane-171c8dd13fd6)
- [Ember Octane – everything one can expect in the next Ember.js edition](http://hangaroundtheweb.com/2018/08/ember-octane-everything-one-can-expect-in-the-next-ember-edition/)
- [Lazy-loading modules in Ember.js](https://medium.com/zonky-developers/lazy-loading-modules-in-emberjs-e4f880b15aa0)
- [Components patterns in Ember.js](https://medium.com/macsour/components-patterns-in-ember-js-5e6fc6eea28f)
- [Optimizing Ember.js Templates](https://medium.com/square-corner-blog/optimizing-ember-templates-c479d26fe58e)
- [How to keep your ember.js project clean and well-structured](https://geeks.uniplaces.com/how-to-keep-your-ember-js-project-clean-and-well-structured-fbff040274de)
- [PWA Your Ember.js App](https://blog.201-created.com/pwa-your-ember-app-7ee8242f306e)
- [Adding a new build notification to an Ember.js application](https://medium.com/@jonpitch/adding-a-new-build-notification-to-an-ember-application-c657211289f6)
- [Making Ember.js Applications' UI Transitions Screen Reader Friendly](https://engineering.linkedin.com/blog/2018/10/making-ember-applications--ui-transitions-screen-reader-friendly)
- [Share Ember.js common code between apps](https://dev.to/michalbryxi/share-emberjs-common-code-between-apps-1a7k)
- [The Ember.js of the future... today!](https://dev.to/nullvoxpopuli/the-emberjs-of-the-future-today-12c)
- [Building a Progressive Web App with Ember.js](https://madhatted.com/2017/6/16/building-a-progressive-web-app-with-ember)
- [Dynamic component layout in Ember.js](https://medium.com/freshworks-engineering-blog/dynamic-component-layout-in-ember-c9375c49126a)
- [Using PurgeCSS with Ember.js](http://www.jurecuhalev.com/blog/2018/09/07/using-purgecss-with-ember-js/)
- [Modern Ember.js (2018)](https://codingitwrong.com/2018/08/16/modern-ember.html)
- [Automating Ember.js App Deployment on AWS](https://medium.com/@piotr.steininger/automating-ember-js-app-deployment-on-aws-feccc6d94828)
- [Django & Ember.js Full Stack Basics: Connecting Frontend and Backend — Part 1](https://medium.com/@sunskyearthwind/django-emberjs-full-stack-basics-connecting-frontend-and-backend-part-1-beed8c386b08)
- [Everything one can expect in Ember Octane](http://hangaroundtheweb.com/2018/08/ember-octane-everything-one-can-expect-in-the-next-ember-edition)
- [Shipping Ember.js bundles based on the user's browser](https://sivasubramanyam.me/emberjs-shipping-different-bundles/)
- [To `attrs` or not to `attrs`](https://locks.svbtle.com/to-attrs-or-not-to-attrs)
- [Nested components and angle brackets, a sneaky solution](https://locks.svbtle.com/nested-components-and-angle-brackets)
- [How I added whitelabel theming to my Ember.js app](https://medium.com/@simeonberns/how-i-added-whitelabel-theming-to-my-ember-app-97bfca9e263a)
- [Decorating Guide: Commonly-Used Ember.js Decorators](https://codingitwrong.com/2018/08/21/decorating-guide.html)
- [Understanding Ember's resolver](https://dockyard.com/blog/2016/09/14/understanding-ember-s-resolver)
- [Creating Connection-aware Ember.js Media Components](http://hangaroundtheweb.com/2018/08/creating-connection-aware-ember-media-components/)
- [A framework for ambitious Chrome Extensions](https://envoy.engineering/a-framework-for-ambitious-chrome-extensions-b08d1f4b944d)
- [Autodiscovery for the Ember.js component playground](https://simplabs.com/blog/2018/06/05/ember-component-playground.html)

- [Configuring Ember.js Analytics for GDPR](https://fullstackstanley.com/read/configuring-ember-js-analytics-for-gdpr)
- [Drag and Drop on iOS with Ember.js](https://dockyard.com/blog/2018/07/20/drag-and-drop-on-ios-with-ember)
- [Tips for improving build time of large apps](https://discuss.emberjs.com/t/tips-for-improving-build-time-of-large-apps/15008)
- [Error Handling](https://github.com/pixelhandler/ember-jsonapi-resources/wiki/Error-Handling)
- [Build and Authenticate an Ember.js 3 Application](https://auth0.com/blog/build-and-authenticate-an-emberjs-3-application)
- [Everything you need to know to upgrade your Ember.js app](https://medium.com/front-end-hacking/everything-you-need-to-know-to-upgrade-your-ember-js-app-including-ember-3-9de5e808dde0)
- [16 Opensource Ember.js Projects to Learn From](https://www.icicletech.com/blog/16-opensource-emberjs-projects-to-learn-from)
- [5 Essential Ember.js Concepts You Must Understand](https://emberigniter.com/5-essential-ember-concepts/)
- [Adding AWS Amplify to an Ember.js Application](https://itnext.io/adding-aws-amplify-to-an-ember-js-application-72683167c476)

- [An Interview with Tom Dale of Ember.js](https://javascriptreport.com/interview-with-tom-dale/)
- [Animations in Ember.js with liquid-fire](https://www.airpair.com/ember.js/posts/animations-in-emberjs-with-liquidfire)

- [Awesome Ember.js Addons](https://www.codementor.io/gowiem/awesome-ember-addons-bwhiofit9)
- [Building a performant real-time web app with Ember Fastboot and Phoenix](https://medium.com/peep-stack/building-a-performant-web-app-with-ember-fastboot-and-phoenix-part-1-fa1241654308)
- [Debug Ember.js app with VSCode](https://medium.com/@minhdn/debug-ember-app-with-vscode-5f4fde511f9f)
- [Debugging Ember.js applications in Visual Studio Code](http://blog.firstiwaslike.com/debugging-ember-js-application-in-visual-studio-code/)
- [DEPLOYING WITH EMBER.JS: A STORY](https://blogs.library.ucsf.edu/ckm/2017/09/06/deploying-with-ember-js-a-story/)
- [Do not confuse environment for deploy target](https://lolma.us/en/blog/class-and-attribute-bindings)
- [Ember.js Best Practices: Computed Properties with Dynamic Dependent Keys](https://dockyard.com/blog/2015/10/23/ember-best-practices-dynamic-dependent-keys-for-computed-properties)
- [Ember.js Best Practices: Avoid leaking state into factories](https://dockyard.com/blog/2015/09/18/ember-best-practices-avoid-leaking-state-into-factories)
- [Ember CLI Addon Docs: Shared Documentation for the Ember.js Ecosystem](https://medium.com/build-addepar/ember-cli-addon-docs-shared-documentation-for-the-ember-ecosystem-6f29aa0cee87)
- [Ember Inspector - The Journey so Far](https://shipshape.io/blog/ember-inspector-the-journey-so-far/)
- [Ember.js on Medium](https://medium.com/front-end-hacking/tagged/ember)
- [EmberCamp Module Unification Update](https://madhatted.com/2017/7/12/embercamp-module-unification-update)
- [Skeleton Screen Loading in Ember.js](https://emberway.io/skeleton-screen-loading-in-ember-js-2f7ac2384d63)
- [Static Blogs with Prember and Markdown](https://shipshape.io/blog/static-blogs-with-prember-and-markdown/)
- [Tom Dale on Ember.js and JavaScript Frameworks](https://www.infoq.com/interviews/tom-dale-ember) - Year 2013.
- [Using ember-freestyle as a component playground](https://simplabs.com/blog/2018/01/24/ember-freestyle.html)
- [Using npm libraries in Ember CLI](https://simplabs.com/blog/2017/02/13/npm-libs-in-ember-cli.html)
- [We have a new Ember.js front-end!](https://medium.com/@appaloosastore/we-have-a-new-emberjs-front-end-c7246e76cdbd)
- [What you didn't know about passing dynamic classname and attribute bidings from parent template](https://lolma.us/en/blog/class-and-attribute-bindings)
- [You can only change what you can measure](https://blog.201-created.com/you-can-only-change-what-you-can-measure-6be8826503a7)

- [How I added whitelabel theming to my Ember.js app](https://medium.com/@simeonberns/how-i-added-whitelabel-theming-to-my-ember-app-97bfca9e263a)
- [Customising Ember Power Select](https://medium.com/life-at-kayako/customising-ember-power-select-3d570c7c4c0c)
- [Deep Dive on Ember.js Events](https://medium.com/square-corner-blog/deep-dive-on-ember-events-cf684fd3b808)

- [A collection of notes that summarize EmberConf 2021](https://alexdiliberto.com/posts/emberconf-2021-notes/)
- [A collection of notes that summarize EmberConf 2020](https://alexdiliberto.com/posts/emberconf-2020-notes/)
- [A collection of notes that summarize EmberConf 2019](https://alexdiliberto.com/posts/emberconf-2019-notes/)
- [EmberConf 2019 Links and Notes](https://github.com/dknutsen/emberconf-2019)
- [A collection of links that summarize EmberConf 2018](https://github.com/nucleartide/emberconf-2018)
- [A collection of links that summarize EmberConf 2017](https://github.com/poteto/emberconf-2017)
- [A collection of links that summarize EmberConf 2016](https://github.com/poteto/emberconf-2016)
- [A collection of links that summarize EmberConf 2015](https://github.com/poteto/emberconf-2015)
- [A list of EmberJS2018 blog posts and ideas](https://github.com/zinyando/emberjs2018-posts)
- [Blog Post for an Ambitious Framework](https://blog.201-created.com/blog-post-for-an-ambitious-framework-d7e9248893fa)
- [Essential Ember Addons: The State of the Ember Addon Ecosystem in 2019](https://0xadada.pub/2019/06/17/essential-ember-addons/)
- [Deploying an Ember.js App to Netlify](https://derricksdocs.com/deploying-an-emberjs-app-to-netlify/)
- [Ember performance tweaks: Optimising build timelines & bundle size](https://abhilashlr.in/ember-performance-tweaks-part-1)
- [Ember performance tweaks: Optimising Assets](https://abhilashlr.in/ember-performance-tweaks-part-2)
- [Ember performance tweaks: Search engine optimization](https://abhilashlr.in/ember-performance-tweaks-part-3)

### Ember-Cli Articles
- [Ember-cli fingerprinting and dynamic assets](https://medium.com/@ruslanzavacky/ember-cli-fingerprinting-and-dynamic-assets-797a298d8dc6)
- [Secrets of the Ember-CLI server: Express middleware with Ember-CLI](https://blog.201-created.com/secrets-of-the-ember-cli-server-bde80bb546dd)


### Why Articles
- [NYC Planning Labs: Why Choose Ember.js?](https://medium.com/nycplanninglabs/nyc-planning-labs-why-choose-ember-js-fe9ff75f4373)
- [Why DockYard Builds with Ember.js](https://dockyard.com/blog/2017/10/04/why-dockyard-uses-ember)
- [Ember.js. Your best bet.](https://medium.com/@alvincrespo/ember-your-best-bet-b5cd7275dc84)
- [Why Ember.js?](http://www.melsumner.com/blog/ember/why-ember/)
- [6 Reasons Why To Use Ember.js In 2019](https://selleo.com/blog/6-reasons-why-to-use-ember-in-2019)
- [Ember.js: Our Secret Weapon](https://www.prototypal.io/blog/)
- [How Ember.js Enables Us to Focus on Shipping Features](http://blog.nightwatch.io/ember-js-shipping-features)
- [When you should not pick Ember.js as your next front-end tool](https://medium.com/selleo/when-you-should-not-pick-emberjs-as-your-next-front-end-tool-203697c2e0f0)
- [Moving from React to Ember 2020](http://medium.com/@nowims/moving-from-react-to-ember-2020-86e082477d45)
- [Essential Ember Addons: The State of the Ember Addon Ecosystem in 2019](https://0xadada.pub/2019/06/17/essential-ember-addons/)

### Jump-Start Articles
- [The simplest possible Ember Data CRUD Tutorial](https://medium.com/ember-ish/the-simplest-possible-ember-data-crud-16eacee33ae6)
- [Challenges I face(d) with Ember.js](https://medium.com/@sarbbottam/challenges-i-face-with-ember-js-59bfba30416e)
- [It’s easier in Ember.js. Probably.](http://www.melsumner.com/blog/development/its-easier-in-ember-probably/)

### Articles Glimmer
- [Alternative View Layers for an Elm App](https://robots.thoughtbot.com/elm-glimmer)
- [Creating Web Components with Glimmer](https://simplabs.com/blog/2017/08/28/creating-web-components-with-glimmer.html)
- [Building a PWA with Glimmer.js](https://simplabs.com/blog/2018/07/03/building-a-pwa-with-glimmer-js.html)
- [The Glimmer VM: Boots Fast and Stays Fast](https://yehudakatz.com/2017/04/05/the-glimmer-vm-boots-fast-and-stays-fast/)
- [The Glimmer Binary Experience](https://engineering.linkedin.com/blog/2017/12/the-glimmer-binary-experience)
- [Glimmer.js: What’s the Deal with TypeScript?](https://medium.com/@tomdale/glimmer-js-whats-the-deal-with-typescript-f666d1a3aad0)
- [Glimmer.js Application proposal](https://gist.github.com/tomdale/10fe9feeb84f2e4325f042839799bd9d) - Compilation, Rendering, SSR, Rehydration.
- [Git Guides](https://github.com/glimmerjs/glimmer-vm/blob/master/guides/01-introduction.md)
- [Designing and Implementing Glimmer Like a Programming Language](https://thefeedbackloop.xyz/designing-and-implementing-glimmer-like-a-programming-language/)
- [Glimmer: Blazing Fast Rendering for Ember.js, Part 1](https://engineering.linkedin.com/blog/2017/03/glimmer--blazing-fast-rendering-for-ember-js--part-1)
- [Glimmer: Blazing Fast Rendering for Ember.js, Part 2](https://engineering.linkedin.com/blog/2017/06/glimmer--blazing-fast-rendering-for-ember-js--part-2)
- [Why I’m excited about Glimmer.js](https://hackernoon.com/why-im-excited-about-glimmerjs-3631bd0c95c4)
- [Getting Started With Glimmer-Native](https://codingitwrong.com/2019/06/26/glimmer-native-tutorial.html)
- [What is the current state of more advanced Glimmer VM features?](https://discuss.emberjs.com/t/what-is-the-current-state-of-more-advanced-glimmer-vm-features/18114/4)
- [UNIT-TESTING GLIMMER COMPONENTS](https://timgthomas.com/2019/11/unit-testing-glimmer-components/)

### Articles Engines
- [CSS in Ember Engines](https://medium.com/@ynotdraw/css-in-ember-engines-230ef8d4cef8)
- [Enginification](https://simplabs.com/blog/2017/12/04/enginification.html)

### Articles Ember-Concurrency
- [Adopting ember-concurrency or: How I Learned to Stop Worrying and Love the Task](https://engineering.linkedin.com/blog/2016/12/ember-concurrency--or--how-i-learned-to-stop-worrying-and-love-t)
- [Async or Swim: Replacing your Route models with Ember Concurrency Tasks](https://medium.com/@AveryBloom/async-or-swim-replacing-your-route-models-with-ember-concurrency-tasks-5a230252893a)
- [ember-concurrency: the solution to so many problems you never knew you had](https://emberway.io/ember-concurrency-the-solution-to-so-many-problems-you-never-knew-you-had-cce6d7731ba9)
- [PromiseProxyMixin: pure Ember alternative to ember-concurrency](https://lolma.us/en/blog/promise-proxy-mixin/)
- [Two-Tasks Routes in Ember.js](https://tritarget.org/#Two-Tasks%20Routes%20in%20Ember)

### Articles ES6
- [ES Classes in Ember.js](https://medium.com/build-addepar/es-classes-in-ember-js-63e948e9d78e)

### Articles TypeScript
- [ember-cli-typescript v2 beta](https://www.chriskrycho.com/2018/ember-cli-typescript-v2-beta.html)
- [Ember Typescript Code Coverage - how to gist](https://gist.github.com/lifeart/5f75981d5f6262d1bfc4525aebfcf7d5)
- [Type-Informed Design](https://www.chriskrycho.com/2018/type-informed-design.html)
- [Typing Your Ember.js](https://www.chriskrycho.com/typing-your-ember.html) - Using TypeScript with Ember.js.
- [Ember.js, TypeScript, and Class Properties](https://www.chriskrycho.com/2018/ember-ts-class-properties.html)
- [Set your Ember.js project up to use TypeScript](http://www.chriskrycho.com/2017/typing-your-ember-part-1.html)
- [Class properties — some notes on how things differ from the Ember.Object world](https://www.chriskrycho.com/2018/typing-your-ember-update-part-2.html)
- [Computed properties, actions, mixins, and class methods](https://www.chriskrycho.com/2018/typing-your-ember-update-part-3.html)
- [Using Ember Data, and service and controller injections improvements](https://www.chriskrycho.com/2018/typing-your-ember-update-part-4.html)

### Articles Modern Testing
- [Using Fakes from Ember-Sinon-QUnit](https://medium.com/@mudflye/using-fakes-from-ember-sinon-qunit-c9fb7d4d9b1d)
- [Headless Ember.js Tests in GitLab with Docker](https://medium.com/devopslinks/headless-ember-tests-in-gitlab-with-docker-fd5f05eef436)
- [Making my Ember.js test suite 3x faster. A story about Mirage](https://mlange.io/blog/making-tests-faster-mirage/making-tests-faster-mirage/)
- [Learn TDD in Ember.js](https://learntdd.in/ember/)
- [STORY-BASED BDD - AN ALTERNATIVE APPROACH TO TESTING WITH EMBER](https://www.kaliber5.de/en/blog/story-based-bdd-an-alternative-approach-to-testing-with-ember/)
- [Ember.js Timer Leaks: The Bad Apples in Your Test Infrastructure](https://engineering.linkedin.com/blog/2018/01/ember-timer-leaks)
- [Test helpers: The next generation](https://dockyard.com/blog/2018/01/18/test-helpers-the-next-generation)
- [How we test 200k lines Ember.js application in <10 minutes. Again!](https://hackernoon.com/how-we-got-tests-for-200k-lines-ember-application-running-10-minutes-again-1fa7a4c5af2f)
- [Bending Time in Ember.js Tests](https://dockyard.com/blog/2018/04/18/bending-time-in-ember-tests)
- [Ember.js QUnit Simplification](https://www.rwjblue.com/2017/10/23/ember-qunit-simplication/)
- [Testing your Ember.js application in 2018](https://dockyard.com/blog/2018/03/29/testing-your-ember-application-in-2018)
- [Modern Ember.js Testing](https://dockyard.com/blog/2018/01/11/modern-ember-testing)
- [Testing Ember.js Applications in 2018](https://blog.201-created.com/testing-ember-applications-in-2018-4635ac241f00)
- [Testing Ember.js Mixins (and Helpers) With a Container](https://www.chriskrycho.com/2016/testing-emberjs-mixins-with-a-container.html)
- [Write Tests Like a Mathematician: Part 1](https://crunchingnumbers.live/2019/08/04/write-tests-like-a-mathematician-part-1/)
- [Write Tests Like a Mathematician: Part 2](https://crunchingnumbers.live/2019/08/06/write-tests-like-a-mathematician-part-2/)
- [Write Tests Like a Mathematician: Part 3](https://crunchingnumbers.live/2019/10/11/write-tests-like-a-mathematician-part-3/)
- [Setting up Coveralls for your Ember Addons](http://hangaroundtheweb.com/2020/05/setting-up-coveralls-for-your-ember-addons/)

### Articles FastBoot
- [How to integrate Ember FastBoot in Cloud Functions for Firebase](https://cenchat.com/blog/2019/06/06/how-to-setup-ember-fastboot-in-cloud-functions-for-firebase.html)
- [Ember FastBoot + Google App Engine](https://pulletsforever.com/ember-fastboot-google-app-engine-1d38e1e3ffc2)
- [Deploying FastBoot apps with ember-cli-deploy](https://www.effective-ember.com/blog/deploying-fastboot-apps-with-ember-cli-deploy)

### Articles about Data
- [Managing Relations in Ember Data with JSON API](https://www.mediasuite.co.nz/blog/managing-relations-ember-data-json-api/)
- [Creating a Default Record When a belongsTo Request Errors](https://shipshape.io/blog/ember-data-belongs-to-find-or-create/)
- [The case against async relationships in Ember Data](https://embermap.com/notes/83-the-case-against-async-relationships)
- [No Graph Theory Required: Ember.js and GraphQL in Practice](https://medium.com/kloeckner-i/ember-and-graphql-8aa15f7a2554)
- [Offline Data and Sync with Ember-Orbit](https://codingitwrong.com/2018/05/10/ember-orbit.html)
- [Inlining store data in Ember.js](https://balinterdi.com/blog/inlining-store-data-in-ember-js/)
- [Extracting Metadata from a Custom API with Ember Data](https://thejsguy.com/2018/04/06/extracting-metadata-from-a-custom-api-with-ember-data.html)
- [Ad Hoc Relationships with Ember Data](https://shipshape.io/blog/ad-hoc-relationships-with-ember-data/)
- [Ember Data RecordArray AntiPatterns](https://gist.github.com/runspired/d86a76158050c4f573f5f26df1dab143)
- [Useful Ember Data helpers](https://gist.github.com/runspired/96618af26fb1c687a74eb30bf15e58b6)
- [Cascade Deleting Relationships in Ember Data](https://davidtang.io/2017/02/10/cascade-deleting-relationships-in-ember-data.html)
- [Fit Any Backend Into Ember with Custom Adapters & Serializers](https://emberigniter.com/fit-any-backend-into-ember-custom-adapters-serializers/)

### Articles about Routing
- [How to reset the Ember.js router namespace with this.route()](http://toddsmithsalter.com/how-to-reset-the-route-namespace-with-this-route/)
- [Ember.js-Router Wildcard/Globbing Routes](https://www.tutorialspoint.com/emberjs/route_glbng_rut.htm)
- [Ember.js.Route redirecting ‘/’ to ‘/my-own’](https://medium.com/ember-titbits/quest-4-ember-route-defaulting-to-my-own-f22b0dcb336f)

### Yarn in Ember Articles
- [Ember.js and Yarn Workspaces](https://medium.com/square-corner-blog/ember-and-yarn-workspaces-fca69dc5d44a)

### Best-practices

- [ember-best-practices](https://github.com/ember-best-practices)
- [An Ember.js Debugging Flowchart](https://www.mutuallyhuman.com/blog/2016/08/12/an-ember-debugging-flowchart)
- [Built-in input helpers in Ember.js: when should they be used?](https://balinterdi.com/blog/built-in-input-helpers-in-ember-js-when-and-whether-they-should-be-used/)

### Nice to know

- [Codemods](https://caseywatts.com/2018/08/23/codemods.html)
- [Creating runtime assisted Codemods using Telemetry helpers](http://hangaroundtheweb.com/2019/10/creating-runtime-assisted-codemods-using-telemetry-helpers/)

### Blogs

- [lost-in-technology.com](https://www.lost-in-technology.com/blog/)
- [TODAY I LEARNED / Ember.js](https://til.hashrocket.com/emberjs)
- [Ember.js Daily Tips](http://www.emberdaily.com)
- [emberway.io](https://emberway.io/)
- [yehudakatz](https://yehudakatz.com/)
- [201-created.com](https://blog.201-created.com/)
- [airpair.com](https://www.airpair.com/ember.js)
- [alexdiliberto.com](https://alexdiliberto.com/)
- [balinterdi.com](https://balinterdi.com/blog/) - Balint Erdi blog.
- [codeburst.io](https://codeburst.io/tagged/emberjs)
- [codementor.io](https://www.codementor.io/community/topic/emberjs)
- [dockyard.com](https://dockyard.com/blog/categories/ember)
- [emberigniter.com](https://emberigniter.com/articles/)
- [blog.embermap.com](https://blog.embermap.com)
- [engineering.linkedin.com](https://engineering.linkedin.com/blog/topic/ember)
- [hackernoon.com](https://hackernoon.com/tagged/ember)
- [lolma.us](https://lolma.us/en/blog)
- [madhatted.com](https://madhatted.com/)
- [medium.com/ember-ish](https://medium.com/ember-ish) - Ember.js essentials for beginners and intermediate devs.
- [netguru.co](https://www.netguru.co/blog/topic/ember-js)
- [programwitherik.com](https://www.programwitherik.com) - Ember.js tuts.
- [rwjblue.com](http://rwjblue.com/)
- [shipshape.io](https://shipshape.io/blog/)
- [simplabs.com](https://simplabs.com/blog/)
- [thejsguy.com](https://thejsguy.com/)

### Books

- [The Shortest Ember.js Book](https://github.com/ember-learn/the-shortest-ember-book)
- [A deep dive into the Ember.js runloop](https://github.com/eoinkelly/ember-runloop-handbook)
- [Developing an Ember.js Edge](https://gumroad.com/l/xlsx)
- [Ember Data in the Wild](https://leanpub.com/emberdatainthewild)
- [ember-cli 101](https://leanpub.com/ember-cli-101) - By Adolfo Builes.
- [Ember.js for Artisans](https://leanpub.com/emberforartisans) - Creating Single Page Apps backed by Laravel.
- [Ember.js in Action](http://manning.com/skeie/) - By Joachim Haagen Skeie.
- [Professor Frisby's Mostly adequate guide to Functional Programming](https://drboolean.gitbooks.io/mostly-adequate-guide-old/)
- [Rock and Roll with Ember.js](http://rockandrollwithemberjs.com/)
- [Ember.js Book (RU)](https://leanpub.com/ember-book)
- [Pragmatic, balanced FP in JavaScript](https://github.com/getify/Functional-Light-JS)

### Cheatsheets

- [API](https://emberjs.com/api/)
- [Glimmer.js](https://glimmerjs.com/)
- [guides](https://guides.emberjs.com/)
- [Ember Component Cheat Sheet](https://codingitwrong.com/2019/07/23/ember-component-cheat-sheet.html) - pre Octane

### Codemods
- [ember-es6-class-codemod](https://github.com/scalvert/ember-es6-class-codemod) - A codemod-cli project for converting Ember.js objects to es6 native classes.
- [ember-native-class-codemod](https://github.com/ember-codemods/ember-native-class-codemod) - A codemod for transforming your ember app code to native JavaScript class syntax with decorators!
- [ember-cli-mirage-faker-codemod](https://github.com/caseywatts/ember-cli-mirage-faker-codemod) - This codemod is to help transition from importing faker through ember-cli-mirage, to instead import it directly from faker.
- [ember-mocha-codemods](https://github.com/Turbo87/ember-mocha-codemods) - Codemod scripts for ember-mocha.
- [ember-module-migrator](https://github.com/rwjblue/ember-module-migrator) - Automated migration for new Ember.js application layout.
- [ember-qunit-codemod](https://github.com/rwjblue/ember-qunit-codemod) - This codemod is intended to automatically convert your projects from the older moduleFor* syntax of ember-qunit@2 to the newer syntax.
- [ember-test-helpers-codemod](https://github.com/simonihmig/ember-test-helpers-codemod) - Codemod to transform your Ember.js tests to use @ember/test-helpers.
- [es5-getter-ember-codemod](https://github.com/rondale-sc/es5-getter-ember-codemod) - This codemod is intended to automatically convert your usage of get, and getProperties to use traditional object dot notation.
- [qunit-dom-codemod](https://github.com/simplabs/qunit-dom-codemod) - Basic codemod to automatically convert your assertions to qunit-dom assertions.
- [test-selectors-codemod](https://github.com/lorcan/test-selectors-codemod) - A codemode for fixing the ember-test-selectors testSelector helper deprecation.
- [ember-on-codemod](https://github.com/craigbilner/ember-on-codemod) - Replace use of Ember.on.
- [ember-memory-leaks-codemod](https://github.com/rajasegar/ember-memory-leaks-codemod) - A collection of codemod's for fixing memory leaks in Ember.js applications.
- [ember-3x-codemods](https://github.com/rajasegar/ember-3x-codemods) - A Codemod with a collection of transforms to address Ember.js 3.x deprecations.
- [ember-computed-getter-codemod](https://github.com/Alonski/ember-computed-getter-codemod) - Ember.js Computed Getter Codemod.

### Community

- [Forum](http://discuss.emberjs.com/)
- [GitHub issues](https://github.com/emberjs/ember.js/issues)
- [Reddit](https://www.reddit.com/r/emberjs/)
- [Slack](https://embercommunity.slack.com)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/ember.js)
- [Telegram](https://t.me/ember_js)

### Contribution Guides

- [How to contribute to the ember times - part1](https://www.kennethlarsen.org/how-to-contribute-to-the-ember-times)
- [How to contribute ember release post - part2](https://www.kennethlarsen.org/how-to-contribute-ember-release-post)

### Courses

- [embermap.com](https://embermap.com)
- [Emberschool.com](https://www.emberschool.com)
- [embercasts.com](https://www.embercasts.com)
- [Frontend Masters: Advanced Ember.js 2.x - Mike North](https://frontendmasters.com/courses/advanced-ember-2/)
- [Frontend Masters: Ember.js 2.x - Mike North](https://frontendmasters.com/courses/ember-2/)

### Discovery

- [emberobserver](https://emberobserver.com/) - Ember Observer.
- [emberjs.GitHub.io/rfcs/](https://emberjs.github.io/rfcs/) - Ember.js RFCs.

### Ember Releases

- [Ember 3.10 Released](https://blog.emberjs.com/2019/05/21/ember-3-10-released.html) - May 21, 2019
- [Ember 3.11](https://blog.emberjs.com/2019/07/15/ember-3-11-released.html) - July 15, 2019
- [Ember 3.12](https://blog.emberjs.com/2019/08/16/ember-3-12-released.html) - August 16, 2019
- [Ember 3.13 (Octane Preview)](https://blog.emberjs.com/2019/09/25/ember-3-13-released.html) - Sep 25, 2019
- [Ember 3.14 (Octane Preview Cont.)](https://blog.emberjs.com/2019/11/18/ember-3-14-released.html) - Nov 18, 2019
- [Ember 3.15 "Octane" Released](https://blog.emberjs.com/2019/12/20/ember-3-15-released.html) - Dec 20, 2019
- [Ember 3.16](https://blog.emberjs.com/2020/02/12/ember-3-16-released.html) - Feb 12, 2020
- [Ember 3.17](https://blog.emberjs.com/2020/03/16/ember-3-17-released.html) - March 16, 2020
- [Ember 3.18](https://blog.emberjs.com/2020/05/05/ember-3-18-released.html) - May 5, 2020
- [Ember 3.19](https://blog.emberjs.com/2020/06/26/ember-3-19-released.html) - June 26, 2020
- [Ember 3.20](https://blog.emberjs.com/2020/07/29/ember-3-20-released.html) - July 29, 2020
- [Ember 3.21](https://blog.emberjs.com/2020/09/02/ember-3-21-released.html) - Sep 02, 2020
- [Ember 3.22](https://blog.emberjs.com/2020/10/20/ember-3-22-released.html) - Oct 20, 2020

### Examples
- [A list of open source Ember.js apps](https://github.com/EmberSherpa/open-source-ember-apps)
- [Simple contact manager demo app for ember-orbit](https://github.com/cerebris/peeps-ember-orbit)
- [API Docs](https://github.com/ember-learn/ember-api-docs) - This application was built to display our versioned API docs.
- [guides-app](https://github.com/ember-learn/guides-app) - Replacement for emberjs/guides and the Ember.js Guides.
- [Builds](https://github.com/ember-learn/builds) - This is the application that the Ember.js team built to display our various release channels.
- [HospitalRun](https://github.com/HospitalRun/hospitalrun-frontend) - Ember.js front end for HospitalRun [hospitalrun.io](http://hospitalrun.io/).
- [Rancher](https://github.com/rancher/ui) - [Rancher](http://rancher.com) is enterprise management for Kubernetes.
- [Super Rentals](https://github.com/ember-learn/super-rentals) - Super Rentals is a good starter project to get acclimated to the Ember.js way of doing things.
- [Travis CI](https://github.com/travis-ci/travis-web) - The Ember.js web client for [Travis CI](https://travis-ci.org/).
- [Vault](https://github.com/hashicorp/vault/tree/master/ui/app) - A Tool for Managing Secrets (Hashicorp).
- [ember-osf-web](https://github.com/CenterForOpenScience/ember-osf-web) - Ember.js front-end for the Open Science Framework.
- [ember-graphql-examples](https://github.com/chadian/ember-graphql-examples) - Examples of using GraphQL in Ember.js.
- [ember-rolodex](https://github.com/rtablada/ember-rolodex) - An example of what an Ember.js tutorial between the quick start and Super Rents could look like.
- [ember-styleguide](https://github.com/ember-learn/ember-styleguide)
- [Ghost Admin Client](https://github.com/TryGhost/Ghost-Admin)
- [emberclear](https://github.com/NullVoxPopuli/emberclear) - Encrypted Chat. No History. No Logs.  + MU & TS.
- [Ember.js nested engines example app + Fastboot.](https://github.com/catz/eng-test)
- [Percy's frontend web application, built with Ember.js.](https://github.com/percy/percy-web)
- [Fire Tracker](https://github.com/SCPR/fire-tracker) - KPCC's tool for following & researching California wildfires.
- [skylines-project](https://github.com/skylines-project/skylines/tree/master/ember) - Live tracking, flight database and competition framework.
- [PIX](https://github.com/1024pix/pix-editor) - PIX.
- [ember-monorepo-demo](https://github.com/lennyburdette/ember-monorepo-demo)
- [documize.com](https://github.com/documize/community)
- [New York City Census Reporting Tool](https://github.com/NYCPlanning/labs-factfinder)
- [Medicine Inventory](https://github.com/aalasolutions/ember-medical-inventory) - Sample application developed with Ember CLI, Corber.io, ember-element-ui.
- [octane-ecommerce](https://github.com/betocantu93/octane-ecommerce) - Ember Octane + FastBoot + Algolia + PayPal + Formspree ([s](https://docs.google.com/presentation/d/1YaG26Fj-tVjyFV8LvQJkfIH89-HYdkfHfhdRz3bC2-k/edit#slide=id.g56ccd9a7f0_0_33), [v](https://www.youtube.com/watch?v=KnkWs18V9dA&feature=youtu.be), [d](https://octane-ecommerce.herokuapp.com/)).
- [Rust Package Registry](https://github.com/rust-lang/crates.io) - [crates.io](https://crates.io)
- [Ember.js RealWorld Implementation](https://github.com/gothinkster/ember-realworld) - Ember.js codebase containing real world examples (CRUD, auth, advanced patterns, etc) that adheres to the RealWorld spec and API.
- [A wild tomster appears](https://github.com/scudco/tomsweeper)
- [An ember integration for building visual programming editors with blockly.](https://github.com/Program-AR/ember-blockly)
- [https://www.submarinecablemap.com/](https://www.submarinecablemap.com/)
- [https://music.apple.com/](https://music.apple.com/)
- [https://creator.emojible.store/](https://creator.emojible.store/)


### Examples Glimmer
- [breethe-client](https://github.com/simplabs/breethe-client) - Air Quality Data for Locations around the World.
- [Glimmeroids](https://github.com/t-sauer/Glimmeroids) - Asteroids implementation using Glimmer.js.
- [glimmer-hn-pwa](https://github.com/mhadaily/glimmer-hn-pwa) - A Demonstration Of Hacker News Progressive Web App Powered By Glimmer.js.
- [the-chosen](https://github.com/FLarra/the-chosen) - Glimmer.js project created to learn & decide easier during our scrum dailies meeting who is the next person to share status.
- [glimmer_eats](https://github.com/James-Byrne/glimmer_eats) - A demo PWA built with Glimmer.js.
- [built-with-spaghetti](https://github.com/gordonbisnor/built-with-spaghetti) - Built with Spaghetti aims to function as a gateway to web art.
- [glimmer-live-chat](https://github.com/rajasegar/glimmer-live-chat) - A Live chat application crafted using Glimmer.js.
- [glimmer-synth](https://github.com/jimenglish81/glimmer-synth) - Synthesizer built using WebAudio and Glimmer.js.
- [glimmer-js-online-offline-demo](https://github.com/thomasbrus/glimmer-js-online-offline-demo) - Sample Glimmer.js app: online/offline browser events.
- [glimmer-qrious](https://github.com/c0urg3tt3/glimmer-qrious) - Glimmer.js components using QRious library to generate QR code in webpage.
- [glimmerjs-address-book-demo](https://github.com/ttdonovan/glimmerjs-address-book-demo) - Example Glimmer.js application - AddressBook Demo.
- [glimmer-dashboard](https://github.com/JustInToCoding/glimmer-dashboard) - Glimmer.js dashboard example.
- [glimmer-redux-todo](https://github.com/bashmach/glimmer-redux-todo) - Todo app written with Glimmer.js and Redux.
- [glimmer-pong](https://github.com/knownasilya/glimmer-pong) - Pong game written using Glimmer.js and SVGs.
- [glimmer-material](https://github.com/cyk/glimmer-material) - A Glimmer.js wrapper for Material Components for the Web.
- [glimmer-of-life](https://github.com/trentmwillis/glimmer-of-life) - An implementation of Conway's Game of Life using Glimmer.js.
- [vorfreude](https://github.com/chadian/vorfreude) - When you can't wait but have to.
- [endless-hoops](https://github.com/mtmckenna/endless-hoops) - It's a basketball game written in JavaScript/Canvas/Glimmer.js.
- [glimmer-hangman](https://github.com/BenSchoenmakers94/glimmer-hangman) - A implementation of the well-known game 'Hangman' in Glimmer.js.


### Gists
- [Forwarding Named Blocks in Glimmer](https://gist.github.com/tomdale/bedb77662b19529f59154ec55e2f4a21)
- [Multi Named Blocks](https://gist.github.com/pzuraq/0c16d7baef7237b62dfd7529d1969344)
- [Accessing the Global App Object in an Ember CLI App](https://gist.github.com/lifeart/fcdc59e2aa6a3c78457fecd57e578aa9)
- [A principled model for forms](https://gist.github.com/chriskrycho/48fa641eeb55217d4063592b411b1192)
- [ember-cli-advanced-proxy](https://github.com/bryanaka/ember-cli-advanced-proxy/blob/594e13cf2de386d8ea65dac88f643241f7a28363/index.js)
- [A list of Ember.js VSCode Extensions](https://github.com/Alonski/ember-vscode-extensions)
- [Ember.js Bundle Size](https://gist.github.com/CodingItWrong/074d20c5468a9c340e15aa46e19a8221)
- [Converting libraries to Ember CLI addons](https://gist.github.com/kristianmandrup/ae3174217f68a6a51ed5)
- [Developing Addons and Blueprints](https://gist.github.com/kristianmandrup/ae3174217f68a6a51ed5)
- [Ember.js + ESLint + Prettier + Ember Suave](https://gist.github.com/sarupbanskota/2394fc439e538239a073c39514a5aa55)
- [@listochkin/Ember.js Video Collection (Ru/En)](https://gist.github.com/listochkin/87e47cdbf986fb2e9905)
- [@rwjblue/ember_examples](https://gist.github.com/rwjblue/8816372)
- [@wycats/A small sampling of external projects initially built for Ember.js use but designed to be used standalone](https://gist.github.com/wycats/b58d56e5a47db4128a0a)
- [Ember.js publishing tools](https://gist.github.com/anulman/1e1da1d38178e7242d4701638bb29391)
- [Ember CLI es6 imports](https://gist.github.com/lifeart/949d867ba5f5455f8d955d9c9dc3610d)
- [Ember CLI Windows speedup](https://gist.github.com/lifeart/f436306a92f62610d65caaa699c17065)
- [How to debug an ember application with VS Code](https://gist.github.com/nightire/38ad30167df55175853b20f025f46596)
- [What are components all about.](https://gist.github.com/begedin/98045c9b4df900bb4695)
- ["Why Ember.js" Thoughts](https://gist.github.com/MelSumner/971ba6b7a3c0b01a4cb3a43d3b962dac)
- [Ember.js approval requirements](https://gist.github.com/PoslinskiNet/2d7a05944ca3c468440a0faea153062b)

### Gists Ember Data
- [Mirage GraphQL example](https://gist.github.com/samselikoff/0e176a76e5be53cbb94e85020fc2b115)
- [Ember Data | Useful helpers: push-deletion, push-payload](https://gist.github.com/runspired/96618af26fb1c687a74eb30bf15e58b6)
- [Ember Data | Complex Attrs](https://gist.github.com/runspired/a4b56f7eefe9f8e04f7f0c83e4dfeaf0)
- [Ember Data | Advanced Query Cache](https://gist.github.com/runspired/dba8d8b4b0cde8d272ec368739460eba)
- [Ember Data | Can we unload a record that has been deleted?](https://gist.github.com/runspired/c92c8d066511083f8c171a33ae27dedf)
- [Ember Data | Persist Local Relationship Changes](https://gist.github.com/runspired/15387de0130478aae377d22b16021982)
- [Ember Data | Push Polymorphic](https://gist.github.com/runspired/c5e86b006841fdab62bcddbc200f14e2)
- [Ember Data | has-many Batch Create](https://gist.github.com/runspired/ad9a9bab3ee2dac11c2af8ee9e31b81d)
- [Ember Data | Local Deletion](https://gist.github.com/runspired/68ad36b99367946a32c470fe1504d0ee)
- [Ember Data | Save Transaction](https://gist.github.com/runspired/a607f4debabde043efd284a04b244974)
- [Ember Data | Coalesce findHasMany within adapter Twiddle](https://gist.github.com/runspired/597ff8ccc4e9a06ff26c1754ba108fb3)
- [Ember Data | Nested save](https://gist.github.com/runspired/bc93f1c525837420f7b14d8cdcb2d36a)
- [Ember Data | Cascade Delete](https://gist.github.com/runspired/e9ee98ccc89fad2a07d9c86f2541a763)

### Miscellaneous

- [builtwithember](http://builtwithember.io/) - Apps powered by Ember.js.
- [emberwatch](https://github.com/emberwatch) - The community hub for Ember.js content.

### Newsletters

- [Ember Weekly](http://www.emberweekly.com/) - The latest Ember.js news, tips, and code delivered directly to your inbox.
- [Official Ember Blog](https://emberjs.com/blog/) - Big announcements like new Ember.js version release notes or State of the Union information.
- [statusboard](https://emberjs.com/statusboard/) - STATUS BOARD.
- [The Ember Times](https://the-emberjs-times.ongoodbits.com/) - Updates from the Ember.js Learning Team.

### Podcasts

- [embermap](https://embermap.com/topics/the-embermap-podcast)
- [emberweekend](https://emberweekend.com/episodes)

### Sandboxes
- [Ember Twiddle](https://ember-twiddle.com/) - An Ember.js Twiddle for multiples files which lets you save your work in GitHub.
- [Ember @ Glitch](https://ember.glitch.me/) - Glitch.me with Ember.js.
- [Ember @ CodeSandbox](https://codesandbox.io/s/github/mike-north/ember-new-output) - CodeSandbox with Ember.js.
- [Ember Octane @ CodeSandbox](https://codesandbox.io/s/octane-starter-li841) - Ember Octane CodeSandbox template.

### Screencasts

- [BuildLab: Ember.js Screencasts for the determined.](https://www.youtube.com/channel/UC1ssGKlQh87Ubyuv1lEiY0g)
- [Ember Screencasts](https://www.emberscreencasts.com/) - Weekly Screencasts for the Busy Developer.
- [EmberCasts](http://www.embercasts.com/) - Currently on hiatus whilst the author works on the next version of Handlebars.
- [EmberWatch - Screencasts](http://emberwatch.com/screencasts.html) - A collection of Ember.js screencasts.
- [Community Groups App - Creating Records in Ember CLI Mirage (part 2a)](https://www.youtube.com/watch?v=4iqNcTUXurY)
- [Community Groups App - Creating Records in Ember CLI Mirage (part 2b)](https://www.youtube.com/watch?v=eAI1LxgSOqw)
- [Community Groups App - Debugging relationships in Ember CLI Mirage (part 3)](https://www.youtube.com/watch?time_continue=1&v=DRzPJ4RMT0w)

### Slides

- [30 Days Of Ember](https://slides.com/poslinski_net/30-days-of-ember) - Dawid Pośliński.
- [NaNoWriMo: How can Ember help you write a novel](https://slides.com/emma_be/nanowrimo-ember#/) - @EmmaDelecolle.
- [Slides from Ember JS Berlin talk, Design Patterns in Ember](https://github.com/chadian/ember-js-berlin-design-patterns) - By @chadian.
- [Rainy Day Ember Data](https://speakerdeck.com/tonywok/rainy-day-ember-data) - Tony Schneider (@tonywok).
- [Building Realtime Apps with Ember.js and WebSockets](https://www.slideshare.net/BenLimmer/building-realtime-apps-with-emberjs-and-websockets) - Ben Limmer.
- [Deploying a Location-Aware Ember Application](https://www.slideshare.net/BenLimmer/deploying-a-locationaware-ember-application) -  Ben Limmer.
- [Developing Desktop Apps with Electron & Ember.js - FITC WebU2017](https://www.slideshare.net/anulman/developing-desktop-apps-with-electron-emberjs-fitc-webu2017) - Aidan Nulman.
- [Developing Desktop Apps with Electron & Ember.js](https://www.slideshare.net/fitc_slideshare/developing-desktop-apps-with-electron-emberjs)
- [Ember addons, served three ways](https://www.slideshare.net/mikelnorth/ember-addons-served-three-ways) - Mike North.
- [Ember At Scale](https://www.slideshare.net/chadhietala/ember-at-scale) - Chad Hietala, LinkedIn.
- [EmberConf 2015 – Ambitious UX for Ambitious Apps](https://www.slideshare.net/sugarpirate/emberconf-2015-ambitious-ux-for-ambitious-apps) - Lauren Elizabeth Tan.
- [EmberConf 2016 – Idiomatic Ember: Finding the Sweet Spot of Performance & Productivity](https://www.slideshare.net/sugarpirate/emberconf-2016-idiomatic-ember-finding-the-sweet-spot-of-performance-productivity) - Lauren Elizabeth Tan.
- [Fun with Ember 2.x Features](https://www.slideshare.net/BenLimmer/fun-with-ember-2x-features) - Ben Limmer.
- [How do I Even Web App](https://www.slideshare.net/lydiaguarino/how-do-i-even-web-app) - An introduction to web programming with Ember CLI by Lydia Guarino.
- [Rapid prototyping and easy testing with ember cli mirage](https://www.slideshare.net/KrzysztofBiaek1/rapid-prototyping-and-easy-testing-with-ember-cli-mirage) -  Krzysztof Bialek.
- [Start Me Up - Building an MVP with EmberJS, Firebase and Material Design](https://www.slideshare.net/PickNBook/start-me-up-building-an-mvp-with-emberjs-firebase-and-material-design) - Brendan O'Hara.
- [Upgrading Ember.js Apps](https://www.slideshare.net/BenLimmer/upgrading-emberjs-apps) - Ben Limmer.

### Styleguides

- [ember-styleguide](https://github.com/ember-learn/ember-styleguide)
- [Softlayer Ember.js](https://github.com/softlayer/ember-style-guide)
- [Netguru Ember.js](https://github.com/netguru/ember-styleguide)
- [DockYard Ember.js](https://github.com/DockYard/styleguides/blob/master/engineering/ember.md)
- [JavaScript Style Guide](https://github.com/DockYard/styleguides/blob/master/engineering/javascript.md)

### Tools

- [Ember Data Sails Adapter](https://github.com/bmac/ember-data-sails-adapter) - An Ember Data adaptor for the Sails.js sockets.
- [Ember Data WordPress Adapter](https://github.com/HeyHumanAgency/Ember-Data-WordPress) - An Ember Data adapter for the WordPress JSON API.
- [Ember Gist](http://ember-gist.joostdvrs.com/) - Demo Ember CLI'eque apps using GitHub Gist.
- [Ember Inspector](https://github.com/emberjs/ember-inspector) - Adds an Ember.js tab to Chrome or Firefox Developer Tools that allows you to inspect Ember.js objects in your application. - Officially maintained.
- [Ember Perf](https://github.com/mike-north/ember-perf) - Measure user-percieved performance data in your ember.js app.
- [ember-cli-diff](http://www.ember-cli-diff.org/) - A simple tool to see differences between new ember apps.
- [ember-cli](https://ember-cli.com/) - The command line interface for ambitious web applications.
- [ember-data-model-maker](https://andycrum.github.io/ember-data-model-maker/) - UI to make ember-data models & payload examples.
- [Glimmer Playground](https://try.glimmerjs.com/) - An Glimmer.js playground.
- [mber](https://github.com/izelnakri/mber) - Ember CLI replacement. Currently alpha.
- [remote-inspector](https://github.com/joostdevries/ember-cli-remote-inspector) - Lets you inspect apps running on different devices/browsers over the network using websockets.
- [Ember Unused Components](https://github.com/vastec/ember-unused-components) - This script searches for unused components in your Ember project

### Tutorials

- [How to learn EmberJS in a hurry](https://medium.com/ember-ish/how-to-learn-emberjs-in-a-hurry-c6fdeae256a0)
- [Discover Ember 2](https://www.ludu.co/course/ember) - Learn how to build a Twitter clone from scratch.
- [Ember Components: A Deep Dive](http://code.tutsplus.com/tutorials/ember-components-a-deep-dive--net-35551) - A closer look at using Ember.js Components.
- [Ember runloop handbook](https://github.com/eoinkelly/ember-runloop-handbook) - A deep dive into the Ember.js runloop.
- [Ember with Phoenix (AKA The PEEP Stack)](https://medium.com/peep-stack) - Developing an Ember.js front-end alongside a [JSON API](http://jsonapi.org/)-compliant [Phoenix](http://www.phoenixframework.org/) backend.
- [Getting into Ember.js](http://code.tutsplus.com/tutorials/getting-into-emberjs--net-30709) - A five part introductory course to Ember.
- [Getting Started with Ember.js using Ember CLI](https://thetechcofounder.com/getting-started-with-ember/) - Building a Todo app with Ember CLI.
- [yoember.com/](http://yoember.com/) - Ember.js Tutorial - From beginner to advance.
- [build-pacman](http://www.jeffreybiles.com/build-pacman)

### Twitter

- [EmberJS](https://twitter.com/emberjs)
- [The Ember Times](https://twitter.com/embertimes)
- [Ember Watch](https://twitter.com/EmberWatch)
- [Ember Weekly](https://twitter.com/EmberWeekly)

- [Tom Dale](https://twitter.com/tomdale)
- [Yehuda Katz](https://twitter.com/wycats)
- [Melanie Sumner](https://twitter.com/melaniersumner)
- [Jen Weber](https://twitter.com/jwwweber)
- [Robert Jackson](https://twitter.com/rwjblue)
- [Stefan Penner](https://twitter.com/stefanpenner)
- [Matthew Beale](https://twitter.com/mixonic)
- [Chris Thoburn](https://twitter.com/Runspired)
- [Chris Garrett](https://twitter.com/pzuraq)
- [Alex Navasardyan](https://twitter.com/twokul)
- [Igor Terzic](https://twitter.com/terzicigor)
- [Dan Gebhardt](https://twitter.com/dgeb)

- [Alex Speller](https://twitter.com/alexspeller)
- [Sam Selikoff](https://twitter.com/samselikoff)
- [Erik Bryn](https://twitter.com/ebryn)
- [Gavin Joyce](https://twitter.com/gavinjoyce)
- [Ryan Toronto](https://twitter.com/ryantotweets)
- [Balint Erdi](https://twitter.com/baaz)
- [Luke Melia](https://twitter.com/lukemelia)

### Videos

- [Working with Ember Animated & Addon Internals: Ember Concurrency – Ember NYC, May 2019](https://www.youtube.com/watch?v=JbxaVHQFou0)
- [Ember.js Tutorial: Build a painting game in 20 mins](https://www.youtube.com/watch?v=N4KrBuO0RRE)
- [Ember-cli In-Repo Addons with Jacob Bixby](https://www.youtube.com/watch?v=VYrMs1Zzpqs)
- [Maintaining an Ember App at Scale, with Chris Ng](https://www.youtube.com/watch?v=gyGZHydh0Hw&feature=em-uploademail)
- [Jackie Luo: From React to Ember: A Modern Comparison](https://www.youtube.com/watch?v=7yxr4iBrZsw)
- [Ember San Francisco Meetup at Square, October 2018](https://www.youtube.com/watch?v=ulWhjL0Aj5s)
- [The Future of Ember js](https://www.youtube.com/watch?v=4b9VbB2bnfw) - Summary of upcoming changes to Ember.js based on presentations from EmberConf 2018.
- [Ember: The Next 10 Years | Tom Dale | EmberCamp Chicago 2018](https://www.youtube.com/watch?v=9cseB2xoT-0)
- [Stop Coding: You Have a Product Gap | Sam Selikoff | EmberCamp Chicago 2018](https://www.youtube.com/watch?v=fYHgyIlGttk)
- [Caveats of the Default Store - Ember London - September 2018](https://www.youtube.com/watch?v=EcKaDu0xo_A)
- [EmberFest 2019](https://www.youtube.com/playlist?list=PLN4SpDLOSVkT0e094BZhGkUnf2WBF09xx)
- [EmberFest 2018](https://www.youtube.com/watch?v=oRzmDobMZ_Q&list=PLN4SpDLOSVkSB9034lDNdP1JoNBGssax9)
- [EmberFest 2014](https://www.youtube.com/watch?v=z4oxa-UR7oA&list=PLN4SpDLOSVkSbGTLohVaYGDB8hxWxGPBA)
- [Global Ember Meetup](https://vimeo.com/globalembermeetup)
- [Ember @ Netflix](https://pusher.com/sessions/meetup/emberfest/ember-netflix)
- [Ember Engines at Scale](https://pusher.com/sessions/meetup/ember-london/ember-engines-at-scale)
- [Ember Test Recorder](https://pusher.com/sessions/meetup/ember-london/ember-test-recorder)
- [Ember-cli In-Repo Addons with Jacob Bixby](https://www.youtube.com/watch?v=VYrMs1Zzpqs)
- [ember-content-placeholders](https://pusher.com/sessions/meetup/emberfest/ember-content-placeholders)
- [Ember.JS in the Year 2020](https://pusher.com/sessions/meetup/emberfest/emberjs-in-the-year-2020)
- [EmberConf 2014](https://www.youtube.com/playlist?list=PLE7tQUdRKcyaOyfBnAndJxQ9PNVmKva0d) - Videos of the sessions from EmberConf 2014.
- [EmberConf 2015](https://www.youtube.com/playlist?list=PLE7tQUdRKcyacwiUPs0CjPYt6tJub4xXU) - Videos of the sessions from EmberConf 2015.
- [EmberConf 2016](https://www.youtube.com/playlist?list=PL4eq2DPpyBblc8aQAd516-jGMdAhEeUiW) - Videos of the sessions from EmberConf 2016.
- [EmberConf 2017](https://www.youtube.com/playlist?list=PL4eq2DPpyBbna_5fLPqOqensqSZpGf-hT) - Videos of the sessions from EmberConf 2017.
- [EmberConf 2018](https://www.youtube.com/watch?v=NhtpXs0ZtUc&list=PL4eq2DPpyBbnjD5iLp55as9OvIdEDI_Kt) - Videos of the sessions from EmberConf 2018.
- [EmberConf 2019](https://www.youtube.com/playlist?list=PLE7tQUdRKcyYWLWrHgmWsvzsQBSWCLHYL) - Videos of the sessions from EmberConf 2019.
- [EmberConf 2020](https://www.youtube.com/playlist?list=PL4eq2DPpyBbkC03mdzlyej6tcbEqrZK8N) - Videos of the sessions from EmberConf 2020.
- [ReactiveConf 2017 - Tom Dale: Secrets of the Glimmer VM](https://www.youtube.com/watch?v=nXCSloXZ-wc)
- [ReactiveConf 2017](https://youtu.be/62xd25kEZ3o?t=27618)
- [Tim Thomas - Using Ember.js to build Electron Apps](https://www.youtube.com/watch?v=ER1V_u0N7u4)
- [Tom Dale on Static Analysis, Upstreaming Glimmer, and Ember in 2018](https://embermap.com/topics/the-embermap-podcast/tom-dale-on-static-analysis-upstreaming-glimmer-and-ember-in-2018)
- [Tom Dale Talks EmberJS](https://www.slideshare.net/LinkedInPulse/tom-dale-ember-javascript-emberjs-linkedin)
- [Using TypeScript in Ember](https://pusher.com/sessions/meetup/ember-london/using-typescript-in-ember)
- [Web App Performance & Ember.js](https://www.youtube.com/watch?v=BelKk7dvA1A) - Web App Performance & Ember.js.
- [Why Ember CLI uses Broccoli](https://embermap.com/topics/intro-to-broccoli/why-ember-uses-broccoli)
- [Developing ember apps on glitch.com](https://www.youtube.com/watch?v=uhXA6ECaknw)
- [Chris Krycho: TypeScript and Ember js - Why and How?](https://www.youtube.com/watch?v=fFzxbBrvytU)
- [Isaac Lee: Use D3 with Ember](https://www.youtube.com/watch?v=vD7H9O--tu4)
- [Open Source Live - Robert Jackson and Chris Manson pair on ember-cli](https://www.youtube.com/watch?v=rsftBMGOfyo)
- [Must have add-ons in EmberJS - Dawid Pośliński](https://www.youtube.com/watch?v=IprfNT0xbrI)
- [Building Modern Apps Using API Services - Ember Meetup August 21, 2018](https://www.youtube.com/watch?v=VMnzGJ4PN0s)
- [How to improve your tests? - Paweł Kuwik](https://www.youtube.com/watch?v=rs71sx5IZ-U&t=0s&list=PLxt6MasYELQ5W3y8rwGa98GsyMBdhr_cp)
- [Optional & upcoming features - Michał Staśkiewicz](https://www.youtube.com/watch?v=4XokzPT4rgg&t=0s&list=PLxt6MasYELQ5W3y8rwGa98GsyMBdhr_cp)
- [Hybrid Apps with Ember/Glimmer](https://pusher.com/sessions/meetup/emberfest/hybrid-apps-with-emberglimmer)
- [Productive Frontend Test Driven Development That Actually Works](https://www.youtube.com/watch?v=63Ya91f8W-8)
- [EmberCamp 2018](https://www.youtube.com/watch?v=0ziETDm1QTI&list=PL4eq2DPpyBbm-vTgHMdBjUi1Qd5GiRIfW) - Videos of the sessions from EmberCamp 2018
- [EmberCamp 2019](https://www.youtube.com/watch?v=a1HALof3r5M&list=PL4eq2DPpyBbmSKZLCqzMqdtpedlGrDQuc) - Videos of the sessions from EmberCamp 2019
- [Ember.js: The Documentary](https://www.youtube.com/watch?v=Cvz-9ccflKQ&vl=en)
- [Ember.js: The Documentary (Русская версия)](https://www.youtube.com/watch?v=7Ym2ADCn77Q) - Russian langauge version
- [GraphQL: The Documentary](https://www.youtube.com/watch?v=783ccP__No8&vl=en)
- [GraphQL: The Documentary (Русская версия)](https://www.youtube.com/watch?v=i_rsfHMF3x4) - Russian language version
- [Ember and GraphQL: A Quick Example](https://www.youtube.com/watch?v=YxRvXgDIHW8)
- [Ember Octane Livestream: Build a drum machine](https://www.youtube.com/watch?v=5znpEiwHpL4)
- [Tracking in the Glimmer VM](https://www.youtube.com/watch?v=BjKERSRpPeI) - Chris Garrett discusses how tracking works in Ember
- [Commit Porto '19: Thriving through the hype cycle: an Ember.js story (Ricardo Mendes)](https://www.youtube.com/watch?v=ECkbVa0iC4k)
- [Animating Across Routes with Ember Animated](https://www.youtube.com/watch?v=O4Mt-dDqkk0) - EmberMap video adding across-route tranistion animations
- [Creating an Ember Application](https://www.youtube.com/watch?v=R2JdP4lb5Xw) - First in an upcoming series on Ember
- [Ember and GraphQL: A Quick Example](https://www.youtube.com/watch?v=YxRvXgDIHW8)
- [Stef & Rob: do we still need the built-in Input component?](https://www.youtube.com/watch?v=c0Rl6o9wLX0) Stefan Penner and Robert Jackson debate the built-in Input component
- [Ember Octane - Great For Beginners](https://www.youtube.com/watch?v=iTPFsXcTAaY&feature=youtu.be) - You can just write HTML and CSS and get pretty far with Ember Octane
- [Yet Another Test Runner by Kelly Sheldon @ Ember London](https://www.youtube.com/watch?v=HYwXL3f854Y&list=PL4eq2DPpyBbmvEzhyW9fhMzlctxwrn8JM&index=1)


### YouTube channels

- [Amsterdam Ember.js](https://www.youtube.com/channel/UCx9sVlEZLOKxw8OGCtoqULw)
- [Boston Ember](https://www.youtube.com/channel/UCp_L_YjmXTKR4Q2fg1XahsA)
- [Denver Ember](https://www.youtube.com/channel/UCsy4OVL_kNXsxr0a5LNKWpw)
- [Ember Videos](https://www.youtube.com/channel/UCMmzJ82sCmooDdtzVY8FxEA)
- [EmberJS Chennai](https://www.youtube.com/channel/UC-PzS1OA64zFD2kt3hwfGTA)
- [Ember.js Dublin](https://www.youtube.com/channel/UCQeD0i9ltSV1aOfX6FGeiOA)
- [EmberATX](https://www.youtube.com/channel/UCl7qY85b7KLJV3xnn1Xh_Cw)
- [EmberJSSeattleMeetup](https://www.youtube.com/channel/UC_EzRy1fCQPRPOD-uqk-E5w)
- [EmberSchool](https://www.youtube.com/channel/UCntNIA2acwPDIY77bX2uLmw)
- [EmberSherpa](https://www.youtube.com/user/EmberSherpa/videos)
- [Meetup: London](https://www.youtube.com/playlist?list=PL4eq2DPpyBbmvEzhyW9fhMzlctxwrn8JM)
- [Silicon Valley Ember.js meetup](https://www.youtube.com/channel/UCi12gVD9jIDwJLVTNnKvhlw)
- [So Ember 2017](https://www.youtube.com/watch?v=UpUtVGW43hY&list=PLXOJZupxSq204IxtG80UfIW-gU0IxAScY)
- [Wicked Good Ember 2016](https://www.youtube.com/playlist?list=PLXOJZupxSq22zfW2KVnXFgLbu--DA7q0G)
- [May I ask a Question](https://www.youtube.com/channel/UCyErLHzPqLAkL1F-SivFDcA)

### YouTube playlists
- [Ember London 2018](https://www.youtube.com/watch?v=EcKaDu0xo_A&list=PL8xuokhAnn4rUlol6aspg-VYetu9BLsWV)
- [Intercom Screencasts](https://www.youtube.com/playlist?list=PLpAr6J-75N27wctNT70O0lubaGTPjwi1L)
- [Ember.js tutorial for beginners in 2020](https://www.youtube.com/watch?v=eQUvN9Ujs1s&list=PLk51HrKSBQ88wDXgPF-QLMfPFlLwcjTlo) - A 10 part series by Shawn Chen

## License

[CC0](https://github.com/ember-community-russia/awesome-ember/blob/master/./LICENSE)
