<div class="github-widget" data-repo="jonathandion/awesome-emails"></div>
<h1 align="center">
AWESOME EMAILS ✉ ✨
</h1>
<h4 align="center">
 A collection of awesome frameworks, templates, tools, workflows and many more to build better emails.
</h4>
<p align="center" style="text-align: center;">
<a href="https://awesome.re"><img src="https://awesome.re/badge.svg" alt="Awesome"></a>
<a href="https://twitter.com/@0xjdion"><img src="https://img.shields.io/twitter/url/https/twitter.com/blueaquilae.svg?style=social&amp;label=Follow%20%400xjdion" alt="Jonathan Dion Twitter"></a>
</p>



## Frameworks

### React

- [React Email](https://react.email/) - A collection of high-quality, unstyled components for creating beautiful emails using React and TypeScript.
- [Mailing](https://www.mailing.run/) - Build emails in React, send from anywhere.
- [JSX-email](https://jsx.email/) - JSX Mail is an email framework that uses React to create email templates. 

### Misc

- [MJML](https://mjml.io) - MJML is a markup language designed to reduce the pain of coding a responsive email.
- [Foundation for Emails](https://github.com/zurb/foundation-emails) - Quickly create responsive HTML emails that work on any device & client. Even Outlook.
- [Email Framework](http://emailframe.work/) - The HTML email framework developed to help you build responsive HTML email.
- [HEML](https://heml.io) - HEML is an open source markup language for building responsive email.
- [Acorn](https://docs.thememountain.com/acorn/) - A responsive email framework based on a golden ratio typography grid.
- [Pine](https://docs.thememountain.com/pine/) - A 12 column grid, responsive email framework.
- [Maizzle](https://maizzle.com) - Quickly build HTML emails with Tailwind CSS.

## Cheatsheets

- [Rico's cheatsheet](https://devhints.io/html-email) - Rico's cheatsheet for HTML email.

## Templates

- [Cerberusemail](https://www.cerberusemail.com/) - Patterns for Responsive HTML Email Templates.
- [Responsive templates](https://templates.emailoctopus.com/) - Free HTML templates from EmailOctopus, usable with any provider.
- [Campaign](https://github.com/bevacqua/campaign) - Compose responsive email templates easily, fill them with models, and send them out.
- [Sendwithus](https://www.sendwithus.com/resources/templates) - Open source email templates.
- [Mailchimp Email Blueprints](https://github.com/mailchimp/Email-Blueprints) - Email Blueprints is a collection of HTML email templates that can serve as a solid foundation and starting point for the design of emails.
- [Campaign Monitor Templates](https://www.campaignmonitor.com/email-templates/) - Easily create beautiful, branded email marketing campaigns.
- [Responsive Transactional HTML Email Templates](https://github.com/mailgun/transactional-email-templates) - Each template is responsive and each has been tested in all the popular email clients.
- [Cerberus](https://github.com/TedGoas/Cerberus) - Few responsive email patterns.
- [Antwort](https://github.com/internations/antwort) - Antwort offers responsive layouts for Email that both fits and adapts to client widths.
- [Responsive HTML Template](https://github.com/charlesmudy/responsive-html-email-template) - This template is designed to work on all major email platforms and it is built with media query, making it responsive for smartphones that supports media query.
- [HTML Email Templates](https://www.htmlemailtemplates.net/) - Responsive HTML email templates for Startups & SaaS.
- [Free Responsive template : Slate](https://litmus.com/resources/free-responsive-email-templates/) - Five pre-tested templates that work with any mailing service.
- [Grunt Email Boilerplate](https://github.com/dwightjack/grunt-email-boilerplate) - A Grunt template to create emails.
- [Responsive Email Patterns](http://responsiveemailpatterns.com/) - A collection of patterns & modules for responsive emails.
- [Email boilerplate](https://github.com/seanpowell/Email-Boilerplate) - The email boilerplate for sending out nicely formatted messages.
- [htmlemail](https://htmlemail.io/) - Responsive HTML email templates for startups & developers.
- [Postmark Transactional Email Templates](https://github.com/wildbit/postmark-templates) - Rock-solid email templates for applications.
- [Stripo](https://stripo.email/templates/) - Rich set of responsive, interactive beautiful email templates with Stripo.
- [Postcards](https://designmodo.com/postcards/) - Design responsive email templates online without coding knowledge.
- [Lee Munroe's Grunt Email Design](https://github.com/leemunroe/grunt-email-workflow) - A Grunt workflow for designing and testing responsive HTML email templates with SCSS.

## Tools

- [Can I Email](https://www.caniemail.com/) - Can I email… Support tables for HTML and CSS in emails.
- [Topol](https://topol.io/) - Create stunning responsive HTML e-mails in a minute.
- [MJML Desktop App](https://mjmlio.github.io/mjml-app/) - MJML official desktop app.
- [Rollover](http://freshinbox.com/tools/rollover/) - Generates code for a Rollover Image that displays an alternative image when the email recipient hovers the cursor over the image.
- [Bulletproof Email Buttons](http://buttons.cm/) - Design gorgeous buttons using progressively enhanced VML and CSS.
- [Bulletproof Background Images](http://backgrounds.cm/) - Create rock-solid background images for your HTML email with some help from VML and CSS.
- [Stripo.email](https://stripo.email/) - Online drag-n-drop and HTML email builder to create professional and responsive email templates fast without any HTML skills.
- [MySigMail Card](https://mysigmail.com/card/) - A free drag & drop builder helps you create email templates intuitively and very quickly.
- [TestSubject](http://zurb.com/playground/testsubject) - Test How Your Email Subject Lines Appear On The Most Popular Mobile Devices.
- [MailSpice analytics](https://mailspice.com) - Email analytics add-on for all email services that provides deep insights into all of your email campaigns (works with all ESPs).
- [Alter.email](https://alter.email/) - A free tool to help you inline CSS, remove unused CSS, clean up your text, add extra attributes to tags, add URL tracking parameters, minify, and even prettify HTML email.
- [Sensitive Subjects](https://sensitivesubjects.com/) - Never send an embarrassing subject line!
- [Detergent](https://detergent.io) - A tool to prepare the text for pasting into HTML: removes invisible Unicode characters (like [ETX](https://www.fileformat.info/info/unicode/char/0003/index.htm) which can come from PSD files), encodes special characters (like turning £ into `&pound;`) and improves typography.
- [EmailComb](http://emailcomb.com/) - Email-friendly unused CSS removal tool which does not parse and thus accepts mixed sources, including your ESP templating tags. Extras: CSS uglification and HTML/CSS minification (powered by HTML Crush).
- [HTML Crush](https://htmlcrush.com/) - Email-friendly HTML minifier: limits lines to 500 chars. (best practice), respects Outlook conditional tags and accepts mixed sources, including ESP templating tags. Optionally, can only remove indentations (not touching line breaks).
- [Tabifier](https://tools.arantius.com/tabifier) - Opposite of HTML Crush - a tool to beautify the indentation in HTML files. Works with mixed input sources, including your ESP templating tags.
- [Email Link Builder](https://email-link-builder.samcarlton.com/) - Make mailto links that open email drafts with prefilled Recipients, Subject, Body and more.
- [email-verifier](https://github.com/AfterShip/email-verifier) - A tool for email verification without sending any emails.
- [DevMail](https://devmail.email/) - An email sandbox for software developers. Capture emails from your dev, staging, QA, or CI environment.
- [Disposable Email Check API](https://open.kickbox.com/) - A free API for checking if an email address is disposable. No sign up required.

## Services

- [Resend](https://resend.com/) - Build, test, and send transactional emails at scale.
- [EmailOctopus](https://emailoctopus.com) - Email marketing made easy.
- [Mailchimp](https://mailchimp.com/) - MailChimp provides email marketing for more than 15 million people globally.
- [Mailjet](https://mailjet.com/) - all-in-one Email Services Provider that allows businesses to send Marketing, Transaction Email and Email Automation.
- [Mailscribe Mailmaker](https://mailscribe.com/page/mailmaker) - AI-powered email marketing platform that allows to design email with built-in components.
- [Campaign monitor](https://www.campaignmonitor.com/) - Campaign Monitor makes it easy for you to create, send, and optimize your email marketing campaigns.
- [Sendgrid](https://sendgrid.com/) - Delivering your transactional and marketing email through one reliable platform.
- [Postal](https://github.com/atech/postal) - A fully featured open source mail delivery platform for incoming & outgoing e-mail.
- [SparkPost](https://www.sparkpost.com/) - Your application’s emails: Delivered on time and to the inbox.
- [Mautic](https://mautic.com/) - Mautic Marketing Automation. Build smarter campaigns – and build them faster – with marketing automation that’s quick to learn, simple to use, and easy to iterate.
- [Mailgun](https://www.mailgun.com/) - Transactional Email API Service For Developers.
- [eSputnik](https://esputnik.com/en) - eSputnik is a marketing automation system trusted by more than 30 thousand loyal customers worldwide to send more than a billion emails every month.
- [Postmark](https://postmarkapp.com) - Lightning fast delivery for your application emails. Postmark delivers your transactional email to customers on time, every time.
- [ImprovMX](https://improvmx.com/) - Create free email aliases for your domain name.
- [Reacher](https://reacher.email) - Check if an email exists without sending any email. Written in Rust, 100% open-source.
- [Kickbox](https://kickbox.com) - Email verification service (check an email exists).
- [Forward Email](https://forwardemail.net) - The 100% open-source and privacy-focused email service.
- [Campaign Cleaner](https://campaigncleaner.com) - The Ultimate Tool for Optimized, High-Performance Email Campaigns.
- [ForwardMX](https://forwardmx.net) - Premium email forwarding for your domain name.
- [Heybounce](https://www.heybounce.io) - Email verification service that checks if an email exists and detects disposable emails.

## Self-Hosted Services

- [Cloud Seeder](https://ipv6.rs/cloudseeder) - 1-click Install and Upgrade a Postfix+Dovecot or Stalwart mail server instance, hands free.
- [iRedMail](https://iredmail.org/) - Easy to install open source mail server solution.
- [Mail-in-a-box](https://mailinabox.email/) - Lets you become your own mail service provider in a few easy steps.
- [Mailcow](https://mailcow.email/) - The mailserver suite with the 'moo'. An easy to use dockerized selfhosted email solution.
- [Mailtrain](https://mailtrain.org/) - Self Hosted Newsletter App Built on Top of Nodemailer.
- [Mautic](https://mautic.org/) - Mautic Marketing Automation. Build smarter campaigns – and build them faster – with marketing automation that’s quick to learn, simple to use, and easy to iterate.
- [Modoboa](https://modoboa.org/) - A solution to quickly deploy and manage a complete email server, compatible with latest standards and optimized for delivery and reputation protection.
- [Poste.io](https://poste.io/) - Complete mailserver built in one docker container.
- [SimpleLogin](https://github.com/simple-login/app) - Self-hosted email alias solution.

## Articles

- [My Wonderful HTML Email Workflow](https://www.joshwcomeau.com/react/wonderful-emails-with-mjml-and-mdx/) - My Wonderful HTML Email Workflow, using MJML and MDX for responsive emails.
- [Email Design Workflow](http://www.leemunroe.com/email-design-workflow/) - An email design workflow by By Lee Munroe.
- [Composing better emails](https://iridakos.com/how-to/2019/06/26/composing-better-emails.html) - Tips for writing effective emails.
- [Darylldoyle Gulp workflow](https://github.com/darylldoyle/Gulp-Email-Creator) - Gulp Email Creator is a gulp workflow inspired by Lee Munroe's grunt-email-design workflow.
- [Html Email Development Workflow](http://www.sitepoint.com/my-current-html-email-development-workflow/) - A Typical Email Development Workflow by Sitepoint.

## Design

- [CSS Support](https://www.campaignmonitor.com/css/) - A complete breakdown of the CSS support for every popular mobile, web and desktop email client on the planet.
- [Email Template Guide](https://blocksedit.com/email-template-guide/) - Using a modular email template system.
- [Mail Servers Best Pratices](https://documentation.mailgun.com/best_practices.html#email-best-practices) - This guide is a brief summary of email best practices that we have learned from managing mail servers.
- [Stylecampaign](http://stylecampaign.com/blog/2014/02/responsive-email-navigation/) - I looked at the navigation of 50 responsive retail emails. Here is a breakdown of the patterns I discovered.

## Blogs

- [EmailOctopus Blog](https://emailoctopus.com/blog/)
- [Litmus Blog](https://litmus.com/blog/)
- [Stylecampaign Blog](http://stylecampaign.com/blog/)
- [Myemma Blog](http://myemma.com/content-hub)
- [Postmarkapp Blog](http://blog.postmarkapp.com/)
- [Spently Blog](https://blog.spently.com/)
- [Emailmonks Blog](http://www.emailmonks.com/blog/)
- [Stripo.email Blog](http://www.emailmonks.com/blog/) - Email Marketing & Email Design Blog.
- [HTML Email Blog](https://htmlemail.io/blog/)
- [Build Better Blog](https://blocksedit.com/content-code/) - Design and content production in email marketing.
- [Email Design Blog](https://designmodo.com/design/email-design/) - Articles, tutorial, inspiration for all email geeks.

## Resources

- [Email marketing regulations](https://github.com/threeheartsdigital/email-marketing-regulations) - A guide to email marketing regulations around the world.
- [Email toolbox](http://email-toolbox.com/) - Hand-picked resources for email marketers and designers.
- [Mailchimp](http://mailchimp.com/resources/) - Super awesome resources from Mailchimp.
- [Litmus Resources](https://litmus.com/resources) - Stay up to date with the latest email news and trends with Litmus resources.
- [Campaign Monitor Resources](https://www.campaignmonitor.com/resources/) - Campaign Monitor resources will turn you into an expert in no time.
- [Campaign Monitor Dev Resources](https://www.campaignmonitor.com/dev-resources/)
- [Mailchimp](http://templates.mailchimp.com/) - Mailchimp Email Design Reference.
- [Arstechnica](https://arstechnica.com/information-technology/2014/02/how-to-run-your-own-e-mail-server-with-your-own-domain-part-1/) - Tutorial on how to build your own email server.
- [Mailmodo](https://www.mailmodo.com/email-templates/)- Mega Email Template Library, from where you can get the template for free or customize your own Email Templates

## Inspirations

- [Email Copy](http://www.goodemailcopy.com/) - Email copy from great companies.
- [Really good emails Codepen](http://codepen.io/reallygoodemails/)
- [Really good emails](http://reallygoodemails.com/) - The Best Email Designs in the Universe.
- [TidyMails](http://tidymails.com/) - The Email Newsletters' Universe.
- [Milled](http://milled.com/)
- [The Top Email Campaigns](https://www.campaignmonitor.com/best-email-marketing-campaigns/) - The most effective email marketing campaigns from Campaign Monitor.
- [Htmlemaildesigns](http://htmlemaildesigns.com/) - Beautiful emails to help inspire your next email design.
- [WhoSentWhat](http://whosentwhat.com) - We bring email newsletters from inbox to web

## Statistics

- [Myemma Email Stats](http://myemma.com/brainiac/gate-free-stats) - 18 must-know stats for modern email marketers by Emma, Inc.
- [Mailchimp Research](http://mailchimp.com/resources/research/) - Mailchimp's researchers are constantly analyzing data to help you make the most of your email campaigns.
- [Campaign Monitor 2015 Report](https://www.campaignmonitor.com/resources/guides/email-marketing-new-rules/) - 2015 Report: The new rules of email marketing.
- [Campaign Monitor 2016 Report](https://www.campaignmonitor.com/company/annual-report/2016/) - 2016 Report: Campaign Monitor 2016 Year in Review.

## Testing

- [PutsMail](https://putsmail.com/) - Free tool to test your HTML emails before sending them!
- [Litmus](https://litmus.com/) - Test and track your emails with Litmus.
- [Campaign Monitor](https://www.campaignmonitor.com/testing/) - Test your design in all the different email client with Campaign Monitor.
- [Grunt Litmus](https://www.npmjs.com/package/grunt-litmus) - Send email tests to Litmus with grunt.
- [Gulp Litmus](https://www.npmjs.com/package/gulp-litmus) - Send email tests to Litmus with gulp.
- [MailTrap](https://mailtrap.io) - A Fake SMTP Server to Test, View and Share emails without spamming real customers.
- [testmail.app](https://testmail.app) - A fake SMTP server with unlimited mailboxes and a GraphQL API for automating end-to-end tests.
- [MailHog](https://github.com/mailhog/MailHog) A local fake SMTP server (based on Go).
- [MailCatcher](https://mailcatcher.me/) A local fake SMTP server (based on Ruby).
- [Email Privacy Tester](https://www.emailprivacytester.com/) - A tool to test your email client's priacy features (loading remote content).
- [Mail Tester](https://www.mail-tester.com/) - Test the spammyness of your emails.
- [Mailsnag](https://mailsnag.com/) - Test email server for all of your SMTP needs - simulate delay and errors, preview and share emails, and more - all without sending emails to actual customers.
- [Email Spam Tester](https://kickbox.com/email-spam-tester/) - Free tool to check to see if your email will end up in the spam folder.

## Learning

- [Responsive HTML Email Design](https://frontendmasters.com/courses/responsive-email/) - Responsive email course by Justine Jordan and Jason Rodriguez.
- [Mastering HTML Email](http://webdesign.tutsplus.com/series/mastering-html-email--webdesign-17696) - This series of tutorials will take you through the fundamentals, exploring development techniques, workflow and design approaches.
- [Building Responsive Email Templates with Ink](https://scotch.io/tutorials/building-responsive-email-templates-with-ink) - Building Responsive Email Templates with Ink.
- [Litmus learning](https://litmus.com/community/learning) - Litmus learning resources.

<hr>

### Contribution

Suggestions and PRs are welcome! 🤙
If you want to contribute, please read the [contribution guidelines](https://github.com/jonathandion/awesome-emails/blob/master/contributing.md).

### Check Also

- [Awesome JS Books](https://github.com/jonathandion/awesome-js-books) - This is a curated list of all the best JavaScript books.
- [Web Configs](https://github.com/jonathandion/web-configs) - Monorepo for all common configurations for building web apps.
- [My Neovim Config](https://github.com/jonathandion/web-dev.nvim) - Small Neovim configuration written in Lua that is specifically designed for web development.

### License
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)
