<div class="github-widget" data-repo="sindresorhus/awesome-electron"></div>
## Awesome Electron [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/sindresorhus/awesome-electron/master/electron-logo.svg?sanitize=true" align="right" width="100">](https://electronjs.org)

> Useful resources for creating apps with [Electron](https://electronjs.org)

Electron is an open-source framework for creating desktop apps using web technologies. It combines the Chromium rendering engine and the Node.js runtime.

<br>

---

<br>
<br>
<div align="center">
	<sub>Check out my macOS app</sub>
	<br>
	<h2>
		<a href="https://sindresorhus.com/menu-bar-spacing">Menu Bar Spacing</a>
		<br>
		<sup>Customize the gap between menu bar items on macOS</sup>
	</h2>
</div>
<br>
<br>

---

<br>



## Apps

Made with Electron.

### Open Source

###### Featured

- [WebTorrent](https://github.com/feross/webtorrent-app) - Streaming torrent client.
- [Min](https://github.com/minbrowser/min) - Minimal web browser.
- [Hyper](https://github.com/zeit/hyper) - Terminal.
- [Visual Studio Code](https://github.com/Microsoft/vscode) - Cross-platform IDE.

###### Other

- [Git-it](https://github.com/jlord/git-it-electron) - Teaches you Git and GitHub.
- [Caprine](https://github.com/sindresorhus/caprine) - Unofficial Facebook Messenger app.
- [Simplenote](https://github.com/Automattic/simplenote-electron) - Note keeper.
- [Abricotine](https://github.com/brrd/Abricotine) - Markdown editor with inline preview.
- [Kap](https://github.com/wulkano/kap) - Screen recorder with GIF support.
- [Medis](https://github.com/luin/medis) - Redis database management.
- [SmartMirror](https://github.com/evancohen/smart-mirror) - Voice controlled smart mirror.
- [Beaker](https://github.com/beakerbrowser/beaker) - Browser with peer-to-peer web protocols.
- [KeeWeb](https://github.com/keeweb/keeweb) - Unofficial KeePass app.
- [Gitify](https://github.com/manosim/gitify) - GitHub notifications in your menubar.
- [SpaceRadar](https://github.com/zz85/space-radar) - Interactive disk space and memory visualization.
- [Leanote](https://github.com/leanote/desktop-app) - Cloud notepad.
- [Loop Drop](https://github.com/mmckegg/loop-drop-app) - MIDI looper and synth for live electronic music performances.
- [Pomodoro](https://github.com/G07cha/pomodoro) - Timer based on the Pomodoro Technique.
- [Sia-UI](https://gitlab.com/NebulousLabs/Sia-UI) - Decentralized file storage system based on cryptocurrency technology.
- [MarkRight](https://github.com/dvcrn/markright) - GitHub flavored Markdown editor with live preview.
- [Sqlectron](https://github.com/sqlectron/sqlectron-gui) - SQL client.
- [Light Table](https://github.com/LightTable/LightTable) - Code editor with instant feedback.
- [Google Play Music Desktop Player](https://github.com/MarshallOfSound/Google-Play-Music-Desktop-Player-UNOFFICIAL-) - Unofficial Google Play Music app.
- [Chrome DevTools](https://github.com/auchenberg/chrome-devtools-app) - Chrome DevTools packaged as an app.
- [Proton](https://github.com/steventhanna/proton) - Markdown editor with live preview.
- [Hawkpass](https://github.com/kalpetros/hawkpass) - Password generator.
- [Boostnote](https://github.com/BoostIO/Boostnote) - Markdown note & code snippet app for developers.
- [Before Dawn](https://github.com/muffinista/before-dawn) - Screensaver tool.
- [Catify](https://github.com/MeoBeoI/Catify) - Utility for Spotify.
- [Ansel](https://github.com/m0g/ansel) - Image organizer.
- [Tockler](https://github.com/MayGo/tockler) - Tracks your time.
- [Mattermost](https://github.com/mattermost/desktop) - Mattermost client.
- [Crypter](https://github.com/HR/Crypter) - Secure encryption client.
- [YakYak](https://github.com/yakyak/yakyak) - Unofficial Google Hangouts app.
- [Museeks](https://github.com/KeitIG/museeks) - Music player.
- [Sabaki](https://github.com/SabakiHQ/Sabaki) - Go/Baduk/Weiqi board.
- [Wire](https://github.com/wireapp/wire-desktop) - Messenger and calling app.
- [Extraterm](https://github.com/sedwards2009/extraterm) - Terminal.
- [Stacer](https://github.com/oguzhaninan/Stacer) - Ubuntu system optimizer.
- [Inpad](https://github.com/sarah-seo/Inpad) - Notes app with GitHub-flavored Markdown.
- [Cerebro](https://github.com/KELiON/cerebro) - Launcher with inline previews.
- [LosslessCut](https://github.com/mifi/lossless-cut) - Lossless video trimming & cutting.
- [Buka](https://github.com/oguzhaninan/Buka) - E-book management.
- [Insomnia](https://github.com/getinsomnia/insomnia) - Create and manage HTTP requests.
- [Tusk](https://github.com/champloohq/tusk) - Unofficial Evernote app.
- [Buttercup Desktop](https://github.com/buttercup/buttercup-desktop) - Password manager.
- [Mailspring](https://github.com/Foundry376/Mailspring) - Extensible email client. (Fork of Nylas Mail)
- [Headset](https://github.com/headsetapp/headset-electron) - Discover, collect, and listen to music from YouTube.
- [Nuclear](https://github.com/nukeop/nuclear) - Music player that streams from free sources.
- [Mark Text](https://github.com/marktext/marktext) - Real-time preview Markdown editor.
- [Pomotroid](https://github.com/Splode/pomotroid) - Pomodoro timer.
- [Netron](https://github.com/lutzroeder/netron) - Visualizer for deep learning and machine learning models.
- [Etcher](https://github.com/resin-io/etcher) - Flash OS images to SD cards and USB drives.
- [Notable](https://github.com/fabiospampinato/notable) - Markdown-based note-taking.
- [Unsplash Wallpapers](https://github.com/soroushchehresa/unsplash-wallpapers) - Set desktop wallpaper from Unsplash.
- [Motrix](https://github.com/agalwood/Motrix) - Download manager.
- [Franz](https://github.com/meetfranz/franz) - Skype, Slack, Hangouts, WhatsApp, Grape, Telegram, FB Messenger, Hipchat in the same app.
- [Gmail Desktop](https://github.com/timche/gmail-desktop) - Unofficial Gmail app.
- [Upcount](https://github.com/madisvain/upcount) - Invoicing.
- [ExifCleaner](https://github.com/szTheory/exifcleaner) - Clean image metadata with drag and drop.
- [massCode](https://github.com/antonreshetov/massCode) - Code snippet manager for developers.
- [Swifty](https://github.com/swiftyapp/swifty) - Password manager.
- [MQTTX](https://github.com/emqx/MQTTX) - Client for MQTT, which is a lightweight messaging protocol.
- [LightProxy](https://github.com/alibaba/lightproxy) - Web debugging proxy.
- [Beekeeper Studio](https://github.com/beekeeper-studio/beekeeper-studio) - Cross-platform SQL editor and database manager.
- [Mouseless](https://github.com/ueberdosis/mouseless) - Keyboard shortcut training and look-up.
- [Glyphfinder](https://github.com/ueberdosis/glyphfinder) - Unicode character search.
- [Graviton Editor](https://github.com/Graviton-Code-Editor/Graviton-App) - Cross-platform code editor.
- [Yana](https://github.com/lukasbach/yana) - Notebook app with rich-text notes, nested note organization and global search.
- [SpaceEye](https://github.com/KYDronePilot/SpaceEye) - Live satellite imagery for your desktop background.
- [Heroic Games Launcher](https://github.com/Heroic-Games-Launcher/HeroicGamesLauncher) - Alternative Epic games launcher.
- [VIR](https://github.com/TommyX12/VIR) - Intelligent time manager with automatic planning.
- [Browserosaurus](https://github.com/will-stone/browserosaurus) - Browser prompter for macOS.
- [linked](https://github.com/lostdesign/linked) - Daily journal.
- [shadowsocks-electron](https://github.com/nojsja/shadowsocks-electron) - Cross-platform Shadowsocks client.
- [Sigma File Manager](https://github.com/aleksey-hoffman/sigma-file-manager) - Modern file manager.
- [Ostara](https://github.com/krud-dev/ostara) - Monitor and interact with Spring Boot apps via Actuator.
- [PikaTorrent](https://github.com/G-Ray/pikatorrent) - BitTorrent client.
- [Wave Terminal](https://github.com/wavetermdev/waveterm) - Open-source terminal with AI integration.

### Closed Source

###### Featured

- [Rosefinch](https://rosefinchapp.com) - Store and run SQL queries.
- [Nota](https://nota.md) - Pro writing app designed for local Markdown files.

###### Other

- [GitKraken](http://www.gitkraken.com) - Git client.
- [1Clipboard](http://1clipboard.io) - Universal clipboard manager.
- [Postman](https://www.getpostman.com) - Create and send HTTP requests.
- [Slack](https://medium.com/ben-and-dion/how-slack-built-a-well-loved-product-going-against-peter-thiel-and-native-app-fashion-2abbbe5a022f) - Desktop version.
- [Avocode](http://avocode.com) - Share design and collaborate.
- [Prepros](https://prepros.io) - Compile almost any preprocessing language with live browser refresh.
- [Stremio](http://www.strem.io) - Media center.
- [Typetalk](http://www.typetalk.in) - Share and discuss ideas with your team through instant messaging.
- [Pingendo](http://pingendo.com) - Bootstrap prototyping.
- [Spreaker Studio](https://www.spreaker.com/download) - Audio recording and broadcasting.
- [MockingBot](https://mockingbot.com) - Prototyping tool for designing apps.
- [Caret](http://caret.io) - Markdown editor.
- [Remember](https://rememberapp.co.kr) - Business card management. *(Korean)*
- [MongoDB Compass](https://www.mongodb.com/products/compass) - Official MongoDB app.
- [Freeter](https://freeter.io) - Organizer for freelancers & creatives.
- [WhatsApp](https://www.whatsapp.com/download/) - Official WhatsApp app.
- [CatLight](https://catlight.io) - Build status notifier.
- [Discord](https://discord.com) - Voice and text chat.
- [Cocos Creator](http://cocos2d-x.org/products#creator) - Game editor for creating web and native games for Cocos2D-x.
- [Inkdrop](https://www.inkdrop.info) - Markdown notebook for hackers.
- [Exodus](https://www.exodus.io) - Secure, manage, and exchange blockchain assets like Bitcoin and Ethereum.
- [Hackolade](http://hackolade.com) - Data modeling for NoSQL and multi-model databases.
- [CashNotify](https://cashnotify.com) - Monitor your Stripe accounts from your menu bar.
- [Mockoon](https://mockoon.com) - Mock servers in seconds.
- [Twitch](https://app.twitch.tv) - Official Twitch app.
- [Fenêtre](https://fenêt.re) - Picture-in-picture for your Mac.
- [Cleavr](https://cleavr.io) - Provision servers and deploy web apps.
- [Brandy](https://getbrandy.io) - A brand asset manager for your menu bar.
- [Cacher](https://www.cacher.io) - Cloud-based, team-enabled code snippet manager with Gist sync.
- [MusicPlus](https://musicplus.io) - Free music app for macOS and Windows.
- [Mingo](https://mingo.io) - MongoDB GUI.
- [Moon Modeler](https://datensen.com) - Schema design tool for MongoDB, Mongoose, and MariaDB.
- [Notion](https://notion.so) - All-in-one workspace for your notes, tasks, wikis, and databases.
- [FATpick](https://www.fatpick.com) - Guitar tablature viewer that scores your performance as you play along.
- [Taskade](https://www.taskade.com) - Realtime organization and collaboration tool for distributed teams with tasks, notes, and chat.
- [Coloban](https://www.coloban.com) - All-in-one project management tool with chats, Kanban, Gantt, calls, screenshare, and more.
- [Dynobase](https://dynobase.dev) - AWS DynamoDB GUI.
- [Lotus](https://getlotus.app) - Keep up with GitHub notifications without stress.
- [RunJS](https://runjs.app) - Playground for JavaScript and TypeScript.
- [OpenSFTP](https://opensftp.com) - Integrated SSH and SFTP workspace client.

### Samples

- [Electron API usage](https://github.com/hokein/electron-sample-apps) - Sample apps illustrating usage of Electron APIs.
- [Screen Recorder](https://github.com/hokein/electron-screen-recorder) - WebRTC screen recorder.
- [Activity Monitor](https://electronjs.org/blog/simple-samples#activity-monitor) - Shows a doughnut chart of the CPU system, user, and idle activity time.
- [Hash](https://electronjs.org/blog/simple-samples#hash) - Shows the hash values of entered text using different algorithms.
- [Prices](https://electronjs.org/blog/simple-samples#prices) - Shows the current price of oil, gold, and silver using the Yahoo Finance API.

## Boilerplates

- [electron-boilerplate](https://github.com/sindresorhus/electron-boilerplate) - Boilerplate to kickstart creating an app - by [sindresorhus](http://github.com/sindresorhus).
- [generator-electron](https://github.com/sindresorhus/generator-electron) - Scaffold out an app boilerplate.
- [electron-boilerplate](https://github.com/szwacz/electron-boilerplate) - Comprehensive boilerplate which even generates installers - by [szwacz](https://github.com/szwacz).
- [electron-react-boilerplate](https://github.com/chentsulin/electron-react-boilerplate) - Boilerplate based on React and webpack.
- [electron-quick-start](https://github.com/electron/electron-quick-start) - Clone the repo to try a simple app.
- [bozon](https://github.com/railsware/bozon) - Scaffold, run, test, and package your app.
- [secure-electron-template](https://github.com/reZach/secure-electron-template) - Security-focused boilerplate for creating apps with React, Redux, Webpack, and i18next.
- [angular-electron](https://github.com/maximegris/angular-electron) - Fast bootstrapping with Angular, Electron, TypeScript, SASS, and Hot Reload.
- [vite-electron-builder](https://github.com/cawa-93/vite-electron-builder) - Secure boilerplate for Electron app based on Vite. TypeScript + Vue/React/Angular/Svelte/Vanilla.

## Tools

### For Electron

- [electron-builder](https://github.com/electron-userland/electron-builder) - Create installers.
- [electron-packager](https://github.com/electron-userland/electron-packager) - Package and distribute your app.
- [electron-debug](https://github.com/sindresorhus/electron-debug) - Adds useful debug features.
- [electron-is-dev](https://github.com/sindresorhus/electron-is-dev) - Check if Electron is running in development.
- [electron-localshortcut](https://github.com/parro-it/electron-localshortcut) - Add keyboard shortcuts locally to a window.
- [fix-path](https://github.com/sindresorhus/fix-path) - Fix the $PATH on macOS when run from a GUI app. Useful when spawning a child process.
- [electron-dl](https://github.com/sindresorhus/electron-dl) - Simplified file downloads.
- [electron-release-server](https://github.com/ArekSredzki/electron-release-server) - Self-hosted release server with front-end & auto-updater support.
- [electron-rebuild](https://github.com/electron/electron-rebuild) - Rebuild native Node.js modules against the currently installed Electron version.
- [debug-menu](https://github.com/parro-it/debug-menu) - Chrome-like "inspect element" context-menu.
- [electron-installer-debian](https://github.com/unindented/electron-installer-debian) - Create a Debian package.
- [electron-installer-redhat](https://github.com/unindented/electron-installer-redhat) - Create a Red Hat package.
- [electron-installer-windows](https://github.com/unindented/electron-installer-windows) - Create a Windows package.
- [electron-download](https://github.com/electron-userland/electron-download) - Download the Electron release zip from GitHub.
- [electron-osx-sign](https://github.com/electron-userland/electron-osx-sign) - Code-signing for macOS apps.
- [ember-electron](https://github.com/felixrieseberg/ember-electron) - Build, test, and package Ember apps.
- [electron-store](https://github.com/sindresorhus/electron-store) - Save and load data like user preferences, app state, cache, etc.
- [electron-context-menu](https://github.com/sindresorhus/electron-context-menu) - Extensible context menu.
- [NeDB](https://github.com/louischatriot/nedb) - Embedded persistent or in-memory database.
- [RxDB](https://github.com/pubkey/rxdb) - A realtime NoSQL database.
- [electron-devtools-installer](https://github.com/GPMDP/electron-devtools-installer) - Install DevTools extensions from the Chrome Web Store.
- [electron-log](https://github.com/megahertz/electron-log) - Simple logging.
- [electron-about-window](https://github.com/rhysd/electron-about-window) - 'About This App' window.
- [elemon](https://github.com/manidlou/elemon) - Live-reload your app during development.
- [electron-is-accelerator](https://github.com/brrd/electron-is-accelerator) - Check if a string is a valid accelerator.
- [electron-pdf-window](https://github.com/gerhardberger/electron-pdf-window) - View PDF files in browser windows.
- [got](https://github.com/sindresorhus/got) - Simplified HTTP requests.
- [electron-unhandled](https://github.com/sindresorhus/electron-unhandled) - Catch unhandled errors and promise rejections.
- [electron-util](https://github.com/sindresorhus/electron-util) - Useful utilities for developing apps and modules.
- [electron-reloader](https://github.com/sindresorhus/electron-reloader) - Simple auto-reloading during development.
- [electron-serve](https://github.com/sindresorhus/electron-serve) - Static file serving (Useful for routing, like `react-router`).
- [electron-timber](https://github.com/sindresorhus/electron-timber) - Pretty logger.
- [chromium-net-errors](https://github.com/maxkueng/chromium-net-errors) - Chromium's network errors as custom error classes.
- [run-electron](https://github.com/sindresorhus/run-electron) - Run Electron without all the junk terminal output.
- [debugtron](https://github.com/pd4d10/debugtron) - Debug in-production Electron-based apps.
- [electron-better-ipc](https://github.com/sindresorhus/electron-better-ipc) - Simplified IPC communication.
- [electron-chrome-extension](https://github.com/getstation/electron-chrome-extension) - Add support for Chrome extensions.
- [trilogy](https://github.com/citycide/trilogy) - TypeScript SQLite database layer with support for both native C++ and pure JavaScript backends.
- [adblocker-electron](https://github.com/cliqz-oss/adblocker/tree/master/packages/adblocker-electron) - Block ads and trackers.
- [electronmon](https://github.com/catdad/electronmon) - Monitor and reload apps out-of-process during development.
- [electronegativity](https://github.com/doyensec/electronegativity) - Identify misconfigurations and security anti-patterns.
- [UpdateRocks!](https://www.update.rocks) - Auto-update service. Free for open source projects.
- [electron-vite](https://github.com/alex8088/electron-vite) - Fast and easy-to-use build tool integrated with Vite.
- [pluggable-electron](https://github.com/dutchigor/pluggable-electron) - Build apps that can be extended through plugins.
- [Hydraulic Conveyor](https://hydraulic.dev) - CLI tool that deploys apps without needing any special update servers, multi-platform CI, or code changes.
- [Aptabase](https://aptabase.com/for-electron) - Analytics for apps. Open source, privacy-friendly, and simple.

### Using Electron

- [nativefier](https://github.com/jiahaog/nativefier) - Create an app of any website.
- [electron-stream](https://github.com/juliangruber/electron-stream) - Streaming wrapper.
- [electron-pdf](https://github.com/fraserxu/electron-pdf) - Generate PDF from URL, HTML, or Markdown files on the command-line.
- [electron-mocha](https://github.com/jprichardson/electron-mocha) - Run Mocha tests in Electron.
- [Reactotron](https://github.com/reactotron/reactotron) - Inspect your React and React Native apps.
- [jest-electron](https://github.com/hustcc/jest-electron) - Run and debug Jest unit tests in a browser environment.

## Components

- [menubar](https://github.com/maxogden/menubar) - Menubar app framework.
- [React Desktop](https://github.com/gabrielbull/react-desktop) - UI toolkit for macOS and Windows built with React.
- [chrome-tabs](https://github.com/adamschwartz/chrome-tabs) - Chrome like tabs.
- [Xel](https://xel-toolkit.org) - Widget toolkit for building native-like apps.

## Documentation

- [Quick Start](https://electronjs.org/docs/tutorial/quick-start)
- [Official docs](https://electronjs.org/docs)
- [Essential Electron](http://jlord.us/essential-electron/) - Concise overview.

## Articles

- [Electron Fundamentals](http://maxogden.com/electron-fundamentals.html)
- [Building a desktop application with Electron](https://medium.com/@bojzi/building-a-desktop-application-with-electron-204203eeb658)
- [Codesigning your app for macOS](http://jbavari.github.io/blog/2015/08/14/codesigning-electron-applications/)
- [Auto-updating apps for macOS and Windows: The complete guide](https://medium.com/@svilen/auto-updating-apps-for-windows-and-osx-using-electron-the-complete-guide-4aa7a50b904c)
- [Building a desktop app with Electron, React, and Redux](https://anadea.info/blog/building-desktop-app-with-electron)
- [Introducing BrowserView for Electron](https://blog.figma.com/introducing-browserview-for-electron-7b40b4b493d5) - New Electron API to embed web apps with fewer bugs and improved performance.
- [Migrating Slack's Desktop App to BrowserView](https://slack.engineering/growing-pains-migrating-slacks-desktop-app-to-browserview-2759690d9c7b) - Slack rewrote their Electron app with `BrowserView`, Redux, Rx, and TypeScript, to fix its performance problems.
- [Electron on the App Store](https://medium.com/@yoannm/pushing-electron-on-the-mac-appstore-early-stages-7dcb85936f92) - A 5-part series about the journey of making and publishing an Electron app to the Mac App Store.
- [Building a file explorer with Electron, Quasar, and Vue](https://medium.com/quasar-framework/building-an-electron-file-explorer-with-quasar-and-vue-7bf94f1bbf6) - Focused on design and code decisions and Electron security.
- [Using Google Analytics to gather usage statistics in Electron](https://kilianvalkhof.com/2018/apps/using-google-analytics-to-gather-usage-statistics-in-electron/) - How to collect anonymous user statistics.
- [Notarizing your Electron app](https://kilianvalkhof.com/2019/electron/notarizing-your-electron-application/) - How to configure your app packaging for Apple's notarization.
- [Making Electron apps feel native on Mac](https://getlotus.app/21-making-electron-apps-feel-native-on-mac)

## Books

- [Developing an Electron Edge](https://bleedingedgepress.com/developing-an-electron-edge/) - [Preview](https://read.amazon.com/kp/embed?asin=B01G7TTKSK&asin=B01G7TTKSK&preview=newtab&linkCode=kpe&ref_=cm_sw_r_kb_dp_DLhOxb0XZ3MEC) 💲
- [Electron in Action](https://www.manning.com/books/electron-in-action?a_aid=electroninaction) 💲
- [Cross-Platform Desktop Applications](https://www.manning.com/books/cross-platform-desktop-applications) 💲

## Videos

- [Getting Started with Electron 1.x](https://www.youtube.com/watch?v=jKzBJAowmGg)
- [Packaging and Distributing Electron Desktop Apps](https://www.youtube.com/watch?v=dz5SnmBzBXc)
- [Multi Window Electron Desktop Apps](https://www.youtube.com/watch?v=K-H2amwQ_pU)
- [The State of Electron](https://www.youtube.com/watch?v=RaPmi-33rfc)
- [Cross-Platform Desktop Apps with Electron](https://www.youtube.com/watch?v=9xX_G0l5jLU)
- [Building Native Desktop apps using Electron](https://www.youtube.com/watch?v=nXIrFq5-FC8)
- [The New Desktop: Electron, React, & Pixel-Perfect Native-Feeling Experiences](https://www.youtube.com/watch?v=jRPUB-D1Wx0)
- [Building Desktop Apps with Node.js and Electron](https://www.youtube.com/watch?v=rbSvc8_BHaw)
- [Electron Fundamentals course - Pluralsight](https://www.pluralsight.com/courses/electron-fundamentals) 💲
- [Electron: Building Cross Platform Desktop Apps - Lynda](https://www.lynda.com/Electron-tutorials/Electron-Building-Cross-Platform-Desktop-Apps/518051-2.html) 💲
- [Build a desktop application with Electron - Egghead](https://egghead.io/courses/build-a-desktop-application-with-electron) 💲
- [Build Cross-Platform Desktop Apps with Electron - Frontend Masters](https://frontendmasters.com/courses/electron/) 💲
- [Electron Meetup SF, November 2017](https://www.youtube.com/watch?v=DDjVaHPvRdM) - Includes some good talks on improving app startup time, debugging crashes, etc.
- [Make Your Electron App Feel at Home Everywhere](https://www.youtube.com/watch?v=fw4PmPaghyU) - Tips on making your app feel more native on macOS, Windows, and Linux without sacrificing your own style.

## Podcasts

- [Hanselminutes: Creating cross-platform Electron apps with Jessica Lord](http://hanselminutes.com/534/creating-cross-platform-electron-apps-with-jessica-lord)
- [The Changelog #216: GitHub's Electron with Zeke Sikelianos](https://changelog.com/podcast/216)
- [Full Stack Radio #48: Jessica Lord - Building Desktop Apps with Electron](http://www.fullstackradio.com/48)

## Community

- [Reddit](https://www.reddit.com/r/electronjs)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/electron)
- [`@electronjs` on Twitter](https://twitter.com/electronjs)
- [electron-br](https://electron-br.slack.com) *(Brazilian Portuguese)*
- [electron-pl](https://electronpl.github.io) *(Polish)*
- [`@electron_ru` on Telegram](https://telegram.me/electron_ru) *(Russian)*
- [`electronjs` on Facebook](https://www.facebook.com/groups/electronjs/)
- [Product Hunt](https://www.producthunt.com/@sindresorhus/collections/electron-apps)

## Contribute

Contributions welcome! Read the [contribution guidelines](https://github.com/sindresorhus/awesome-electron/blob/master/contributing.md) first.

## Related

- [awesome-nodejs](https://github.com/sindresorhus/awesome-nodejs)
- [awesome-electronjs-hacking](https://github.com/doyensec/awesome-electronjs-hacking)
