<div class="github-widget" data-repo="antontarasenko/awesome-economics"></div>
## Awesome Economics [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

 * 为经济学家精选的链接集合. 的一部分 ["Awesome X" series](https://github.com/sindresorhus/awesome).*

该列表会定期更新新链接. 点击右上角“关注”即可关注.

欢迎您的贡献. 添加链接到“读者发送的链接” [by yourself](https://github.com/antontarasenko/awesome-economics/blob/master/contributing.md) 或发送新内容至<antontarasenko@gmail.com> .




## Studying

### Courses

* [MIT OCW Economics](http://ocw.mit.edu/courses/economics/)  - 涵盖经济学所有主要领域的 100 多门课程. 课程包括先决条件、推荐教科书、讲座幻灯片和作业. 本科和研究生课程.
* [edX Economics](https://www.edx.org/course/subject/economics-finance) - 介绍性主题，一些先决条件.
* [Khan Academy: Economics](https://www.khanacademy.org/economics-finance-domain) - 基本主题.

### Useful Materials

* [Academic Search](https://cse.google.com/cse/publicurl?cx=002720237717066476899:e55ib8o11ka)  - 搜索“.edu”和其他教育领域. 这些资料比大互联网靠谱多了.
* [Foundational Equations of Economics](http://economics.stackexchange.com/questions/35/what-are-the-foundational-equations-of-economics)  - 这些方程式显示了“像经济学家一样思考”背后的原则. 研究生教科书将这些等式放在上下文中.
* [IGM Economic Experts Panel](http://www.igmchicago.org/igm-economic-experts-panel)  - 顶级经济学家反思与政策相关的问题. 一些答案包含有用的细节.
* [AEA Resources for Economists](http://rfe.org/) - 由美国经济协会维护的有用链接列表.

## Research

### Portals

* [RePEc](http://repec.org/) - 为经济研究人员提供的网络服务：参考书目、博客聚合器、新工作论文、软件.
* [Federal Reserve Bank of St. Louis: Web Services](https://research.stlouisfed.org/resources.html) - 有用的服务列表.

### Articles and Working Papers

* [IDEAS RePEc](https://ideas.repec.org/)  - 最大的经济学出版物数据库（2,000,000 项）. 使用 Google 可以更轻松地搜索论文：``site:ideas.repec.org<search term>  ``. 下面提到的索引来源.
* [NBER](http://nber.org/papers.html)  - 主要研究人员的工作论文. 其中许多论文发表在同行评审的期刊上.
* [SSRN Economics](http://ssrn.com/en/index.cfm/ern/) - 工作论文，无期刊出版物.
* [Google Scholar](http://scholar.google.com/)  - 一般搜索学术文献. 具有作者页面和引文计数器. 如果你只看经济著作，IDEAS 会更强大.

### Data

Datasets

* [FRED2](https://research.stlouisfed.org/fred2/)  - 来自 80 个来源的 380,000（宏）时间序列. 支持将数据导入 Excel、Stata、R 等的插件. 有一个移动应用程序.
* [World Bank Data](http://data.worldbank.org/)  - 国际宏观时间序列. 有数据导入插件.
* [IMF Data](http://www.imf.org/en/Data) - 宏数据的标准参考.
* [Quandl](https://www.quandl.com/)  - 汇总来自多个来源的金融和经济数据. 一些数据供应商通过此服务出售他们的数据. 与统计软件的良好集成.
* [MEDevEcon](https://sites.google.com/site/medevecon/devecondata) - 与发展经济学相关的数据.
* [Monetary Economics: Data Sources](https://sites.google.com/site/davesmant/various/data-sets-sources) - 宏数据源概述.
* [OFFSTATS](http://www.offstats.auckland.ac.nz/) - 按国家和主题链接到官方数据源.

Search

* [International Open Government Dataset Search](https://logd.tw.rpi.edu//node/9903)  - 超过 1,000,000 个政府数据集. 工作时，此服务看起来 [like this](http://web.archive.org/web/20140815054106/http://logd.tw.rpi.edu/node/9903) . 否则，您会看到 403 错误.
* [Dataset Search Engine](https://cse.google.com/cse/publicurl?cx=002720237717066476899:v2wv26idk7m)  - 基于谷歌的搜索超过 200 个数据源，包括这里提到的那些. 你可以使用谷歌 [search operators](http://www.googleguide.com/advanced_operators_reference.html) 这里.
* [StackExchange Open Data](http://opendata.stackexchange.com/) - 如果您没有找到您正在寻找的数据，您可以在这里询问.
* [Reddit /r/datasets](https://www.reddit.com/r/datasets) - 多了一个请求数据集的地方.

### Software

Writing

* [LaTeX](https://www.latex-project.org/)  - 经济学家用 LaTeX 写作，因为它比 Word 或 LibreOffice 更好地处理数学和参考文献. 如果你经常写作，LaTeX 值得学习.
  - [Beamer](https://www.ctan.org/pkg/beamer?lang=en) - 用于演示的 LaTeX 类.
  - [TikZ](http://www.texample.net/tikz/examples/)  - 绘制图形的扩展.  A [how-to](http://cremeronline.com/LaTeX/minimaltikz.pdf) and a [manual](http://www.texample.net/media/pgf/builds/pgfmanualCVS2012-11-04.pdf).
* [LyX](http://www.lyx.org/) - 一个免费且简单的 LaTeX 编辑器.
* [Zotero](https://www.zotero.org/)  - 书目管理. 同时安装 (a) Zotero 浏览器插件，将论文从 RePEc 导入您的图书馆；  (b) Zotero-LyX 插件可以轻松引用文献.
* [Git](https://git-scm.com/downloads)  - 版本控制系统. 如果您想还原几个月前所做的更改或与其他作者合作，这很有用.  DropBox 也有版本控制，但 Git 更明确.  A [short intro](http://rogerdudler.github.io/git-guide/) . 或者使用 [GitHub Desktop](https://desktop.github.com/) 如果你喜欢简单.
* [Mendeley](https://www.mendeley.com)  - 书目管理. 支持多平台同步：Mac, Windows, Ipad, Phone...

Computing

* [Stata](http://www.stata.com/)  - 经济学统计计算的行业标准. 免费替代品：
  - [IPython](http://ipython.org/)  - 基于 Python 的环境. 计量经济学分析是使用免费软件包完成的：statsmodels、SciPy、NumPy、pandas.
  - [RStudio](https://www.rstudio.com/)  - 基于 R 的环境.  R 是统计学家的标准语言，因此 R 存储库通常包含其他语言不可用的专用库.
* [Matlab](http://www.mathworks.com/products/matlab/)  - 经济学建模和数值优化的行业标准. 免费替代品：
  - [Octave](https://www.gnu.org/software/octave/)
  - [Julia](https://julialang.org/) - 旨在满足高性能数值分析和计算科学需求的高级动态编程语言.
* [Mathematica](https://www.wolfram.com/mathematica/)  - 符号计算. 免费替代品
  - [Sage](http://www.sagemath.org/)
* [Julia](https://julialang.org/) - 开源科学计算软件.

Sharing

* [GitHub](https://github.com/)  - 代码和数据的存储库. 在这里发布研究成果并不常见，但比其他选择（大学主页、DropBox 等）更方便.
  - [GitHub Pages](https://pages.github.com/) - 简单的静态网站.
  - [GitHub LFS](https://git-lfs.github.com/) - 大文件存储.
* [IPython Notebooks](http://ipython.org/)  - LaTeX 和 Word 的交互式替代品. 查看笔记本的外观示例 [data-science-ipython-notebooks](https://github.com/donnemartin/data-science-ipython-notebooks) 和 [the gallery](https://github.com/ipython/ipython/wiki/A-gallery-of-interesting-IPython-Notebooks).

Reviews

* [Most common programs used by Economists](http://economics.stackexchange.com/questions/5853/most-common-programs-used-by-economists) - 社区管理的常用软件列表.
* [Software for Researchers: New Data and Applications](https://antontarasenko.com/2016/01/14/software-for-research/) - 包括上面提到的软件和更多.

### Useful Materials

* [How to efficiently manage a statistical analysis project?](http://stats.stackexchange.com/questions/2910/how-to-efficiently-manage-a-statistical-analysis-project)
* RePEc 引用排名
  - [Top Authors](https://ideas.repec.org/top/top.person.all.html)
  - [Economic Institutions](https://ideas.repec.org/top/top.inst.nbcites.html)
  - [Research Items](https://ideas.repec.org/top/top.item.nbcites.html)
  - [Software Items](http://logec.repec.org/scripts/itemstat.pf?type=redif-software)


## Discussions

 * 博客 - 经济学家最流行的自我表达方式. 主要的博客聚合器：
  - [EconAcademics.org](http://econacademics.org/)
  - [Economist's View](http://economistsview.typepad.com/) - 马克托马
  - [Grasping Reality](http://delong.typepad.com/) - 布拉德德隆
  - [Marginal Revolution](http://marginalrevolution.com/) - 泰勒考恩和亚历克斯塔巴罗克
  - [VOX CEPR](http://www.voxeu.org/) - CEPR 成员
* [Economics Blog Search](https://cse.google.com/cse/publicurl?cx=002720237717066476899:i_zfef5fawa) - 基于谷歌的上述博客搜索服务.
* [AEA Blog Directory](https://www.aeaweb.org/rfe/showCat.php?cat_id=96) - 主要经济博客列表.
* [StackExchange Economics](http://economics.stackexchange.com/) - 一个问答网站，您可以在其中提问和回答问题.
 * Reddit - 一个流行的新闻聚合器. 有许多与经济学相关的部分，例如：
  - [/r/GoodEconomics/](https://www.reddit.com/r/GoodEconomics/) - 关于经济问题的精选文章.
  - [/r/EconPapers/](https://www.reddit.com/r/EconPapers/) - 讨论经济论文.
* Discord - 一个流行的聊天平台
  - [Academic Economics](https://discord.gg/n9V7hjNtPV) - 一个社区，有讨论经济学和帮助成员练习的房间

## Career

### Undergraduate

* 大学排名 - 可能有助于选择大学.
  - [QS World University Rankings by Subject 2016 - Economics & Econometrics](http://www.topuniversities.com/university-rankings/university-subject-rankings/2016/economics-econometrics#sorting=rank+region=+country=+faculty=+stars=false+search=)
  - [Academic Ranking of World Universities in Economics / Business](http://www.shanghairanking.com/SubjectEcoBus2015.html)

### Graduate

* [American Economic Association: Graduate Training in Economics](https://www.aeaweb.org/gradstudents/index.php) - 项目概览、要求和对考虑攻读经济学博士项目的人的建议.

### Faculty

* [Job Openings for Economists](https://www.aeaweb.org/joe/) - 美国经济协会的工作委员会.
* [Econ Jobs Postings](https://econjobmarket.org/positions) - 学术职位空缺清单.
* [Economics Job Market Rumors](http://www.econjobrumors.com/wiki.php)  - 经济学家职位空缺清单. 非正式的.


## Economics on GitHub

_按字母顺序排序_

### Economists

* [davidrpugh](https://github.com/davidrpugh)  - 牛津马丁学院新经济思维研究所； 牛津数学研究所，牛津，英国. 
* [gboehl](https://github.com/gboehl) - 波恩大学，波恩，德国.
* [hmgaudecker](https://github.com/hmgaudecker) - 波恩大学，波恩，德国.
* [jesusfv](https://github.com/jesusfv)
* [jstac](https://github.com/jstac) - 澳大利亚国立大学，堪培拉，澳大利亚.
* [mwt](https://github.com/mwt) - 美国西北大学
* [nathanlane](https://github.com/nathanlane) - 瑞典斯德哥尔摩国际经济研究所.
* [nealbob](https://github.com/nealbob) - 澳大利亚国立大学，堪培拉，澳大利亚.
* [robertdkirkby](https://github.com/robertdkirkby)
* [trickvi](https://github.com/trickvi) - 冰岛统计局，冰岛.

### Projects

* [EconForge](https://github.com/EconForge) - 围绕 Pablo Winant 的团队提供软件包来解决经济模型.
* [economics-book](https://github.com/philschatz/economics-book) - 经济学教科书（Openstax）.
* [econpizza](https://github.com/gboehl/econpizza) - 用于解决和模拟具有异构代理的非线性模型的工具箱.
* [fecon235](https://github.com/rsvp/fecon235) - 金融经济学计算工具、Python 代码库和使用 Jupyter 笔记本的教程，包括数据检索、图形和优化.
* [macro_puzzles](https://github.com/gboehl/macro_puzzles) - 宏观经济学难题列表.
* [pydsge](https://github.com/gboehl/pydsge) - 解决、过滤和估计偶尔具有约束力的 DSGE 模型的工具.
* [pyeconomics](https://github.com/davidrpugh/pyeconomics) - Python 中的计算经济学.
* [QuantEcon](https://github.com/QuantEcon/) - 数量经济学图书馆.
* [quantecon_nyu_2016](https://github.com/jstac/quantecon_nyu_2016) - 计算经济学专​​题
* [VFI Toolkit](https://github.com/vfitoolkit) - 用于 GPU 上的值函数迭代的 Matlab 工具包.
* [zice-2014](https://github.com/davidrpugh/zice-2014) - 苏黎世计算经济学倡议 (ZICE) 2014 的课程材料.


## Links Sent by Readers

* [Deveconodata Blogspot](http://devecondata.blogspot.com/)  - 发展经济学数据集. 定期更新.
* [Economics Games](http://economics-games.com/) - 用于教授经济学的免费在线课堂游戏.
* [Quantitative Economics](https://lectures.quantecon.org/py/index.html) - Thomas J. Sargent 和 John Stachurski 使用 Python 计算工具的系列讲座.
* [Top 100 Economics Blogs](https://www.intelligenteconomist.com/top-economics-blogs-2016/) - 流行经济学博客的链接，带有简要说明.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
