<div class="github-widget" data-repo="nirgn975/awesome-drupal"></div>
## Awesome Drupal [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://raw.githubusercontent.com/nirgn975/awesome-drupal/master/icon-drupal.png" align="right" width="90">](https://www.drupal.org)

> [Drupal](https://www.drupal.org) 是一个用 PHP 编写并在 GNU 通用公共许可证下分发的免费开源 CMS，为全球网站提供后端——从个人博客到公司、政治和政府网站.

你可能还喜欢 [awesome-php](https://github.com/ziadoz/awesome-php).





## Tools

- [Drupal Console](https://drupalconsole.com/)  - Drupal CLI. 生成样板代码、与 Drupal 交互和调试的工具.
- [DrupalVM](https://www.drupalvm.com/) - Drupal VM 可以快速轻松地构建 Drupal 开发环境，并向开发人员介绍在虚拟机或 Docker 容器上进行 Drupal 开发的美妙世界（而不是笨拙的基于 MAMP/WAMP 的开发）.
- [Drush](http://www.drush.org/)  - Drush 是 Drupal 的命令行 shell 和 Unix 脚本界面.  Drush 核心附带了许多有用的命令，用于与模块/主题/配置文件等代码进行交互. 同样，它运行 update.php，执行 sql 查询和数据库迁移，以及其他实用程序，如运行 cron 或清除缓存.
- [Yo Hedley!](https://github.com/Gizra/generator-hedley) - 搭建无头 Drupal 后端、Angular 应用程序客户端和 Behat 测试.
- [DDEV-Local](https://github.com/drud/ddev)  - 基于 Docker 的工具，用于创建和管理本地开发环境. 也可用于其他 PHP 应用程序. 另见 [Get Started Guide](https://www.drud.com/get-started/) 


## Modules

- [Administration menu](https://www.drupal.org/project/admin_menu) - 提供独立于主题的管理界​​面（也称为导航、后端）.
- [Administration views](https://www.drupal.org/project/admin_views) - 用实际视图替换管理概述/列表页面以获得卓越的可用性.
- [Backup and Migrate](https://www.drupal.org/project/backup_migrate)  - 备份和恢复您的 Drupal MySQL 数据库、代码和文件，或在环境之间迁移站点.  Backup and Migrate 支持 gzip、bzip 和 zip 压缩以及自动计划备份.
- [Better Exposed Filters](https://www.drupal.org/project/better_exposed_filters)  - 备份和恢复您的 Drupal MySQL 数据库、代码和文件，或在环境之间迁移站点.  Backup and Migrate 支持 gzip、bzip 和 zip 压缩以及自动计划备份.
- [CKEditor - WYSIWYG HTML editor](https://www.drupal.org/project/ckeditor) - 该模块将允许 Drupal 将 textarea 字段替换为 CKEditor - 一种可视化 HTML 编辑器，通常称为 WYSIWYG 编辑器.
- [Colorbox](https://www.drupal.org/project/colorbox)  - Colorbox 是一个用于 jQuery 的轻量级可定制灯箱插件. 该模块允许将 Colorbox 集成到 Drupal 中.
- [Context](https://www.drupal.org/project/context)  - 上下文允许您管理站点不同部分的上下文条件和反应. 您可以将每个上下文视为代表您站点的一个“部分”.
- [Display Suite](https://www.drupal.org/project/ds) - Display Suite 允许您使用拖放界面完全控制内容的显示方式.
- [RESTful module](https://www.drupal.org/project/restful) - 允许通过 RESTful HTTP 请求操作 Drupal，使用安全性、性能和可用性的最佳实践.
- [Organic groups module](https://www.drupal.org/project/og) - 使用户能够创建和管理他们自己的“群组”.
- [Message](https://www.drupal.org/project/message) - 在许多不同的用例中启用记录和显示系统事件.
- [Message Notify](https://www.drupal.org/project/message_notify)  – 生成消息时转发消息.
- [Message Subscribe](https://www.drupal.org/project/message_subscribe) – 注册以在针对特定内容生成消息时收到通知.
- [Module Filter](https://www.drupal.org/project/module_filter) – 当处理一个相当大的网站或什至只是一个用于测试正在考虑的新模块和各种模块的开发站点时，模块列表页面可能会变得非常大. 
- [Entities Diagram Graph](https://www.drupal.org/sandbox/bricel/2654176) - 生成特定 Drupal 7 安装的实体、字段及其关系的图表.
- [Owl Carousel](https://www.drupal.org/project/OwlCarousel) - 此模块集成了由 OwlFonk 构建的精彩 Owl Carousel 滑块. 
- [csv2sql](https://www.drupal.org/project/csv2sql) - 将 CSV 转换为 SQL 并在您的 Drupal 安装中创建一个表.
- [Logs HTTP](https://www.drupal.org/project/logs_http) - 提供通过 tag/http 端点推送到日志的 JSON 事件.
- [Features](https://www.drupal.org/project/features)  - 启用 Drupal 中功能的捕获和管理. 功能是 Drupal 实体的集合，它们一起满足特定的用例.
- [Commerce](https://www.drupal.org/project/commerce) - 用于构建各种规模的电子商务网站和应用程序.
- [Views](https://www.drupal.org/project/views) - 允许管理员和站点设计者创建、管理和显示内容列表.
- [Panels](https://www.drupal.org/project/panels) - 允许站点管理员为多种用途创建自定义布局.
- [Panelizer](https://www.drupal.org/project/panelizer) - 允许站点管理员为多种用途创建自定义布局.
- [Pathauto](https://www.drupal.org/project/pathauto) - Pathauto 模块自动为各种内容（节点、分类术语、用户）生成 URL/路径别名，无需用户手动指定路径别名.
- [Ctools](https://www.drupal.org/project/ctools) - 该套件主要是一组用于改善开发人员体验的 API 和工具.
- [Search API](https://www.drupal.org/project/search_api) - 提供一个框架，可以使用任何类型的搜索引擎轻松地在 Drupal 已知的任何实体上创建搜索.
- [Slick](https://www.drupal.org/project/slick)  - Slick 是一个强大且高性能的幻灯片/轮播解决方案，利用了 Ken Wheeler 的 Slick 轮播. 请参阅 http://kenwheeler.github.io/slick
- [Token](https://www.drupal.org/project/token) - 提供核心不支持的额外令牌（最显着的字段），以及用于浏览令牌的 UI.
- [Ubercart](https://www.drupal.org/project/ubercart)  - Ubercart 是您网站上最受欢迎的 Drupal 电子商务平台. 它实现了开始在线销售产品所需的一切. 
- [Rules](https://www.drupal.org/project/rules) - 规则模块允许站点管理员根据发生的事件定义有条件执行的操作（称为反应或 ECA 规则）.
- [Entity API](https://www.drupal.org/project/entity) - 扩展 Drupal 核心的实体 API，以提供处理实体及其属性的统一方式.
- [Entity cache](https://www.drupal.org/project/entitycache) - 将核心实体放入 Drupal 的缓存 API.
- [elFinder file manager](https://www.drupal.org/project/elfinder) - elFinder 是一个开源的 AJAX 文件管理器
- [IMCE](https://www.drupal.org/project/imce) - IMCE 是一个图像/文件上传器和浏览器，支持个人目录和配额.
- [Date](https://www.drupal.org/project/date) - 包含灵活的日期/时间字段类型日期字段和其他模块可以使用的日期 API.
- [Devel](https://www.drupal.org/project/devel) - 包含模块开发人员和主题的乐趣的模块套件.
- [Migrate](https://www.drupal.org/project/migrate) - Provides a flexible framework for migrating content into Drupal from other sources.
- [Entity validator](https://www.drupal.org/project/entity_validator) - 允许您定义一个插件并设置方法来验证您正在处理的对象.
- [Webform](https://www.drupal.org/project/webform) - Webform 是在 Drupal 中制作表格和调查的模块.
- [WYSIWYG](https://www.drupal.org/project/wysiwyg) - 允许使用客户端编辑器来编辑内容.


## Documentation

- [Installation Guide ](https://www.drupal.org/docs/7/install)
- [Site Building Guide](https://www.drupal.org/documentation/build)
- [Administration & Security Guide](https://www.drupal.org/docs/7/administering-drupal-7-site)
- [Structure Guide](https://www.drupal.org/docs/7/nodes-content-types-and-fields)
- [Multilingual Guide](https://www.drupal.org/docs/7/multilingual)
- [Theming Guide](https://www.drupal.org/docs/7/theming)
- [Mobile Guide](https://www.drupal.org/docs/7/mobile)
- [API Reference](https://api.drupal.org/api/drupal)
- [Examples for Developers](https://www.drupal.org/project/examples)
- [Troubleshooting](https://www.drupal.org/troubleshooting)
- [The Drupal Cookbook (for beginners)](https://www.drupal.org/documentation/customization/tutorials/beginners-cookbook)


## Articles

- [Let’s Talk about Decoupled Authentication](http://www.gizra.com/content/restful-access-token/)
- [Creating a Dynamic Email Template in Drupal](http://www.gizra.com/content/dynamic-email-template/)
- [Getting started with a Core Initiative](http://www.gizra.com/content/getting-started-with-drupal-core-initiative/)
- [Drupal 8: Migrate Nodes with Attachments Easily](http://www.gizra.com/content/drupal-8-attachment-migration/)
- [Migration Best Practices](http://www.gizra.com/content/migration-best-practices/)
- [Cross-Site Scripting attack detection](http://www.gizra.com/content/xss-attack/)
- [simpleTest with Behat for Drupal 8](http://www.gizra.com/content/simpletest-behat-drupal-8/)
- [Logs, The Easy Way](http://www.gizra.com/content/logs-easy-way/)
- [Todo app with RESTful backend](http://www.gizra.com/content/todo-restful-backend/)
- [Message-subscribe - A New Subscription System](http://www.gizra.com/content/message-subscribe-new-subscription-system/)
- [What is Message module, and its new features](http://www.gizra.com/content/what-message-module-and-its-new-features/)
- [Message notify - Multilingual email notifications](http://www.gizra.com/content/message-notify-multilingual-email-notifications/)
- [Data Migration - part 1](http://www.gizra.com/content/data-migration-part-1/)
- [Data Migration - part 2](http://www.gizra.com/content/data-migration-part-2/)
- [How to install Drupal using Composer](http://whaaat.com/installing-drush-9-using-composer)
- [Using composer to set up Drupal 8](https://www.lullabot.com/articles/goodbye-drush-make-hello-composer)
- [使用 Inferno.js 的 Drupal 无头架构 [现场演示]](https://snipcart.com/blog/drupal-headless-architecture-tutorial)


## Distributions

- [Commerce kickstart](https://www.drupal.org/project/commerce_kickstart) - Commerce Kickstart 是启动和运行 Drupal Commerce 的最快方式.
- [OpenScholar](https://www.drupal.org/project/openscholar) - 为您机构的所有网站提供支持的最简单方法.
- [Open Atrium](https://www.drupal.org/project/openatrium) - 由 Phase2 Technology 维护的 Open Atrium 是一个 Drupal 发行版，可让您通过便捷的协作自信地与同事互动.
- [OpenPublic](https://www.drupal.org/project/openpublic) - 对于政府和公共政策组织，开源只有在满足公共部门的安全性、可访问性和灵活性要求的情况下才有效. 
- [OpenPublish](https://www.drupal.org/project/openpublish)  - OpenPublish 是专为在线新闻行业设计的 Drupal 7 打包发行版. 它部署在各种媒体站点中，包括杂志、报纸、期刊、贸易出版物、广播、有线服务、多媒体站点和会员出版物.

## Books

- [Drupal 7 The Essentials - Johan Falk](https://archive.org/details/Drupal7TheEssentials)


## Videos

- [Drupal 8 Basics - LevelUpTuts](https://www.youtube.com/playlist?list=PLLnpHn493BHE9mfp6z5--UowO-6SOzcuI)
- [Drupal 7 Tutorials - LevelUpTuts](https://www.youtube.com/playlist?list=PL15BE2E8313A4E809)
- [Decoupled Drupal: When, Why, and How](https://www.youtube.com/watch?v=bLWa3SbEEa8)
- [Building Modern APIs with RESTful](https://www.youtube.com/playlist?list=PLZOQ_ZMpYrZv8_c7jd_CkO_93-DnyVFY5)
- [DrupalCon Portland 2013 - Organic Groups \\ Message](https://www.youtube.com/watch?v=XglUUroifsg)
- [Drupalize Me](https://drupalize.me)


## Podcasts

- [Lullabot Podcast](https://www.lullabot.com/podcasts)
- [DrupalEasy Podcast](https://www.drupaleasy.com/podcast)
- [Talking Drupal](http://www.talkingdrupal.com)
- [Acquia Engage](https://dev.acquia.com/learn?type_1=podcast)


## Community

- [Reddit](https://www.reddit.com/r/drupal/)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/drupal)
- [`@drupal` on Twitter](https://twitter.com/drupal)
- [`#drupal` on Freenode](http://webchat.freenode.net/?channels=drupal)
- [`#drupal-contribute` on Freenode](http://webchat.freenode.net/?channels=drupal-contribute)
- [`#drupal-support` on Freenode](http://webchat.freenode.net/?channels=drupal-support)
- [Drupal Israel Meetup Group](https://www.meetup.com/Drupal-Israel/) *（希伯来语）*
- [Drupal NYC Meetup Group](https://www.meetup.com/drupalnyc/)


## Tips

- [Solr Script](https://github.com/RoySegall/solr-script) - 安装 Apache Solr 的便捷脚本.
- [Ubuntu development environment setup](https://github.com/Gizra/KnowledgeBase/wiki/Ubuntu-and-development-environment-setup) - 提供配置 ubuntu 的步骤，以便为 PHP 和 Drupal 开发做好准备.
- [MacOS: New Machine configuration](https://github.com/Gizra/KnowledgeBase/wiki/MacOS:-New-Machine) - 提供用于配置 MacOS 以进行开发的文件和脚本.


## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/nirgn975/awesome-drupal/blob/master/contributing.md) 第一的.


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Nir Galon](http://nirgn.com) 已放弃该作品的所有版权和相关或邻接权.
