<div class="github-widget" data-repo="stve/awesome-dropwizard"></div>
## Awesome Dropwizard [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)][awesome]

[<img src="https://cdn.rawgit.com/stve/awesome-dropwizard/master/dropwizard-hat.png" align="right" width="50">][dropwizard]

[很棒]：https://github.com/sindresorhus/awesome
[dropwizard]：http://www.dropwizard.io

&gt; 用于创建应用程序的有用资源 [Dropwizard](http://www.dropwizard.io)

### Contributing

请快速浏览一下 [contribution guidelines](https://github.com/stve/awesome-dropwizard/blob/master/CONTRIBUTING.md) 第一的.

## Editor Support

*支持您最喜欢的编辑器.*

### Eclipse

* [dropwizard-tools](https://github.com/Tasktop/dropwizard-tools) - 用于 Dropwizard 的 Eclipse 工具

## Open Source

* [dropwizard-jaxws](https://github.com/roskart/dropwizard-jaxws) - 支持使用 JAX-WS API 构建 SOAP Web 服务和客户端.
* [dropwizard-redirect-bundle](https://github.com/bazaarvoice/dropwizard-redirect-bundle) - 允许 HTTP 重定向.
* [dropwizard-template-config](https://github.com/tkrille/dropwizard-template-config) - 使您能够将 config.yaml 编写为 Freemarker 模板.
* [dropwizard-caching-bundle](https://github.com/bazaarvoice/dropwizard-caching-bundle) - 为资源和缓存响应生成缓存控制选项.
* [dropwizard-xml](https://github.com/yunspace/dropwizard-xml) - 用于处理和验证 XML 的 Dropwizard 包
* [dropwizard-crypto](https://github.com/meltmedia/dropwizard-crypto) - Dropwizard 的加密包
* [dropwizard-circuitbreaker](https://github.com/mtakaki/dropwizard-circuitbreaker) - dropwizard 的断路器设计模式
* [dropwizard-maxmind-bundle](https://github.com/phaneesh/dropwizard-maxmind-bundle) - MaxMind GeoIP2 支持 dropwizard
* [dropwizard-protobuf](https://github.com/dropwizard/dropwizard-protobuf) - 支持在 Dropwizard 中读写 Google Protocol Buffer 对象
* [dropwizard-activemq-bundle](https://github.com/mbknor/dropwizard-activemq-bundle) - 在您的 Dropwizard 应用程序中通过 ActiveMQ 发送和接收 JSON
* [dropwizard-consul](https://github.com/smoketurner/dropwizard-consul) - Dropwizard 的领事包
* [dropwizard-zipkin](https://github.com/smoketurner/dropwizard-zipkin) - 用于 Dropwizard 的 Zipkin 包
* [dropwizard-graphql](https://github.com/smoketurner/dropwizard-graphql) - 用于 Dropwizard 的 GraphQL 包
* [dropwizard-money](https://github.com/smoketurner/dropwizard-money) - Dropwizard 的钱包
* [breakerbox](https://github.com/yammer/breakerbox) - 坚韧前端 + Archaius
* [tenacity](https://github.com/yammer/tenacity) - 用于 Dropwizard 的 Hystrix 包
* [dropwizard-grpc](https://github.com/msteinhoff/dropwizard-grpc) - 在 Dropwizard 服务中使用 gRPC 服务器
* [sqs-dropwizard](https://github.com/bascan/aws-dropwizard) - 亚马逊 SQS 集成
* [dropwizard-simple-cors](https://github.com/ojacobson/dropwizard-simple-cors) - 提供简单、合理的 CORS 支持的 Dropwizard 包
* [dropwizard-version-info](https://github.com/palantir/dropwizard-version-info) - 公开版本端点的 Dropwizard 包

### Boilerplate Destruction
* [Brahma-HibernateUtils](https://github.com/gozefo/brahma-hibernateutils) - 一个注释处理器来跟踪```@Entity``` 类，使 dropwizard 中的实体注册变得超级简单.

### Authentication

* [dropwizard-auth-ldap](https://github.com/yammer/dropwizard-auth-ldap) - Dropwizard 的 LDAP 身份验证
* [dropwizard-jwt-cookie-authentication](https://github.com/dhatim/dropwizard-jwt-cookie-authentication) - Dropwizard 捆绑包通过 JWT cookie 管理身份验证

### Assets

* [dropwizard-configurable-assets-bundle](https://github.com/bazaarvoice/dropwizard-configurable-assets-bundle) - 在 Dropwizard 中使用的 AssetBundle 实现，允许用户配置.
* [dropwizard-markdown-assets-bundle](https://github.com/rnorth/dropwizard-markdown-assets-bundle) - 将 Markdown 文件呈现为漂亮的 HTML

### Data Stores

* [dropwizard-etcd](https://github.com/meltmedia/dropwizard-etcd) - 用于 Etcd 的 Dropwizard 捆绑包
* [dropwizard-mongo](https://github.com/eeb/dropwizard-mongo) - 用于连接到 mongoDB 的工厂和健康检查.
* [dropwizard-elasticsearch](https://github.com/dropwizard/dropwizard-elasticsearch) - 一组用于在 Dropwizard 服务中使用 Elasticsearch 的类
* [dropwizard-service-discovery](https://github.com/santanusinha/dropwizard-service-discovery) - Zookeeper 服务发现包和 dropwizard 客户端.
* [dropwizard-cassandra](https://github.com/composable-systems/dropwizard-cassandra) - Dropwizard 支持 Cassandra
* [dropwizard-riak](https://github.com/smoketurner/dropwizard-riak) - Dropwizard 支持 Riak
* [dropwizard-orient-server](https://github.com/xvik/dropwizard-orient-server) - 用于 dropwizard 的嵌入式 OrientDB 服务器
* [dropwizard-atomix](https://github.com/smoketurner/dropwizard-atomix) - 整合 [Atomix](http://atomix.io/)

### Metrics

* [riemann-bundle](https://github.com/phaneesh/riemann-bundle) - 简化 dropwizard 指标集成到 Riemann 中
* [metrics](http://metrics.dropwizard.io/3.1.0/manual/third-party/) - 指标库

### Logging

* [dropwizard-gelf](https://github.com/gini/dropwizard-gelf) - Dropwizard 的插件包支持记录到支持 GELF 的服务器
* [dropwizard-raven](https://github.com/tradier/dropwizard-raven) - 用于将错误记录到 Sentry 的 Dropwizard 集成
* [dropwizard-logstash-encoder](https://github.com/Wikia/dropwizard-logstash-encoder) - 使用 logstash-logback-encoder 发送日志的 Dropwizard 日志插件

### Scheduled/Recurrence Jobs

* [dropwizard-quartz](https://github.com/jaredstehler/dropwizard-quartz) - 集成 Guice 和 Quartz 的简单 Job Scheduler 实现.
* [dropwizard-jobs](https://github.com/spinscale/dropwizard-jobs) - dropwizard 的 Quartz 集成
* [dropwizard-sundial](https://github.com/timmolter/dropwizard-sundial) - 使用日晷在 Dropwizard 中安排工作

### Guice

* [dropwizard-guice](https://github.com/HubSpot/dropwizard-guice) - 添加对 Guice 的支持.
* [dropwizard-guicey](https://github.com/xvik/dropwizard-guicey) - Dropwizard guice 集成
* [dropwizard-guicier](https://github.com/HubSpot/dropwizard-guicier) - 用于处理 Guice 集成的 Dropwizard 包.

### Deployment

* [WizToWar](https://github.com/twilio/wiztowar) - 从您的 Dropwizard 应用程序构建 WAR
* [wizard-in-a-box](https://github.com/rvs-fluid-it/wizard-in-a-box) - 部署 Dropwizard 应用程序作为一场战争

## Tutorials

* [Getting Started](http://www.dropwizard.io/0.9.2/docs/getting-started.html)
* [Official docs](http://www.dropwizard.io/0.9.2/docs/manual/index.html)
* [Dropwizard internals](http://www.dropwizard.io/0.9.2/docs/manual/internals.html)
* [Dropwizard Modules Directory](http://modules.dropwizard.io/)

## Guides

* [Serving Static Assets with DropWizard](https://spin.atomicobject.com/2014/10/11/serving-static-assets-with-dropwizard/)
* [Hooking up Custom Jersey Servlets in Dropwizard](https://spin.atomicobject.com/2015/03/30/jersey-servlets-dropwizard/)
* [Using Hibernate DAOs in DropWizard Tasks](https://spin.atomicobject.com/2015/02/03/dropwizard-hibernate-dao/)
* [Heroku for Highly Available Dropwizard Apps](http://techbytes.anuragkapur.com/2015/05/heroku-for-highly-available-dropwizard.html?m=1)
* [Enabling Newrelic for Dropwizard](http://kyleboon.org/blog/2013/09/23/newrelic-for-dropwizard/)
* [Application Health Checks with DropWizard](http://willhamill.com/2014/12/04/application-health-checks-with-dropwizard)
* [Using Hystrix with Dropwizard](http://christopher-batey.blogspot.com/2014/08/using-hystrix-with-dropwizard.html)
* [Using Dropwizard in combination with Elasticsearch](https://www.gridshore.nl/2014/05/15/using-dropwizard-combination-elasticsearch/)
* [Deploy a Dropwizard Unikernel to AWS](https://boxfuse.com/blog/dropwizard-aws.html)
* [Use Consul's KV store for Dropwizard settings](http://www.remmelt.com/post/use-consuls-kv-store-for-dropwizard-settings/)
* [Deploying Dropwizard on App Engine Flex](https://www.aytech.ca/blog/dropwizard-app-engine-flexible-env/)
* [Measuring the performance of your Dropwizard application](https://www.aytech.ca/blog/measuring-performance-dropwizard-application/)
* [Heroku + Gradle + Dropwizard](https://www.aytech.ca/blog/heroku-gradle-dropwizard/)

## Community

* [dropwizard-user](https://groups.google.com/forum/#!forum/dropwizard-user)
* [StackOverflow](https://stackoverflow.com/questions/tagged/dropwizard)
* [`@dropwizardio` on twitter](https://twitter.com/dropwizardio)

## Videos

* [Instant-ish Real Service Architecture](https://vimeo.com/37930578)

## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/stve/awesome-dropwizard/blob/master/CONTRIBUTING.md) 第一的.

## Awesome!

查看更多 [awesome projects](https://github.com/sindresorhus/awesome).

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Steve Agalloco](https://beforeitwasround.com) 已放弃该作品的所有版权和相关或邻接权.
