<div class="github-widget" data-repo="petk/awesome-dojo"></div>
## Awesome Dojo

<a href="https://raw.githubusercontent.com/sindresorhus/awesome"><img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" alt="Awesome" height="18"></a>
[![CCO License](https://img.shields.io/badge/license-CC0-blue.svg?style=plastic "CC0 License")](#contributing-and-license)
[![Project Maintained](https://img.shields.io/badge/project-maintained-brightgreen.svg?style=plastic "Project Maintained")](https://github.com/petk/awesome-dojo/commits/master)
[![Build Status](https://img.shields.io/travis/petk/awesome-dojo/master.svg)](https://travis-ci.org/petk/awesome-dojo)

精选清单 [Dojo JavaScript Toolkit](http://dojotoolkit.org) 图书馆、资源和其他闪亮的东西.

灵感来自 GitHub 上的“awesome-*”趋势.

 &gt; 一个 JavaScript 工具包，可以节省您的时间并随着您的开发过程进行扩展. 提供构建 Web 应用程序所需的一切. 语言实用程序、UI 组件等都集中在一个地方，旨在完美地协同工作.


## Index



## DojoToolkit.org resources and documentation

* [API](http://dojotoolkit.org/api/) - Dojo 工具包的 API 参考
* [Roadmap](https://github.com/dojo/meta/wiki/Roadmap) Dojo 路线图（所有版本）
* [Blog](http://dojotoolkit.org/blog/) - Dojo 工具包博客
* [Demos](http://demos.dojotoolkit.org/demos/) - Dojo 工具包演示
* [Reference guide](https://github.com/dojo/docs) - [http://dojotoolkit.org/reference-guide/1.10/](http://dojotoolkit.org/reference-guide/1.10/)
* [Tutorials](http://dojotoolkit.org/documentation/) - Dojo Toolkit 的授权和更新教程
* [Dojo Meta](https://github.com/dojo/meta) - Dojo 2 贡献和编码指南
* [Dojo Website](https://github.com/dojo/dojo-website) - Dojo Toolkit 1.x 到 2.x 过渡的网站




## Tutorials

* [Dojo and Bootstrap FAQ](https://www.sitepen.com/blog/2014/08/13/dojo-faq-how-do-i-use-bootstrap-with-dijit/) - 如何在 Dijit 中使用 Bootstrap
* [Dojo Toolkit 1.9 tutorial](https://github.com/cepa/dojo-tutorial) - 使用 Dojo Toolkit 1.9 的教程
* [Dojo the Good parts](https://github.com/DavidSpriggs/Dojo--The-Good-Parts) - 2014 年 3 月 10 日至 13 日在棕榈泉举行的 ESRI 开发者峰会演示.
* [Pluralsight's Dojo tutorial](https://www.pluralsight.com/courses/dojo-fundamentals) - 学习 Dojo Toolkit 的视频教程



## Bootstraps and boilerplates

* [dboostrap](https://github.com/atoha/dbootstrap) - Bootstrap theme for Dojo
* [Dojo Boilerplate](https://github.com/csnover/dojo-boilerplate) - 使用 Dojo Toolkit 进行开发的起始样板
* [Dojo Twitter bootstrap](https://github.com/xsokev/Dojo-Bootstrap) - 使用 Dojo 实现 Twitter Bootstrap 框架
* [dojo.js](https://github.com/gpedro/dojo.js) - 使用 Jasmine 和 Gulp 开始你的 dojo 的简约样板.
* [dojo-node-boilerplate](https://github.com/kitsonk/dojo-node-boilerplate) - 在 NodeJS 上使用 Dojo Toolkit 的快速入门“模板”



## Packages, libraries and scripts

* [AngularJS Dojo](https://github.com/adrobisch/angular-dojo) - 用于 dojo 小部件的 AngularJS 指令
* [delite](https://github.com/ibm-js/delite) - HTML 自定义元素/小部件基础结构
* [deliteful](https://github.com/ibm-js/deliteful) - 多渠道（桌面/移动）用户界面自定义元素库
* [Dojo Foundation packages](http://packages.dojofoundation.org/) - Dojo Foundation 上可用的软件包
* [dojo-smore](https://github.com/kfranqueiro/dojo-smore) - 包含 Dojo/Store 实现的包
* [generator-dojo](https://github.com/bryanforbes/generator-dojo) - 用于 Dojo 项目的自耕农生成器
* 网格
    * [dgrid](http://dgrid.io/) - 充分利用现代浏览器和对象存储的下一代网格组件.
    * [gridx](http://oria.github.io/gridx/) - 快速渲染、良好模块化和基于插件架构的网格.
    * [xgrid](https://github.com/xblox/xgrid) - dgrid 扩展.
* [grunt-dojo](https://github.com/phated/grunt-dojo) - 在 Grunt 任务中构建 Dojo
* [grunt-dojo2](https://github.com/dojo/grunt-dojo2) - 在 Grunt 任务中构建 Dojo2
* [karma-dojo](https://github.com/garcimouche/karma-dojo) - A [Karma](http://karma-runner.github.io/) 插入.  Dojo 工具包的适配器.
* [Leadfoot](https://github.com/theintern/leadfoot) - 为 Selenium WebDriver API 带来跨平台一致性的 JavaScript 客户端库
* [Sitepen dstore](https://github.com/SitePen/dstore) - 数据基础架构框架，提供用于建模和与数据集合和对象交互的工具.
* [xaction](https://github.com/xblox/xaction) - 为用户操作提供 UI 和逻辑的组件.

#### Dojo 2

* [Dojo core](https://github.com/dojo/core) - 包含 TypeScript 和 JavaScript 核心实用程序的 Dojo 2 包
* [DOM Utilities](https://github.com/dojo/dom) - Dojo2 DOM 实用程序
* [Dojo Command Line Tooling](https://github.com/dojo/cli)   - Dojo2 应用程序的命令行工具
* [Dojo loader](https://github.com/dojo/loader) - 用于 Dojo2 的 AMD 加载程序.
* [Dojo routing](https://github.com/dojo/routing) - Dojo2 路由
* [Dojo compose](https://github.com/dojo/compose) - Dojo2 组合库
* [Dojo widgets](https://github.com/dojo/widgets) - Dojo 2 的核心 UI 组件库
* [Dojo has](https://github.com/dojo/has) - 特征检测库
* [Dojo shim](https://github.com/dojo/shim) - 提供 ES6+ 功能模块化填充的模块
* [Dojo parse](https://github.com/dojo/parser) - 用于声明性实例化小部件的包.
* [Dojo2 App](https://github.com/dojo/app) - Dojo 2 的应用程序框架（示例）





## Serverside integrations

* [Dojango](https://github.com/klipstein/dojango/) - Dojo 和 Django Python 框架集成
* [dojo-rails](http://robin850.github.io/dojo-rails/) - Dojo 和 Ruby on Rails 框架集成
* [Dojo Maven](https://github.com/cometd/dojo-maven) - Dojo 工具包的 Maven 包装
* ASP.NET
    * [Dojo & ASP.NET](https://www.codeproject.com/Articles/650443/DataGrid-View-with-Sorting-and) - 使用 Dojo EnhancedGrid、JsonRest Store、Entity Framework、SQL Server、ASP.NET MVC Web API 进行排序和分页的 DataGrid 视图
    * [Dojo.NET](https://github.com/lstratman/Dojo.NET) - .NET 类库，使用 Dojo 工具包为 ASP.NET 网站（WebForms 和 MVC，包括 Razor）提供 WebControl 绑定.
    * [Reactive Extensions](https://github.com/Reactive-Extensions/RxJS-Dojo) - Dojo 工具包的反应式扩展绑定
* 爪哇
    * [Dojofaces](http://www.dojofaces.org) - 帮助 JSF 开发人员将 Dojo 小部件与 JSF 支持 bean 连接起来的项目
    * [DWR](http://directwebremoting.org/dwr/index.html) - 在服务器上启用 Java 并在浏览器中启用 JavaScript 的库
    * [Grails](https://grails.org/) - 支持 Dojo 的开源全栈 Web 应用程序框架 [plugin](http://grails.org/plugin/dojo)
    * [LightStreamer](http://www.lightstreamer.com/) - 集成了 Dojo 的服务器
    * [Spring](https://www.sitepen.com/blog/2011/08/11/how-do-you-use-the-dojo-store-jsonrest-api-with-spring/) - 如何整合Spring和Dojo
    * [Websphere](http://www-03.ibm.com/software/products/en/appserv-was) - 应用服务器集成了Dojo
* 节点.js
    * [dojo-node](https://github.com/agebrock/dojo-node) - 用于 Node.js 的 Lightwave Dojo 包装器
    * [Dojos](https://github.com/supnate/dojos) - NodeJS 上的服务器端道场
    * [Node.js integration](http://dojotoolkit.org/documentation/tutorials/1.10/node/) - 教程如何使用 Dojo 和 Node.js
* PHP
    * [Dojo & Composer](https://github.com/zoopcommerce/pixie) - 包括 Dojo 在内的 zoop 包的自定义 Composer 安装程序
    * [Dojo & Symfony PHP framework](https://www.sitepen.com/blog/2011/09/06/what-is-the-best-way-to-use-dojo-with-a-symfony-backend/) - 将 Dojo Toolkit 与 Symfony PHP 框架集成
    * [Dojo & Zend PHP framework](https://github.com/superdweebie/DojoModule) - 通过 DojoModule 将 Dojo Toolkit 与 Zend Framework 集成



## Testing

* [Intern](https://github.com/theintern/) - 用于 JavaScript 的下一代代码测试堆栈.
* [Intern User guide](https://theintern.github.io/intern/#what-is-intern) - 关于如何使用 The Intern 的相当完整的手册
* [Intern Yeoman page objects](https://github.com/glamb/generator-internjs-pageobjects/) - 用于创建单元测试和套件的 Yeoman 生成器
* [Intern Yeoman generator](https://github.com/naglalakk/generator-intern) - Yeoman 发电机 - 实习生



## Applications

* [AuShada](https://github.com/dreaswar/AuShadha) - 用于电子病历（EMR）和公共卫生管理的 Django 和 Dojo 应用程序
* [dapi](https://github.com/dojo/dapi) - node.js Dojo API 查看器
* [Dig Dug](https://github.com/theintern/digdug) - 用于启动 WebDriver 服务隧道的 JavaScript 库
* [Dojo Demo](https://github.com/rmurphey/dojo-demo) -道场演示
* [dojorama](https://github.com/sirprize/dojorama) - 基于 Dojo 1.9、Twitter Bootstrap 3 和历史 API 的单页演示应用程序
* [Dojox application](https://github.com/dmachi/dojox_application) - 适用于手机、平板电脑和台式机的 Dojox 应用程序框架
* [js-doc-parse](https://github.com/dojo/js-doc-parse) - 用于解析 dojo JavaScript 文件和提取内联文档的库
* [rstwiki](https://github.com/phiggins42/rstwiki) - 使用 Python 和 Dojo 工具包构建的简单 reST/wiki 系统
* [Scripted](https://github.com/scripted-editor) - Scripted 是一个快速、轻量级的代码编辑器，最初专注于 JavaScript 编辑
* [todomvc](https://github.com/tastejs/todomvc) - 帮助您选择一个 MV\* 框架 - todo 应用示例
* [Dojo2 Example](https://github.com/dojo/examples) - 道场 2 示例
* [xamiro](https://github.com/xblox/xamiro) - PHP 和 JavaScript 中类似 IDE 的文件管理器，具有最小的依赖性.
* [Windows-dist](https://github.com/flysurfer28/windows-dist) - 用于物联网和原型制作的全自动化套件.



## Themes

* [dijit-claro-stylus](https://github.com/kfranqueiro/dijit-claro-stylus) - 将 Dijit 的 Claro 主题从 LESS 直接转换为 Stylus.
* [Flat Dojo Theme](http://yiweima.github.io/flatdojo/) - Esri 平面数字设计
* [Semantic Dojo Theme](http://websemantics.github.io/semantic-dojo/) - 响应式 Dojo 主题，利用了 [Semantic UI](http://semantic-ui.com/) 框架.



## TypeScript

* [Definitive TypeScript Guide](https://www.sitepen.com/blog/2013/12/31/definitive-guide-to-typescript/) - 关于 TypeScript 特性和功能的指南
* [Dojo to Typescript Converter](https://github.com/stopyoukid/DojoToTypescriptConverter) - 从 dojo api.json 文件创建与 typescript 兼容的声明的 typescript 脚本.
* [Dojo-TypeScript](https://github.com/schungx/Dojo-TypeScript) - 使用带有 Microsoft TypeScript 0.9.5 的 Dojo 1.9 AMD 风格
* [Dojo Typings](https://github.com/dojo/typings) - Dojo 1 TypeScript 类型库（包括 Dijit 和 DojoX）



## Community

* [Brazilian Facebook Group](https://www.facebook.com/groups/288220914564119/) - Facebook 上的巴西 Dojo 社区
* [Dojo mailing list](http://dojotoolkit.org/community/) - 问题和讨论的邮件列表
* [Dojo on StackOverflow](http://stackoverflow.com/questions/tagged/dojo) - StackOverflow 上的 Dojo 工具包支持
* [Dojo on Twitter](https://twitter.com/dojo) - Dojo 的 Twitter 帐户
* [Facebook Group](https://www.facebook.com/groups/4375511291/) - Facebook 上的 Dojo 社区
* [Google Plus Community](https://plus.google.com/communities/107837593684207188221) - Google Plus 上的 Dojo 社区
* [Linked In Dojo Ajax Toolkit Developers Group](https://www.linkedin.com/groups/Dojo-Ajax-Toolkit-Developers-71399) - LinkedIn 上的 Dojo 社区
* [Linked In Dojo Toolkit Group](https://www.linkedin.com/groups/dojo-toolkit-81926) - LinkedIn 上的 Dojo 社区
* [Reddit Community](https://www.reddit.com/r/dojo/) - 越来越多的社区在 Reddit 上讨论 Dojo（仅限受邀者）.
* [SensioLabs Connect Club](https://connect.sensiolabs.com/club/dojo-toolkit) - 面向 PHP 和 Symfony 开发人员的 Sensiolabs Connect Dojo 工具包俱乐部
* [IRC](http://irc.lc/freenode/dojo) - 大型且活跃的 IRC 支持频道.
* [Meetup](https://www.meetup.com/topics/dojo/) - 在本地参与并找到本地用户组.



## Other Awesome Lists

* [awesome-javascript](https://github.com/sorrycc/awesome-javascript) - 很棒的 JavaScript 列表
* [awesome-javascript-books](https://github.com/heatroom/awesome-javascript-books) - 很棒的 JavaScript 书籍
* 很棒的列表：
    * [awesome](https://github.com/sindresorhus/awesome) - 很棒的清单
    * [awesome-awesome](https://github.com/emijrp/awesome-awesome) - 很棒的清单
    * [GetAwesomeness](https://getawesomeness.herokuapp.com/) - 很棒的清单
    * [lists](https://github.com/jnv/lists) - 很棒的清单
    * [awesome-all](https://github.com/bradoyler/awesome-all) - 很棒的清单
    * [awesome-awesome](https://github.com/erichs/awesome-awesome) - 很棒的清单



## Contributing and License

非常欢迎您 [contribute](https://github.com/petk/awesome-dojo/blob/master/CONTRIBUTING.md) 以及这个很棒的 Dojo 工具包列表. 非常感谢所有人 [contributors](https://github.com/petk/awesome-dojo/graphs/contributors) 谁帮助建立了这份名单.

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Peter Kokot](https://github.com/petk) 已放弃该作品的所有版权和相关或邻接权.
