<div class="github-widget" data-repo="folkswhocode/awesome-diversity"></div>
## Awesome Diversity 

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Mencionado en Comunidad Tecnológica](https://github.com/comunidad-tecnologica/comunidad-tecnologica/blob/master/img/comunidad-tecnologica.svg)](https://github.com/comunidad-tecnologica/comunidad-tecnologica)

 :sparkles：关于技术多样性的精彩文章、网站和资源的精选列表.  ：火花：

此列表包含有关多样性的各种资源，更具体地说是技术多样性，包括帖子、演讲、可操作资源、会议、社交媒体倡导者等. 该列表的目标是为愿意在日常行动中做得更好以使科技行业成为更具包容性的地方的科技公司和社区以及寻求进一步阅读主题的个人提供快速访问多样性的信息他们可能会对技术领域的多样性和公平性感兴趣.

**始终在进行中.**


- [Diverse Figures In Tech History](https://github.com/folkswhocode/awesome-diversity/blob/master//FIGURES.md)

## Organizations

为技术带来多样性的组织.

- [1 Million Women To Tech](https://github.com/1millionwomentotech/toolkitten) - 其使命是到 2020 年为 100 万女性提供免费编码教育的组织.提供免费（DIY）和付费（认证）课程.
- [Algorithmic Justice League](https://www.ajlunited.org/) - Collective that aims to fight algorithmic bias.
- [AnyKey](https://www.anykey.org) - 其使命是帮助在电子竞技中为游戏社区的边缘化成员创造公平和包容的空间的组织.
- [Black Compute HER](https://blackcomputeher.org/) - 致力于支持黑人妇女和女孩的计算+技术教育和劳动力发展.
- [Black Girls Code](http://www.blackgirlscode.com/) - 致力于向世界展示黑人女孩可以编码的组织.
- [Black Girl Gamers](http://blackgirlgamers.com)  - 支持黑人女玩家的安全空间. 还发现于：
  - [Twitch](https://www.twitch.tv/blackgirlgamers)
  - [Steam](https://steamcommunity.com/groups/BlackGirlsWhoPlayGames)
- [Blacks In Technology](https://www.blacksintechnology.net/) - 组织专注于通过建立世界级技术卓越和创新的蓝图来“打破鸿沟”.
- [Black Women in Computational Biology](https://www.blackwomencompbio.org/) - 一个由黑人女性组成的交叉社区，她们正在致力于（或感兴趣）将计算和定量科学与生物学相结合的职业.
- [Bridge Troll](https://www.bridgetroll.org/) - 由志愿者组织的活动，旨在为人们提供技术支持.
- [Brown Girl, Tech World](https://www.browngirltech.world/) - 数字安全空间和非营利组织，面向从事科技行业的棕色人种妇女和女孩.
- [Code 2040](http://www.code2040.org/) - 通过各种计划和奖学金，Code2040 是一项伟大的举措，为黑人和拉丁裔人才创造技术机会.
- [Codebar](https://codebar.io/) - Codebar 是一项非营利性计划，通过定期举办编程研讨会来促进多元化技术社区的发展.
- [Code Liberation](http://codeliberation.org/) - Code Liberation 促进女性、非二元性别、女性和女性认同者创建数字游戏和创意技术，以实现 STEAM 领域的多样化.
- [Consensual Software](http://consensualsoftware.com/) - 一个倡导在软件设计中更好地使用许可的开源项目.
- [Computational Biology in Sweden, RSG-Sweden](http://rsg-sweden.iscbsc.org/) - 一个由学生和研究人员组成的团队共同努力，让更多人对计算生物学感兴趣，并将人们联系起来，在瑞典建立一个多元化和包容性的社区.
- [Dear Tech People](http://www.deartechpeople.com) - 100 家顶级科技公司的种族和性别多样性排名.
- [Dev Color](https://www.devcolor.org/) - 一个旨在促进黑人软件工程师职业发展的非营利组织.
- [Disability Visibility Project](https://disabilityvisibilityproject.com/) - 一个致力于创建、共享和扩大残疾媒体和文化的在线社区.
- [Diversify Tech](https://www.diversifytech.co/) - 为技术领域代表性不足的人收集的资源.
- [Diversity Charter](http://diversitycharter.org/) - 章程表明您关心多样性.
- [Django Girls](https://djangogirls.org/) - 非营利组织和社区，赋予女性权力并帮助女性组织编程研讨会.
- [EquitableTech](http://equitabletech.com) - 致力于使技术多样化的非营利组织，重点是开源.
- [FrameShift Consulting](https://frameshiftconsulting.com/) - FrameShift 开源他们出色的 Ally Skills Workshop、会议事件响应材料和许多其他资源，允许扩展创建欢迎、包容、多样化的文化.
- [Fund Club](http://joinfundclub.com/) - Fund Club 为心理健康、多样性、包容性、反骚扰等众多倡议筹集资金.
- [Geek Girls Carrots](http://gocarrots.org) - 自 2011 年以来吸引女性加入科技行业.
- [Girl Develop It](https://www.girldevelopit.com/) - 非营利组织，旨在为有兴趣学习网络和软件开发的女性提供负担得起且无需评判的机会.
- [Girl Gamers](https://www.reddit.com/r/GirlGamers/) - 供女性讨论游戏、极客文化中的女性以及因性别而产生的经历的社区.
- [Girls In Tech Global Classroom](http://globalclassroom.girlsintech.org) - 为女孩和女性免费提供技术相关课程（例如 3-D Tinkercad 设计）的组织.
- [Girls Who Code](https://girlswhocode.com/) - 旨在缩小技术方面的性别差距的组织.
- [GoodForPoc](https://github.com/GoodForPoC/GoodForPoC) - 技术领域有色人种的包容性公司名单.
- [Hack The Hood](http://www.hackthehood.org/) - 向低收入有色人种青年介绍技术职业的非营利组织.
- [Hidden Genius Project](http://www.hiddengeniusproject.org/) - 将年轻黑人男性与成为高绩效企业家和技术专家所需的一切联系起来的计划.
- [Kapor Center](http://www.kaporcenter.org/) - Kapor 组织家族致力于为代表性不足的有色人种消除科学、技术、工程和数学 (STEM) 教育和技术职业的障碍.
- [Lesbians Who Tech](https://lesbianswhotech.org/) - Lesbians Who Tech 是一个由科技界或科技界酷儿女性（以及热爱她们的人）组成的社区.
- [OS4W](https://www.os4w.org) - OS4W 旨在成为一种资源，将所有女性（包括有色人种女性和变性女性）与欢迎、包容和欣赏其贡献者多样性的开源项目联系起来.
- [Open Source Diversity](https://opensourcediversity.org/) - Open Source Diversity 是一个收集资源、建立网络和协作以在自由和开源软件社区中实现更多多样性和包容性的社区.
- [Open Sourcing Mental Illness](https://osmihelp.org/) - Open Sourcing Mental Illness 是一家非营利性公司，致力于提高认识、教育和提供资源以支持技术和开源社区的心理健康.
- [Out In Tech](https://outintech.com) - 联合 LGBTQ+ 技术社区的非营利组织.
- [OpenCIDER](https://selgebali.gitbook.io/opencider/) - A community building effort to promote computational inclusion and serve as digital equity resource.
- [ParadigmIQ](https://www.paradigmiq.com/) - Paradigm 提供一系列研讨会、培训和评估，以帮助实现多样性、包容性、归属感、保留率等.
- [People Of Creativity](http://www.peopleofcreativity.xyz/) - 专注于创建一个共享机会、经验和想法的社区的组织，最终改善少数群体在整个创意产业中的代表性.
- [PHP Women](http://phpwomen.org) - 在 PHP 社区内提供支持的包容性全球网络.
- [Ping A Programadoras](https://pingprogramadoras.org/) - 妇女和非二元性别人群，其目的是在技术领域进行反思和赋权.
- [Pink Programming](https://www.pinkprogramming.se) - 为女性、跨性别者和非二元性社区组织代码活动的非营利组织.
- [Project Alloy](https://www.projectalloy.org/) - Project Alloy 正在建立一个更具包容性的技术社区，一次召开一次会议，向处于职业生涯早期且在技术领域代表性不足的人们提供财政补助和其他资源.
- [Project Include](http://projectinclude.org/) - 非营利组织，使用数据和宣传来加速科技行业的多元化和包容性解决方案.
- [PyLadies](http://www.pyladies.com/) - 国际指导小组，致力于帮助更多女性成为 Python 开源社区的积极参与者和领导者.
- [Q-Space](http://qhumanity.org/index.php/our-projects/q-space/) - 位于中国北京的酷儿和女权主义创客空间，提供学习空间和社区行动以促进变革.
- [Rails Girls](http://railsgirls.com/) - 旨在为女性提供工具和社区以了解技术和建立她们的想法的组织.
- [Rails Girls Summer Of Code](https://railsgirlssummerofcode.org/) - Rails Girls Summer of Code 是一项全球奖学金计划，旨在为开源带来更多多样性.
- [R-Ladies](https://rladies.org/) - 一个促进 R 社区性别多样性的全球性组织.
- [RightsTech Women](https://rightstech.org) - 总部位于瑞士的非营利组织，将机器人技术、技术和针对女孩和妇女的人权培训相结合. 
- [Scala Bridge](http://www.scalabridge.org/) - 建立一个包容性的 Scala 社区，为女性举办介绍性编程研讨会.
- [She++](https://sheplusplus.org) - 非营利组织，致力于通过消除围绕技术职业的负面刻板印象来增强技术领域代表性不足的群体的能力.
- [She Can Code](https://shecancode.io/) - 一个以赋权女性进入并留在科技行业为使命的组织.
- [Techqueria](https://techqueria.org/) - 一个非营利组织，服务于最大的拉丁裔技术社区.
- [Techtonica](https://techtonica.org/) - Techtonica 与科技公司合作，为湾区女性和非二元性别、与女性相邻的低收入成年人提供带津贴和工作安置的技术学徒培训.
- [Tech Ladies](https://www.hiretechladies.com/) - Tech Ladies 将女性与科技领域的最佳工作和机会联系起来.
- [Teens Exploring Technology](http://exploringtech.org/) - 鼓励市中心的青少年黑人和拉丁裔男性成为城市社区变革的催化剂.
- [TLA Black Women In Tech](https://theblackwomenintech.com/) - 非营利组织，致力于通过让黑人女性人才脱颖而出并让公司接触到黑人女性人才，从而在科技领域搭建机会桥梁.
- [TLA Women In Tech](http://tlawomenintech.org/) - 致力于提高技术领域的性别平衡和平等的工作组.
- [Trans*H4CK](http://www.transhack.org/) - Trans\*H4CK 通过改善获得社会服务的机会、促进性别安全和社区可持续性，同时提高跨性别*技术创新者和企业家的知名度，从而赋予跨性别者、性别不一致者、性别和非二元性别者权力.
- [Women Love Tech](https://womenlovetech.com/)  - 推出 Women Love Tech 的愿景是分享对技术的热情和热爱. 从那时起，Women Love Tech 已经发展成为一本生活方式科技数字杂志，面向热爱一切可以改善日常生活的科技的女性.
- [Women Make](https://womenmake.com/) - 一个女性处于最前沿的社区.
- [Women Hack For Non-Profits](http://www.womenhackfornonprofits.com/) - 一个由技术女性组成的社区，为非营利组织和有事业的个人构建开源项目.
- [Women Techmakers](https://www.womentechmakers.com/) - 为技术领域的女性提供知名度、社区和资源的 Google 计划.
- [Women Who Code](https://www.womenwhocode.com/) - Women Who Code 是一个全球社区，通过资源、工作委员会、会议奖学金和其他会员福利，赋予女性权力，使其在技术领域脱颖而出.
- [Women Who Go](https://www.womenwhogo.org/) - 一个专注于构建更加多样化和包容性的 Golang 社区的网络.
- [Women Who Tech](https://www.womenwhotech.com/) - 非营利组织，汇集才华横溢的知名女性，在技术领域开辟新天地，以改变世界并激发变革.
- [Wonder Women Tech](https://wonderwomentech.com/) - 制作全年计划和国家和国际会议的组织，以突出、教育和庆祝女性和 STEAM（科学、技术、工程、艺术、数学）、创新和创业精神的多样性.
- [Write/Speak/Code](https://www.writespeakcode.com/) - 一个 501c3 免税非营利组织，举办年度会议和聚会活动，旨在帮助您通过写作、演讲和开源充分掌握您的专业知识.
- [YesWeTech](http://yeswetech.org/) - 女权主义社区为对技术感兴趣的女性创造平等和自豪的文化.
- [Natives in Tech](https://nativesintech.org) - Natives in Tech 是本地和非本地软件开发人员的联盟，其目标是支持软件应用程序开发，以加强本地人的信念、知识和身份. 
- [Brazilians in Tech](https://braziliansintech.com/)- Brazilians in Tech 是巴西第一个为从事数字技术工作或对数字技术感兴趣的女性汇集科学技术领域最相关机会的巴西平台.
- [Latinas in computing](https://latinasincomputing.org/) - 一个由计算方面的拉丁裔创建并为之服务的社区，其使命是促进他们在计算相关领域的代表性和成功.
- [Latinas in tech](https://www.latinasintech.org/)  - 一个非营利组织，旨在联系、支持和赋权从事科技工作的拉丁裔女性. 我们与顶尖科技公司携手合作，为学习、指导和招聘创造安全的空间.

## Events

以下是特别努力包容和鼓励多样性的活动清单

- [ACT-W National Conference](http://www.act-w.org/) - 由 ChickTech 主办，ACT-W National 专注于为您提供职业发展、领导力、技术和多样性方面鼓舞人心且可操作的教育.
- [AlterConf](https://alterconf.com/) - AlterConf 是一个巡回会议系列，为边缘化人群和那些在科技和游戏行业支持他们的人提供安全的机会.
- [DDD Europe](https://dddeurope.com)  - Domain-Driven Design Europe 专注于软件设计和建模. 他们对多样性和改善活动有着惊人的承诺.
- [Lambda World](http://www.lambda.world/)  - Lambda World 是一个功能性编程会议，其意识形态是赋予技术领域代表性不足的少数群体权力. 在这种心态下，我们采取了一些我们遵循的行动，例如提供补助金来支付门票和住宿，举办包容性研讨会，并通过提供旅游活动和诸如婴儿床和婴儿车.
- [PyMCon](https://pymc-devs.github.io/pymcon//) - PyMCon 是由 PyMC 社区组织的针对贝叶斯社区的异步优先虚拟会议，从组委会到与会者都非常强调多样性和包容性.
- [REFACTR.TECH](https://www.refactr.tech) - REFACTR.TECH 专注于技术，同时为围绕技术的多样性、包容性和交叉性进行深思熟虑和细致入微的对话创造安全空间.

## Ally Resources

以下是各种类型的资源（谈话、文档、博客文章等）的集合，可以成为任何多元化努力的盟友.

- [Better Male Allies](https://code.likeagirl.io/@betterallies) - 通过代码像一个女孩.
- [Contributor Covenant](https://www.contributor-covenant.org/) - 由 Coraline Ada Ehmke 撰写.
- [Inclusion At Work](https://inclusionatwork.co) - 詹妮弗·金.
- [Resources For Allies](https://github.com/larahogan/ally-resources) - 劳拉·霍根 (Lara Hogan).

## Actionable Resources

以下是个人资源列表，其中包含可作为任何多元化努力的盟友的可操作项目.

- [5 Ally Actions | June 15, 2018](https://code.likeagirl.io/5-ally-actions-june-15-2018-cfdef1e590cb) - 更好的盟友.
- [10 Actionable Ways To Actually Increase Diversity In Tech](https://www.fastcompany.com/3041339/10-commitments-that-will-make-a-difference-in-increasing-diversity-in-tec) - 凯瑟琳·阿什克拉夫特.
- [Bias and Hiring: How We Hire UX Researchers](https://medium.com/firefox-ux/bias-and-hiring-how-we-hire-ux-researchers-6f9db9f8d670) - 莎朗·包蒂斯塔 (Sharon Bautista).
- [Bootstrapping Inclusion](http://www.attack-gecko.net/2017/10/22/bootstrapping-inclusion/) - 杰森黄.
- [Building Inclusive Communities](https://medium.com/@fox/building-inclusive-communities-232dc01d1aba) - 卡罗琳娜·斯祖尔 (Karolina Szczur).
- [Dev Team Diversity #Realtalk](https://www.devmynd.com/blog/2015-08-09-dev-team-diversity-realtalk/) - 莎拉·梅.
- [Fundamentals of Effective Allyship](https://medium.com/@fox/fundamentals-of-effective-allyship-468bd0afe89b) - 卡罗琳娜·斯祖尔 (Karolina Szczur).
- [Gender Decoder For Job Ads](http://gender-decoder.katmatfield.com/) - 作者：凯特·马特菲尔德.
- [How A Common Interview Question Fuels The Gender Pay Gap (And How To Stop It)](https://www.nytimes.com/2018/05/01/upshot/how-a-common-interview-question-fuels-the-gender-pay-gap-and-how-to-stop-it.html) - 克莱尔·凯恩·米勒 (Claire Cain Miller).
- [How Organizations Can Become More Inclusive Of People With Disabilities](https://opensource.com/article/17/12/diversity-and-inclusion) ——迈克尔·舒尔茨.
- [How To Build Inclusive Culture](https://medium.com/@nmsanchez/how-to-build-inclusive-culture-360160f417a1) - 妮可桑切斯.
- [How To Fight Sexism On Your Company's Slack](https://lifehacker.com/how-to-fight-sexism-on-your-companys-slack-1821302639) - 尼克·道格拉斯.
- [Increase Diversity In Our Speaker Line Up](https://github.com/lnug/feedback/issues/107#issuecomment-296282498) - 索莱达·佩纳德斯 (Soledad Penadés).
- [On Improving Diversity In Hiring](https://cate.blog/2017/09/28/on-improving-diversity-in-hiring/) - 凯特休斯顿.
- [So, You Just Learned There Are Issues With The Tech Industry. Now What?](https://github.com/stephmarx/so-you-just-learned) - 斯蒂芬妮·斯莱特里 (Stephanie Slattery).
- [Top 10 Everyday Actions Any Hiring Manager Can Do To Diversify Their Candidate Pipeline](https://code.likeagirl.io/are-you-even-trying-69e270ef283f) - 通过代码像一个女孩.
- [Tracking Compensation And Promotion Inequity](http://larahogan.me/blog/inclusion-math/) - 劳拉·霍根 (Lara Hogan).
- [What Does Sponsorship Look Like?](http://larahogan.me/blog/what-sponsorship-looks-like/) - 劳拉·霍根 (Lara Hogan).
- [You Have A Culture Problem. Here's How To Avoid A Diversity Disaster](https://medium.com/projectinclude/you-have-a-culture-problem-heres-how-to-avoid-a-diversity-disaster-178eaecd7e3f) - Ellen K. Pao.

## Projects

支持代表性不足的群体并且您可以参与的开源项目.

- [A11y Project](https://www.a11yproject.com/) - 社区驱动的努力，使数字可访问性更容易.
- [Accessibility Cloud](https://www.accessibility.cloud/) - 以标准化、面向未来且易于使用的方式简化共享和获取可访问性数据.
- [CHAOSS D&I Workgroup](https://chaoss.community/metrics/) - 为项目收集资源以创建多样性和包容性报告.
- [Chayn](https://chayn.co/) - 一个志愿者网络，通过在网络上创建以幸存者为主导的交叉资源，在全球范围内解决基于性别的暴力问题.
- [Diversity Tickets](https://diversitytickets.org/)  - 帮助活动覆盖更多样化的受众. 并帮助您找到这些事件.
- [SignDict](https://signdict.org/) - 手语开放词典.
- [The Supernova Project](http://supernovaproject.org/) - 旨在为解决 LGBTQIA+ 社区内的虐待问题做出贡献的全球努力.
- [Wheelmap](https://wheelmap.org/) - 世界上最大的轮椅无障碍场所众包和开放数据库.
- [WikiProject Women in Red](https://en.wikipedia.org/wiki/Wikipedia:WikiProject_Women_in_Red) - 通过女性成就的传记和文章增加女性在维基百科上的代表性.

## Posts

关于技术的多样性和包容性的文章和帖子.

- [100 Women In Tech And Founders To Follow On Twitter](https://medium.com/athena-talks/100-women-in-tech-and-founders-to-follow-on-twitter-f98560b1a3c7) - 艾莉森·卡平 (Allyson Kapin).
- [30+ Diversity And Inclusion Activists And Organisations I Look Up To](https://medium.com/@fox/30-diversity-and-inclusion-activists-and-organisations-8b39b6bf537b) - 卡罗琳娜·斯祖尔 (Karolina Szczur).
- [A Brief History Of Women In Computing](https://hackernoon.com/a-brief-history-of-women-in-computing-e7253ac24306) - 法鲁克·阿特斯 (Faruk Ateş).
- [A Counterintuitive Way To Increase Diversity In Tech](https://medium.com/@rachelnabors/a-counterintuitive-way-to-increase-diversity-in-tech-31aea2ce6a50) - 雷切尔·纳博斯 (Rachel Nabors).
- [A Study Used Sensors To Show That Men And Women Are Treated Differently At Work](https://hbr.org/2017/10/a-study-used-sensors-to-show-that-men-and-women-are-treated-differently-at-work) - Stephen Turban、Laura Freeman 和 Ben Waber 着.
- [Accessibility 101: Introduction To Disability And Accessibility](https://www.youtube.com/watch?v=qM7wFZo5yfI) - 珍妮·莱·弗鲁里 (Jenny Lay-Flurrie). 
- [Advice For Women In Tech Who Are Tired Of Talking About Women In Tech](https://blog.valerieaurora.org/2018/03/11/advice-for-women-in-tech-who-are-tired-of-talking-about-women-in-tech/) - 瓦莱丽·奥罗拉 (Valerie Aurora).
- [Becoming A 10x Developer](https://kateheddleston.com/blog/becoming-a-10x-developer) - 凯特赫德勒斯顿.
- [Bias, Diversity, Backlash, Manifestos, And Rebuttals](https://code.likeagirl.io/bias-diversity-backlash-manifestos-and-rebuttals-834f7425180e) - 洛雷娜·巴尔巴 (Lorena A Barba).
- [Can We Talk About The Gender Pay Gap?](https://www.washingtonpost.com/graphics/2017/business/women-pay-gap/) - Xaquín González Veira 着.
- [Code Of Conduct Enforcement Warning Signs](https://otter.technology/blog/2017/12/28/code-of-conduct-enforcement-warning-signs/) - 水獭科技.
- [Creating Safe Places](https://medium.com/defensible-me/creating-safe-places-59158520c5d8) - 劳拉贝尔.
- [Designing Forms For Gender Diversity And Inclusion](https://uxdesign.cc/designing-forms-for-gender-diversity-and-inclusion-d8194cf1f51) - 萨布丽娜·丰塞卡 (Sabrina Fonseca).
- [Diverse Teams Feel Less Comfortable — And That’s Why They Perform Better](https://hbr.org/2016/09/diverse-teams-feel-less-comfortable-and-thats-why-they-perform-better) - David Rock、Heidi Grant 和 Jacqui Grey.
- [Ellen Pao: Has Anything Really Changed For Women In Tech?](https://mobile.nytimes.com/2017/09/16/opinion/sunday/ellen-pao-sexism-tech.html) - 包爱伦.
- [Emotional Labor Is The Unpaid Job Men Still Don't Understand](http://www.harpersbazaar.com/culture/features/a12063822/emotional-labor-gender-equality/) - 杰玛·哈特利 (Gemma Hartley).
- [Engineering A Culture Of Psychological Safety](https://blog.intercom.com/psychological-safety/) - 约翰鲁尼.
- [Gaming While Black: Casual Racism To Cautious Optimism](https://www.engadget.com/2015/01/16/gaming-while-black-casual-racism-to-cautious-optimism/) - 杰西卡康迪特.
- [Gender Bias? A Transgender Perspective!](https://code.likeagirl.io/gender-bias-a-transgender-perspective-de27f2cd3837) - 丹妮拉·彼得鲁扎莱克 (Daniela Petruzalek).
- [Getting Free Of Toxic Tech Culture](https://blog.valerieaurora.org/2018/01/17/getting-free-of-toxic-tech-culture/) - 瓦莱丽·奥罗拉 (Valerie Aurora) 和苏珊·吴 (Susan Wu).
- [Hidden Figures: How Silicon Valley Keeps Diversity Data Secret](https://www.revealnews.org/article/hidden-figures-how-silicon-valley-keeps-diversity-data-secret/amp/) - 经过
威尔埃文斯和 Sinduja Rangarajan.
- [How Can I Get A Diverse And Inclusive Team?](https://delawen.com/es/2019/06/how-can-i-get-a-diverse-team/) - María Arias de Reyna Domínguez 着.
- [How "Good Intent" Undermines Diversity And Inclusion](https://thebias.com/2017/09/26/how-good-intent-undermines-diversity-and-inclusion/) - 安娜丽.
- [How Tech's Lack Of Diversity Leads To Racist Software](http://www.sfgate.com/business/amp/How-tech-s-lack-of-diversity-leads-to-racist-6398224.php) - 文迪·李.
- [How To Be An Ally](https://andre.arko.net/2013/12/04/how-to-be-an-ally/) - 安德烈·阿尔科.
- [How To Maintain A Predominantly White Workplace](https://qz.com/work/1334187/how-to-maintain-a-predominantly-white-workplace/) - Leniece Flowers Brissett 着.
- [I'm Not Your Guy, Dude: Why Language Really Does Matter](https://hub.wiley.com/community/exchanges/educate/blog/2017/03/05/i-m-not-your-guy-dude-why-language-really-does-matter) - 黛安·鲁比诺 (Diane Rubino).
- [If You Can't Find A Spouse Who Supports Your Career, Stay Single](https://hbr.org/2017/10/if-you-cant-find-a-spouse-who-supports-your-career-stay-single) - 作者 Avivah Wittenberg-Cox.
- [If You Think Women In Tech Is Just A Pipeline Problem, You Haven't Been Paying Attention](https://medium.com/tech-diversity-files/if-you-think-women-in-tech-is-just-a-pipeline-problem-you-haven-t-been-paying-attention-cb7a2073b996) - 雷切尔托马斯.
- [Important Women In CS Who Aren't Grace Hopper](https://www.hillelwayne.com/post/important-women-in-cs/) - 希勒尔·韦恩 (Hillel Wayne).
- [Not Applicable: What Your Job Post Is Really Saying](https://where.coraline.codes/blog/not_applicable/) - 由 Coraline Ada 撰写.
- [On Toxic Jobs, Low Self-Esteem, & Interviewing](https://code.likeagirl.io/toxic-jobs-low-self-esteem-interviewing-6c4650a3c28a) - 雷切尔托马斯.
- [Racial Bias At Tech Companies Is Real](http://www.complex.com/life/2016/03/tech-diversity-problem) - 苏珊娜·韦斯 (Suzannah Weiss).
- [Recruiting For Privilege](https://techburst.io/recruiting-for-privilege-5f019741fac3) - 托比·吉勒布林 (Tobbe Gyllebring).
- [Software Development 450 Words Per Minute](https://www.vincit.fi/en/blog/software-development-450-words-per-minute/) - 盲人软件工程师 Tuukka Ojala.
- [Stop Saying That Diversity Means Lowering The Bar](https://work.qz.com/1175679/software-engineer-tracy-chous-mission-to-diversify-silicon-valley/) - 利亚·费斯勒 (Leah Fessler).
- [Strategies For Hiring Diverse Candidates](https://code.likeagirl.io/strategies-for-hiring-diverse-candidates-4d86ad693762/) - 乔伊·埃伯茨 (Joy Ebertz).
- [Striving To Be Seen: Black Girl Gamers On Twitch](https://www.engadget.com/2018/08/15/black-girl-gamers-twitch-partner-communities/) - 杰西卡康迪特.
- [Struggling For Investments, Silicon Valley Women Reluctant To Speak Out On Harassment](https://www.npr.org/sections/alltechconsidered/2017/11/16/564498133/struggling-for-investments-silicon-valley-women-reluctant-to-speak-out-on-harass) - 劳拉·赛德尔 (Laura Sydell).
- [Survey Finds That In Tech, Retaliation For Speaking Up About Workplace Discrimination Is Common](https://www.marketplace.org/2018/07/24/business/retaliation-workplace) - 珍妮特·阮和大卫·布兰卡乔.
- [Survival Tips For Women In Tech](https://patricia.no/2018/09/06/survival_tips_for_women_in_tech.html) - 帕特丽夏·阿斯 (Patricia Aas).
- [The Do's And Don'ts Of Being A Good Ally](http://theangryblackwoman.com/2009/10/01/the-dos-and-donts-of-being-a-good-ally/) - 通过 Carnythia.
- [The Other Diversity Dividend](https://hbr.org/2018/07/the-other-diversity-dividend) - By Paul Gompers and Silpa Kovvali.
- [The Perverse Incentives That Help Incels Thrive In Tech](https://www.wired.com/story/ellen-pao-the-perverse-incentives-that-help-incels-thrive-in-tech/) - 包爱伦.
- [The Tech Industry's Gender-Discrimination Problem](https://www.newyorker.com/magazine/2017/11/20/the-tech-industrys-gender-discrimination-problem) - Sheelah Kolhatkar 着.
- [There’s A Big Difference Between An Intention To Be Inclusive And A Strategy](https://qz.com/work/1308410/theres-a-big-difference-between-an-intention-to-be-inclusive-and-a-strategy/) - 金克雷顿.
- [This Is How Sexism Works In Silicon Valley My Lawsuit Failed. Others won't.](https://www.thecut.com/2017/08/ellen-pao-silicon-valley-sexism-reset-excerpt.html) - 包爱伦.
- [ThoughtWorks' Insights On Inclusivity](https://www.thoughtworks.com/insights/inclusivity):
  - [Inclusion Is Everyone's Business: Q&A For Individuals](https://www.thoughtworks.com/insights/blog/inclusion-everyone-s-business-qa-part-1).
  - [Inclusion Is Everyone's Business: Q&A For Companies](https://www.thoughtworks.com/insights/blog/inclusion-everyones-business-qa-companies).
- [Tools For White Guys Who Are Working For Social Change](http://xyonline.net/content/tools-white-guys-who-are-working-social-change-and-other-people-socialized-society-based) - 克里斯·克拉斯.
- [Trans-Inclusive Design](http://alistapart.com/article/trans-inclusive-design/) - 艾琳怀特.
- [True Diversity Is Intersectional](https://medium.com/projectinclude/true-diversity-is-intersectional-2282b8da8882) - 包爱伦.
- [We Need More Radical Solutions For Diversity And Inclusion](https://medium.com/projectinclude/we-need-more-radical-solutions-for-diversity-and-inclusion-26edaf4ab5a4) - Ellen K. Pao.
- [What Does It Mean To Be A Feminist Coder In 2018?](https://dev.to/xrwang/what-does-it-mean-to-be-a-feminist-coder-in-2018--25i3) - By Xiaowei R. Wang.
- [What I Learned From The Fall Of Ellen Pao](https://www.damemagazine.com/2018/03/15/what-i-learned-from-the-fall-of-ellen-pao/) - Madhushree Ghosh 着.
- [White Fragility In Teaching And Education Technology](https://www.edsurge.com/news/2018-08-23-white-fragility-in-teaching-and-education-an-interview-with-dr-robin-diangelo) - 玛丽乔玛达.
- [Who Killed The Junior Developer?](https://medium.com/@melissamcewen/who-killed-the-junior-developer-33e9da2dc58c) - 梅丽莎·麦克尤恩 (Melissa McEwen).
- [Why Are There Few Women In Tech? Watch A Recruiting Session](https://www.wired.com/story/why-are-there-few-women-in-tech-watch-a-recruiting-session/) - 杰西亨佩尔.
- [Why Diverse Teams Matter](http://er.educause.edu/articles/2016/5/why-diverse-teams-matter) - 布拉德麦克莱恩、凯瑟琳阿什克拉夫特和露西桑德斯.
- [Why Doesn't My Company Get Credit For Tackling Gender Diversity?](https://medium.com/projectinclude/why-doesnt-my-company-get-credit-for-tackling-gender-diversity-b38f0c63a33b) - Ellen K. Pao.
- [Why Don't European Girls Like Science Or Technology?](https://news.microsoft.com/europe/features/dont-european-girls-like-science-technology/) - 由微软.
- [Why I Care About Diversity In Tech](https://medium.com/little-thoughts/why-i-care-about-diversity-in-tech-31bde2de8532) - 特雷西周.
- [Why I Don't Use My Real Photo When Messaging With Customers On My Website](https://www.kapwing.com/blog/why-i-dont-use-my-real-photo/) - 朱莉娅·恩托芬 (Julia Enthoven).
- [Why Men Don't Believe The Data On Gender Bias In Science](https://www.wired.com/story/why-men-dont-believe-the-data-on-gender-bias-in-science/) - 艾里逊线圈.
- [Why More Tech Companies Should Hire People With Disabilities](https://www.inc.com/zoe-henry/aapd-disability-equality-index-2017.html) - 佐伊·亨利 (Zoë Henry).
- [Why Tech Needs The Rooney Rule](https://techcrunch.com/2015/07/28/why-tech-needs-the-rooney-rule/) - 萨米艾哈迈德.
- [Why We Shouldn't Underestimate The Power Of Diversity](http://ideas.ted.com/why-we-shouldnt-underestimate-the-power-of-diversity/) - Joi Ito 和 Jeff Howe.
- [Why Your Efforts To Fix Your Pipeline Aren’t Fixing Your Pipeline](https://chelseatroy.com/2018/04/12/why-your-efforts-to-fix-your-pipeline-arent-fixing-your-pipeline/) - 切尔西特洛伊.
- [Women And Minorities Are Penalized For Promoting Diversity](https://hbr.org/2016/03/women-and-minorities-are-penalized-for-promoting-diversity) - 作者：Stefanie K. Johnson 和 David R. Hekman.
- [You Can’t Just Hit The Diversity Button](https://medium.com/projectinclude/you-cant-just-hit-the-diversity-button-94b7043372a9) - Project Include 的 Laura I. Gómez.
- [Your Company's Slack Is Probably Sexist](https://work.qz.com/1128150/your-companys-slack-is-probably-sexist/) - 利亚·费斯勒 (Leah Fessler).
- [Diversity in Tech](https://www.linkedin.com/pulse/diversity-tech-adam-e-recvlohe/) - 亚当 Recvlohe

## Talks

关于多样性、共识软件和安全社区的谈话和演示.

- [9 Ways To Stop Hurting And Start Helping Women In Tech](https://www.youtube.com/watch?v=pUVhF3jDG08) - 布丽安娜吴.
- [Consensual Software: Prioritizing Trust & Safety For New Features](https://www.youtube.com/watch?v=Ccw3VfE3P4M) - 丹妮尔·梁.
- [Category Theory In Life](https://youtu.be/ho7oagHeqNc) - 由尤金妮亚郑.
- [Diversity In Tech: Building Inclusivity](https://www.youtube.com/watch?v=XAiDY3k50D8) - 马克辛·威廉姆斯.
- [Enforcing Your Code Of Conduct: Effective Incident Response](https://www.youtube.com/watch?v=nizfHxg8y3o) - 奥黛丽·埃施莱特 (Audrey Eschright).
- [Going Beyong The Pipeline Problem](https://www.facebook.com/getpantheon/videos/1904727832878526/?permPage=1) - 万神殿.
- [Intro To Accessibility](https://www.youtube.com/watch?v=qQj4JLfQvtI) - 埃里克贝利.
- [Software Art Thou: Debugging The Tech Industry](https://www.youtube.com/watch?v=zjjvaIaYMd0o) - 莉娜莱因哈德.
- [Survival Tips For Women In Tech](https://www.pscp.tv/w/1BdGYepvvLQGX) - 帕特丽夏·阿斯 (Patricia Aas).
- [The Future Of STEM Depends On Diversity ](https://www.youtube.com/watch?v=-v8aDo4dV3Q) - 妮可·卡布雷拉·萨拉查 (Nicole Cabrera Salazar).
- [Why We Need Diversity In Technology](https://www.youtube.com/watch?v=OOQfQwxCOF0) - 丽贝卡迈克尔.
- [Building Open Source Software that Empowers Native Communities](https://www.youtube.com/watch?v=AAdrbrYNnPw) - 亚当 Recvlohe (@arecvlohe)

## Advocates

公开支持和授权科技领域代表性不足的群体的人.

- [FolksWhoCode](https://github.com/folkswhocode) - 旨在建立更丰富和多样化的技术社区的组织.

## Books

对技术的多样性和包容性提供深刻见解的书籍.

- [Technically Wrong: Sexist Apps, Biased Algorithms, And Other Threats Of Toxic Tech](http://www.sarawb.com/technically-wrong/) - 坚定地审视导致疏忽、偏见和道德噩梦的价值观、流程和假设.

## Contributing

请参见 [CONTRIBUTING](https://github.com/folkswhocode/awesome-diversity/blob/master/.github/CONTRIBUTING.md) 更多细节. 在这里你有字母顺序 [list of contributors](https://github.com/folkswhocode/awesome-diversity/blob/master/CONTRIBUTORS.md) 这个存储库的.

----------------------------

该项目是 [folkswhocode](https://github.com/folkswhocode) 组织.
这意味着它遵守其 [core values](https://github.com/folkswhocode/base/blob/master/en/VALUES.md), [code of conduct](https://github.com/folkswhocode/base/blob/master/en/CODE_OF_CONDUCT.md) 和
[contributing guidelines](https://github.com/folkswhocode/awesome-diversity/blob/master/.github/CONTRIBUTING.md)，并使用等价物 [license](https://github.com/folkswhocode/awesome-diversity/blob/master/LICENSE).

我们的行为准则改编自 [Contributor Covenant](http://contributor-covenant.org/).
