<div class="github-widget" data-repo="jonleibowitz/awesome-digitalocean"></div>
## Awesome DigitalOcean [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/jonleibowitz/awesome-digitalocean/master/media/DO_Logo.png" align="right" width="100">](https://www.digitalocean.com/)

&gt; 精选清单 [DigitalOcean](https://www.digitalocean.com) 指南、博客和其他资源.

 DigitalOcean 的标语是它是一个简单而强大的云计算平台，专为开发人员设计. 借助 DigitalOcean，您可以单独或与团队轻松启动云计算和存储资源. 

欢迎投稿. 通过拉取请求添加链接或创建问题以开始讨论.





## Community

- [Tutorial Search and Index](https://www.digitalocean.com/community/tutorials)
- [Community articles by tag](https://www.digitalocean.com/community/tags)
- [Questions](https://www.digitalocean.com/community/questions)
- [Projects](https://www.digitalocean.com/community/projects)
- [Meetups](https://www.meetup.com/pro/digitalocean/)
- [DigitalOcean Lovers](https://www.linkedin.com/groups/8876623/) - 面向 DigitalOcean 用户和爱好者的 LinkedIn 群组.
- 

## Configuration management

- [Using Ansible with DigitalOcean](https://the.binbashtheory.com/using-ansible-with-digitalocean/)
- [Ansible Cloud Modules - DigitalOcean](https://docs.ansible.com/ansible/latest/collections/community/digitalocean/index.html#plugins-in-community-digitalocean)
- [Terraform - DigitalOcean Provider](https://www.terraform.io/docs/providers/do/)
- [DigitalOcean in Action!](https://github.com/keinohguchi/do-in-action) - 将 DigitalOcean 与 Terraform 和 Ansible 一起使用的示例回购.
- [Use DigitalOcean as Dynamic DNS](https://surdu.me/2019/07/28/digital-ocean-ddns.html)

## Developer documentation

- [API](https://developers.digitalocean.com/documentation/v2/)
- [Spaces API](https://developers.digitalocean.com/documentation/spaces/)
- [OAuth](https://developers.digitalocean.com/documentation/oauth/)
- [Droplet Metadata](https://developers.digitalocean.com/documentation/metadata/)
- [Official DO Release Notes](https://www.digitalocean.com/docs/release-notes/) - 跟踪 DigitalOcean 云平台的增量改进和主要版本的注释.
- [DigitalOcean API Slugs](https://slugs.do-api.dev/)

## Open source projects

- [Open Source @ DigitalOcean](https://developers.digitalocean.com/opensource/)
- [Netbox](https://github.com/digitalocean/netbox)
- [Doctl](https://github.com/digitalocean/doctl) - DigitalOcean API 的官方命令行界面.
- [go-libvirt](https://github.com/digitalocean/go-libvirt)
- [go-qemu](https://github.com/digitalocean/go-qemu)

## Commercial integrations

- [Bill.do](https://bill.do) - 免费的 DigitalOcean 计费监控和洞察工具
- [HostLaunch](https://hostlaunch.io) - 推出基于 DigitalOcean 和 ServerPilot 的托管公司.
- [SimpleBackups](https://simplebackups.io) - 用于在自动驾驶仪上安排 DigitalOcean 备份（文件和数据库）的工具.
- [SnapShooter](https://snapshooter.io/digitalocean) - 每天到每小时备份 Droplets 和 Volumes 的工具
- [Weap.io](https://weap.io)  - 每小时到每日 DigitalOcean 备份. 用于安排更频繁的 DigitalOcean 备份的工具

## Community OSS projects

- [do-sshuttle](https://github.com/f/do-sshuttle) - 通过 sshuttle 到 DigitalOcean Droplet 的透明代理.
- [drophosts](https://github.com/qmx/drophosts) - 使用对等液滴更新 `/etc/hosts`.
- [droplan](https://github.com/tam7t/droplan) - 管理 DigitalOcean 液滴上私有接口的 iptable 规则.
- [foreman-digitalocean](https://github.com/theforeman/foreman-digitalocean) - 启用 Foreman 中 DigitalOcean 液滴管理的插件.
- [ghost-digitalocean](https://github.com/shiva-hack/ghost-digitalocean) - Ghost 的 DigitalOcean 存储适配器.
- [lita-digitalocean](https://github.com/jimmycuadra/lita-digitalocean) - 用于管理 DigitalOcean 服务的 Lita 处理程序.
- [hostpool](https://github.com/progrium/hostpool) - DigitalOcean 主机的工作池管理器.
- [DDNS](https://github.com/skibish/ddns) - 以 DigitalOcean Networking DNS 作为后端的个人 DDNS 客户端.
- [Less Confusing Menus](https://github.com/addpipe/Less-Confusing-Digital-Ocean-Menus) - 一个 Chrome 扩展程序，使帐户菜单不那么混乱.
- [DigitalOcean Droplet creator](https://github.com/NicholasPCole/dodc) - 基于对话框的 shell 脚本，用于快速创建单个 DigitalOcean Droplet.
- [do-upgrade-plans](https://github.com/bjornjohansen/do-upgrade-plans) - 一个脚本，用于以相同的成本将您的 DigitalOcean Droplet 升级为更好的计划.

## Clients

- [doctl](https://github.com/digitalocean/doctl) - 用于 DigitalOcean 服务的命令行工具.
- [digitalocean-indicator](https://github.com/andrewsomething/digitalocean-indicator) - Debian Gnome 面板客户端.
- [domanager](https://github.com/itohnobue/domanager) - Linux 和 Windows 系统托盘客户端.
- [OceanBar](https://github.com/terhechte/OceanBar) - macOS 菜单栏客户端.
- [Tugboat](https://github.com/pearkes/tugboat) - 用于 DigitalOcean 服务的 Ruby 命令行工具，专注于更具指导性的用户体验.

## Video tutorials

- [Building a Kubernetes cluster on DigitalOcean using Kubicorn](https://www.youtube.com/watch?v=XpxgSZ3dspE)

## Other

- [Reddit community](https://www.reddit.com/r/digital_ocean/)
- [`##digitalocean` on freenode](https://webchat.freenode.net/)
- [Engineering Code of Conduct](https://github.com/digitalocean/engineering-code-of-conduct)
- [User Scripts](https://github.com/digitalocean/do_user_scripts) - 帮助在 Droplet 上配置应用程序的用户数据脚本.
- [Hacktoberfest](https://hacktoberfest.digitalocean.com/) - 与 GitHub 合作举办为期一个月的开源软件庆祝活动.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Jon Leibowitz](https://github.com/jonleibowitz) 已放弃该作品的所有版权和相关或邻接权.
