<div class="github-widget" data-repo="maehr/awesome-digital-history"></div>
## Awesome Digital History [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/maehr/awesome-digital-history/master/static/favicon.png" align="right" width="100">](https://maehr.github.io/awesome-digital-history/)

> Find primary sources online and learn how to research history digitally.

Finding aids for textual and multimedia [primary sources](https://en.wikipedia.org/wiki/Primary_source) with a focus on the western hemisphere and the 19th and 20th centuries. Courses and learning tools to explore history digitally.

📢 **Announcement**

🎉 Check out our new website at [awesome-digital-history.pages.dev](https://awesome-digital-history.pages.dev/) with more information, filters, and a search function. 🎉



## Archives and primary sources

### Africa

- [PARC](https://parc-portal.org/) - Portal for African Research Collections: PARC is the new meta-catalogue for the Africana collections at the research location Basel.
- [West African Arabic Manuscript Database](https://islam.zmo.de/s/westafrica/page/home) - A comprehensive collection of manuscripts that provides insight into the Islamic scholarly tradition in West Africa.

### Asia

- [FOCAL](https://www.asia-directories.org/) - The Asia Directories and Chronicles is a reference work for foreign traders in the Asian region, published annually by the Hong Kong Daily Press, annually between 1863 and 1941.

### Austria

- [ANNO](https://anno.onb.ac.at/) - Austrian Newspapers online.
- [Digitarium](https://digitarium-app.acdh-dev.oeaw.ac.at/) - Digital edition of the historical Wiener Zeitung.
- [Österreichische Mediathek](https://www.mediathek.at/) - The Austrian archive for sound recordings and videos from cultural and contemporary history.
- [Wien Geschichte Wiki](https://www.geschichtewiki.wien.gv.at/Wien_Geschichte_Wiki) - It is based on the Historical Dictionary Vienna by Felix Czeike, currently there are 50,156 contributions and 12,510 images.

### Europe

- [Archives Portal Europe](https://www.archivesportaleurope.net/) - European archives search engine.
- [Encyclopédie d'histoire numérique](https://ehne.fr/) - European History through renewed historiographic objects and major contemporary challenges.
- [Europeana](https://www.europeana.eu/) - Search engine for European textual and non-textual archival sources.
- [Mapire](https://mapire.eu/) - Interactive historical maps.
- [Monasterium](https://www.monasterium.net/mom/home) - Deeds from all over Europe.
- [Project Gutenberg](https://www.gutenberg.org/) - A library of over 60,000 free eBooks.
- [Visual Archive Southeastern Europe](http://gams.uni-graz.at/context:vase) - Historical and contemporary visual materials from Southeastern Europe.

### France

- [Gallica](https://gallica.bnf.fr/) - Digital library of the National Library of France.
- [Institut national de l'audiovisuel](https://www.ina.fr/) - INA is a repository of French radio and television audiovisual archives.

### Germany

- [Archivportal](https://www.archivportal-d.de/) - German archives search engine.
- [Bavarikon](https://www.bavarikon.de/) - Collection of Bavarian maps, places, newspapers etc.
- [Computerarchiv Muenchen](http://computerarchiv-muenchen.de/) - South German Museum for History of Digital Development.
- [Deutsche Digitale Bibliothek](https://www.deutsche-digitale-bibliothek.de/) - Over 12 million objects.
- [Deutsches Zeitungsportal](https://www.deutsche-digitale-bibliothek.de/newspaper) - Discover historical newspapers from 1671 to 1950.
- [Digitale Sammlungen](https://www.digitale-sammlungen.de/) - Collections of the Munich Digitization Center.
- [Digitales Deutsches Frauenarchiv](https://www.digitales-deutsches-frauenarchiv.de/) - An interactive portal on the history of women's movements in Germany.
- [Docupedia](https://docupedia.de/) - Terms, methods, and debates in contemporary history research.
- [historicum.net](https://www.historicum.net/home/) - A specialized information service for historians that offers access to research tools and services.
- [leo bw](https://www.leo-bw.de/) - Platform of the State Archives of Baden-Württemberg.
- [LexM](https://www.lexm.uni-hamburg.de/content/index.xml) - Encyclopedia of musicians persecuted during the Nazi era.
- [MARCHIVUM](https://druckschriften-digital.marchivum.de/) - Collection of Mannheim newspapers and historical printed matter on the history of Mannheim.
- [Projekt Gutenberg](https://www.projekt-gutenberg.org/) - Contains 10'000 works by over 2'000 authors in German.
- [SLUB Dresden](https://digital.slub-dresden.de/kollektionen/) - Over 1.8 million graphic media (photographs, maps, drawings).
- [Spiegel Online](https://www.spiegel.de/dienste/besser-surfen-auf-spiegel-online-suchen-im-archiv-a-676489.html) - SPIEGEL archive since 1947.
- [UB Heidelberg](https://www.ub.uni-heidelberg.de/helios/digi/digilit.html) - Manuscripts, documents, maps and literature.
- [Uni Frankfurt](http://sammlungen.ub.uni-frankfurt.de/) - Rare prints, manuscripts, bequests and more.
- [Zefys](http://zefys.staatsbibliothek-berlin.de/) - Historical German newspapers.
- [ZLB](https://digital.zlb.de/) - Collections of the Berlin Central and State Library.

### Global

- [Bitsavers.org](http://bitsavers.trailing-edge.com/) - Computer code, reference manuals, and magazines.
- [Classic Computer Magazine Archive](https://www.atarimagazines.com/) - Preserving information from early personal computer magazines.
- [Fxtop](https://fxtop.com/) - Forex rate history since 1953.
- [Got Papers?](https://gotpapers.scene.org/?page_id=73) - Resources on the history of games, cracking, and the demoscene.
- [HMML](https://hmml.org/) - Hill Museum & Manuscript Library. Digital collection of manuscripts from around the world.
- [Internet Archive](https://archive.org/) - Non-profit library of millions of free books, movies, software, music, websites, and more.
- [Karlsruher Virtueller Katalog](https://kvk.bibliothek.kit.edu/) - Book search engine for finding hundreds of millions of media in catalogs worldwide.
- [Marxist Internet Archive](https://www.marxists.org/) - Everything you ever wanted to know about Marx (and other important socialists).
- [Mementoweb](http://timetravel.mementoweb.org/) - Find archived web pages in Internet Archive, Archive-It, British Library, archive.today, and GitHub.
- [OldMapsOnline](https://www.oldmapsonline.org/) - Maps, starting in the 17th century.
- [OpenCat](https://opencat.io/) - Search engine for libraries around the globe.
- [OpenHistoricalMap](https://openhistoricalmap.org/) - A time travel map created by a community of mappers and historians.
- [Public Books Database](http://www.publicbooks.org/public-books-database/) - Open access academic literature.
- [United Nations Archive](https://archives.un.org/) - Archives and records from the United Nations regarding Secretaries-Generals, departments and missions.
- [WayBackMachine](https://archive.org/web/) - Explore more than 486 billion web pages saved over time.
- [World Historical Gazeteer](https://whgazetteer.org/) - Collection of content and services that permit world historians to do spatial and temporal reasoning and visualization in a data rich environment at global and trans-regional scales.

### Great Britain

- [British Library](https://www.bl.uk/catalogues-and-collections/digital-collections) - Maps, manuscripts and sounds.
- [National Records of Scotland](https://www.nrscotland.gov.uk/) - Repository for the public and legal records of Scotland.
- [NLS](https://data.nls.uk/data/) - Data collections from the National Library of Scotland.
- [The National Archives](https://www.nationalarchives.gov.uk/) - A non-ministerial department, and the official archive and publisher for the UK Government, and for England and Wales.
- [The Proceedings of the Old Bailey](https://www.oldbaileyonline.org/) - London's Central Criminal Court, 1674 to 1913.

### Netherlands

- [Delpher](https://www.delpher.nl/) - Dutch newspapers, books and magazines.
- [Nationaal Archief](https://www.nationaalarchief.nl/) - Rich collection of the National Archives of the Netherlands.

### North America

- [Ad\*Access](https://repository.duke.edu/dc/adaccess) - U.S. and Canadian advertisements covering five product categories - Beauty and Hygiene, Radio, Television, Transportation, and World War II propaganda - dated between 1911 and 1955.
- [Chronicling America](https://chroniclingamerica.loc.gov/) - America's historic newspapers from 1777-1963.
- [Computer Gaming World Museum](https://www.cgwmuseum.org/) - Archive of various magazines on gaming.
- [David Rumsey Map Collection](https://www.davidrumsey.com/) - Historical maps collection.
- [Digital Public Library of America](https://dp.la/) - Discovery tool, or union catalog, for public domain and openly licensed content held by the United States' archives, libraries, museums, and other cultural heritage institutions.
- [Digital Transgender Archive](https://www.digitaltransgenderarchive.net/) - Wide range of trans-related digitized historical materials, born-digital materials, and information on archival holdings throughout the world.
- [Eugenics Archive](https://eugenicsarchive.ca/) - Scholars, survivors, students, and community partners in challenging eugenics.
- [HathiTrust](https://www.hathitrust.org) - A not-for-profit collaborative of academic and research libraries preserving and making accessible millions of digitized items.
- [National Archives](https://www.archives.gov/) - The official archives regarding veteran records, founding documents and presidential libraries of the United States.
- [Perry-Castañeda Library Map Collection](https://legacy.lib.utexas.edu/maps/) - Online collection of scanned maps.
- [Women Working 1800-1930](https://library.harvard.edu/collections/women-working-1800-1930) - An exploration of women's impact on the economic life of the United States between 1800 and the Great Depression.
- [World Digital Library](https://www.wdl.org/) - WDL is an international digital library operated by UNESCO and the United States Library of Congress.

### Switzerland

- [Amtsdruckschriften](https://www.amtsdruckschriften.bar.admin.ch/) - Federal Gazette, Administrative Case Law of the Federal Authorities and more documents from the Swiss Federal Archives.
- [Année Politique Suisse](https://anneepolitique.swiss/) - Sources and database for swiss socio-political topics.
- [arCHeco](https://www.archeco.info/) - Index of economic collections in archives of Switzerland and Liechtenstein.
- [Archives Online](https://www.archives-online.org/) - Archival search engine for Switzerland.
- [chgov](https://www.chgov.bar.admin.ch/) - Minutes of the Federal Council (1848-1963).
- [COSMOV](http://www.cosmov.uzh.ch/) - COSMOV includes a digital edition of the events of the Zurich summer of 1968.
- [DigiBern](https://www.digibern.ch/) - Bernese culture and history on the Internet.
- [Diplomatic Documents of Switzerland](https://www.dodis.ch/) - Diplomatic documents of Switzerland.
- [e-codices](http://e-codices.ch/) - Virtual manuscript library of Switzerland.
- [e-gs](https://www.e-gs.ethz.ch/) - Online web portal of the ETH Zurich Graphics Collection.
- [e-manuscripta](https://www.e-manuscripta.ch/) - Manuscript material from Swiss libraries and archives.
- [e-newspaperarchives.ch](https://www.e-newspaperarchives.ch/) - Swiss newspapers.
- [E-Periodica](https://www.e-periodica.ch/) - Swiss journals.
- [e-rara](https://www.e-rara.ch/) - The platform for digitised rare books from Swiss libraries.
- [histHub](https://histhub.ch/) - The platform manages authority files on Swiss history.
- [Historical Encyclopedia of Switzerland](https://hls-dhs-dss.ch/) - Encyclopedia on Swiss history.
- [HSSO](https://hsso.ch/) - Historical statistics of Switzerland online.
- [impresso](https://impresso-project.ch/) - Historical newspaper collections of the Swiss National Library, the National Library of Luxembourg, the Neue Zürcher Zeitung, Le Temps, the Valais State Archives and the Swiss Economic Archives.
- [Industriekultur](https://industriekultur.ch/) - Swiss national inventory of industry artifacts.
- [infoclio.ch Edition projects](http://www.infoclio.ch/en/edition-projects) - A database containing current historical edition projects in Switzerland.
- [Kartenportal](http://www.kartenportal.ch/) - Search engine for maps.
- [Le Temps](https://www.letempsarchives.ch/) - Archive of Gazette de Lausanne et du Journal de Genève.
- [map.geo.admin.ch](https://map.geo.admin.ch/) - Journey through time via maps of Switzerland.
- [MEMOBASE](http://www.memobase.ch/) - Provides access to audiovisual documents from Swiss memory institutions.
- [Sammlung Schweizerischer Rechtsquellen online](https://www.ssrq-sds-fds.ch/projekte/ssrq-online/) - Retrodigitalisierte und digitale Editionseinheiten der Schweizerischen Rechtsquellen. Ediert wird rechtshistorisches Quellenmaterial vom Mittelalter bis in die Frühe Neuzeit (1798).
- [Schweizerisches Wirtschaftsarchiv](https://ub.unibas.ch/de/historische-bestaende/wirtschaftsarchive/) - This collection comprises over 500 business archives from the period 1750 to the present day, with a focus on the Basel region.
- [Sources Online](https://sources-online.org/index.html) - A platform for digital scholarly text editions, integrating TEI Publisher and IIIF in Switzerland.
- [swisscollections](https://swisscollections.ch/) - Meta search engine for historical and modern collections in Swiss libraries and archives.
- [timeSTAT Cubes](http://www.sfa-laboratory.ch/sr/cubestest/index.php) - The Federal Council reports to parliament on income and expenditure for the past years.
- [transcriptiones](http://transcriptiones.ch) - Create, share and access transcriptions of historical manuscripts.

## Learning

- [AdFontes](https://www.adfontes.uzh.ch/) - An Introduction to Working with Sources in the Archive.
- [Clio Guide](https://guides.clio-online.de/) - A handbook on digital resources for the historical sciences.
- [Crafting Digital History](http://workbook.craftingdigitalhistory.ca/) - A Workbook for Methods and Readings in Digital History.
- [Digital History Guide](http://chnm.gmu.edu/digitalhistory/) - Introduction to the web for historians, who wish to produce online historical work.
- [Geospatial Historian](https://geospatialhistorian.wordpress.com/) - Open HGIS Lessons and Resources.
- [HIST 7370](https://cblevins.github.io/f19-dig-hist/) - Online course for Methods and Readings in Digital History.
- [History Toolkit](https://dg.philhist.unibas.ch/en/studium/history-a-toolkit-for-students/) - History Toolkit for Students.
- [Introduction to Digital History](https://wissen-ist-acht.github.io/digitalhistory.intro/) - This guide, created in the fall semester of 2022, accompanies the introductory courses in history at the University of Basel and is intended to provide a first insight into the field of digital history.
- [Introduction to Python for Humanists](https://python-textbook.pythonhumanities.com/intro.html) - A textbook offering a comprehensive introduction to Python programming, tailored for researchers and students in the humanities.
- [Local Linkages](https://locallinkages.org/) - Professional development curriculum to introduce to historical research methods and digital history skills.
- [Python für Historiker:innen](https://digital-history-berlin.github.io/Python-fuer-Historiker-innen/home.html) - The Jupyter Book (in German language) is aimed at historians who are looking for a first application-oriented and interactive introduction to the Python programming language.
- [The CTP Book](https://comp-think.github.io/) - A book for teaching Computational Thinking and Programming skills to people with a background in the Humanities.
- [The Programming Historian](https://programminghistorian.org/) - Novice-friendly, peer-reviewed tutorials that help humanists learn a wide range of digital tools, techniques, and workflows to facilitate research and teaching.
- [UCI Digital History](https://guides.lib.uci.edu/history/history_dh) - Overview on the field of Digital History and Digital Humanities.
- [We think History](https://wethink.hypotheses.org/) - News about and innovations from digital history.

## More Awesome

- [Computer History](https://github.com/watson/awesome-computer-history) - An Awesome List of computer history videos, documentaries and related folklore.
- [Data Visualization](https://github.com/fasouto/awesome-dataviz#readme) - A curated list of awesome open-source data visualizations frameworks, libraries and software.
- [Digital Humanities](https://dh-tech.github.io/awesome-digital-humanities#readme) - Tools, resources, and services supporting the Digital Humanities.
- [Research Tools](https://github.com/emptymalei/awesome-research#readme) - A list of tools for research.
- [Scientific Writing](https://github.com/writing-resources/awesome-scientific-writing#readme) - Scientific writing can extend beyond LaTeX, made possible by formats, such as Markdown (and its many flavours), reStructuredText and Jupyter notebooks.
- [Tempopedia](https://tempopedia.org/) - Digital History Directory.

## Contribute

Contributions welcome! Read the [CONTRIBUTING.md](https://github.com/maehr/awesome-digital-history/blob/main/CONTRIBUTING.md) first.
