<div class="github-widget" data-repo="jondot/awesome-devenv"></div>
## Awesome Dev Env [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

精选的工具、资源和工作流程技巧列表，打造出色的开发环境.

灵感来自 [awesome-go](https://github.com/avelino/awesome-go), 这又受到了启发 [awesome-python](https://github.com/vinta/awesome-python).

### Contributing

[Guidelines](https://github.com/jondot/awesome-devenv/blob/master/CONTRIBUTING.md) 调整并改编自 `awesome-go` - 谢谢！

但简而言之：

* 列表按字母顺序排序
* 如果您认为某个项目不应该出现在这里 [open an issue](https://github.com/jondot/awesome-devenv/issues/new)


非常感谢大家在 [contributor list](https://github.com/jondot/awesome-devenv/graphs/contributors) :)



_注意：对于特定于操作系统的工具，请尽量标记为 `OSX/WIN/*NIX/LIN`_





## Admins
*管理数据库、权限等的工具*

* [hss](https://github.com/six-ddc/hss) - 永远不要再输入烦人的 ssh 命令.
* [MongoHub](https://github.com/fotonauts/MongoHub-Mac/releases) - 用于 mongo 的本机 OSx 客户端
* [Robomongo](http://robomongo.org/) - MongoDB 的跨平台管理员


## Benchmarking
*对您的代码或服务进行基准测试的工具*

* [apachebench (ab)](http://httpd.apache.org/docs/2.2/programs/ab.html)
* [boom](https://github.com/rakyll/boom)
* [httperf](http://www.hpl.hp.com/research/linux/httperf/)
* [phantomas](https://github.com/macbre/phantomas) - 网站性能评估工具
* [siege](http://www.joedog.org/siege-home/)
* [Vegeta](https://github.com/tsenart/vegeta)
* [wrk](https://github.com/wg/wrk)
* [redis-faina](https://github.com/Instagram/redis-faina) 基于 MONITOR 命令的 Instagram 的 Redis 计数器/计时统计


## Data
*处理在线和离线数据的工具*

* [s3cmd](https://github.com/s3tools/s3cmd) - Amazon 的 S3 CLI 工具


## Diagnostics
*工作时检查诊断系统的工具*

* [glances](https://github.com/nicolargo/glances)
* [nmon](http://nmon.sourceforge.net/pmwiki.php)
* [gtop](https://github.com/aksakalli/gtop)


## Desktop
*用于改进和破解您的香草桌面的工具*

* [Alfred](http://www.alfredapp.com/) - OSX 生产力应用程序`/OSX/`
* [hydra](https://github.com/sdegutis/hydra) - 编写桌面脚本
  `/OSX/`
* [Keycastr](https://github.com/sdeken/keycastr) - 出示你的钥匙
  呈现/投射`/OSX/`

## Documentation
*记录项目的工具*

* [Log4brains](https://github.com/thomvaill/log4brains) - 文档即代码知识库，用于管理项目的架构决策记录 (ADR) 并将它们自动发布为静态网站.


## Dotfiles

* [dotfiles.github.io](https://dotfiles.github.io/)  - 收集的点文件资源. 包含带有点文件引导程序的部分以及各种 shell 和编辑器的框架列表.
* [Zach Holman's](https://github.com/holman/dotfiles) - oh-my-zsh、osx、Zsh、vi、Ruby、Git 等
* [Mathias Bynens's](https://github.com/mathiasbynens/dotfiles) - .files，包括 ~/.osx — OS X 的合理黑客默认设置
* [Thoughtbot's](https://github.com/thoughtbot/dotfiles) - 一组 vim、zsh、git 和 tmux 配置文件
* [Paul Miller's](https://github.com/paulmillr/dotfiles) - 色彩丰富且功能强大的 OS X 配置文件和实用程序


## Editors
*只为您最喜欢的编辑器提供很棒的工具和插件*

### Atom

* [atom-beautify](https://github.com/Glavin001/atom-beautify) - 美化 HTML（包括 Handlebars）、CSS（包括 Sass 和 Less）、JavaScript 以及 Atom 中的更多内容.
* [file-icons](https://github.com/DanBrooker/file-icons) - 将文件特定图标添加到 atom 以改进视觉 grepping.
* [highlight-selected](https://github.com/richrace/highlight-selected) - 双击一个词以在整个打开的文件中突出显示它.
* [minimap](https://github.com/atom-minimap/minimap) - 完整源代码的图形地图（预览）.
* [minimap-git-diff](https://github.com/atom-minimap/minimap-git-diff) - Atom git-diff 包的迷你地图绑定.
* [minimap-highlight-selected](https://github.com/atom-minimap/minimap-highlight-selected) - 高亮选择包的迷你地图绑定.
* [atom-project-manager](https://github.com/danielbrodin/atom-project-manager) - 轻松访问所有项目并使用项目特定设置和选项管理它们.
* [atom-tree-view-git-status](https://github.com/subesokun/atom-tree-view-git-status) - 在 Atom 树视图中显示 Git 存储库状态.
* [atom-pigments](https://github.com/abe33/atom-pigments) - 用于在项目和文件中显示颜色的 Atom 包.

### Vim

* [Completor](https://github.com/maralla/completor.vim) - 支持全方位和语义完成的异步自动完成.
* [Powerline](https://github.com/Lokaltog/powerline) - 改进了缓冲区的状态栏.
* [snipmate](https://github.com/garbas/vim-snipmate) - 与 Textmate 片段兼容的文本片段.
* [The Ultimate Vim Distribution](http://vim.spf13.com/) - spf13-vim 是 Vim、GVim 和 MacVim 的 vim 插件和资源的分布.

### Sublime Text 3

* [AdvancedNewFile](https://github.com/skuroda/Sublime-AdvancedNewFile) - 文件创建插件.
* [Emmet](https://github.com/sergeche/emmet-sublime)
* [Git Gutter](https://github.com/jisaacks/GitGutter) - 在编辑器窗口的边缘显示更改/添加的行.
* [jsFormat](https://github.com/jdc0589/JsFormat) - Javascript 格式.
* [LiveReload](https://github.com/dz0ny/LiveReload-sublimetext2) - LiveReload 插件.
* [MarkdownEditing](https://github.com/SublimeText-Markdown/MarkdownEditing) - Markdown 语法理解和良好的配色方案.
* [Package Control](https://sublime.wbond.net/installation) - Sublime Text 包管理器.
* [RubyTest](https://github.com/maltize/sublime-text-2-ruby-tests) - 用于运行 Ruby 测试的插件.
* [Side Bar Enhancments](https://github.com/titoBouzout/SideBarEnhancements)  - 增强 Sublime Text 侧边栏. 文件和文件夹.
* [Sublime Git](https://github.com/kemayo/sublime-text-git) - 用于 Sublime 的 Git 集成.
* [Sublime Linter](https://github.com/SublimeLinter/SublimeLinter3/) - 交互式代码检查.
* [TrailingSpaces](https://github.com/SublimeText/TrailingSpaces) - 突出显示尾随空格并立即删除它们.

### Intellij

* [keymap](https://github.com/jondot/keymaps/) - 混合 Vim/ReSharper/Intellij 键盘映射

### Visual Studio Code

* [Dev Git Repo](https://github.com/Microsoft/vscode) - VS Code 的 Github 代码库 
* [Monaco Editor Git Repo](https://github.com/microsoft/monaco-editor) - 基于浏览器的底层编辑器的 Github 代码库

#### Extensions
* [VS Code Extension Marketplace](https://marketplace.visualstudio.com/search?target=VSCode&category=All%20categories) - 扩展的官方网站
* [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python) - 官方 Python 扩展
* [Sync settings](https://marketplace.visualstudio.com/items?itemName=Shan.code-settings-sync) - 出色的设置扩展和 VS 代码设置的扩展同步

## Git
*用于打造出色 Git 体验的工具和插件*

* [awesome-github](https://github.com/fffaraz/awesome-github) - Faraz Fallahi 维护着 GitHub 和 Git 资源的精选列表.
* [gh](https://github.com/jingweno/gh) - 快速 GitHub 命令行客户端（集线器端口到 Go）
* [git-extra-commands](https://github.com/unixorn/git-extra-commands) - 收集的 git 帮助脚本
* [git-extras](https://github.com/visionmedia/git-extras) - GIT 实用程序——repo 摘要、repl、变更日志填充、作者提交百分比等
* [git-it-on](https://github.com/peterhurford/git-it-on.zsh) - ZSH 插件，添加一个 gitit 命令，在你当前的分支中打开 github 上的当前目录
* [git-secret](https://github.com/sobolevn/git-secret) - 一个 bash 工具，用于将您的私人数据存储在 git 存储库中.
* [git-semver](https://github.com/markchalloner/git-semver) - 使语义版本控制 2.0.0 和更改日志管理更容易的 git 插件.
* [git-sweep](https://github.com/arc90/git-sweep) - 安全地删除已合并到 master 中的分支
* [git-up](https://github.com/aanand/git-up) - 更好的“git pull”
* [hub](https://hub.github.com/) - git CLI 包装器，使使用 GitHub 更容易
* [scm_breeze](https://github.com/ndbroadbent/scm_breeze) 简化你的 git 工作流程
* [tig](http://jonas.nitro.dk/tig/) - 一个基于 ncurses 的 git 文本模式界面

## Misc
*在其他类别找不到家的好用工具*

* [Fenix Web Server](https://fenixwebserver.com) - 具有按钮共享功能的多主机本地静态 Web 服务器（桌面应用程序）.
* [ML Workspace](hhttps://github.com/ml-tooling/ml-workspace) - 用于机器学习和数据科学的多合一基于 Web 的开发环境.
* [Mockoon](https://mockoon.com) - 一个 API / HTTP REST 模拟桌面应用程序
* [HTTP Toolkit](https://httptoolkit.tech) - HTTP 检查和调试桌面应用程序

## Notifications
*通知开发人员工作环境变化的工具*

* [CatLight](https://catlight.io)  - 开发人员的状态通知程序. 检查持续交付构建的状态并显示桌面通知.

## Orchestration
*用于编排出色开发环境的工具*

* [azk](https://github.com/azukiapp/azk) - 用于编排开发环境的轻量级开源引擎
* [Nanobox](https://github.com/nanobox-io/nanobox) - 用于创建可在任何地方部署的一致、隔离的开发环境的微型 PaaS (μPaaS) https://nanobox.io.

## Presentation
*展示作品的工具*

* [bespoke.js](https://github.com/markdalgleish/bespoke.js) - DIY演示文稿微框架
* [hacker-slides](https://github.com/msoedov/hacker-slides) - 基于 Reveal.js 的演示工具
* [impress.js](https://github.com/impress/impress.js) - 基于 CSS3 变换和过渡功能的演示框架
* [mithril-slides](https://github.com/wulab/mithril-slides) - 以秘银编写的受 Keynote 启发的演示应用程序
* [remark](https://github.com/gnab/remark) - 浏览器上基于降价的演示
* [reveal.js](https://github.com/hakimel/reveal.js/) - 浏览器上基于降价的演示
* [deck.js](https://github.com/imakewebthings/deck.js) - 浏览器上基于降价的演示
* [vimdeck](https://github.com/tybenz/vimdeck) - 存在于你的 Vim 中
* [WebSlides](https://github.com/jlantunez/webslides) - 使 HTML 演示变得简单

## Shell
*拥有出色 shell 环境的工具*

* [awesome-zsh-plugins](https://github.com/unixorn/awesome-zsh-plugins) - 可用的 zsh 插件列表 [zgen](https://github.com/tarjoilija/zgen) 和别 [oh-my-zsh](https://github.com/robbyrussell/oh-my-zsh/) 兼容的 zsh 框架
* [fish-shell](https://github.com/fish-shell/fish-shell) - 用户友好的命令行外壳
* [hss](https://github.com/six-ddc/hss) - 永远不要再输入烦人的 ssh 命令.
* [oh-my-fish](https://github.com/oh-my-fish/oh-my-fish) - 受 oh-my-zsh 启发的管理鱼壳配置的框架.
* [oh-my-zsh](https://github.com/robbyrussell/oh-my-zsh/) - 用于管理 zsh 配置的社区驱动框架.
* [zgen](https://github.com/tarjoilija/zgen) - 管理 zsh 配置的更快框架，向后兼容 oh-my-zsh 插件
* [zsh](http://www.zsh.org/) - 为交互使用而设计的 shell，尽管它也是一种强大的脚本语言.
* [shellcheck](https://github.com/koalaman/shellcheck) - Lint for shell. Will find deprecated and/or dangerous usage in shell scripts
* [zsh quickstart kit](https://github.com/unixorn/zsh-quickstart-kit) - 使用 zsh 和 zgen 进行设置的快速介绍

## Text
*处理文本文件的工具——搜索、替换、处理*

* [ack](https://github.com/petdance/ack2) - 基于 Perl
  比 grep 更好的工具.
* [ag](https://github.com/ggreer/the_silver_searcher) - 基于 AC 的代码搜索工具类似于 ack，但速度更快
* [peco](https://github.com/peco/peco) - 交互式过滤，如交互式 Grep
* [ripgrep](https://github.com/BurntSushi/ripgrep) - 比 grep 更快，用 Rust 编写


## Terminal
*用于终端和终端工作的工具和插件*

* [autojump](https://github.com/joelthelion/autojump) - 记住你
  文件夹并根据部分召回跳转到它们（例如 `j proj` 将跳转
到`/home/Users/yourself/projects`.
* [fasd](https://github.com/clvv/fasd) 命令行生产力助推器，提供对文件和目录的快速访问.
* [freshenv](https://github.com/raiyanyahya/freshenv) - 配置、共享、管理本地和云开发人员环境.
* [homebrew](http://brew.sh) - 使用单个命令可以轻松地在 OS X 系统上安装开源包.
* [hss](https://github.com/six-ddc/hss) - 永远不要再输入烦人的 ssh 命令.
* [httpie](http://httpie.org/) 一个命令行 HTTP 客户端，一个用户友好的 cURL 替代品.
* [iTerm2](http://www.iterm2.com/) - 一个很好的终端替代 `/OSX/`
* [jq](https://stedolan.github.io/jq/) - 一个轻量级和灵活的命令行 JSON 处理器
* [oh-my-zsh](https://github.com/robbyrussell/oh-my-zsh) - 这
  令人难以置信的 ZSH 插件.
* [Pipe Viewer](http://www.ivarch.com/programs/pv.shtml) - 通过管道监控数据进度的工具
* [tmux](https://tmux.github.io/) 很棒的终端多路复用器.
* [zoxide](https://github.com/ajeetdsouza/zoxide)  - 一种更好的浏览文件系统的方法. 用 Rust 编写，跨 shell，比其他自动跳转器快得多.


## Workflow
*使用代码改进日常工作流程的工具和插件*

* [fswatch](https://github.com/alandipert/fswatch) - 一个手表工具
  将发出 FS 事件，您可以按需运行命令. 笔记 -
`fswatch-run` 也是.
* [guard](https://github.com/guard/guard) - 具有庞大插件生态系统的 FS 监视工具
* [just](https://github/casey/just)  - 一个任务运行器，用于方便地保存和运行项目特定的命令. 类似于 make，但更好
* [LiveReload](http://livereload.com/) - FS watch 和预处理器作为 `/OSX/` 和 `/WIN/` 的桌面应用程序，具有互补的浏览器扩展
  * [guard-livereload](https://github.com/guard/guard-livereload) - 与 LiveReload 的浏览器扩展兼容的 Guard 插件
  * [simplehttp](https://github.com/snwfdhmp/simplehttp) 通过 http 开始提供本地目录的最快和最简单的方法.
* [watchman](https://github.com/facebook/watchman) - 脸书更好
  `watch` - 注意它是作为服务工作的.
* [Zappr](https://github.com/zalando/zappr) - GitHub 集成旨在通过启用/禁用拉取请求批准检查来增强您的项目工作流程.
* [ergo](https://github.com/cristianoliveira/ergo) - 管理在不同端口上运行的多个本地服务变得容易.
* [Prodmodel](https://github.com/prodmodel/prodmodel) - 为数据科学管道构建工具.
* [Gebug](https://github.com/moshebe/gebug) - 通过无缝启用调试器和热重载功能，使 Dockerized Go 应用程序的调试变得超级容易的工具.
