<div class="github-widget" data-repo="klaufel/awesome-design-systems"></div>
## Awesome Design Systems [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

> A curated list of bookmarks, resources and articles about design systems focused on developers.

<p align="center">
  <a href="https://github.com/klaufel/awesome-design-systems#readme">
    <img src="https://raw.githubusercontent.com/klaufel/awesome-design-systems/master/media/awesome-design-systems-cover.svg?sanitize=true" alt="Awesome Design Systems"/>
  </a>
</p>



## Design systems

A Design System is an ever evolving collection of reusable components, guided by rules that ensure consistency and speed, by being the single source of truth for any product development.

### Design systems of some "known" companies

- [Atlassian Design Guidelines](https://atlassian.design/) - End-to-end design language to create straightforward and beautiful experiences.
- [Firefox Photon Design System](https://design.firefox.com/photon) - Launch recognizable, enjoyable Firefox products and features faster.
- [GitHub Primer](https://primer.style/) - Open-source it to allow the community to design and build their own projects.
- [GitLab Design System - Pajamas](https://design.gitlab.com/) - Resources, components, and design guidelines behind GitLab.
- [Google Material Design](https://material.io/design) - Create intuitive and beautiful products with Material Design.
- [IBM Carbon](https://www.carbondesignsystem.com/) - Carbon is IBM's open-source design system for products and experiences.
- [Shopify Polaris](https://polaris.shopify.com/) - Our design system helps us work together to build a great experience for all of Shopify's merchants.

See more design systems [here](https://github.com/alexpate/awesome-design-systems)!

### Design systems articles

- [A design system governance process](https://bradfrost.com/blog/post/a-design-system-governance-process/)
- [A guide to collaborating on design systems](https://www.invisionapp.com/inside-design/collaborating-on-design-systems/)
- [Building a Design System? Start with a map](https://blog.prototypr.io/building-a-design-system-start-with-map-909aa4baf41f)
- [Building your design system](https://www.designbetter.co/design-systems-handbook/building-design-system)
- [Design Systems are for People](https://publication.design.systems/design-systems-are-for-people-a484620b6988)
- [Design Systems vs. Pattern Libraries vs. Style Guides – What's the Difference?](https://www.uxpin.com/studio/blog/design-systems-vs-pattern-libraries-vs-style-guides-whats-difference/)
- [How Spotify organises work in Figma to improve collaboration](https://spotify.design/articles/2020-04-20/how-spotify-works-in-figma/)
- [How to Build Design Systems](https://medium.muz.li/how-to-build-design-systems-3431560f51fb)
- [What is a Design System – Everything You Need to Know](https://uxmisfit.com/2019/03/26/what-is-a-design-system-everything-you-need-to-know/)
- [Your sketch library is not a design system](https://bradfrost.com/blog/post/your-sketch-library-is-not-a-design-system/)

### More resources

- [Design system checklist](https://designsystemchecklist.com/) - Build better design systems. An open-source checklist to help you plan, build and grow your design system.
- [Design Systems Survey](https://designsystemssurvey.seesparkbox.com/) - Designers and developers from more than 20 industries tell us about their design systems and their uses.
- [Design.system](https://design.systems/) - Resources for the design systems community.
- [Super friendly](https://superfriendlydesign.systems/) - We help in-house teams make better digital products with design systems.

## UI Design tools

### Design tools

- [Figma](https://www.figma.com/) - Helps teams create, test, and ship better designs from start to finish (cross-platform).
- [InVision](https://www.invisionapp.com/) - The digital product design platform powering the world's best user experiences.
- [Sketch](https://www.sketch.com/) - A design toolkit built to help you create your best work from your earliest ideas, through to final artwork (for macOS).
- [AdobeXD](https://www.adobe.com/products/xd.html) - Share your story with designs that look and feel like the real thing. Wireframe, animate, prototype, collaborate, and more — it’s all right here, all in one UI/UX design tool.
- [Marvel](https://marvelapp.com/) - Marvel has everything you need to bring ideas to life and transform how you create digital products with your team. Placing the power of design in everyone’s hands.
- [UXPin](https://www.uxpin.com/) - Design and manage your entire UX/UI project in one tool.
- [Penpot](https://penpot.app) - Penpot is the first Open Source design and prototyping platform meant for cross-domain teams.

See design tools plugins [here](https://github.com/LisaDziuba/Awesome-Design-Tools/blob/master/Awesome-Design-Plugins.md)!

### Integrations

- [Abstract](https://www.abstract.com/) - Design collaboration without the chaos (for Sketch and XD on macOS).
- [Avocode](https://avocode.com/) - Helps you share design files, discuss changes, and code websites, mobile apps, & newsletters faster.
- [InVision Design System Manager](https://www.invisionapp.com/design-system-manager) - Powers creative and consistent design at scale with a central place to manage design and coded components.
- [Zeplin](https://zeplin.io/) - The better way to share, organize and collaborate on designs—built with developers in mind.

### Accessibility (a11y)

- [Accessibility for developers](https://www.invisionapp.com/inside-design/accessibility-for-developers/) - 5 simple ways developers can help improve and enforce website accessibility.
- [Stark](https://www.getstark.co/) - Empowers you to design with accessibility in mind from conception of brand to fruition of product. Contrast checker, colorblind simulation and color suggestions.
- [The A11Y Project](https://a11yproject.com/) - A community-driven effort to make web accessibility easier. See [resources](https://a11yproject.com/resources/) section.
- [InclusiveColors palette creator](https://www.inclusivecolors.com/) - Creates accessible custom Tailwind-style color palettes that pass WCAG contrast checks and can be exported to CSS/Figma/Adobe.

### Design tools articles

- [Adobe XD vs Sketch vs Figma vs InVision - How to Pick the Best Design Software in 2020](https://www.freecodecamp.org/news/adobe-xd-vs-sketch-vs-figma-vs-invision/)

## Design tokens

- [Design Tokens W3C Community Group](https://www.w3.org/community/design-tokens/) - View repository on GitHub [here](https://github.com/design-tokens/community-group)!
- [DesignTokens.dev](https://www.designtokens.dev/) - Ship your design tokens without managing infrastructure.
- [Diez](https://diez.org/) - Free & open-source developer toolkit for expressing visual styles that can be shared across codebases, native platforms, and teams.
- [Design Tokens Validator](https://animaapp.github.io/design-token-validator-site/) - Validate your design tokens against the Design Token Community Group spec.

### Plugins

- [Abstract Connect](https://github.com/MichaelZaporozhets/abstractconnect) - A Design tokens extractor for devs using Abstract & JavaScript.
- [Zeplin JSON export tokens](https://extensions.zeplin.io/berk/zeplin-json-extension) - Design tokens Zeplin extension to generate your tokens in JSON format.

### Tools

- [Figmagic](https://github.com/mikaelvesavuori/figmagic) - Generate design tokens, export graphics, and extract design token-driven React components from your Figma documents.
- [Style Dictionary](https://github.com/amzn/style-dictionary) - A Style Dictionary uses design tokens to define styles once and use those styles on any platform or language.
- [Superposition](https://superposition.design/) - Extract design tokens from websites and use them in code and in your design tool. Use the design system you already have.
- [Theo](https://github.com/salesforce-ux/theo) - Theo is an abstraction for transforming and formatting Design Tokens.

### Articles

- [A designer's guide to the Figma API](https://medium.com/@danhollick/a-designers-guide-to-the-figma-api-64f2785969d8)
- [Building a Visual Studio Code Theme with Style Dictionary](https://dbanks.design/blog/vs-code-theme-with-style-dictionary/)
- [Design tokens with Figma](https://blog.prototypr.io/design-tokens-with-figma-aef25c42430f)
- [Documenting Design Tokens](https://dbanks.design/blog/documenting-design-tokens/)
- [How to manage your Design Tokens with Style Dictionary](https://medium.com/@didoo/how-to-manage-your-design-tokens-with-style-dictionary-98c795b938aa)
- [Manage design tokens with TypeScript and styled-components](https://www.erikverweij.dev/blog/manage-design-tokens-with-typescript-and-styled-components/)
- [Theo Design Tokens Using Node-Sass Importer For Any Build Method](https://basalt.io/blog/theo-design-tokens-using-node-sass-importer-for-any-build-method)
- [Tokenize it](https://blog.prototypr.io/tokenize-it-2a544ef1413b)
- [Tokens in Design Systems](https://medium.com/eightshapes-llc/tokens-in-design-systems-25dd82d58421)

See more design tokens info [here](https://github.com/sturobson/Awesome-Design-Tokens)!

## Coding tools

- [Backlight](https://backlight.dev/) — With collaboration between developers and designers at heart, Backlight is a very complete coding platform where teams build, document, publish, scale and maintain Design Systems. 

## Pattern library

### Styleguides and documentation

- [Stencil](https://stenciljs.com/) - Toolchain for building reusable, scalable Design Systems.
- [Zeroheight](https://zeroheight.com/) - Create beautiful living styleguides and document all your design system resources in one place. _[Learn about this](https://medium.com/zeroheight/zeroheight-3-0-b6643c347596)_.

### Develop isolated components

- [Backlight](https://backlight.dev/) - Collaborative platform to build Design Systems on the code side. Empower your front-end with an all-in-one solution to manage components. Quick start, speed-up collaboration. 
- [Pattern Lab](https://patternlab.io/) - Pattern Lab helps you and your team build thoughtful, pattern-driven user interfaces using atomic design principles.
- [React Styleguidist](https://react-styleguidist.js.org/) - Isolated React component development environment with a living style guide.
- [Storybook](https://storybook.js.org/) - Build bulletproof UI components faster. Storybook is an open source tool for developing UI components in isolation for React, Vue, and Angular. It makes building stunning UIs organized and efficient.
- [Styled System](https://styled-system.com/) - Styled System is a collection of utility functions that add style props to your React components and allows you to control styles based on a global theme object.

#### Storybook addons

- [Accessibility](https://github.com/storybookjs/storybook/tree/master/addons/a11y) - Test component compliance with web accessibility standards.
- [Actions](https://github.com/storybookjs/storybook/tree/master/addons/actions) - Get UI feedback when an action is performed on an interactive element.
- [Backgrounds](https://github.com/storybookjs/storybook/tree/master/addons/backgrounds) - Switch backgrounds to view components in different settings.
- [Console](https://github.com/storybookjs/storybook-addon-console) - Show console output like logs, errors, and warnings in the Storybook.
- [Docs](https://github.com/storybookjs/storybook/tree/master/addons/docs) - Document component usage and properties in Markdown.
- [Knobs](https://github.com/storybookjs/storybook/tree/master/addons/knobs) - Interact with component inputs dynamically in the Storybook UI.
- [Links](https://github.com/storybookjs/storybook/tree/master/addons/links) - Link stories together to build demos and prototypes with your UI components.
- [Source](https://github.com/storybookjs/storybook/tree/master/addons/storysource) - View a story's source code to see how it works and paste into your app.
- [Storyshots](https://github.com/storybookjs/storybook/tree/master/addons/storyshots) - Take a code snapshot of every story automatically with Jest.
- [Viewport](https://github.com/storybookjs/storybook/tree/master/addons/viewport) - Build responsive components by adjusting Storybook's viewport size and orientation.

More info to Storybook [here](https://github.com/lauthieb/awesome-storybook)!

### Pattern libraries articles

- [Dependency discovery in Storybook](https://medium.com/storybookjs/discover-dependencies-in-storybook-49264d361e21)
- [Design systems workflow in Storybook](https://blog.hichroma.com/design-systems-in-storybook-2b2be06e394b)
- [How design systems use Storybook](https://medium.com/storybookjs/how-design-systems-use-storybook-2ed735ad07a9)
- [How packaging makes it dead simple to share UI components](https://blog.hichroma.com/how-packaging-makes-it-dead-simple-to-share-ui-components-29912593539d)
- [Storybook design system](https://github.com/storybookjs/design-system)
- [Storybook Docs sneak peek](https://medium.com/storybookjs/storybook-docs-sneak-peak-5be78445094a)

## Testing

### Unit & Regression test

- [Chromatic](https://www.chromaticqa.com/) - Visual testing for React, Angular and Vue. Chromatic ensures consistency in UI components, down to the pixel. Every commit is automatically tested for visual changes in the cloud.
- [Testing library](https://testing-library.com/) - Simple and complete testing utilities that encourage good testing practices.

## Books

- [Acing the System Design Interview](https://www.manning.com/books/acing-the-system-design-interview) - Book that gives the insights, skills, and practice needed to ace the toughest system design interview questions by Zhiyong Tan.
- [Atomic Design](https://atomicdesign.bradfrost.com/) - Atomic design methodology for creating design systems by Brad Frost.
- [Building Design Systems](https://www.apress.com/gp/book/9781484245132) - Unify user experiences through a shared design language by Sarrah Vesselov and Taurie Davis.
- [Design systems](https://www.smashingmagazine.com/design-systems-book/) - A practical guide to creating design languages for digital products by Alla Kholmatova (Smashing Magazine).
- [Front-End Style Guides](https://www.maban.co.uk/projects/front-end-style-guides/) - Creating and maintaining style guides for websites by Anna Debenham.
- [Frontend Architecture for Design Systems](http://shop.oreilly.com/product/0636920040156.do) - A modern blueprint for scalable and sustainable websites by Micah Godbolt.
- [Introduction to Design Systems](https://fem-design-systems.netlify.app/) - A practical introduction to design systems by using React, Figma and Storybook by Emma Bostian
- [Modular Web Design](https://www.amazon.com/Modular-Web-Design-Components-Documentation/dp/0321601351/) - Creating Reusable Components for user experience design and documentation by Nathan Curtis.

## Talks

- [Building Accessible Interfaces: Patterns And Techniques](https://vimeo.com/331530115) - Will be building and refactoring common UI components, and share a couple of techniques she often uses to build with accessibility in mind by Sara Soueidan.
- [Design Processes & Systems in Craft](https://dotall.com/sessions/design-processes-systems-in-craft) - Design shouldn't be a siloed practice, but a collaborative effort rooted in process. How do we get there? In this session, we'll look at how we can reframe our design approach to be more human-centric and systems-minded by Courtney Bradford.
- [Design Systems - The State of the Web](https://www.youtube.com/watch?v=jpmeWXISU5E) - Conversation about the role of design systems in modern web development and how they can change the dynamics between designer and developer by Adam Argyle (Design Advocate at Google).
- [Design Systems](https://youtu.be/K8MF3aDg-bM?t=4750) - Women of React conf by [Neha Sharma](https://twitter.com/hellonehha).
- [How To Build a Design System | UXPin](https://www.youtube.com/watch?v=h0MqkRJdaao) - Will teach you how to build a UX Design System using the UX Pin prototyping & design platform.
- [Introducing Design Systems Into Chaos](https://youtu.be/FZSi1bK-BRM) - Shares practical examples on where to begin to set up a design system, what to prioritize, and how to make a big impact to customers and colleagues, to help you introduce systems that bring order to chaos by Diana Mounter (Design Systems Lead at GitHub).
- [Jina Anne - Designing a Design System](https://youtu.be/7hYOLLO2gc4) - Will share strategies for how to approach, design and build an effective design system; how to successfully maintain the system to ensure ongoing usefulness by Jina (Lead Designer on the Design Systems team at Salesforce UX).
- [Level up your Design System with styled-system](https://youtu.be/K8MF3aDg-bM?t=7280) - Women of React conf by [Taley'a Mirza](https://twitter.com/TaleyaMirza).
- [Maintaining Design Systems](https://aneventapart.com/news/post/maintaining-design-systems-by-brad-frost-aea-video) - Helps you learn how to keep your system and the products it serves in sync and understand how to maintain and evolve your design system to give your users get the best possible experience by Brad Frost (Front-end designer).

## Contributing

Contributions welcome! Read the [contribution guidelines](https://github.com/klaufel/awesome-design-systems/blob/master/CONTRIBUTING.md) first.
