<div class="github-widget" data-repo="robinstickel/awesome-design-principles"></div>
## Awesome Design Principles [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

精选的良好设计和体验原则列表.

 &gt; 设计原则是创造更好、更一致的设计和体验的工具. 它们是指导详细设计决策的高级规则. 它们通常写在更大的风格指南、模式库或设计系统中.

知道下面未列出的资源吗？ 随意创建一个新 [pull request](https://github.com/robinstickel/awesome-design-principles/pulls), 或者打开一个 [issue](https://github.com/robinstickel/awesome-design-principles/issues/new) . 请阅读 [contribution guidelines](https://github.com/robinstickel/awesome-design-principles/blob/master/CONTRIBUTING.md) 在贡献之前.

- [Principles within bigger Design Systems](https://github.com/robinstickel/awesome-design-principles#principles-within-bigger-design-systems)
- [Articles about Design Principles](https://github.com/robinstickel/awesome-design-principles#articles-about-design-principles)
- [Other Resources](https://github.com/robinstickel/awesome-design-principles#other-resources)
- [Credits and Notes](https://github.com/robinstickel/awesome-design-principles#credits-and-notes)

## Principles within bigger Design Systems

- [Alibaba Ant Design Principles](https://ant.design/docs/spec/proximity)
- [Apple Human Interface Principles](https://developer.apple.com/design/human-interface-guidelines/)
- [Atlassian Brand Personality](https://atlassian.design/guidelines/brand/personality)
- [Co-op Design Principles](https://coop-design-manual.herokuapp.com/principles.html)
- [Firefox Photon Design System Principles](http://design.firefox.com/photon/introduction/principles.html)
- [Google Material Design Principles](https://material.io/guidelines/#introduction-principles)
- [GOV.uk Design Principles](https://www.gov.uk/design-principles)
- [Harmony Design System Voice & Tone Principles](http://harmony.intuit.com/voice-tone/)
- [IBM Carbon Design Principles](https://www.carbondesignsystem.com/guidelines/accessibility/overview)
- [Lost My Name Design System Principles](http://design-system.lostmy.name/design-principles)
- [Mailchimp Writing Goals and Principles](http://styleguide.mailchimp.com/writing-principles/)
- [Nachos - Trello's Design System Principles](https://design.trello.com/principles)
- [Seek Style Guide Principles](https://seek-oss.github.io/seek-style-guide/)
- [Shopify Polaris Principles](https://polaris.shopify.com/principles/principles#app)
- [U.S. Web Design Principles](https://standards.usa.gov/design-principles/)

## Articles about Design Principles

- [Design Principles - a Guide](https://www.cxpartners.co.uk/our-thinking/design-principles/) - 良好的介绍和最佳实践.
- [Developing Asanas Design Principles](https://blog.asana.com/2013/10/design-principles/) - 关于 Asana 如何发展其原则的内幕文章.
- [The Core Principles of UI Design](https://www.invisionapp.com/blog/core-principles-of-ui-design/) - Fundamental UI Design 的简短摘录，这是 Jane Portman 的 InVision 电子课程.
- [Design Principles Guide to less shitty Feedback](https://medium.com/apegroup-texts/design-principles-a-guide-to-less-shitty-feedback-64e9541816c1) - 关于如何设定设计原则的简短介绍和实用指南（附示例）

## Other Resources

- [Built Environment Innovation Design](https://github.com/BEICOOP/BEICPBLChallenge/blob/master/Phase3/Stakeholders_Roles/Designer.md) - 列出与建筑环境企业相关的专业设计学科并描述它们的角色（基于开源项目的学习挑战课程的一部分）.
- [Learn Design Principles](http://learndesignprinciples.com/) - 了解如何将设计原则从架构应用到产品设计.
- [Design Principles FTW](http://www.designprinciplesftw.com/) - “互联网上最大的设计原则集合.”
- [principles.adactio.com](https://principles.adactio.com/) - 包含各种类型的更传统设计原则的巨大列表.
- [Principles of User Interface Design](http://bokardo.com/principles-of-user-interface-design/) - 由 Joshua Porter 详细解释原则的长列表
- [Principles of Product Design](http://bokardo.com/principles-of-product-design/) - 由 Joshua Porter 详细解释原则的长列表

### Credits and Notes
这份清单的灵感主要来自 [Awesome Design Systems](https://github.com/alexpate/awesome-design-systems) 亚历克斯佩特. 作为一名用户体验设计师，我发现自己经常编写设计和/或体验原则. 我创建此列表以供参考并获得更好设计原则的灵感.
