<div class="github-widget" data-repo="ChristosChristofidis/awesome-deep-learning"></div>
## Awesome Deep Learning [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)


* **[Books](#books)**

* **[Courses](#courses)**  

* **[Videos and Lectures](#videos-and-lectures)**  

* **[Papers](#papers)**  

* **[Tutorials](#tutorials)**  

* **[Researchers](#researchers)**  

* **[Websites](#websites)**  

* **[Datasets](#datasets)**

* **[Conferences](#Conferences)**

* **[Frameworks](#frameworks)**  

* **[Tools](#tools)**  

* **[Miscellaneous](#miscellaneous)**  

* **[Contributing](#contributing)**  


### Books

1.  [Deep Learning](http://www.deeplearningbook.org/) 作者：Yoshua Bengio、Ian Goodfellow 和 Aaron Courville (05/07/2015)
2.  [Neural Networks and Deep Learning](http://neuralnetworksanddeeplearning.com/) Michael Nielsen（2014 年 12 月）
3.  [Deep Learning](http://research.microsoft.com/pubs/209355/DeepLearning-NowPublishing-Vol7-SIG-039.pdf) 微软研究院 (2013)
4.  [Deep Learning Tutorial](http://deeplearning.net/tutorial/deeplearning.pdf) 蒙特利尔大学 LISA 实验室（2015 年 1 月 6 日）
5.  [neuraltalk](https://github.com/karpathy/neuraltalk) 作者：Andrej Karpathy：基于 numpy 的 RNN/LSTM 实现
6.  [An introduction to genetic algorithms](http://www.boente.eti.br/fuzzy/ebook-fuzzy-mitchell.pdf)
7.  [Artificial Intelligence: A Modern Approach](http://aima.cs.berkeley.edu/)
8.  [Deep Learning in Neural Networks: An Overview](http://arxiv.org/pdf/1404.7828v4.pdf)
9.  [Artificial intelligence and machine learning: Topic wise explanation](https://leonardoaraujosantos.gitbooks.io/artificial-inteligence/)
10. [Grokking Deep Learning for Computer Vision](https://www.manning.com/books/grokking-deep-learning-for-computer-vision)
11. [Dive into Deep Learning](https://d2l.ai/) - 基于 numpy 的交互式深度学习书籍
12. [Practical Deep Learning for Cloud, Mobile, and Edge](https://www.oreilly.com/library/view/practical-deep-learning/9781492034858/) - 一本关于生产过程中优化技术的书.
13. [Math and Architectures of Deep Learning](https://www.manning.com/books/math-and-architectures-of-deep-learning) - 克里希南杜·乔杜里 (Krishnendu Chaudhury)
14. [TensorFlow 2.0 in Action](https://www.manning.com/books/tensorflow-in-action) - Thushan Ganegedara 着
15. [Deep Learning for Natural Language Processing](https://www.manning.com/books/deep-learning-for-natural-language-processing) - Stephan Raaijmakers
16. [Deep Learning Patterns and Practices](https://www.manning.com/books/deep-learning-patterns-and-practices) - 安德鲁·费利奇
17. [Inside Deep Learning](https://www.manning.com/books/inside-deep-learning) ——爱德华·拉夫
18. [Deep Learning with Python, Second Edition](https://www.manning.com/books/deep-learning-with-python-second-edition) ——弗朗索瓦·肖莱
19. [Evolutionary Deep Learning](https://www.manning.com/books/evolutionary-deep-learning) - 迈克尔·兰哈姆
20. [Engineering Deep Learning Platforms](https://www.manning.com/books/engineering-deep-learning-platforms) - Chi Wang 和 Donald Szeto
21. [Deep Learning with R, Second Edition](https://www.manning.com/books/deep-learning-with-r-second-edition) - François Chollet 与 Tomasz Kalinowski 和 JJ Allaire
22. [Regularization in Deep Learning](https://www.manning.com/books/regularization-in-deep-learning) - by Liu Peng
23. [Jax in Action](https://www.manning.com/books/jax-in-action) ——格里戈里·萨普诺夫
24. [Hands-On Machine Learning with Scikit-Learn, Keras, and TensorFlow](https://www.knowledgeisle.com/wp-content/uploads/2019/12/2-Aur%C3%A9lien-G%C3%A9ron-Hands-On-Machine-Learning-with-Scikit-Learn-Keras-and-Tensorflow_-Concepts-Tools-and-Techniques-to-Build-Intelligent-Systems-O%E2%80%99Reilly-Media-2019.pdf) 通过 Aurélien Géron |  2019 年 10 月 15 日

### Courses

1.  [Machine Learning - Stanford](https://class.coursera.org/ml-005) 作者：Andrew Ng 在 Coursera 中（2010-2014）
2.  [Machine Learning - Caltech](http://work.caltech.edu/lectures.html) 亚西尔·阿布-穆斯塔法 (2012-2014)
3.  [Machine Learning - Carnegie Mellon](http://www.cs.cmu.edu/~tom/10701_sp11/lectures.shtml) 作者：Tom Mitchell（2011 年春季）
2.  [Neural Networks for Machine Learning](https://class.coursera.org/neuralnets-2012-001) 作者：Geoffrey Hinton 在 Coursera 中（2012 年）
3.  [Neural networks class](https://www.youtube.com/playlist?list=PL6Xpj9I5qXYEcOhn7TqghAJ6NAPrNmUBH) 来自舍布鲁克大学的 Hugo Larochelle (2013)
4.  [Deep Learning Course](http://cilvr.cs.nyu.edu/doku.php?id=deeplearning:slides:start) 纽约大学 CILVR 实验室 (2014)
5.  [A.I - Berkeley](https://courses.edx.org/courses/BerkeleyX/CS188x_1/1T2013/courseware/) 丹·克莱因和彼得·阿比尔 (2013)
6.  [A.I - MIT](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-034-artificial-intelligence-fall-2010/lecture-videos/) 帕特里克·亨利·温斯顿 (2010)
7.  [Vision and learning - computers and brains](http://web.mit.edu/course/other/i2course/www/vision_and_learning_fall_2013.html) 作者：Shimon Ullman、Tomaso Poggio、Ethan Meyers @ MIT (2013)
9.  [Convolutional Neural Networks for Visual Recognition - Stanford](http://vision.stanford.edu/teaching/cs231n/syllabus.html) by Fei-Fei Li, Andrej Karpathy (2017)
10.  [Deep Learning for Natural Language Processing - Stanford](http://cs224d.stanford.edu/)
11.  [Neural Networks - usherbrooke](http://info.usherbrooke.ca/hlarochelle/neural_networks/content.html)
12.  [Machine Learning - Oxford](https://www.cs.ox.ac.uk/people/nando.defreitas/machinelearning/) (2014-2015)
13.  [Deep Learning - Nvidia](https://developer.nvidia.com/deep-learning-courses) (2015)
14.  [Graduate Summer School: Deep Learning, Feature Learning](https://www.youtube.com/playlist?list=PLHyI3Fbmv0SdzMHAy0aN59oYnLy5vyyTA) Geoffrey Hinton、Joshua Bengio、Yann LeCun、Andrew Ng、Nando de Freitas 和其他几位@IPAM，加州大学洛杉矶分校 (2012)
15.  [Deep Learning - Udacity/Google](https://www.udacity.com/course/deep-learning--ud730) 作者：Vincent Vanhoucke 和 Arpan Chakraborty (2016)
16.  [Deep Learning - UWaterloo](https://www.youtube.com/playlist?list=PLehuLRPyt1Hyi78UOkMPWCGRxGcA9NVOE) 滑铁卢大学 Ali Ghodsi 教授 (2015)
17.  [Statistical Machine Learning - CMU](https://www.youtube.com/watch?v=azaLcvuql_g&list=PLjbUi5mgii6BWEUZf7He6nowWvGne_Y8r) 拉里·沃瑟曼 (Larry Wasserman) 教授
18.  [Deep Learning Course](https://www.college-de-france.fr/site/en-yann-lecun/course-2015-2016.htm) Yann LeCun (2016)
19. [Designing, Visualizing and Understanding Deep Neural Networks-UC Berkeley](https://www.youtube.com/playlist?list=PLkFD6_40KJIxopmdJF_CLNqG3QuDFHQUm)
20. [UVA Deep Learning Course](http://uvadlc.github.io) 阿姆斯特丹大学人工智能硕士.
21. [MIT 6.S094: Deep Learning for Self-Driving Cars](http://selfdrivingcars.mit.edu/)
22. [MIT 6.S191: Introduction to Deep Learning](http://introtodeeplearning.com/)
23. [Berkeley CS 294: Deep Reinforcement Learning](http://rll.berkeley.edu/deeprlcourse/)
24. [Keras in Motion video course](https://www.manning.com/livevideo/keras-in-motion)
25. [Practical Deep Learning For Coders](http://course.fast.ai/) 作者：Jeremy Howard - Fast.ai
26. [Introduction to Deep Learning](http://deeplearning.cs.cmu.edu/) 由教授比克沙·拉吉 (2017)
27. [AI for Everyone](https://www.deeplearning.ai/ai-for-everyone/) 吴恩达 (2019)
28. [MIT Intro to Deep Learning 7 day bootcamp](https://introtodeeplearning.com) - 在麻省理工学院设计的为期 7 天的训练营，介绍深度学习方法和应用（2019 年）
29. [Deep Blueberry: Deep Learning](https://mithi.github.io/deep-blueberry) - 免费的五个周末计划，供自学者学习深度学习架构的基础知识，如 CNN、LSTM、RNN、VAE、GAN、DQN、A3C 等（2019 年）
30. [Spinning Up in Deep Reinforcement Learning](https://spinningup.openai.com/) - OpenAI 提供的免费深度强化学习课程（2019 年）
31. [Deep Learning Specialization - Coursera](https://www.coursera.org/specializations/deep-learning) - 通过 Andrew NG 的最佳课程进入 AI.
32. [Deep Learning - UC Berkeley | STAT-157](https://www.youtube.com/playlist?list=PLZSO_6-bSqHQHBCoGaObUljoXAyyqhpFW) Alex Smola 和 Mu Li (2019)
33. [Machine Learning for Mere Mortals video course](https://www.manning.com/livevideo/machine-learning-for-mere-mortals) 通过尼克蔡斯
34. [Machine Learning Crash Course with TensorFlow APIs](https://developers.google.com/machine-learning/crash-course/) -谷歌人工智能
35. [Deep Learning from the Foundations](https://course.fast.ai/part2) 杰里米霍华德 - Fast.ai
36. [Deep Reinforcement Learning (nanodegree) - Udacity](https://www.udacity.com/course/deep-reinforcement-learning-nanodegree--nd893) 3-6 个月的优达学城纳米学位，涵盖多个课程（2018 年）
37. [Grokking Deep Learning in Motion](https://www.manning.com/livevideo/grokking-deep-learning-in-motion) 博卡内斯 (2018)
38. [Face Detection with Computer Vision and Deep Learning](https://www.udemy.com/share/1000gAA0QdcV9aQng=/) 通过 Hakan Cebeci
39. [Deep Learning Online Course list at Classpert](https://classpert.com/deep-learning) 来自 Classpert 在线课程搜索的深度学习在线课程列表（有些是免费的）
40. [AWS Machine Learning](https://aws.training/machinelearning) 亚马逊机器学习大学的机器学习和深度学习课程
41. [Intro to Deep Learning with PyTorch](https://www.udacity.com/course/deep-learning-pytorch--ud188) - Udacity 和 Facebook AI 的深度学习入门课程
42. [Deep Learning by Kaggle](https://www.kaggle.com/learn/deep-learning) - Kaggle 的深度学习免费课程
43. [Yann LeCun’s Deep Learning Course at CDS](https://cds.nyu.edu/deep-learning/) - DS-GA 1008 · 2021 年春季 
44. [Neural Networks and Deep Learning](https://webcms3.cse.unsw.edu.au/COMP9444/19T3/) - COMP9444 19T3
45. [Deep Learning A.I.Shelf](http://aishelf.org/category/ia/deep-learning/)

### Videos and Lectures

1.  [How To Create A Mind](https://www.youtube.com/watch?v=RIkxVci-R4k) 雷·库兹韦尔
2.  [Deep Learning, Self-Taught Learning and Unsupervised Feature Learning](https://www.youtube.com/watch?v=n1ViNeWhC24) 吴恩达
3.  [Recent Developments in Deep Learning](https://www.youtube.com/watch?v=vShMxxqtDDs&amp;index=3&amp;list=PL78U8qQHXgrhP9aZraxTT5-X1RccTcUYT) 杰夫·辛顿
4.  [The Unreasonable Effectiveness of Deep Learning](https://www.youtube.com/watch?v=sc-KbuZqGkI) 通过 Yann LeCun
5.  [Deep Learning of Representations](https://www.youtube.com/watch?v=4xsVFLnHC_0) 通过约书亚本吉奥
6.  [Principles of Hierarchical Temporal Memory](https://www.youtube.com/watch?v=6ufPpZDmPKA) 通过杰夫霍金斯
7.  [Machine Learning Discussion Group - Deep Learning w/ Stanford AI Lab](https://www.youtube.com/watch?v=2QJi0ArLq7s&amp;list=PL78U8qQHXgrhP9aZraxTT5-X1RccTcUYT) 通过亚当科茨
8.  [Making Sense of the World with Deep Learning](http://vimeo.com/80821560) 亚当·科茨
9.  [Demystifying Unsupervised Feature Learning ](https://www.youtube.com/watch?v=wZfVBwOO0-k) 亚当·科茨
10.  [Visual Perception with Deep Learning](https://www.youtube.com/watch?v=3boKlkPBckA) 通过 Yann LeCun
11.  [The Next Generation of Neural Networks](https://www.youtube.com/watch?v=AyzOUbkUf3M) 作者：Geoffrey Hinton 在 GoogleTechTalks
12.  [The wonderful and terrifying implications of computers that can learn](http://www.ted.com/talks/jeremy_howard_the_wonderful_and_terrifying_implications_of_computers_that_can_learn) TEDxBrussels 的杰里米·霍华德 (Jeremy Howard)
13.  [Unsupervised Deep Learning - Stanford](http://web.stanford.edu/class/cs294a/handouts.html) Andrew Ng 在斯坦福大学 (2011)
14.  [Natural Language Processing](http://web.stanford.edu/class/cs224n/handouts/) 克里斯·曼宁 (Chris Manning) 在斯坦福
15.  [A beginners Guide to Deep Neural Networks](http://googleresearch.blogspot.com/2015/09/a-beginners-guide-to-deep-neural.html) 娜塔莉·哈梅尔和洛林·尤尔尚斯基
16.  [Deep Learning: Intelligence from Big Data](https://www.youtube.com/watch?v=czLI3oLDe8M) 由斯坦福 VLAB 的 Steve Jurvetson（和小组）撰写.
17. [Introduction to Artificial Neural Networks and Deep Learning](https://www.youtube.com/watch?v=FoO8qDB8gUU) 摩托罗拉移动总部的 Leo Isikdogan
18. [NIPS 2016 lecture and workshop videos](https://nips.cc/Conferences/2016/Schedule) - NIPS 2016
19. [Deep Learning Crash Course](https://www.youtube.com/watch?v=oS5fz_mHVz0&list=PLWKotBjTDoLj3rXBL-nEIPRN9V3a9Cx07)：Leo Isikdogan 在 YouTube 上的一系列迷你讲座（2018 年）
20. [Deep Learning Crash Course](https://www.manning.com/livevideo/deep-learning-crash-course) 作者：Oliver Indicator Man
21. [Deep Learning with R in Motion](https://www.manning.com/livevideo/deep-learning-with-r-in-motion)：一个实时视频课程，教授如何使用强大的 Keras 库及其 R 语言界面将深度学习应用于文本和图像.
22. [Medical Imaging with Deep Learning Tutorial](https://www.youtube.com/playlist?list=PLheiZMDg_8ufxEx9cNVcOYXsT3BppJP4b) ：本教程的风格是关于深度学习医学成像的研究生讲座. 这将涵盖流行医学图像领域（胸部 X 光和组织学）的背景，以及处理多模态/视图、分割和计数任务的方法.
23. [Deepmind x UCL Deeplearning](https://www.youtube.com/playlist?list=PLqYmG7hTraZCDxZ44o4p3N5Anz3lLRVZF): 2020 版本 
24. [Deepmind x UCL Reinforcement Learning](https://www.youtube.com/playlist?list=PLqYmG7hTraZBKeNJ-JE_eyJHZ7XgBoAyb): 深度强化学习
25. [CMU 11-785 Intro to Deep learning Spring 2020](https://www.youtube.com/playlist?list=PLp-0K3kfddPzCnS4CqKphh-zT3aDwybDe) 课程：11-785，Bhiksha Raj 深度学习入门 
26. [Machine Learning CS 229](https://www.youtube.com/playlist?list=PLoROMvodv4rMiGQp3WXShtMGgzqpfVfbU) : 结尾部分着重于深度学习 By Andrew Ng
27. [What is Neural Structured Learning by Andrew Ferlitsch](https://youtu.be/LXWSE_9gHd0)
28. [Deep Learning Design Patterns by Andrew Ferlitsch](https://youtu.be/_DaviS6K0Vc)
29. [Architecture of a Modern CNN: the design pattern approach by Andrew Ferlitsch](https://youtu.be/QCGSS3kyGo0)
30. [Metaparameters in a CNN by Andrew Ferlitsch](https://youtu.be/K1PLeggQ33I)
31. [Multi-task CNN: a real-world example by Andrew Ferlitsch](https://youtu.be/dH2nuI-1-qM)
32. [A friendly introduction to deep reinforcement learning by Luis Serrano](https://youtu.be/1FyAh07jh0o)
33. [What are GANs and how do they work? by Edward Raff](https://youtu.be/f6ivp84qFUc)
34. [Coding a basic WGAN in PyTorch by Edward Raff](https://youtu.be/7VRdaqMDalQ)
35. [Training a Reinforcement Learning Agent by Miguel Morales](https://youtu.be/8TMT-gHlj_Q)
36. [Understand what is Deep Learning](https://www.scaler.com/topics/what-is-deep-learning/)

### Papers
*您还可以从中找到被引用最多的深度学习论文 [here](https://github.com/terryum/awesome-deep-learning-papers)*

1.  [ImageNet Classification with Deep Convolutional Neural Networks](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks.pdf)
2.  [Using Very Deep Autoencoders for Content Based Image Retrieval](http://www.cs.toronto.edu/~hinton/absps/esann-deep-final.pdf)
3.  [Learning Deep Architectures for AI](http://www.iro.umontreal.ca/~lisa/pointeurs/TR1312.pdf)
4.  [CMU’s list of papers](http://deeplearning.cs.cmu.edu/)
5.  [Neural Networks for Named Entity Recognition](http://nlp.stanford.edu/~socherr/pa4_ner.pdf) [zip](http://nlp.stanford.edu/~socherr/pa4-ner.zip)
6. [Training tricks by YB](http://www.iro.umontreal.ca/~bengioy/papers/YB-tricks.pdf)
7. [Geoff Hinton's reading list (all papers)](http://www.cs.toronto.edu/~hinton/deeprefs.html)
8. [Supervised Sequence Labelling with Recurrent Neural Networks](http://www.cs.toronto.edu/~graves/preprint.pdf)
9.  [Statistical Language Models based on Neural Networks](http://www.fit.vutbr.cz/~imikolov/rnnlm/thesis.pdf)
10.  [Training Recurrent Neural Networks](http://www.cs.utoronto.ca/~ilya/pubs/ilya_sutskever_phd_thesis.pdf)
11.  [Recursive Deep Learning for Natural Language Processing and Computer Vision](http://nlp.stanford.edu/~socherr/thesis.pdf)
12.  [Bi-directional RNN](http://www.di.ufpe.br/~fnj/RNA/bibliografia/BRNN.pdf)
13.  [LSTM](http://web.eecs.utk.edu/~itamar/courses/ECE-692/Bobby_paper1.pdf)
14.  [GRU - Gated Recurrent Unit](http://arxiv.org/pdf/1406.1078v3.pdf)
15.  [GFRNN](http://arxiv.org/pdf/1502.02367v3.pdf) [.](http://jmlr.org/proceedings/papers/v37/chung15.pdf) [.](http://jmlr.org/proceedings/papers/v37/chung15-supp.pdf)
16.  [LSTM: A Search Space Odyssey](http://arxiv.org/pdf/1503.04069v1.pdf)
17.  [A Critical Review of Recurrent Neural Networks for Sequence Learning](http://arxiv.org/pdf/1506.00019v1.pdf)
18.  [Visualizing and Understanding Recurrent Networks](http://arxiv.org/pdf/1506.02078v1.pdf)
19.  [Wojciech Zaremba, Ilya Sutskever, An Empirical Exploration of Recurrent Network Architectures](http://jmlr.org/proceedings/papers/v37/jozefowicz15.pdf)
20.  [Recurrent Neural Network based Language Model](http://www.fit.vutbr.cz/research/groups/speech/publi/2010/mikolov_interspeech2010_IS100722.pdf)
21.  [Extensions of Recurrent Neural Network Language Model](http://www.fit.vutbr.cz/research/groups/speech/publi/2011/mikolov_icassp2011_5528.pdf)
22.  [Recurrent Neural Network based Language Modeling in Meeting Recognition](http://www.fit.vutbr.cz/~imikolov/rnnlm/ApplicationOfRNNinMeetingRecognition_IS2011.pdf)
23.  [Deep Neural Networks for Acoustic Modeling in Speech Recognition](http://cs224d.stanford.edu/papers/maas_paper.pdf)
24.  [Speech Recognition with Deep Recurrent Neural Networks](http://www.cs.toronto.edu/~fritz/absps/RNN13.pdf)
25.  [Reinforcement Learning Neural Turing Machines](http://arxiv.org/pdf/1505.00521v1)
26.  [Learning Phrase Representations using RNN Encoder-Decoder for Statistical Machine Translation](http://arxiv.org/pdf/1406.1078v3.pdf)
27. [Google - Sequence to Sequence  Learning with Neural Networks](http://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf)
28. [Memory Networks](http://arxiv.org/pdf/1410.3916v10)
29. [Policy Learning with Continuous Memory States for Partially Observed Robotic Control](http://arxiv.org/pdf/1507.01273v1)
30. [Microsoft - Jointly Modeling Embedding and Translation to Bridge Video and Language](http://arxiv.org/pdf/1505.01861v1.pdf)
31. [Neural Turing Machines](http://arxiv.org/pdf/1410.5401v2.pdf)
32. [Ask Me Anything: Dynamic Memory Networks for Natural Language Processing](http://arxiv.org/pdf/1506.07285v1.pdf)
33. [Mastering the Game of Go with Deep Neural Networks and Tree Search](http://www.nature.com/nature/journal/v529/n7587/pdf/nature16961.pdf)
34. [Batch Normalization](https://arxiv.org/abs/1502.03167)
35. [Residual Learning](https://arxiv.org/pdf/1512.03385v1.pdf)
36. [Image-to-Image Translation with Conditional Adversarial Networks](https://arxiv.org/pdf/1611.07004v1.pdf)
37. [Berkeley AI Research (BAIR) Laboratory](https://arxiv.org/pdf/1611.07004v1.pdf)
38. [MobileNets by Google](https://arxiv.org/abs/1704.04861)
39. [Cross Audio-Visual Recognition in the Wild Using Deep Learning](https://arxiv.org/abs/1706.05739)
40. [Dynamic Routing Between Capsules](https://arxiv.org/abs/1710.09829)
41. [Matrix Capsules With Em Routing](https://openreview.net/pdf?id=HJWLfGWRb)
42. [Efficient BackProp](http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf)
43. [Generative Adversarial Nets](https://arxiv.org/pdf/1406.2661v1.pdf)
44. [Fast R-CNN](https://arxiv.org/pdf/1504.08083.pdf)
45. [FaceNet: A Unified Embedding for Face Recognition and Clustering](https://arxiv.org/pdf/1503.03832.pdf)
46. [Siamese Neural Networks for One-shot Image Recognition](https://www.cs.cmu.edu/~rsalakhu/papers/oneshot1.pdf)
47. [Unsupervised Translation of Programming Languages](https://arxiv.org/pdf/2006.03511.pdf)
48. [Matching Networks for One Shot Learning](http://papers.nips.cc/paper/6385-matching-networks-for-one-shot-learning.pdf)
49. [VOLO: Vision Outlooker for Visual Recognition](https://arxiv.org/pdf/2106.13112.pdf)
50. [ViT: An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale](https://arxiv.org/pdf/2010.11929.pdf)
51. [Batch Normalization: Accelerating Deep Network Training by Reducing Internal Covariate Shift](http://proceedings.mlr.press/v37/ioffe15.pdf)
52. [DeepFaceDrawing: Deep Generation of Face Images from Sketches](http://geometrylearning.com/paper/DeepFaceDrawing.pdf?fbclid=IwAR0colWFHPGBCB1APZq9JVsWeWtmeZd9oCTNQvR52T5PRUJP_dLOwB8pt0I)

### Tutorials

1.  [UFLDL Tutorial 1](http://deeplearning.stanford.edu/wiki/index.php/UFLDL_Tutorial)
2.  [UFLDL Tutorial 2](http://ufldl.stanford.edu/tutorial/supervised/LinearRegression/)
3.  [Deep Learning for NLP (without Magic)](http://www.socher.org/index.php/DeepLearningTutorial/DeepLearningTutorial)
4.  [A Deep Learning Tutorial: From Perceptrons to Deep Networks](http://www.toptal.com/machine-learning/an-introduction-to-deep-learning-from-perceptrons-to-deep-networks)
5.  [Deep Learning from the Bottom up](http://www.metacademy.org/roadmaps/rgrosse/deep_learning)
6.  [Theano Tutorial](http://deeplearning.net/tutorial/deeplearning.pdf)
7.  [Neural Networks for Matlab](http://uk.mathworks.com/help/pdf_doc/nnet/nnet_ug.pdf)
8.  [Using convolutional neural nets to detect facial keypoints tutorial](http://danielnouri.org/notes/2014/12/17/using-convolutional-neural-nets-to-detect-facial-keypoints-tutorial/)
9.  [Torch7 Tutorials](https://github.com/clementfarabet/ipam-tutorials/tree/master/th_tutorials)
10.  [The Best Machine Learning Tutorials On The Web](https://github.com/josephmisiti/machine-learning-module)
11. [VGG Convolutional Neural Networks Practical](http://www.robots.ox.ac.uk/~vgg/practicals/cnn/index.html)
12. [TensorFlow tutorials](https://github.com/nlintz/TensorFlow-Tutorials)
13. [More TensorFlow tutorials](https://github.com/pkmital/tensorflow_tutorials)
13. [TensorFlow Python Notebooks](https://github.com/aymericdamien/TensorFlow-Examples)
14. [Keras and Lasagne Deep Learning Tutorials](https://github.com/Vict0rSch/deep_learning)
15. [Classification on raw time series in TensorFlow with a LSTM RNN](https://github.com/guillaume-chevalier/LSTM-Human-Activity-Recognition)
16. [Using convolutional neural nets to detect facial keypoints tutorial](http://danielnouri.org/notes/2014/12/17/using-convolutional-neural-nets-to-detect-facial-keypoints-tutorial/)
17. [TensorFlow-World](https://github.com/astorfi/TensorFlow-World)
18. [Deep Learning with Python](https://www.manning.com/books/deep-learning-with-python)
19. [Grokking Deep Learning](https://www.manning.com/books/grokking-deep-learning)
20. [Deep Learning for Search](https://www.manning.com/books/deep-learning-for-search)
21. [Keras Tutorial: Content Based Image Retrieval Using a Convolutional Denoising Autoencoder](https://medium.com/sicara/keras-tutorial-content-based-image-retrieval-convolutional-denoising-autoencoder-dc91450cc511)
22. [Pytorch Tutorial by Yunjey Choi](https://github.com/yunjey/pytorch-tutorial)
23. [Understanding deep Convolutional Neural Networks with a practical use-case in Tensorflow and Keras](https://ahmedbesbes.com/understanding-deep-convolutional-neural-networks-with-a-practical-use-case-in-tensorflow-and-keras.html)
24. [Overview and benchmark of traditional and deep learning models in text classification](https://ahmedbesbes.com/overview-and-benchmark-of-traditional-and-deep-learning-models-in-text-classification.html)
25. [Hardware for AI: Understanding computer hardware & build your own computer](https://github.com/MelAbgrall/HardwareforAI)
26. [Programming Community Curated Resources](https://hackr.io/tutorials/learn-artificial-intelligence-ai)
27. [The Illustrated Self-Supervised Learning](https://amitness.com/2020/02/illustrated-self-supervised-learning/)
28. [Visual Paper Summary: ALBERT (A Lite BERT)](https://amitness.com/2020/02/albert-visual-summary/)
28. [Semi-Supervised Deep Learning with GANs for Melanoma Detection](https://www.manning.com/liveproject/semi-supervised-deep-learning-with-gans-for-melanoma-detection/)
29. [Named Entity Recognition using Reformers](https://github.com/SauravMaheshkar/Trax-Examples/blob/main/NLP/NER%20using%20Reformer.ipynb)
30. [Deep N-Gram Models on Shakespeare’s works](https://github.com/SauravMaheshkar/Trax-Examples/blob/main/NLP/Deep%20N-Gram.ipynb)
31. [Wide Residual Networks](https://github.com/SauravMaheshkar/Trax-Examples/blob/main/vision/illustrated-wideresnet.ipynb)
32. [Fashion MNIST using Flax](https://github.com/SauravMaheshkar/Flax-Examples)
33. [Fake News Classification (with streamlit deployment)](https://github.com/SauravMaheshkar/Fake-News-Classification)
34. [Regression Analysis for Primary Biliary Cirrhosis](https://github.com/SauravMaheshkar/CoxPH-Model-for-Primary-Biliary-Cirrhosis)
35. [Cross Matching Methods for Astronomical Catalogs](https://github.com/SauravMaheshkar/Cross-Matching-Methods-for-Astronomical-Catalogs)
36. [Named Entity Recognition using BiDirectional LSTMs](https://github.com/SauravMaheshkar/Named-Entity-Recognition-)
37. [Image Recognition App using Tflite and Flutter](https://github.com/SauravMaheshkar/Flutter_Image-Recognition)

## Researchers

1. [Aaron Courville](http://aaroncourville.wordpress.com)
2. [Abdel-rahman Mohamed](http://www.cs.toronto.edu/~asamir/)
3. [Adam Coates](http://cs.stanford.edu/~acoates/)
4. [Alex Acero](http://research.microsoft.com/en-us/people/alexac/)
5. [ Alex Krizhevsky ](http://www.cs.utoronto.ca/~kriz/index.html)
6. [ Alexander Ilin ](http://users.ics.aalto.fi/alexilin/)
7. [ Amos Storkey ](http://homepages.inf.ed.ac.uk/amos/)
8. [ Andrej Karpathy ](https://karpathy.ai/)
9. [ Andrew M. Saxe ](http://www.stanford.edu/~asaxe/)
10. [ Andrew Ng ](http://www.cs.stanford.edu/people/ang/)
11. [ Andrew W. Senior ](http://research.google.com/pubs/author37792.html)
12. [ Andriy Mnih ](http://www.gatsby.ucl.ac.uk/~amnih/)
13. [ Ayse Naz Erkan ](http://www.cs.nyu.edu/~naz/)
14. [ Benjamin Schrauwen ](http://reslab.elis.ugent.be/benjamin)
15. [ Bernardete Ribeiro ](https://www.cisuc.uc.pt/people/show/2020)
16. [ Bo David Chen ](http://vision.caltech.edu/~bchen3/Site/Bo_David_Chen.html)
17. [ Boureau Y-Lan ](http://cs.nyu.edu/~ylan/)
18. [ Brian Kingsbury ](http://researcher.watson.ibm.com/researcher/view.php?person=us-bedk)
19. [ Christopher Manning ](http://nlp.stanford.edu/~manning/)
20. [ Clement Farabet ](http://www.clement.farabet.net/)
21. [ Dan Claudiu Cireșan ](http://www.idsia.ch/~ciresan/)
22. [ David Reichert ](http://serre-lab.clps.brown.edu/person/david-reichert/)
23. [ Derek Rose ](http://mil.engr.utk.edu/nmil/member/5.html)
24. [ Dong Yu ](http://research.microsoft.com/en-us/people/dongyu/default.aspx)
25. [ Drausin Wulsin ](http://www.seas.upenn.edu/~wulsin/)
26. [ Erik M. Schmidt ](http://music.ece.drexel.edu/people/eschmidt)
27. [ Eugenio Culurciello ](https://engineering.purdue.edu/BME/People/viewPersonById?resource_id=71333)
28. [ Frank Seide ](http://research.microsoft.com/en-us/people/fseide/)
29. [ Galen Andrew ](http://homes.cs.washington.edu/~galen/)
30. [ Geoffrey Hinton ](http://www.cs.toronto.edu/~hinton/)
31. [ George Dahl ](http://www.cs.toronto.edu/~gdahl/)
32. [ Graham Taylor ](http://www.uoguelph.ca/~gwtaylor/)
33. [ Grégoire Montavon ](http://gregoire.montavon.name/)
34. [ Guido Francisco Montúfar ](http://personal-homepages.mis.mpg.de/montufar/)
35. [ Guillaume Desjardins ](http://brainlogging.wordpress.com/)
36. [ Hannes Schulz ](http://www.ais.uni-bonn.de/~schulz/)
37. [ Hélène Paugam-Moisy ](http://www.lri.fr/~hpaugam/)
38. [ Honglak Lee ](http://web.eecs.umich.edu/~honglak/)
39. [ Hugo Larochelle ](http://www.dmi.usherb.ca/~larocheh/index_en.html)
40. [ Ilya Sutskever ](http://www.cs.toronto.edu/~ilya/)
41. [ Itamar Arel ](http://mil.engr.utk.edu/nmil/member/2.html)
42. [ James Martens ](http://www.cs.toronto.edu/~jmartens/)
43. [ Jason Morton ](http://www.jasonmorton.com/)
44. [ Jason Weston ](http://www.thespermwhale.com/jaseweston/)
45. [ Jeff Dean ](http://research.google.com/pubs/jeff.html)
46. [ Jiquan Mgiam ](http://cs.stanford.edu/~jngiam/)
47. [ Joseph Turian ](http://www-etud.iro.umontreal.ca/~turian/)
48. [ Joshua Matthew Susskind ](http://aclab.ca/users/josh/index.html)
49. [ Jürgen Schmidhuber ](http://www.idsia.ch/~juergen/)
50. [ Justin A. Blanco ](https://sites.google.com/site/blancousna/)
51. [ Koray Kavukcuoglu ](http://koray.kavukcuoglu.org/)
52. [ KyungHyun Cho ](http://users.ics.aalto.fi/kcho/)
53. [ Li Deng ](http://research.microsoft.com/en-us/people/deng/)
54. [ Lucas Theis ](http://www.kyb.tuebingen.mpg.de/nc/employee/details/lucas.html)
55. [ Ludovic Arnold ](http://ludovicarnold.altervista.org/home/)
56. [ Marc'Aurelio Ranzato ](http://www.cs.nyu.edu/~ranzato/)
57. [ Martin Längkvist ](http://aass.oru.se/~mlt/)
58. [ Misha Denil ](http://mdenil.com/)
59. [ Mohammad Norouzi ](http://www.cs.toronto.edu/~norouzi/)
60. [ Nando de Freitas ](http://www.cs.ubc.ca/~nando/)
61. [ Navdeep Jaitly ](http://www.cs.utoronto.ca/~ndjaitly/)
62. [ Nicolas Le Roux ](http://nicolas.le-roux.name/)
63. [ Nitish Srivastava ](http://www.cs.toronto.edu/~nitish/)
64. [ Noel Lopes ](https://www.cisuc.uc.pt/people/show/2028)
65. [ Oriol Vinyals ](http://www.cs.berkeley.edu/~vinyals/)
66. [ Pascal Vincent ](http://www.iro.umontreal.ca/~vincentp)
67. [ Patrick Nguyen ](https://sites.google.com/site/drpngx/)
68. [ Pedro Domingos ](http://homes.cs.washington.edu/~pedrod/)
69. [ Peggy Series ](http://homepages.inf.ed.ac.uk/pseries/)
70. [ Pierre Sermanet ](http://cs.nyu.edu/~sermanet)
71. [ Piotr Mirowski ](http://www.cs.nyu.edu/~mirowski/)
72. [ Quoc V. Le ](http://ai.stanford.edu/~quocle/)
73. [ Reinhold Scherer ](http://bci.tugraz.at/scherer/)
74. [ Richard Socher ](http://www.socher.org/)
75. [ Rob Fergus ](http://cs.nyu.edu/~fergus/pmwiki/pmwiki.php)
76. [ Robert Coop ](http://mil.engr.utk.edu/nmil/member/19.html)
77. [ Robert Gens ](http://homes.cs.washington.edu/~rcg/)
78. [ Roger Grosse ](http://people.csail.mit.edu/rgrosse/)
79. [ Ronan Collobert ](http://ronan.collobert.com/)
80. [ Ruslan Salakhutdinov ](http://www.utstat.toronto.edu/~rsalakhu/)
81. [ Sebastian Gerwinn ](http://www.kyb.tuebingen.mpg.de/nc/employee/details/sgerwinn.html)
82. [ Stéphane Mallat ](http://www.cmap.polytechnique.fr/~mallat/)
83. [ Sven Behnke ](http://www.ais.uni-bonn.de/behnke/)
84. [ Tapani Raiko ](http://users.ics.aalto.fi/praiko/)
85. [ Tara Sainath ](https://sites.google.com/site/tsainath/)
86. [ Tijmen Tieleman ](http://www.cs.toronto.edu/~tijmen/)
87. [ Tom Karnowski ](http://mil.engr.utk.edu/nmil/member/36.html)
88. [ Tomáš Mikolov ](https://research.facebook.com/tomas-mikolov)
89. [ Ueli Meier ](http://www.idsia.ch/~meier/)
90. [ Vincent Vanhoucke ](http://vincent.vanhoucke.com)
91. [ Volodymyr Mnih ](http://www.cs.toronto.edu/~vmnih/)
92. [ Yann LeCun ](http://yann.lecun.com/)
93. [ Yichuan Tang ](http://www.cs.toronto.edu/~tang/)
94. [ Yoshua Bengio ](http://www.iro.umontreal.ca/~bengioy/yoshua_en/index.html)
95. [ Yotaro Kubo ](http://yota.ro/)
96. [ Youzhi (Will) Zou ](http://ai.stanford.edu/~wzou)
97. [ Fei-Fei Li ](http://vision.stanford.edu/feifeili)
98. [ Ian Goodfellow ](https://research.google.com/pubs/105214.html)
99. [ Robert Laganière ](http://www.site.uottawa.ca/~laganier/)
100. [Merve Ayyüce Kızrak](http://www.ayyucekizrak.com/)


### Websites

1.  [deeplearning.net](http://deeplearning.net/)
2.  [deeplearning.stanford.edu](http://deeplearning.stanford.edu/)
3.  [nlp.stanford.edu](http://nlp.stanford.edu/)
4.  [ai-junkie.com](http://www.ai-junkie.com/ann/evolved/nnt1.html)
5.  [cs.brown.edu/research/ai](http://cs.brown.edu/research/ai/)
6.  [eecs.umich.edu/ai](http://www.eecs.umich.edu/ai/)
7.  [cs.utexas.edu/users/ai-lab](http://www.cs.utexas.edu/users/ai-lab/)
8.  [cs.washington.edu/research/ai](http://www.cs.washington.edu/research/ai/)
9.  [aiai.ed.ac.uk](http://www.aiai.ed.ac.uk/)
10.  [www-aig.jpl.nasa.gov](http://www-aig.jpl.nasa.gov/)
11.  [csail.mit.edu](http://www.csail.mit.edu/)
12.  [cgi.cse.unsw.edu.au/~aishare](http://cgi.cse.unsw.edu.au/~aishare/)
13.  [cs.rochester.edu/research/ai](http://www.cs.rochester.edu/research/ai/)
14.  [ai.sri.com](http://www.ai.sri.com/)
15.  [isi.edu/AI/isd.htm](http://www.isi.edu/AI/isd.htm)
16.  [nrl.navy.mil/itd/aic](http://www.nrl.navy.mil/itd/aic/)
17.  [hips.seas.harvard.edu](http://hips.seas.harvard.edu/)
18.  [AI Weekly](http://aiweekly.co)
19.  [stat.ucla.edu](http://statistics.ucla.edu/)
20.  [deeplearning.cs.toronto.edu](http://deeplearning.cs.toronto.edu/i2t)
21.  [jeffdonahue.com/lrcn/](http://jeffdonahue.com/lrcn/)
22.  [visualqa.org](http://www.visualqa.org/)
23.  [www.mpi-inf.mpg.de/departments/computer-vision...](https://www.mpi-inf.mpg.de/departments/computer-vision-and-multimodal-computing/)
24.  [Deep Learning News](http://news.startup.ml/)
25.  [Machine Learning is Fun! Adam Geitgey's Blog](https://medium.com/@ageitgey/)
26.  [Guide to Machine Learning](http://yerevann.com/a-guide-to-deep-learning/)
27.  [Deep Learning for Beginners](https://spandan-madan.github.io/DeepLearningProject/)
28.  [Machine Learning Mastery blog](https://machinelearningmastery.com/blog/)
29.  [ML Compiled](https://ml-compiled.readthedocs.io/en/latest/)
30.  [Programming Community Curated Resources](https://hackr.io/tutorials/learn-artificial-intelligence-ai)
31.  [A Beginner's Guide To Understanding Convolutional Neural Networks](https://adeshpande3.github.io/A-Beginner%27s-Guide-To-Understanding-Convolutional-Neural-Networks/)
32.  [ahmedbesbes.com](http://ahmedbesbes.com)
33.  [amitness.com](https://amitness.com/)
34.  [AI Summer](https://theaisummer.com/)
35.  [AI Hub - supported by AAAI, NeurIPS](https://aihub.org/)
36.  [CatalyzeX: Machine Learning Hub for Builders and Makers](https://www.catalyzeX.com)
37.  [The Epic Code](https://theepiccode.com/)
38.  [all AI news](https://allainews.com/)

### Datasets

1.  [MNIST](http://yann.lecun.com/exdb/mnist/) 手写数字
2.  [Google House Numbers](http://ufldl.stanford.edu/housenumbers/) 从街景
3.  [CIFAR-10 and CIFAR-100](http://www.cs.toronto.edu/~kriz/cifar.html)
4.  [IMAGENET](http://www.image-net.org/)
5.  [Tiny Images](http://groups.csail.mit.edu/vision/TinyImages/) 8000 万张小图片6.  
6.  [Flickr Data](https://yahooresearch.tumblr.com/post/89783581601/one-hundred-million-creative-commons-flickr-images) 1 亿个雅虎数据集
7.  [Berkeley Segmentation Dataset 500](http://www.eecs.berkeley.edu/Research/Projects/CS/vision/bsds/)
8.  [UC Irvine Machine Learning Repository](http://archive.ics.uci.edu/ml/)
9.  [Flickr 8k](http://nlp.cs.illinois.edu/HockenmaierGroup/Framing_Image_Description/KCCA.html)
10. [Flickr 30k](http://shannon.cs.illinois.edu/DenotationGraph/)
11. [Microsoft COCO](http://mscoco.org/home/)
12. [VQA](http://www.visualqa.org/)
13. [Image QA](http://www.cs.toronto.edu/~mren/imageqa/data/cocoqa/)
14. [AT&T Laboratories Cambridge face database](http://www.uk.research.att.com/facedatabase.html)
15. [AVHRR Pathfinder](http://xtreme.gsfc.nasa.gov)
16. [Air Freight](http://www.anc.ed.ac.uk/~amos/afreightdata.html)  - Air Freight 数据集是一个光线追踪图像序列以及基于纹理特征的地面实况分割.  （455 张图像 + GT，每张 160x120 像素）.  （格式：PNG）  
17. [Amsterdam Library of Object Images](http://www.science.uva.nl/~aloi/)  - ALOI 是一千个小物体的彩色图像集合，为科学目的而记录. 为了捕捉物体记录中的感官变化，我们系统地改变每个物体的视角、照明角度和照明颜色，并额外捕捉宽基线立体图像. 我们记录了每个物体的一百多张图像，为该系列收集了总共 110,250 张图像.  （格式：png）
18. [Annotated face, hand, cardiac & meat images](http://www.imm.dtu.dk/~aam/)  - 大多数图像和注释由使用 AAM-API 的各种 ASM/AAM 分析进行补充.  （格式：bmp、asf）
19. [Image Analysis and Computer Graphics](http://www.imm.dtu.dk/image/)  
21. [Brown University Stimuli](http://www.cog.brown.edu/~tarr/stimuli.html)  - 各种数据集，包括 geons、对象和“greebles”. 适用于测试识别算法.  （格式：图片）
22. [CAVIAR video sequences of mall and public space behavior](http://homepages.inf.ed.ac.uk/rbf/CAVIARDATA1/) - 90 个人类活动序列中的 90K 视频帧，带有检测和行为分类的 XML ground truth（格式：MPEG2 和 JPEG）
23. [Machine Vision Unit](http://www.ipab.inf.ed.ac.uk/mvu/)
25. [CCITT Fax standard images](http://www.cs.waikato.ac.nz/~singlis/ccitt.html) - 8 张图片（格式：gif）
26. [CMU CIL's Stereo Data with Ground Truth](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/cil-ster.html) - 3 组 11 张图像，包括带光谱辐射的彩色 tiff 图像（格式：gif、tiff）
27. [CMU PIE Database](http://www.ri.cmu.edu/projects/project_418.html) - 包含 68 个人在 13 种姿势、43 种照明条件和 4 种不同表情下捕获的 41,368 张人脸图像的数据库.
28. [CMU VASC Image Database](http://www.ius.cs.cmu.edu/idb/) - 图像、序列、立体对（数千张图像）（格式：Sun Rasterimage）
29. [Caltech Image Database](http://www.vision.caltech.edu/html-files/archive.html)  - 大约 20 张图片 - 大部分是小物体和玩具的俯视图.  （格式：GIF）
30. [Columbia-Utrecht Reflectance and Texture Database](http://www.cs.columbia.edu/CAVE/curet/)  - 超过 60 个 3D 纹理样本的纹理和反射率测量，使用超过 200 种不同的观察和照明方向组合进行观察.  （格式：bmp）
31. [Computational Colour Constancy Data](http://www.cs.sfu.ca/~colour/data/index.html)  - 面向计算颜色恒常性的数据集，但通常对计算机视觉有用. 它包括合成数据、相机传感器数据和 700 多张图像.  （格式：tiff）
32. [Computational Vision Lab](http://www.cs.sfu.ca/~colour/)
34. [Content-based image retrieval database](http://www.cs.washington.edu/research/imagedatabase/groundtruth/)  - 11 组彩色图像，用于测试基于内容的检索算法. 大多数集合都有一个描述文件，其中包含每个图像中的对象名称.  (格式: jpg)
35. [Efficient Content-based Retrieval Group](http://www.cs.washington.edu/research/imagedatabase/)
37. [Densely Sampled View Spheres](http://ls7-www.cs.uni-dortmund.de/~peters/pages/research/modeladaptsys/modeladaptsys_vba_rov.html)  - 密集采样的视域 - 两个玩具对象的视域的上半部分，每个对象有 2500 张图像.  （格式：tiff）
38. [Computer Science VII (Graphical Systems)](http://ls7-www.cs.uni-dortmund.de/)
40. [Digital Embryos](https://web-beta.archive.org/web/20011216051535/vision.psych.umn.edu/www/kersten-lab/demos/digitalembryo.html)  - 数字胚胎是可用于开发和测试对象识别系统的新对象. 它们具有有机外观.  （格式：可根据要求提供各种格式）
41. [Univerity of Minnesota Vision Lab](http://vision.psych.umn.edu/users/kersten//kersten-lab/kersten-lab.html) 
42. [El Salvador Atlas of Gastrointestinal VideoEndoscopy](http://www.gastrointestinalatlas.com)  - 从胃肠视频内窥镜检查中获取的高分辨率研究图像和视频.  （格式：jpg、mpg、gif）
43. [FG-NET Facial Aging Database](http://sting.cycollege.ac.cy/~alanitis/fgnetaging/index.htm)  - 数据库包含 1002 张不同年龄段的人脸图像.  (格式: jpg)
44. [FVC2000 Fingerprint Databases](http://bias.csr.unibo.it/fvc2000/)  - FVC2000 是第一届国际指纹验证算法竞赛. 四个指纹数据库构成了FVC2000 benchmark（共3520个指纹）.
45. [Biometric Systems Lab](http://biolab.csr.unibo.it/home.asp) - 博洛尼亚大学
46. [Face and Gesture images and image sequences](http://www.fg-net.org) - 几个面部和手势的图像数据集，这些图像数据集是为基准测试注释的基本事实
47. [German Fingerspelling Database](http://www-i6.informatik.rwth-aachen.de/~dreuw/database.html)  - 该数据库包含 35 个手势，由 1400 个图像序列组成，其中包含在非均匀日光照明条件下记录的 20 个不同人的手势.  (格式: mpg,jpg)  
48. [Language Processing and Pattern Recognition](http://www-i6.informatik.rwth-aachen.de/)
50. [Groningen Natural Image Database](http://hlab.phys.rug.nl/archive.html) - 4000+ 1536x1024（16 位）校准户外图像（格式：自制软件）
51. [ICG Testhouse sequence](http://www.icg.tu-graz.ac.at/~schindler/Data) - 2 个来自不同观看高度的转盘序列，每个序列 36 张图像，分辨率 1000x750，彩色（格式：PPM）
52. [Institute of Computer Graphics and Vision](http://www.icg.tu-graz.ac.at)
54. [IEN Image Library](http://www.ien.it/is/vislib/) - 1000 多张图像，主要是室外序列（格式：原始、ppm）  
55. [INRIA's Syntim images database](http://www-rocq.inria.fr/~tarel/syntim/images.html) - 15 幅简单物体的彩色图像（格式：gif）
56. [INRIA](http://www.inria.fr/)
57. [INRIA's Syntim stereo databases](http://www-rocq.inria.fr/~tarel/syntim/paires.html) - 34 个经过校准的彩色立体对（格式：gif）
58. [Image Analysis Laboratory](http://www.ece.ncsu.edu/imaging/Archives/ImageDataBase/index.html)  - 从各种成像方式获得的图像——原始 CFA 图像、范围图像和大量“医学图像”.  （格式：自制软件）
59. [Image Analysis Laboratory](http://www.ece.ncsu.edu/imaging)
61. [Image Database](http://www.prip.tuwien.ac.at/prip/image.html) - 包含一些纹理的图像数据库  
62. [JAFFE Facial Expression Image Database](http://www.mis.atr.co.jp/~mlyons/jaffe.html) - The JAFFE database consists of 213 images of Japanese female subjects posing 6 basic facial expressions as well as a neutral pose. Ratings on emotion adjectives are also available, free of charge, for research purposes. (Formats: TIFF Grayscale images.)
63. [ATR Research, Kyoto, Japan](http://www.mic.atr.co.jp/)
64. [JISCT Stereo Evaluation](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.vislist.com/IMAGERY/JISCT/)  - 44 个图像对. 这些数据已用于立体分析的评估，如 1993 年 4 月 ARPA 图像理解研讨会论文“The JISCT Stereo Evaluation”中所述，RCBolles、HHBaker 和 MJHannah，263--274（格式：SSI）
65. [MIT Vision Texture](https://vismod.media.mit.edu/vismod/imagery/VisionTexture/vistex.html) - 图像存档（100 多张图像）（格式：ppm）
66. [MIT face images and more](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://whitechapel.media.mit.edu/pub/images) - hundreds of images (Formats: homebrew)
67. [Machine Vision](http://vision.cse.psu.edu/book/testbed/images/) - 图片来自 Jain、Kasturi、Schunck 的教科书（20 多张图片）（格式：GIF TIFF）
68. [Mammography Image Databases](http://marathon.csee.usf.edu/Mammography/Database.html)  - 100 张或更多带有基本事实的乳房 X 线照片图像. 可根据要求提供其他图像，并提供了到其他几个乳腺 X 线摄影数据库的链接.  （格式：自制软件）
69. [https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.cps.msu.edu/pub/prip](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.cps.msu.edu/pub/prip) - 许多图像（格式：未知）
70. [Middlebury Stereo Data Sets with Ground Truth](http://www.middlebury.edu/stereo/data.html)  - 包含平面区域的场景的六个多帧立体数据集. 每个数据集包含 9 个彩色图像和亚像素精度的地面实况数据.  （格式：ppm）
71. [Middlebury Stereo Vision Research Page](http://www.middlebury.edu/stereo) - 明德学院
72. [Modis Airborne simulator, Gallery and data set](http://ltpwww.gsfc.nasa.gov/MODIS/MAS/) - High Altitude Imagery from around the world for environmental modeling in support of NASA EOS program (Formats: JPG and HDF)
73. [NIST Fingerprint and handwriting](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://sequoyah.ncsl.nist.gov/pub/databases/data) - 数据集 - 数千张图片（格式：未知）
74. [NIST Fingerprint data](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.cs.columbia.edu/jpeg/other/uuencoded) - 压缩的多部分 uuencoded tar 文件
75. [NLM HyperDoc Visible Human Project](http://www.nlm.nih.gov/research/visible/visible_human.html) - 彩色、CAT 和 MRI 图像样本 - 超过 30 张图像（格式：jpeg）
76. [National Design Repository](http://www.designrepository.org)  - 超过 55,000 个 3D CAD 和（大部分）机械/机加工工程设计的实体模型.  （格式：gif、vrml、wrl、stp、sat） 
77. [Geometric & Intelligent Computing Laboratory](http://gicl.mcs.drexel.edu)
79. [OSU (MSU) 3D Object Model Database](http://eewww.eng.ohio-state.edu/~flynn/3DDB/Models/) - 数年来收集的几组 3D 对象模型，用于对象识别研究（格式：自制软件、vrml）
80. [OSU (MSU/WSU) Range Image Database](http://eewww.eng.ohio-state.edu/~flynn/3DDB/RID/) - 数以百计的真实和合成图像（格式：gif、自制软件）
81. [OSU/SAMPL Database: Range Images, 3D Models, Stills, Motion Sequences](http://sampl.eng.ohio-state.edu/~sampl/database.htm) - 超过 1000 个范围图像、3D 对象模型、静止图像和运动序列（格式：gif、ppm、vrml、自制软件）
82. [Signal Analysis and Machine Perception Laboratory](http://sampl.eng.ohio-state.edu)
84. [Otago Optical Flow Evaluation Sequences](http://www.cs.otago.ac.nz/research/vision/Research/OpticalFlow/opticalflow.html)  - 具有机器可读地面真实光流场的合成和真实序列，以及为新序列生成地面真实的工具.  （格式：ppm、tif、自制软件）
85. [Vision Research Group](http://www.cs.otago.ac.nz/research/vision/index.html)
87. [https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.limsi.fr/pub/quenot/opflow/testdata/piv/](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.limsi.fr/pub/quenot/opflow/testdata/piv/)  - 用于测试粒子图像测速应用程序的真实和合成图像序列. 这些图像可用于光流和图像匹配算法的测试.  (格式: pgm (raw))
88. [LIMSI-CNRS/CHM/IMM/vision](http://www.limsi.fr/Recherche/IMM/PageIMM.html)
89. [LIMSI-CNRS](http://www.limsi.fr/)
90. [Photometric 3D Surface Texture Database](http://www.taurusstudio.net/research/pmtexdb/index.htm)  - 这是第一个提供完整真实表面旋转和注册光度立体数据（30 个纹理，1680 个图像）的 3D 纹理数据库.  （格式：TIFF）
91. [SEQUENCES FOR OPTICAL FLOW ANALYSIS (SOFA)](http://www.cee.hw.ac.uk/~mtc/sofa)  - 9 个合成序列，专为测试运动分析应用程序而设计，包括运动和相机参数的完整地面实况.  （格式：gif）
92. [Computer Vision Group](http://www.cee.hw.ac.uk/~mtc/research.html)
94. [Sequences for Flow Based Reconstruction](http://www.nada.kth.se/~zucch/CAMERA/PUB/seq.html) - 用于测试运动算法结构的合成序列（格式：pgm）
95. [Stereo Images with Ground Truth Disparity and Occlusion](http://www-dbv.cs.uni-bonn.de/stereo_data/)  - 一小组走廊的合成图像，添加了不同数量的噪音. 使用这些图像来对您的立体算法进行基准测试.  （格式：raw、viff (khoros) 或 tiff）
96. [Stuttgart Range Image Database](http://range.informatik.uni-stuttgart.de) - 从网络上提供的高分辨率多边形模型中获取的合成范围图像集合（格式：自制软件）
97. [Department Image Understanding](http://www.informatik.uni-stuttgart.de/ipvr/bv/bv_home_engl.html)
99. [The AR Face Database](http://www2.ece.ohio-state.edu/~aleix/ARdatabase.html)  - 包含 4,000 多张彩色图像，对应 126 个人脸（70 名男性和 56 名女性）. 具有面部表情、照明和遮挡变化的正面视图.  （格式：RAW（RGB 24 位））
100. [Purdue Robot Vision Lab](http://rvl.www.ecn.purdue.edu/RVL/)
101. [The MIT-CSAIL Database of Objects and Scenes](http://web.mit.edu/torralba/www/database.html)  - 用于测试多类对象检测和场景识别算法的数据库. 超过 72,000 张图像，带有 2873 个带注释的帧. 超过 50 个带注释的对象类.  (格式: jpg)
102. [The RVL SPEC-DB (SPECularity DataBase)](http://rvl1.ecn.purdue.edu/RVL/specularity_database/)  - 在三种不同照明条件（漫射/环境/定向）下拍摄的 100 个物体的 300 多张真实图像的集合.  -- 使用这些图像来测试用于检测和补偿彩色图像中的镜面高光的算法.  （格式：TIFF）
103. [Robot Vision Laboratory](http://rvl1.ecn.purdue.edu/RVL/)
105. [The Xm2vts database](http://xm2vtsdb.ee.surrey.ac.uk)  - XM2VTSDB 包含 295 人在四个月内拍摄的四段数字录音. 该数据库包含人脸的图像和视频数据.
106. [Centre for Vision, Speech and Signal Processing](http://www.ee.surrey.ac.uk/Research/CVSSP)
107. [Traffic Image Sequences and 'Marbled Block' Sequence](http://i21www.ira.uka.de/image_sequences) - 数千帧数字化交通图像序列以及“大理石块”序列（灰度图像）（格式：GIF）
108. [IAKS/KOGS](http://i21www.ira.uka.de)
110. [U Bern Face images](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.iam.unibe.ch/pub/Images/FaceImages) - 数百张图片（格式：Sun 光栅文件）
111. [U Michigan textures](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://freebie.engin.umich.edu/pub/misc/textures) （格式：压缩原始）
112. [U Oulu wood and knots database](http://www.ee.oulu.fi/~olli/Projects/Lumber.Grading.html) - 包括分类 - 1000 多张彩色图像（格式：ppm）
113. [UCID - an Uncompressed Colour Image Database](http://vision.doc.ntu.ac.uk/datasets/UCID/ucid.html)  - 具有预定义基本事实的图像检索基准数据库.  （格式：tiff）
115. [UMass Vision Image Archive](http://vis-www.cs.umass.edu/~vislib/)  - 包含航空、空间、立体、医学图像等的大型图像数据库.  （格式：自制软件）
116. [UNC's 3D image database](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://sunsite.unc.edu/pub/academic/computer-science/virtual-reality/3d) - 许多图像（格式：GIF）
117. [USF Range Image Data with Segmentation Ground Truth](http://marathon.csee.usf.edu/range/seg-comp/SegComp.html) - 80 个图像集（格式：太阳光栅图像）
118. [University of Oulu Physics-based Face Database](http://www.ee.oulu.fi/research/imag/color/pbfd.html) - 包含不同光源和相机校准条件下的面部彩色图像以及每个人的皮肤光谱反射测量值.
119. [Machine Vision and Media Processing Unit](http://www.ee.oulu.fi/mvmp/)
121. [University of Oulu Texture Database](http://www.outex.oulu.fi)  - 包含 320 个表面纹理的数据库，每个纹理都是在三种光源、六种空间分辨率和九种旋转角度下捕获的. 还提供了一组测试套件，以便可以以标准方式测试纹理分割、分类和检索算法.  （格式：bmp、ras、xv）
122. [Machine Vision Group](http://www.ee.oulu.fi/mvg)
124. [Usenix face database](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.uu.net/published/usenix/faces) - 来自许多不同站点的数千张面部图像（大约 994 张）
125. [View Sphere Database](http://www-prima.inrialpes.fr/Prima/hall/view_sphere.html)  - 从许多不同的角度看到的 8 个物体的图像. 使用具有 172 个图像/球体的测地线对视图球体进行采样. 有两套用于训练和测试.  （格式：ppm）
126. [PRIMA, GRAVIR](http://www-prima.inrialpes.fr/Prima/)
127. [Vision-list Imagery Archive](https://github.com/ChristosChristofidis/awesome-deep-learning/blob/master/ftp://ftp.vislist.com/IMAGERY/) - 许多图像，多种格式
128. [Wiry Object Recognition Database](http://www.cs.cmu.edu/~owenc/word.htm)  - 数以千计的手推车、梯子、凳子、自行车、椅子和杂乱场景的图像，带有边缘和区域的真实标签.  (格式: jpg)
129. [3D Vision Group](http://www.cs.cmu.edu/0.000000E+003dvision/)
131. [Yale Face Database](http://cvc.yale.edu/projects/yalefaces/yalefaces.html) - 165 张图像（15 个人），具有不同的光照、表情和遮挡配置.
132. [Yale Face Database B](http://cvc.yale.edu/projects/yalefacesB/yalefacesB.html)  - 在 576 个观察条件（9 个姿势 x 64 个照明条件）下看到的 10 个对象的 5760 张单光源图像.  （格式：PGM）
133. [Center for Computational Vision and Control](http://cvc.yale.edu/)
134. [DeepMind QA Corpus](https://github.com/deepmind/rc-data)  - 来自 CNN 和 DailyMail 的文本 QA 语料库. 总共超过 300K 个文档. [Paper](http://arxiv.org/abs/1506.03340) 以供参考.
135. [YouTube-8M Dataset](https://research.google.com/youtube8m/) - YouTube-8M 是一个大规模标记视频数据集，由 800 万个 YouTube 视频 ID 和来自 4800 个视觉实体的不同词汇表的相关标签组成.
136. [Open Images dataset](https://github.com/openimages/dataset) - Open Images 是一个包含约 900 万个图像 URL 的数据集，这些图像已用跨越 6000 多个类别的标签进行了注释.
137. [Visual Object Classes Challenge 2012 (VOC2012)](http://host.robots.ox.ac.uk/pascal/VOC/voc2012/index.html#devkit) - VOC2012 数据集包含 12k 图像和 20 个用于对象检测和分割的注释类.
138. [Fashion-MNIST](https://github.com/zalandoresearch/fashion-mnist)  - MNIST 类时尚产品数据集，由 60,000 个示例的训练集和 10,000 个示例的测试集组成. 每个示例都是一个 28x28 的灰度图像，与来自 10 个类别的标签相关联.
139. [Large-scale Fashion (DeepFashion) Database](http://mmlab.ie.cuhk.edu.hk/projects/DeepFashion.html)  - 包含超过 800,000 张不同的时尚图片. 此数据集中的每张图像都标有 50 个类别、1,000 个描述性属性、边界框和服装标志
140. [FakeNewsCorpus](https://github.com/several27/FakeNewsCorpus) - 包含约 1000 万篇使用分类的新闻文章 [opensources.co](http://opensources.co) 类型
141. [LLVIP](https://github.com/bupt-ai-cz/LLVIP) - 用于低光视觉研究的 15488 张可见红外配对图像（30976 张图像）， [Project_Page](https://bupt-ai-cz.github.io/LLVIP/)
142. [MSDA](https://github.com/bupt-ai-cz/Meta-SelfLearning) - 来自 5 个不同领域的超过 500 万张图像用于多源 ocr/文本识别 DA 研究， [Project_Page](https://bupt-ai-cz.github.io/Meta-SelfLearning/)
143. [SANAD: Single-Label Arabic News Articles Dataset for Automatic Text Categorization](https://data.mendeley.com/datasets/57zpx667y9/2)  - SANAD 数据集是大量阿拉伯语新闻文章的集合，可用于不同的阿拉伯语 NLP 任务，例如文本分类和词嵌入. 这些文章是使用专门为三个流行新闻网站编写的 Python 脚本收集的：AlKhaleej、AlArabiya 和 Akhbarona. 
144. [Referit3D](https://referit3d.github.io)  - 两个大规模和互补的视觉语言数据集（又名 Nr3D 和 Sr3D），用于识别 ScanNet 场景中的细粒度 3D 对象.  Nr3D 包含 41.5K 自然、自由形式的话语，而 Sr3d 包含 83.5K 基于模板的话语.
145. [SQuAD](https://rajpurkar.github.io/SQuAD-explorer/) - 斯坦福发布了约 100,000 个英语 QA 对和约 50,000 个无法回答的问题
146. [FQuAD](https://fquad.illuin.tech/) - Illuin Technology 发布了约 25,000 个法语 QA 对
147. [GermanQuAD and GermanDPR](https://www.deepset.ai/germanquad) - deepset 发布了约 14,000 个德国 QA 对
148. [SberQuAD](https://github.com/annnyway/QA-for-Russian) - Sberbank 发布了约 90,000 个俄罗斯 QA 对
149. [ArtEmis](http://artemisdataset.org/) - 包含 80,000 幅 WikiArt 艺术作品的 450K 情绪反应情感注释和语言解释.

### Conferences

1. [CVPR - IEEE Conference on Computer Vision and Pattern Recognition](http://cvpr2018.thecvf.com)
2. [AAMAS - International Joint Conference on Autonomous Agents and Multiagent Systems](http://celweb.vuse.vanderbilt.edu/aamas18/)
3. [IJCAI - 	International Joint Conference on Artificial Intelligence](https://www.ijcai-18.org/)
4. [ICML - 	International Conference on Machine Learning](https://icml.cc)
5. [ECML - European Conference on Machine Learning](http://www.ecmlpkdd2018.org)
6. [KDD - Knowledge Discovery and Data Mining](http://www.kdd.org/kdd2018/)
7. [NIPS - Neural Information Processing Systems](https://nips.cc/Conferences/2018)
8. [O'Reilly AI Conference - 	O'Reilly Artificial Intelligence Conference](https://conferences.oreilly.com/artificial-intelligence/ai-ny)
9. [ICDM - International Conference on Data Mining](https://www.waset.org/conference/2018/07/istanbul/ICDM)
10. [ICCV - International Conference on Computer Vision](http://iccv2017.thecvf.com)
11. [AAAI - Association for the Advancement of Artificial Intelligence](https://www.aaai.org)
12. [MAIS - Montreal AI Symposium](https://montrealaisymposium.wordpress.com/)

### Frameworks

1.  [Caffe](http://caffe.berkeleyvision.org/)  
2.  [Torch7](http://torch.ch/)
3.  [Theano](http://deeplearning.net/software/theano/)
4.  [cuda-convnet](https://code.google.com/p/cuda-convnet2/)
5.  [convetjs](https://github.com/karpathy/convnetjs)
5.  [Ccv](http://libccv.org/doc/doc-convnet/)
6.  [NuPIC](http://numenta.org/nupic.html)
7.  [DeepLearning4J](http://deeplearning4j.org/)
8.  [Brain](https://github.com/harthur/brain)
9.  [DeepLearnToolbox](https://github.com/rasmusbergpalm/DeepLearnToolbox)
10.  [Deepnet](https://github.com/nitishsrivastava/deepnet)
11.  [Deeppy](https://github.com/andersbll/deeppy)
12.  [JavaNN](https://github.com/ivan-vasilev/neuralnetworks)
13.  [hebel](https://github.com/hannes-brt/hebel)
14.  [Mocha.jl](https://github.com/pluskid/Mocha.jl)
15.  [OpenDL](https://github.com/guoding83128/OpenDL)
16.  [cuDNN](https://developer.nvidia.com/cuDNN)
17.  [MGL](http://melisgl.github.io/mgl-pax-world/mgl-manual.html)
18.  [Knet.jl](https://github.com/denizyuret/Knet.jl)
19.  [Nvidia DIGITS - a web app based on Caffe](https://github.com/NVIDIA/DIGITS)
20.  [Neon - Python based Deep Learning Framework](https://github.com/NervanaSystems/neon)
21.  [Keras - Theano based Deep Learning Library](http://keras.io)
22.  [Chainer - A flexible framework of neural networks for deep learning](http://chainer.org/)
23.  [RNNLM Toolkit](http://rnnlm.org/)
24.  [RNNLIB - A recurrent neural network library](http://sourceforge.net/p/rnnl/wiki/Home/)
25.  [char-rnn](https://github.com/karpathy/char-rnn)
26.  [MatConvNet: CNNs for MATLAB](https://github.com/vlfeat/matconvnet)
27.  [Minerva - a fast and flexible tool for deep learning on multi-GPU](https://github.com/dmlc/minerva)
28.  [Brainstorm - Fast, flexible and fun neural networks.](https://github.com/IDSIA/brainstorm)
29.  [Tensorflow - Open source software library for numerical computation using data flow graphs](https://github.com/tensorflow/tensorflow)
30.  [DMTK - Microsoft Distributed Machine Learning Tookit](https://github.com/Microsoft/DMTK)
31.  [Scikit Flow - Simplified interface for TensorFlow (mimicking Scikit Learn)](https://github.com/google/skflow)
32.  [MXnet - Lightweight, Portable, Flexible Distributed/Mobile Deep Learning framework](https://github.com/apache/incubator-mxnet)
33.  [Veles - Samsung Distributed machine learning platform](https://github.com/Samsung/veles)
34.  [Marvin - A Minimalist GPU-only N-Dimensional ConvNets Framework](https://github.com/PrincetonVision/marvin)
35.  [Apache SINGA - A General Distributed Deep Learning Platform](http://singa.incubator.apache.org/)
36.  [DSSTNE - Amazon's library for building Deep Learning models](https://github.com/amznlabs/amazon-dsstne)
37.  [SyntaxNet - Google's syntactic parser - A TensorFlow dependency library](https://github.com/tensorflow/models/tree/master/syntaxnet)
38.  [mlpack - A scalable Machine Learning library](http://mlpack.org/)
39.  [Torchnet - Torch based Deep Learning Library](https://github.com/torchnet/torchnet)
40.  [Paddle - PArallel Distributed Deep LEarning by Baidu](https://github.com/baidu/paddle)
41.  [NeuPy - Theano based Python library for ANN and Deep Learning](http://neupy.com)
42.  [Lasagne - a lightweight library to build and train neural networks in Theano](https://github.com/Lasagne/Lasagne)
43.  [nolearn - wrappers and abstractions around existing neural network libraries, most notably Lasagne](https://github.com/dnouri/nolearn)
44.  [Sonnet - a library for constructing neural networks by Google's DeepMind](https://github.com/deepmind/sonnet)
45.  [PyTorch - Tensors and Dynamic neural networks in Python with strong GPU acceleration](https://github.com/pytorch/pytorch)
46.  [CNTK - Microsoft Cognitive Toolkit](https://github.com/Microsoft/CNTK)
47.  [Serpent.AI - Game agent framework: Use any video game as a deep learning sandbox](https://github.com/SerpentAI/SerpentAI)
48.  [Caffe2 - A New Lightweight, Modular, and Scalable Deep Learning Framework](https://github.com/caffe2/caffe2)
49.  [deeplearn.js - Hardware-accelerated deep learning and linear algebra (NumPy) library for the web](https://github.com/PAIR-code/deeplearnjs)
50.  [TVM - End to End Deep Learning Compiler Stack for CPUs, GPUs and specialized accelerators](https://tvm.ai/)
51.  [Coach - Reinforcement Learning Coach by Intel® AI Lab](https://github.com/NervanaSystems/coach)
52.  [albumentations - A fast and framework agnostic image augmentation library](https://github.com/albu/albumentations)
53.  [Neuraxle - A general-purpose ML pipelining framework](https://github.com/Neuraxio/Neuraxle)
54.  [Catalyst: High-level utils for PyTorch DL & RL research. It was developed with a focus on reproducibility, fast experimentation and code/ideas reusing](https://github.com/catalyst-team/catalyst)
55.  [garage - A toolkit for reproducible reinforcement learning research](https://github.com/rlworkgroup/garage)
56.  [Detecto - Train and run object detection models with 5-10 lines of code](https://github.com/alankbi/detecto)
57.  [Karate Club - An unsupervised machine learning library for graph structured data](https://github.com/benedekrozemberczki/karateclub)
58.  [Synapses - A lightweight library for neural networks that runs anywhere](https://github.com/mrdimosthenis/Synapses)
59.  [TensorForce - A TensorFlow library for applied reinforcement learning](https://github.com/reinforceio/tensorforce)
60.  [Hopsworks - A Feature Store for ML and Data-Intensive AI](https://github.com/logicalclocks/hopsworks)
61.  [Feast - A Feature Store for ML for GCP by Gojek/Google](https://github.com/gojek/feast)
62.  [PyTorch Geometric Temporal - Representation learning on dynamic graphs](https://github.com/gojek/feast)
63.  [lightly - A computer vision framework for self-supervised learning](https://github.com/lightly-ai/lightly)
64.  [Trax — Deep Learning with Clear Code and Speed](https://github.com/google/trax)
65.  [Flax - a neural network ecosystem for JAX that is designed for flexibility](https://github.com/google/flax)
66.  [QuickVision](https://github.com/Quick-AI/quickvision)
67.  [Colossal-AI - An Integrated Large-scale Model Training System with Efficient Parallelization Techniques](https://github.com/hpcaitech/ColossalAI)
68.  [haystack: an open-source neural search framework](https://haystack.deepset.ai/docs/intromd)
69.  [Maze](https://github.com/enlite-ai/maze) - 面向应用的深度强化学习框架解决现实世界的决策问题.
70.  [InsNet - A neural network library for building instance-dependent NLP models with padding-free dynamic batching](https://github.com/chncwang/InsNet)

### Tools

1.  [Nebullvm](https://github.com/nebuly-ai/nebullvm) - 易于使用的库，可利用多个深度学习编译器来促进深度学习推理.
2.  [Netron](https://github.com/lutzroeder/netron) - 深度学习和机器学习模型的可视化工具
2.  [Jupyter Notebook](http://jupyter.org) - 用于交互式计算的基于网络的笔记本环境
3.  [TensorBoard](https://github.com/tensorflow/tensorboard) - TensorFlow 的可视化工具包
4.  [Visual Studio Tools for AI](https://www.microsoft.com/en-us/research/project/visual-studio-code-tools-ai/) - 开发、调试和部署深度学习和人工智能解决方案
5.  [TensorWatch](https://github.com/microsoft/tensorwatch) - 深度学习的调试和可视化
6. [ML Workspace](https://github.com/ml-tooling/ml-workspace) - 用于机器学习和数据科学的多合一基于 Web 的 IDE.
7.  [dowel](https://github.com/rlworkgroup/dowel)  - 用于机器学习研究的小记录器. 只需一次调用 logger.log() 即可将任何对象记录到控制台、CSV、TensorBoard、文本日志文件等
8.  [Neptune](https://neptune.ai/) - 用于实验跟踪和结果可视化的轻量级工具. 
9.  [CatalyzeX](https://chrome.google.com/webstore/detail/code-finder-for-research/aikkeehnlfpamidigaffhfmgbkdeheil) - 浏览器扩展（[Chrome](https://chrome.google.com/webstore/detail/code-finder-for-research/aikkeehnlfpamidigaffhfmgbkdeheil) 和 [Firefox](https://addons.mozilla.org/en-US/firefox/addon/code-finder-catalyzex/)) that automatically finds 和 links to code implementations for ML papers anywhere online: Google, Twitter, Arxiv, Scholar, etc.
10. [Determined](https://github.com/determined-ai/determined) - 深度学习训练平台，集成了对分布式训练、超参数调整、智能 GPU 调度、实验跟踪和模型注册的支持.
11. [DAGsHub](https://dagshub.com/) - 开源机器学习社区平台——管理实验、数据和模型并轻松创建协作机器学习项目.
12. [hub](https://github.com/activeloopai/Hub)  - activeloop.ai 针对 TensorFlow/PyTorch 的最快非结构化数据集管理. 流和版本控制数据. 将大数据转换为云上的单个类似 numpy 的数组，可在任何机器上访问.
13. [DVC](https://dvc.org/)  - DVC 旨在使 ML 模型可共享和可复制. 它旨在处理大型文件、数据集、机器学习模型、指标和代码.
14. [CML](https://cml.dev/) - CML 帮助您将您最喜欢的 DevOps 工具用于机器学习.
15. [MLEM](https://mlem.ai/)  - MLEM 是一种可以轻松打包、部署和服务机器学习模型的工具. 无缝支持实时服务、批处理等多种场景.


### Miscellaneous

1.  [Caffe Webinar](http://on-demand-gtc.gputechconf.com/gtcnew/on-demand-gtc.php?searchByKeyword=shelhamer&amp;searchItems=&amp;sessionTopic=&amp;sessionEvent=4&amp;sessionYear=2014&amp;sessionFormat=&amp;submit=&amp;select=+)
2.  [100 Best Github Resources in Github for DL](http://meta-guide.com/software-meta-guide/100-best-github-deep-learning/)
3.  [Word2Vec](https://code.google.com/p/word2vec/)
4.  [Caffe DockerFile](https://github.com/tleyden/docker/tree/master/caffe)
5.  [TorontoDeepLEarning convnet](https://github.com/TorontoDeepLearning/convnet)
6.  [gfx.js](https://github.com/clementfarabet/gfx.js)
7.  [Torch7 Cheat sheet](https://github.com/torch/torch7/wiki/Cheatsheet)
8. [Misc from MIT's 'Advanced Natural Language Processing' course](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-864-advanced-natural-language-processing-fall-2005/)
9. [Misc from MIT's 'Machine Learning' course](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-867-machine-learning-fall-2006/lecture-notes/)
10. [Misc from MIT's 'Networks for Learning: Regression and Classification' course](http://ocw.mit.edu/courses/brain-and-cognitive-sciences/9-520-a-networks-for-learning-regression-and-classification-spring-2001/)
11. [Misc from MIT's 'Neural Coding and Perception of Sound' course](http://ocw.mit.edu/courses/health-sciences-and-technology/hst-723j-neural-coding-and-perception-of-sound-spring-2005/index.htm)
12. [Implementing a Distributed Deep Learning Network over Spark](http://www.datasciencecentral.com/profiles/blogs/implementing-a-distributed-deep-learning-network-over-spark)
13. [A chess AI that learns to play chess using deep learning.](https://github.com/erikbern/deep-pink)
14. [Reproducing the results of "Playing Atari with Deep Reinforcement Learning" by DeepMind](https://github.com/kristjankorjus/Replicating-DeepMind)
15. [Wiki2Vec. Getting Word2vec vectors for entities and word from Wikipedia Dumps](https://github.com/idio/wiki2vec)
16. [The original code from the DeepMind article + tweaks](https://github.com/kuz/DeepMind-Atari-Deep-Q-Learner)
17. [Google deepdream - Neural Network art](https://github.com/google/deepdream)
18. [An efficient, batched LSTM.](https://gist.github.com/karpathy/587454dc0146a6ae21fc)
19. [A recurrent neural network designed to generate classical music.](https://github.com/hexahedria/biaxial-rnn-music-composition)
20. [Memory Networks Implementations - Facebook](https://github.com/facebook/MemNN)
21. [Face recognition with Google's FaceNet deep neural network.](https://github.com/cmusatyalab/openface)
22. [Basic digit recognition neural network](https://github.com/joeledenberg/DigitRecognition)
23. [Emotion Recognition API Demo - Microsoft](https://www.projectoxford.ai/demo/emotion#detection)
24. [Proof of concept for loading Caffe models in TensorFlow](https://github.com/ethereon/caffe-tensorflow)
25. [YOLO: Real-Time Object Detection](http://pjreddie.com/darknet/yolo/#webcam)
26. [YOLO: Practical Implementation using Python](https://www.analyticsvidhya.com/blog/2018/12/practical-guide-object-detection-yolo-framewor-python/)
27. [AlphaGo - A replication of DeepMind's 2016 Nature publication, "Mastering the game of Go with deep neural networks and tree search"](https://github.com/Rochester-NRT/AlphaGo)
28. [Machine Learning for Software Engineers](https://github.com/ZuzooVn/machine-learning-for-software-engineers)
29. [Machine Learning is Fun!](https://medium.com/@ageitgey/machine-learning-is-fun-80ea3ec3c471#.oa4rzez3g)
30. [Siraj Raval's Deep Learning tutorials](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A)
31. [Dockerface](https://github.com/natanielruiz/dockerface) - 易于安装和使用深度学习更快的 R-CNN 人脸检测，用于 docker 容器中的图像和视频.
32. [Awesome Deep Learning Music](https://github.com/ybayle/awesome-deep-learning-music) - 与应用于音乐的深度学习科学研究相关的精选文章列表
33. [Awesome Graph Embedding](https://github.com/benedekrozemberczki/awesome-graph-embedding) - 与图级图结构化数据的深度学习科学研究相关的精选文章列表.
34. [Awesome Network Embedding](https://github.com/chihming/awesome-network-embedding) - 与节点级别的图结构数据的深度学习科学研究相关的精选文章列表.
35. [Microsoft Recommenders](https://github.com/Microsoft/Recommenders) 包含用于构建推荐系统的示例、实用程序和最佳实践. 提供了几种最先进算法的实现，供您在自己的应用程序中自学和定制.
36. [The Unreasonable Effectiveness of Recurrent Neural Networks](http://karpathy.github.io/2015/05/21/rnn-effectiveness/) - Andrej Karpathy 关于使用 RNN 生成文本的博客文章.
37. [Ladder Network](https://github.com/divamgupta/ladder_network_keras) - 用于半监督学习的阶梯网络的 Keras 实现 
38. [toolbox: Curated list of ML libraries](https://github.com/amitness/toolbox)
39. [CNN Explainer](https://poloclub.github.io/cnn-explainer/)
40. [AI Expert Roadmap](https://github.com/AMAI-GmbH/AI-Expert-Roadmap) - 成为人工智能专家的路线图
41. [Awesome Drug Interactions, Synergy, and Polypharmacy Prediction](https://github.com/AstraZeneca/awesome-polipharmacy-side-effect-prediction/)

-----
### Contributing
有什么您认为很棒并且适合此列表的内容吗？ 随时发送一个 [pull request](https://github.com/ashara12/awesome-deeplearning/pulls).

-----
## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Christos Christofidis](https://linkedin.com/in/Christofidis) 已放弃该作品的所有版权和相关或邻接权.
