<div class="github-widget" data-repo="guillaume-chevalier/awesome-deep-learning-resources"></div>
## [Awesome Deep Learning Resources](https://github.com/guillaume-chevalier/Awesome-Deep-Learning-Resources) [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

这是我最喜欢的深度学习资源的粗略列表. 它对我学习如何进行深度学习很有用，我用它来重温主题或作为参考.
我 （[Guillaume Chevalier](https://github.com/guillaume-chevalier)) 已经建立了这个列表并仔细阅读了这里列出的所有内容.




<a name="trends" />

## Trends

这是历来 [Google Trends](https://www.google.ca/trends/explore?date=all&q=machine%20learning,deep%20learning,data%20science,computer%20programming)，从2004年至今，2017年9月：
<p align="center">
  <img src="https://raw.githubusercontent.com/guillaume-chevalier/awesome-deep-learning-resources/master/google_trends.png" width="792" height="424" />
</p>

您可能还想看看 Andrej Karpathy  [new post](https://medium.com/@karpathy/a-peek-at-trends-in-machine-learning-ab8a1085a106) 关于机器学习研究的趋势.

我相信深度学习是让计算机更像人类思考的关键，并且具有很大的潜力. 一些困难的自动化任务可以很容易地解决，而这在早期用经典算法是不可能实现的.

关于计算机科学硬件指数级进步的摩尔定律现在对 GPU 的影响比对 CPU 的影响更大，因为原子晶体管的尺寸存在物理限制. 我们正在转向并行架构
[[read more](https://www.quora.com/Does-Moores-law-apply-to-GPUs-Or-only-CPUs) ]. 深度学习通过使用 GPU 在底层利用并行架构. 最重要的是，深度学习算法可能会使用量子计算，并在未来应用于机器-大脑接口.

我发现智能和认知的关键是一个非常有趣的探索主题，但尚未得到很好的理解. 这些技术很有前途.


<a name="online-classes" />

## Online Classes

- **[DL&RNN Course](https://www.dl-rnn-course.neuraxio.com/start?utm_source=github_awesome) - 我创建了这门关于深度学习和递归神经网络的内容丰富的课程.**
- [Machine Learning by Andrew Ng on Coursera](https://www.coursera.org/learn/machine-learning) - 著名的入门级在线课程 [certificate](https://www.coursera.org/account/accomplishments/verify/DXPXHYFNGKG3) . 授课老师：Andrew Ng，斯坦福大学副教授； 百度首席科学家；  Coursera 董事长兼联合创始人.
- [Deep Learning Specialization by Andrew Ng on Coursera](https://www.coursera.org/specializations/deep-learning) - Andrew Ng 的新系列 5 门深度学习课程，现在使用 Python 而不是 Matlab/Octave，这导致了 [specialization certificate](https://www.coursera.org/account/accomplishments/specialization/U7VNC3ZD9YD8).
- [Deep Learning by Google](https://www.udacity.com/course/deep-learning--ud730) - 很好的中级到高级课程，涵盖高级深度学习概念，我发现一旦掌握了基础知识，它有助于发挥创造力.
- [Machine Learning for Trading by Georgia Tech](https://www.udacity.com/course/machine-learning-for-trading--ud501)  - 有趣的课程，用于获取应用于交易的机器学习基础知识以及一些人工智能和金融概念. 我特别喜欢关于 Q-Learning 的部分.
- [Neural networks class by Hugo Larochelle, Université de Sherbrooke](https://www.youtube.com/playlist?list=PL6Xpj9I5qXYEcOhn7TqghAJ6NAPrNmUBH) - Hugo Larochelle 免费在线提供有关神经网络的有趣课程，但我已经观看了其中一些视频.
- [GLO-4030/7030 Apprentissage par réseaux de neurones profonds](https://ulaval-damas.github.io/glo4030/)  - 这是拉瓦尔大学教授 Philippe Giguère 教授的课程. 我特别发现它对多头注意力机制的罕见可视化非常棒，可以在 [slide 28 of week 13's class](http://www2.ift.ulaval.ca/~pgiguere/cours/DeepLearning/09-Attention.pdf).
- [Deep Learning & Recurrent Neural Networks (DL&RNN)](https://www.neuraxio.com/en/time-series-solution) - 关于深度学习和递归神经网络主题的最丰富、最密集的加速课程（在末尾滚动）.

<a name="books" />

## Books

- [Clean Code](https://www.amazon.ca/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882)  - 回到你愚弄的基础！ 了解如何为您的职业打造整洁的代码. 这是迄今为止我读过的最好的书，即使这个列表与深度学习有关.
- [Clean Coder](https://www.amazon.ca/Clean-Coder-Conduct-Professional-Programmers/dp/0137081073)  - 了解如何成为一名专业的编码员以及如何与您的经理互动. 这对任何编码职业都很重要.
- [How to Create a Mind](https://www.amazon.com/How-Create-Mind-Thought-Revealed/dp/B009VSFXZ4)  - 音频版本很适合在通勤时收听. 这本书激励人们对思维进行逆向工程，并思考如何编写 AI 代码.
- [Neural Networks and Deep Learning](http://neuralnetworksanddeeplearning.com/index.html) - 这本书涵盖了神经网络和深度学习背后的许多核心概念.
- [Deep Learning - An MIT Press book](http://www.deeplearningbook.org/) - 然而在本书的中途，它包含了关于如何思考实际深度学习的令人满意的数学内容.
- [Some other books I have read](https://books.google.ca/books?hl=en&as_coll=4&num=100&uid=103409002069648430166&source=gbs_slider_cls_metadata_4_mylibrary_title) - 此处列出的一些书籍与深度学习的相关性较低，但在某种程度上仍与此列表相关.

<a name="posts-and-articles" />

## Posts and Articles

- [Predictions made by Ray Kurzweil](https://en.wikipedia.org/wiki/Predictions_made_by_Ray_Kurzweil) - 由 Ray Kurzweil 做出的中长期未来主义预测列表.
- [The Unreasonable Effectiveness of Recurrent Neural Networks](http://karpathy.github.io/2015/05/21/rnn-effectiveness/) - 必须阅读 Andrej Karpathy 的帖子 - 这就是促使我学习 RNN 的原因，它展示了它可以在最基本的 NLP 形式中实现什么.
- [Neural Networks, Manifolds, and Topology](http://colah.github.io/posts/2014-03-NN-Manifolds-Topology/) - 重新审视神经元如何映射信息.
- [Understanding LSTM Networks](http://colah.github.io/posts/2015-08-Understanding-LSTMs/) - 解释 LSTM 单元的内部工作原理，此外，它在结论中有有趣的链接.
- [Attention and Augmented Recurrent Neural Networks](http://distill.pub/2016/augmented-rnns/) - 对视觉动画很有趣，它是一个很好的注意力机制介绍示例.
- [Recommending music on Spotify with deep learning](http://benanne.github.io/2014/08/05/spotify-cnns.html) - 对音频进行聚类非常棒 - 由 Spotify 的实习生发布.
- [Announcing SyntaxNet: The World’s Most Accurate Parser Goes Open Source](https://research.googleblog.com/2016/05/announcing-syntaxnet-worlds-most.html) - Parsey McParseface 的诞生，一个神经语法树解析器.
- [Improving Inception and Image Classification in TensorFlow](https://research.googleblog.com/2016/08/improving-inception-and-image.html) - 非常有趣的 CNN 架构（例如：初始式卷积层在减少参数数量方面很有前途且高效）.
- [WaveNet: A Generative Model for Raw Audio](https://deepmind.com/blog/wavenet-generative-model-raw-audio/) - 逼真的会说话的机器：完美的语音生成.
- [François Chollet's Twitter](https://twitter.com/fchollet) - Keras 的作者 - 拥有有趣的 Twitter 帖子和创新想法.
- [Neuralink and the Brain’s Magical Future](http://waitbutwhy.com/2017/04/neuralink.html) - 关于大脑和脑机接口的未来的发人深省的文章.
- [Migrating to Git LFS for Developing Deep Learning Applications with Large Files](http://vooban.com/en/tips-articles-geek-stuff/migrating-to-git-lfs-for-developing-deep-learning-applications-with-large-files/) - 轻松管理私人 Git 项目中的大文件.
- [The future of deep learning](https://blog.keras.io/the-future-of-deep-learning.html) - François Chollet 对深度学习未来的看法.
- [Discover structure behind data with decision trees](http://vooban.com/en/tips-articles-geek-stuff/discover-structure-behind-data-with-decision-trees/) - 种植决策树并将其可视化，推断数据背后隐藏的逻辑.
- [Hyperopt tutorial for Optimizing Neural Networks’ Hyperparameters](http://vooban.com/en/tips-articles-geek-stuff/hyperopt-tutorial-for-optimizing-neural-networks-hyperparameters/) - 学会自动而不是手动减少超参数空间.
- [Estimating an Optimal Learning Rate For a Deep Neural Network](https://medium.com/@surmenok/estimating-optimal-learning-rate-for-a-deep-neural-network-ce32f2556ce0) - 在任何一次完整训练之前估计最佳学习率的巧妙技巧.
 - [The Annotated Transformer](http://nlp.seas.harvard.edu/2018/04/03/attention.html) - 有助于理解“Attention Is All You Need”(AIAYN) 论文. 
 - [The Illustrated Transformer](http://jalammar.github.io/illustrated-transformer/) - 也有助于理解“Attention Is All You Need”(AIAYN) 论文.
 - [Improving Language Understanding with Unsupervised Learning](https://blog.openai.com/language-unsupervised/) - 对大量语料库进行无监督预训练，跨越许多 NLP 任务的 SOTA.
 - [NLP's ImageNet moment has arrived](https://thegradient.pub/nlp-imagenet/) - 为 NLP 的 ImageNet 时刻欢呼. 
 - [The Illustrated BERT, ELMo, and co. (How NLP Cracked Transfer Learning)](https://jalammar.github.io/illustrated-bert/) - 了解用于 NLP 的 ImageNet 时刻的不同方法. 
 - [Uncle Bob's Principles Of OOD](http://butunclebob.com/ArticleS.UncleBob.PrinciplesOfOod) - 不仅 SOLID 原则是编写干净代码所必需的，而且众所周知的 REP、CCP、CRP、ADP、SDP 和 SAP 原则对于开发必须捆绑在不同的独立包中的大型软件也非常重要.
 - [Why do 87% of data science projects never make it into production?](https://venturebeat.com/2019/07/19/why-do-87-of-data-science-projects-never-make-it-into-production/) - 数据不容忽视，团队和数据科学家之间的沟通对于正确集成解决方案很重要.
 - [The real reason most ML projects fail](https://towardsdatascience.com/what-is-the-main-reason-most-ml-projects-fail-515d409a161f) - 专注于明确的业务目标，除非您拥有真正干净的代码，否则应避免算法转向，并能够知道您编写的代码何时“足够好”.
 - [SOLID Machine Learning](https://www.umaneo.com/post/the-solid-principles-applied-to-machine-learning) - 适用于机器学习的 SOLID 原则.
 
<a name="practical-resources" />

## Practical Resources

<a name="librairies-and-implementations" />

### Librairies and Implementations
- [Neuraxle, a framwework for machine learning pipelines](https://github.com/Neuraxio/Neuraxle) - 用于构建和部署机器学习项目的最佳框架，并且还与大多数框架兼容（例如：Scikit-Learn、TensorFlow、PyTorch、Keras 等）.
- [TensorFlow's GitHub repository](https://github.com/tensorflow/tensorflow) - 最著名的深度学习框架，包括高级和低级，同时保持灵活性.
- [skflow](https://github.com/tensorflow/skflow) - TensorFlow wrapper à la scikit-learn.
- [Keras](https://keras.io/) - Keras 是另一个像 TensorFlow 一样有趣的深度学习框架，它主要是高级的.
- [carpedm20's repositories](https://github.com/carpedm20) - 韩国人 Taehoon Kim（又名 carpedm20）实现了许多有趣的神经网络架构.
- [carpedm20/NTM-tensorflow](https://github.com/carpedm20/NTM-tensorflow) - 神经图灵机 TensorFlow 实现.
- [Deep learning for lazybones](http://oduerr.github.io/blog/2016/04/06/Deep-Learning_for_lazybones) - TensorFlow 中的迁移学习教程，用于从预训练的 CNN、AlexNet 2012 的高级嵌入中获取视觉.
- [LSTM for Human Activity Recognition (HAR)](https://github.com/guillaume-chevalier/LSTM-Human-Activity-Recognition) - 我的关于在时间序列上使用 LSTM 进行分类的教程.
- [Deep stacked residual bidirectional LSTMs for HAR](https://github.com/guillaume-chevalier/HAR-stacked-residual-bidir-LSTMs) - Improvements on the previous project.
- [Sequence to Sequence (seq2seq) Recurrent Neural Network (RNN) for Time Series Prediction](https://github.com/guillaume-chevalier/seq2seq-signal-prediction) - 我的关于如何预测数字时间序列的教程 - 可能是多通道的.
- [Hyperopt for a Keras CNN on CIFAR-100](https://github.com/guillaume-chevalier/Hyperopt-Keras-CNN-CIFAR-100) - 在 CIFAR-100 数据集上自动（元）优化神经网络（及其架构）.
- [ML / DL repositories I starred](https://github.com/guillaume-chevalier?direction=desc&page=1&q=machine+OR+deep+OR+learning+OR+rnn+OR+lstm+OR+cnn&sort=stars&tab=stars&utf8=%E2%9C%93) - GitHub 充满了不错的代码示例和项目.
- [Smoothly Blend Image Patches](https://github.com/guillaume-chevalier/Smoothly-Blend-Image-Patches) - 平滑的补丁合并 [semantic segmentation with a U-Net](https://vooban.com/en/tips-articles-geek-stuff/satellite-image-segmentation-workflow-with-u-net/).
- [Self Governing Neural Networks (SGNN): the Projection Layer](https://github.com/guillaume-chevalier/SGNN-Self-Governing-Neural-Networks-Projection-Layer) - 有了这个，您可以在深度学习模型中使用单词，而无需训练或加载嵌入.
- [Neuraxle](https://github.com/Neuraxio/Neuraxle) - Neuraxle 是一个机器学习 (ML) 库，用于构建整洁的管道，提供正确的抽象以简化 ML 应用程序的研究、开发和部署.
- [Clean Machine Learning, a Coding Kata](https://github.com/Neuraxio/Kata-Clean-Machine-Learning-From-Dirty-Code) - 通过练习学习用于以良好方式进行机器学习的良好设计模式.

<a name="some-datasets" />

### Some Datasets

这些是我发现开发模型似乎很有趣的资源.

- [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/datasets.html) - 机器学习的大量数据集.
- [Cornell Movie--Dialogs Corpus](http://www.cs.cornell.edu/~cristian/Cornell_Movie-Dialogs_Corpus.html) - 这可以用于聊天机器人.
- [SQuAD The Stanford Question Answering Dataset](https://rajpurkar.github.io/SQuAD-explorer/) - 可以在线探索的问答数据集，以及在该数据集上表现良好的模型列表.
- [LibriSpeech ASR corpus](http://www.openslr.org/12/) - 巨大的免费英语语音数据集，性别和说话人均衡，看起来质量很高.
- [Awesome Public Datasets](https://github.com/caesar0301/awesome-public-datasets) - 一个很棒的公共数据集列表.
- [SentEval: An Evaluation Toolkit for Universal Sentence Representations](https://arxiv.org/abs/1803.05449) - 一个 Python 框架，用于在许多数据集（NLP 任务）上对您的句子表示进行基准测试. 
- [ParlAI: A Dialog Research Software Platform](https://arxiv.org/abs/1705.06476) - 另一个 Python 框架，用于在许多数据集（NLP 任务）上对句子表示进行基准测试.


<a name="other-math-theory" />

## Other Math Theory

<a name="gradient-descent-algorithms-and-optimization" />

### Gradient Descent Algorithms & Optimization Theory

- [Neural Networks and Deep Learning, ch.2](http://neuralnetworksanddeeplearning.com/chap2.html) - 反向传播算法如何工作的概述.
- [Neural Networks and Deep Learning, ch.4](http://neuralnetworksanddeeplearning.com/chap4.html) - 神经网络可以计算任何函数的视觉证明.
- [Yes you should understand backprop](https://medium.com/@karpathy/yes-you-should-understand-backprop-e2f06eab496b#.mr5wq61fb) - 揭示反向传播的注意事项以及在训练模型时了解这一点的重要性.
- [Artificial Neural Networks: Mathematics of Backpropagation](http://briandolhansky.com/blog/2013/9/27/artificial-neural-networks-backpropagation-part-4) - 从数学上描绘反向传播.
- [Deep Learning Lecture 12: Recurrent Neural Nets and LSTMs](https://www.youtube.com/watch?v=56TYLaQN4N8) - 正确解释了 RNN 图的展开，并暴露了梯度下降算法的潜在问题.
- [Gradient descent algorithms in a saddle point](http://sebastianruder.com/content/images/2016/09/saddle_point_evaluation_optimizers.gif) - 可视化不同的优化器如何与鞍点交互.
- [Gradient descent algorithms in an almost flat landscape](https://devblogs.nvidia.com/wp-content/uploads/2015/12/NKsFHJb.gif) - 可视化不同的优化器如何与几乎平坦的景观相互作用.
- [Gradient Descent](https://www.youtube.com/watch?v=F6GSRDoB-Cg) - 好吧，我已经在上面列出了 Andrew NG 的 Coursera 课程，但是这个视频特别适合作为介绍和定义梯度下降算法.
- [Gradient Descent: Intuition](https://www.youtube.com/watch?v=YovTqTY-PYY) - 上一个视频的后续内容：现在添加直觉.
- [Gradient Descent in Practice 2: Learning Rate](https://www.youtube.com/watch?v=gX6fZHgfrow) - 如何调整神经网络的学习率.
- [The Problem of Overfitting](https://www.youtube.com/watch?v=u73PU6Qwl1I) - 对过度拟合以及如何解决该问题的很好解释.
- [Diagnosing Bias vs Variance](https://www.youtube.com/watch?v=ewogYw5oCAI) - 了解神经网络预测中的偏差和方差以及如何解决这些问题.
- [Self-Normalizing Neural Networks](https://arxiv.org/pdf/1706.02515.pdf) - 令人难以置信的 SELU 激活功能的出现.
- [Learning to learn by gradient descent by gradient descent](https://arxiv.org/pdf/1606.04474.pdf) - 作为优化器的 RNN：引入 L2L 优化器，一种元神经网络.

<a name="complex-numbers-and-digital-signal-processing" />

### Complex Numbers & Digital Signal Processing

好吧，信号处理可能与深度学习没有直接关系，但研究它很有趣，可以在开发基于信号的神经架构时有更多的直觉.

- [Window Functions](https://en.wikipedia.org/wiki/Window_function) - 列出一些已知窗口函数的维基百科页面 - 请注意 [Hann-Poisson window](https://en.wikipedia.org/wiki/Window_function#Hann%E2%80%93Poisson_window) 对于贪婪的爬山算法（例如梯度下降）特别有趣. 
- [MathBox, Tools for Thought Graphical Algebra and Fourier Analysis](https://acko.net/files/gltalks/toolsforthought/) - 傅里叶分析的新面貌.
- [How to Fold a Julia Fractal](http://acko.net/blog/how-to-fold-a-julia-fractal/) - 处理复数和波动方程的动画.
- [Animate Your Way to Glory, Math and Physics in Motion](http://acko.net/blog/animate-your-way-to-glory/) - 物理引擎中的收敛方法，并应用于交互设计.
- [Animate Your Way to Glory - Part II, Math and Physics in Motion](http://acko.net/blog/animate-your-way-to-glory-pt2/) - 使用四元数进行旋转和旋转插值的漂亮动画，这是一种用于处理 3D 旋转的数学对象.
- [Filtering signal, plotting the STFT and the Laplace transform](https://github.com/guillaume-chevalier/filtering-stft-and-laplace-transform) - 关于信号处理的简单 Python 演示.


<a name="papers" />

## Papers

<a name="recurrent-neural-networks" />

### Recurrent Neural Networks

- [Deep Learning in Neural Networks: An Overview](https://arxiv.org/pdf/1404.7828v4.pdf) - You_Again 对深度学习的总结/概述，主要是关于 RNN.
- [Bidirectional Recurrent Neural Networks](http://www.di.ufpe.br/~fnj/RNA/bibliografia/BRNN.pdf) - 更好地使用时间轴上双向扫描的 RNN 进行分类.
- [Learning Phrase Representations using RNN Encoder-Decoder for Statistical Machine Translation](https://arxiv.org/pdf/1406.1078v3.pdf)  - 两个网络合二为一，组合成一个 seq2seq（序列到序列）编码器-解码器架构.  RNN 编码器——具有 1000 个隐藏单元的解码器.  Adadelta 优化器.
- [Sequence to Sequence Learning with Neural Networks](http://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) - 在 WMT&#39;14 英语到法语数据集上，具有 1000 个隐藏大小的 4 个堆叠 LSTM 单元，具有反向输入句子和波束搜索.
- [Exploring the Limits of Language Modeling](https://arxiv.org/pdf/1602.02410.pdf) - 在字符级 CNN 之上使用单词级 LSTM 的漂亮递归模型，使用了过多的 GPU 功率.
- [Neural Machine Translation and Sequence-to-sequence Models: A Tutorial](https://arxiv.org/pdf/1703.01619.pdf) - 对 NMT 主题的有趣概述，我主要阅读了关于 RNN 的第 8 部分，作为复习.
- [Exploring the Depths of Recurrent Neural Networks with Stochastic Residual Learning](https://cs224d.stanford.edu/reports/PradhanLongpre.pdf) - 基本上，在当前的情感分析案例中，残差连接可能比堆叠 RNN 更好.
- [Pixel Recurrent Neural Networks](https://arxiv.org/pdf/1601.06759.pdf) - 非常适合类似 photoshop 的“内容感知填充”来填充图像中缺失的补丁.
- [Adaptive Computation Time for Recurrent Neural Networks](https://arxiv.org/pdf/1603.08983v4.pdf)  - 让 RNN 决定计算多长时间. 我很想看看它与神经图灵机的结合有多好. 可以找到有关该主题的有趣的交互式可视化 [here](http://distill.pub/2016/augmented-rnns/).

<a name="convolutional-neural-networks" />

### Convolutional Neural Networks

- [What is the Best Multi-Stage Architecture for Object Recognition?](http://yann.lecun.com/exdb/publis/pdf/jarrett-iccv-09.pdf) - 非常适合使用“局部对比度归一化”.
- [ImageNet Classification with Deep Convolutional Neural Networks](http://www.cs.toronto.edu/~fritz/absps/imagenet.pdf) - AlexNet，2012 ILSVRC，ReLU 激活函数的突破.
- [Visualizing and Understanding Convolutional Networks](https://arxiv.org/pdf/1311.2901v3.pdf) - 对于“deconvnet 层”.
- [Fast and Accurate Deep Network Learning by Exponential Linear Units](https://arxiv.org/pdf/1511.07289v1.pdf) - CIFAR 视觉任务的 ELU 激活函数.
- [Very Deep Convolutional Networks for Large-Scale Image Recognition](https://arxiv.org/pdf/1409.1556v6.pdf)  - 有趣的想法是在池化之前堆叠多个 3x3 conv+ReLU 以获得更大的过滤器大小，只需几个参数. 还有一个用于“ConvNet Configuration”的漂亮表格.
- [Going Deeper with Convolutions](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Szegedy_Going_Deeper_With_2015_CVPR_paper.pdf) - GoogLeNet：“初始”层/模块的出现，其想法是将卷积层并行化为许多具有“相同”填充的不同大小的迷你卷积，并在深度上连接.
- [Highway Networks](https://arxiv.org/pdf/1505.00387v2.pdf) - 公路网络：剩余连接.
- [Batch Normalization: Accelerating Deep Network Training by Reducing Internal Covariate Shift](https://arxiv.org/pdf/1502.03167v3.pdf) - 批量归一化 (BN)：通过对整个批次求和来归一化层的输出，然后执行线性重新缩放和移动某个可训练量.
- [U-Net: Convolutional Networks for Biomedical Image Segmentation](https://arxiv.org/pdf/1505.04597.pdf) - U-Net 是一种编码器-解码器 CNN，它也具有跳跃连接，适用于每个像素级别的图像分割.
- [Deep Residual Learning for Image Recognition](https://arxiv.org/pdf/1512.03385v1.pdf) - 带有批量归一化层的非常深的残差层 - 又名“如何过度拟合具有太多层的任何视觉数据集，并使任何视觉模型在给定足够数据的情况下在识别时正常工作”.
- [Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning](https://arxiv.org/pdf/1602.07261v2.pdf) - 用于改进具有剩余连接的 GoogLeNet.
- [WaveNet: a Generative Model for Raw Audio](https://arxiv.org/pdf/1609.03499v2.pdf) - 使用基于扩张因果卷积的新架构生成史诗般的原始语音/音乐，以捕获更多音频长度.
- [Learning a Probabilistic Latent Space of Object Shapes via 3D Generative-Adversarial Modeling](https://arxiv.org/pdf/1610.07584v2.pdf) - 用于 3D 模型生成的 3D-GAN 和来自嵌入的有趣 3D 家具算术（想想带有 3D 家具表示的 word2vec 字算术）.
- [Accurate, Large Minibatch SGD: Training ImageNet in 1 Hour](https://research.fb.com/publications/ImageNet1kIn1h/) - 难以置信的快速分布式 CNN 训练.
- [Densely Connected Convolutional Networks](https://arxiv.org/pdf/1608.06993.pdf) - CVPR 2017 最佳论文奖，在 CIFAR-10、CIFAR-100 和 SVHN 数据集上取得了最先进的性能改进，这种新的神经网络架构被命名为 DenseNet.
- [The One Hundred Layers Tiramisu: Fully Convolutional DenseNets for Semantic Segmentation](https://arxiv.org/pdf/1611.09326.pdf) - 融合了 U-Net 和 DenseNet 的思想，这种新的神经网络特别适用于图像分割中的大型数据集.
- [Prototypical Networks for Few-shot Learning](https://arxiv.org/pdf/1703.05175.pdf) - 在损失中使用距离度量来从几个例子中确定对象属于哪个类.

<a name="attention-mechanisms" />

### Attention Mechanisms

- [Neural Machine Translation by Jointly Learning to Align and Translate](https://arxiv.org/pdf/1409.0473.pdf)  - LSTM 的注意机制！ 大多数情况下，数字和公式及其解释对我很有用. 我在那篇论文上发表了演讲 [here](https://www.youtube.com/watch?v=QuvRWevJMZ4).
- [Neural Turing Machines](https://arxiv.org/pdf/1410.5401v2.pdf)  - 出色地让神经网络学习一种算法，该算法在长时间依赖性上具有看似良好的泛化能力. 序列召回问题.
- [Show, Attend and Tell: Neural Image Caption Generation with Visual Attention](https://arxiv.org/pdf/1502.03044.pdf) - LSTM 在 CNN 特征图上的注意力机制创造了奇迹.
- [Teaching Machines to Read and Comprehend](https://arxiv.org/pdf/1506.03340v3.pdf) - 一个关于文本问答的非常有趣和创造性的工作，多么突破，与此有关.
- [Effective Approaches to Attention-based Neural Machine Translation](https://arxiv.org/pdf/1508.04025.pdf) - 探索注意力机制的不同方法.
- [Matching Networks for One Shot Learning](https://arxiv.org/pdf/1606.04080.pdf) - 通过使用注意力机制和查询将图像与其他图像进行比较以进行分类，使用低数据进行一次性学习的有趣方式.
- [Google’s Neural Machine Translation System: Bridging the Gap between Human and Machine Translation](https://arxiv.org/pdf/1609.08144.pdf) - 2016 年：在编码器/解码器上具有注意机制的堆叠残差 LSTM 是 NMT（神经机器翻译）的最佳选择.
- [Hybrid computing using a neural network with dynamic external memory](http://www.nature.com/articles/nature20101.epdf?author_access_token=ImTXBI8aWbYxYQ51Plys8NRgN0jAjWel9jnR3ZoTv0MggmpDmwljGswxVdeocYSurJ3hxupzWuRNeGvvXnoO8o4jTJcnAyhGuZzXJ1GEaD-Z7E6X_a9R-xqJ9TfJWBqz) - 改进基于 NTM 的可微分记忆：现在是可微分神经计算机 (DNC).
- [Massive Exploration of Neural Machine Translation Architectures](https://arxiv.org/pdf/1703.03906.pdf) - 这产生了关于在框架 seq2seq 问题公式中执行 NMT 的工作边界的直觉.
- [通过在 Mel 频谱图上调节 WaveNet 进行自然 TTS 合成
预测](https://arxiv.org/pdf/1712.05884.pdf) - A [WaveNet](https://arxiv.org/pdf/1609.03499v2.pdf) 用作声码器可以以 Tacotron 2 LSTM 神经网络生成的梅尔频谱图为条件，注意从文本生成整洁的音频.
- [Attention Is All You Need](https://arxiv.org/abs/1706.03762) (AIAYN) - 引入具有位置编码的多头自注意力神经网络来进行句子级 NLP，无需任何 RNN 或 CNN - 这篇论文是必读的（另请参阅 [this explanation](http://nlp.seas.harvard.edu/2018/04/03/attention.html) 和 [this visualization](http://jalammar.github.io/illustrated-transformer/) 的论文）. 

<a name="other" />

### Other

- [ProjectionNet: Learning Efficient On-Device Deep Networks Using Neural Projections](https://arxiv.org/abs/1708.00630) - 用深度神经网络中的单词投影替换单词嵌入，这不需要预先提取的词典，也不需要存储嵌入矩阵. 
- [Self-Governing Neural Networks for On-Device Short Text Classification](http://aclweb.org/anthology/D18-1105)  - 本文是上述 ProjectionNet 的续集.  SGNN 在 ProjectionNet 上进行了详细阐述，优化更详细更深入（另见我 [attempt to reproduce the paper in code](https://github.com/guillaume-chevalier/SGNN-Self-Governing-Neural-Networks-Projection-Layer) 看 [the talks' recording](https://vimeo.com/305197775)).
- [Matching Networks for One Shot Learning](https://arxiv.org/abs/1606.04080)  - 从其他示例列表（没有明确的类别）和每个分类任务的低数据中分类一个新示例，但大量数据用于许多类似的分类任务 - 它似乎比孪生网络更好. 总结一下：使用匹配网络，您可以直接优化示例之间的余弦相似度（就像自我注意产品会匹配）直接传递给 softmax. 我猜想匹配网络可能与 word2vec 的 CBOW 或 Skip-gram 中的负采样 softmax 训练一起使用，而无需进行任何上下文嵌入查找. 


<a name="youtube" />

## YouTube and Videos

- [Attention Mechanisms in Recurrent Neural Networks (RNNs) - IGGG](https://www.youtube.com/watch?v=QuvRWevJMZ4) - 阅读小组关于注意力机制的演讲（论文：通过联合学习对齐和翻译进行神经机器翻译）.
- [Tensor Calculus and the Calculus of Moving Surfaces](https://www.youtube.com/playlist?list=PLlXfTHzgMRULkodlIEqfgTS-H1AY_bNtq) - 正确概括 Tensors 的工作原理，但仅仅观看一些视频已经对理解这些概念有很大帮助.
- [Deep Learning & Machine Learning (Advanced topics)](https://www.youtube.com/playlist?list=PLlp-GWNOd6m4C_-9HxuHg2_ZeI2Yzwwqt) - 我发现有趣或有用的有关深度学习的视频列表，这是所有内容的混合体.
- [Signal Processing Playlist](https://www.youtube.com/playlist?list=PLlp-GWNOd6m6gSz0wIcpvl4ixSlS-HEmr) - 我编写的关于 DFT/FFT、STFT 和拉普拉斯变换的 YouTube 播放列表 - 我对我的软件工程学士学位不包括信号处理课程（除了量子物理课程中的一点）感到生气.
- [Computer Science](https://www.youtube.com/playlist?list=PLlp-GWNOd6m7vLOsW20xAJ81-65C-Ys6k) - 我编写的另一个 YouTube 播放列表，这次是关于各种 CS 主题.
- [Siraj's Channel](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A/videos?view=0&sort=p&flow=grid) - Siraj 提供有关深度学习的有趣、快节奏的视频教程.
- [Two Minute Papers' Channel](https://www.youtube.com/user/keeroyz/videos?sort=p&view=0&flow=grid) - 一些研究论文的有趣而浅显的概述，例如关于 WaveNet 或神经风格迁移.
- [Geoffrey Hinton interview](https://www.coursera.org/learn/neural-networks-deep-learning/lecture/dcm5r/geoffrey-hinton-interview) - Andrew Ng 采访 Geoffrey Hinton，谈他的研究和突破，并为学生提供建议.
- [Growing Neat Software Architecture from Jupyter Notebooks](https://www.youtube.com/watch?v=K4QN27IKr0g) - 介绍如何在使用 Jupyter 笔记本时构建机器学习项目.

<a name="misc-hubs-and-links" />

## Misc. Hubs & Links

- [Hacker News](https://news.ycombinator.com/news) - 也许我是如何发现 ML 的 - 有趣的趋势在成为大事之前就出现在那个网站上.
- [DataTau](http://www.datatau.com/) - 这是一个类似于 Hacker News 的中心，但专门针对数据科学.
- [Naver](http://www.naver.com/)  - 这是一个韩语搜索引擎 - 具有讽刺意味的是，最好与谷歌翻译一起使用. 令人惊讶的是，有时深度学习搜索结果和可理解的高级数学内容在那里比在谷歌搜索上更容易出现.
- [Arxiv Sanity Preserver](http://www.arxiv-sanity.com/) - 具有 TF/IDF 功能的 arXiv 浏览器.
- [Awesome Neuraxle](https://github.com/Neuraxio/Awesome-Neuraxle) - Neuraxle 的一个很棒的列表，这是一个用于编码清洁生产级 ML 管道的 ML 框架.


<a name="license" />

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Guillaume Chevalier](https://github.com/guillaume-chevalier) has waived all copyright and related or neighboring rights to this work.
