<div class="github-widget" data-repo="terryum/awesome-deep-learning-papers"></div>
## Awesome - Most Cited Deep Learning Papers

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

【通知】自2017年以来，由于每天发表的深度学习论文海量，此榜单不再维护.

被引用次数最多的深度学习论文精选列表（2012-2016 年）

我们相信存在*经典*深度学习论文，无论其应用领域如何，都值得一读. 我们不想提供大量的论文，而是想提供一个*精选列表*，其中包含在某些研究领域被认为是*必读*的令人敬畏的深度学习论文.

## Background

在这个列表之前，还有其他*很棒的深度学习列表*，例如， [Deep Vision](https://github.com/kjw0612/awesome-deep-vision) and [Awesome Recurrent Neural Networks](https://github.com/kjw0612/awesome-rnn) . 此外，在这个列表出来之后，另一个深度学习初学者的很棒的列表，叫做 [Deep Learning Papers Reading Roadmap](https://github.com/songrotek/Deep-Learning-Papers-Reading-Roadmap), 被许多深度学习研究者所创造和喜爱.

尽管 *Roadmap List* 包含许多重要的深度学习论文，但我还是难以阅读所有这些论文. 正如我在引言中提到的，我相信开创性的作品可以为我们提供经验教训，无论它们的应用领域如何. 因此，我想在这里介绍 **深度学习前 100 篇论文**，作为概述深度学习研究的一个很好的起点.

每天获取最新发表论文的消息，关注我 [twitter](https://twitter.com/TerryUm_ML) 或者 [facebook page](https://www.facebook.com/terryum.io/)! 

## Awesome list criteria

1. 建议列出2012-2016年发表的**深度学习论文前100名**.
2. 如果将一篇论文添加到列表中，则应删除另一篇论文（通常来自 *More Papers from 2016&quot; 部分）以保留前 100 篇论文.（因此，删除论文与添加论文一样也是重要的贡献）
3. 重要但未能入选的论文将被列入*More than Top 100*部分.
4. 近6个月或2012年之前发表的论文请参考*New Papers*和*Old Papers*部分.

*（引用标准）*
- **< 6 months** : *New Papers* (by discussion)
- **2016**：+60 次引用或“2016 年的更多论文”
- **2015**：+200 次引用
- **2014**：+400 次引用
- **2013**：+600 次引用
- **2012**：+800 次引用
- **~2012** : *旧论文*（通过讨论）

请注意，我们更喜欢可应用于各种研究的开创性深度学习论文，而不是应用论文. 因此，一些符合标准的论文可能不会被接受，而另一些则可以. 这取决于论文的影响力、对研究领域其他研究的适用性等.

**We need your contributions!**

如果您有任何建议（遗漏论文、新论文、主要研究人员或拼写错误），请随时编辑并提出请求.
（请阅读 [contributing guide](https://github.com/terryum/awesome-deep-learning-papers/blob/master/Contributing.md) 以获得进一步的说明，尽管只是让我知道论文的标题也可以对我们做出很大的贡献.）

（更新）您可以下载所有前 100 篇论文 [this](https://github.com/terryum/awesome-deep-learning-papers/blob/master/fetch_papers.py) 并收集所有作者的姓名 [this](https://github.com/terryum/awesome-deep-learning-papers/blob/master/get_authors.py) . 还， [bib file](https://github.com/terryum/awesome-deep-learning-papers/blob/master/top100papers.bib) 所有前 100 篇论文都可用. 谢谢，doodhwala， [Sven](https://github.com/sunshinemyson) and [grepinsight](https://github.com/grepinsight)!

+ 谁能贡献一下获取Top-100论文作者统计的代码？




*（超过前100名）*

* [New Papers](#new-papers) : 不到 6 个月
* [Old Papers](#old-papers) : 2012年之前
* [HW / SW / Dataset](#hw--sw--dataset) : 技术报告
* [Appendix: More than Top 100](#appendix-more-than-top-100) : 更多论文不在列表中

* * *

### Understanding / Generalization / Transfer
 - **在神经网络中提炼知识**（2015 年），G. Hinton 等人.  [[pdf]](http://arxiv.org/pdf/1503.02531)
 - **深度神经网络很容易被愚弄：无法识别图像的高置信度预测**（2015 年），A. Nguyen 等人.  [[pdf]](http://arxiv.org/pdf/1412.1897)
 - **深度神经网络中的特征如何转移？**（2014 年），J. Yosinski 等人.  [[pdf]](http://papers.nips.cc/paper/5347-how-transferable-are-features-in-deep-neural-networks.pdf)
 - **CNN 现成的功能：一个惊人的识别基线**（2014 年），A. Razavian 等人.  [[pdf]](http://www.cv-foundation.org//openaccess/content_cvpr_workshops_2014/W15/papers/Razavian_CNN_Features_Off-the-Shelf_2014_CVPR_paper.pdf)
 - **使用卷积神经网络学习和传输中级图像表示**（2014 年），M. Oquab 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2014/papers/Oquab_Learning_and_Transferring_2014_CVPR_paper.pdf)
- **可视化和理解卷积网络**（2014 年），M. Zeiler 和 R. Fergus [[pdf]](http://arxiv.org/pdf/1311.2901)
 - **Decaf：用于通用视觉识别的深度卷积激活功能**（2014 年），J. Donahue 等人.  [[pdf]](http://arxiv.org/pdf/1310.1531)

<!---[Key researchers]  [Geoffrey Hinton](https://scholar.google.ca/citations?user=JicYPdAAAAAJ), [Yoshua Bengio](https://scholar.google.ca/citations?user=kukA0LcAAAAJ), [Jason Yosinski](https://scholar.google.ca/citations?hl=en&user=gxL1qj8AAAAJ) -->

### Optimization / Training Techniques
 - **训练非常深的网络**（2015 年），R. Srivastava 等人.  [[pdf]](http://papers.nips.cc/paper/5850-training-very-deep-networks.pdf)
- **批量归一化：通过减少内部协变量偏移加速深度网络训练**（2015 年），S. Loffe 和 C. Szegedy [[pdf]](http://arxiv.org/pdf/1502.03167)
 - **深入研究整流器：在 imagenet 分类上超越人类水平**（2015 年），K. He 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/He_Delving_Deep_into_ICCV_2015_paper.pdf)
 - **Dropout：一种防止神经网络过度拟合的简单方法**（2014 年），N. Srivastava 等.  [[pdf]](http://jmlr.org/papers/volume15/srivastava14a/srivastava14a.pdf)
- **Adam：一种随机优化方法** (2014)，D. Kingma 和 J. Ba [[pdf]](http://arxiv.org/pdf/1412.6980)
 - **通过防止特征检测器的共同适应来改进神经网络**（2012 年），G. Hinton 等人.  [[pdf]](http://arxiv.org/pdf/1207.0580.pdf)
- **随机搜索超参数优化** (2012) J. Bergstra 和 Y. Bengio [[pdf]](http://www.jmlr.org/papers/volume13/bergstra12a/bergstra12a)

<!---[Key researchers] [Geoffrey Hinton](https://scholar.google.ca/citations?user=JicYPdAAAAAJ), [Yoshua Bengio](https://scholar.google.ca/citations?user=kukA0LcAAAAJ), [Christian Szegedy](https://scholar.google.ca/citations?hl=en&user=3QeF7mAAAAAJ), [Sergey Ioffe](https://scholar.google.ca/citations?user=S5zOyIkAAAAJ), [Kaming He](https://scholar.google.ca/citations?hl=en&user=DhtAFkwAAAAJ), [Diederik P. Kingma](https://scholar.google.ca/citations?hl=en&user=yyIoQu4AAAAJ)-->

### Unsupervised / Generative Models
 - **像素递归神经网络**（2016 年），A. Oord 等人.  [[pdf]](http://arxiv.org/pdf/1601.06759v2.pdf)
 - **改进的 GAN 训练技术**（2016 年），T. Salimans 等人.  [[pdf]](http://papers.nips.cc/paper/6125-improved-techniques-for-training-gans.pdf)
 - **使用深度卷积生成对抗网络进行无监督表示学习**（2015 年），A. Radford 等人.  [[pdf]](https://arxiv.org/pdf/1511.06434v2)
 - **DRAW：用于图像生成的递归神经网络**（2015 年），K. Gregor 等人.  [[pdf]](http://arxiv.org/pdf/1502.04623)
 - **生成对抗网络**（2014 年），I. Goodfellow 等人.  [[pdf]](http://papers.nips.cc/paper/5423-generative-adversarial-nets.pdf)
- **自动编码变分贝叶斯** (2013)，D. Kingma 和 M. Welling [[pdf]](http://arxiv.org/pdf/1312.6114)
 - **使用大规模无监督学习构建高级特征**（2013 年），Q. Le 等.  [[pdf]](http://arxiv.org/pdf/1112.6209)

<!---[Key researchers] [Yoshua Bengio](https://scholar.google.ca/citations?user=kukA0LcAAAAJ), [Ian Goodfellow](https://scholar.google.ca/citations?user=iYN86KEAAAAJ), [Alex Graves](https://scholar.google.ca/citations?user=DaFHynwAAAAJ)-->
### Convolutional Neural Network Models
 - **重新思考计算机视觉的初始架构**（2016 年），C. Szegedy 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Szegedy_Rethinking_the_Inception_CVPR_2016_paper.pdf)
 - **Inception-v4、inception-resnet 和残差连接对学习的影响** (2016)，C. Szegedy 等人.  [[pdf]](http://arxiv.org/pdf/1602.07261)
 - **深度残差网络中的身份映射**（2016 年），K. He 等人.  [[pdf]](https://arxiv.org/pdf/1603.05027v2.pdf)
 - **用于图像识别的深度残差学习**（2016 年），K. He 等人.  [[pdf]](http://arxiv.org/pdf/1512.03385)
- **空间变换器网络**（2015 年），M. Jaderberg 等人，[[pdf]](http://papers.nips.cc/paper/5854-spatial-transformer-networks.pdf)
 - **Going deeper with convolutions** (2015)，C. Szegedy 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Szegedy_Going_Deeper_With_2015_CVPR_paper.pdf)
- **用于大规模图像识别的超深卷积网络**（2014 年），K. Simonyan 和 A. Zisserman [[pdf]](http://arxiv.org/pdf/1409.1556)
 - **细节中的魔鬼回归：深入研究卷积网络**（2014 年），K. Chatfield 等.  [[pdf]](http://arxiv.org/pdf/1405.3531)
 - **OverFeat：使用卷积网络集成识别、定位和检测**（2013 年），P. Sermanet 等.  [[pdf]](http://arxiv.org/pdf/1312.6229)
 - **Maxout 网络** (2013)，I. Goodfellow 等人.  [[pdf]](http://arxiv.org/pdf/1302.4389v4)
 - **网络中的网络** (2013)，M. Lin 等人.  [[pdf]](http://arxiv.org/pdf/1312.4400)
 - **使用深度卷积神经网络进行 ImageNet 分类** (2012)，A. Krizhevsky 等人.  [[pdf]](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks.pdf)

<!---[Key researchers]  [Christian Szegedy](https://scholar.google.ca/citations?hl=en&user=3QeF7mAAAAAJ), [Kaming He](https://scholar.google.ca/citations?hl=en&user=DhtAFkwAAAAJ), [Shaoqing Ren](https://scholar.google.ca/citations?hl=en&user=AUhj438AAAAJ), [Jian Sun](https://scholar.google.ca/citations?hl=en&user=ALVSZAYAAAAJ), [Geoffrey Hinton](https://scholar.google.ca/citations?user=JicYPdAAAAAJ), [Yoshua Bengio](https://scholar.google.ca/citations?user=kukA0LcAAAAJ), [Yann LeCun](https://scholar.google.ca/citations?hl=en&user=WLN3QrAAAAAJ)-->

### Image: Segmentation / Object Detection
 - **你只看一次：统一的实时对象检测**（2016 年），J. Redmon 等.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Redmon_You_Only_Look_CVPR_2016_paper.pdf)
 - **用于语义分割的全卷积网络**（2015 年），J. Long 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Long_Fully_Convolutional_Networks_2015_CVPR_paper.pdf)
 - **更快的 R-CNN：使用区域提议网络实现实时目标检测**（2015 年），S. Ren 等人.  [[pdf]](http://papers.nips.cc/paper/5638-faster-r-cnn-towards-real-time-object-detection-with-region-proposal-networks.pdf)
- **Fast R-CNN** (2015)，R. Girshick [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/Girshick_Fast_R-CNN_ICCV_2015_paper.pdf)
 - **用于准确对象检测和语义分割的丰富特征层次结构**（2014 年），R. Girshick 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2014/papers/Girshick_Rich_Feature_Hierarcies_2014_CVPR_paper.pdf)
 - **用于视觉识别的深度卷积网络中的空间金字塔池**（2014 年），K. He 等人.  [[pdf]](http://arxiv.org/pdf/1406.4729)
 - **使用深度卷积网络和完全连接的 CRF 进行语义图像分割**，L. Chen 等人.  [[pdf]](https://arxiv.org/pdf/1412.7062)
 - **学习场景标签的层次特征**（2013 年），C. Farabet 等人.  [[pdf]](https://hal-enpc.archives-ouvertes.fr/docs/00/74/20/77/PDF/farabet-pami-13.pdf)

<!---[Key researchers]  [Ross Girshick](https://scholar.google.ca/citations?hl=en&user=W8VIEZgAAAAJ), [Jeff Donahue](https://scholar.google.ca/citations?hl=en&user=UfbuDH8AAAAJ), [Trevor Darrell](https://scholar.google.ca/citations?hl=en&user=bh-uRFMAAAAJ)-->

### Image / Video / Etc
 - **使用深度卷积网络的图像超分辨率**（2016 年），C. Dong 等人.  [[pdf]](https://arxiv.org/pdf/1501.00092v3.pdf)
 - **艺术风格的神经算法**（2015 年），L. Gatys 等人.  [[pdf]](https://arxiv.org/pdf/1508.06576)
- **用于生成图像描述的深度视觉语义对齐**（2015 年），A. Karpathy 和 L. Fei-Fei [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers /Karpathy_Deep_Visual-Semantic_Alignments_2015_CVPR_paper.pdf)
 - **Show, attend and tell: Neural image caption generation with visual attention** (2015), K. Xu 等人.  [[pdf]](http://arxiv.org/pdf/1502.03044)
 - **Show and tell: A neural image caption generator** (2015), O. Vinyals 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Vinyals_Show_and_Tell_2015_CVPR_paper.pdf)
 - **用于视觉识别和描述的长期循环卷积网络**（2015 年），J. Donahue 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Donahue_Long-Term_Recurrent_Convolutional_2015_CVPR_paper.pdf)
 - **VQA：视觉问答**（2015 年），S. Antol 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/Antol_VQA_Visual_Question_ICCV_2015_paper.pdf)
 - **DeepFace：缩小人脸验证中与人类水平表现的差距**（2014 年），Y. Taigman 等.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2014/papers/Taigman_DeepFace_Closing_the_2014_CVPR_paper.pdf)：
 - **使用卷积神经网络进行大规模视频分类**（2014 年），A. Karpathy 等人.  [[pdf]](http://vision.stanford.edu/pdf/karpathy14.pdf)
 - **用于视频动作识别的双流卷积网络**（2014 年），K. Simonyan 等人.  [[pdf]](http://papers.nips.cc/paper/5353-two-stream-convolutional-networks-for-action-recognition-in-videos.pdf)
 - **用于人体动作识别的 3D 卷积神经网络** (2013)，S. Ji 等人.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/icml2010_JiXYY10.pdf)

<!---[Key researchers]  [Oriol Vinyals](https://scholar.google.ca/citations?user=NkzyCvUAAAAJ), [Andrej Karpathy](https://scholar.google.ca/citations?user=l8WuQJgAAAAJ)-->

<!---[Key researchers]  [Alex Graves](https://scholar.google.ca/citations?user=DaFHynwAAAAJ)-->

### Natural Language Processing / RNNs
 - **命名实体识别的神经架构**（2016 年），G. Lample 等人.  [[pdf]](http://aclweb.org/anthology/N/N16/N16-1030.pdf)
 - **探索语言建模的极限**（2016 年），R. Jozefowicz 等.  [[pdf]](http://arxiv.org/pdf/1602.02410)
 - **教机器阅读和理解**（2015 年），K. Hermann 等人.  [[pdf]](http://papers.nips.cc/paper/5945-teaching-machines-to-read-and-comprehend.pdf)
 - **基于注意力的神经机器翻译的有效方法**（2015 年），M. Luong 等人.  [[pdf]](https://arxiv.org/pdf/1508.04025)
 - **作为循环神经网络的条件随机场**（2015 年），S. Zheng 和 S. Jayasumana.  [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/Zheng_Conditional_Random_Fields_ICCV_2015_paper.pdf)
 - **记忆网络** (2014)，J. Weston 等人.  [[pdf]](https://arxiv.org/pdf/1410.3916)
 - **神经图灵机**（2014 年），A. Graves 等人.  [[pdf]](https://arxiv.org/pdf/1410.5401)
 - **通过联合学习对齐和翻译进行神经机器翻译**（2014 年），D. Bahdanau 等人.  [[pdf]](http://arxiv.org/pdf/1409.0473)
 - **Sequence to sequence learning with neural networks** (2014), I. Sutskever 等人.  [[pdf]](http://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf)
 - **使用 RNN 编码器-解码器学习短语表示以进行统计机器翻译** (2014)，K. Cho 等人.  [[pdf]](http://arxiv.org/pdf/1406.1078)
 - **用于建模句子的卷积神经网络**（2014 年），N. Kalchbrenner 等人.  [[pdf]](http://arxiv.org/pdf/1404.2188v1)
- **用于句子分类的卷积神经网络** (2014)，Y. Kim [[pdf]](http://arxiv.org/pdf/1408.5882)
 - **手套：用于单词表示的全局向量**（2014 年），J. Pennington 等人.  [[pdf]](http://anthology.aclweb.org/D/D14/D14-1162.pdf)
- **句子和文档的分布式表示**（2014 年），Q. Le 和 T. Mikolov [[pdf]](http://arxiv.org/pdf/1405.4053)
 - **单词和短语的分布式表示及其组合**（2013 年），T. Mikolov 等人.  [[pdf]](http://papers.nips.cc/paper/5021-distributed-representations-of-words-and-phrases-and-their-compositionality.pdf)
 - **向量空间中单词表示的有效估计**（2013 年），T. Mikolov 等人.  [[pdf]](http://arxiv.org/pdf/1301.3781)
 - **情感树库语义组合的递归深度模型**（2013 年），R. Socher 等人.  [[pdf]](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.383.1327&amp;rep=rep1&amp;type=pdf)
 - **使用递归神经网络生成序列**（2013 年），A. Graves.  [[pdf]](https://arxiv.org/pdf/1308.0850)

<!---[Key researchers]  [Kyunghyun Cho](https://scholar.google.ca/citations?user=0RAmmIAAAAAJ), [Oriol Vinyals](https://scholar.google.ca/citations?user=NkzyCvUAAAAJ), [Richard Socher](https://scholar.google.ca/citations?hl=en&user=FaOcyfMAAAAJ), [Tomas Mikolov](https://scholar.google.ca/citations?user=oBu8kMMAAAAJ), [Christopher D. Manning](https://scholar.google.ca/citations?user=1zmDOdwAAAAJ), [Yoshua Bengio](https://scholar.google.ca/citations?user=kukA0LcAAAAJ)-->

### Speech / Other Domain
 - **基于端到端注意力的大词汇量语音识别**（2016 年），D. Bahdanau 等人.  [[pdf]](https://arxiv.org/pdf/1508.04395)
 - **Deep speech 2: End-to-end speech recognition in English and Mandarin** (2015), D. Amodei 等人.  [[pdf]](https://arxiv.org/pdf/1512.02595)
- **使用深度递归神经网络进行语音识别**（2013 年），A. Graves [[pdf]](http://arxiv.org/pdf/1303.5778.pdf)
 - **用于语音识别声学建模的深度神经网络：四个研究小组的共同观点**（2012 年），G. Hinton 等人.  [[pdf]](http://www.cs.toronto.edu/~asamir/papers/SPM_DNN_12.pdf)
 - **用于大词汇量语音识别的上下文相关预训练深度神经网络** (2012) G. Dahl 等人.  [[pdf]](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.337.7548&amp;rep=rep1&amp;type=pdf)
 - **使用深度信念网络的声学建模**（2012 年），A. Mohamed 等人.  [[pdf]](http://www.cs.toronto.edu/~asamir/papers/speechDBN_jrnl.pdf)

<!---[Key researchers]  [Alex Graves](https://scholar.google.ca/citations?user=DaFHynwAAAAJ), [Geoffrey Hinton](https://scholar.google.ca/citations?user=JicYPdAAAAAJ), [Dong Yu](https://scholar.google.ca/citations?hl=en&user=tMY31_gAAAAJ)-->

### Reinforcement Learning / Robotics
 - **深度视觉运动策略的端到端培训**（2016 年），S. Levine 等人.  [[pdf]](http://www.jmlr.org/papers/volume17/15-522/source/15-522.pdf)
 - **通过深度学习和大规模数据收集学习机器人抓取的手眼协调**（2016 年），S. Levine 等.  [[pdf]](https://arxiv.org/pdf/1603.02199)
 - **深度强化学习的异步方法**（2016 年），V. Mnih 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v48/mniha16.pdf)
 - **使用双 Q 学习的深度强化学习**（2016 年），H. Hasselt 等人.  [[pdf]](https://arxiv.org/pdf/1509.06461.pdf )
 - **通过深度神经网络和树搜索掌握围棋游戏**（2016 年），D. Silver 等人.  [[pdf]](http://www.nature.com/nature/journal/v529/n7587/full/nature16961.html)
 - **通过深度强化学习进行持续控制**（2015 年），T. Lillicrap 等人.  [[pdf]](https://arxiv.org/pdf/1509.02971)
 - **通过深度强化学习进行人类水平的控制**（2015 年），V. Mnih 等人.  [[pdf]](http://www.davidqiu.com:8888/research/nature14236.pdf)
 - **用于检测机器人抓握的深度学习**（2015 年），I. Lenz 等人.  [[pdf]](http://www.cs.cornell.edu/~asaxena/papers/lenz_lee_saxena_deep_learning_grasping_ijrr2014.pdf)
 - **使用深度强化学习玩 atari**（2013 年），V. Mnih 等人.  [[pdf]](http://arxiv.org/pdf/1312.5602.pdf))

<!---[Key researchers]  [Sergey Levine](https://scholar.google.ca/citations?user=8R35rCwAAAAJ), [Volodymyr Mnih](https://scholar.google.ca/citations?hl=en&user=rLdfJ1gAAAAJ), [David Silver](https://scholar.google.ca/citations?user=-8DNE4UAAAAJ)-->

### More Papers from 2016
 - **层归一化**（2016 年），J. Ba 等人.  [[pdf]](https://arxiv.org/pdf/1607.06450v1.pdf)
 - **Learning to learn by gradient descent by gradient descent** (2016), M. Andrychowicz 等人.  [[pdf]](http://arxiv.org/pdf/1606.04474v1)
 - **神经网络的领域对抗训练**（2016 年），Y. Ganin 等人.  [[pdf]](http://www.jmlr.org/papers/volume17/15-239/source/15-239.pdf)
 - **WaveNet：原始音频的生成模型**（2016 年），A. Oord 等人.  [[pdf]](https://arxiv.org/pdf/1609.03499v2) [[web]](https://deepmind.com/blog/wavenet-generative-model-raw-audio/)
 - **彩色图像着色** (2016)，R. Zhang 等人.  [[pdf]](https://arxiv.org/pdf/1603.08511)
 - **自然图像流形上的生成视觉操作**（2016 年），J. Zhu 等人.  [[pdf]](https://arxiv.org/pdf/1609.03552)
 - **纹理网络：纹理和程式化图像的前馈合成**（2016 年），D Ulyanov 等.  [[pdf]](http://www.jmlr.org/proceedings/papers/v48/ulyanov16.pdf)
 - **SSD：单发多盒检测器**（2016 年），W. Liu 等人.  [[pdf]](https://arxiv.org/pdf/1512.02325)
 - **SqueezeNet：AlexNet 级准确度，参数减少 50 倍且模型大小小于 1MB**（2016 年），F. Iandola 等人.  [[pdf]](http://arxiv.org/pdf/1602.07360)
 - **Eie：压缩深度神经网络上的高效推理引擎**（2016 年），S. Han 等人.  [[pdf]](http://arxiv.org/pdf/1602.01528)
 - **二值化神经网络：训练权重和激活限制为+ 1 或-1 的深度神经网络**（2016 年），M. Courbariaux 等.  [[pdf]](https://arxiv.org/pdf/1602.02830)
 - **用于视觉和文本问答的动态记忆网络**（2016 年），C. Xiong 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v48/xiong16.pdf)
 - **用于图像问答的堆叠注意力网络**（2016 年），Z. Yang 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Yang_Stacked_Attention_Networks_CVPR_2016_paper.pdf)
 - **使用具有动态外部存储器的神经网络进行混合计算**（2016 年），A. Graves 等人.  [[pdf]](https://www.gwern.net/docs/2016-graves.pdf)
 - **Google 的神经机器翻译系统：弥合人机翻译之间的差距**（2016 年），Y. Wu 等人.  [[pdf]](https://arxiv.org/pdf/1609.08144)

* * *


### New papers
*值得一读的新发表论文（&lt;6个月）*
 - MobileNets：用于移动视觉应用的高效卷积神经网络（2017 年），Andrew G. Howard 等人.  [[pdf]](https://arxiv.org/pdf/1704.04861.pdf)
 - 卷积序列到序列学习 (2017)，Jonas Gehring 等人.  [[pdf]](https://arxiv.org/pdf/1705.03122)
 - 基于知识的神经对话模型 (2017)，Marjan Ghazvininejad 等.  [[pdf]](https://arxiv.org/pdf/1702.01932)
 - 准确的大型 Minibatch SGD：在 1 小时内训练 ImageNet（2017 年），Priya Goyal 等人.  [[pdf]](https://research.fb.com/wp-content/uploads/2017/06/imagenet1kin1h3.pdf)
 - TACOTRON：走向端到端语音合成（2017 年），Y. Wang 等人.  [[pdf]](https://arxiv.org/pdf/1703.10135.pdf)
 - Deep Photo Style Transfer (2017)，F. Luan 等人.  [[pdf]](http://arxiv.org/pdf/1703.07511v1.pdf)
 - 作为强化学习的可扩展替代方案的进化策略 (2017)，T. Salimans 等人.  [[pdf]](http://arxiv.org/pdf/1703.03864v1.pdf)
 - 可变形卷积网络 (2017)，J. Dai 等人.  [[pdf]](http://arxiv.org/pdf/1703.06211v2.pdf)
 - Mask R-CNN (2017)，K. He 等人.  [[pdf]](https://128.84.21.199/pdf/1703.06870)
 - 学习发现与生成对抗网络的跨域关系 (2017)，T. Kim 等人.  [[pdf]](http://arxiv.org/pdf/1703.05192v1.pdf) 
- Deep voice：实时神经文本转语音 (2017)，S. Arik 等人，[[pdf]](http://arxiv.org/pdf/1702.07825v2.pdf)
 - PixelNet：像素表示、像素表示和像素表示 (2017)，A. Bansal 等人.  [[pdf]](http://arxiv.org/pdf/1702.06506v1.pdf)
 - 批量重归一化：减少批量归一化模型中的小批量依赖（2017 年），S. Ioffe.  [[pdf]](https://arxiv.org/abs/1702.03275)
 - Wasserstein GAN (2017)，M. Arjovsky 等人.  [[pdf]](https://arxiv.org/pdf/1701.07875v1)
 - 理解深度学习需要重新思考泛化 (2017)，C. Zhang 等人.  [[pdf]](https://arxiv.org/pdf/1611.03530)
 - 最小二乘生成对抗网络 (2016)，X. Mao 等人.  [[pdf]](https://arxiv.org/abs/1611.04076v2)


### Old Papers
*2012年以前发表的经典论文*
 - 无监督特征学习中单层网络的分析 (2011)，A. Coates 等.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/AISTATS2011_CoatesNL11.pdf)
 - 深度稀疏整流器神经网络 (2011)，X. Glorot 等.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/AISTATS2011_GlorotBB11.pdf)
 - 自然语言处理（几乎）从零开始（2011 年），R. Collobert 等人.  [[pdf]](http://arxiv.org/pdf/1103.0398)
 - 基于循环神经网络的语言模型 (2010)，T. Mikolov 等人.  [[pdf]](http://www.fit.vutbr.cz/research/groups/speech/servite/2010/rnnlm_mikolov.pdf)
 - 堆叠式去噪自动编码器：在具有局部去噪标准的深度网络中学习有用的表示（2010 年），P. Vincent 等人.  [[pdf]](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.297.3484&amp;rep=rep1&amp;type=pdf)
- Learning mid-level features for recognition (2010), Y. Boureau [[pdf]](http://ece.duke.edu/~lcarin/boureau-cvpr-10.pdf)；
- 训练受限玻尔兹曼机的实用指南 (2010)，G. Hinton [[pdf]](http://www.csri.utoronto.ca/~hinton/absps/guideTR.pdf)
- 了解训练深度前馈神经网络的难度 (2010)，X. Glorot 和 Y. Bengio [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/AISTATS2010_GlorotB10.pdf)
 - 为什么无监督预训练有助于深度学习 (2010)，D. Erhan 等人.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/AISTATS2010_ErhanCBV10.pdf)
 - 学习人工智能的深度架构（2009 年），Y. Bengio.  [[pdf]](http://saghv.com/download/soft/machine%20learning,%20artificial%20intelligence,%20mathematics%20ebooks/ML/learning%20deep%20architectures%20for%20AI%20(2009).pdf )
 - 用于分层表示的可扩展无监督学习的卷积深度信念网络 (2009)，H. Lee 等人.  [[pdf]](http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.149.802&amp;rep=rep1&amp;type=pdf)
 - 深度网络的贪婪分层训练 (2007)，Y. Bengio 等人.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/NIPS2006_739.pdf)
 - 使用神经网络降低数据维度，G. Hinton 和 R. Salakhutdinov.  [[pdf]](http://homes.mpimf-heidelberg.mpg.de/~mhelmsta/pdf/2006%20Hinton%20Salakhudtkinov%20Science.pdf)
 - 深度信念网络的快速学习算法 (2006)，G. Hinton 等人.  [[pdf]](http://nuyoo.utm.mx/~jjf/rna/A8%20A%20fast%20learning%20algorithm%20for%20deep%20belief%20nets.pdf)
 - 基于梯度的学习应用于文档识别 (1998)，Y. LeCun 等.  [[pdf]](http://yann.lecun.com/exdb/publis/pdf/lecun-01a.pdf)
 - 长短期记忆 (1997)，S. Hochreiter 和 J. Schmidhuber.  [[pdf]](http://www.mitpressjournals.org/doi/pdfplus/10.1162/neco.1997.9.8.1735)


### HW / SW / Dataset
-  SQuAD: 100,000+ Questions for Machine Comprehension of Text (2016), Rajpurkar et al. [[pdf]](https://arxiv.org/pdf/1606.05250.pdf)
 - OpenAI gym (2016)，G. Brockman 等人.  [[pdf]](https://arxiv.org/pdf/1606.01540)
 - TensorFlow：异构分布式系统上的大规模机器学习（2016 年），M. Abadi 等人.  [[pdf]](http://arxiv.org/pdf/1603.04467)
- Theano：用于快速计算数学表达式的 Python 框架，R. Al-Rfou 等人.
 - Torch7：用于机器学习的类似 matlab 的环境，R. Collobert 等人.  [[pdf]](https://ronan.collobert.com/pub/matos/2011_torch7_nipsw.pdf)
- MatConvNet：用于 matlab 的卷积神经网络 (2015)，A. Vedaldi 和 K. Lenc [[pdf]](http://arxiv.org/pdf/1412.4564)
 - Image Large Scale Visual Recognition Challenge (2015)，O. Russakovsky 等人.  [[pdf]](http://arxiv.org/pdf/1409.0575)
 - Caffe：用于快速特征嵌入的卷积架构（2014 年），Y. Jia 等人.  [[pdf]](http://arxiv.org/pdf/1408.5093)


### Book / Survey / Review
 - 关于深度学习的起源 (2017)，H. Wang 和 Bhiksha Raj.  [[pdf]](https://arxiv.org/pdf/1702.07800)
- 深度强化学习：概述（2017），Y. Li，[[pdf]](http://arxiv.org/pdf/1701.07274v2.pdf)
 - 神经机器翻译和序列到序列模型（2017）：教程，G. Neubig.  [[pdf]](http://arxiv.org/pdf/1703.01619v1.pdf)
 - 神经网络和深度学习（书籍，2017 年 1 月），Michael Nielsen.  [[html]](http://neuralnetworksanddeeplearning.com/index.html)
 - 深度学习（书籍，2016 年），Goodfellow 等人.  [[html]](http://www.deeplearningbook.org/)
 - LSTM：太空漫游 (2016)，K. Greff 等人.  [[pdf]](https://arxiv.org/pdf/1503.04069.pdf?utm_content=buffereddc5&amp;utm_medium=social&amp;utm_source=plus.google.com&amp;utm_campaign=buffer)
 - 变分自编码器教程 (2016)，C. Doersch.  [[pdf]](https://arxiv.org/pdf/1606.05908)
- 深度学习 (2015)，Y. LeCun、Y. Bengio 和 G. Hinton [[pdf]](https://www.cs.toronto.edu/~hinton/absps/NatureDeepReview.pdf)
- Deep learning in neural networks: An overview (2015), J. Schmidhuber [[pdf]](http://arxiv.org/pdf/1404.7828)
 - 表示学习：回顾和新观点（2013 年），Y. Bengio 等人.  [[pdf]](http://arxiv.org/pdf/1206.5538)

### Video Lectures / Tutorials / Blogs

*(Lectures)*
- CS231n，用于视觉识别的卷积神经网络，斯坦福大学 [[web]](http://cs231n.stanford.edu/)
- CS224d, Deep Learning for Natural Language Processing, Stanford University [[web]](http://cs224d.stanford.edu/)
- Oxford Deep NLP 2017，牛津大学自然语言处理深度学习 [[web]](https://github.com/oxford-cs-deepnlp-2017/lectures)

*(Tutorials)*
- NIPS 2016 教程，长滩 [[web]](https://nips.cc/Conferences/2016/Schedule?type=Tutorial)
- ICML 2016 教程，纽约市 [[web]](http://techtalks.tv/icml/2016/tutorials/)
- ICLR 2016 视频，圣胡安 [[web]](http://videolectures.net/iclr2016_san_juan/)
- 深度学习暑期学校 2016，蒙特利尔 [[web]](http://videolectures.net/deeplearning2016_montreal/)
- 湾区深度学习学校 2016，斯坦福 [[web]](https://www.bayareadlschool.org/)

*(Blogs)*
- OpenAI [[网络]](https://www.openai.com/)
- 提炼 [[web]](http://distill.pub/)
- Andrej Karpathy 博客 [[web]](http://karpathy.github.io/)
- Colah 的博客 [[Web]](http://colah.github.io/)
- WildML [[Web]](http://www.wildml.com/)
- FastML [[网络]](http://www.fastml.com/)
- TheMorningPaper [[web]](https://blog.acolyer.org)

### Appendix: More than Top 100
*(2016)*
 - 一种没有显式神经机器翻译分割的字符级解码器 (2016)，J. Chung 等人.  [[pdf]](https://arxiv.org/pdf/1603.06147)
 - 使用深度神经网络对皮肤癌进行皮肤科医生级别的分类 (2017)，A. Esteva 等人.  [[html]](http://www.nature.com/nature/journal/v542/n7639/full/nature21056.html)
 - 具有多重多实例学习的弱监督对象定位 (2017)，R. Gokberk 等人.  [[pdf]](https://arxiv.org/pdf/1503.00949)
 - 使用深度神经网络进行脑肿瘤分割 (2017)，M. Havaei 等人.  [[pdf]](https://arxiv.org/pdf/1505.03540)
 - Forcing 教授：训练递归网络的新算法（2016 年），A. Lamb 等人.  [[pdf]](https://arxiv.org/pdf/1610.09038)
 - Adversarially learned inference (2016)，V. Dumoulin 等人.  [[web]](https://ishmaelbelghazi.github.io/ALI/)[[pdf]](https://arxiv.org/pdf/1606.00704v1)
- 了解卷积神经网络 (2016)，J. Koushik [[pdf]](https://arxiv.org/pdf/1605.09081v1)
 - 让人类脱离循环：贝叶斯优化回顾 (2016)，B. Shahriari 等.  [[pdf]](https://www.cs.ox.ac.uk/people/nando.defreitas/publications/BayesOptLoop.pdf)
- 递归神经网络的自适应计算时间（2016 年），A. Graves [[pdf]](http://arxiv.org/pdf/1603.08983)
 - 密集连接的卷积网络 (2016)，G. Huang 等人.  [[pdf]](https://arxiv.org/pdf/1608.06993v1)
- 用于精确对象检测和分割的基于区域的卷积网络 (2016)，R. Girshick 等人. 
 - 基于模型的加速连续深度 q 学习（2016 年），S. Gu 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v48/gu16.pdf)
 - 彻底检查 cnn/每日邮件阅读理解任务 (2016)，D. Chen 等人.  [[pdf]](https://arxiv.org/pdf/1606.02858)
 - 使用混合词字符模型实现开放词汇神经机器翻译，M. Luong 和 C. Manning.  [[pdf]](https://arxiv.org/pdf/1604.00788)
 - 用于自然语言处理的非常深的卷积网络（2016 年），A. Conneau 等人.  [[pdf]](https://arxiv.org/pdf/1606.01781)
 - Bag of tricks for efficient text classification (2016)，A. Joulin 等人.  [[pdf]](https://arxiv.org/pdf/1607.01759)
 - 用于语义分割的深度结构化模型的高效分段训练（2016 年），G. Lin 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Lin_Efficient_Piecewise_Training_CVPR_2016_paper.pdf)
 - Learning to compose neural networks for question answering (2016)，J. Andreas 等人.  [[pdf]](https://arxiv.org/pdf/1601.01705)
 - 实时风格转移和超分辨率的感知损失 (2016)，J. Johnson 等人.  [[pdf]](https://arxiv.org/pdf/1603.08155)
 - 使用卷积神经网络在野外阅读文本 (2016)，M. Jaderberg 等人.  [[pdf]](http://arxiv.org/pdf/1412.1842)
 - 什么是有效的检测建议？  (2016)，J. Hosang 等人.  [[pdf]](https://arxiv.org/pdf/1502.05082)
 - Inside-outside net: Detecting objects in context with skip pooling and recurrent neural networks (2016), S. Bell 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Bell_Inside-Outside_Net_Detecting_CVPR_2016_paper.pdf).
 - 通过多任务网络级联进行实例感知语义分割 (2016)，J. Dai 等.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2016/papers/Dai_Instance-Aware_Semantic_Segmentation_CVPR_2016_paper.pdf)
 - 使用 pixelcnn 解码器生成条件图像 (2016)，A. van den Oord 等人.  [[pdf]](http://papers.nips.cc/paper/6527-tree-structured-reinforcement-learning-for-sequential-object-localization.pdf)
- 具有随机深度的深度网络 (2016)，G. Huang 等人，[[pdf]](https://arxiv.org/pdf/1603.09382)
 - 随机梯度 Langevin 动力学的一致性和波动 (2016)，Yee Whye Teh 等.  [[pdf]](http://www.jmlr.org/papers/volume17/teh16a/teh16a.pdf)

*(2015)*
 - 问你的神经元：一种基于神经的方法来回答有关图像的问题（2015 年），M. Malinowski 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/Malinowski_Ask_Your_Neurons_ICCV_2015_paper.pdf)
 - Exploring models and data for image question answering (2015)，M. Ren 等人.  [[pdf]](http://papers.nips.cc/paper/5640-stochastic-variational-inference-for-hidden-markov-models.pdf)
 - 你在和机器说话吗？ 多语言图像问题的数据集和方法 (2015)，H. Gao 等人.  [[pdf]](http://papers.nips.cc/paper/5641-are-you-talking-to-a-machine-dataset-and-methods-for-multilingual-image-question.pdf)
 - 心灵之眼：图像标题生成的循环视觉表示（2015 年），X. Chen 和 C. Zitnick.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Chen_Minds_Eye_A_2015_CVPR_paper.pdf)
 - 从字幕到视觉概念再返回 (2015)，H. Fang 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Fang_From_Captions_to_2015_CVPR_paper.pdf).
 - 实现 AI 完整问答：一组前提玩具任务（2015 年），J. Weston 等人.  [[pdf]](http://arxiv.org/pdf/1502.05698)
 - 问我任何问题：用于自然语言处理的动态记忆网络（2015 年），A. Kumar 等人.  [[pdf]](http://arxiv.org/pdf/1506.07285)
 - 使用 LSTM (2015) 对视频表示进行无监督学习，N. Srivastava 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v37/srivastava15.pdf)
 - 深度压缩：通过修剪、训练有素的量化和霍夫曼编码压缩深度神经网络 (2015)，S. Han 等人.  [[pdf]](https://arxiv.org/pdf/1510.00149)
 - 改进了树结构长短期记忆网络的语义表示（2015 年），K. Tai 等人.  [[pdf]](https://arxiv.org/pdf/1503.00075)
 - 字符感知神经语言模型 (2015)，Y. Kim 等人.  [[pdf]](https://arxiv.org/pdf/1508.06615)
 - 语法作为外语（2015），O. Vinyals 等.  [[pdf]](http://papers.nips.cc/paper/5635-grammar-as-a-foreign-language.pdf)
 - 信任区域策略优化 (2015)，J. Schulman 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v37/schulman15.pdf)
- 超越短片：视频分类的深度网络 (2015) [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2015/papers/Ng_Beyond_Short_Snippets_2015_CVPR_paper.pdf)
 - Learning Deconvolution Network for Semantic Segmentation (2015)，H. Noh 等人.  [[pdf]](https://arxiv.org/pdf/1505.04366v1)
 - 使用 3d 卷积网络学习时空特征 (2015)，D. Tran 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/Tran_Learning_Spatiotemporal_Features_ICCV_2015_paper.pdf)
 - 通过深度可视化了解神经网络 (2015)，J. Yosinski 等人.  [[pdf]](https://arxiv.org/pdf/1506.06579)
 - 循环网络架构的实证探索（2015 年），R. Jozefowicz 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v37/jozefowicz15.pdf)
 - 使用对抗网络拉普拉斯金字塔的深度生成图像模型 (2015)，E.Denton 等人.  [[pdf]](http://papers.nips.cc/paper/5773-deep-generative-image-models-using-a-laplacian-pyramid-of-adversarial-networks.pdf)
 - 门控反馈循环神经网络 (2015)，J. Chung 等人.  [[pdf]](http://www.jmlr.org/proceedings/papers/v37/chung15.pdf)
 - 通过指数线性单元 (ELUS) 快速准确地进行深度网络学习 (2015)，D. Clevert 等人.  [[pdf]](https://arxiv.org/pdf/1511.07289.pdf%5Cnhttp://arxiv.org/abs/1511.07289%5Cnhttp://arxiv.org/abs/1511.07289)
 - 指针网络 (2015)，O. Vinyals 等.  [[pdf]](http://papers.nips.cc/paper/5866-pointer-networks.pdf)
 - Visualizing and Understanding Recurrent Networks (2015), A. Karpathy 等人.  [[pdf]](https://arxiv.org/pdf/1506.02078)
 - 基于注意力的语音识别模型（2015 年），J. Chorowski 等人.  [[pdf]](http://papers.nips.cc/paper/5847-attention-based-models-for-speech-recognition.pdf)
 - 端到端记忆网络 (2015)，S. Sukbaatar 等人.  [[pdf]](http://papers.nips.cc/paper/5846-end-to-end-memory-networks.pdf)
 - Describing videos by exploiting temporal structure (2015)，L. Yao 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_iccv_2015/papers/Yao_Describing_Videos_by_ICCV_2015_paper.pdf)
 - 神经对话模型 (2015)，O. Vinyals 和 Q. Le.  [[pdf]](https://arxiv.org/pdf/1506.05869.pdf)
 - 通过从词嵌入中吸取的经验教训提高分布相似性，O. Levy 等人.  [[pdf]] (https://www.transacl.org/ojs/index.php/tacl/article/download/570/124)
 - 使用 Stack Long Short-Term Memory（2015）的基于转换的依赖解析，C. Dyer 等.  [[pdf]](http://aclweb.org/anthology/P/P15/P15-1033.pdf)
 - 通过使用 LSTM 对字符建模而不是单词来改进基于转换的解析（2015 年），M. Ballesteros 等人.  [[pdf]](http://aclweb.org/anthology/D/D15/D15-1041.pdf)
 - Finding function in form: Compositional character models for open vocabulary word representation (2015), W. Ling 等人.  [[pdf]](http://aclweb.org/anthology/D/D15/D15-1176.pdf)


*(~2014)*
- DeepPose：通过深度神经网络进行人体姿态估计 (2014)，A. Toshev 和 C. Szegedy [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2014/papers/Toshev_DeepPose_Human_Pose_2014_CVPR_paper.pdf)
- Learning a Deep Convolutional Network for Image Super-Resolution (2014, C. Dong et al. [[pdf]](https://www.researchgate.net/profile/Chen_Change_Loy/publication/264552416_Lecture_Notes_in_Computer_Science/links/53e583e50cf25d674e9c280e.pdf)
 - 视觉注意力的循环模型 (2014)，V. Mnih 等人.  [[pdf]](http://arxiv.org/pdf/1406.6247.pdf)
- Empirical evaluation of gated recurrent neural networks on sequence modeling (2014), J. Chung et al. [[pdf]](https://arxiv.org/pdf/1412.3555)
 - 解决神经机器翻译中的罕见词问题（2014 年），M. Luong 等人.  [[pdf]](https://arxiv.org/pdf/1410.8206)
 - 关于神经机器翻译的特性：编码器-解码器方法 (2014)，K. Cho 等. 阿尔.
 - 递归神经网络正则化 (2014)，W. Zaremba 等人.  [[pdf]](http://arxiv.org/pdf/1409.2329)
 - 神经网络的有趣特性 (2014)，C. Szegedy 等人.  [[pdf]](https://arxiv.org/pdf/1312.6199.pdf)
 - 使用递归神经网络实现端到端语音识别（2014 年），A. Graves 和 N. Jaitly.  [[pdf]](http://www.jmlr.org/proceedings/papers/v32/graves14.pdf)
 - 使用深度神经网络的可扩展对象检测 (2014)，D. Erhan 等人.  [[pdf]](http://www.cv-foundation.org/openaccess/content_cvpr_2014/papers/Erhan_Scalable_Object_Detection_2014_CVPR_paper.pdf)
 - 关于深度学习中初始化和动量的重要性（2013 年），I. Sutskever 等人.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/icml2013_sutskever13.pdf)
 - 使用 dropconnect (2013)，L. Wan 等人对神经网络进行正则化.  [[pdf]](http://machinelearning.wustl.edu/mlpapers/paper_files/icml2013_wan13.pdf)
 - Learning Hierarchical Features for Scene Labeling (2013)，C. Farabet 等人.  [[pdf]](https://hal-enpc.archives-ouvertes.fr/docs/00/74/20/77/PDF/farabet-pami-13.pdf)
- Linguistic Regularities in Continuous Space Word Representations (2013), T. Mikolov et al. [[pdf]](http://www.aclweb.org/anthology/N13-1#page=784)
 - 大规模分布式深度网络 (2012)，J. Dean 等人.  [[pdf]](http://papers.nips.cc/paper/4687-large-scale-distributed-deep-networks.pdf)
- A Fast and Accurate Dependency Parser using Neural Networks. Chen and Manning. [[pdf]](http://cs.stanford.edu/people/danqi/papers/emnlp2014.pdf)



## Acknowledgement

感谢您的所有贡献. 请务必阅读 [contributing guide](https://github.com/terryum/awesome-deep-learning-papers/blob/master/Contributing.md) 在你提出拉取请求之前.

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Terry T. Um](https://www.facebook.com/terryum.io/) 已放弃该作品的所有版权和相关或邻接权.
