<div class="github-widget" data-repo="numetriclabz/awesome-db"></div>
太棒了 - 分贝 [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
=========
精选的令人惊叹的数据库库、资源和闪亮事物的列表 [Numetric Technologies](https://www.numetriclabz.com/)

## Clojure

 * [Datomic](http://www.datomic.com/)
 * [clojure.jdbc](https://github.com/niwibe/clojure.jdbc)
 * [cravendb](https://github.com/robashton/cravendb)

## C / CPP
* [Aerospike](https://github.com/aerospike/aerospike-server) - Aerospike 数据库服务器——闪存优化、内存中、nosql 数据库
* [Alchemy-Database](https://github.com/JakSprats/Alchemy-Database) - AlchemyDB 现在是 Aerospike
* [cstore_fdw](https://github.com/citusdata/cstore_fdw) - 用于使用 PostgreSQL 进行分析的快速柱状存储 [website](http://citusdata.github.io/cstore_fdw/)
* [LMDB](http://symas.com/mdb/) - 具有完整 ACID 语义的非常快速的嵌入式键/值存储.
* [memcache](https://github.com/memcached/memcached) - 免费开源、高性能、分布式内存对象缓存系统
* [monetdb](https://github.com/snaga/monetdb) - [website](https://www.monetdb.org/)
* [mongo](https://github.com/mongodb/mongo) - Mongo 数据库 http://www.mongodb.org/
* [facebook/mysql-5.6](https://github.com/facebook/mysql-5.6) - Facebook 的 Oracle MySQL v5.6 数据库分支
* [twitter/mysql](https://github.com/twitter/mysql) - 在 Twitter 上维护和使用的 MySQL 分支 https://github.com/twitter/mysql/wiki
* [postgres](https://github.com/postgres/postgres)
* [Redis](https://github.com/antirez/redis)  - Redis 是一个持久存在于磁盘上的内存数据库. 数据模型是键值对，但支持许多不同类型的值：字符串、列表、集合、排序集合、哈希 [website](http://redis.io)
* [redis-nds](https://github.com/mpalmer/redis/tree/nds-2.6)  - 这是为实现 NDS（朴素磁盘存储）而打补丁的 Redis 版本. 有关此功能的文档包含在 README.nds 中.
* [rethinkdb](https://github.com/rethinkdb/rethinkdb)  - 一个开源分布式 JSON 文档数据库，具有令人愉悦且功能强大的查询语言.  http://www.rethinkdb.com
* [rocksdb](https://github.com/facebook/rocksdb) - 用于快速存储的嵌入式键值存储 http://rocksdb.org
* [ssdb](https://github.com/ideawu/ssdb) - SSDB - 一个快速的 NoSQL 数据库，Redis 的替代品 http://ssdb.io
* [SQLite](http://www.sqlite.org/) - 一个完全嵌入式、功能齐全的关系数据库，大小为几十万，您可以将其直接包含到您的项目中.
* [tokudb-engine](https://github.com/Tokutek/tokudb-engine)- TokuDB 是用于 MySQL 和 MariaDB 的高性能、写入优化、压缩、事务存储引擎
* [TokuMX](https://github.com/Tokutek/mongo)- TokuMX 是 MongoDB 的高性能、并发、压缩、直接替换引擎
* [VoltDB](https://github.com/VoltDB/voltdb/) - VoltDB 是一种可水平扩展的内存中 SQL RDBMS，专为具有极高读写吞吐量要求的应用程序而设计.


## dot-net

* [RavenDB](https://github.com/ravendb/ravendb) - 支持 .NET 的 linq 文档数据库 http://ayende.com/Blog/
* [OrigoDB](http://dev.origodb.com) - 用于 NET/Mono 的内存嵌入式数据库引擎

## Erlang

* [riak](https://github.com/basho/riak) - Riak 是 Basho Technologies 的分散式数据存储.
* [Pulsedb](http://pulsedb.io) - Pulsedb 是一个时间序列数据库服务器和库.

## Go-lang

* [bolt](https://github.com/boltdb/bolt) - Go 的低级键/值数据库.
* [diskv](https://github.com/peterbourgon/diskv) - 本地磁盘支持的键值存储.
* [go-cache](https://github.com/pmylund/go-cache) - 用于 Go 的内存中键：值存储/缓存（类似于 Memcached）库，适用于单机应用程序.
* [goleveldb](https://github.com/syndtr/goleveldb) - 的实施 [LevelDB](https://code.google.com/p/leveldb/) Go 中的键/值数据库.
* [groupcache](https://github.com/golang/groupcache) - Groupcache 是一个缓存和缓存填充库，在许多情况下旨在替代 memcached.
* [influxdb](https://github.com/influxdb/influxdb) - 用于指标、事件和实时分析的可扩展数据存储
* [ledisdb](https://github.com/siddontang/ledisdb) - Ledisdb 是基于 LevelDB 的类似 Redis 的高性能 NoSQL.
* [roshi](https://github.com/soundcloud/roshi/) - Roshi 是用于时间戳事件的大规模 CRDT 集实现.
* [skydb.io](https://github.com/skydb/sky) - Sky 是一个开源数据库，用于对行为数据进行灵活、高性能的分析.
* [tiedot](https://github.com/HouzuoGuo/tiedot) - 由 Golang 提供支持的 NoSQL 数据库.



## JAVA
* [cassandra](https://github.com/apache/cassandra)  - Cassandra 是一个分区行存储. 行被组织到具有所需主键的表中.
* [elasticsearch](https://github.com/elasticsearch/elasticsearch) - 开源、分布式、RESTful 搜索引擎 [website](http://elasticsearch.org)
* [lmdbjni](https://github.com/deephacks/lmdbjni) - LMDB for Java，这是一个非常快速的嵌入式键/值存储，具有完整的 ACID 语义.
* [mapdb](https://github.com/jankotek/MapDB)  - MapDB 提供由磁盘存储或堆外内存支持的并发映射、集合和队列. 它是一种快速且易于使用的嵌入式 Java 数据库引擎.http://www.mapdb.org
* [neo4j](https://github.com/neo4j/neo4j) - [Neo4j](http://neo4j.org) 是世界领先的图形数据库.
* [orientdb](https://github.com/orientechnologies/orientdb) - OrientDB 是一个开源 NoSQL DBMS，具有文档和图形 DBMS 的特性.
* [voldemort](https://github.com/voldemort/voldemort) - 亚马逊 Dynamo 的开源克隆. [website](http://project-voldemort.com)
- [Titan](https://github.com/thinkaurelius/titan) - 分布式图数据库 http://titandb.io


## Javascript
* [couchdb](https://github.com/apache/couchdb) - Apache CouchDB™ 是一个数据库，它使用 JSON 作为文档，使用 JavaScript 作为 MapReduce 索引，并使用常规 HTTP 作为其 API [网站] (http://couchdb.apache.org/)
* [mongodb](https://github.com/mongodb/mongo)  - MongoDB 是一个提供高性能、高可用性和易扩展性的文档数据库. 文档（对象）很好地映射到编程语言数据类型. 嵌入式文档和数组减少了对连接的需求. 动态模式使多态更容易.  [网站] (https://www.mongodb.org/)



## Scala
* [BlinkDB](https://github.com/sameeragarwal/blinkdb) - BlinkDB：​​超大数据的亚秒级近似查询 [网站] (http://blinkdb.cs.berkeley.edu/)

## Research Papers
* [db-readings](https://github.com/rxin/db-readings) - 了解数据库和构建新数据系统所必需的论文清单
