<div class="github-widget" data-repo="javierluraschi/awesome-dataviz"></div>
## Awesome Dataviz
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) ![Test](https://github.com/javierluraschi/awesome-dataviz/actions/workflows/main.yaml/badge.svg)


很棒的**开源**数据可视化框架、库和软件的精选列表. 灵感来自 [awesome-python](https://github.com/vinta/awesome-python) 最初由 [fasouto](https://github.com/fasouto).



## JavaScript tools

### Charting libraries
- [ApexCharts](https://apexcharts.com/) - 现代和交互式 SVG 图表.
- [Chart.js](https://www.chartjs.org/) - 带有画布标签的图表.
- [Chartist.js](https://gionkunz.github.io/chartist-js/) - 具有良好浏览器兼容性的响应式图表.
- [dc.js](https://github.com/dc-js/dc.js) 是一个多维图表，旨在与 crossfilter 一起本地工作.
- [Dygraphs](https://dygraphs.com/) - 适用于庞大数据集的交互式折线图库.
- [Echarts](https://github.com/ecomfe/echarts) - 为大数据集准备的高度可定制和交互式图表.
- [Epoch](https://github.com/epochjs/epoch) - 完美创建实时图表.
- [Google Charts](https://developers.google.com/chart) - 浏览器和移动设备的交互式图表.
- [G2](https://g2plot.antv.vision/en) - 基于图形语法的交互式响应式图表库，由阿里巴巴维护
- [GraphicsJS](http://www.graphicsjs.org) - 基于 SVG/VML 的具有直观 API 的轻量级 JS 图形库.
- [lit-line](https://github.com/apinet/lit-line) - SVG Line Chart Web Component - light, fast, interactive & fully responsive.
- [MetricsGraphics.js](https://metricsgraphicsjs.org/) - 针对时间序列数据进行了优化.
- [NVD3](https://github.com/novus/nvd3) - 用 d3.js 编写的可重用图表库.
- [Plotly.js](https://github.com/plotly/plotly.js/) - 强大的声明式库，支持 20 种图表类型.
- [React wrapper](https://github.com/hustcc/echarts-for-react)
- [TechanJS](https://techanjs.org/) - 股票和金融图表.
- [TOAST UI Chart](https://github.com/nhnent/tui.chart) - 支持旧版浏览器的完整库.
- [Vizzu](https://github.com/vizzuhq/vizzu-lib) - 用于动画数据可视化和数据故事的库.

### Charting libraries for graphs
- [Cola.js](https://marvl.infotech.monash.edu/webcola/)  - 使用基于约束的优化技术创建图表的工具. 适用于 d3 和 svg.js.
- [Cytoscape.js](https://js.cytoscape.org/) - 用于图形绘制的 JavaScript 库由 [Cytoscape](https://www.cytoscape.org) 核心开发人员.
- [Sigma.js](https://sigmajs.org/) - 专门用于图形绘制的 JavaScript 库.
- [VivaGraph](https://github.com/anvaka/VivaGraphJS) - JavaScript 的图形绘制库.
- [G6](https://github.com/antvis/g6) - 基于 Javascript 和 Typescript 的图形可视化库，由阿里巴巴维护
- [diagram.js](https://github.com/bpmn-io/diagram-js) - 作为 camunda 在线 BPMN 建模器基础的 Javascript 图表库.
- [Uber React Digraph](https://github.com/uber/react-digraph) - 由 UBER 维护的基于 React.js 的有向图库.

### Maps
- [CARTO](https://github.com/CartoDB/cartodb) - CARTO 是一个开源工具，允许在网络上存储和可视化地理空间数据.
- [Cesium](https://github.com/AnalyticalGraphicsInc/cesium) - WebGL 3D 地球仪和地图.
- [Deck.gl](https://deck.gl/) - 用于大型数据集可视化探索性数据分析的 WebGL 框架.
- [L7](https://github.com/antvis/L7) - 由阿里巴巴维护的大规模 WebGL 驱动的地理空间数据可视化分析框架
- [L7 Plot](https://github.com/antvis/L7Plot) - 阿里巴巴维护的地理空间可视化图表库
- [DataMaps](https://github.com/markmarkoh/datamaps) - 使用 D3.js 的交互式 SVG 地图.
- [Dipper](https://github.com/antvis/dipper) - 基于L7的地图应用开发框架，由阿里巴巴维护.
- [Leaflet](https://leafletjs.com) - 适用于移动设备的交互式地图的 JavaScript 库.
- [Mapael](https://github.com/neveldo/jQuery-Mapael) - 基于 raphael.js 的 jQuery 插件，用于显示矢量地图.

### d3
- 看 [Awesome D3](https://github.com/wbkd/awesome-d3)

### React
- [BizCharts](https://github.com/alibaba/BizCharts) - 基于数据可视化库 [G2](https://github.com/antvis/G2) 和反应
- [Graphin](https://github.com/antvis/Graphin) - 基于 React 和 Typescript 的图形可视化库（建立在 G6 之上，由阿里巴巴维护.
- [React-vis](https://github.com/uber/react-vis) - 反应组件以构建数据可视化.
- [Recharts](https://github.com/recharts/recharts) - 声明式反应组件以呈现 D3 图表.
- [Victory](https://formidable.com/open-source/victory/) - 用于构建交互式数据可视化的可组合组件
- [nivo](https://github.com/plouc/nivo) - 具有同构能力的 React 增压数据可视化组件， [demo](https://nivo.rocks).
- [React Svg Textures](https://github.com/finnfiddle/react-svg-textures)  - Textures.js 移植到 React. 完全同构.
- [DevExtreme React Chart](https://devexpress.github.io/devextreme-reactive/react/chart/) - 用于 Bootstrap 和 Material Design 的高性能基于插件的 React 图表.

## React Native
- [F2](https://github.com/antvis/F2) - 由阿里巴巴维护的优雅、交互式和灵活的移动图表库

### Misc
- [Graphology](https://github.com/graphology/graphology)  - 用于 javascript 和 TypeScript 的强大且多用途的 Graph 对象； 作为基础库为其他图形可视化库提供支持.
- [Piecon](https://github.com/lipka/piecon) - 您的网站图标中的饼图.
- [Textures.js](https://riccardoscalco.github.io/textures/) - 创建 SVG 模式的库.
- [Timeline.js](https://timeline.knightlab.com/) - 创建交互式时间表.
- [Vega](https://vega.github.io/vega/) - Vega 是一种可视化语法，一种用于创建、保存和共享交互式可视化设计的声明式格式.
- [Vega-Lite](https://vega.github.io/vega-lite/)  - 是交互式图形的高级语法. 它提供了一种简洁的 JSON 语法，用于快速生成可视化以支持分析.
- [Vis.js](https://visjs.org/) - 动态可视化库，包括时间线、网络和图形（2D 和 3D）.

## Android tools
- [DecoView](https://github.com/bmarrdev/android-DecoView-charting) - 动画圆轮图表库.
- [MPAndroidChart](https://github.com/PhilJay/MPAndroidChart) - 一个强大且易于使用的图表库.
- [WilliamChart](https://github.com/diogobernardino/WilliamChart) - 简单的图表库.

## C++ tools
- [LargeVis](https://github.com/lferry007/LargeVis) - 实施 [LargeVis paper](https://arxiv.org/abs/1602.00370)，用于可视化大规模和高维数据.
- [PlotJuggler](https://github.com/facontidavide/PlotJuggler) - 用于绘制图表的开源 Qt5 应用程序（基于 Qwt）.
- [Visualization Toolkit (VTK)](https://gitlab.kitware.com/vtk/vtk/blob/master/README.md) - 用于 3d 图形、图像处理和可视化的开源库.

## Golang tools
- [svgo](https://github.com/ajstarks/svgo) - 用于生成 SVG 的 Go 语言库.
- [plot](https://github.com/gonum/plot) - 用于在 Go 中构建和绘图的 API.
- [go-echars](https://github.com/chenjiandongx/go-echarts) - 简单而强大的 Go 数据可视化库.

## iOS tools
- [BEMSimpleLineGraph](https://github.com/Boris-Em/BEMSimpleLineGraph) - 高度可定制和交互式的线图.
- [Charts](https://github.com/danielgindi/Charts)  - MPAndroidChart 的 iOS 端口. 您可以使用非常相似的代码为两个平台创建图表.
- [JBChartView](https://github.com/Jawbone/JBChartView) - 折线图和条形图的图表库.
- [PNChart](https://github.com/kevinzhow/PNChart) - 一个简单而漂亮的图表库，用于 Piner 和 CoinsMan.

## Machine Learning tools
- [TensorWatch](https://github.com/microsoft/tensorwatch) - 用于数据科学和机器学习的调试和可视化工具

## Python tools
- [altair](https://altair-viz.github.io/) - 基于 Vega-Lite 的声明性统计可视化.
- [bokeh](https://bokeh.pydata.org/en/latest/) - Python 的交互式网络绘图.
- [Chartify](https://github.com/spotify/chartify) - Bokeh 包装器，使数据科学家可以轻松创建图表.
- [diagram](https://github.com/tehmaze/diagram) - 使用 UTF-8 字符的文本模式图表
- [ggplot](https://github.com/yhat/ggpy) - 基于绘图系统 [R's](#r-tools) ggplot2.
- [glumpy](https://github.com/glumpy/glumpy) - OpenGL 科学可视化库.
- [holoviews](https://holoviews.org/) - 来自注释数据的复杂和声明性可视化.
- [ipychart](https://github.com/nicohlr/ipychart) - Jupyter Notebook 中 Chart.js 的强大功能.
- [mayai](https://docs.enthought.com/mayavi/mayavi/) - Python 中的交互式科学数据可视化和 3D 绘图.
- [matplotlib](https://matplotlib.org/) - 二维绘图库.
- [missingno](https://github.com/ResidentMario/missingno) - 提供灵活的数据可视化实用工具集，允许基于 matplotlib 快速直观地总结数据集的完整性.
- [plotly](https://plot.ly/python/) - 基于交互式 Web 的可视化构建于 [plotly.js](https://github.com/plotly/plotly.js)
- [pptk](https://github.com/heremaps/pptk) - 可视化和使用 2D/3D 点云
- [PyQtGraph](https://www.pyqtgraph.org/) - 交互式和实时 2D/3D/图像绘图和科学/工程小部件.
- [PyVista](https://github.com/pyvista/pyvista) – 通过可视化工具包 (VTK) 的简化界面进行 3D 绘图和网格分析
- [seaborn](https://seaborn.pydata.org/) - 用于制作有吸引力和信息丰富的统计图形的库.
- [toyplot](https://toyplot.readthedocs.io/en/stable/) - 具有成人大小目标的儿童大小的 Python 绘图工具包.
- [three.py](https://github.com/stemkoski/three.py/)  - 易于使用的基于 PyOpenGL 的 3D 库. 受 Three.js 启发.
- [veusz](https://veusz.github.io/) - Python 多平台 GUI 绘图工具和图形库
- [VisPy](https://vispy.org/) - 基于 OpenGL 的高性能科学可视化.
- [vtk](https://www.vtk.org/) - 包含 Python 界面的 3D 计算机图形、图像处理和可视化.
- [pandas-profiling](https://github.com/pandas-profiling/pandas-profiling) - 生成具有可视化的统计分析报告，用于快速数据分析.
- [pyechars](https://github.com/pyecharts/pyecharts) - Echarts 库的 Python 绑定.

## R tools
- [ggplot2](https://ggplot2.tidyverse.org/) - 基于图形语法的绘图系统.
- [ggvis](https://ggvis.rstudio.com/) - 一个数据可视化包，其语法类似于 ggplot2，可让您创建丰富的交互式图形.
- [lattice](https://lattice.r-forge.r-project.org) - R 的网格图形
- [plotly](https://github.com/ropensci/plotly) - 交互式图表（包括向 ggplot2 输出添加交互性）、制图和简单网络图
- [rbokeh](https://hafen.github.io/rbokeh/) - R 到散景的接口.
- [rgl](https://cran.r-project.org/web/packages/rgl/index.html) - 使用 OpenGL 的 3D 可视化
- [shiny](https://shiny.rstudio.com) - 创建交互式应用程序/可视化的框架
- [visNetwork](https://datastorm-open.github.io/visNetwork/) - 交互式网络可视化

## Ruby tools
- [Chartkick](https://github.com/ankane/chartkick) - 使用一行 Ruby 创建图表.

## Markup-based tools
- [mermaidjs](https://mermaidjs.github.io/mermaid-live-editor) - 一种简单的类似 markdown 的脚本语言，用于通过 javascript 从文本生成图表
- [wavedrom.com](https://wavedrom.com/) - 从简单的文字描述中绘制您的时序图或波形

## Other tools
不依赖于特定平台或语言的工具.
- [Charted](https://github.com/mikesall/charted) - 一种图表工具，可从任何数据文件生成自动、可共享的图表.
- [Gephi](https://github.com/gephi/gephi) - 用于可视化和操作大型图形的开源平台
- [Kepler.gl](https://kepler.gl/) - 用于大规模数据集的地理空间分析工具.
- [Mermaid](https://github.com/knsv/mermaid) - 一种用于以与 markdown 类似的方式从文本生成图表和流程图的工具.
- [RAW](https://rawgraphs.io) - 从 CSV 或 Excel 文件创建 Web 可视化.
- [Spark](https://github.com/holman/spark)  - 外壳的迷你图. 它有几个 [implementations in different languages](https://github.com/holman/spark/wiki/Alternative-Implementations).
- [Visual-Insights](https://github.com/ObservedObserver/visual-insights) - 数据分析中的自动洞察提取和可视化规范.
- [X6](https://x6.antv.vision/en) - 用于快速构建DAG图、ER图、流程图等应用的图创建库，由阿里巴巴维护
- [Graphviz](https://graphviz.org/)  - 开源图形可视化命令行工具和库. 从输入文本到 SVG、PDF、交互式网络图形浏览器. 

## Resources

## Books
- [Design for Information](https://www.amazon.com/Design-Information-Introduction-Histories-Visualizations/dp/1592538061) 伊莎贝尔梅雷莱斯.
- [The Best American Infographics 2014](https://www.amazon.com/Best-American-Infographics-2014/dp/0547974515) 加雷斯库克.
- [The Grammar of Graphics](https://www.amazon.com/Grammar-Graphics-Statistics-Computing/dp/0387245448/) 利兰威尔金森着. 基本可视化理论.
- [The Visual Display of Quantitative Information](https://www.amazon.com/Visual-Display-Quantitative-Information/dp/0961392142) 爱德华·塔夫特.
- [The Wall Street Journal Guide to Information Graphics](https://www.amazon.com/Street-Journal-Guide-Information-Graphics/dp/0393347281) 通过 Dona M. Wong
- [Visualization Analysis and Design](https://www.amazon.com/Visualization-Analysis-Design-AK-Peters/dp/1466508914) 塔玛拉·芒兹纳 (Tamara Munzner) 着.
- [Interactive Data Visualization for the Web](https://chimera.labs.oreilly.com/books/1230000000345) 斯科特·默里 (Scott Murray) 着. 可供在线阅读. 专注于D3.
- [Data Visualization Toolkit](https://datavisualizationtoolkit.com) 巴雷特奥斯汀克拉克. 使用 D3、Ruby on Rails、Postgres、PostGIS 和 Leaflet.
- [Data Visualisation: A Handbook for Data Driven Design](https://www.amazon.com/Data-Visualisation-Handbook-Driven-Design/dp/1526468921/) 通过安迪柯克

## Catalogs
- [The Data Visualization Catalogue](https://www.datavizcatalogue.com) - 数据可视化方法的集合，各有利弊.
- [Data Viz Project](https://datavizproject.com)
- [The R Graph Gallery](https://www.r-graph-gallery.com)
- [From data to Viz](https://www.data-to-viz.com)
- [Chartopedia](https://www.anychart.com/chartopedia)
- [Interactive Chart Chooser](https://depictdatastudio.com/charts/) 通过描述数据工作室
- 维基百科
  - [Data visualization techniques](https://en.wikipedia.org/wiki/Data_visualization#Techniques)
  - [List of graphical methods](https://en.wikipedia.org/wiki/List_of_graphical_methods)
  - [Types of diagrams](https://en.wikipedia.org/wiki/Diagram#Gallery_of_diagram_types)
  - [Types of plots](https://en.wikipedia.org/wiki/Plot_(graphics)#Types_of_plots)
  - [Types of charts](https://en.wikipedia.org/wiki/Chart#Types)

## Podcasts
- [Data Stories](https://datastori.es/)
- [DataFramed](https://www.datacamp.com/community/podcast)
- [Data Viz Today](https://dataviztoday.com/)

## Twitter accounts
- [Alberto Cairo](https://twitter.com/albertocairo)
- [Andrei Kashcha](https://twitter.com/anvaka)
- [Benjamin Wiederkehr](https://twitter.com/datavis)
- [Jan Žák](https://twitter.com/zakjan)
- [Mara Averick](https://twitter.com/dataandme)
- [Martin Wattenberg](https://twitter.com/wattenberg)
- [Mike Bostock](https://twitter.com/mbostock)
- [Nadieh Bremer](https://twitter.com/NadiehBremer)
- [NYT Graphics](https://twitter.com/nytgraphics)
- [Visualizing](https://twitter.com/VisualizingOrg)

## Websites
- [Data For Visualization](https://dataforvisualization.com/) 博客 - 用软件开发人员眼中的数据讲故事
- [Ann K. Emery](https://annkemery.com/)的博客
- [Data Visualization Society](https://www.datavisualizationsociety.com/) - The Data Visualization Society 是一个致力于为数据可视化专业人士培养社区的组织.
- [eagereyes](https://eagereyes.org/)
- [EvergreenData](https://stephanieevergreen.com/)
- [FlowingData](https://flowingdata.com/)
- [Information is Beautiful](https://www.informationisbeautiful.net/)
- [Junk Charts](https://junkcharts.typepad.com/) - Kaiser Fung 分析了为什么某些数据化工作有效/无效
- [Lisa Rost thinks and discusses about why we dataviz](https://lisacharlotterost.github.io/)
- [Makeover Monday](https://www.makeovermonday.co.uk/) 博客 - [#MakeoverMonday](https://twitter.com/search?q=%23makeovermonday) 在推特上
- [The Open News](https://source.opennews.org/articles/) blog - Open news 不时有一些不错的dataviz相关文章
- [The Pudding](https://pudding.cool/)
- [Truth & Beauty Operations](https://truth-and-beauty.net/)
- [University of Washington Interactive Data Lab Papers](https://idl.cs.washington.edu/papers)
- [vis4.net](https://www.vis4.net/blog/) - Gregor Aisch 对可视化和数据新闻的随意思考


## Contributing

- 请先检查重复项.
- 保持描述简短、简单和公正.
- 请对每个建议进行单独提交
- 如果需要，添加一个新类别.

感谢您的建议！


## Contributors

- Fabio Souto 最初创建了这个 repo，与 Fabio 联系 [fabiosouto.me](https://fabiosouto.me/).
- [Javier Luraschi](https://github.com/javierluraschi) 是当前的维护者，他在 [Hal9](https://hal9.com).


- - -

如果您对这份自以为是的清单有任何疑问，请随时与我联系 [@javierluraschi](https://twitter.com/javierluraschi) 在推特上或 [open a GitHub issue](https://github.com/javierluraschi/awesome-dataviz/issues/new).
