<div class="github-widget" data-repo="wbkd/awesome-d3"></div>
## Awesome D3 [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

此列表跟踪有趣 [D3js](http://d3js.org) 库、插件和实用程序.
<br />我们决定不在这里列出教程、资源或概念，因为已经有一个 **[very good list of readings](https://github.com/mbostock/d3/wiki/Tutorials)** 在那里你可以检查并做出贡献.

Curators: [Moritz Klack](https://twitter.com/moklick) 和 [Christopher Möller](https://twitter.com/chrtze)  [webkid.io](http://www.webkid.io)

您还可以使用我们的交互式浏览列表 [D3 Discovery](https://d3-discovery.net/) 工具.


## Charts

- [billboard.js](https://github.com/naver/billboard.js) - 可重复使用的图表库 [条形图、线形图、区域图、环形图、饼图、阶梯图、样条图]
- [britecharts](https://github.com/britecharts/britecharts) - 客户端可重用图表库 [条形图、线形图、圆环图、迷你图、阶梯图]
- [chart-parts](https://github.com/Microsoft/chart-parts) - 一个灵活的、反应友好的、用于数据可视化的图形语法
- [cubism](https://github.com/square/cubism) - Time series visualization
- [c3](https://github.com/c3js/c3) - 可重复使用的图表库 [折线图、样条曲线、阶梯图、面积图、堆叠图、条形图、饼图、圆环图]
- [dagre-d3](https://github.com/dagrejs/dagre-d3) - 在客户端布局有向图
- [dc.js](https://github.com/dc-js/dc.js) - 对于大量数据
- [d2b](https://github.com/d2bjs/d2b) - 轴图、饼图、桑基图、旭日图的图表库
- [d3-bar](https://github.com/tj/d3-bar) - 条形图
- [d3-beeswarm](https://github.com/Kcnarf/d3-beeswarm) - 计算蜂群排列的插件
- [d3-boxplot](https://github.com/akngs/d3-boxplot) - d3js 箱线图插件
- [d3-bumps-chart](https://github.com/johnwalley/d3-bumps-chart) - 用于可视化颠簸图表的插件
- [d3-dag](https://github.com/erikbrinkman/d3-dag) - 用于可视化有向无环图的布局算法
- [d3-ez](https://github.com/jamesleesaunders/d3-ez) - 易于重复使用的 D3 图表和组件 [条形图、圆环图、饼图、气泡图、玫瑰图、热图]
- [d3-flame-graph](https://github.com/spiermar/d3-flame-graph) - 来自分层数据的火焰图
- [d3-funnel](https://github.com/jakezatecky/d3-funnel) - 漏斗图和金字塔图表库
- [d3-gridding](https://github.com/romsson/d3-gridding) - 使用网格的图表模型
- [d3-heatmap](https://github.com/tj/d3-heatmap) - 热图
- [d3-message-sequence](https://github.com/koudelka/d3-message-sequence) - 动态/静态消息序列图
- [d3-upset](https://github.com/chuntul/d3-upset) - 绘制 UpSet 图的函数 [upset, bar, intersections, venn, relationships]
- [d3-x3d](https://github.com/jamesleesaunders/d3-x3d) - 使用 D3 和 X3D 的数据驱动 3D 图表 [气泡、条形图、表面积、散点图、面积]
- [d3fc](https://github.com/d3fc/d3fc) - 交互式图表组件的集合 [折线图、条形图、堆积图、散点图、烛台图、ohlc]
- [d3plus](https://github.com/alexandersimoes/d3plus) - 用于轻松创建可视化效果的扩展库 [散点图、堆叠图、线图、条形图、饼图、网络图、气泡图、框图、地图]
- [d3panels](https://github.com/kbroman/d3panels) - 带有链接刷牙的交互式图表[点、散点、线、热图、直方图]
- [d3pie](https://github.com/benkeen/d3pie) - 可配置的饼图库和生成器
- [D3xter](https://github.com/NathanEpstein/D3xter) - 直接绘图 [情节、时间线、条形图、直方图、饼图]
- [D4](https://github.com/heavysixer/d4) - 可重复使用的图表 DSL [条形图、环形图、折线图、散点图、堆叠图、瀑布图]
- [dTree](https://github.com/ErikGartner/dTree) - 家谱库
- [EventDrops](https://github.com/marmelab/EventDrops) - 基于时间/事件系列的交互式可视化
- [metrics-graphics](https://github.com/metricsgraphics/metrics-graphics) - 针对时间序列数据的可视化进行了优化 [line, scatter, area]
- [micropolar](https://github.com/biovisualize/micropolar/) - 一个极地海图库
- [mpld3](https://github.com/mpld3/mpld3) - 导出 matplotlib 图形以在浏览器中工作
- [neo4jd3](https://github.com/eisman/neo4jd3) - Neo4j 图形可视化
- [nvd3](https://github.com/novus/nvd3) - 可重复使用的图表和图表组件 [箱形图、对接图、烛台、折线图、条形图、饼图、散点图、迷你图]
- [oecd-simple-charts](https://github.com/oecd-cyc/oecd-simple-charts) - 简单的图表库[箱形图、堆积条形图、珍珠图]
- [plotly.js](https://github.com/plotly/plotly.js/) - 高级图表库 [散点图、折线图、条形图、饼图、箱线图、直方图、热图]
- [plottable](https://github.com/palantir/plottable) - 灵活的交互式网络图表 [区域、条形图、折线图、饼图、散点图、堆叠图]
- [rickshaw](https://github.com/shutterstock/rickshaw) - 用于创建交互式实时图形的工具包 [折线图、散点图、条形图]
- [taucharts](https://github.com/TargetProcess/tauCharts) - 专注于设计和灵活性的图表 [折线图、条形图、面积图、堆叠图]
- [vega](https://github.com/vega/vega) - 可视化语法
- [vega-lite](https://github.com/vega/vega-lite) - 交互式图形的高级语法
- [vega-lite-api](https://github.com/vega/vega-lite-api) - Vega-Lite 的 JavaScript API.
- [venn.js](https://github.com/benfred/venn.js) - 面积比例维恩图和欧拉图
- [visavail](https://github.com/flrs/visavail) - 时间数据可用性可视化
- [vizabi](https://github.com/vizabi/vizabi) - 构建可视化数据探索工具的框架[bubble, map, line, bar, sankey, donut]
- [WebCola](https://github.com/tgdwyer/WebCola) - 图形可视化和探索的布局
- [xkcdgraphs](https://github.com/imkevinxu/xkcdgraphs) - Xkcd 样式图 [线]

##### Third Party

- [Layer Cake](https://github.com/mhkeller/layercake) - 一个建立在 Svelte 之上的图形框架.
- [nivo](https://github.com/plouc/nivo) - 用于具有同构能力的 React 的 Dataviz 组件 [条形图、线形图、区域图、气泡图、弦图、热图]
- [ngx-charts](https://github.com/swimlane/ngx-charts) - Angular [条形图、饼图、折线图、面积图、极坐标图、堆积图、气泡图] 的图表框架
- [potion](https://github.com/finnfiddle/potion) - 用于组合可视化的 React 组件集合
- [react-d3-components](https://github.com/codesuki/react-d3-components) - D3 组件 [条形图、堆积图、散点图、线形图、面积图、饼图]
- [react-d3-library](https://github.com/react-d3-library/react-d3-library) - 在 React [area, bar, line, pie, scatter] 中使用 D3 的库
- [react-stockcharts](https://github.com/rrag/react-stockcharts) - 高度可定制的股票图表 [面积图、折线图、散点图、气泡图、条形图、堆叠图、烛台图]
- [react-vis](https://github.com/uber/react-vis) - 一组用于呈现可视化效果的反应组件 [区域、条形图、热图、线、散点图]
- [reaviz](https://github.com/reaviz/reaviz) - 基于D3的React数据可视化库
- [recharts](https://github.com/recharts/recharts) - 重新设计的图表库，使用 React 构建
- [semiotic](https://github.com/nteract/semiotic) - 结合React &amp; D3的数据可视化框架[散点、线、面积]
- [victory](https://github.com/FormidableLabs/victory) - 用于构建可视化的可组合 React 组件 [区域、条形图、烛台、饼图、线、散点图、voronoi]
- [vx](https://github.com/hshoff/vx) - React 的可视化组件 [bar, line, scatter, stacked, area, pattern, heatmap, pie, radial, map, geo]
- [Vs](https://github.com/GopherJ/Vs) - Vue.js 的声明式可视化组件 [bar、line、area、pie、donut、stacked、sankey、timeline]
- [v-chart-plugin](https://github.com/ignoreintuition/v-chart-plugin) - 轻松将图表绑定到存储在 Vue.js 组件中的数据.


## Maps

- [d3-composite-projections](https://github.com/rveciana/d3-composite-projections) - 一起显示国家遥远土地的预测
- [datamaps](https://github.com/markmarkoh/datamaps) - 一个文件中的可自定义地图可视化
- [d3-topogram](https://github.com/shawnbot/topogram) - 基于 TopoJSON 的连续区域地图
- [d3-exploder](https://github.com/bsouthga/d3-exploder) - 让您轻松移动和调整地理特征
- [d3-geo-polygon](https://github.com/d3/d3-geo-polygon) - 球形多边形的裁剪和几何操作
- [d3-geo-projection](https://github.com/d3/d3-geo-projection) - 扩展的地理预测
- [d3-geo-scale-bar](https://github.com/HarryStevens/d3-geo-scale-bar) - 显示投影地理空间数据的自动比例尺.
- [d3-geo-voronoi](https://github.com/Fil/d3-geo-voronoi) - 球体的 Voronoi 图和 Delaunay 三角剖分
- [d3-geomap](https://github.com/yaph/d3-geomap) - 用于创建地理地图的库
- [d3.geo2rect](https://github.com/sebastian-meier/d3.geo2rect) - 将 geojson 多边形变形为矩形
- [d3-inertia](https://github.com/Fil/d3-inertia) - d3-drag 的扩展，以一定的惯性继续鼠标移动
- [mapmap.js](https://github.com/floledermann/mapmap.js) - 用于交互式专题地图的数据驱动 API
- [maptable](https://github.com/Packet-Clearing-House/maptable) - 将数据集转换为一组可视化组件（地图、过滤器、表格）
- [simple-map-d3](https://github.com/MinnPost/simple-map-d3) - 简单的等值线样式地图
- [spam](https://github.com/newsappsio/spam) - 使用 D3 和 Canvas 轻松创建地图

##### Third Party

- [leaflet-d3](https://github.com/Asymmetrik/leaflet-d3) - 将 D3 与 Leaflet [map, geo] 一起使用的插件集合
- [Wikimaps-D3js Atlas](https://github.com/WikimapsAtlas/WikimapsAtlas-generator) - 用于生成光栅、topojson 和 svg 地图的 CLI [map, geo]
- [react-simple-maps](https://github.com/zcreativelabs/react-simple-maps) - React 的 SVG 映射组件库，建立在 d3-geo [map, geo] 之上

## Utils

- [crossfilter](https://github.com/crossfilter/crossfilter) - 用于探索大型多变量数据集的库
- [d3kit-timeline](https://github.com/kristw/d3kit-timeline) - 标签不重叠的时间轴组件
- [d3scription](https://github.com/GlobalWebIndex/d3scription) - 带有窗口边缘碰撞检测的工具提示
- [d3-annotation](https://github.com/susielu/d3-annotation) - 具有内置注释类型的注释助手
- [d3-area-label](https://github.com/curran/d3-area-label) - 用于在区域中放置标签的库
- [d3-breadcrumbs](https://github.com/bumbeishvili/d3-breadcrumbs) - 简化面包屑的使用
- [d3-component](https://github.com/curran/d3-component) - 轻量级组件抽象
- [d3-extended](https://github.com/wbkd/d3-extended) - 使用一些常见的 jQuery 函数扩展 d3
- [d3-helpers](https://github.com/bahmutov/d3-helpers) - 实用功能很少
- [d3-history](https://github.com/vijithassar/d3-history) - 正确的 URL 栏历史记录
- [d3-hsluv](https://github.com/petulla/d3-hsluv) - 人性化的 HSL（色调、饱和度、亮度）色彩空间.
- [d3-iconarray](https://github.com/tomgp/d3-iconarray) - 用于对齐网格中元素的插件
- [d3-interpolate-path](https://github.com/pbeshai/d3-interpolate-path) - 插入具有不同点数的路径
- [d3-jetpack](https://github.com/gka/d3-jetpack) - 漂亮的便利包装器，可加快您的日常工作
- [d3-lasso](https://github.com/skokenes/d3-lasso) - 通过在对象上方或周围画一条线来标记元素
- [d3-legend](https://github.com/susielu/d3-legend) - 传奇帮手
- [d3-loom](https://github.com/nbremer/d3-loom) - 用于创建“织机”可视化的插件
- [d3-nelson-rules](https://github.com/53seven/d3-nelson-rules) - 将尼尔森过程控制规则应用于一组数据
- [d3-peaks](https://github.com/efekarakus/d3-peaks) - 在嘈杂的信号中找到峰值
- [d3-ring-note](https://github.com/armollica/d3-ring-note) - 用于放置圆圈和文本注释的插件
- [d3-scale-cluster](https://github.com/schnerd/d3-scale-cluster) - 将数据聚类成离散组的规模
- [d3-sparql](https://github.com/zazuko/d3-sparql) - 用于从 SPARQL 端点访问数据的实用程序
- [d3-template](https://github.com/ErikOnBike/d3-template) - 使用 D3 的数据绑定机制创建和呈现模板的插件
- [d3-tooltip](https://github.com/bumbeishvili/d3-tooltip) - 带有阴影和动态内容的箭头形工具提示
- [d3-voronoi-treemap](https://github.com/Kcnarf/d3-voronoi-treemap) - 根据 Voronoi 镶嵌计算树图
- [d3-xray](https://github.com/vijithassar/d3-xray) - 记录数据结果的书签在您将鼠标悬停时加入
- [swoopyarrows](https://github.com/bizweekgraphics/swoopyarrows) - 用于创建俯冲箭头的插件
- [swoopy-drag](https://github.com/1wheel/swoopy-drag) - d3 图形的手工标签放置
- [textures](https://github.com/riccardoscalco/textures) - 用于数据可视化的 SVG 模式

## Miscellaneous

- [chess-dataviz](https://github.com/ebemunk/chess-dataviz) - 国际象棋数据可视化库
- [codeflower](https://github.com/fzaninotto/CodeFlower) - 整个代码鸟瞰图
- [d3-cloud](https://github.com/jasondavies/d3-cloud) - 词云
- [d3-context-menu](https://github.com/patorjk/d3-context-menu) - 创建上下文菜单的助手
- [d3-force-gravity](https://github.com/sohamkamani/d3-force-gravity) - 实施引力吸引（或类似力场的排斥力）
- [d3-force-reuse](https://github.com/twosixlabs/d3-force-reuse) - 通过重用力近似来加快力导向图布局
- [d3-force-sampled](https://github.com/twosixlabs/d3-force-sampled) - 通过随机顶点采样的超快速、线性时间力导向图布局
- [d3.sketchy](https://github.com/sebastian-meier/d3.sketchy) - 创建粗略的背景、形状和线条
- [d3plus-text](https://github.com/d3plus/d3plus-text) - 具有换行和自动字体缩放功能的智能 SVG 文本框
- [graph-scroll](https://github.com/1wheel/graph-scroll) - 简单的滚动事件
- [mermaid](https://github.com/knsv/mermaid) - 以 Markdown 风格从文本生成图表和流程图
- [netvis](https://github.com/dborzov/netvis) - 可视化任意协议的网络通信
- [treeviz](https://github.com/PierreCapo/treeviz) - 从 json 数据创建可定制的树
- [twitter-sentiment-visualisation](https://github.com/Lissy93/twitter-sentiment-visualisation) - 一系列显示 Twitter 数据实时情绪的 D3.js 图表  

## Server side
- [d3-node](https://github.com/d3-node/d3-node) - 静态图表和地图生成
- [Kyrix](https://github.com/tracyhenry/Kyrix) - 具有自动服务器端缩放支持的交互式平移/缩放可视化. 

## Bl.ocks.org Profiles

 * [Adam Pearce - 1wheel](https://bl.ocks.org/1wheel)
 * [Colin Eberhardt - ColinEberhardt](https://bl.ocks.org/ColinEberhardt)
 * [Harry Stevens - HarryStevens](https://bl.ocks.org/HarryStevens)
 * [Luis Sevillano - LuisSevillano](https://bl.ocks.org/LuisSevillano)
 * [Peter Cook - d3indepth](https://bl.ocks.org/d3indepth)
 * [Elijah Meeks - emeeks](https://bl.ocks.org/emeeks)
 * [Ian Johnson - enjalot](https://bl.ocks.org/enjalot)
 * [Philippe Rivière - fil](https://bl.ocks.org/fil)
 * [Mike Bostock - mbostock](https://bl.ocks.org/mbostock)
 * [Matteo Filipponi - mfilippo](https://bl.ocks.org/mfilippo)
 * [Micah Stubbs - micahstubbs](https://bl.ocks.org/micahstubbs)
 * [Nadieh Bremer - nbremer](https://bl.ocks.org/nbremer)
 * [Matteo Abrate - nitaku](https://bl.ocks.org/nitaku)
 * [Susie Lu - susielu](https://bl.ocks.org/susielu)
 * [Shirley Wu - sxywu](https://bl.ocks.org/sxywu)
 * [Kai Chang - syntagmatic](https://bl.ocks.org/syntagmatic)
 * [Tom Shanley - tomshanley](https://bl.ocks.org/tomshanley)
 * [Vasco Asturiano - vasturiano](https://bl.ocks.org/vasturiano)
 * [Noah Veltman - veltman](https://bl.ocks.org/veltman)
 * [Zan Armstrong - zanarmstrong](https://bl.ocks.org/zanarmstrong)
