<div class="github-widget" data-repo="apsdehal/awesome-ctf"></div>
## Awesome CTF [![Build Status](https://travis-ci.org/apsdehal/awesome-ctf.svg?branch=master)](https://travis-ci.org/apsdehal/awesome-ctf) [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

精选清单 [Capture The Flag](https://en.wikipedia.org/wiki/Capture_the_flag#Computer_security)  (CTF) 框架、库、资源、软件和教程. 该列表旨在帮助初学者和经验丰富的 CTF 玩家在一个地方找到与 CTF 相关的所有内容.

### Contributing

请快速浏览一下 [contribution guidelines](https://github.com/apsdehal/ctf-tools/blob/master/CONTRIBUTING.md) 第一的.

#### _If you know a tool that isn't present here, feel free to open a pull request._

### Why?

建立 CTF 中使用的工具集合并记住它们是需要时间的. 这个 repo 有助于将所有这些分散的工具放在一个地方.





## Create

*用于创建 CTF 挑战的工具*

- [Kali Linux CTF Blueprints](https://www.packtpub.com/eu/networking-and-servers/kali-linux-ctf-blueprints) - 关于构建、测试和定制您自己的夺旗挑战的在线书籍.


## Forensics

*用于创建取证挑战的工具*

- [Dnscat2](https://github.com/iagox86/dnscat2) - 通过 DNS 主机通信.
- [Kroll Artifact Parser and Extractor (KAPE)](https://learn.duffandphelps.com/kape) - 分类程序.
- [Magnet AXIOM](https://www.magnetforensics.com/downloadaxiom) - 以工件为中心的 DFIR 工具.
- [Registry Dumper](http://www.kahusecurity.com/posts/registry_dumper_find_and_dump_hidden_registry_keys.html) - 转储您的注册表.

## Platforms

*可用于举办CTF的项目*

- [CTFd](https://github.com/isislab/CTFd) - 托管纽约大学 Tandon ISISLab 的危险风格 CTF 的平台.
- [echoCTF.RED](https://github.com/echoCTF/echoCTF.RED) - 开发、部署和维护您自己的 CTF 基础设施.
- [FBCTF](https://github.com/facebook/fbctf) - 举办 Facebook 夺旗比赛的平台.
- [Haaukins](https://github.com/aau-network-security/haaukins)- 用于安全教育的易于访问和自动化的虚拟化平台.
- [HackTheArch](https://github.com/mcpa-stlouis/hack-the-arch) - CTF评分平台.
- [Mellivora](https://github.com/Nakiami/mellivora) - 用 PHP 编写的 CTF 引擎.
- [MotherFucking-CTF](https://github.com/andreafioraldi/motherfucking-ctf)  - 用于托管 CTF 的 Badass 轻量级平台. 不涉及 JS.
- [NightShade](https://github.com/UnrealAkama/NightShade) - 一个简单的安全 CTF 框架.
- [OpenCTF](https://github.com/easyctf/openctf)  - 盒子里的 CTF. 需要最少的设置.
- [PicoCTF](https://github.com/picoCTF/picoCTF)  - 用于运行 picoCTF 的平台. 一个很好的框架来托管任何 CTF.
- [PyChallFactory](https://github.com/pdautry/py_chall_factory) - 用于创建/管理/打包危险 CTF 挑战的小型框架.
- [RootTheBox](https://github.com/moloch--/RootTheBox) - 黑客游戏（CTF 记分牌和游戏管理器）.
- [Scorebot](https://github.com/legitbs/scorebot) - Legitbs (Defcon) 的 CTF 平台.
- [SecGen](https://github.com/cliffe/SecGen)  - 安全场景生成器. 随机创建易受攻击的虚拟机.

## Steganography

*用于创建隐写挑战的工具*

检查解决部分的隐写术.

## Web

*用于创建网络挑战的工具*

*JavaScript 混淆器*

- [Metasploit JavaScript Obfuscator](https://github.com/rapid7/metasploit-framework/wiki/How-to-obfuscate-JavaScript-in-Metasploit)
- [Uglify](https://github.com/mishoo/UglifyJS)


## Solve

*用于解决 CTF 挑战的工具*

## Attacks

*用于执行各种攻击的工具*

- [Bettercap](https://github.com/bettercap/bettercap) - 执行 MITM（中间人）攻击的框架.
- [Yersinia](https://github.com/tomac/yersinia) - 攻击第 2 层的各种协议.

## Crypto

*用于解决加密挑战的工具*

- [CyberChef](https://gchq.github.io/CyberChef) - 用于分析和解码数据的 Web 应用程序.
- [FeatherDuster](https://github.com/nccgroup/featherduster) - 一种自动化的模块化密码分析工具.
- [Hash Extender](https://github.com/iagox86/hash_extender) - 用于执行散列长度扩展攻击的实用工具.
- [padding-oracle-attacker](https://github.com/KishanBagaria/padding-oracle-attacker) - 执行填充 oracle 攻击的 CLI 工具.
- [PkCrack](https://www.unix-ag.uni-kl.de/~conrad/krypto/pkcrack.html) - 破解 PkZip 加密的工具.
- [QuipQuip](https://quipqiup.com) - 破解替代密码或 vigenere 密码（无密钥）的在线工具.
- [RSACTFTool](https://github.com/Ganapati/RsaCtfTool) - 用于恢复具有各种攻击的 RSA 私钥的工具.
- [RSATool](https://github.com/ius/rsatool) - 根据 p 和 q 的知识生成私钥.
- [XORTool](https://github.com/hellman/xortool) - 分析多字节异或密码的工具.

## Bruteforcers

*用于各种暴力破解的工具（密码等）*

- [Hashcat](https://hashcat.net/hashcat/) - 密码破解器
- [Hydra](https://tools.kali.org/password-attacks/hydra) - 支持多种攻击协议的并行登录破解程序
- [John The Jumbo](https://github.com/magnumripper/JohnTheRipper) - 开膛手约翰的社区增强版.
- [John The Ripper](http://www.openwall.com/john/) - 密码破解器.
- [Nozzlr](https://github.com/intrd/nozzlr) - Nozzlr 是一个强力框架，真正模块化且脚本友好.
- [Ophcrack](http://ophcrack.sourceforge.net/) - 基于彩虹表的 Windows 密码破解程序.
- [Patator](https://github.com/lanjelot/patator) - Patator 是一个多用途的暴力破解器，采用模块化设计.
- [Turbo Intruder](https://portswigger.net/research/turbo-intruder-embracing-the-billion-request-attack) - 用于发送大量 HTTP 请求的 Burp Suite 扩展 

## Exploits

*用于解决漏洞利用挑战的工具*

- [DLLInjector](https://github.com/OpenSecurityResearch/dllinjector) - 在进程中注入 dll.
- [libformatstr](https://github.com/hellman/libformatstr) - 简化格式字符串利用.
- [Metasploit](http://www.metasploit.com/) - Penetration testing software.
  - [Cheatsheet](https://www.comparitech.com/net-admin/metasploit-cheat-sheet/)
- [one_gadget](https://github.com/david942j/one_gadget) - 一种用于查找一个小工具 `execve(&#39;/bin/sh&#39;, NULL, NULL)` 调用的工具.
  - `gem install one_gadget`
- [Pwntools](https://github.com/Gallopsled/pwntools) - 用于编写漏洞的 CTF 框架.
- [Qira](https://github.com/BinaryAnalysisPlatform/qira) - QEMU 交互式运行时分析器.
- [ROP Gadget](https://github.com/JonathanSalwan/ROPgadget) - ROP开发框架.
- [V0lt](https://github.com/P1kachu/v0lt) - 安全 CTF 工具包.

## Forensics

*用于解决取证挑战的工具*

- [Aircrack-Ng](http://www.aircrack-ng.org/) - 破解 802.11 WEP 和 WPA-PSK 密钥.
  -`apt-get 安装 aircrack-ng`
- [Audacity](http://sourceforge.net/projects/audacity/) - 分析声音文件（mp3、m4a 等）.
  -`apt-get install audacity`
- [Bkhive and Samdump2](http://sourceforge.net/projects/ophcrack/files/samdump2/) - 转储 SYSTEM 和 SAM 文件.
  -`apt-get 安装 samdump2 bkhive`
- [CFF Explorer](http://www.ntcore.com/exsuite.php) - 体育编辑器.
- [Creddump](https://github.com/moyix/creddump) - 转储 Windows 凭据.
- [DVCS Ripper](https://github.com/kost/dvcs-ripper) - Rips 网络可访问（分布式）版本控制系统.
- [Exif Tool](http://www.sno.phy.queensu.ca/~phil/exiftool/) - 读取、写入和编辑文件元数据.
- [Extundelete](http://extundelete.sourceforge.net/) - 用于从可安装映像中恢复丢失的数据.
- [Fibratus](https://github.com/rabbitstack/fibratus) - 用于探索和跟踪 Windows 内核的工具.
- [Foremost](http://foremost.sourceforge.net/) - 使用标头提取特定类型的文件.
  - `apt-get 安装最重要`
- [Fsck.ext4](http://linux.die.net/man/8/fsck.ext3) - 用于修复损坏的文件系统.
- [Malzilla](http://malzilla.sourceforge.net/) - 恶意软件搜寻工具.
- [NetworkMiner](http://www.netresec.com/?page=NetworkMiner) - 网络取证分析工具.
- [PDF Streams Inflater](http://malzilla.sourceforge.net/downloads.html) - 查找并提取压缩为 PDF 文件的 zlib 文件.
- [Pngcheck](http://www.libpng.org/pub/png/apps/pngcheck.html) - 验证 PNG 的完整性并以人类可读的形式转储所有块级信息.
  -`apt-get install pngcheck`
- [ResourcesExtract](http://www.nirsoft.net/utils/resources_extract.html) - 从 exe 中提取各种文件类型.
- [Shellbags](https://github.com/williballenthin/shellbags) - 调查 NT\_USER.dat 文件.
- [Snow](https://sbmlabs.com/notes/snow_whitespace_steganography_tool) - 空白隐写术工具.
- [USBRip](https://github.com/snovvcrash/usbrip) - 用于在 GNU/Linux 上跟踪 USB 设备工件（USB 事件的历史记录）的简单 CLI 取证工具.
- [Volatility](https://github.com/volatilityfoundation/volatility) - 调查内存转储.
- [Wireshark](https://www.wireshark.org) - 用于分析 pcap 或 pcapng 文件

*注册表查看器*
- [OfflineRegistryView](https://www.nirsoft.net/utils/offline_registry_view.html) - 适用于 Windows 的简单工具，允许您从外部驱动器读取离线注册表文件并以 .reg 文件格式查看所需的注册表项.
- [Registry Viewer®](https://accessdata.com/product-download/registry-viewer-2-0-0) - 用于查看 Windows 注册表.

## Networking

*用于解决网络挑战的工具*

- [Masscan](https://github.com/robertdavidgraham/masscan) -海量IP端口扫描器、TCP端口扫描器.
- [Monit](https://linoxide.com/monitoring-2/monit-linux/) - 用于检查网络主机（和其他非网络活动）的 linux 工具.
- [Nipe](https://github.com/GouveaHeitor/nipe) - Nipe 是一个使 Tor 网络成为默认网关的脚本.
- [Nmap](https://nmap.org/) - 用于网络发现和安全审计的开源实用程序.
- [Wireshark](https://www.wireshark.org/) - 分析网络转储.
  -`apt-get 安装 wireshark`
- [Zeek](https://www.zeek.org) - 开源网络安全监视器.
- [Zmap](https://zmap.io/) - 开源网络扫描仪.

## Reversing

*用于解决逆向挑战的工具*

- [Androguard](https://github.com/androguard/androguard) - 逆向工程 Android 应用程序.
- [Angr](https://github.com/angr/angr) - 与平台无关的二进制分析框架.
- [Apk2Gold](https://github.com/lxdvs/apk2gold) - 另一个 Android 反编译器.
- [ApkTool](http://ibotpeaches.github.io/Apktool/) - 安卓反编译器.
- [Barf](https://github.com/programa-stic/barf-project) - 二进制分析和逆向工程框架.
- [Binary Ninja](https://binary.ninja/) - 二进制分析框架.
- [BinUtils](http://www.gnu.org/software/binutils/binutils.html) - 二进制工具的集合.
- [BinWalk](https://github.com/devttys0/binwalk) - 分析、逆向工程和提取固件映像.
- [Boomerang](https://github.com/BoomerangDecompiler/boomerang) - 将 x86/SPARC/PowerPC/ST-20 二进制文件反编译为 C.
- [ctf_import](https://github.com/docileninja/ctf_import) – 从跨平台剥离的二进制文件运行基本功能.
- [cwe_checker](https://github.com/fkie-cad/cwe_checker) - cwe_checker 在二进制可执行文件中发现易受攻击的模式.
- [demovfuscator](https://github.com/kirschju/demovfuscator) - 用于 movfuscated 二进制文件的正在进行的去混淆器.
- [Frida](https://github.com/frida/) - 动态代码注入.
- [GDB](https://www.gnu.org/software/gdb/) - GNU 项目调试器.
- [GEF](https://github.com/hugsy/gef) - GDB 插件.
- [Ghidra](https://ghidra-sre.org/)  - 开源逆向工程工具套件. 类似于 IDA Pro.
- [Hopper](http://www.hopperapp.com/) - 适用于 OSX 和 Linux 的逆向工程工具（反汇编程序）.
- [IDA Pro](https://www.hex-rays.com/products/ida/) - 最常用的倒车软件.
- [Jadx](https://github.com/skylot/jadx) - 反编译安卓文件.
- [Java Decompilers](http://www.javadecompilers.com) - Java 和 Android APK 的在线反编译器.
- [Krakatau](https://github.com/Storyyeller/Krakatau) - Java 反编译器和反汇编器.
- [Objection](https://github.com/sensepost/objection) - 运行时移动探索.
- [PEDA](https://github.com/longld/peda) - GDB 插件（仅限 python2.7）.
- [Pin](https://software.intel.com/en-us/articles/pin-a-dynamic-binary-instrumentation-tool) - 英特尔的动态二进制工具.
- [PINCE](https://github.com/korcankaraokcu/PINCE) - GDB 前端/逆向工程工具，专注于游戏破解和自动化.
- [PinCTF](https://github.com/ChrisTheCoolHut/PinCTF) - 使用英特尔引脚进行边信道分析的工具.
- [Plasma](https://github.com/joelpx/plasma) - 用于 x86/ARM/MIPS 的交互式反汇编器，可以生成带有彩色语法的缩进伪代码.
- [Pwndbg](https://github.com/pwndbg/pwndbg) - 一个 GDB 插件，它提供了一套实用程序来轻松破解 GDB.
- [radare2](https://github.com/radare/radare2) - 便携式倒车框架.
- [Triton](https://github.com/JonathanSalwan/Triton/) - 动态二进制分析 (DBA) 框架.
- [Uncompyle](https://github.com/gstarnberger/uncompyle) - 反编译 Python 2.7 二进制文件 (.pyc).
- [WinDbg](http://www.windbg.org/) - Microsoft 分发的 Windows 调试器.
- [Xocopy](http://reverse.lostrealm.com/tools/xocopy.html) - 可以复制具有执行权限但没有读取权限的可执行文件的程序.
- [Z3](https://github.com/Z3Prover/z3) - 来自 Microsoft Research 的定理证明器.

*JavaScript 去混淆器*

- [Detox](http://relentless-coding.org/projects/jsdetox/install) - 一个 Javascript 恶意软件分析工具.
- [Revelo](http://www.kahusecurity.com/posts/revelo_javascript_deobfuscator.html) - 分析混淆的 Javascript 代码.

*SWF分析器*
- [RABCDAsm](https://github.com/CyberShadow/RABCDAsm) - 实用程序集合，包括 ActionScript 3 汇编器/反汇编器.
- [Swftools](http://www.swftools.org/) - 用于处理 SWF 文件的实用程序集合.
- [Xxxswf](https://bitbucket.org/Alexander_Hanel/xxxswf) - 用于分析 Flash 文件的 Python 脚本.

## Services

*互联网上提供的各种有用服务*

- [CSWSH](http://cow.cat/cswsh.html) - 跨站点 WebSocket 劫持测试器.
- [Request Bin](https://requestbin.com/) - 让您检查对特定 url 的 http 请求.

## Steganography

*用于解决隐写术挑战的工具*

- [AperiSolve](https://aperisolve.fr/) - Aperi&#39;Solve 是一个对图像进行图层分析的平台（开源）.
- [Convert](http://www.imagemagick.org/script/convert.php) - 转换图像黑白格式并应用过滤器.
- [Exif](http://manpages.ubuntu.com/manpages/trusty/man1/exif.1.html) - 显示 JPEG 文件中的 EXIF 信息.
- [Exiftool](https://linux.die.net/man/1/exiftool) - 读写文件中的元信息.
- [Exiv2](http://www.exiv2.org/manpage.html) - 图像元数据操作工具.
- [Image Steganography](https://sourceforge.net/projects/image-steg/)  - 将文本和文件嵌入带有可选加密功能的图像中. 易于使用的用户界面.
- [Image Steganography Online](https://incoherency.co.uk/image-steganography) - 这是一个客户端 Javascript 工具，用于隐写将图像隐藏在其他图像的较低“位”中
- [ImageMagick](http://www.imagemagick.org/script/index.php) - 用于处理图像的工具.
- [Outguess](https://www.freebsd.org/cgi/man.cgi?query=outguess+&apropos=0&sektion=0&manpath=FreeBSD+Ports+5.1-RELEASE&format=html) - 通用隐写工具.
- [Pngtools](https://packages.debian.org/sid/pngtools) - 用于与 PNG 相关的各种分析.
  -`apt-get install pngtools`
- [SmartDeblur](https://github.com/Y-Vladimir/SmartDeblur) - 用于去模糊和修复散焦图像.
- [Steganabara](https://www.openhub.net/p/steganabara) - 用 Ja​​va 编写的隐写分析工具.
- [SteganographyOnline](https://stylesuxx.github.io/steganography/) - 在线隐写术编码器和解码器.
- [Stegbreak](https://linux.die.net/man/1/stegbreak) - 对 JPG 图像发起暴力字典攻击.
- [StegCracker](https://github.com/Paradoxis/StegCracker) - 隐写术蛮力实用程序，用于发现文件中的隐藏数据.
- [stegextract](https://github.com/evyatarmeged/stegextract) - 检测图像中的隐藏文件和文本.
- [Steghide](http://steghide.sourceforge.net/) - 在各种图像中隐藏数据.
- [StegOnline](https://georgeom.net/StegOnline/upload) - 进行广泛的图像隐写术操作，例如隐藏/显示隐藏在位中的文件（开源）.
- [Stegsolve](http://www.caesum.com/handbook/Stegsolve.jar) - 将各种隐写技术应用于图像.
- [Zsteg](https://github.com/zed-0xff/zsteg/) - PNG/BMP 分析.

## Web

*用于解决网络挑战的工具*

- [BurpSuite](https://portswigger.net/burp) - 用于测试网站安全性的图形工具.
- [Commix](https://github.com/commixproject/commix) - 自动化一体化操作系统命令注入和利用工具.
- [Hackbar](https://addons.mozilla.org/en-US/firefox/addon/hackbartool/) - Firefox 插件，便于网络开发.
- [OWASP ZAP](https://www.owasp.org/index.php/Projects/OWASP_Zed_Attack_Proxy_Project) - 拦截代理以重放、调试和模糊 HTTP 请求和响应
- [Postman](https://chrome.google.com/webstore/detail/postman/fhbjgbiflinjbdggehcddcbncdddomop?hl=en) - 添加用于调试网络请求的 chrome.
- [Raccoon](https://github.com/evyatarmeged/Raccoon) - 用于侦察和漏洞扫描的高性能攻击性安全工具.
- [SQLMap](https://github.com/sqlmapproject/sqlmap) - 自动 SQL 注入和数据库接管工具.
  ```pip 安装 sqlmap```
- [W3af](https://github.com/andresriancho/w3af) - Web 应用程序攻击和审计框架.
- [XSSer](http://xsser.sourceforge.net/) - 自动化的 XSS 测试器.


## Resources

*在哪里可以发现 CTF*

## Operating Systems

*渗透测试和安全实验室操作系统*

- [Android Tamer](https://androidtamer.com/) - 基于 Debian.
- [BackBox](https://backbox.org/) - 基于 Ubuntu.
- [BlackArch Linux](https://blackarch.org/) - 基于 Arch Linux.
- [Fedora Security Lab](https://labs.fedoraproject.org/security/) - 基于 Fedora.
- [Kali Linux](https://www.kali.org/) - 基于 Debian.
- [Parrot Security OS](https://www.parrotsec.org/) - 基于 Debian.
- [Pentoo](http://www.pentoo.ch/) - 基于 Gentoo.
- [URIX OS](http://urix.us/) - 基于 openSUSE.
- [Wifislax](http://www.wifislax.com/) - 基于 Slackware.

*恶意软件分析师和逆向工程*

- [Flare VM](https://github.com/fireeye/flare-vm/) - 基于 Windows.
- [REMnux](https://remnux.org/) - 基于 Debian.

## Starter Packs

*安装程序脚本的集合，有用的工具*

- [CTF Tools](https://github.com/zardus/ctf-tools) - Collection of setup scripts to install various security research tools.
- [LazyKali](https://github.com/jlevitsk/lazykali) - 2016 年 LazyKali 更新，简化了工具和配置的安装.

## Tutorials

*学习如何玩 CTF 的教程*

- [CTF Field Guide](https://trailofbits.github.io/ctf/) - Trails of Bits 的野外指南.
- [CTF Resources](http://ctfs.github.io/resources/) - 由社区维护的入门指南.
- [How to Get Started in CTF](https://www.endgame.com/blog/how-get-started-ctf) - Endgame 为 CTF 初学者编写的简短指南
- [Intro. to CTF Course](https://www.hoppersroppers.org/courseCTF.html) - 一门免费课程，向初学者教授取证、加密和 Web-ex 的基础知识.
- [IppSec](https://www.youtube.com/channel/UCa6eh7gCkpPo5XXUDfygQQA) - 流行的 CTF 平台的视频教程和演练.
- [LiveOverFlow](https://www.youtube.com/channel/UClcE-kVhqyiHCcjYwcpfj9w) - 关于开发的视频教程.
- [MIPT CTF](https://github.com/xairy/mipt-ctf) - 面向 CTF 初学者的小型课程（俄语）.


## Wargames

*永远在线的CTF*

- [Backdoor](https://backdoor.sdslabs.co/) - SDSLabs 的安全平台.
- [Crackmes](https://crackmes.one/) - 逆向工程挑战.
- [CryptoHack](https://cryptohack.org/) - 有趣的密码学挑战.
- [echoCTF.RED](https://echoctf.red/) - 具有多种攻击目标的在线 CTF.
- [Exploit Exercises](https://exploit-exercises.lains.space/) - 各种虚拟机学习各种计算机安全问题.
- [Exploit.Education](http://exploit.education) - 各种虚拟机学习各种计算机安全问题.
- [Gracker](https://github.com/Samuirai/gracker) - 学习曲线缓慢的二元挑战，以及每个级别的评论.
- [Hack The Box](https://www.hackthebox.eu) - 面向各类安全爱好者的每周 CTF.
- [Hack This Site](https://www.hackthissite.org/) - 黑客训练场.
- [Hacker101](https://www.hacker101.com/) - 来自 HackerOne 的 CTF
- [Hacking-Lab](https://hacking-lab.com/) - 道德黑客、计算机网络和安全挑战平台.
- [Hone Your Ninja Skills](https://honeyourskills.ninja/) - 从基础开始的网络挑战.
- [IO](http://io.netgarage.org/) - 用于二元挑战的兵棋推演.
- [Microcorruption](https://microcorruption.com) - 嵌入式安全 CTF.
- [Over The Wire](http://overthewire.org/wargames/) - 由 OvertheWire 社区维护的战争游戏.
- [PentesterLab](https://pentesterlab.com/) - 各种虚拟机和在线挑战（付费）.
- [PicoCTF](https://2019game.picoctf.com)  - 全年无休的ctf比赛. 来自年度 picoCTF 竞赛的问题.
- [PWN Challenge](http://pwn.eonew.cn/) - 二进制开发战争游戏.
- [Pwnable.kr](http://pwnable.kr/) - 典当游戏.
- [Pwnable.tw](https://pwnable.tw/) - 二进制战争游戏.
- [Pwnable.xyz](https://pwnable.xyz/) - 二进制开发战争游戏.
- [Reversin.kr](http://reversing.kr/) - 逆转挑战.
- [Ringzer0Team](https://ringzer0team.com/) - Ringzer0 团队在线 CTF.
- [Root-Me](https://www.root-me.org/) - 黑客与信息安全学习平台.
- [ROP Wargames](https://github.com/xelenonz/game) - ROP 战争游戏.
- [SANS HHC](https://holidayhackchallenge.com/past-challenges/) - 节日主题的挑战
  每年发布并由 SANS 维护.
- [SmashTheStack](http://smashthestack.org/) - 由 SmashTheStack 社区维护的各种兵棋推演.
- [Viblo CTF](https://ctf.viblo.asia)  - 许多不同类别的各种惊人的 CTF 挑战. 具有练习模式和竞赛模式.
- [VulnHub](https://www.vulnhub.com/) - 基于 VM 的数字安全、计算机应用和网络管理实践.
- [W3Challs](https://w3challs.com) - 渗透测试培训平台，提供不同类别的各种计算机挑战.
- [WebHacking](http://webhacking.kr) - 网络黑客挑战.


*自托管 CTF*
- [Damn Vulnerable Web Application](http://www.dvwa.co.uk/) - 极易受到攻击的 PHP/MySQL Web 应用程序.
- [Juice Shop CTF](https://github.com/bkimminich/juice-shop-ctf) - 用于托管 CTF 的脚本和工具 [OWASP Juice Shop](https://www.owasp.org/index.php/OWASP_Juice_Shop_Project) 容易地.

## Websites

*关于 CTF 的各种通用网站*

- [Awesome CTF Cheatsheet](https://github.com/uppusaikiran/awesome-ctf-cheatsheet#awesome-ctf-cheatsheet-) - CTF 备忘单.
- [CTF Time](https://ctftime.org/) - 关于世界各地发生的 CTF 的一般信息.
- [Reddit Security CTF](http://www.reddit.com/r/securityctf) - Reddit CTF 类别.

## Wikis

*可用于学习 CTF 的各种 Wiki*

- [Bamboofox](https://bamboofox.github.io/) - 学习CTF的中文资源.
- [bi0s Wiki](https://teambi0s.gitlab.io/bi0s-wiki/) - 来自团队 bi0s 的 Wiki.
- [CTF Cheatsheet](https://uppusaikiran.github.io/hacking/Capture-the-Flag-CheatSheet/) - CTF 提示和技巧.
- [ISIS Lab](https://github.com/isislab/Project-Ideas/wiki) - Isis 实验室的 CTF Wiki.
- [OpenToAll](https://github.com/OpenToAllCTF/Tips) - OTA CTF 团队成员提供的 CTF 提示.

## Writeups Collections

*CTF 文章合集*

- [0e85dc6eaf](https://github.com/0e85dc6eaf/CTF-Writeups) - 0e85dc6eaf 对 CTF 挑战的评论
- [Captf](http://captf.com/) - psifertex 转储了 CTF 挑战和材料.
- [CTF write-ups (community)](https://github.com/ctfs/) - CTF challenges + 由社区维护的 write-ups 存档.
- [CTFTime Scrapper](https://github.com/abdilahrf/CTFWriteupScrapper) - 从 CTF Time 中删除所有 writeup 并组织首先阅读的内容.
- [HackThisSite](https://github.com/HackThisSite/CTF-Writeups) - CTF write-ups repo 由 HackThisSite 团队维护.
- [Mzfr](https://github.com/mzfr/ctf-writeups/) - mzfr 撰写的 CTF 竞赛文章
- [pwntools writeups](https://github.com/Gallopsled/pwntools-write-ups) - 全部使用 pwntools 的 CTF 文章合集.
- [SababaSec](https://github.com/SababaSec/ctf-writeups) - SababaSec 团队的 CTF 文章合集
- [Shell Storm](http://shell-storm.org/repo/CTF/) - 由 Jonathan Salwan 维护的 CTF 挑战档案.
- [Smoke Leet Everyday](https://github.com/smokeleeteveryday/CTF_WRITEUPS) - CTF write-ups repo 由 SmokeLeetEveryday 团队维护.

### LICENSE

抄送0:)
