<div class="github-widget" data-repo="awesome-css-group/awesome-css"></div>
[awesome-link]:  https://github.com/sindresorhus/awesome
[awesome-badge]: https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg
[travis-link]:   https://travis-ci.org/awesome-css-group/awesome-css
[travis-badge]:  https://travis-ci.org/awesome-css-group/awesome-css.svg?branch=master

## Awesome CSS [![Awesome][awesome-badge]][awesome-link] [![Travis Build Status][travis-badge]][travis-link] 

> /* A curated list of awesome frameworks, style guides, and other cool nuggets for writing amazing CSS. */

## Introduction

### Motivation

This document is a curated list of frameworks, style guides, and cool nuggets of information for writing awesome CSS. It does not contain resources to learn CSS.

### Complementary Resources

If you're struggling with something CSS-related, look for answers within the following resources:

- [CSS - MDN - Mozilla](https://developer.mozilla.org/en-US/docs/Web/CSS)
- [Reddit (CSS)](https://www.reddit.com/r/css/)
- [StackOverflow (CSS)](https://stackoverflow.com/questions/tagged/css)

<!-- Used for the "back to top" links within the document -->
<div id="contents"></div>


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->



<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## CSS Working Group

The CSS Working Group creates and defines CSS specifications. These specifications are assigned [maturity levels](https://www.w3.org/2005/10/Process-20051014/tr#maturity-levels) as they move through the design process. If you would like to learn more, visit [CSS Working Group Page](https://www.w3.org/Style/CSS/).

### Editor's Draft :black_nib:

*Editor's drafts of CSS specifications*

- [W3c/csswg-drafts](https://github.com/w3c/csswg-drafts) - Mirror of CSS WG Editor Draft repository.
- [W3c/css-houdini-drafts](https://github.com/w3c/css-houdini-drafts) - Mirror of Houdini WG Editor repository.

## Parsers :mag:

* [CSSOM](https://github.com/NV/CSSOM) - CSS Object Model implemented in pure JavaScript.
* [CSSTree](https://github.com/csstree/csstree) - Detailed CSS parser with syntax validator.
* [Gonzales PE](https://github.com/tonyganch/gonzales-pe) - CSS parser with support for preprocessors.
* [Mensch](https://github.com/brettstimmerman/mensch) - A decent CSS parser.
* [ParserLib](https://github.com/CSSLint/parser-lib) - CSSLint/parser-lib.
* [PostCSS](https://github.com/postcss/postcss) - Transforming styles with JS plugins.
* [Rework](https://github.com/reworkcss/rework) - Plugin framework for CSS preprocessing in Node.js.
* [Stylecow](https://github.com/stylecow/stylecow) - Modern CSS for all browsers.

<sub>[⇧ back to top](#contents)</sub>

## Preprocessors :pill:

*Write CSS faster*

* [LESS](https://github.com/less/less.js) - Backwards compatible with CSS, and the extra features it adds use existing CSS syntax.
* [PostCSS](https://github.com/postcss/postcss) - Transforming CSS with JS plugins.
* [Sass](https://github.com/sass/sass) - Mature, stable, and powerful professional-grade CSS extension language.
* [STYLIS](https://github.com/thysultan/stylis.js) - Light-weight CSS preprocessor.
* [Stylus](http://learnboost.github.io/stylus/) - Expressive, robust, feature-rich CSS language built for NodeJs.
* [Vanilla Extract](https://vanilla-extract.style/) - Generate static CSS using Typescript. Write type‑safe, locally scoped classes, variables and themes.

<sub>[⇧ back to top](#contents)</sub>

## Frameworks :art:

* [AgnosticUI](https://www.agnosticui.com/) - Accessible CSS component primitives that also work with React, Vue 3, Svelte, and Angular.
* [Bonsai](https://www.bonsaicss.com/) - A complete Utility First CSS Framework for less than 50kb.
* [Bootstrap](https://getbootstrap.com/) - The most popular HTML, CSS, and JS framework.
* [Bulma](http://bulma.io/) - A modern CSS framework based on Flexbox. Also has Sass import for modification.
* [Butter Cake](http://getbuttercake.com/) - A Modern Lightweight Front End CSS framework for faster and easier web development.
* [Charts.css](https://chartscss.org/) - CSS data visualization framework.
* [Chota](https://jenil.github.io/chota/) - A responsive, customizable micro-framework (3kb) with helpful utilities and a grid system.
* [Cirrus](https://spiderpig86.github.io/Cirrus/) - A fully responsive and comprehensive CSS framework with beautiful controls and simplistic structure.
* [Foundation](http://foundation.zurb.com/) - advanced responsive front-end framework.
* [Gralig](http://gralig.com/) - A modest, grayish CSS library.
* [Halfmoon](https://www.gethalfmoon.com/) - A responsive front-end framework with a built-in dark mode.
* [Hasser CSS](https://github.com/HeavenMercy/HasserCSS) - A lightweight (12k, not minified) but useful CSS framework with flexible Grid, Hero and more.
* [Inuit.css](http://inuitcss.com/) - Powerful, scalable, Sass-based, BEM, OOCSS framework.
* [Material-components-web](https://github.com/material-components/material-components-web) - Modular and customizable Material Design UI components for the web.
* [Materialize](http://materializecss.com/) - A modern responsive front-end framework based on Material Design.
* [Milligram](http://milligram.io) - A minimalist CSS framework.
* [Numl](https://numl.design) - An HTML-based language and design system that lets you create responsive and accessible high-quality web interfaces with any look.
* [Pure.css](http://purecss.io/) - A set of small, responsive CSS modules that you can use in every web project.
* [Semantic UI](http://semantic-ui.com/) - Powerful framework that uses human-friendly HTML.
* [Shorthand Framework](https://github.com/shorthandcss/shorthand) - Feature rich CSS framework for the new decade.
* [Spectre.css](https://picturepan2.github.io/spectre/index.html) - A lightweight, responsive and modern CSS framework.
* [Strawberry](https://github.com/jfet97/strawberry) - A set of common flexbox utilities focused on making your life easier and faster with nested flexboxes.
* [Tachyons](http://tachyons.io/) - Functional CSS for humans.
* [Tacit](https://yegor256.github.io/tacit/) - CSS framework for dummies with zero skills in graphic design.
* [Tailwindcss](https://github.com/tailwindcss/tailwindcss) - A utility-first CSS framework for rapid UI development.
* [Tronic247 Material](https://material.pages.dev/) - A responsive framework based on CSS and some JS while following Material Design guidelines.
* [UIkit](http://getuikit.com/) - A lightweight and modular front-end framework.
* [Unsemantic](http://unsemantic.com/) - Fluid grid for mobile, tablet, and desktop.
* [Wing](https://kbrsh.github.io/wing/) - A Minimal, Lightweight, Responsive framework.

_[You can find more frameworks at "awesome-css-frameworks"](https://github.com/troxler/awesome-css-frameworks)_

<sub>[⇧ back to top](#contents)</sub>

## Toolkits :wrench:

* [Bourbon](http://bourbon.io/) - A simple and lightweight mixin library for Sass.

<sub>[⇧ back to top](#contents)</sub>

## Reset and Normalize

- [CSS Checker](https://github.com/ruilisi/css-checker) - Find and Reduce Similar & Duplicated CSS Scripts.
- [MiniReset.css](https://github.com/jgthms/minireset.css) - A tiny modern CSS reset.
- [Normalize-OpenType](https://github.com/kennethormandy/normalize-opentype.css) - Adds OpenType features—ligatures, kerning, and more—to Normalize.css.
- [Normalize](https://github.com/necolas/normalize.css) - A set of CSS rules that provide better cross-browser consistency in the default styling of HTML elements.
- [Reset.css](https://meyerweb.com/eric/tools/css/reset/) - CSS Tools: Reset CSS.
- [Reseter.css](https://github.com/krishdevdb/reseter.css) - A Futuristic CSS Reset/Normalizer. That Redifines Instead Of Preserving.
- [Sanitize.css](https://github.com/jonathantneal/sanitize.css/) - A set of CSS rules that style with today’s best practices out-of-the-box.
- [Unstyle.css](https://github.com/Martin-Pitt/css-unstyle) - Specialised stylesheet for removing user agent styles, style the web with your baseline.

<sub>[⇧ back to top](#contents)</sub>

## CSS Development at Large-Scale Websites

* [Bugsnag's CSS Architecture](http://blog.bugsnag.com/bugsnags-css-architecture) by [Max Luster](https://twitter.com/maxluster)
* [CSS at BBC Sport](https://medium.com/@shaunbent/css-at-bbc-sport-part-1-bab546184e66) by Shaun Bent
* [CSS AT HOOTSUITE](http://code.hootsuite.com/css-at-hootsuite/) by Steve Mynett
* [GitHub's CSS](http://markdotto.com/2014/07/23/githubs-css/) by [Mark Otto](https://twitter.com/mdo)
* [How we do CSS at Ghost](https://dev.ghost.org/css-at-ghost/) by Paul Davis
* [Lonely Planet](http://ianfeather.co.uk/css-at-lonely-planet/) by [Ian Feather](https://twitter.com/ianfeather)
* [Medium’s CSS is actually pretty good.](https://medium.com/@fat/mediums-css-is-actually-pretty-fucking-good-b8e2a6c78b06) by [Jacob Thornton](https://twitter.com/fat)
* [Refining The Way We Structure Our CSS At Trello](http://blog.trello.com/refining-the-way-we-structure-our-css-at-trello/) by [Bobby Grace](https://twitter.com/bobbygrace)
* [Scalable-css-reading-list](https://github.com/davidtheclark/scalable-css-reading-list)

<sub>[⇧ back to top](#contents)</sub>

## Code Style Guidelines :book:

* [Code Guide](http://codeguide.co/) by [Mark Otto](https://twitter.com/mdo)
* [CSS Guidelines](http://cssguidelin.es/) by [Harry Roberts](https://twitter.com/csswizardry)
* [CSS Styleguide](https://github.com/grvcoelho/css) by [Guilherme Rv Coelho](https://github.com/grvcoelho)
* [Dropbox (S)CSS Style Guide](https://github.com/dropbox/css-style-guide) by Dropbox
* [Google HTML/CSS Style Guide](https://google.github.io/styleguide/htmlcssguide.html) by Google
* [Idiomatic CSS](https://github.com/necolas/idiomatic-css) by [Nicolas Gallagher](https://twitter.com/necolas)
* [Official Trello CSS Guide](https://gist.github.com/bobbygrace/9e961e8982f42eb91b80) by Bobby Grace
* [Sass Guidelines](https://sass-guidelin.es/) by [Kitty Giraudel](https://twitter.com/KittyGiraudel)
* [SASS Style Guide](http://sass-lang.com/styleguide) by Sass team
* [ThinkUp CSS Style Guide](https://github.com/ThinkUpLLC/ThinkUp/wiki/Code-Style-Guide:-CSS) by ThinkUp
* [WordPress CSS Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/css/) by WorldPress

<sub>[⇧ back to top](#contents)</sub>

## Style Guide

* [AUI](http://docs.atlassian.com/aui/latest/docs) by Atlassian Design
* [Design Elements](http://rizzo.lonelyplanet.com/styleguide/design-elements/colours) by lonely planet
* [Fluent UI](https://github.com/microsoft/fluentui) by Microsoft
* [GitHub CSS Style Guide](https://primer.github.io/) by Github
* [Lighting Design System](https://www.lightningdesignsystem.com/) by Salesforce
* [Patterns](https://ux.mailchimp.com/patterns) by MailChimp
* [Solid](http://solid.buzzfeed.com/) by BuzzFeed
* [Style Guide](https://www.starbucks.com/static/reference/styleguide/) by Starbucks
* [Website Style Guide Resources](http://styleguides.io/examples.html) by Awesome people

View more style guides at [Website Style Guide Resources](http://styleguides.io/)

<sub>[⇧ back to top](#contents)</sub>


## Style Guide Generators :slot_machine:

- [Hologram](https://github.com/trulia/hologram)
- [mdcss](https://github.com/jonathantneal/mdcss)
- [Source](https://github.com/sourcejs/Source)
- [Styledoc](https://github.com/Joony/styledoc/)
- [Styledocco](https://github.com/jacobrask/styledocco)
- [Styledown](https://github.com/styledown/styledown)
- [Sc5-styleguide](https://github.com/SC5/sc5-styleguide)

<sub>[⇧ back to top](#contents)</sub>


## Naming conventions & Methodologies :bulb:

* [Atomic Design](http://patternlab.io/resources.html)
* [Atomic OOBEMITSCSS](https://www.sitepoint.com/atomic-oobemitscss/)
* [BEM](https://en.bem.info/)
* [ITCSS](http://itcss.io/)
* [Kickoff CSS](http://trykickoff.com/learn/css.html#namingscheme)
* [MaintainableCSS](http://maintainablecss.com)
* [NCSS](https://ncss.io)
* [OOCSS](https://www.smashingmagazine.com/2011/12/an-introduction-to-object-oriented-css-oocss/)
* [Point North](http://pointnorth.io/#base-browser-styling)
* [RSCSS](https://rscss.io/)
* [SUIT CSS](https://github.com/suitcss/suit/blob/master/doc/naming-conventions.md#u-utilityname)
* [Title CSS](https://www.sitepoint.com/title-css-simple-approach-css-class-naming/)

<sub>[⇧ back to top](#contents)</sub>


## CSS in JS

* [Aphrodite](https://github.com/Khan/aphrodite)
* [Babel-plugin-css-in-js](https://github.com/martinandert/babel-plugin-css-in-js)
* [Classy](https://github.com/inturn/classy)
* [Csjs](https://github.com/rtsao/csjs)
* [Css-loader](https://github.com/webpack/css-loader)
* [JSS](https://github.com/cssinjs/jss)
* [React-styled](https://github.com/bloodyowl/react-styled)
* [React-with-styles](https://github.com/airbnb/react-with-styles)
* [Styled-jsx](https://github.com/zeit/styled-jsx)
* [Styled-components](https://github.com/styled-components/styled-components)
* [Stylin](https://github.com/sultan99/stylin)


Here is a [CSS in JS techniques comparison](https://github.com/MicheleBertoli/css-in-js)

<sub>[⇧ back to top](#contents)</sub>


## CSS Polyfills

* [Polyfill.js](https://github.com/philipwalton/polyfill/) - A library to make creating CSS polyfills much easier.
* [Prefixfree](https://github.com/LeaVerou/prefixfree) - Break free from CSS prefix hell.
* [Fixed-sticky](https://github.com/filamentgroup/fixed-sticky) - A CSS position:sticky polyfill.
* [Selectivizr](https://github.com/keithclark/selectivizr) - A JavaScript utility that emulates CSS3 pseudo-classes and attribute selectors in Internet Explorer 6-8.
* [PIE](https://github.com/lojjic/PIE) - Allows Internet Explorer to recognize and render various CSS3 box decoration properties.


<sub>[⇧ back to top](#contents)</sub>


## Miscellaneous

* [Beautiful CSS box-shadow examples](https://getcssscan.com/css-box-shadow-examples) - Curated collection of 93 beautiful CSS box-shadow. Click to copy.
* [Can I use](https://caniuse.com/) - Browser support for CSS, HTML5 and other front-end web technologies.
* [Flexbox Patterns](https://flexboxpatterns.com/) by cjcenizal
* [Glassmorphism CSS Generator](https://ui.glass/generator/) - Generate CSS for glassmorphism.
* [GradientArt](https://gra.dient.art/) - An advanced CSS gradient editor with layering, design tools and free cloud storage.
* [Live editor for CSS and LESS](https://github.com/webextensions/live-css-editor) - Magic CSS extension for Chrome, Firefox and Edge.
* [RevengeCSS](https://github.com/Heydon/REVENGE.CSS) - A CSS bookmarklet that uses selectors to find bad markup, displaying ugly pink error messages in comic sans serif wherever you write bad HTML
* [Single Div Project](https://github.com/ManrajGrover/SingleDivProject) - One `<div>`. Many possibilities.
* [You Might Not Need JS](http://youmightnotneedjs.com/) - CSS alternatives for common JS UI components.
* [Xpath-to-selector](https://github.com/steambap/xpath-to-selector) - Convert xpath to css selector.

<sub>[⇧ back to top](#contents)</sub>

## Podcasts :radio:

*Something to listen to while programming.*

* [CSS Podcast](https://thecsspodcast.libsyn.com/) - Una Kravets and Adam Argyle,and development.
* [Non Breaking Space Show](http://goodstuff.fm/nbsp) - Seeking out the best,and smartest creative people on digital art,and the accompanying blog,and UX.
* [Shop Talk Show](http://shoptalkshow.com/) - A live podcast with Chris Coyier and Dave Rupert about front-end web design,hosted by Anna Debenham and Brad Frost.
* [Syntax](https://syntax.fm/) - A Tasty Treats Podcast for Web Developers.,typography,web technology
* [The Big Web Show](http://5by5.tv/bigwebshow/) - Topics like web publishing,is all about keeping you updated with the latest in Open Source Technology.
* [The Changelog](https://changelog.com/) - The tagline for the Changelog says it all: “Open Source moves fast. Keep up.” This podcast,and more. It's everything web that matters.
* [The Web Ahead](http://5by5.tv/webahead/) - Conversations with world experts on changing technologies and future of the web.

<sub>[⇧ back to top](#contents)</sub>


## Twitter :satellite:

*Active accounts to follow.*

* [Adam Morse](https://twitter.com/mrmrs_) - Advocate for users and open-source.
* [Andrey Sitnik](https://twitter.com/andreysitnik) - Author of @Autoprefixer, http://easings.net  and @PostCSS.
* [Ben Briggs](https://twitter.com/ben_eb) - Final year web technologies student. node.js, javascript, open source modules, client side optimisation, web performance.
* [Brad Frost](https://twitter.com/brad_frost) - Web designer, speaker, writer, consultant, musician.
* [Chris Coyier](https://twitter.com/chriscoyier) - Designer @CodePen. Writer @Real_CSS_Tricks.
* [Connor Sears](https://twitter.com/connors) - Designer at GitHub.
* [CSS Animation](https://twitter.com/cssanimation)
* [CSS Commits](https://twitter.com/CSScommits) - Latest commits to @CSSWG’s public Mercurial repository.
* [Daniel Glazman](https://twitter.com/glazou) - W3C CSS Working Group Co-chairman, entrepreneur, software engineer, geek, father of two, polyglot, duck lover. Nah. Tweets are strictly mine.
* [Dave McFarland](https://twitter.com/davemcfarland) - Web developer, author of CSS: The Missing Manual, JavaScript & jQuery.
* [Donovan Hutchinson](https://twitter.com/donovanh) - Designer, developer, writer. Occasionally blogs at http://Hop.ie, and currently building @cssanimation.
* [Dudley Storey](https://twitter.com/dudleystorey) - Web development writer, teacher, and speaker.
* [Eric Bidelman](https://twitter.com/ebidel) - Engineer at Google working on Chrome, web components, and Polymer.
* [Evangelina Ferreira](https://twitter.com/evaferreira92) - Web Designer. Professor at @multimedial_utn HTML5 & CSS Freak. Ocassional Translator.
* [Guy Routledge](https://twitter.com/guyroutledge) - Front-end dev, Teacher @GA_London, Screencaster at http://www.atozcss.com, property snob, Foodie.
* [Harry Roberts](https://twitter.com/csswizardry)- Consultant Front-end Architect: @google, @Etsy, @kickstarter, @BBC, @Deloitte, @FT, more.
* [Heydon Pickering](https://twitter.com/heydonworks) - Moderate consumer of rice. Also a UX designer, author, @smashingmag editor and programmer.
* [Jonathan Snook](https://twitter.com/snookca) - Designer, Developer, Writer, Speaker. I make stuff on the web. I wrote SMACSS.
* [Kitty Giraudel](https://twitter.com/KittyGiraudel) - Non-binary accessibility & diversity advocate, frontend developer, author.
* [L. David Baron](https://twitter.com/davidbaron) - Mozilla developer, CSS and W3C standards diplomat.
* [Lea Verou](https://twitter.com/LeaVerou) - Research Assistant @MIT_CSAIL, @CSSWG IE, @OReillyMedia author, Ex @W3C staff.
* [Manoela Ilic](https://twitter.com/crnacura) - ...aka Mary Lou @codrops ༶ CSS & HTML are my crayons ༶ Interested in Cognitive Science, AI, HCI, UI Design & Astrophysics ༶ Digital nomad.
* [Mark Otto](https://twitter.com/mdo) - GitHub and Bootstrap. Formerly at Twitter. Huge nerd.
* [Maxime Thirouin](https://twitter.com/MoOx) - Freelance front-end vigilante, UI/UX developer.
* [Natalie Weizenbaum](https://twitter.com/nex3) - Trans coder lady. Lead designer/developer of @SassCSS, working for @google on @dart_lang.
* [Nicolas Gallagher](https://twitter.com/necolas) - Software Engineer at @twitter.
* [Nicole Sullivan](https://twitter.com/stubbornella) - GEEK.
* [Patrick Hamann](https://twitter.com/patrickhamann) - Lover of mountains, craft beers and discovering new food.
* [Paul Lewis](https://twitter.com/aerotwist) - Googler who noodles with code and design.
* [Phil Walton](https://twitter.com/philwalton) - Engineer at Google • Open Source Advocate • Developer • Designer • Writer.
* [Rachel Andrew](https://twitter.com/rachelandrew) - Web Developer, half of @grabaperch CMS, CSS Working Group Invited Expert.
* [Remy Sharp](https://twitter.com/rem) - All about CSS sizing units.
* [Sara Soueidan](https://twitter.com/SaraSoueidan) - Author of the @Codrops CSS Reference & Co-author of the Smashing Book #5.
* [Scott Jehl](https://twitter.com/scottjehl) - Author of @responsiblerwd, now on sale from @abookapart.
* [Simon](https://twitter.com/simurai) - UI designer, CSS doodler.
* [The Chris Eppstein](https://twitter.com/chriseppstein) - Loves love. Hates hate. Has a kick-ass family. Writes code. Leads stylesheet tech @LinkedIn.
* [Una Kravets](https://twitter.com/Una) - Front-end @IBMDesign. Sassvocate, community builder, & handcrafter. STEMinist :) Open source all the things.
* [Zoe M. Gillenwater](https://twitter.com/zomigi) - Web designer/developer specializing in CSS, RWD, UX, & accessibility.
* [Zoltán Szőgyényi](https://twitter.com/zoltanszogyenyi) - Web developer, Co-founder at Themesberg. I'm building Glass UI.
* [앗킨스 탭](https://twitter.com/tabatkins) - Literally Jenn Schiffer's Mom.

<sub>[⇧ back to top](#contents)</sub>


## Videos :tv:

*Good study videos from CSS Must Watch Videos. Some items are quoted from [AllThingsSmitty/must-watch-css](https://github.com/AllThingsSmitty/must-watch-css).

[I told him on Twitter](https://twitter.com/sota0805/status/527635856031375360). I appreciate his valuable efforts.*

### 2019

1. [Next-Generation Web Styling](https://www.youtube.com/watch?v=-oyeaIirVC0) - Una Kravets & Adam Argyle @ Chrome Dev Summit 2019.

### 2016

1. [Component-Based Style Reuse](https://www.youtube.com/watch?v=_70Yp8KPXH8) :page_facing_up: [transcript](https://2016.cssconf.com/) :watch: `37:24` - Pete Hunt @ CSS conf 2016.
1. [CSS4 Grid: True Layout Finally Arrives](https://www.youtube.com/watch?v=jl164y-Vb5E) :page_facing_up: [transcript](https://2016.cssconf.com/) :watch: `29:27` - Jen Kramer @ CSS conf 2016.
1. [Houdini: Demystifying the Future of CSS](https://www.youtube.com/watch?v=sE3ttkP15f8) :watch: `36:58` @ Google I/O 2016.

### 2015

1. [Mdo-ular CSS](http://jqueryuk.com/2015/videos.php?s=mdo-ular-css) :watch: `30:06` - Mark Otto @ jQuery UK.
1. [CSS Architecture with SMACSS](https://www.youtube.com/watch?v=6co781JgoqQ) :watch: `30:15` - Caleb Meredith @ DevTips channel.
1. [CSS Workflow from the Ground Up](https://www.youtube.com/watch?v=ZVk3GQHfkbU) :watch: `46:06` - Jonathan Snook @ Generate conf 2015.

<sub>[⇧ back to top](#contents)</sub>

## Books :books:

* [CSS: The Definitive Guide, 4th Edition](http://shop.oreilly.com/product/0636920012726.do)  - Visual Presentation for the Web
* [CSS: The Missing Manual](http://shop.oreilly.com/product/0636920036357.do) – Really Helpful in Advancing your Design Skills to a whole new Level
* [CSS Secrets](http://shop.oreilly.com/product/0636920031123.do) – Better Solutions to Everyday Web Design Problems
* [Every Layout: Relearn CSS Layout](https://every-layout.dev/) – Solving responsive layout problems using algorithmic design.
* [Tiny CSS Projects](https://www.manning.com/books/tiny-css-projects) – Improve the way you write CSS as you build 12 tiny projects.

<sub>[⇧ back to top](#contents)</sub>

## Tutorials :clapper:

* [30 Seconds of CSS](https://www.30secondsofcode.org/css/p/1) -  A curated collection of useful CSS snippets you can understand in 30 seconds or less.
* [All selectors in CSS](https://medium.com/@ymzEmre/css-cascade-specificity-basic-selectors-c5adc01dd861) - All selectors in CSS.
* [Community Curated CSS Resources](https://hackr.io/tutorials/learn-css) - Top Recommended Resources.
* [CSS Diner](https://flukeout.github.io/) – Interactive gamified tutorial for learning selection with CSS.
* [CSS Grid PlayGround](https://mozilladevelopers.github.io/playground/) - Simple tutorial to learn CSS Grid from Mozilla.
* [CSS Grids videos tutorial](https://cssgrid.io/) - Free video course by Wes Bos to learn CSS Grids.
* [CSS Hands-on Tutorial](https://labex.io/tutorials/quick-start-with-css-free-tutorials-413795) - Free CSS hands-on tutorial by LabEx.
* [CSS Math Functions](https://stackdiary.com/css-math-functions/) - Using CSS Math for responsive design.
* [Flexbox video tutorial](https://flexbox.io/) - Free video course by Wes Bos to learn flexbox.
* [Organize CSS with a Modular Architecture: OOCSS, BEM, SMACSS](https://snipcart.com/blog/organize-css-modular-architecture) - In-depth intro to OOCSS, BEM, SMACSS, with examples.
* [Work With Animations](https://developer.mozilla.org/en-US/docs/Tools/Page_Inspector/How_to/Work_with_animations) - Inspecting animations.

<sub>[⇧ back to top](#contents)</sub>

## Maintainers

[sotayamashita]: https://github.com/sotayamashita
[Rishabh04-02]:  https://github.com/Rishabh04-02

[@sotayamashita][sotayamashita], [@Rishabh04-02][Rishabh04-02] and You!


## Contribute

[contributor-covenant]: https://www.contributor-covenant.org/version/1/3/0/code-of-conduct/

Feel free to dive in! Open an issue or submit PRs.

Awesome CSS follows the [Contributor Covenant][contributor-covenant] Code of Conduct.
