<div class="github-widget" data-repo="micromata/awesome-css-learning"></div>
## Awesome CSS Learning [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) <a href="https://developer.mozilla.org/docs/Web/CSS"><img src="https://upload.wikimedia.org/wikipedia/commons/d/d5/CSS3_logo_and_wordmark.svg" width="125" align="right" alt="CSS Logo"></a>

&gt; 一个很棒的列表，仅限于最好的 CSS 学习资源

这份榜单主要是关于 [CSS](https://developer.mozilla.org/docs/Web/CSS)  – 语言和模块. 与命名约定、架构范例、框架、预处理器、后处理器、CSS-in-JS 或当今 CSS 生态系统的其他方面无关.

*请阅读 [contribution guidelines](https://github.com/micromata/awesome-css-learning/blob/master/.github/contributing.md) 在贡献之前.*



---

## CSS References

- [codrops](https://tympanus.net/codrops/css_reference/) - 广泛的 CSS 参考提供了比 [MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/Reference).
- [Can I use](https://caniuse.com) - 交互式浏览器支持 CSS（和 HTML5）表格.

## CSS in a nutshell

- [Introduction to CSS](https://scrimba.com/g/gintrotocss) - 这个截屏视频系列将在大约一小时内教您 CSS 的基础知识.

## Fundamental concepts

- [The cascade](https://developer.mozilla.org/en-US/docs/Web/CSS/Cascade) - 本文解释了级联是什么以及它对您有何影响.
- [Specificity and inheritance](https://www.smashingmagazine.com/2010/04/css-specificity-and-inheritance/)  - 了解特异性和继承对于掌握 CSS 很重要. 这篇文章会有所帮助.
- [CSS Box Model](https://developer.mozilla.org/en-US/docs/Learn/CSS/Introduction_to_CSS/Box_model) - 一篇解释网络布局基础的文章.
  - 还可以查看有关的详细信息 [box-sizing](https://css-tricks.com/box-sizing/) 财产.
- [Responsive Design](https://web.dev/learn/design/) - 有关响应式设计各个方面的广泛信息，使网站看起来很棒并且适合所有人.

## CSS units

- [The Lengths of CSS](https://css-tricks.com/the-lengths-of-css/) - 涵盖绝对和相对单位的概述.
- [Fun with Viewport Units](https://css-tricks.com/fun-viewport-units/) - 传授基础知识并展示一些漂亮的用例.

## Selectors

- [Basic CSS Selectors](https://www.sitepoint.com/css-selectors/) - 介绍您需要了解的非常基本的 CSS 选择器.
- [Advanced CSS Selectors](https://www.smashingmagazine.com/2009/08/taming-advanced-css-selectors/)  - 提升你的知识水平. 从属性选择器到 CSS3 伪类.
- [CSS Diner](https://flukeout.github.io) - 了解如何在这个有趣的小游戏中使用 CSS 选择器.

## Custom properties (aka CSS variables)

- [CSS Variables: Why Should You Care?](https://developers.google.com/web/updates/2016/02/css-variables-why-should-you-care) - CSS 变量的简短介绍.
- [Locally Scoped CSS Variables: What, How, and Why](https://una.im/local-css-vars/) - 描述局部作用域 CSS 变量的优点.
- [Using CSS variables correctly](https://www.madebymike.com.au/writing/using-css-variables/) - 使用 CSS 变量的模式和反模式.
- [Everything you need to know about CSS Variables](https://medium.freecodecamp.org/everything-you-need-to-know-about-css-variables-c74d922ea855) - 使用真实示例超越 CSS 变量基础知识的深度文章.
- [Getting Reactive with CSS](https://www.youtube.com/watch?v=4IRPxCMAIfA) - 令人兴奋的讨论在 JavaScript 中结合 CSS 变量和函数式反应式编程的可能性.

## Layout

- [Learn CSS Layout](http://book.mixu.net/css) - 在 5 章中了解 CSS 布局技术.
- [Layout Land](https://www.youtube.com/channel/UC7TizprGknbDalbHplROtag) - 关于新 CSS 布局可能性的 Jen Simmons 视频系列.
- [Laying Out The Future With Grid And Flexbox](https://www.youtube.com/watch?v=hj355PRbwSQ) - 引入了一个新的布局系统，包括 Flexbox、CSS Grid 和 Box Alignment Module.

### Classic layouting

- [Floats](https://tympanus.net/codrops/css_reference/float/) - 关于如何使用（和清除）浮动的深入信息.
- [Positioning Types](https://scotch.io/bar-talk/5-things-you-might-not-know-about-the-css-positioning-types) - 深入了解一些与CSS定位布局方式相关的鲜为人知的事情.
- [inline-block](https://iamsteve.me/blog/entry/inline_block) - 显示在哪些情况下使用显示属性“inline-block”进行布局是有意义的.

### Flexbox

- [A Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) - 所有你需要知道的关于 Flexbox 的信息都在一页上.
<!--lint ignore no-dead-urls-->
- [Flexbox playground](https://codepen.io/enxaneta/full/adLPwv) - 在 CodePen 上玩 Flexbox 示例.
- [Flexbox Defense](http://www.flexboxdefense.com) - 浏览器中的塔防游戏，让您在乐趣中学习 Flexbox.
- [Flexbox Froggy](https://flexboxfroggy.com) - 通过一个涉及青蛙和睡莲叶的有趣游戏来学习 Flexbox 的所有基础知识.
- [Flexbugs](https://github.com/philipwalton/flexbugs) - 社区策划的 flexbox 问题列表和它们的跨浏览器解决方法.
- [Flexbox Zombies](https://flexboxzombies.com) - 一个由故事情节驱动的培训课程，您可以在其中使用 Flexbox 和弩来猎杀僵尸.
- [What the Flexbox?](https://flexbox.io/) - 一个简单、免费的 20 个视频课程，将帮助您掌握 CSS Flexbox！

### Grid

- [A Complete Guide to Grid](https://css-tricks.com/snippets/css/complete-guide-grid/) - 所有您需要了解的有关一页 CSS 网格布局的信息.
- [Grid by Example](https://gridbyexample.com) - 除了如何使用 Grid 的示例外，该站点还提供其他有用的学习资源.
- [Designing with Grid](https://talks.jensimmons.com/J5VRbA/designing-with-grid) - 谈论 CSS Grid 提供的新布局可能性.
- [Grid Garden](https://cssgridgarden.com) - 可爱的游戏，您可以在其中编写 CSS 代码来种植您的胡萝卜园.
- [GridBugs](https://github.com/rachelandrew/gridbugs) - 社区策划的网格互操作问题列表及其解决方法.
- [Grid Critters](https://www.gridcritters.com) - 通过掌握冒险游戏来学习 CSS 网格布局.
- [CSS Grid](https://cssgrid.io) - 与 Wes Bos 一起学习 CSS 网格 - 免费的 4 小时视频课程，25 个视频.

## Animation

- [CSS Transitions and Transforms for Beginners](https://robots.thoughtbot.com/transitions-and-transforms) - 介绍 CSS 转换和 CSS (2D) 转换.
- [All you need to know about CSS Transitions](https://blog.alexmaccaw.com/all-you-need-to-know-about-css-transitions/) - 还涉及从链接和事件到硬件加速和动画功能的高级主题.
- [CSS 3D transforms](https://3dtransforms.desandro.com) - 多页教程，包含卡片翻转和旋转木马效果等示例.
- [CSS Animation for Beginners](https://robots.thoughtbot.com/css-animation-for-beginners) - 使用关键帧传授 CSS 动画的概念.
- [animatable](http://leaverou.github.io/animatable/) - 漂亮的小页面展示了哪些 CSS 属性是可动画的. 

---

## Related

[Awesome JavaScript Learning](https://github.com/micromata/awesome-javascript-learning) - 一个仅限于最佳 JavaScript 学习资源的小列表.
