<div class="github-widget" data-repo="troxler/awesome-css-frameworks"></div>
## Awesome CSS Frameworks [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

List of awesome CSS frameworks.  
Feel free to [contribute](https://github.com/troxler/awesome-css-frameworks/blob/master/.github/CONTRIBUTING.md).

**Supported by [FrontAid CMS](https://frontaid.io/?pk_campaign=cssfw)**:

<a href="https://frontaid.io/?pk_campaign=cssfw"><img
  src="https://raw.githubusercontent.com/troxler/awesome-css-frameworks/master/media/frontaid.png"
  width="600"
  alt="FrontAid CMS - Agile Content Management with Git."></a>



## Base / Reset / Normalize

- [**modern-normalize**](https://github.com/sindresorhus/modern-normalize) - Normalize browsers' default style.  
  ![](https://img.shields.io/github/stars/sindresorhus/modern-normalize.svg?style=social&label=Star)
  [Repo](https://github.com/sindresorhus/modern-normalize)
  | #CSS

- [**ress**](https://github.com/filipelinhares/ress) - Modern CSS reset.  
  ![](https://img.shields.io/github/stars/filipelinhares/ress.svg?style=social&label=Star)
  [Repo](https://github.com/filipelinhares/ress)
  | #CSS

- [**Natural Selection**](https://github.com/frontaid/natural-selection) - Collection of best-practice CSS selectors.  
  ![](https://img.shields.io/github/stars/frontaid/natural-selection.svg?style=social&label=Star)
  | #CSS


## Class-less

Frameworks that use semantic HTML and do not rely on classes.

- [**MVP.css**](https://andybrewer.github.io/mvp/) - Minimalist stylesheet for HTML elements.  
  ![](https://img.shields.io/github/stars/andybrewer/mvp.svg?style=social&label=Star)
  [Docs](https://andybrewer.github.io/mvp/#docs),
  [Repo](https://github.com/andybrewer/mvp/)
  | #CSS

- [**sakura**](https://oxal.org/projects/sakura/) - Minimal classless CSS framework/theme.  
  ![](https://img.shields.io/github/stars/oxalorg/sakura.svg?style=social&label=Star)
  [Demo](https://oxal.org/projects/sakura/demo/),
  [Repo](https://github.com/oxalorg/sakura)
  | #SCSS

- [**Simple.css**](https://simplecss.org/) - Lightweight, classless CSS framework.  
  ![](https://img.shields.io/github/stars/kevquirk/simple.css?style=social&label=Star)
  [Demo](https://simplecss.org/demo),
  [Docs](https://github.com/kevquirk/simple.css/wiki),
  [Repo](https://github.com/kevquirk/simple.css/)
  | #CSS

- [**Tacit**](https://yegor256.github.io/tacit/) - CSS framework for dummies, without classes.  
  ![](https://img.shields.io/github/stars/yegor256/tacit.svg?style=social&label=Star)
  [Repo](https://github.com/yegor256/tacit/)
  | #SCSS


## Very Lightweight

Frameworks that are smaller than ~5KB.

- [**Pure**](https://purecss.io) - Set of small, responsive CSS modules that you can use in every web project.  
  ![](https://img.shields.io/github/stars/pure-css/pure.svg?style=social&label=Star)
  [Demo](https://purecss.io/layouts/),
  [Docs](https://purecss.io/start/),
  [Repo](https://github.com/pure-css/pure)
  | #CSS

- [**Picnic CSS**](https://picnicss.com) - Lightweight and beautiful library.  
  ![](https://img.shields.io/github/stars/franciscop/picnic.svg?style=social&label=Star)
  [Demo](https://picnicss.com/tests),
  [Docs](https://picnicss.com/documentation),
  [Repo](https://github.com/franciscop/picnic)
  | #SCSS

- [**Chota**](https://jenil.github.io/chota/) - Really small CSS framework.  
  ![](https://img.shields.io/github/stars/jenil/chota.svg?style=social&label=Star)
  [Demo](https://raw.githack.com/jenil/chota/master/test/index.html),
  [Docs](https://jenil.github.io/chota/#docs),
  [Repo](https://github.com/jenil/chota)
  | #CSS


## General Purpose

- [**Bootstrap**](https://getbootstrap.com) - The most popular HTML, CSS, and JavaScript framework for developing responsive, mobile first projects on the web.  
  ![](https://img.shields.io/github/stars/twbs/bootstrap.svg?style=social&label=Star)
  [Demo](https://getbootstrap.com/docs/4.0/examples/),
  [Docs](https://getbootstrap.com/docs/4.0/),
  [Repo](https://github.com/twbs/bootstrap)
  | #SCSS

- [**Bulma**](https://bulma.io) - Modern CSS framework based on Flexbox.  
  ![](https://img.shields.io/github/stars/jgthms/bulma.svg?style=social&label=Star)
  [Demo](https://bulma.io/expo/),
  [Docs](https://bulma.io/documentation/overview/start/),
  [Repo](https://github.com/jgthms/bulma)
  | #Sass

- [**Foundation**](https://get.foundation/) - The most advanced responsive front-end framework in the world.  
  ![](https://img.shields.io/github/stars/zurb/foundation-sites.svg?style=social&label=Star)
  [Demo](https://get.foundation/templates.html),
  [Docs](https://get.foundation/sites/docs/),
  [Repo](https://github.com/foundation/foundation-sites)
  | #SCSS

- [**UIkit**](https://getuikit.com) - Lightweight and modular front-end framework for developing fast and powerful web interfaces.  
  ![](https://img.shields.io/github/stars/uikit/uikit.svg?style=social&label=Star)
  [Demo](https://getuikit.com/v2/showcase/index.html),
  [Docs](https://getuikit.com/docs/introduction),
  [Repo](https://github.com/uikit/uikit)
  | #LESS #SCSS

- [**Primer**](https://primer.style/) - CSS framework that powers GitHub's front-end design.  
  ![](https://img.shields.io/github/stars/primer/css.svg?style=social&label=Star)
  [Docs](https://primer.style/css/),
  [Repo](https://github.com/primer/css)
  | #SCSS

- [**Pico.css**](https://picocss.com/) - Elegant styles for all native HTML elements, dark mode automatically enabled.  
  ![](https://img.shields.io/github/stars/picocss/pico.svg?style=social&label=Star)
  [Demo](https://picocss.com/#examples),
  [Docs](https://picocss.com/docs/),
  [Repo](https://github.com/picocss/pico)
  | #SCSS

- [**Carbon Components**](https://www.carbondesignsystem.com/) - Component library behind IBM's Carbon Design System.  
  ![](https://img.shields.io/github/stars/carbon-design-system/carbon-components.svg?style=social&label=Star)
  [Docs](https://www.carbondesignsystem.com/components/overview/),
  [Repo](https://github.com/carbon-design-system/carbon)
  | #SCSS

- [**U.S. Web Design System**](https://designsystem.digital.gov/) - Components used by U.S. federal government websites.  
  ![](https://img.shields.io/github/stars/uswds/uswds.svg?style=social&label=Star)
  [Docs](https://designsystem.digital.gov/components/overview/),
  [Repo](https://github.com/uswds/uswds)
  | #SCSS

- [**Fomantic-UI**](https://fomantic-ui.com/) - Build beautiful websites fast, with concise HTML, intuitive javascript, and simplified debugging.  
  ![](https://img.shields.io/github/stars/fomantic/fomantic-ui.svg?style=social&label=Star)
  [Docs](https://fomantic-ui.com/introduction/getting-started.html),
  [Repo](https://github.com/fomantic/fomantic-ui/)
  | #LESS

- [**Blaze UI**](https://www.blazeui.com) - Open source modular toolkit providing great structure for building websites quickly with a scalable and maintainable foundation.  
  ![](https://img.shields.io/github/stars/BlazeSoftware/atoms.svg?style=social&label=Star)
  [Demo](https://www.blazeui.com/components/buttons/),
  [Docs](https://www.blazeui.com/getting-started/install/),
  [Repo](https://github.com/BlazeSoftware/atoms)
  | #SCSS

- [**Cirrus**](https://cirrus-ui.netlify.app/) - Component and utility centric SCSS framework designed for rapid prototyping.  
  ![](https://img.shields.io/github/stars/spiderpig86/Cirrus.svg?style=social&label=Star)
  [Demo](https://cirrus-ui.netlify.app/getting-started/examples),
  [Docs](https://cirrus-ui.netlify.app/getting-started/setup),
  [Repo](https://github.com/Spiderpig86/Cirrus)
  | #CSS

- [**Vanilla Framework**](https://vanillaframework.io/) - Simple, extensible CSS framework. Written by the Canonical Web Team.  
  ![](https://img.shields.io/github/stars/canonical-web-and-design/vanilla-framework.svg?style=social&label=Star)
  [Demo](https://vanillaframework.io/docs/examples),
  [Docs](https://vanillaframework.io/docs/),
  [Repo](https://github.com/canonical/vanilla-framework)
  | #SCSS

- [**PatternFly**](https://www.patternfly.org/) - UI framework for enterprise web applications.  
  ![](https://img.shields.io/github/stars/patternfly/patternfly.svg?style=social&label=Star)
  [Demo](https://www.patternfly.org/patterns/about-patterns),
  [Docs](https://www.patternfly.org/get-started/),
  [Repo](https://github.com/patternfly/patternfly)
  | #SCSS #LESS

- [**Stacks**](https://stackoverflow.design/) - UI components used by Stack Overflow.  
  ![](https://img.shields.io/github/stars/StackExchange/Stacks.svg?style=social&label=Star)
  [Docs](https://stackoverflow.design/product/develop/using-stacks/),
  [Repo](https://github.com/StackExchange/Stacks)
  | #LESS

- [**HiQ**](https://jonathanharrell.github.io/hiq/) - Simple CSS foundation with responsive typography and input styling.  
  ![](https://img.shields.io/github/stars/jonathanharrell/hiq.svg?style=social&label=Star)
  [Docs](https://jonathanharrell.github.io/hiq/guide/),
  [Repo](https://github.com/jonathanharrell/hiq/)
  | #PostCSS


## Material Design

- [**Material Components Web**](https://material.io/components/web/) - Modular and customizable Material Design UI components for the web.  
  ![](https://img.shields.io/github/stars/material-components/material-components-web.svg?style=social&label=Star)
  [Demo](https://material.io/components?platform=web),
  [Docs](https://material.io/develop/web/getting-started),
  [Repo](https://github.com/material-components/material-components-web)
  | #SCSS

- [**Beer CSS**](https://www.beercss.com) - Build material design interfaces in record time without stress for devs.  
  ![](https://img.shields.io/github/stars/beercss/beercss.svg?style=social&label=Star)
  [Repo](https://github.com/beercss/beercss)
  | #CSS

- [**Materialize**](https://materializecss.github.io/materialize/) - Responsive front-end library based on Google's Material Design.  
  ![](https://img.shields.io/github/stars/materializecss/materialize.svg?style=social&label=Star)
  [Docs](https://materializecss.github.io/materialize/getting-started.html),
  [Repo](https://github.com/materializecss/materialize)
  | #SCSS


## Utility-based

- [**Tailwind CSS**](https://tailwindcss.com) - Utility-first CSS framework for rapid UI development.  
  ![](https://img.shields.io/github/stars/tailwindlabs/tailwindcss.svg?style=social&label=Star)
  [Docs](https://tailwindcss.com/docs),
  [Repo](https://github.com/tailwindlabs/tailwindcss)
  | #CSS

- [**Open Props**](https://open-props.style) - CSS custom properties to help accelerate adaptive and consistent design.  
  ![](https://img.shields.io/github/stars/argyleink/open-props.svg?style=social&label=Star)
  [Demo](https://open-props.style/#gallery),
  [Docs](https://open-props.style/#getting-started),
  [Repo](https://github.com/argyleink/open-props/)
  | #CSS #PostCSS


## Specialized

- [**NES.css**](https://nostalgic-css.github.io/NES.css/) - NES-style CSS Framework.  
  ![](https://img.shields.io/github/stars/nostalgic-css/NES.css.svg?style=social&label=Star)
  [Demo](https://nostalgic-css.github.io/NES.css/),
  [Docs](https://github.com/nostalgic-css/NES.css#installation),
  [Repo](https://github.com/nostalgic-css/NES.css)
  | #SCSS

- [**98.css**](https://jdan.github.io/98.css/) - CSS library for building interfaces that look like Windows 98.  
  ![](https://img.shields.io/github/stars/jdan/98.css.svg?style=social&label=Star)
  [Repo](https://github.com/jdan/98.css)
  | #CSS

- [**Tufte CSS**](https://edwardtufte.github.io/tufte-css/) - Style your webpage like Edward Tufte’s handouts.  
  ![](https://img.shields.io/github/stars/edwardtufte/tufte-css.svg?style=social&label=Star)
  [Repo](https://github.com/edwardtufte/tufte-css)
  | #CSS

- [**Gutenberg**](https://github.com/BafS/Gutenberg) - Modern framework to print the web correctly.  
  ![](https://img.shields.io/github/stars/BafS/Gutenberg.svg?style=social&label=Star)
  [Demo](https://bafs.github.io/Gutenberg/),
  [Docs](https://github.com/BafS/Gutenberg#what-does-the-framework-do-)
  | #SCSS

- [**System.css**](https://sakofchit.github.io/system.css/) - Design system for building retro Apple interfaces.  
  ![](https://img.shields.io/github/stars/sakofchit/system.css.svg?style=social&label=Star)
  [Repo](https://github.com/sakofchit/system.css)
  | #PostCSS

- [**XP.css**](https://botoxparty.github.io/XP.css/) - CSS library for building interfaces that look like Windows XP.  
  ![](https://img.shields.io/github/stars/botoxparty/XP.css.svg?style=social&label=Star)
  [Repo](https://github.com/botoxparty/XP.css)
  | #PostCSS

- [**TuiCss**](https://github.com/vinibiavatti1/TuiCss) - Library to create MS-DOS interfaces.  
  ![](https://img.shields.io/github/stars/vinibiavatti1/TuiCss.svg?style=social&label=Star)
  [Demo](https://github.com/vinibiavatti1/TuiCss/wiki/Examples),
  [Docs](https://github.com/vinibiavatti1/TuiCss/wiki)
  | #SCSS

- [**7.css**](https://khang-nd.github.io/7.css/) - CSS library for building interfaces that look like Windows 7.  
  ![](https://img.shields.io/github/stars/khang-nd/7.css.svg?style=social&label=Star)
  [Repo](https://github.com/khang-nd/7.css)
  | #PostCSS

- [**Bojler**](https://bojler.slicejack.com) - Email framework for developing responsive and lightweight email templates.  
  ![](https://img.shields.io/github/stars/Slicejack/bojler.svg?style=social&label=Star)
  [Docs](https://bojler.slicejack.com/documentation/getting-started/),
  [Repo](https://github.com/Slicejack/bojler)
  | #SCSS


## Stalled Development

Frameworks that have not seen any real development for more than about one year or officially have been deprecated.
We are keeping them here for reference/inspiration and hope for a revival.

<details>
  <summary><strong>Show Section</strong></summary>

- [**Semantic UI**](https://semantic-ui.com) - User interface is the language of the web.  
  ![](https://img.shields.io/github/stars/semantic-org/semantic-ui.svg?style=social&label=Star)
  [Docs](https://semantic-ui.com/introduction/getting-started.html),
  [Repo](https://github.com/semantic-org/semantic-ui)
  | #LESS

- [**Tachyons**](https://tachyons.io) - Quickly build and design new UI without writing CSS.  
  ![](https://img.shields.io/github/stars/tachyons-css/tachyons.svg?style=social&label=Star)
  [Demo](https://tachyons.io/gallery/),
  [Docs](https://tachyons.io/docs/),
  [Repo](https://github.com/tachyons-css/tachyons/)
  | #CSS

- [**Bourbon**](https://www.bourbon.io/) - Lightweight Sass tool set.  
  ![](https://img.shields.io/github/stars/thoughtbot/bourbon.svg?style=social&label=Star)
  [Docs](https://www.bourbon.io/docs/latest/),
  [Repo](https://github.com/thoughtbot/bourbon/)
  | #SCSS

- [**Water.css**](https://watercss.kognise.dev/) - Just-add-CSS collection of styles to make simple websites just a little nicer.  
  ![](https://img.shields.io/github/stars/kognise/water.css.svg?style=social&label=Star)
  [Repo](https://github.com/kognise/water.css)
  | #CSS

- [**sanitize.css**](https://csstools.github.io/sanitize.css/) - The best-practices CSS foundation.  
  ![](https://img.shields.io/github/stars/csstools/sanitize.css.svg?style=social&label=Star)
  [Repo](https://github.com/csstools/sanitize.css)
  | #CSS
  
- [**modern-css-reset**](https://github.com/hankchizljaw/modern-css-reset) - Tiny little reset that you can use as the basis of your CSS projects.  
  ![](https://img.shields.io/github/stars/hankchizljaw/modern-css-reset.svg?style=social&label=Star)
  [Repo](https://github.com/hankchizljaw/modern-css-reset)
  | #CSS

- [**minireset.css**](https://jgthms.com/minireset.css/) - Tiny modern CSS reset.  
  ![](https://img.shields.io/github/stars/jgthms/minireset.css.svg?style=social&label=Star)
  [Repo](https://github.com/jgthms/minireset.css)
  | #Sass

- [**CSS Remedy**](https://github.com/jensimmons/cssremedy) - Start your project with a remedy for the technical debt of CSS.  
  ![](https://img.shields.io/github/stars/jensimmons/cssremedy.svg?style=social&label=Star)
  | #CSS

- [**inuitcss**](https://github.com/inuitcss/inuitcss) - Extensible, scalable, Sass-based, OOCSS framework for large and long-lasting UI projects.  
  ![](https://img.shields.io/github/stars/inuitcss/inuitcss.svg?style=social&label=Star)
  [Repo](https://github.com/inuitcss/inuitcss)
  | #SCSS

- [**unsemantic**](https://unsemantic.com) - Fluid grid for mobile, tablet, and desktop.  
  ![](https://img.shields.io/github/stars/nathansmith/unsemantic.svg?style=social&label=Star)
  [Demo](https://unsemantic.com/demo-responsive),
  [Docs](https://unsemantic.com/css-documentation),
  [Repo](https://github.com/nathansmith/unsemantic)

- [**Propeller**](https://propeller.in) - Front-end responsive framework based on Google's Material Design standards & Bootstrap.  
  ![](https://img.shields.io/github/stars/digicorp/propeller.svg?style=social&label=Star)
  [Docs](https://propeller.in/frameworks/open-source/get-started/),
  [Repo](https://github.com/digicorp/propeller)
  | #SCSS

- [**Concise CSS**](https://concisecss.com) - Give up the bloat. Stop tripping over your classes. Be concise.  
  ![](https://img.shields.io/github/stars/ConciseCSS/concise.css.svg?style=social&label=Star)
  [Docs](https://concisecss.com/documentation/),
  [Repo](https://github.com/ConciseCSS/concise.css)
  | #SCSS

- [**Responsive Boilerplate**](https://responsivebp.com) - Powerful, accessible, developer friendly framework for building responsive websites.  
  ![](https://img.shields.io/github/stars/responsivebp/responsive.svg?style=social&label=Star)
  [Docs](https://responsivebp.com/getting-started/),
  [Repo](https://github.com/responsivebp/responsive)
  | #SCSS

- [**turretcss**](https://turretcss.com) - Responsive front-end framework for accessible and semantic websites.  
  ![](https://img.shields.io/github/stars/turretcss/turretcss.svg?style=social&label=Star)
  [Demo](https://turretcss.com/demo/),
  [Docs](https://turretcss.com/getting-started/),
  [Repo](https://github.com/turretcss/turretcss)
  | #CSS

- [**Centurion**](https://www.centurionframework.com) - Web-based framework for rapid prototyping and building larger web projects.  
  ![](https://img.shields.io/github/stars/justinhough/Centurion.svg?style=social&label=Star)
  [Docs](https://github.com/justinhough/Centurion/blob/master/DOCUMENTATION.md),
  [Repo](https://github.com/justinhough/Centurion)

</details>

---

## License
License [CC0 1.0](https://creativecommons.org/publicdomain/zero/1.0/):

> You can copy, modify, distribute and perform the work, even for commercial purposes, all without asking permission.

Images of GitHub stars are provided by [Shields](https://github.com/badges/shields).
