<div class="github-widget" data-repo="j0hnm4r5/awesome-creative-technology"></div>
<div align="center">
	<div>
		<a href="https://github.com/j0hnm4r5/awesome-creative-technology">
			<img width="500" src="https://raw.githubusercontent.com/j0hnm4r5/awesome-creative-technology/master/./logo.gif" alt="Awesome Creative Technology Groups">
		</a>
	</div>
	<br>
	<p>
		Curated list of Creative Technology groups, companies, studios, collectives, etc.
	</p>
	<br>
	<a href="https://awesome.re">
		<img src="https://awesome.re/badge-flat2.svg" alt="Awesome">
	</a>
	<hr>
</div>

## Awesome Creative Technology

> Businesses, groups, agencies, schools, festivals, and conferences that specialize in combining computing, design, art, and user experience.

Creative technology is a broadly interdisciplinary and transdisciplinary field combining computing, design, art, and user experience.

This list hopes to compile the best creative technology groups & resources across the world, both as a source of inspiration and as a reference point for potential employers and meetups of creative technologists.

Creative technologists by definition have a breadth of skills as opposed to a specific specialty, so it's difficult to categorize them. While this isn't a perfect organization, each group below generally specializes in the area to which they've been assigned.

---



---

## Creative Technology

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**1024 Architecture**](https:&#x2F;&#x2F;www.1024architecture.net&#x2F;) | [Paris] | architectural and digital works, orchestrated sound and light scores | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:job@1024architecture.net)
| [**Acrylicize**](https:&#x2F;&#x2F;www.acrylicize.com&#x2F;) | [London] [NYC] [Seattle] | harness the power of art and creativity to help people fall in love with spaces | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:work@acrylicize.com)
| [**Ada**](https:&#x2F;&#x2F;a-da.co&#x2F;) | [NYC] | experience innovation and design agency that partners with the world&#39;s most ambitious visionaries and brands in the culture, arts and social impact space | 
| [**Adirondack Studios**](https:&#x2F;&#x2F;www.adkstudios.com&#x2F;) | [Glens Falls, NY] [Dubai] [Orlando] [Shanghai] [LA] [Singapore] | concept, schematic, design, construction, fabrication, installation, support | [🌐](https:&#x2F;&#x2F;www.adkstudios.com&#x2F;team&#x2F;#careers)
| [**Alt Ethos**](https:&#x2F;&#x2F;altethos.com&#x2F;) | [Denver] | experiential, metaverse, and event design agency | 
| [**Art + Com**](https:&#x2F;&#x2F;artcom.de&#x2F;en&#x2F;) | [Berlin] | media sculptures, data installations, new media | [🌐](https:&#x2F;&#x2F;artcom.de&#x2F;en&#x2F;jobs&#x2F;)
| [**Art Processors**](https:&#x2F;&#x2F;www.artprocessors.net) | [Melbourne] [NYC] | partner with cultural and tourism organisations to invent new realities of human experience | [🌐](https:&#x2F;&#x2F;www.artprocessors.net&#x2F;job-opportunities)
| [**Artists &amp; Engineers**](https:&#x2F;&#x2F;www.artistsandengineers.co.uk&#x2F;) | [London] | production and technology studio, showrooms, concerts, art installations | 
| [**Augmented Magic**](https:&#x2F;&#x2F;www.augmented-magic.com&#x2F;) | [Paris] | augmented magic shows, digital installations | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:contact@augmented-magic.com)
| [**AV Controls**](https:&#x2F;&#x2F;www.av-controls.com&#x2F;) | [NYC] | site-specific technology installations, digital landmarks | [🌐](https:&#x2F;&#x2F;www.av-controls.com&#x2F;jobs-current)
| [**Barbarian**](https:&#x2F;&#x2F;wearebarbarian.com&#x2F;) | [NYC] | marketing and advertising, new media | [🌐](https:&#x2F;&#x2F;wearebarbarian.hire.trakstar.com&#x2F;jobs?)
| [**batwin + robin productions**](https:&#x2F;&#x2F;www.batwinandrobin.com&#x2F;) | [NYC] | environments, interactives, theaters, events | 
| [**Beaudry Interactive**](https:&#x2F;&#x2F;www.binteractive.com&#x2F;) | [LA] | themed entertainment, museum exhibitions, live shows, and branded experiences | 
| [**Blackbow**](https:&#x2F;&#x2F;www.blackbow.cn&#x2F;) | [Beijing] | projection mapping, digital art and cultural experiences | [🌐](https:&#x2F;&#x2F;www.blackbow.cn&#x2F;career&#x2F;)
| [**Blublu**](http:&#x2F;&#x2F;www.blu-blu.com&#x2F;) | [Hangzhou] | projection mapping, immersive experiences for museums and workspace | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:blu@blu-blu.com)
| [**Bluecadet**](https:&#x2F;&#x2F;www.bluecadet.com&#x2F;) | [Philadelphia] [NYC] | experience design across digital and physical environments, visitor centers | [🌐](https:&#x2F;&#x2F;www.bluecadet.com&#x2F;contact&#x2F;careers&#x2F;#custom-shortcode-4)
| [**Brain**](https:&#x2F;&#x2F;brain.wtf) | [LA] | s very serious art studio | 
| [**BRC Imagination Arts**](https:&#x2F;&#x2F;www.brcweb.com&#x2F;) | [Burbank, CA] [Edinburgh] [Amsterdam] | brand and cultural stories, strategy, animation, digital and hybrid experiences | 
| [**BRDG Studios**](https:&#x2F;&#x2F;www.brdg.co&#x2F;) | [Philadelphia] | digital moments in physical spaces, retail environments, art galleries, events | [🌐](https:&#x2F;&#x2F;brdg.co&#x2F;careers&#x2F;)
| [**BREAKFAST**](https:&#x2F;&#x2F;breakfastny.com&#x2F;) | [NYC] | software-&#x2F;hardware-driven artworks, flip discs | [🌐](https:&#x2F;&#x2F;breakfaststudio.com&#x2F;jobs)
| [**Breeze Creative**](https:&#x2F;&#x2F;www.breezecreative.com&#x2F;) | [NYC] [Miami] | interactive experience design, family entertainment, museums, playgrounds, educational institutions | 
| [**Bright**](https:&#x2F;&#x2F;brig.ht&#x2F;) | [Paris] | data visualization, digital installations, experiential sites, video games | [🌐](https:&#x2F;&#x2F;brig.ht&#x2F;contact)
| [**C&amp;G Partners**](https:&#x2F;&#x2F;www.cgpartnersllc.com&#x2F;) | [NYC] | branding, digital installations, exhibits and environments, signage, wayfinding, websites | [🌐](https:&#x2F;&#x2F;www.cgpartnersllc.com&#x2F;about&#x2F;careers&#x2F;)
| [**Charcoalblue**](https:&#x2F;&#x2F;www.charcoalblue.com&#x2F;) | [NYC] [Melbourne] [Chicago] [UK] [London] | amazing spaces where stories are told and experiences are shared | [🌐](https:&#x2F;&#x2F;www.charcoalblue.com&#x2F;work-with-us)
| [**Cinimod Studio**](https:&#x2F;&#x2F;www.cinimodstudio.com) | [London] | location based work where technology, environment, content and real life interaction meet | [🌐](https:&#x2F;&#x2F;www.cinimodstudio.com&#x2F;about)
| [**Cocolab**](https:&#x2F;&#x2F;cocolab.mx&#x2F;en&#x2F;) | [Mexico City] | multimedia experiences, immersive walk, exhibitions, installations, multimedia museography | 
| [**Code and Theory**](https:&#x2F;&#x2F;www.codeandtheory.com&#x2F;) | [NYC] [San Francisco] [London] [Manila] | strategically driven, digital-first agency that lives at the intersection of creativity and technology | [🌐](https:&#x2F;&#x2F;www.codeandtheory.com&#x2F;careers)
| [**Cognition**](https:&#x2F;&#x2F;cognitionlabs.io&#x2F;) | [LA] | an interactive studio designed to enrich experiences by building creative technology with human empathy | [🌐](https:&#x2F;&#x2F;www.codeandtheory.com&#x2F;careers)
| [**Comuzi**](https:&#x2F;&#x2F;www.comuzi.xyz&#x2F;) | [London] | explore and imagine and prototyp and creatr future-forward creative concepts | 
| [**Cosm**](https:&#x2F;&#x2F;www.cosm.com&#x2F;) | [Dallas] [LA] [City] [Pittsburgh] [Gurgaon] | immersive entertainment and media, planetariums, LED domes | [🌐](https:&#x2F;&#x2F;www.cosm.com&#x2F;careers)
| [**DE-YAN**](https:&#x2F;&#x2F;de-yan.com&#x2F;) | [NYC] | creative concepting, experiential, motion, graphic &amp; interactive design within luxury, fashion, beauty, &amp; lifestyle | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:CAREERS@DE-YAN.COM)
| [**Deeplocal**](https:&#x2F;&#x2F;www.deeplocal.com&#x2F;) | [Pittsburgh] | creative engineers, inventors, interactive experiences, human stories | [🌐](https:&#x2F;&#x2F;deeplocal.applytojob.com&#x2F;)
| [**Design I&#x2F;O**](https:&#x2F;&#x2F;www.design-io.com&#x2F;) | [NYC] [San Francisco] | immersive, interactive installations, storytelling, events, galleries, museums, exhibitions and public space | 
| [**Digifun**](http:&#x2F;&#x2F;www.digitalfun.net&#x2F;) | [Shanghai] | projection mapping, new media art education | 
| [**Digital Ambiance**](https:&#x2F;&#x2F;www.digitalambiance.com&#x2F;) | [Berkeley, CA] | lighting design, projection mapping, interactive design | [🌐](https:&#x2F;&#x2F;www.digitalambiance.com&#x2F;careers&#x2F;)
| [**Digital Kitchen**](https:&#x2F;&#x2F;www.thisisdk.com) | [LA] | iconic main titles, multimedia content, imaginative experiences, and immersive spaces | 
| [**Dimensional Innovations**](https:&#x2F;&#x2F;dimin.com&#x2F;) | [Kansas City] [Atlanta] [Minneapolis] [Denver] [LA] [Pittsburgh] | experience design, interactive experiences, brand activation | [🌐](https:&#x2F;&#x2F;dimin.com&#x2F;about&#x2F;careers)
| [**Dome**](http:&#x2F;&#x2F;www.domecollective.com) | [NYC] | experience design studio that gathers designers, technologists, and strategists to solve unusual problems | 
| [**Domestic Data Streamers**](https:&#x2F;&#x2F;domesticstreamers.com&#x2F;) | [Barcelona] | fighting indifference towards data | 
| [**DOTDOT**](https:&#x2F;&#x2F;dotdot.studio&#x2F;about&#x2F;) | [Auckland] [NYC] [Brisbane] | AR, music videos, interactive installations, games | 
| [**dotdotdash**](https:&#x2F;&#x2F;dotdotdash.io&#x2F;) | [Portland] [LA] [NYC] | innovation agency that seamlessly blends the physical and digital | [🌐](https:&#x2F;&#x2F;www.dotdotdash.io&#x2F;careers)
| [**Downstream**](https:&#x2F;&#x2F;downstream.com&#x2F;) | [Portland] [Amsterdam] [Melbourne] | strategy + design + content + technology | [🌐](https:&#x2F;&#x2F;downstream.com&#x2F;careers)
| [**Dpt.**](https:&#x2F;&#x2F;dpt.co&#x2F;) | [Montreal] | generating wonder with immersive platforms, AR, &amp; VR | [🌐](https:&#x2F;&#x2F;dpt.co&#x2F;en&#x2F;contact-us&#x2F;)
| [**Eness**](https:&#x2F;&#x2F;www.eness.com&#x2F;) | [Melbourne] | evocative interactive experiences for public, commercial and cultural entities | [🌐](https:&#x2F;&#x2F;www.eness.com&#x2F;jobs)
| [**Envoy**](https:&#x2F;&#x2F;www.weareenvoy.com&#x2F;) | [Chicago] [LA] [San Diego] | transform environments into exceptional experiences, formerly Leviathan | [🌐](https:&#x2F;&#x2F;www.weareenvoy.com&#x2F;careers)
| [**Eos Lightmedia**](https:&#x2F;&#x2F;www.eoslightmedia.com&#x2F;) | [Vancouver] [NYC] [Orlando] | lighting and audiovisual design, themed attractions, museums, architecture, public spaces, building facades, presentation centers, and public art installations | 
| [**ESI Design**](https:&#x2F;&#x2F;esidesign.nbbj.com&#x2F;) | [NYC] | transforms places into experiences, immersive deisgn, architectural scale | [🌐](https:&#x2F;&#x2F;esidesign.nbbj.com&#x2F;jobs&#x2F;)
| [**Extrapolation Factory**](https:&#x2F;&#x2F;extrapolationfactory.com&#x2F;) | [NYC] | research studio, futures studies, collaborative prototyping | 
| [**Fast Horse**](https:&#x2F;&#x2F;www.fasthorseinc.com&#x2F;) | [Minneapolis] | a truly integrated creative agency | [🌐](https:&#x2F;&#x2F;www.fasthorseinc.com&#x2F;careers&#x2F;)
| [**FIELD**](https:&#x2F;&#x2F;www.field.io&#x2F;) | [London] | future aesthetics for design, motion, experiential | 
| [**Float4**](https:&#x2F;&#x2F;float4.com&#x2F;en&#x2F;) | [Montreal] [NYC] | integrates digital experiences into physical spaces to amplify their identity | [🌐](https:&#x2F;&#x2F;float4.com&#x2F;en&#x2F;life-at-float4&#x2F;)
| [**fuse**](https:&#x2F;&#x2F;www.fuseworks.it&#x2F;en&#x2F;) | [Modena, Italy] | live-media performances, experimentation, electronic music, digital arts | 
| [**Future Colossal**](https:&#x2F;&#x2F;www.futurecolossal.com&#x2F;) | [NYC] | experiential technologies in advertising and entertainment and art | [🌐](https:&#x2F;&#x2F;www.futurecolossal.com&#x2F;contact)
| [**Gallagher &amp; Associates**](https:&#x2F;&#x2F;www.gallagherdesign.com&#x2F;) | [DC] [NYC] [Portland] [Singapore] | harmony between technology, narrative, and physical design | [🌐](https:&#x2F;&#x2F;www.futurecolossal.com&#x2F;contact)
| [**Game Seven**](https:&#x2F;&#x2F;www.gamesevenmktg.com&#x2F;) | [NYC] [LA] | intersection of sport and culture, brand stories | [🌐](https:&#x2F;&#x2F;www.gameseven.agency&#x2F;careers)
| [**Geeksart**](http:&#x2F;&#x2F;geeks-art.com&#x2F;) | [Guangzhou] [Shanghai] | media sculptures, new media exhibition | [🌐](http:&#x2F;&#x2F;geeks-art.com&#x2F;join-us&#x2F;)
| [**Giant Spoon**](https:&#x2F;&#x2F;giantspoon.com&#x2F;) | [NYC] [LA] | translate cultural trends into big ideas, experiential, gaming | [🌐](https:&#x2F;&#x2F;giantspoon.com&#x2F;#careers)
| [**Groove Jones**](https:&#x2F;&#x2F;groovejones.com&#x2F;) | [Dallas] | XR, AR, VR, volumetric scanning, popups | [🌐](https:&#x2F;&#x2F;groovejones.com&#x2F;workwithus&#x2F;)
| [**Hotel Creative**](https:&#x2F;&#x2F;hotelcreative.com&#x2F;) | [London] | retail, branding, exhibitions, events | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@hotelcreative.com)
| [**Hovercraft**](https:&#x2F;&#x2F;www.hovercraftstudio.com&#x2F;) | [Denver] [Portland] | interactive installations, site-specific content, retail, sports | [🌐](https:&#x2F;&#x2F;hovercraftstudio.com&#x2F;careers?job&#x3D;freelance-creative-partners)
| [**HUSH**](https:&#x2F;&#x2F;heyhush.com&#x2F;) | [NYC] | marketing and advertising, retail and DTC, architecture | [🌐](https:&#x2F;&#x2F;www.heyhush.com&#x2F;people)
| [**iart**](https:&#x2F;&#x2F;iart.ch&#x2F;en&#x2F;) | [Basel] | studio for media architectures, enhancing physical spaces with digital technology | [🌐](https:&#x2F;&#x2F;iart.ch&#x2F;en&#x2F;jobs)
| [**IMG SRC**](https:&#x2F;&#x2F;www.imgsrc.co.jp&#x2F;) | [Tokyo] | full-service communication agency focusing on websites, installations, and R&amp;D | [🌐](https:&#x2F;&#x2F;www.imgsrc.co.jp&#x2F;en&#x2F;careers&#x2F;)
| [**Immersive International**](https:&#x2F;&#x2F;www.immersive.international&#x2F;) | [London] [Shanghai] [Ottawa] [Hong Kong] [Cape Town] | live experiences and art installations in public, private and commercial spaces | 
| [**Intergalactic**](https:&#x2F;&#x2F;intergalactic.com) | [Vancouver] [London] | mobile apps, interactive screens, web development, application design and visualization | [🌐](https:&#x2F;&#x2F;intergalactic.com&#x2F;careers)
| [**Invisible North**](https:&#x2F;&#x2F;www.invisiblenorth.com&#x2F;) | [NYC] | culturally fluent, thoughtful experiences, bring brands to life | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@invisiblenorth.com)
| [**Jam3**](https:&#x2F;&#x2F;www.jam3.com) | [Toronto] [LA] [Montevideo] [Amsterdam] | create modern experiences for tomorrow&#39;s brands | [🌐](https:&#x2F;&#x2F;media.monks.com&#x2F;careers)
| [**Jason Sherwood Design**](http:&#x2F;&#x2F;jasonsherwooddesign.com&#x2F;) | [NYC] | television and broadway and concert stage design | 
| [**Left Field Labs**](https:&#x2F;&#x2F;www.leftfieldlabs.com&#x2F;) | [LA] | products, platforms, and services that solve fundamental human challenges | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:talent@leftfieldlabs.com)
| [**Listen**](https:&#x2F;&#x2F;wearelisten.com&#x2F;) | [NYC] | sensory-driven brand assets, modern cultural landscape, sound, experiences | 
| [**Lorem Ipsum**](https:&#x2F;&#x2F;loremipsumcorp.com&#x2F;) | [NYC] [Moscow] [London] | experience design, narrative, physical and digital environments | 
| [**m ss ng p eces**](https:&#x2F;&#x2F;mssngpeces.com&#x2F;) | [NYC] [LA] | new wave production and entertainment partner for content and immersive experiences that inspire culture | 
| [**Magnopus**](https:&#x2F;&#x2F;www.magnopus.com&#x2F;) | [LA] [London] | unite the physical and digital worlds with extraordinary experiences | [🌐](https:&#x2F;&#x2F;www.magnopus.com&#x2F;current-openings)
| [**Manifold**](https:&#x2F;&#x2F;www.wearemanifold.com&#x2F;) | [San Francisco] [LA] [Portland] | we hire smart people and get out of their way | [🌐](https:&#x2F;&#x2F;www.wearemanifold.com&#x2F;contact&#x2F;)
| [**Map**](http:&#x2F;&#x2F;mapprojectoffice.com&#x2F;) | [London] | industrial designers who believe great design can solve problems | [🌐](https:&#x2F;&#x2F;universal.pinpointhq.com&#x2F;)
| [**Marshmallow Laser Feast**](https:&#x2F;&#x2F;www.marshmallowlaserfeast.com&#x2F;) | [London] | leaving a slug trail of sensory nuggets as we journey through the cosmos | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@marshmallowlaserfeast.com)
| [**Master of Shapes**](https:&#x2F;&#x2F;masterofshapes.com&#x2F;) | [LA] | a space surfing, geometry taming, buffalo riding, Future House | 
| [**Midnight Commercial**](http:&#x2F;&#x2F;midnightcommercial.com&#x2F;) | [NYC] | unite the disparate digital and physical worlds | 
| [**Midwest Immersive**](https:&#x2F;&#x2F;www.mwimmersive.com&#x2F;) | [Chicago] | immersive experiences for brands and agencies, projection mapping, LED lighting, games and app development | 
| [**MindBuffer**](https:&#x2F;&#x2F;mindbuffer.net&#x2F;) | [Berlin] | audiovisual research and digital design studio | 
| [**Moment Factory**](https:&#x2F;&#x2F;momentfactory.com&#x2F;home) | [Montreal] [LA] [London] [Tokyo] [Paris] [NYC] | shows, destinations, content, interactive, scenography | [🌐](https:&#x2F;&#x2F;momentfactory.com&#x2F;careers)
| [**Momentum Worldwide**](https:&#x2F;&#x2F;www.momentumww.com&#x2F;) | [NYC] [Athens] [Atlanta] [Bogota] [Bucharest] [Cairo] [Chicago] [Dubai] [Frankfurt] [Gothenburg] [Lima] [London] [Madrid] [Manchester] [Mexico City] [Milan] [New Delhi] [Santiago] [Sao Paulo] [Seattle] [Seoul] [St. Louis] [Sydney] [Toronto] [Tokyo] | disruptive, entertaining, shareable, unforgettable experiences for clients and their fans | [🌐](https:&#x2F;&#x2F;www.momentumww.com&#x2F;opportunities&#x2F;)
| [**Motse**](https:&#x2F;&#x2F;www.behance.net&#x2F;motseart&#x2F;projects) | [Shenzhen] | digital art | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:lixuanjie@silkroadcg.com)
| [**Mousetrappe Media**](https:&#x2F;&#x2F;www.mousetrappe.com&#x2F;) | [LA] | media design and production, architecturally mapped projection, immersive films, exhibits, attractions, and live events | [🌐](https:&#x2F;&#x2F;www.mousetrappe.com&#x2F;244-2&#x2F;jobs&#x2F;)
| [**MSCHF**](https:&#x2F;&#x2F;mschf.xyz&#x2F;) | [NYC] | viral stunts and products, trying to do stuff that the world can&#39;t even define | 
| [**mycotoo**](https:&#x2F;&#x2F;mycotoo.com&#x2F;) | [LA] [Barcelona] | entertainment development company specializing in theme park design, immersive experiences, and best-in-class events worldwide | 
| [**NCompass**](https:&#x2F;&#x2F;ncompassonline.com&#x2F;) | [LA] | brand and marketing solutions creating experiences that integrate the latest technology and creative | 
| [**Neon Global**](https:&#x2F;&#x2F;www.neonglobal.com&#x2F;) | [Singapore] | world class and epic experiences that are innovative, creative and exciting | [🌐](https:&#x2F;&#x2F;www.neonglobal.com&#x2F;en&#x2F;connect&#x2F;)
| [**NeoPangea**](https:&#x2F;&#x2F;www.neopangea.com&#x2F;) | [Reading, PA] | microsites, games, VR&#x2F;AR, digital, social | 
| [**NEXT&#x2F;NOW**](https:&#x2F;&#x2F;www.nextnowagency.com&#x2F;) | [Chicago] | brand activations, immersive environments, emerging technologies | [🌐](https:&#x2F;&#x2F;www.nextnowagency.com&#x2F;careers)
| [**NGX Interactive**](https:&#x2F;&#x2F;ngxinteractive.com&#x2F;) | [Vancouver] | pushing new technologies to create experiences that are vivid and meaningful | [🌐](https:&#x2F;&#x2F;ngxinteractive.recruitee.com&#x2F;)
| [**Night Kitchen**](https:&#x2F;&#x2F;www.whatscookin.com&#x2F;) | [Philadelphia] | dynamic digital experiences, online exhibitions, digital strategy, storytelling | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@whatscookin.com)
| [**Nohlab**](https:&#x2F;&#x2F;nohlab.com&#x2F;works) | [Istanbul] | producing interdisciplinary experiences around art, design and technology | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:apply@nohlab.com)
| [**Normal**](https:&#x2F;&#x2F;normal.studio&#x2F;en&#x2F;) | [Montreal] | public installations, entertainment, performing arts, stage design | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:cv@normal.studio)
| [**Nowhere**](https:&#x2F;&#x2F;studionowhere.com&#x2F;) | [Shanghai] | marketing events, interactive experiences | 
| [**Oat Foundry**](https:&#x2F;&#x2F;www.oatfoundry.com&#x2F;) | [Philadelphia] | split-flap displays, electromechanical stuff, think tank, products, experiences | [🌐](https:&#x2F;&#x2F;www.oatfoundry.com&#x2F;careers&#x2F;)
| [**OIO**](https:&#x2F;&#x2F;oio.studio&#x2F;) | [London] | creative company working on future products and tools for a less boring future | 
| [**Onformative**](https:&#x2F;&#x2F;onformative.com&#x2F;) | [Berlin] | studio for digital art and design, challenge the boundaries between art and design and technology | [🌐](https:&#x2F;&#x2F;onformative.com&#x2F;jobs)
| [**Optimist**](https:&#x2F;&#x2F;optimistinc.com&#x2F;) | [LA] [NYC] [London] [Amsterdam] [Hamburg] [Berlin] [Prague] | architects of subculture, creative, design, strategy, production, content, brand experience | [🌐](https:&#x2F;&#x2F;optimistinc.com&#x2F;job-openings.html)
| [**Ouchhh Studio**](https:&#x2F;&#x2F;ouchhh.tv&#x2F;) | [Istanbul] | public art, poetic public experiences, data as a paint, algorithm as a brush | 
| [**Patten Studio**](https:&#x2F;&#x2F;www.pattenstudio.com&#x2F;) | [NYC] | informed by research at the MIT Media Lab, experiences that connect people | [🌐](https:&#x2F;&#x2F;www.pattenstudio.com&#x2F;about&#x2F;)
| [**Pneuhaus**](https:&#x2F;&#x2F;pneu.haus) | [Island] | using inflatables to investigate the fundamental properties of perceptual experience in order to incite curiosity and wonder | 
| [**Potion Design**](https:&#x2F;&#x2F;www.potiondesign.com&#x2F;) | [NYC] | design and technology studio, interactive, musuems | [🌐](https:&#x2F;&#x2F;www.potiondesign.com&#x2F;work-with-us)
| [**pretty bloody simple**](https:&#x2F;&#x2F;www.prettybloodysimple.com) | [Munich] | interactive experiences, analog and digital, musuems | 
| [**RadicalMedia**](https:&#x2F;&#x2F;www.radicalmedia.com&#x2F;) | [NYC] [LA] | commercials, documentaries, music videos, branded experiences, &amp; immersive environments | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:careers@radicalmedia.com)
| [**Rare Volume**](https:&#x2F;&#x2F;rarevolume.com&#x2F;) | [NYC] | design and technology studio, interactive video walls | [🌐](https:&#x2F;&#x2F;rarevolume.com&#x2F;about&#x2F;)
| [**Red Paper Heart**](https:&#x2F;&#x2F;redpaperheart.com) | [NYC] | art from real world interaction | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@redpaperheart.com)
| [**Relative Scale**](https:&#x2F;&#x2F;relativescale.com&#x2F;) | [Raleigh] | bespoke digital products and experiences for brands and institutions | 
| [**RGI Creative**](https:&#x2F;&#x2F;www.rgicreative.com&#x2F;) | [Cleveland] | corporate experience design, museums exhibits and displays | [🌐](https:&#x2F;&#x2F;www.rgicreative.com&#x2F;contactform)
| [**Rosie Lee Creative**](https:&#x2F;&#x2F;rosieleecreative.com&#x2F;) | [London] [Amsterdam] [NYC] | design, creative, digital and consultancy | [🌐](https:&#x2F;&#x2F;rosieleecreative.com&#x2F;jobs)
| [**S1T2**](https:&#x2F;&#x2F;s1t2.com&#x2F;) | [Sydney] [Melbourne] [Shanghai] | We create interactive experiences that immerse audiences in the future of storytelling through technology. | 
| [**Second Story**](https:&#x2F;&#x2F;secondstory.com&#x2F;) | [Atlanta] [Portland] [NYC] | exhibition, interactive, software, experience, hardware, VR, AR, projection | [🌐](https:&#x2F;&#x2F;careers.smartrecruiters.com&#x2F;PublicisGroupe&#x2F;razorfish)
| [**Seeeklab**](https:&#x2F;&#x2F;www.seeeklab.com&#x2F;en&#x2F;) | [Xiamen] | marketing events, interactive installation | 
| [**Set Reset**](https:&#x2F;&#x2F;set-reset.com&#x2F;) | [London] | transforming data into compelling stories that fuel growth and create opportunity | 
| [**SOSO**](https:&#x2F;&#x2F;www.sosolimited.com&#x2F;) | [Boston] [San Diego] | delivering real human impact across physical and virtual space, placemaking and storytelling | [🌐](https:&#x2F;&#x2F;www.sosolimited.com&#x2F;careers&#x2F;)
| [**space150**](https:&#x2F;&#x2F;www.space150.com&#x2F;) | [Minneapolis] [LA] [NYC] | a tech-driven creative agency | [🌐](https:&#x2F;&#x2F;www.space150.com&#x2F;careers)
| [**Sparks**](https:&#x2F;&#x2F;www.wearesparks.com&#x2F;) | [Philadelphia] [Shanghai] [Paris] [Berlin] [Amsterdam] | conferences, popups, event production, fabrication | 
| [**Special Projects**](https:&#x2F;&#x2F;specialprojects.studio&#x2F;) | [London] | design and innovation agency that reveals user needs and transforms them into experiences and products | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:careers@specialprojects.studio)
| [**Spectacle**](https:&#x2F;&#x2F;spectacle.works&#x2F;) | [Phoenix] | expertise in fabricating experiences that drive engagement and wow participants | 
| [**Spectra Studio**](https:&#x2F;&#x2F;spectra.studio&#x2F;) | [LA] | installations, projection, sculpture, robotics, light and sound | 
| [**Squint&#x2F;Opera**](https:&#x2F;&#x2F;www.squintopera.com&#x2F;about&#x2F;) | [London] [NYC] [Dubai] | experience design for the built environment and musuems and attractions | 
| [**Staat**](https:&#x2F;&#x2F;www.staat.com&#x2F;) | [Amsterdam] | branding, editorial, event, film, graphic design, illustration, installation, interactive, interior design, production, retail | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@staat.com)
| [**Stimulant**](https:&#x2F;&#x2F;stimulant.com&#x2F;) | [San Francisco] | experience design and interactive installation, human-scale, site-specific digital experiences and touchscreen applications | 
| [**StoreyStudio**](https:&#x2F;&#x2F;www.storeystudio.com&#x2F;) | [London] | spatial design, set design, window displays, moving image | [🌐](https:&#x2F;&#x2F;www.storeystudio.com&#x2F;content&#x2F;vacancies)
| [**Studio Black**](https:&#x2F;&#x2F;www.studioblack.org&#x2F;) | [LA] [NYC] | technical production, design advisory, content management, digital content | 
| [**Studio Elsewhere**](https:&#x2F;&#x2F;www.studioelsewhere.co&#x2F;) | [NYC] | bio-experiential design and technology to support brain health | 
| [**Studio TheGreenEyl**](https:&#x2F;&#x2F;thegreeneyl.com&#x2F;) | [Berlin] [NYC] | exhibitions, installations, objects, images, interactions and algorithms | 
| [**Super A-OK**](https:&#x2F;&#x2F;superaok.com&#x2F;) | [NYC] | A multi-modal service bureau for the 21st century, fabrication, electronics | 
| [**SUPERBIEN**](https:&#x2F;&#x2F;www.superbien.studio) | [Paris] [NYC] [Dubai] | Creative studio for visually extended experiences, merging digital &amp; physical environments. | [🌐](https:&#x2F;&#x2F;www.superbien.studio&#x2F;career)
| [**Superfly**](https:&#x2F;&#x2F;superf.ly&#x2F;) | [NYC] | create shared experiences that shape how the world plays &amp; connects | [🌐](https:&#x2F;&#x2F;superflypresents.applytojob.com&#x2F;apply)
| [**TAD**](https:&#x2F;&#x2F;technologyarchitecturedesign.com&#x2F;) | [NYC] [London] | digital experiences, technology and architecture, designed to inspire people. | [🌐](https:&#x2F;&#x2F;technologyarchitecturedesign.com&#x2F;home&#x2F;opportunities)
| [**tamschick**](https:&#x2F;&#x2F;tamschick.com&#x2F;) | [Berlin] | media and architectural narrative design, exhibitions, branded space, musuems | [🌐](https:&#x2F;&#x2F;tamschick.factorialhr.com&#x2F;)
| [**Team Epiphany**](https:&#x2F;&#x2F;www.teamepiphany.com&#x2F;) | [NYC] [LA] | influencer marketing, IRL, vertical integration | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:info@teamepiphany.com)
| [**Tellart**](https:&#x2F;&#x2F;www.tellart.com&#x2F;) | [Providence] [Amsterdam] [San Francisco] | transformative experiences, invention, physical &amp; digital experiences, new technologies | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:careers@tellart.com)
| [**The Gathery**](http:&#x2F;&#x2F;www.thegathery.com&#x2F;) | [NYC] | editorially-born creative agency specializing in brand marketing and content creation | [🌐](https:&#x2F;&#x2F;www.thegathery.com&#x2F;careers)
| [**The Lab at Rockwell Group**](https:&#x2F;&#x2F;www.labatrockwellgroup.com) | [NYC] | architecture and design, branded experiences, immersive environments, pop ups | 
| [**The Projects**](http:&#x2F;&#x2F;theprojects.com&#x2F;) | [London] [LA] [NYC] [Sydney] | brand consultancy, meaningful experiences, tell stories | 
| [**THG**](https:&#x2F;&#x2F;thehettemagroup.com&#x2F;) | [LA] | experiential, exhibit, live shows, theme parks, retail, dining, museums | 
| [**Thinkwell**](https:&#x2F;&#x2F;thinkwellgroup.com&#x2F;) | [LA] [Montreal] [Abu Dhabi] [Riyadh] | strategy, experience design, production, master planning, entertainment destinations, branded attractions, interactive media installations, events, museums, expos | [🌐](https:&#x2F;&#x2F;thinkwellgroup.com&#x2F;careers&#x2F;)
| [**Tinker**](https:&#x2F;&#x2F;tinker.nl&#x2F;en) | [Utrecht] | narrative spaces, musuems, experience design, consultancy | 
| [**Tool**](https:&#x2F;&#x2F;www.toolofna.com&#x2F;) | [LA] | help brands and agencies with ideation, content, and experience production that generate buzz | 
| [**Trivium Interactive**](https:&#x2F;&#x2F;www.triviuminteractive.com&#x2F;) | [Boston] | experience design and production | [🌐](https:&#x2F;&#x2F;www.triviuminteractive.com&#x2F;careers)
| [**Two Goats**](https:&#x2F;&#x2F;www.twogoats.us&#x2F;) | [NYC] [LA] [London] | AR, interactive branded experiences | 
| [**Unified Field**](https:&#x2F;&#x2F;www.unifiedfield.com&#x2F;) | [NYC] | content-rich, experiential and interactive media for digital branding, media environments, and exhibits in public spaces | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:career@unifiedfield.com)
| [**UNIT9**](https:&#x2F;&#x2F;www.unit9.com&#x2F;) | [London] [LA] [NYC] [Berlin] | innovation architects, product designers, software engineers, gaming experts, creatives, art directors, designers, producers and film directors | [🌐](https:&#x2F;&#x2F;www.unit9.com&#x2F;jobs)
| [**Upswell**](https:&#x2F;&#x2F;hello-upswell.com&#x2F;) | [Portland] | digital and physical content first experiences | [🌐](https:&#x2F;&#x2F;upswell.studio&#x2F;contact)
| [**VTProDesign**](https:&#x2F;&#x2F;vtprodesign.com&#x2F;) | [LA] | high tech robotics and projection mapping | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@vtprodesign.com)
| [**VVOX**](https:&#x2F;&#x2F;volvoxlabs.com&#x2F;) | [NYC] [LA] | high-end design, code, fabrication, sound | [🌐](https:&#x2F;&#x2F;volvoxlabs.com&#x2F;contact&#x2F;)
| [**We Are Royale**](https:&#x2F;&#x2F;weareroyale.com&#x2F;) | [LA] [Seattle] | frontlines of design &amp; technology to arm brands with the creative to turn audiences into advocates | [📧](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/mailto:jobs@weareroyale.com)
| [**WHITEvoid**](https:&#x2F;&#x2F;www.whitevoid.com&#x2F;) | [Berlin] [Shanghai] | public or brand spaces and events, trade fair stands, shows and exhibitions, museums and festivals | 
| [**WOA STUDIO**](https:&#x2F;&#x2F;www.woastudio.it&#x2F;) | [Milan] | immersive experiences, multimedia, video mapping, digital artistry | 
| [**Wonderlabs**](https:&#x2F;&#x2F;www.wonderlabsstudio.com&#x2F;) | [Shanghai] | marketing events, interactive installation | [🌐](https:&#x2F;&#x2F;www.wonderlabsstudio.com&#x2F;channels&#x2F;219.html)
| [**XORXOR**](https:&#x2F;&#x2F;www.xorxor.hu) | [Budapest] | collaboration between scientists, engineers, artists and robots, real-time visuals meet complex design | [🌐](https:&#x2F;&#x2F;www.xorxor.hu&#x2F;jobs.html)
| [**y&#x3D;f(x)**](https:&#x2F;&#x2F;www.yfxlab.com&#x2F;) | [Amsterdam] | creative technology studio focused on the creation of overarching multimedia experiences, with specially crafted software and design | 
| [**Yellow Studio**](https:&#x2F;&#x2F;yellowstudio.com&#x2F;) | [NYC] | artistically-minded design, tv&#x2F;concert&#x2F;event production design, set design | 
| [**Zebradog**](https:&#x2F;&#x2F;www.zebradog.com&#x2F;) | [Madison] | communication design and the built environment, higher education | 


## Collectives &amp; Practices

Established artist collectives&#x2F;practices that work with creative technology (here primarily for reference, not necessarily for career opportunities).

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**3-Legged Dog**](https:&#x2F;&#x2F;www.3ld.org&#x2F;) | [NYC] | original works in theater, performance, dance, media and hybrid forms | 
| [**Brooklyn Research**](https:&#x2F;&#x2F;brooklynresearch.com&#x2F;) | [NYC] | we build interactive systems for a range of clients including museums, artists, and leading technology firms | 
| [**Dave + Gabe**](https:&#x2F;&#x2F;www.daveandgabe.care&#x2F;) | [NYC] | interactive installation studio, real-time animation, generative 3D sound | 
| [**Hypersonic**](https:&#x2F;&#x2F;www.hypersonic.cc&#x2F;) | [NYC] | groundbreaking new media sculptures and physical installations | 
| [**Kimchi and Chips**](https:&#x2F;&#x2F;www.kimchiandchips.com&#x2F;) | [South Korea] | intersection of art, science and philosophy through ambitious large-scale installations | 
| [**NightLight Labs**](https:&#x2F;&#x2F;nightlight.io&#x2F;) | [LA] | installations, activations, narrative experiences | 
| [**NONOTAK Studio**](https:&#x2F;&#x2F;www.nonotak.com&#x2F;) | [Paris] | light and sound installations, ethereal, immersive, dreamlike | 
| [**panGenerator**](https:&#x2F;&#x2F;pangenerator.com&#x2F;) | [Warsaw] | new media art and design collective, mixing bits &amp; atoms | 
| [**Random International**](https:&#x2F;&#x2F;www.random-international.com&#x2F;) | [London] [Berlin] | experimental practice within contemporary art, human condition in an increasingly mechanised world | 
| [**Smooth Technology**](https:&#x2F;&#x2F;smooth.technology&#x2F;) | [NYC] | cutting-edge technology and artistic sensibility, wireless wearables, create the impossible | 
| [**Taller Estampa**](https:&#x2F;&#x2F;www.tallerestampa.com) | [Barcelona] | group of filmmakers, programmers and researchers who work in the fields of experimental audiovisual and digital environments. | 
| [**teamLab**](https:&#x2F;&#x2F;www.teamlab.art&#x2F;) | [Tokyo] | full-room interactive projection mapping, interdisciplinary group of ultratechnologists | 
| [**The Cuttelfish**](https:&#x2F;&#x2F;www.thecuttlefish.com&#x2F;) | [USA] | explore and imagine and prototyp and creatr future-forward creative concepts | 
| [**Ultravioletto**](https:&#x2F;&#x2F;ultraviolet.to&#x2F;) | [Rome] | exhibitions, fairs, museums, brand experiences and events | 
| [**United Visual Artists**](https:&#x2F;&#x2F;www.uva.co.uk&#x2F;) | [London] | new technologies with traditional media, site-specific, instruments that manipulate perception | 
| [**WHYIXD**](https:&#x2F;&#x2F;www.whyixd.com&#x2F;) | [Taiwan] | cross-disciplinary art installations, dance, architecture, music | 


## Experiential Spaces &amp; Experiences

Groups that create experential spaces &amp; experiences full of creative technology.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**29 Rooms (Vice Media Group)**](https:&#x2F;&#x2F;www.29rooms.com&#x2F;) | [USA] | multi-sensory installations, performances, and workshops | 
| [**Cascade**](https:&#x2F;&#x2F;cascadeshow.com&#x2F;) | [LA] | interactive art experience | 
| [**Color Factory**](https:&#x2F;&#x2F;www.colorfactory.co&#x2F;) | [NYC] [Houston] | collaborative interactive exhibit | 
| [**Meow Wolf**](https:&#x2F;&#x2F;meowwolf.com&#x2F;) | [Santa Fe] [Las Vegas] [Denver] | immersive and interactive experiences that transport audiences of all ages into fantastic realms of story and exploration | 
| [**Museum of Ice Cream**](https:&#x2F;&#x2F;www.museumoficecream.com&#x2F;) | [San Francisco] [NYC] | transforms concepts and dreams into spaces that provoke imagination and creativity | 
| [**PopUpMob**](https:&#x2F;&#x2F;popupmob.com&#x2F;) | [NYC] [LA] [London] [Paris] | one-stop shop for pop up experiences | 
| [**Studio Daguet**](http:&#x2F;&#x2F;www.daguet.com&#x2F;) | [Nantes] [Paris] | staging stories, show, music, theme parks, museums, hotels | 


## Fabricators

Groups that mostly fabricate pieces for creative technology companies.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**5 Ten**](https:&#x2F;&#x2F;www.510visuals.com&#x2F;) | [NYC] | LED technology design, fabrication, and integration | 
| [**Bednark**](https:&#x2F;&#x2F;builtbybednark.com&#x2F;) | [NYC] | full-service fabrication, production, install | 
| [**Bridgewater Studio**](https:&#x2F;&#x2F;www.bridgewaterstudio.net) | [Chicago] | full service design and fabrication | [🌐](https:&#x2F;&#x2F;www.bridgewaterstudio.net&#x2F;about)
| [**Eventscape**](https:&#x2F;&#x2F;eventscape.com&#x2F;) | [Toronto] | building the extraordinary, full service | 
| [**Gamma**](https:&#x2F;&#x2F;gamma.nyc&#x2F;) | [NYC] | large scale robotic cnc, install, sculptures | 
| [**Pink Sparrow**](https:&#x2F;&#x2F;www.pinksparrow.com&#x2F;) | [NYC] [LA] | environmental design, project management | 
| [**Visionary Effects**](http:&#x2F;&#x2F;www.visionaryeffects.com&#x2F;) | [Pittsburgh] | old-school manufacturing processes with digital design and fabrication | 


## Event Production

Groups that specialize in event production, often with a creative technology twist.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**Dera Lee Productions**](http:&#x2F;&#x2F;www.deralee.com&#x2F;) | [NYC] | theatre arts, story-telling | 
| [**GPJ**](https:&#x2F;&#x2F;www.gpj.com&#x2F;) | [Austin] [Boston] [Dallas] [Detroit] [LA] [Nashville] [NYC] [San Francisco] [Silicon Valley] | immersive events and experiences | 
| [**SAT**](https:&#x2F;&#x2F;sat.qc.ca&#x2F;en) | [Montreal] | immersive experiences, concerts, workshops, conferences, exhibitions | 
| [**Sparks**](https:&#x2F;&#x2F;wearesparks.com&#x2F;) | [Philadelphia] [Detroit] [Connecticut] [Atlanta] [LA] [Las Vegas] [NYC] [San Francisco] [Shanghai] | trade show, experiential, retail | 


## Architecture

Groups that generally design architecture often incorporating creative technology.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**Carlo Ratti Associatti**](https:&#x2F;&#x2F;carloratti.com&#x2F;) | [Torino, Italy] [NYC] [UK] | design and innovation office, MIT Media Lab: Senseable City Lab | 
| [**Gensler DXD**](https:&#x2F;&#x2F;dxd.gensler.com&#x2F;) | [Worldwide] | built environment with integrated capabilities in strategy, design, technology, data, and architecture | 
| [**Olson Kundig**](https:&#x2F;&#x2F;olsonkundig.com&#x2F;) | [Seattle] [NYC] | architecture, vessel that supports specific art installations, seamless spatial experience | 
| [**SOFTlab**](https:&#x2F;&#x2F;softlabnyc.com&#x2F;) | [NYC] | mixes research and creativity and technology with a strong desire to make working fun | 
| [**Universal Design Studio**](http:&#x2F;&#x2F;www.universaldesignstudio.com&#x2F;) | [London] [NYC] | driven by a deeply held belief in the transformative power of well designed and finely crafted spaces | 


## Creative Agencies

Groups that are have a more general focus, but have a knack for projects imbued with creative technology.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**&amp;Walsh**](https:&#x2F;&#x2F;andwalsh.com&#x2F;) | [NYC] | brand strategy, art direction, design and production across all platforms | 
| [**AKQA**](https:&#x2F;&#x2F;www.akqa.com&#x2F;) | [London] [SF] [São Paulo] [Melbourne] [Aarhus] [Miami] [Amsterdam] [Atlanta] [Auckland] [Berlin] [Cairo] [Cape Town] [Copenhagen] [Dubai] [Gothenburg] [Gurgaon] [Johannesburg] [Milan] [NYC] [Paris] [Portland, OR] [Riyadh] [Shanghai] [Stockholm] [Sydney] [Tokyo] [Venice] [DC] [Wellington] | the most powerful force in the universe isn’t technology, it’s imagination | 
| [**BUCK**](https:&#x2F;&#x2F;buck.co&#x2F;) | [LA] [NYC] [Sydney] [Amsterdam] | VR, AR, installation, real-time animation, 3D, experiential | 
| [**Framestore**](https:&#x2F;&#x2F;www.framestore.com&#x2F;) | [London] [NYC] [Montreal] | virtual, augmented and mixed realities, location-based entertainment, and theme park rides | 
| [**ManvsMachine**](https:&#x2F;&#x2F;mvsm.com&#x2F;) | [London] [LA] | multidimensional creative studio | 
| [**Media Monks**](https:&#x2F;&#x2F;www.mediamonks.com&#x2F;) | [Amsterdam] [London] [Dubai] [Stockholm] [NYC] [LA] [San Francisco] [Mexico City] [São Paulo] [Buenos Aires] [Shanghai] [Singapore] | creative production | 
| [**R&#x2F;GA**](https:&#x2F;&#x2F;www.rga.com&#x2F;) | [Austin] [Chicago] [LA] [NYC] [Portland] [San Francisco] [Berlin] [Bucharest] [London] [Buenos Aires] [Santiago] [São Paulo] [Melbourne] [Shanghai] [Singapore] [Sydney] [Tokyo] | business, experience, and marketing transformation | 
| [**SuperUber**](https:&#x2F;&#x2F;www.superuber.com&#x2F;) | [Rio de Janeiro] [São Paulo] | experiences that blend art, technology, architecture and design | 
| [**The Mill**](https:&#x2F;&#x2F;www.themill.com&#x2F;) | [London] [NYC] [LA] [Chicago] [Bangalore] [Berlin] | experience makers, media and brand activation, innovative design, and inventive technologies | 
| [**Weber Shandwick**](https:&#x2F;&#x2F;www.webershandwick.com&#x2F;) | [Atlanta] [Baltimore] [Bogotá] [Boston] [Brasilia] [Buenos Aires] [Buffalo] [Chicago] [Dallas] [Detroit] [Lima] [LA] [Mexico City] [Minneapolis] [Montreal] [Nashville, TN] [NYC] [Philadelphia] [Rio de Janeiro] [SF] [Santiago] [Seattle] [St. Louis] [São Paulo] [Toronto] [Vancouver] [DC] | we work at the intersection of technology, society, policy and media, adding value to culture — to shape and re-shape it | 


## Museums

Groups that generally focus on designing museums and similar experiences using creative technology.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**Art Processors**](https:&#x2F;&#x2F;www.artprocessors.net&#x2F;) | [Melbourne] | specialist interactive media and exhibition design | 
| [**Cortina Productions**](https:&#x2F;&#x2F;www.cortinaproductions.com&#x2F;) | [McLean, VA] | artistry, content, and technology, we render the word to the story, the story to the medium, and the medium to the space. | 
| [**Exploratorium**](https:&#x2F;&#x2F;www.exploratorium.edu&#x2F;) | [San Francisco] | exhibits made in-house, public-facing workshop | 
| [**Gagarin**](https:&#x2F;&#x2F;gagarin.is&#x2F;) | [Reykjavík] | weaving education, information and data into compelling stories | 
| [**Grumpy Sailor**](https:&#x2F;&#x2F;www.grumpysailor.com&#x2F;) | [Sydney] [Melbourne] | digital experiences, exhibit design, brands | 
| [**GSM Project**](https:&#x2F;&#x2F;gsmproject.com&#x2F;en&#x2F;) | [Montreal] [Singapore] [Dubai] | content first, exhibitions | 
| [**Ideum**](https:&#x2F;&#x2F;www.ideum.com&#x2F;) | [Albuquerque] | interactive exhibits and exhibitions, integrated hardware products | 
| [**Iglhaut + von Grote**](http:&#x2F;&#x2F;iglhaut-vongrote.de&#x2F;en&#x2F;) | [Berlin] | scenography, spatial mise-en-scène | 
| [**Local Projects**](https:&#x2F;&#x2F;localprojects.com&#x2F;) | [NYC] | experience Designers pushing the boundaries of human interaction | 
| [**Monadnock Media**](https:&#x2F;&#x2F;monadnock.org&#x2F;) | [Massachusetts] | multimedia experiences for museums, historic sites and public places | 
| [**Northern Light Productions**](https:&#x2F;&#x2F;nlprod.com&#x2F;) | [Boston] | immersive media environments, interactive experiences, or documentary films. | 
| [**RLMG**](https:&#x2F;&#x2F;www.rlmg.com&#x2F;) | [Boston] | story-driven, interactive, dynamic, immersive, and educational installations for public spaces. | 
| [**Roto**](https:&#x2F;&#x2F;roto.com&#x2F;) | [Columbus, OH] | experience design, immersive media, interactive engineering, and custom fabrication for museums, brands, attractions and architectural placemaking. | 
| [**Thinc**](https:&#x2F;&#x2F;www.thincdesign.com&#x2F;) | [NYC] | provoke meaningful conversations about the world in which we live | 


## Festivals &amp; Conferences

Meetups for creative technologists.

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**ISEA**](https:&#x2F;&#x2F;isea2022.isea-international.org&#x2F;) | [Barcelona] [Paris] | the crossroads where art, design, science, technology and society meet | 
| [**MUTEK**](https:&#x2F;&#x2F;montreal.mutek.org&#x2F;) | [Montreal] | electronic music, audiovisual performance, digital art | 
| [**SXSW**](https:&#x2F;&#x2F;www.sxsw.com&#x2F;) | [Austin] | film, music, interactive arts | 


## Education

Undergrad programs, masters and open course teaching and researching creative technologies

| Name | Locations | Keywords | Jobs |
| ---- | --------- | -------- | ---- |
| [**Goldsmiths**](https:&#x2F;&#x2F;www.gold.ac.uk&#x2F;pg&#x2F;ma-computational-arts&#x2F;) | [London] | a degree which develops your arts practice through the expressive world of creative computation | 
| [**ITP**](https:&#x2F;&#x2F;tisch.nyu.edu&#x2F;itp) | [NYC] | ITP&#x2F;IMA offers four programs focused on creative and meaningful application of interactive tools and media. | 
| [**MIT Medialab**](https:&#x2F;&#x2F;media.mit.edu&#x2F;) | [Boston] | art, science, design, and technology build and play off one another in an environment designed for collaboration and inspiration | 
| [**Paris College of Art**](https:&#x2F;&#x2F;www.paris.edu&#x2F;programs&#x2F;graduate&#x2F;master-transdisciplinary-new-media&#x2F;) | [Paris] | designed for those who are interested in exploring the wide-ranging creative field of New Media | 
| [**University of the Arts**](https:&#x2F;&#x2F;www.arts.ac.uk&#x2F;subjects&#x2F;creative-computing&#x2F;postgraduate&#x2F;mres-creative-computing) | [London] | computational technologies in the context of creative computing research | 



---

## Closed Groups

Groups that have closed their doors are still useful for reference and inspiration. Check out the list of them [here](https://github.com/j0hnm4r5/awesome-creative-technology/blob/master/closed.md).
