<div class="github-widget" data-repo="chainstack/awesome-corda"></div>

<div align="center">
  <a href="https://www.corda.net/"><img width="250px" src="https://raw.githubusercontent.com/chainstack/awesome-corda/master/./project_logo.png">
  </a><br />
  <a href="https://www.corda.net/">Corda</a>是一个开源区块链项目，从一开始就为商业而设计.
  <br /> Corda 允许您构建可互操作的区块链网络，在严格保密的情况下进行交易.  Corda 的智能合约技术允许企业直接进行有价值的交易.
  <br />

  [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
</div>


欢迎请求请求！




## Documentation

- [Documentation](https://docs.corda.net/)  -Corda 文档. 一切事物的必去之地.
- [Technical whitepaper](https://www.r3.com/reports/corda-technical-whitepaper/) - Corda 的技术描述.


## Programming

- [Corda API reference](https://api.corda.net/) - Corda 公共 API 参考.
- [Development environment](https://docs.corda.net/getting-set-up.html#set-up-instructions) - 在 Corda 上开始开发的分步说明.

## Tools

- [Braid Corda](https://gitlab.com/bluebank/braid/tree/master/braid-corda) - 从您的 Corda 节点创建 Braid 端点和流.
- [Codaptor](https://github.com/180Protocol/codaptor) - 为在 Corda 节点上运行的任何 CorDapp 自动创建 REST API.
- [Corbeans](https://manosbatsis.github.io/corbeans) - 用于 Spring Boot 的 Corda 集成.
- [Cordage](https://github.com/LayerXcom/cordage) - 提供模块，使 Corda 和其他区块链之间的互操作性成为可能，而无需进一步信任第三方.
- [Cordalo](https://github.com/cordalo-ch) - 提供 Corda 框架以加速您在分散空间中的开发.
- [Corda Lean State](https://manosbatsis.github.io/corda-lean-state) - 从简化的界面生成 Corda 合同和持久状态. 
- [Cordentity](https://github.com/hyperledger-labs/cordentity) - 整合 [Hyperledger Indy](https://www.hyperledger.org/projects/hyperledger-indy) Corda 的功能.
- [DAML for Corda](https://github.com/chainstack/awesome-corda) - Corda 的 DAML 智能合约.
- [DemoBench](https://www.corda.net/demobench/) - 一个独立的桌面应用程序，用于配置和启动本地 Corda 节点.
- [Interact with nodes](https://docs.chainstack.com/operations/corda/tools) - 通过独立的 shell、应用程序或 Web 服务器与您的 Corda 节点交互.
- [Nodes and networks deployment with Chainstack](https://chainstack.com/corda/) - 简单的 Corda 节点和网络部署.
- [Partiture](https://manosbatsis.github.io/partiture/)  - 一个紧凑的 CorDapps 组件框架. 目前，它的主要目标是简化流程组合.
- [PyCorda](https://github.com/chainhaus/pycorda) - 访问节点和保险库数据以使用 pandas DataFrames 进行分析.
- [RPC PoolBoy](https://manosbatsis.github.io/corda-rpc-poolboy/) - 支持多个 Corda 节点的 RPC 连接池.
- [Smart legal contracts with Accord](https://www.accordproject.org/news/smart-legal-contracts-on-corda/) - Corda 上智能法律合约的参考实现.
- [Testacles](https://github.com/manosbatsis/corda-testacles) - 用于扩展 CorDapp 测试套件的工具.
- [Vaultaire](https://manosbatsis.github.io/vaultaire/) - 为 Corda 开发人员查询 DSL 和数据访问实用程序.
- [VS Code Corda extension](https://github.com/corda/vscode-corda) - 用于在 Corda 平台上开发 CorDapps 的 VS Code 工具.
- [Web3j integration for Corda](http://corda.web3j.io/) - 用于与 CorDapps 一起工作的轻量级客户端库.
- [XTS Fountain](https://cordite.foundation/) - 铸造 XTS 代币并将它们发送到 Corda 节点上的代币账户.
- [Splunk App for Corda](https://github.com/splunkdlt/splunk-app-for-corda) - 用于 Corda 监控的 Splunk 官方集成应用程序. 

## Tutorials

- [Official Corda tutorials](https://docs.corda.net/tutorials-index.html) - 学习构建和运行 CorDapps.
- [Sample CorDapps](https://github.com/corda/samples/) - 探索针对各种用途的示例 CorDapps 的代码.
- [No ticket scalping CorDapp](https://docs.chainstack.com/tutorials/no-ticket-scalping-cordapp-on-corda) - 从头开始​​构建、运行 CorDapp 并与之交互.
- [Vaultaire: Corda Vault Queries Made Simple](https://medium.com/@manosbatsis/vaultaire-corda-vault-queries-made-simple-d13db4147298) - 升级到专为您生成的干净且易于使用的查询 DSL.


## Learning and online courses

- [Official Corda Training Platform](https://training.corda.net/)  - 由 R3 (Corda + SDKs) 维护的免费培训平台. 通过可选支持自定进度.
- [Introduction to Corda Development](https://www.udemy.com/course/corda-development/) - 免费的自定进度的在线课程.
- [Corda developer certification](https://www.r3.com/training-and-certification/) - 成为经过认证的 Corda 开发人员.


## Videos

- [Corda Bootcamp](https://www.youtube.com/playlist?list=PLi1PppB3-YrVq5Qy_RM9Qidq0eh-nL11N) - 为 Corda 初学者准备的包含 20 个视频的播放列表.


## CorDapps

试用 CorDapps 并获得灵感. 还探索 [CorDapp marketplace](https://marketplace.r3.com/) 或将您的 CorDapp 添加到列表中！

- [Cordite](https://gitlab.com/cordite/cordite) - 提供去中心化经济和治理服务的 CorDapps 集合.
- [Credit scoring](https://github.com/rafaelazeredo/creditbank) - 用户和零售银行之间的信用评分服务.
- [Auction](https://github.com/ashutoshmeher-r3/auction-cordapp) - 演示拍卖 CorDapp.
- [Private health insurance management](https://github.com/corda-codeclub/marge) - 私人健康保险 CorDapp.
- [Sustainable fishing rights](https://github.com/joeldudleyr3/olive-oyl) - 管理捕鱼权的 CorDapp.

## Networks

- [Corda Network](https://corda.network/) - 由 Corda 网络基金会运营的全球生产网络.
- [Corda Pre-Production Network](https://corda.network/participation/preprod.html) - 提供由 Corda 网络基金会运行的预生产环境的 UAT 网络.
- [Corda Testnet](https://docs.corda.net/corda-testnet-intro.html) - 由 Corda 网络基金会运行的具有最小权限的免费公共测试网.
- [Cordite Network](https://cordite.foundation/) - 一个由 Cordite Foundation 运营的向任何人开放的测试网.


## Community

- [Slack](http://slack.corda.net/) - 与 Corda 社区交谈.
- [Mailing list](https://groups.io/g/corda-dev) - 加入 Corda 开发者邮件列表.
- [Corda Code Club](https://www.meetup.com/Corda-Code-Club/) - 伦敦的 Corda 开发者聚会.


## Misc

- [Corda developer blog](https://lankydan.dev) - 来自 Corda 开发人员的非常有用的博客.


## Official

- [Corda website](https://www.corda.net/)


## Contribute

欢迎投稿！ 读 [contribution guidelines](https://github.com/chainstack/awesome-corda/blob/master/CONTRIBUTING.md).
