<div class="github-widget" data-repo="ConstructCommunity/awesome-construct"></div>
## Awesome Construct [![Awesome](https://awesome.re/badge-flat.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://construct-static.com/images/v861/r/global/construct-3-logo_v130.png" align="right" width="100">](https://www.construct.net/)

> You can create the game of your dreams. Build brain tickling puzzles, stunning platformers and immersive RPGs - or break the mould and make something new.
> Create what you want, how you want with [Construct](https://www.construct.net).
>
> — <cite>Ashley (Scirra Founder)</cite>

This list includes all the best tools, tutorials and examples related to the awesome game development engines [Construct 2](https://www.scirra.com/construct2) and [Construct](https://www.construct.net).

[How to contribute?](https://github.com/armaldio/awesome-construct/blob/master/contributing.md)

<p align="center">  
   :sparkles: <a href="https://github.com/WebCreationClub/awesome-construct/blob/master/c2vsc3.md">Compare Construct 2 and Construct 3</a>  :sparkles:
</p>




## Community
- [Discord Server](https://discord.gg/8RJBHbX) - [Scirra Forum Thread](https://www.construct.net/forum/construct-2/general-discussion-17/there-is-a-construct-2-discord-117214).
- [FAQ](https://www.construct.net/forum/construct-2/how-do-i-18/how-do-i-frequently-asked-ques-41236)
- [Forums](https://www.construct.net/forum)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/construct-3+or+construct-2)
- [Reddit](https://www.reddit.com/r/construct/)
- [Twitter](https://twitter.com/constructteam)
- [Facebook](https://www.facebook.com/ConstructTeam/)

## Games Showcase
- [Games on Steam](http://steamcommunity.com/sharedfiles/filedetails/?id=103535227) - List of Steam games made with the engine.
- [Games on itch.io](https://itch.io/games/tag-construct-2/tag-construct-3) - List of itch.io games made with the engine.
- [Games made with Construct](https://www.madewithconstruct.com/) - A website that list all the games made with the engine.

## Hosting
- [itch.io](http://www.itch.io) - Platform where to host, showcase, promote or sell your games - **Free**.
- [GitHub Pages](http://pages.github.com) - Platform where to host an exported game as a static website - **Free**.
- [Surge](https://surge.sh/) - Platform where to host an exported game as a static website - **Free/Paid**.
- [Vercel](https://vercel.com/) - Platform where to host an exported game as a static website or cloud functions - **Free/Paid**.
- [Netlify](https://www.netlify.com/) - Platform where to host an exported game as a static website - **Free/Paid**.

## Tools
- [Rex's Plugins Tool](https://rexrainbow.github.io/C2RexDoc/c2rexplugins.weebly.com/index.html) - The personnal addon manager of Rex.Rainbow.
- [FrameworkJS for Construct2](https://c2.frameworkjs.eth.limo/) - Use Construct 2 to develop apps [in development]

## Export 
- [ElectronForConstruct](https://electronforconstruct.armaldio.xyz) - Export your games using Electron instead of NW.js.
- [AppPlayer-Electron](https://github.com/Floflis/AppPlayer-Electron) - Preview Construct 2 apps/games in an Electron prebuilt exe - as if Electron were a normal browser! Currently Windows only, but soon™ for Mac and Linux
- [Chowdren](https://mp2.dk/chowdren/) - Blazingly fast runtime for Clickteam Fusion and Scirra Construct.

## Plugins/Behaviors/Effects
- [[Kyatric] C2 Plugins and Behaviors List](https://www.construct.net/forum/extending-construct-2/addons-29/c2-plugins-and-behaviors-list-42712) - Complete list of Plugins and Behaviours available on the forums.
- [[Kyatric] WebGL Effects List](https://www.construct.net/forum/extending-construct-2/effects-31/webgl-effects-list-51897) - Complete list of Effects available on the forums.

## Tutorials
### YouTube

- [[ArcadEdGames] Construct 2 Tutorials](https://www.youtube.com/playlist?list=PLmyh0_jcCzcoPTgHkm4CJSw_sdK5lPSb_) - YouTube channel about making all sort of stuff.
- [[ScirraVideos] Construct 2 Tutorials](https://www.youtube.com/user/ScirraVideos/playlists) - Official Scirra's YouTube channel.
- [[C2Tuts 2D Game Development] Construct 2 Tutorials](https://www.youtube.com/playlist?list=PLGdBDrsyOPm9XGiq1w_8DvbEQbHmkn7fx) - General tutorials.
- [[Nicholas Dingle] Construct 2 Tutorials](https://www.youtube.com/playlist?list=PLsJBMeqEdtggBJBiuX8bnF10ewHjdE20e) - Number of tutorials covering different games you can create and different tricks.
- [[John Maksym] Construct 2 Tutorial Series](https://www.youtube.com/playlist?list=PLq6aUvz66jtfnuyOKnPXO5dZly6CB8naA) - General tutorials.
- [[ConstructG] Create Simple Platformer Game With Construct 2](https://www.youtube.com/playlist?list=PLxwakQrJudt_NQlMp6oVuBdB-WIDKgoQ3) - Tutorial about how to make a platformer game.
- [[Diego Lizarazo] Construct 2 Tutorials](https://www.youtube.com/user/kanedarkon/videos?view=0&flow=grid&sort=da) - Random stuff.
- [[English Acorn] Construct 2 - Tutorials](https://www.youtube.com/playlist?list=PLusL6SZZRaWr4zqm6GrQHmOuShwtypRJ5) - General tutorials about the editor interface.
- [[English Acorn] Construct 2 - Plugins and Objects](https://www.youtube.com/playlist?list=PLusL6SZZRaWqP6UmVPs9Ml8BRo2t-wvnT) - Tutorials about plugins and how they work inside the Editor.
- [[Game Development] Construct 2 - Tutorials](https://www.youtube.com/channel/UCCR955dujboBxEN2VJlZwJw/playlists) - General tutorials.
- [[thenewboston] Game Development w/ Construct 2 Playlist](https://www.youtube.com/playlist?list=PL6gx4Cwl9DGAfHxsK6bji7trLS-N0nKF-) - The official playlist for thenewboston Game Development.
- [[thenewboston] Platform Game Development w/ Construct 2 Playlist](https://www.youtube.com/playlist?list=PL6gx4Cwl9DGAp287UuTE0-K7Ty-b8rGAX) - Official playlist for thenewboston Platform Game Development.
- [[thenewboston] Physics Puzzle Game Development w/ Construct 2 Playlist](https://www.youtube.com/playlist?list=PL6gx4Cwl9DGDexNbWi0uPBP6buduUZO3Q) - The official playlist for thenewboston Physics Puzzle Game Development Tutorials.
- [[LividProductions] Platformer Tutorials](https://www.youtube.com/playlist?list=PLz66pfeeD4TcPN9kO7JlqiITpgi_WWgn7) - This series will teach you how to make a platformer.
- [[Jerementor] Construct 2 Tutorials](https://www.youtube.com/channel/UCQkYeiHm9URZsa7nugUg1lw/playlists) - General tutorials.
- [[Kawaerri] Scirra Construct 2 Tutorial](https://www.youtube.com/playlist?list=PLdn9X5UVD8H1dEcWVjYU9E5fbpPGjZnQv) - General tutorials.
- [[Gamer Z] - Tutorial List](https://www.youtube.com/channel/UCXIcG5r9W_Iw6dui35g9oLQ/playlists) - General tutorials.
- [[TodaysTuts] Construct 2 - Behaviors](https://www.youtube.com/playlist?list=PLO3K3VFvlU6B1InGyrx7Iz7w_MDizWlXK) - Tutorials about Behaviours.
- Let's Make Games: [[PONG]](https://www.youtube.com/watch?v=cvItNHEMB80) [[ASTEROIDS]](https://www.youtube.com/watch?v=nYULTk2BpKY) [[Flappy Bird]](https://www.youtube.com/watch?v=eBccn1qMB_U) - Tutorials on how to make specifi games.
- [Construct 2 Tutorials - Breakout Clone](https://www.youtube.com/playlist?list=PL59F92017DA9887DB) - Learn how to create a Brakeout game.
- [Lessis Games](https://www.youtube.com/@lessisgames8555/playlists) - Tutorials & more.

### Other Sources

- [[MVA] Game Development with Construct 2 (Basic)](https://mva.microsoft.com/en-US/training-courses/game-development-with-construct-2-8355) - Basic course about making games.
- [[MVA] Developing Windows 10 Games with Construct 2 (Advanced)](https://mva.microsoft.com/en-US/training-courses/developing-windows-10-games-with-construct-2-16335) - Advanced course about making games.
- [[Udemy FREE!] Learn Construct 2](https://www.udemy.com/learn-construct-2-creating-a-pixel-platformer-in-html5/) - Creating a Pixel Platformer in HTML5.
- [[TutPlus] Construct 2 Tutorials](https://gamedevelopment.tutsplus.com/categories/construct-2) - General tutorials.
- [How To Construct Demo](https://howtoconstructdemos.com/) - Demo samples.

## E-Books
- [Level Zero](https://www.construct.net/blogs/construct-official-blog-1/level-zero-free-construct-2-book-853) - Complete book on how to make games.

## Useful Links
- [Game Assets by Andre Antonio Schmitzht](https://game-assets.zeef.com/andre.antonio.schmitz) - Resources and tools for creating assets used in games: graphics, modeling, animation, audio, music, video, maps and others.
- [Game Development by David Arcila](https://game-development.zeef.com/david.arcila) - "*The biggest list of game development resources on the web*".

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
