<div class="github-widget" data-repo="tomodachi94/awesome-computercraft"></div>
<!--lint disable double-link-->
<!--
SPDX-FileCopyrightText: 2024 awesome-computercraft contributors

SPDX-License-Identifier: CC-BY-SA-4.0
-->
<!--lint enable double-link-->
<!--lint ignore-->

## Awesome ComputerCraft [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/tomodachi94/awesome-computercraft/master/assets/cc-tweaked-logo.png" align="right" width="100">](https://computercraft.cc)

> Useful programs, libraries, literature, and mods for [ComputerCraft](https://computercraft.info) and [its forks](https://computercraft.cc).

**ComputerCraft** is a mod for Minecraft which adds computers which are programmable with the Lua programming language. **ComputerCraft: Tweaked** is a fork of the mod for newer Minecraft versions.

This project lives [on GitHub](https://github.com/tomodachi94/awesome-computercraft) and might not render correctly on third-party websites.

If you think something should be added to the list, please [reach out](https://github.com/tomodachi94/awesome-computercraft/issues/new/choose).

If you want to contribute, see [CONTRIBUTING.md](https://github.com/tomodachi94/awesome-computercraft/blob/master/./CONTRIBUTING.md).
If you have other questions, see the [FAQ](https://github.com/tomodachi94/awesome-computercraft/blob/master/./FAQ.md).

A note on abbreviations: `CC` is ComputerCraft, `CC:T` is ComputerCraft: Tweaked, and `CC:R` is ComputerCraft: Restitched.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Mods
### ComputerCraft mods

- [ComputerCraft: Tweaked](https://computercraft.cc) -  A fork of the original ComputerCraft for modern versions of Minecraft.
- [ComputerCraft: Restitched](https://www.curseforge.com/minecraft/mc-mods/cc-restitched) -  A set of patches for CC:T that allow running it on Fabric. 
- [ComputerCraft](https://computercraft.info) -  A mod which adds computers to allow execution of Lua programs. 

### Add-on mods

- [Advanced Peripherals](https://www.curseforge.com/minecraft/mc-mods/advanced-peripherals) -  A mod which adds various peripherals and APIs for interacting with other mods. 
- [Computronics](https://wiki.vexatos.com/wiki:computronics) -  A mod which adds various peripherals, notably for detecting events in the world and for manipulation of sound. 
- [Plethora](https://plethora.madefor.cc) -  A mod which adds peripherals and allows many blocks to be accessed as such. In addition, it also allows for manipulation of the player as a peripheral.
    - [Plethora Fabric](https://github.com/SwitchCraftCC/Plethora-Fabric) - A 1.19+ port of Plethora to Fabric.
- [CC:C Bridge](https://modrinth.com/mod/cccbridge) - A mod that adds compatibility between ComputerCraft and [Create](https://modrinth.com/mod/create).
- [sc-peripherals](https://github.com/SwitchCraftCC/sc-peripherals) - A mod that adds 3D printers which allow creating custom blocks and posters.
- [Turtlematic](https://www.curseforge.com/minecraft/mc-mods/turtlematic) - A mod which expands the applications of turtles, making them extremely powerful.
- [UnlimitedPeripheralWorks](https://www.curseforge.com/minecraft/mc-mods/unlimitedperipheralworks) - A mod which adds various peripherals to extend CC:T capabilities. Also adds a lot of peripherals for other mods.
- [Roadworks](https://github.com/znepb/Roadworks) - A mod that adds traffic lights controllable by ComputerCraft.

### Resource packs

- [ComputerCreate](https://modrinth.com/resourcepack/computercreate) -  A resource pack which adds texture packs in the style of the [Create mod](https://modrinth.com/mod/create).

## Lua programs
### Utility

- [ComputerCraft Advanced Shell (cash)](https://cash.madefor.cc) -  A Bourne-compatible shell for ComputerCraft. 
- [Consult](https://consult.madefor.cc) -  A text editor emphasizing ease of use and compatibility with many systems. 
    - [Consult: Recrafted](https://github.com/manaphoenix/CONSULT_RECRAFTED) -  A fork of Consult for Recrafted systems.
- [GEMU](https://github.com/9551-Dev/GEMU) -  CraftOS-PC graphics mode emulator based on Pixelbox.
- [`gist`](https://pastebin.com/zSLPYpqs) -  A GitHub Gist download/upload program which aims to extend the built-in `pastebin` program, but for Gists.
- [Howl](https://github.com/SquidDev-CC/Howl) -  A build system for CC and CC:T.
- [LuaIDE](https://web.archive.org/web/20230211195528/http://www.computercraft.info/forums2/index.php?/topic/12347-luaide-10-you-might-actually-like-editing-in-game/) -  A full-fledged IDE for editing Lua files in-game.
- [Mildly Better Shell (MBS)](https://github.com/SquidDev-CC/mbs) -  An improved shell that includes scrollback and improved resolution of completions.
- [ModemShark](https://gist.github.com/MCJack123/56ca71555d9c0f78d4c985f1e9ad28e8) -  Modem packet sniffer with a simple UI.
- [netshell](https://github.com/lyqyd/cc-netshell) -  Access a computer's shell from another computer.
- [OrangeBox](https://github.com/walksanatora/orangebox) - Virtualization support for ComputerCraft computers.
- [rawshell](https://gist.github.com/MCJack123/8c8861e5e3082d2bed18d07641b5b2cc) -  A modern alternative to netshell supporting CraftOS-PC's "raw mode" format, with file transfers, encryption, passwords, WebSockets, and more.
- [ShrekPrint](https://pinestore.cc/projects/115/shrekprint) - Printing software with full color and book support.
- [ShrekWord](https://pinestore.cc/projects/114/shrekword) - Word-like document editor.
- [unicornpkg](https://unicornpkg.madefor.cc) -  Modern package management that doesn't suck.
- [FSEncrypt](https://gist.github.com/MCJack123/32c56917dc61da336ec0e8ca6aae39f8) -  Transparent filesystem encryption.

### Library

- [Acidity](https://github.com/9551-Dev/acidity) -  A simple procedual world generation-oriented noise generation library.
- [Anavrins' ChaCha20](https://web.archive.org/web/20200924232302/http://www.computercraft.info/forums2/index.php?/topic/25474-chacha20-encryption-in-computercraft/) -  Implementation of [ChaCha20](https://en.wikipedia.org/wiki/ChaCha20-Poly1305). <!-- FIXME: Broken link -->
- Anavrins' hashing libraries:
    - [MD5](https://pastebin.com/6PVSRckQ) -  Implementation of [MD5](https://en.wikipedia.org/wiki/MD5).
    - [SHA-1](https://pastebin.com/SfL7vxP3) -  Implementation of [SHA-1](https://en.wikipedia.org/wiki/SHA-1) with [HMAC](https://en.wikipedia.org/wiki/HMAC) support.
    - [SHA-256](https://web.archive.org/web/20230211193054/http://www.computercraft.info/forums2/index.php?/topic/8169-sha-256-in-pure-lua/) -  Implementation of [SHA-256](https://en.wikipedia.org/wiki/SHA-2) with support for [HMAC](https://en.wikipedia.org/wiki/HMAC) and [PBKDF2](https://en.wikipedia.org/wiki/PBKDF2).
- [AUKit](https://mcjack123.github.io/AUKit/) -  The quintessential audio processing and conversion library for ComputerCraft. 
- [Basalt](https://basalt.madefor.cc/) -  A GUI library emphasizing the user experience.
- [Bigfont](https://pastebin.com/3LfWxRWh) -  A library that makes writing something in different font sizes easy.
- [C3D](https://c3d.madefor.cc/) -  An advanced 3D rendering API.
- [CC-Archive](https://github.com/MCJack123/CC-Archive) -  Various libraries for archiving and unarchiving files.
- [dbprotect](https://gist.github.com/MCJack123/4cf6fc941a2d412b4195caafb9636363) -  A protection wrapper over the `debug` API, allowing restricting access to upvalues in protected functions.
- [`ecc.lua`](https://web.archive.org/web/20190808224502/http://www.computercraft.info/forums2/index.php?/topic/29803-elliptic-curve-cryptography/) -  Implements [elliptic-curve cryptography](https://en.wikipedia.org/wiki/Elliptic-curve_cryptography). <!-- FIXME: Broken link -->
- [ecnet](https://github.com/migeyel/ecnet) -  Secure network communications in ComputerCraft.
- [GuiH](https://guih.madefor.cc) -  A powerful GUI and graphics library.
- [IsometriH](https://github.com/9551-Dev/IsometriH) -  An [isometric rendering](https://en.wikipedia.org/wiki/Isometric_video_game_graphics) engine.
- [Luz](https://github.com/MCJack123/Luz) - An extremely light compression algorithm for Lua files.
- [Milo](https://github.com/kepler155c/opus-apps/wiki/Milo-(crafting---storage-system)) -  A crafting and inventory management system. Note that this depends on OpusOS and Plethora.
- [Pine3D](https://github.com/Xella37/Pine3D) - A 3D rendering engine designed to be fast.
- [PngLua](https://github.com/9551-Dev/pngLua) -  PNG parsing library designed for ComputerCraft.
- [`Pixelbox Lite`](https://github.com/9551-Dev/pixelbox_lite) - A very fast and flexible teletext 2D rendering library for ComputerCraft.
- [RedRun](https://gist.github.com/MCJack123/473475f07b980d57dd2bd818026c97e8) -  A small library for running processes in the background of CraftOS after exiting the program, similar to DOS TSRs.
- [Tamperer](https://github.com/Fatboychummy-CC/Tamperer) -  A library allowing easy creation of settings menus.
- [Tampl](https://github.com/9551-Dev/tampl) - A Lua tokenization and parsing library designed for dynamic code generation and injecting code into existing programs.
- [Telem](https://telem.cyberbit.dev) - A telemetry library for peripherals, facilitating in-game and cloud-based monitoring dashboards for storage, energy, and machinery.
- [VeriCode](https://gist.github.com/MCJack123/7752c85918bcf23ada028abd615e8750) -  Provides simple code signing functions for safely transferring code over modems.

### Fun

- [AUKit austream](https://github.com/MCJack123/AUKit/blob/master/austream.lua) -  Based on AUKit, a simple audio player supporting WAV, DFPWM, AIFF, AU, and FLAC.
- [battleship](https://gist.github.com/MCJack123/7082da1d2ac725c33ff77389877ad7f4) -  An implementation of the popular two-player game *[Battleship](https://en.wikipedia.org/wiki/Battleship_(game))*.
- [CCDoom](https://github.com/Xella37/CCDoom) - The [*Doom* shooter](https://en.wikipedia.org/wiki/Doom_(1993_video_game)) ported to ComputerCraft using Pine3D.
- [CC-Minecraft](https://github.com/Xella37/CC-Minecraft) - *Minecraft* ported to ComputerCraft using Pine3D.
- [LuaGB](https://github.com/MCJack123/LuaGB) -  A port of a Game Boy (Color) emulator for ComputerCraft. Works best in CraftOS-PC.
- [lunatic86](https://github.com/MCJack123/lunatic86) -  A port of an 8086 PC emulator for ComputerCraft.
- [Musicify](https://github.com/knijn/musicify) -  A lightweight client for playing music on ComputerCraft: Tweaked.
	- [tracc](https://github.com/MCJack123/tracc/tree/playAudio) -  An XM module tracker/player for ComputerCraft, supporting 8 channel polyphony in-game.
- [YahtCC](https://gist.github.com/MCJack123/4f7f1635998f44630c8440e81213d32e) -  An implementation of the *[Yahtzee](https://en.wikipedia.org/wiki/Yahtzee)* dice game.
- [YouCube](https://youcube.madefor.cc) -  Access YouTube and other services in ComputerCraft.
- [YTP2CCP](https://pastebin.com/nxEMWHY3) -  Convert commented YouTube piano notes and play them in CC:T.

### Operating systems

- [LevelOS](https://install.leveloper.cc) -  A modern GUI operating system intended to mimic Windows.
- [Opus](https://github.com/kepler155c/opus) -  An OS which includes a GUI, an app store, and many system-related APIs.
- [Phoenix](https://phoenix.madefor.cc) -  An OS which emphasizes modularity. It implements its own kernel.
    - Phoenix is currently in alpha.
- [Recrafted](https://github.com/ocawesome101/recrafted) -  A rewrite of CraftOS aiming for full feature parity while maintaining "saner API design."
- [UnBIOS](https://gist.github.com/MCJack123/42bc69d3757226c966da752df80437dc) -  A program to "undo" CraftOS, returning the system to the same state it was in before running the BIOS. Useful for OS development.
- [cOS](https://github.com/knijn/cos) - The NixOS inspired configurable ComputerCraft OS.


### Economy

- [`colorful.kst`](https://github.com/znepb/colorful) - A Krist store which sells colorful blocks, coloring them on demand.
- [Kristify](https://kristify.madefor.cc/) - Software for highly customizable Krist shops in modern versions of ComputerCraft, powered by [Basalt](https://basalt.madefor.cc).
- [LP](https://github.com/migeyel/lp) - A Krist shop which dynamically adjusts buy and sell prices based on supply and demand.
- [msks](https://github.com/MasonGulu/msks) -  A modern, simple shop for the Krist virtual currency.
- [printshop](https://github.com/znepb/printshop) - A Krist shop which sells 3D prints and posters, also allowing players to print their own designs.

### Mod-specific programs

> Note: This section contains programs which are exclusive to a mod and would not make sense in the Utilities section.

- [DraconicControl](https://pastebin.com/UqVHTht5) -  Allows controlling Draconic Evolution's Draconic Reactor from a computer.
- [ReactorControl and TurbineControl](https://pastebin.com/p4zeq7Ma) -  Automatic management of reactors and turbines in Big Reactors.
    - [ReactorControl patched](https://pastebin.com/2ZrbnH5w) -  The preceeding program uses the `parallel` API recursively, which could cause it to break. A patch has been developed to fix this.
- [`cc-mek-scada`](https://github.com/MikaylaFischler/cc-mek-scada) - Configurable control system for Mekanism fission reactors.

## Non-Lua programs

> Note: This section is for programs that are not mods or Lua programs and **directly** relate to the subject of this list.

### Bridging

> Note: This subsection is for programs which allow ComputerCraft things to be accessed out of the game, primarily through the Internet.

<!-- vale Google.WordList = NO -->
- [Cloud Catcher](https://github.com/SquidDev-CC/cloud-catcher) -  A program which enables interaction with computers outside of the game.
<!-- vale Google.WordList = YES -->
- [Krist Server](https://github.com/tmpim/Krist) -  A server for the Krist virtual currency, intended for use with CC and CC:T.
    - [KristForge](https://github.com/tmpim/kristforge) -  A miner for the Krist virtual currency.
    - [KristWeb2](https://github.com/tmpim/KristWeb2) -  A web wallet for Krist, written in React.
- [Netmount](https://github.com/tmpim/netmountcc) - Configurable WebSocket and WebDAV remote storage solution.
- [Ultron Control](https://gitlab.com/Merith-TK/ultron-control) -  A program which exposes a web API for controlling turtles.

### Emulators

- [CCEmuX](https://emux.cc) -  A CC and CC:T emulator which executes the mods directly.
- [Copy Cat](https://github.com/SquidDev-CC/copy-cat) -  A CC:T emulator that runs in a web browser.
- [CraftOS-PC](https://www.craftos-pc.cc) -  A CC:T emulator written in C++ with the intention of speed.

### Plugins

- [CraftOS-PC for VS Code](https://www.craftos-pc.cc/docs/extension) -  Extension for manipulating and running programs via CraftOS-PC in VSCode.
- [`craftos2-plugins`](https://github.com/MCJack123/craftos2-plugins) -  A collection of small plugins for CraftOS-PC, maintained by the creator.
- [VSCode Extensions for ComputerCraft](https://marketplace.visualstudio.com/items?itemName=lemmmy.computercraft-extension-pack) -  Self-explanatory. Contains autocomplete for CC and CC:T functions, as well as a Lua language server.

### Tools

- [ComputerCraft Music Converter](https://music.madefor.cc) - A web app to convert various sound formats to DFPWM (ComputerCraft's sound format).
- [BIMG-Generator](https://github.com/MasonGulu/BIMG-Generator) - A Java program to convert images to the BIMG format.
- [`cc-tstl-template`](https://github.com/MCJack123/cc-tstl-template) -  A template for the TypeScriptToLua compiler that allows writing ComputerCraft programs in TypeScript.
- [sanjuuni](https://github.com/MCJack123/sanjuuni) -  A program to quickly convert image and video files into various formats for playback and streaming in ComputerCraft.

## Literature
### Essays

- [JackMacWindows's essay on ComputerCraft OSes](https://gist.github.com/MCJack123/4b2bca21bdc0cf5c67ce7177326c2154) -  Contains suggestions, discouragement, and encouragement for building a proper operating system.
- [JackMacWindows's essay on sane APIs](https://gist.github.com/MCJack123/39ac0847579b3676cc098aca5860c758) -  Has suggestions for making your APIs easy to use.

### Tutorials
#### Basics
- [Direwolf20's tutorials](https://www.youtube.com/watch?v=wrUHUhfCY5A) -  A series of videos explaining the basics of ComputerCraft programming. 
- [Sethbling's tutorials](https://www.youtube.com/watch?v=DSsx4VSe-Uk) -  Another series of videos explaining ComputerCraft programming.
- Lyqyd's *Computer Basics* series ([1](https://web.archive.org/web/20170617144334/http://www.computercraft.info/forums2/index.php?/topic/15033-computer-basics-i/), [2](https://web.archive.org/web/20230719181359/https://www.computercraft.info/forums2/index.php?/topic/15041-computer-basics-ii/), [3](https://web.archive.org/web/20230719181437/https://www.computercraft.info/forums2/index.php?/topic/20905-computer-basics-iii/)) -  Though a bit dated, they are excellent for the beginnings of your journey.
- [The FTB Wiki's Getting Started guide for ComputerCraft](https://ftb.fandom.com/wiki/Getting_Started_(ComputerCraft)) -  A useful all-around resource for getting started.

#### Moderate or advanced
- [Bomb Bloke's *Guide to Coroutines*](https://web.archive.org/web/20230210142049/https://www.computercraft.info/forums2/index.php?/topic/25670-bbs-guide-to-coroutines/) -  Explains why you should not use coroutines, and includes tutorials on using them.

### Charts, tables, and calculators

- [JackMacWindows's coroutine flow chart](https://web.archive.org/web/20231212184953/https://cdn.discordapp.com/attachments/477911902152949771/959769473437560862/Blank_Diagram_1_Page_1.png) -  Demonstrates how coroutines work. Each column represents one coroutine's code flow.
- [KingOfGamesYami's event flow chart](https://forums.computercraft.cc/index.php?topic=26.0) -  Demonstrates the flow of events when a program runs.
<!--lint ignore-->
- [Wojbie's decimal font chart](https://web.archive.org/web/20231212200503/https://cdn.discordapp.com/attachments/477911902152949771/933498000385400862/1642633650325141456271.png) and [Cake's hex font chart](https://web.archive.org/web/20231118175928/https://thox.madefor.cc/_images/encodings-cc-chars.png) -  Contains decimal and hex mappings to ComputerCraft font characters.
- [Emma's ComputerCraft compatibility chart](https://docs.google.com/spreadsheets/d/1s4d21cL3QrUyegEzYaVXvqDr1zNorgyZ-fDWeopIC1k/edit?usp=sharing) -  Shows compatibility across emulators and in-game mods.
- [MasonGulu's monitor size calculator](https://monitorsize.madefor.cc/) - An online gadget which calculates how many characters and pixels will fit onto a monitor.

### Other lists

- [Awesome Lua](https://github.com/LewisJEllis/awesome-lua) - An Awesome list specific to the Lua programming language.
- [Awesome SwitchCraft](https://github.com/aspen-reeves/awesome-switchcraft) - An Awesome list specific to the SwitchCraft server.
- [Hengestone's list of languages which compile to Lua](https://github.com/hengestone/lua-languages/blob/master/README.md) -  A list of languages which compile to Lua.

## Resources

- [`tweaked.cc` documentation](https://tweaked.cc) -  Contains documentation for most methods in CC and CC:T.
- [CC's forums](https://computercraft.info/forums2) -  An extremely valuable resource, filled with tutorials and programs. <!-- FIXME: Broken link -->
- [CC:T's forums](https://forums.computercraft.cc) -  Also extremely valuable, but is newer.
- [Minecraft Computer Mods Discord](https://discord.gg/H2UyJXe) -  A Discord server for getting help with programming in CC and CC:T.
- [ComputerCraft's subreddit](https://reddit.com/r/computercraft) - A subreddit for showing off your ComputerCraft creations, as well as getting help.
<!-- vale Vale.Terms = NO -->
- [Lua's manual](https://www.lua.org/manual/) -  Contains documentation on methods not covered in `Tweaked.cc`. Sections 5 (Auxillary Library) and 6 (Standard Library) are of particular interest.
<!-- vale Vale.Terms = YES -->
