<div class="github-widget" data-repo="jbhuang0604/awesome-computer-vision"></div>

## Awesome Computer Vision: [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
精选的计算机视觉资源列表，灵感来自 [awesome-php](https://github.com/ziadoz/awesome-php).

如需计算机视觉领域的人物名单及其学术谱系，请访问 [here](https://github.com/jbhuang0604/awesome-computer-vision/blob/master/people.md)

## Contributing
请随时寄给我 [pull requests](https://github.com/jbhuang0604/awesome-computer-vision/pulls) 或发送电子邮件 (jbhuang@vt.edu) 添加链接.



## Awesome Lists
 - [Awesome Machine Learning](https://github.com/josephmisiti/awesome-machine-learning)
 - [Awesome Deep Vision](https://github.com/kjw0612/awesome-deep-vision)
 - [Awesome Domain Adaptation](https://github.com/zhaoxin94/awesome-domain-adaptation)
 - [Awesome Object Detection](https://github.com/amusi/awesome-object-detection)
 - [Awesome 3D Machine Learning](https://github.com/timzhang642/3D-Machine-Learning)
 - [Awesome Action Recognition](https://github.com/jinwchoi/awesome-action-recognition)
 - [Awesome Scene Understanding](https://github.com/bertjiazheng/awesome-scene-understanding)
 - [Awesome Adversarial Machine Learning](https://github.com/yenchenlin/awesome-adversarial-machine-learning)
 - [Awesome Adversarial Deep Learning](https://github.com/chbrian/awesome-adversarial-examples-dl)
 - [Awesome Face](https://github.com/polarisZhao/awesome-face)
 - [Awesome Face Recognition](https://github.com/ChanChiChoi/awesome-Face_Recognition)
 - [Awesome Human Pose Estimation](https://github.com/wangzheallen/awesome-human-pose-estimation)
 - [Awesome medical imaging](https://github.com/fepegar/awesome-medical-imaging)
 - [Awesome Images](https://github.com/heyalexej/awesome-images)
 - [Awesome Graphics](https://github.com/ericjang/awesome-graphics)
 - [Awesome Neural Radiance Fields](https://github.com/yenchenlin/awesome-NeRF)
 - [Awesome Implicit Neural Representations](https://github.com/vsitzmann/awesome-implicit-representations)
 - [Awesome Neural Rendering](https://github.com/weihaox/awesome-neural-rendering)
 - [Awesome Public Datasets](https://github.com/awesomedata/awesome-public-datasets)
 - [Awesome Dataset Tools](https://github.com/jsbroks/awesome-dataset-tools)
 - [Awesome Robotics Datasets](https://github.com/sunglok/awesome-robotics-datasets)
 - [Awesome Mobile Machine Learning](https://github.com/fritzlabs/Awesome-Mobile-Machine-Learning)
 - [Awesome Explainable AI](https://github.com/wangyongjie-ntu/Awesome-explainable-AI)
 - [Awesome Fairness in AI](https://github.com/datamllab/awesome-fairness-in-ai)
 - [Awesome Machine Learning Interpretability](https://github.com/jphall663/awesome-machine-learning-interpretability)
 - [Awesome Production Machine Learning](https://github.com/EthicalML/awesome-production-machine-learning)
 - [Awesome Video Text Retrieval](https://github.com/danieljf24/awesome-video-text-retrieval)
 - [Awesome Image-to-Image Translation](https://github.com/weihaox/awesome-image-translation)
 - [Awesome Image Inpainting](https://github.com/1900zyh/Awesome-Image-Inpainting)
 - [Awesome Deep HDR](https://github.com/vinthony/awesome-deep-hdr)
 - [Awesome Video Generation](https://github.com/matthewvowels1/Awesome-Video-Generation)
 - [Awesome GAN applications](https://github.com/nashory/gans-awesome-applications)
 - [Awesome Generative Modeling](https://github.com/zhoubolei/awesome-generative-modeling)
 - [Awesome Image Classification](https://github.com/weiaicunzai/awesome-image-classification)
 - [Awesome Deep Learning](https://github.com/ChristosChristofidis/awesome-deep-learning)
 - [Awesome Machine Learning in Biomedical(Healthcare) Imaging](https://github.com/XindiWu/Awesome-Machine-Learning-in-Biomedical-Healthcare-Imaging)
 - [Awesome Deep Learning for Tracking and Detection](https://github.com/abhineet123/Deep-Learning-for-Tracking-and-Detection)
 - [Awesome Human Pose Estimation](https://github.com/wangzheallen/awesome-human-pose-estimation)
 - [Awesome Deep Learning for Video Analysis](https://github.com/HuaizhengZhang/Awsome-Deep-Learning-for-Video-Analysis)
 - [Awesome Vision + Language](https://github.com/yuewang-cuhk/awesome-vision-language-pretraining-papers)
 - [Awesome Robotics](https://github.com/kiloreux/awesome-robotics)
 - [Awesome Visual Transformer](https://github.com/dk-liang/Awesome-Visual-Transformer)
 - [Awesome Embodied Vision](https://github.com/ChanganVR/awesome-embodied-vision)
 - [Awesome Anomaly Detection](https://github.com/hoya012/awesome-anomaly-detection)
 - [Awesome Makeup Transfer](https://github.com/thaoshibe/awesome-makeup-transfer)
 - [Awesome Learning with Label Noise](https://github.com/subeeshvasu/Awesome-Learning-with-Label-Noise)
 - [Awesome Deblurring](https://github.com/subeeshvasu/Awesome-Deblurring)
 - [Awsome Deep Geometry Learning](https://github.com/subeeshvasu/Awsome_Deep_Geometry_Learning)
 - [Awesome Image Distortion Correction](https://github.com/subeeshvasu/Awesome-Image-Distortion-Correction)
 - [Awesome Neuron Segmentation in EM Images](https://github.com/subeeshvasu/Awesome-Neuron-Segmentation-in-EM-Images)
 - [Awsome Delineation](https://github.com/subeeshvasu/Awsome_Delineation)
 - [Awesome ImageHarmonization](https://github.com/subeeshvasu/Awesome-ImageHarmonization)
 - [Awsome GAN Training](https://github.com/subeeshvasu/Awsome-GAN-Training)
 - [Awesome Document Understanding](https://github.com/tstanislawek/awesome-document-understanding)
 

## Books

#### Computer Vision
* [Computer Vision:  Models, Learning, and Inference](http://www.computervisionmodels.com/) - Simon J.D. Prince 2012
* [Computer Vision: Theory and Application](http://szeliski.org/Book/) - 里克·塞利斯基 2010
* [Computer Vision: A Modern Approach (2nd edition)](http://www.amazon.com/Computer-Vision-Modern-Approach-2nd/dp/013608592X/ref=dp_ob_title_bk) - 大卫·福赛斯和让·庞塞 2011
* [Multiple View Geometry in Computer Vision](http://www.robots.ox.ac.uk/~vgg/hzbook/) - 理查德哈特利和安德鲁齐瑟曼 2004
* [Computer Vision](http://www.amazon.com/Computer-Vision-Linda-G-Shapiro/dp/0130307963) - 琳达·G·夏皮罗 2001
* [Vision Science: Photons to Phenomenology](http://www.amazon.com/Vision-Science-Phenomenology-Stephen-Palmer/dp/0262161834/) - 斯蒂芬·E·帕尔默 1999
* [Visual Object Recognition synthesis lecture](http://www.morganclaypool.com/doi/abs/10.2200/S00332ED1V01Y201103AIM011) - 克里斯汀格劳曼和巴斯蒂安雷贝 2011
* [Computer Vision for Visual Effects](http://cvfxbook.com/) - 理查德·拉德克 (Richard J. Radke)，2012 年
* [High dynamic range imaging: acquisition, display, and image-based lighting](http://www.amazon.com/High-Dynamic-Range-Imaging-Second/dp/012374914X) - Reinhard, E., Heidrich, W., Debevec, P., Pattanaik, S., Ward, G., Myszkowski, K 2010
* [Numerical Algorithms: Methods for Computer Vision, Machine Learning, and Graphics](https://people.csail.mit.edu/jsolomon/share/book/numerical_book.pdf) - 贾斯汀所罗门 2015
* [Image Processing and Analysis](https://www.amazon.com/Processing-Analysis-Activate-Learning-Engineering/dp/1285179528) - 斯坦·伯奇菲尔德 2018
* [Computer Vision, From 3D Reconstruction to Recognition](http://web.stanford.edu/class/cs231a/) 西尔维奥·萨瓦雷塞 2018

#### OpenCV Programming
* [Learning OpenCV: Computer Vision with the OpenCV Library](http://www.amazon.com/Learning-OpenCV-Computer-Vision-Library/dp/0596516134) - 加里布拉德斯基和阿德里安凯勒
* [Practical Python and OpenCV](https://www.pyimagesearch.com/practical-python-opencv/) - 阿德里安·罗斯布鲁克
* [OpenCV Essentials](http://www.amazon.com/OpenCV-Essentials-Oscar-Deniz-Suarez/dp/1783984244/ref=sr_1_1?s=books&ie=UTF8&qid=1424594237&sr=1-1&keywords=opencv+essentials#) - Oscar Deniz Suarez、Mª del Milagro Fernandez Carrobles、Noelia Vallez Enano、Gloria Bueno Garcia、Ismael Serrano Gracia

#### Machine Learning
* [Pattern Recognition and Machine Learning](http://research.microsoft.com/en-us/um/people/cmbishop/prml/index.htm) - 克里斯托弗·M·毕晓普 2007
* [Neural Networks for Pattern Recognition](http://www.engineering.upm.ro/master-ie/sacpi/mat_did/info068/docum/Neural%20Networks%20for%20Pattern%20Recognition.pdf) - Christopher M. Bishop 1995
* [Probabilistic Graphical Models: Principles and Techniques](http://pgm.stanford.edu/) - 达芙妮·科勒和尼尔·弗里德曼 2009
* [Pattern Classification](http://www.amazon.com/Pattern-Classification-2nd-Richard-Duda/dp/0471056693) - Peter E. Hart、David G. Stork 和 Richard O. Duda 2000
* [Machine Learning](http://www.amazon.com/Machine-Learning-Tom-M-Mitchell/dp/0070428077/) - 汤姆米切尔 1997
* [Gaussian processes for machine learning](http://www.gaussianprocess.org/gpml/) - Carl Edward Rasmussen 和 Christopher KI Williams 2005
* [Learning From Data](https://work.caltech.edu/telecourse.html)- Yaser S. Abu-Mostafa, Malik Magdon-Ismail and Hsuan-Tien Lin 2012
* [Neural Networks and Deep Learning](http://neuralnetworksanddeeplearning.com/) - 迈克尔·尼尔森 2014
* [Bayesian Reasoning and Machine Learning](http://www.cs.ucl.ac.uk/staff/d.barber/brml/) - David Barber，剑桥大学出版社，2012 年

#### Fundamentals
 * [Linear Algebra and Its Applications](http://www.amazon.com/Linear-Algebra-Its-Applications-4th/dp/0030105676/ref=sr_1_4?ie=UTF8&qid=1421433773&sr=8-4&keywords=Linear+Algebra+and+Its+Applications) - 吉尔伯特斯特朗 1995

## Courses

#### Computer Vision
 * [EENG 512 / CSCI 512 - Computer Vision](http://inside.mines.edu/~whoff/courses/EENG512/) - William Hoff（科罗拉多矿业学院）
 * [Visual Object and Activity Recognition](https://sites.google.com/site/ucbcs29443/) - Alexei A. Efros 和 Trevor Darrell（加州大学伯克利分校）
 * [Computer Vision](http://courses.cs.washington.edu/courses/cse455/12wi/) - Steve Seitz（华盛顿大学）
 * 视觉识别 [Spring 2016](http://vision.cs.utexas.edu/381V-spring2016/), [Fall 2016](http://vision.cs.utexas.edu/381V-fall2016/) - 克里斯汀·格劳曼 (UT Austin)
 * [Language and Vision](http://www.tamaraberg.com/teaching/Spring_15/) - Tamara Berg（北卡罗来纳大学教堂山分校）
 * [Convolutional Neural Networks for Visual Recognition](http://vision.stanford.edu/teaching/cs231n/) - Fei-Fei Li and Andrej Karpathy (Stanford University)
 * [Computer Vision](http://cs.nyu.edu/~fergus/teaching/vision/index.html) - 罗伯·弗格斯（纽约大学）
 * [Computer Vision](https://courses.engr.illinois.edu/cs543/sp2015/) - 德里克·霍伊姆 (UIUC)
 * [Computer Vision: Foundations and Applications](http://vision.stanford.edu/teaching/cs131_fall1415/index.html) - Kalanit Grill-Spector 和 Fei-Fei Li（斯坦福大学）
 * [High-Level Vision: Behaviors, Neurons and Computational Models](http://vision.stanford.edu/teaching/cs431_spring1314/) - Fei-Fei Li (Stanford University)
 * [Advances in Computer Vision](http://6.869.csail.mit.edu/fa15/) -Antonio Torralba 和 Bill Freeman（麻省理工学院）
 * [Computer Vision](http://www.vision.rwth-aachen.de/course/11/) - Bastian Leibe（亚琛工业大学）
 * [Computer Vision 2](http://www.vision.rwth-aachen.de/course/9/) - Bastian Leibe（亚琛工业大学）
 * [Computer Vision](http://klewel.com/conferences/epfl-computer-vision/) 帕斯卡公式 (EPFL)：
 * [Computer Vision 1](http://cvlab-dresden.de/courses/computer-vision-1/) Carsten Rother（德累斯顿工业大学）：
 * [Computer Vision 2](http://cvlab-dresden.de/courses/CV2/) Carsten Rother（德累斯顿工业大学）：
 * [Multiple View Geometry](https://youtu.be/RDkwklFGMfo?list=PLTBdjV_4f-EJn6udZ34tht9EVIW7lbeo4) Daniel Cremers（慕尼黑工业大学）：




#### Computational Photography
* [Image Manipulation and Computational Photography](http://inst.eecs.berkeley.edu/~cs194-26/fa14/) - Alexei A. Efros（加州大学伯克利分校）
* [Computational Photography](http://graphics.cs.cmu.edu/courses/15-463/2012_fall/463.html) - Alexei A. Efros (CMU)
* [Computational Photography](https://courses.engr.illinois.edu/cs498dh3/) - 德里克·霍伊姆 (UIUC)
* [Computational Photography](http://cs.brown.edu/courses/csci1290/) - 詹姆斯·海斯（布朗大学）
* [Digital & Computational Photography](http://stellar.mit.edu/S/course/6/sp12/6.815/) - 弗雷多杜兰德（麻省理工学院）
* [Computational Camera and Photography](http://ocw.mit.edu/courses/media-arts-and-sciences/mas-531-computational-camera-and-photography-fall-2009/) - Ramesh Raskar（麻省理工学院媒体实验室）
* [Computational Photography](https://www.udacity.com/course/computational-photography--ud955) - Irfan Essa（佐治亚理工学院）
* [Courses in Graphics](http://graphics.stanford.edu/courses/) - 斯坦福大学
* [Computational Photography](http://cs.nyu.edu/~fergus/teaching/comp_photo/index.html) - 罗伯·弗格斯（纽约大学）
* [Introduction to Visual Computing](http://www.cs.toronto.edu/~kyros/courses/320/) - Kyros Kutulakos（多伦多大学）
* [Computational Photography](http://www.cs.toronto.edu/~kyros/courses/2530/) - Kyros Kutulakos（多伦多大学）
* [Computer Vision for Visual Effects](https://www.ecse.rpi.edu/~rjradke/cvfxcourse.html) - Rich Radke（伦斯勒理工学院）
* [Introduction to Image Processing](https://www.ecse.rpi.edu/~rjradke/improccourse.html) - Rich Radke（伦斯勒理工学院）

#### Machine Learning and Statistical Learning
 * [Machine Learning](https://www.coursera.org/learn/machine-learning) - Andrew Ng（斯坦福大学）
 * [Learning from Data](https://work.caltech.edu/telecourse.html) - Yasser S. Abu-Mostafa（加州理工学院）
 * [Statistical Learning](https://class.stanford.edu/courses/HumanitiesandScience/StatLearning/Winter2015/about) - Trevor Hastie 和 Rob Tibshirani（斯坦福大学）
 * [Statistical Learning Theory and Applications](http://www.mit.edu/~9.520/fall14/) - Tomaso Poggio、Lorenzo Rosasco、Carlo Ciliberto、Charlie Frogner、Georgios Evangelopoulos、Ben Deen（麻省理工学院）
 * [Statistical Learning](http://www.stat.rice.edu/~gallen/stat640.html) - Genevera Allen（莱斯大学）
 * [Practical Machine Learning](http://www.cs.berkeley.edu/~jordan/courses/294-fall09/) - 迈克尔乔丹（加州大学伯克利分校）
 * [Course on Information Theory, Pattern Recognition, and Neural Networks](http://videolectures.net/course_information_theory_pattern_recognition/) - David MacKay（剑桥大学）
 * [Methods for Applied Statistics: Unsupervised Learning](http://web.stanford.edu/~lmackey/stats306b/) - 莱斯特麦基（斯坦福大学）
 * [Machine Learning](http://www.robots.ox.ac.uk/~az/lectures/ml/index.html) - Andrew Zisserman（牛津大学）
 * [Intro to Machine Learning](https://www.udacity.com/course/intro-to-machine-learning--ud120) - Sebastian Thrun（斯坦福大学）
 * [Machine Learning](https://www.udacity.com/course/machine-learning--ud262) - Charles Isbell、Michael Littman（佐治亚理工学院）
 * [(Convolutional) Neural Networks for Visual Recognition](https://cs231n.github.io/) - Fei-Fei Li、Andrej Karphaty、Justin Johnson（斯坦福大学）
 * [Machine Learning for Computer Vision](https://youtu.be/QZmZFeZxEKI?list=PLTBdjV_4f-EIiongKlS9OKrBEp8QR47Wl) - Rudolph Triebel（慕尼黑工业大学）



#### Optimization
 * [Convex Optimization I](http://stanford.edu/class/ee364a/) - Stephen Boyd（斯坦福大学）
 * [Convex Optimization II](http://stanford.edu/class/ee364b/) - Stephen Boyd（斯坦福大学）
 * [Convex Optimization](https://class.stanford.edu/courses/Engineering/CVX101/Winter2014/about) - Stephen Boyd（斯坦福大学）
 * [Optimization at MIT](http://optimization.mit.edu/classes.php) - （和）
 * [Convex Optimization](http://www.stat.cmu.edu/~ryantibs/convexopt/) - 瑞安·蒂布希拉尼 (CMU)

## Papers

#### Conference papers on the web
 * [CVPapers](http://www.cvpapers.com/) - 网络上的计算机视觉论文
 * [SIGGRAPH Paper on the web](http://kesen.realtimerendering.com/) - 网络上的图形文件
 * [NIPS Proceedings](http://papers.nips.cc/) - 网络上的 NIPS 论文
 * [Computer Vision Foundation open access](http://www.cv-foundation.org/openaccess/menu.py)
 * [Annotated Computer Vision Bibliography](http://iris.usc.edu/Vision-Notes/bibliography/contents.html) - 基思普莱斯（南加州大学）
 * [Calendar of Computer Image Analysis, Computer Vision Conferences](http://iris.usc.edu/Information/Iris-Conferences.html) -（南加州大学）

#### Survey Papers
 * [Visionbib Survey Paper List](http://surveys.visionbib.com/index.html)
 * [Foundations and Trends® in Computer Graphics and Vision](http://www.nowpublishers.com/CGV)
 * [Computer Vision: A Reference Guide](http://link.springer.com/book/10.1007/978-0-387-31439-6)

 ##预训练的计算机视觉模型
 * [List of Computer Vision models](https://github.com/shubham-shahh/Open-Source-Models) 这些模型是在自定义对象上训练

## Tutorials and talks

#### Computer Vision
 * [Computer Vision Talks](http://www.computervisiontalks.com/) - 关于计算机视觉的讲座、主题演讲、小组讨论
 * [The Three R's of Computer Vision](https://www.youtube.com/watch?v=Mqg6eorYRIQ) - Jitendra Malik（加州大学伯克利分校）2013
 * [Applications to Machine Vision](http://videolectures.net/epsrcws08_blake_amv/) - Andrew Blake（微软研究院）2008
 * [The Future of Image Search](http://videolectures.net/kdd08_malik_fis/?q=image) - Jitendra Malik（加州大学伯克利分校）2008
 * [Should I do a PhD in Computer Vision?](https://www.youtube.com/watch?v=M17oGxh3Ny8) - Fatih Porikli（澳大利亚国立大学）
 - [Graduate Summer School 2013: Computer Vision](http://www.ipam.ucla.edu/programs/summer-schools/graduate-summer-school-computer-vision/?tab=schedule) - IPAM, 2013

#### Recent Conference Talks
- [CVPR 2015](http://www.pamitc.org/cvpr15/) - Jun 2015
- [ECCV 2014](http://videolectures.net/eccv2014_zurich/) - 2014 年 9 月
- [CVPR 2014](http://techtalks.tv/cvpr-2014-oral-talks/) - Jun 2014
- [ICCV 2013](http://techtalks.tv/iccv2013/) - 2013 年 12 月
- [ICML 2013](http://techtalks.tv/icml/2013/) - 2013 年 7 月
- [CVPR 2013](http://techtalks.tv/cvpr2013/) - Jun 2013
- [ECCV 2012](http://videolectures.net/eccv2012_firenze/) - 2012 年 10 月
- [ICML 2012](http://techtalks.tv/icml/2012/orals/) - Jun 2012
- [CVPR 2012](http://techtalks.tv/cvpr2012webcast/) - Jun 2012

#### 3D Computer Vision
 * [3D Computer Vision: Past, Present, and Future](https://www.youtube.com/watch?v=kyIzMr917Rc) - Steve Seitz（华盛顿大学）2011
 * [Reconstructing the World from Photos on the Internet](https://www.youtube.com/watch?v=04Kgg3QEXFI) - Steve Seitz（华盛顿大学）2013

#### Internet Vision
 * [The Distributed Camera](http://www.technologyreview.com/video/426265/meet-2011-tr35-winner-noah-snavely/) — Noah Snavely（康奈尔大学）2011
 * [Planet-Scale Visual Understanding](https://www.youtube.com/watch?v=UHkCa9-Z1Ps) — Noah Snavely（康奈尔大学）2014
 * [A Trillion Photos](https://www.youtube.com/watch?v=6MWEfpKUfRc) - Steve Seitz（华盛顿大学）2013

#### Computational Photography
 * [Reflections on Image-Based Modeling and Rendering](https://www.youtube.com/watch?v=j90_0Ndk7XM) - Richard Szeliski（微软研究院）2013
 * [Photographing Events over Time](https://www.youtube.com/watch?v=ZvPaHZZVPRk) - 威廉·弗里曼 (麻省理工学院) 2011
 * [Old and New algorithm for Blind Deconvolution](http://videolectures.net/nipsworkshops2011_weiss_deconvolution/) - Yair Weiss（耶路撒冷希伯来大学）2011
 * [A Tour of Modern "Image Processing"](http://videolectures.net/nipsworkshops2010_milanfar_tmi/) - Peyman Milanfar（加州大学圣克鲁兹分校/谷歌）2010
 * [Topics in image and video processing](http://videolectures.net/mlss07_blake_tiivp/) Andrew Blake（微软研究院）2007
 * [Computational Photography](https://www.youtube.com/watch?v=HJVNI0mkmqk) - 威廉·弗里曼 (麻省理工学院) 2012
 * [Revealing the Invisible](https://www.youtube.com/watch?v=_BWnIQY_X98) - Fredo Durand (麻省理工学院) 2012
 * [Overview of Computer Vision and Visual Effects](https://www.youtube.com/watch?v=rE-hVtytT-I) - Rich Radke（伦斯勒理工学院）2014

#### Learning and Vision
 * [Where machine vision needs help from machine learning](http://videolectures.net/colt2011_freeman_help/?q=computer%20vision) - 威廉·弗里曼 (麻省理工学院) 2011
 * [Learning in Computer Vision](http://videolectures.net/mlss08au_lucey_linv/) - 西蒙·卢西 (CMU) 2008
 * [Learning and Inference in Low-Level Vision](http://videolectures.net/nips09_weiss_lil/?q=computer%20vision) - Yair Weiss（耶路撒冷希伯来大学）2009

#### Object Recognition
 * [Object Recognition](http://research.microsoft.com/apps/video/dl.aspx?id=231358) - 拉里齐特尼克（微软研究院）
 * [Generative Models for Visual Objects and Object Recognition via Bayesian Inference](http://videolectures.net/mlas06_li_gmvoo/?q=Fei-Fei%20Li) - Fei-Fei Li (Stanford University)

#### Graphical Models
 * [Graphical Models for Computer Vision](http://videolectures.net/uai2012_felzenszwalb_computer_vision/?q=computer%20vision) - Pedro Felzenszwalb（布朗大学）2012
 * [Graphical Models](http://videolectures.net/mlss09uk_ghahramani_gm/) - Zoubin Ghahramani（剑桥大学）2009
 * [Machine Learning, Probability and Graphical Models](http://videolectures.net/mlss06tw_roweis_mlpgm/) - Sam Roweis（纽约大学）2006
 * [Graphical Models and Applications](http://videolectures.net/mlss09us_weiss_gma/?q=Graphical%20Models) - Yair Weiss（耶路撒冷希伯来大学）2009

#### Machine Learning
 * [A Gentle Tutorial of the EM Algorithm](https://nikola-rt.ee.washington.edu/people/bulyko/papers/em.pdf) - Jeff A. Bilmes（加州大学伯克利分校）1998
 * [Introduction To Bayesian Inference](http://videolectures.net/mlss09uk_bishop_ibi/) - Christopher Bishop（微软研究院）2009
 * [Support Vector Machines](http://videolectures.net/mlss06tw_lin_svm/) - Chih-Jen Lin（国立台湾大学）2006
 * [Bayesian or Frequentist, Which Are You? ](http://videolectures.net/mlss09uk_jordan_bfway/) - Michael I. Jordan（加州大学伯克利分校）

#### Optimization
 * [Optimization Algorithms in Machine Learning](http://videolectures.net/nips2010_wright_oaml/) - Stephen J. Wright（威斯康星大学麦迪逊分校）
 * [Convex Optimization](http://videolectures.net/mlss07_vandenberghe_copt/?q=convex%20optimization) - Lieven Vandenberghe（加州大学洛杉矶分校）
 * [Continuous Optimization in Computer Vision](https://www.youtube.com/watch?v=oZqoWozVDVg) - Andrew Fitzgibbon（微软研究院）
 * [Beyond stochastic gradient descent for large-scale machine learning](http://videolectures.net/sahd2014_bach_stochastic_gradient/) -弗朗西斯·巴赫 (INRIA)
 * [Variational Methods for Computer Vision](https://www.youtube.com/playlist?list=PLTBdjV_4f-EJ7A2iIH5L5ztqqrWYjP2RI) - Daniel Cremers（慕尼黑工业大学）（[lecture 18 missing from playlist](https://www.youtube.com/watch?v=GgcbVPNd3SI))

#### Deep Learning
 * [A tutorial on Deep Learning](http://videolectures.net/jul09_hinton_deeplearn/) - Geoffrey E. Hinton（多伦多大学）
 * [Deep Learning](http://videolectures.net/kdd2014_salakhutdinov_deep_learning/?q=Hidden%20Markov%20model#) - Ruslan Salakhutdinov（多伦多大学）
 * [Scaling up Deep Learning](http://videolectures.net/kdd2014_bengio_deep_learning/) - Joshua Bengio（蒙特利尔大学）
 * [ImageNet Classification with Deep Convolutional Neural Networks](http://videolectures.net/machine_krizhevsky_imagenet_classification/?q=deep%20learning) - Alex Krizhevsky（多伦多大学）
 * [The Unreasonable Effectivness Of Deep Learning](http://videolectures.net/sahd2014_lecun_deep_learning/) Yann LeCun（纽约大学/Facebook 研究）2014
 * [Deep Learning for Computer Vision](https://www.youtube.com/watch?v=qgx57X0fBdA) - Rob Fergus（纽约大学/Facebook 研究）
 * [High-dimensional learning with deep network contractions](http://videolectures.net/sahd2014_mallat_dimensional_learning/) - Stéphane Mallat（高等师范学院）
 * [Graduate Summer School 2012: Deep Learning, Feature Learning](http://www.ipam.ucla.edu/programs/summer-schools/graduate-summer-school-deep-learning-feature-learning/?tab=schedule) - IPAM, 2012
 * [Workshop on Big Data and Statistical Machine Learning](http://www.fields.utoronto.ca/programs/scientific/14-15/bigdata/machine/)
 * [Machine Learning Summer School](https://www.youtube.com/channel/UC3ywjSv5OsDiDAnOP8C1NiQ) - 雷克雅未克，冰岛 2014
	* [Deep Learning Session 1](https://www.youtube.com/watch?v=JuimBuvEWBg) - Yoshua Bengio（蒙特利尔大学）
	* [Deep Learning Session 2](https://www.youtube.com/watch?v=Fl-W7_z3w3o) - Joshua Bengio（蒙特利尔大学）
	* [Deep Learning Session 3](https://www.youtube.com/watch?v=_cohR7LAgWA) - Joshua Bengio（蒙特利尔大学）

## Software

#### Annotation tools
* [Comma Coloring](http://commacoloring.herokuapp.com/)
* [Annotorious](https://annotorious.github.io/)
* [LabelME](http://labelme.csail.mit.edu/Release3.0/)
* [gtmaker](https://github.com/sanko-shoko/gtmaker)

#### External Resource Links
 * [Computer Vision Resources](https://sites.google.com/site/jbhuang0604/resources/vision) - Jia-Bin Huang (UIUC)
 * [Computer Vision Algorithm Implementations](http://www.cvpapers.com/rr.html) - 简历论文
 * [Source Code Collection for Reproducible Research](http://www.csee.wvu.edu/~xinl/reproducible_research.html) - Xin Li（西弗吉尼亚大学）
 * [CMU Computer Vision Page](http://www.cs.cmu.edu/afs/cs/project/cil/ftp/html/v-source.html)

#### General Purpose Computer Vision Library
* [Open CV](http://opencv.org/)
* [mexopencv](http://kyamagu.github.io/mexopencv/)
* [SimpleCV](http://simplecv.org/)
* [Open source Python module for computer vision](https://github.com/jesolem/PCV)
* [ccv: A Modern Computer Vision Library](https://github.com/liuliu/ccv)
* [VLFeat](http://www.vlfeat.org/)
* [Matlab Computer Vision System Toolbox](http://www.mathworks.com/products/computer-vision/)
* [Piotr's Computer Vision Matlab Toolbox](http://vision.ucsd.edu/~pdollar/toolbox/doc/index.html)
* [PCL: Point Cloud Library](http://pointclouds.org/)
* [ImageUtilities](https://gitorious.org/imageutilities)

#### Multiple-view Computer Vision
* [MATLAB Functions for Multiple View Geometry](http://www.robots.ox.ac.uk/~vgg/hzbook/code/)
* [Peter Kovesi's Matlab Functions for Computer Vision and Image Analysis](http://staffhome.ecm.uwa.edu.au/~00011811/Research/MatlabFns/index.html)
* [OpenGV ](http://laurentkneip.github.io/opengv/) - 几何计算机视觉算法
* [MinimalSolvers](http://cmp.felk.cvut.cz/mini/) - 最小的问题解决者
* [Multi-View Environment](http://www.gcc.tu-darmstadt.de/home/proj/mve/)
* [Visual SFM](http://ccwu.me/vsfm/)
* [Bundler SFM](http://www.cs.cornell.edu/~snavely/bundler/)
* [openMVG: open Multiple View Geometry](http://imagine.enpc.fr/~moulonp/openMVG/)  - 多视图几何； 来自 Motion 库和软件的结构
* [Patch-based Multi-view Stereo V2](http://www.di.ens.fr/pmvs/)
* [Clustering Views for Multi-view Stereo](http://www.di.ens.fr/cmvs/)
* [Floating Scale Surface Reconstruction](http://www.gris.informatik.tu-darmstadt.de/projects/floating-scale-surface-recon/)
* [Large-Scale Texturing of 3D Reconstructions](http://www.gcc.tu-darmstadt.de/home/proj/texrecon/)
* [Awesome 3D reconstruction list](https://github.com/openMVG/awesome_3DReconstruction_list)


#### Feature Detection and Extraction
* [VLFeat](http://www.vlfeat.org/)
* [SIFT](http://www.cs.ubc.ca/~lowe/keypoints/)
  * David G. Lowe，“来自尺度不变关键点的独特图像特征”，国际计算机视觉杂志，60， 2 (2004)，第 91-110 页.
* [SIFT++](http://www.robots.ox.ac.uk/~vedaldi/code/siftpp.html)
* [BRISK](http://www.asl.ethz.ch/people/lestefan/personal/BRISK)
  * Stefan Leutenegger、Margarita Chli 和 Roland Siegwart，“BRISK：二进制稳健不变可扩展关键点”，ICCV 2011
* [SURF](http://www.vision.ee.ethz.ch/~surf/)
   * Herbert Bay、Andreas Ess、Tinne Tuytelaars、Luc Van Gool，“SURF：加速稳健特征”，计算机视觉和图像理解 (CVIU)，卷.  110，第 3 期，第 346--359 页，2008 年
* [FREAK](http://www.ivpe.com/freak.htm)
  * A. Alahi、R. Ortiz 和 P. Vandergheynst，“FREAK：快速视网膜关键点”，CVPR 2012
* [AKAZE](http://www.robesafe.com/personal/pablo.alcantarilla/kaze.html)
  * Paul F. Sewer、Adrien Bartoli 和 Andrew J. Davison，“KAZE 功能”，ECCV
* [Local Binary Patterns](https://github.com/nourani/LBP)

#### High Dynamic Range Imaging
* [HDR_Toolbox](https://github.com/banterle/HDR_Toolbox)

#### Semantic Segmentation
* [List of Semantic Segmentation algorithms](http://www.it-caesar.com/list-of-contemporary-semantic-segmentation-datasets/)

#### Low-level Vision

###### Stereo Vision
 * [Middlebury Stereo Vision](http://vision.middlebury.edu/stereo/)
 * [The KITTI Vision Benchmark Suite](http://www.cvlibs.net/datasets/kitti/eval_stereo_flow.php?benchmark=stero)
 * [LIBELAS: Library for Efficient Large-scale Stereo Matching](http://www.cvlibs.net/software/libelas/)
 * [Ground Truth Stixel Dataset](http://www.6d-vision.com/ground-truth-stixel-dataset)

###### Optical Flow
 * [Middlebury Optical Flow Evaluation](http://vision.middlebury.edu/flow/)
 * [MPI-Sintel Optical Flow Dataset and Evaluation](http://sintel.is.tue.mpg.de/)
 * [The KITTI Vision Benchmark Suite](http://www.cvlibs.net/datasets/kitti/eval_stereo_flow.php?benchmark=flow)
 * [HCI Challenge](http://hci.iwr.uni-heidelberg.de/Benchmarks/document/Challenging_Data_for_Stereo_and_Optical_Flow/)
 * [Coarse2Fine Optical Flow](http://people.csail.mit.edu/celiu/OpticalFlow/) - Ce Liu (MIT)
 * [Secrets of Optical Flow Estimation and Their Principles](http://cs.brown.edu/~dqsun/code/cvpr10_flow_code.zip)
 * [C++/MatLab Optical Flow by C. Liu (based on Brox et al. and Bruhn et al.)](http://people.csail.mit.edu/celiu/OpticalFlow/)
 * [Parallel Robust Optical Flow by Sánchez Pérez et al.](http://www.ctim.es/research_works/parallel_robust_optical_flow/)

###### Image Denoising
BM3D, KSVD,

###### Super-resolution
 * [Multi-frame image super-resolution](http://www.robots.ox.ac.uk/~vgg/software/SR/)
    * Pickup, LC Machine Learning in Multi-frame Image Super-resolution, 博士论文 2008
 * [Markov Random Fields for Super-Resolution](http://people.csail.mit.edu/billf/project%20pages/sresCode/Markov%20Random%20Fields%20for%20Super-Resolution.html)
     * W. T Freeman 和 C. Liu. 用于超分辨率和纹理合成的马尔可夫随机场. 摘自 A. Blake、P. Kohli 和 C. Rother 编着的《用于视觉和图像处理的马尔可夫随机场的进展》，第 10 章.麻省理工学院出版社，2011 年
 * [Sparse regression and natural image prior](https://people.mpi-inf.mpg.de/~kkim/supres/supres.htm)
     * KI Kim 和 Y. Kwon，“使用稀疏回归和自然图像先验的单图像超分辨率”，IEEE Trans. 模式分析与机器智能，卷.  32，没有.  6，第 1127-1133 页，2010 年.
 * [Single-Image Super Resolution via a Statistical Model](http://www.cs.technion.ac.il/~elad/Various/SingleImageSR_TIP14_Box.zip)
     * T. Peleg 和 M. Elad，基于单幅图​​像超分辨率稀疏表示的统计预测模型，IEEE 图像处理汇刊，卷.  23，第 6 期，第 2569-2582 页，2014 年 6 月
 * [Sparse Coding for Super-Resolution](http://www.cs.technion.ac.il/~elad/Various/Single_Image_SR.zip)
    * R. Zeyde、M. Elad 和 M. Protter On Single Image Scale-Up using Sparse-Representations, Curves &amp; Surfaces，法国阿维尼翁，2010 年 6 月 24-30 日（也出现在 Lecture-Notes-on-Computer-科学 - LNCS）.
 * [Patch-wise Sparse Recovery](http://www.ifp.illinois.edu/~jyang29/ScSR.htm)
     * Jianchao Yang、John Wright、Thomas Huang 和 Yi Ma. 通过稀疏表示的图像超分辨率.  IEEE 图像处理交易 (TIP)，卷.  19，2010 年第 11 期.
 * [Neighbor embedding](http://www.jdl.ac.cn/user/hchang/doc/code.rar)
     * H. Chang、DY Yeung、Y. Xiong. 通过邻居嵌入的超分辨率.  IEEE 计算机协会计算机视觉和模式识别 (CVPR) 会议论文集，第 1 卷，第 275-282 页，美国华盛顿特区，2004 年 6 月 27 日至 7 月 2 日.
 * [Deformable Patches](https://sites.google.com/site/yuzhushome/single-image-super-resolution-using-deformable-patches)
    *  Yu Zhu, Yanning Zhang and Alan Yuille, Single Image Super-resolution using Deformable Patches, CVPR 2014
 * [SRCNN](http://mmlab.ie.cuhk.edu.hk/projects/SRCNN.html)
    * Chao Dong、Chen Change Loy、Kaiming He、Xiaoou Tang，学习用于图像超分辨率的深度卷积网络，ECCV 2014
 * [A+: Adjusted Anchored Neighborhood Regression](http://www.vision.ee.ethz.ch/~timofter/ACCV2014_ID820_SUPPLEMENTARY/index.html)
     * R. Timofte、V. De Smet 和 L. Van Gool.  A+：调整后的锚定邻域回归以实现快速超分辨率，ACCV 2014
 * [Transformed Self-Exemplars](https://sites.google.com/site/jbhuang0604/publications/struct_sr)
    * Jia-Bin Huang、Abhishek Singh 和 Narendra Ahuja，使用转换后的自样本的单图像超分辨率，IEEE 计算机视觉和模式识别会议，2015 年

###### Image Deblurring

非盲解卷积
 * [Spatially variant non-blind deconvolution](http://homes.cs.washington.edu/~shanqi/work/spvdeconv/)
 * [Handling Outliers in Non-blind Image Deconvolution](http://cg.postech.ac.kr/research/deconv_outliers/)
 * [Hyper-Laplacian Priors](http://cs.nyu.edu/~dilip/research/fast-deconvolution/)
 * [From Learning Models of Natural Image Patches to Whole Image Restoration](http://people.csail.mit.edu/danielzoran/epllcode.zip)
 * [Deep Convolutional Neural Network for Image Deconvolution](http://lxu.me/projects/dcnn/)
 * [Neural Deconvolution](http://webdav.is.mpg.de/pixel/neural_deconvolution/)

盲解卷积
 * [Removing Camera Shake From A Single Photograph](http://www.cs.nyu.edu/~fergus/research/deblur.html)
 * [High-quality motion deblurring from a single image](http://www.cse.cuhk.edu.hk/leojia/projects/motion_deblurring/)
 * [Two-Phase Kernel Estimation for Robust Motion Deblurring](http://www.cse.cuhk.edu.hk/leojia/projects/robust_deblur/)
 * [Blur kernel estimation using the radon transform](http://people.csail.mit.edu/taegsang/Documents/RadonDeblurringCode.zip)
 * [Fast motion deblurring](http://cg.postech.ac.kr/research/fast_motion_deblurring/)
 * [Blind Deconvolution Using a Normalized Sparsity Measure](http://cs.nyu.edu//~dilip/research/blind-deconvolution/)
 * [Blur-kernel estimation from spectral irregularities](http://www.cs.huji.ac.il/~raananf/projects/deblur/)
 * [Efficient marginal likelihood optimization in blind deconvolution](http://www.wisdom.weizmann.ac.il/~levina/papers/LevinEtalCVPR2011Code.zip)
 * [Unnatural L0 Sparse Representation for Natural Image Deblurring](http://www.cse.cuhk.edu.hk/leojia/projects/l0deblur/)
 * [Edge-based Blur Kernel Estimation Using Patch Priors](http://cs.brown.edu/~lbsun/deblur2013/deblur2013iccp.html)
 * [Blind Deblurring Using Internal Patch Recurrence](http://www.wisdom.weizmann.ac.il/~vision/BlindDeblur.html)

非均匀去模糊
 * [Non-uniform Deblurring for Shaken Images](http://www.di.ens.fr/willow/research/deblurring/)
 * [Single Image Deblurring Using Motion Density Functions](http://grail.cs.washington.edu/projects/mdf_deblurring/)
 * [Image Deblurring using Inertial Measurement Sensors](http://research.microsoft.com/en-us/um/redmond/groups/ivm/imudeblurring/)
 * [Fast Removal of Non-uniform Camera Shake](http://webdav.is.mpg.de/pixel/fast_removal_of_camera_shake/)


###### Image Completion
 * [GIMP Resynthesizer](http://registry.gimp.org/node/27986)
 * [Priority BP](http://lafarren.com/image-completer/)
 * [ImageMelding](http://www.ece.ucsb.edu/~psen/melding)
 * [PlanarStructureCompletion](https://sites.google.com/site/jbhuang0604/publications/struct_completion)

###### Image Retargeting
 * [RetargetMe](http://people.csail.mit.edu/mrub/retargetme/)

###### Alpha Matting
 * [Alpha Matting Evaluation](http://www.alphamatting.com/)
 * [Closed-form image matting](http://people.csail.mit.edu/alevin/matting.tar.gz)
 * [Spectral Matting](http://www.vision.huji.ac.il/SpectralMatting/)
 * [Learning-based Matting](http://www.mathworks.com/matlabcentral/fileexchange/31412-learning-based-digital-matting)
 * [Improving Image Matting using Comprehensive Sampling Sets](http://www.alphamatting.com/ImprovingMattingComprehensiveSamplingSets_CVPR2013.zip)

###### Image Pyramid
* [The Steerable Pyramid](http://www.cns.nyu.edu/~eero/steerpyr/)
* [CurveLab](http://www.curvelet.org/)

###### Edge-preserving image processing
 * [Fast Bilateral Filter](http://people.csail.mit.edu/sparis/bf/)
 * [O(1) Bilateral Filter](http://www.cs.cityu.edu.hk/~qiyang/publications/code/qx.cvpr09.ctbf.zip)
 * [Recursive Bilateral Filtering](http://www.cs.cityu.edu.hk/~qiyang/publications/eccv-12/)
 * [Rolling Guidance Filter](http://www.cse.cuhk.edu.hk/leojia/projects/rollguidance/)
 * [Relative Total Variation](http://www.cse.cuhk.edu.hk/leojia/projects/texturesep/index.html)
 * [L0 Gradient Optimization](http://www.cse.cuhk.edu.hk/leojia/projects/L0smoothing/index.html)
 * [Domain Transform](http://www.inf.ufrgs.br/~eslgastal/DomainTransform/)
 * [Adaptive Manifold](http://inf.ufrgs.br/~eslgastal/AdaptiveManifolds/)
 * [Guided image filtering](http://research.microsoft.com/en-us/um/people/kahe/eccv10/)

#### Intrinsic Images

* [Recovering Intrinsic Images with a global Sparsity Prior on Reflectance](http://people.tuebingen.mpg.de/mkiefel/projects/intrinsic/)
* [Intrinsic Images by Clustering](http://giga.cps.unizar.es/~elenag/projects/EGSR2012_intrinsic/)

#### Contour Detection and Image Segmentation
 * [Mean Shift Segmentation](http://coewww.rutgers.edu/riul/research/code/EDISON/)
 * [Graph-based Segmentation](http://cs.brown.edu/~pff/segment/)
 * [Normalized Cut](http://www.cis.upenn.edu/~jshi/software/)
 * [Grab Cut](http://grabcut.weebly.com/background--algorithm.html)
 * [Contour Detection and Image Segmentation](http://www.eecs.berkeley.edu/Research/Projects/CS/vision/grouping/resources.html)
 * [Structured Edge Detection](http://research.microsoft.com/en-us/downloads/389109f6-b4e8-404c-84bf-239f7cbf4e3d/)
 * [Pointwise Mutual Information](http://web.mit.edu/phillipi/pmi-boundaries/)
 * [SLIC Super-pixel](http://ivrl.epfl.ch/research/superpixels)
 * [QuickShift](http://www.vlfeat.org/overview/quickshift.html)
 * [TurboPixels](http://www.cs.toronto.edu/~babalex/research.html)
 * [Entropy Rate Superpixel](http://mingyuliu.net/)
 * [Contour Relaxed Superpixels](http://www.vsi.cs.uni-frankfurt.de/research/current-projects/research/superpixel-segmentation/)
 * [SEEDS](http://www.mvdblive.org/seeds/)
 * [SEEDS Revised](https://github.com/davidstutz/seeds-revised)
 * [Multiscale Combinatorial Grouping](http://www.eecs.berkeley.edu/Research/Projects/CS/vision/grouping/mcg/)
 * [Fast Edge Detection Using Structured Forests](https://github.com/pdollar/edges)

#### Interactive Image Segmentation
 * [Random Walker](http://cns.bu.edu/~lgrady/software.html)
 * [Geodesic Segmentation](http://www.tc.umn.edu/~baixx015/)
 * [Lazy Snapping](http://research.microsoft.com/apps/pubs/default.aspx?id=69040)
 * [Power Watershed](http://powerwatershed.sourceforge.net/)
 * [Geodesic Graph Cut](http://www.adobe.com/technology/people/san-jose/brian-price.html)
 * [Segmentation by Transduction](http://www.cs.cmu.edu/~olivierd/)

#### Video Segmentation
 * [Video Segmentation with Superpixels](http://www.mpi-inf.mpg.de/departments/computer-vision-and-multimodal-computing/research/image-and-video-segmentation/video-segmentation-with-superpixels/)
 * [Efficient hierarchical graph-based video segmentation](http://www.cc.gatech.edu/cpl/projects/videosegmentation/)
 * [Object segmentation in video](http://lmb.informatik.uni-freiburg.de/Publications/2011/OB11/)
 * [Streaming hierarchical video segmentation](http://www.cse.buffalo.edu/~jcorso/r/supervoxels/)

#### Camera calibration
 * [Camera Calibration Toolbox for Matlab](http://www.vision.caltech.edu/bouguetj/calib_doc/)
 * [Camera calibration With OpenCV](http://docs.opencv.org/trunk/doc/tutorials/calib3d/camera_calibration/camera_calibration.html#)
 * [Multiple Camera Calibration Toolbox](https://sites.google.com/site/prclibo/toolbox)

#### Simultaneous localization and mapping

###### SLAM community:
 * [openSLAM](https://www.openslam.org/)
 * [Kitti Odometry: benchmark for outdoor visual odometry (codes may be available)](http://www.cvlibs.net/datasets/kitti/eval_odometry.php)

###### Tracking/Odometry:
 * [LIBVISO2: C++ Library for Visual Odometry 2](http://www.cvlibs.net/software/libviso/)
 * [PTAM: Parallel tracking and mapping](http://www.robots.ox.ac.uk/~gk/PTAM/)
 * [KFusion: Implementation of KinectFusion](https://github.com/GerhardR/kfusion)
 * [kinfu_remake: Lightweight, reworked and optimized version of Kinfu.](https://github.com/Nerei/kinfu_remake)
 * [LVR-KinFu: kinfu_remake based Large Scale KinectFusion with online reconstruction](http://las-vegas.uni-osnabrueck.de/related-projects/lvr-kinfu/)
 * [InfiniTAM: Implementation of multi-platform large-scale depth tracking and fusion](http://www.robots.ox.ac.uk/~victor/infinitam/)
 * [VoxelHashing: Large-scale KinectFusion](https://github.com/nachtmar/VoxelHashing)
 * [SLAMBench: Multiple-implementation of KinectFusion](http://apt.cs.manchester.ac.uk/projects/PAMELA/tools/SLAMBench/)
 * [SVO: Semi-direct visual odometry](https://github.com/uzh-rpg/rpg_svo)
 * [DVO: dense visual odometry](https://github.com/tum-vision/dvo_slam)
 * [FOVIS: RGB-D visual odometry](https://code.google.com/p/fovis/)

###### Graph Optimization:
 * [GTSAM: General smoothing and mapping library for Robotics and SFM](https://collab.cc.gatech.edu/borg/gtsam?destination=node%2F299) ——佐治亚理工学院
 * [G2O: General framework for graph optomization](https://github.com/RainerKuemmerle/g2o)

###### Loop Closure:
 * [FabMap: appearance-based loop closure system](http://www.robots.ox.ac.uk/~mjc/Software.htm) - 也可用于 [OpenCV2.4.11](http://docs.opencv.org/2.4/modules/contrib/doc/openfabmap.html)
 * [DBoW2: binary bag-of-words loop detection system](http://webdiis.unizar.es/~dorian/index.php?p=32)

###### Localization & Mapping:
 * [RatSLAM](https://code.google.com/p/ratslam/)
 * [LSD-SLAM](https://github.com/tum-vision/lsd_slam)
 * [ORB-SLAM](https://github.com/raulmur/ORB_SLAM)

#### Single-view Spatial Understanding
 * [Geometric Context](http://web.engr.illinois.edu/~dhoiem/projects/software.html) - 德里克·霍伊姆 (CMU)
 * [Recovering Spatial Layout](http://web.engr.illinois.edu/~dhoiem/software/counter.php?Down=varsha_spatialLayout.zip) 瓦尔沙赫道 (UIUC)
 * [Geometric Reasoning](http://www.cs.cmu.edu/~./dclee/code/index.html) - 大卫·李 (CMU)
 * [RGBD2Full3D](https://github.com/arron2003/rgbd2full3d) - Ruiqi Guo (UIUC)

#### Object Detection
 * [INRIA Object Detection and Localization Toolkit](http://pascal.inrialpes.fr/soft/olt/)
 * [Discriminatively trained deformable part models](http://www.cs.berkeley.edu/~rbg/latent/)
 * [VOC-DPM](https://github.com/rbgirshick/voc-dpm)
 * [Histograms of Sparse Codes for Object Detection](http://www.ics.uci.edu/~dramanan/software/sparse/)
 * [R-CNN: Regions with Convolutional Neural Network Features](https://github.com/rbgirshick/rcnn)
 * [SPP-Net](https://github.com/ShaoqingRen/SPP_net)
 * [BING: Objectness Estimation](http://mmcheng.net/bing/comment-page-9/)
 * [Edge Boxes](https://github.com/pdollar/edges)
 * [ReInspect](https://github.com/Russell91/ReInspect)

#### Nearest Neighbor Search

###### General purpose nearest neighbor search
 * [ANN: A Library for Approximate Nearest Neighbor Searching](http://www.cs.umd.edu/~mount/ANN/)
 * [FLANN - Fast Library for Approximate Nearest Neighbors](http://www.cs.ubc.ca/research/flann/)
 * [Fast k nearest neighbor search using GPU](http://vincentfpgarcia.github.io/kNN-CUDA/)

###### Nearest Neighbor Field Estimation
 * [PatchMatch](http://gfx.cs.princeton.edu/gfx/pubs/Barnes_2009_PAR/index.php)
 * [Generalized PatchMatch](http://gfx.cs.princeton.edu/pubs/Barnes_2010_TGP/index.php)
 * [Coherency Sensitive Hashing](http://www.eng.tau.ac.il/~simonk/CSH/)
 * [PMBP: PatchMatch Belief Propagation](https://github.com/fbesse/pmbp)
 * [TreeCANN](http://www.eng.tau.ac.il/~avidan/papers/TreeCANN_code_20121022.rar)

#### Visual Tracking
* [Visual Tracker Benchmark](https://sites.google.com/site/trackerbenchmark/benchmarks/v10)
* [Visual Tracking Challenge](http://www.votchallenge.net/)
* [Kanade-Lucas-Tomasi Feature Tracker](http://www.ces.clemson.edu/~stb/klt/)
* [Extended Lucas-Kanade Tracking](http://www.eng.tau.ac.il/~oron/ELK/ELK.html)
* [Online-boosting Tracking](http://www.vision.ee.ethz.ch/boostingTrackers/)
* [Spatio-Temporal Context Learning](http://www4.comp.polyu.edu.hk/~cslzhang/STC/STC.htm)
* [Locality Sensitive Histograms](http://www.shengfenghe.com/visual-tracking-via-locality-sensitive-histograms.html)
* [TLD: Tracking - Learning - Detection](http://personal.ee.surrey.ac.uk/Personal/Z.Kalal/tld.html)
* [CMT: Clustering of Static-Adaptive Correspondences for Deformable Object Tracking](http://www.gnebehay.com/cmt/)
* [Kernelized Correlation Filters](http://home.isr.uc.pt/~henriques/circulant/)
* [Accurate Scale Estimation for Robust Visual Tracking](http://www.cvl.isy.liu.se/en/research/objrec/visualtracking/scalvistrack/index.html)
* [Multiple Experts using Entropy Minimization](http://cs-people.bu.edu/jmzhang/MEEM/MEEM.html)
* [TGPR](http://www.dabi.temple.edu/~hbling/code/TGPR.htm)
* [CF2: Hierarchical Convolutional Features for Visual Tracking](https://sites.google.com/site/jbhuang0604/publications/cf2)
* [Modular Tracking Framework](http://webdocs.cs.ualberta.ca/~vis/mtf/index.html)

#### Saliency Detection

#### Attributes

#### Action Reconition

#### Egocentric cameras

#### Human-in-the-loop systems

#### Image Captioning
 * [NeuralTalk](https://github.com/karpathy/neuraltalk﻿) -

#### Optimization
 * [Ceres Solver](http://ceres-solver.org/) - 非线性最小二乘问题和无约束优化求解器
 * [NLopt](http://ab-initio.mit.edu/wiki/index.php/NLopt)- 非线性最小二乘问题和无约束优化求解器
 * [OpenGM](http://hci.iwr.uni-heidelberg.de/opengm2/) - 基于因子图的离散优化和推理求解器
 * [GTSAM](https://collab.cc.gatech.edu/borg/gtsam/) - 基于因子图的租赁平方优化求解器

#### Deep Learning
 * [Awesome Deep Vision](https://github.com/kjw0612/awesome-deep-vision)

#### Machine Learning
 * [Awesome Machine Learning](https://github.com/josephmisiti/awesome-machine-learning)
 * [Bob: a free signal processing and machine learning toolbox for researchers](http://idiap.github.io/bob/)
 * [LIBSVM -- A Library for Support Vector Machines](https://www.csie.ntu.edu.tw/~cjlin/libsvm/)

## Datasets

#### External Dataset Link Collection
 * [CV Datasets on the web](http://www.cvpapers.com/datasets.html) - 简历论文
 * [Are we there yet?](http://rodrigob.github.io/are_we_there_yet/build/) - 哪篇论文在标准数据集 X 上提供了最好的结果？
 * [Computer Vision Dataset on the web](http://www.cvpapers.com/datasets.html)
 * [Yet Another Computer Vision Index To Datasets](http://riemenschneider.hayko.at/vision/dataset/)
 * [ComputerVisionOnline Datasets](http://www.computervisiononline.com/datasets)
 * [CVOnline Dataset](http://homepages.inf.ed.ac.uk/cgi/rbf/CVONLINE/entries.pl?TAG363)
 * [CV datasets](http://clickdamage.com/sourcecode/cv_datasets.php)
 * [visionbib](http://datasets.visionbib.com/info-index.html)
 * [VisualData](http://www.visualdata.io/)

#### Low-level Vision

###### Stereo Vision
 * [Middlebury Stereo Vision](http://vision.middlebury.edu/stereo/)
 * [The KITTI Vision Benchmark Suite](http://www.cvlibs.net/datasets/kitti/eval_stereo_flow.php?benchmark=stero)
 * [LIBELAS: Library for Efficient Large-scale Stereo Matching](http://www.cvlibs.net/software/libelas/)
 * [Ground Truth Stixel Dataset](http://www.6d-vision.com/ground-truth-stixel-dataset)

###### Optical Flow
 * [Middlebury Optical Flow Evaluation](http://vision.middlebury.edu/flow/)
 * [MPI-Sintel Optical Flow Dataset and Evaluation](http://sintel.is.tue.mpg.de/)
 * [The KITTI Vision Benchmark Suite](http://www.cvlibs.net/datasets/kitti/eval_stereo_flow.php?benchmark=flow)
 * [HCI Challenge](http://hci.iwr.uni-heidelberg.de/Benchmarks/document/Challenging_Data_for_Stereo_and_Optical_Flow/)

###### Video Object Segmentation
 * [DAVIS: Densely Annotated VIdeo Segmentation](http://davischallenge.org/)
 * [SegTrack v2](http://web.engr.oregonstate.edu/~lif/SegTrack2/dataset.html)


###### Change Detection
 * [Labeled and Annotated Sequences for Integral Evaluation of SegmenTation Algorithms](http://www.gti.ssr.upm.es/data/LASIESTA)
 * [ChangeDetection.net](http://www.changedetection.net/)

###### Image Super-resolutions
 * [Single-Image Super-Resolution: A Benchmark](https://eng.ucmerced.edu/people/cyang35/ECCV14/ECCV14.html)

#### Intrinsic Images
 * [Ground-truth dataset and baseline evaluations for intrinsic image algorithms](http://www.mit.edu/~kimo/publications/intrinsic/)
 * [Intrinsic Images in the Wild](http://opensurfaces.cs.cornell.edu/intrinsic/)
 * [Intrinsic Image Evaluation on Synthetic Complex Scenes](http://www.cic.uab.cat/Datasets/synthetic_intrinsic_image_dataset/)

#### Material Recognition
 * [OpenSurface](http://opensurfaces.cs.cornell.edu/)
 * [Flickr Material Database](http://people.csail.mit.edu/celiu/CVPR2010/)
 * [Materials in Context Dataset](http://opensurfaces.cs.cornell.edu/publications/minc/)

#### Multi-view Reconsturction
* [Multi-View Stereo Reconstruction](http://vision.middlebury.edu/mview/)

#### Saliency Detection

#### Visual Tracking
 * [Visual Tracker Benchmark](https://sites.google.com/site/trackerbenchmark/benchmarks/v10)
 * [Visual Tracker Benchmark v1.1](https://sites.google.com/site/benchmarkpami/)
 * [VOT Challenge](http://www.votchallenge.net/)
 * [Princeton Tracking Benchmark](http://tracking.cs.princeton.edu/)
 * [Tracking Manipulation Tasks (TMT)](http://webdocs.cs.ualberta.ca/~vis/trackDB/)

#### Visual Surveillance
 * [VIRAT](http://www.viratdata.org/)
 * [CAM2](https://cam2.ecn.purdue.edu/)

#### Saliency Detection

#### Change detection
 * [ChangeDetection.net](http://changedetection.net/)

#### Visual Recognition

###### Image Classification
 * [The PASCAL Visual Object Classes](http://pascallin.ecs.soton.ac.uk/challenges/VOC/)
 * [ImageNet Large Scale Visual Recognition Challenge](http://www.image-net.org/challenges/LSVRC/2014/)

###### Self-supervised Learning
* [PASS: An An ImageNet replacement for self-supervised pretraining without humans](https://github.com/yukimasano/PASS)

###### Scene Recognition
 * [SUN Database](http://groups.csail.mit.edu/vision/SUN/)
 * [Place Dataset](http://places.csail.mit.edu/)

###### Object Detection
 * [The PASCAL Visual Object Classes](http://pascallin.ecs.soton.ac.uk/challenges/VOC/)
 * [ImageNet Object Detection Challenge](http://www.image-net.org/challenges/LSVRC/2014/)
 * [Microsoft COCO](http://mscoco.org/)

###### Semantic labeling
 * [Stanford background dataset](http://dags.stanford.edu/projects/scenedataset.html)
 * [CamVid](http://mi.eng.cam.ac.uk/research/projects/VideoRec/CamVid/)
 * [Barcelona Dataset](http://www.cs.unc.edu/~jtighe/Papers/ECCV10/)
 * [SIFT Flow Dataset](http://www.cs.unc.edu/~jtighe/Papers/ECCV10/siftflow/SiftFlowDataset.zip)

###### Multi-view Object Detection
 * [3D Object Dataset](http://cvgl.stanford.edu/resources.html)
 * [EPFL Car Dataset](http://cvlab.epfl.ch/data/pose)
 * [KTTI Dection Dataset](http://www.cvlibs.net/datasets/kitti/eval_object.php)
 * [SUN 3D Dataset](http://sun3d.cs.princeton.edu/)
 * [PASCAL 3D+](http://cvgl.stanford.edu/projects/pascal3d.html)
 * [NYU Car Dataset](http://nyc3d.cs.cornell.edu/)

###### Fine-grained Visual Recognition
 * [Fine-grained Classification Challenge](https://sites.google.com/site/fgcomp2013/)
 * [Caltech-UCSD Birds 200](http://www.vision.caltech.edu/visipedia/CUB-200.html)

###### Pedestrian Detection
 * [Caltech Pedestrian Detection Benchmark](http://www.vision.caltech.edu/Image_Datasets/CaltechPedestrians/)
 * [ETHZ Pedestrian Detection](https://data.vision.ee.ethz.ch/cvl/aess/dataset/)

#### Action Recognition

###### Image-based

###### Video-based
 * [HOLLYWOOD2 Dataset](http://www.di.ens.fr/~laptev/actions/hollywood2/)
 * [UCF Sports Action Data Set](http://crcv.ucf.edu/data/UCF_Sports_Action.php)

###### Image Deblurring
 * [Sun dataset](http://cs.brown.edu/~lbsun/deblur2013/deblur2013iccp.html)
 * [Levin dataset](http://www.wisdom.weizmann.ac.il/~levina/papers/LevinEtalCVPR09Data.rar)

#### Image Captioning
 * [Flickr 8K](http://nlp.cs.illinois.edu/HockenmaierGroup/Framing_Image_Description/KCCA.html)
 * [Flickr 30K](http://shannon.cs.illinois.edu/DenotationGraph/)
 * [Microsoft COCO](http://mscoco.org/)

#### Scene Understanding
 # [SUN RGB-D](http://rgbd.cs.princeton.edu/) - RGB-D 场景理解基准套件
 # [NYU depth v2](http://cs.nyu.edu/~silberman/datasets/nyu_depth_v2.html) - RGBD 图像的室内分割和支持推理

#### Aerial images
 # [Aerial Image Segmentation](https://zenodo.org/record/1154821#.WmN9kHWnHIp) - 从在线地图学习航拍图像分割


## Resources for students

#### Resource link collection
 * [Resources for students](http://people.csail.mit.edu/fredo/student.html) - 弗雷多杜兰德（麻省理工学院）
 * [Advice for Graduate Students](http://www.dgp.toronto.edu/~hertzman/advice/) - 亚伦赫兹曼（Adobe Research）
 * [Graduate Skills Seminars](http://www.dgp.toronto.edu/~hertzman/courses/gradSkills/2010/) - Yashar Ganjali、Aaron Hertzmann（多伦多大学）
 * [Research Skills](http://research.microsoft.com/en-us/um/people/simonpj/papers/giving-a-talk/giving-a-talk.htm) - 西蒙·佩顿·琼斯（微软研究院）
 * [Resource collection](http://web.engr.illinois.edu/~taoxie/advice.htm) - Tao Xie (UIUC) and Yuan Xie (UCSB)

#### Writing
 * [Write Good Papers](http://people.csail.mit.edu/fredo/FredoGoodWriting.pdf) - 弗雷多杜兰德（麻省理工学院）
 * [Notes on writing](http://people.csail.mit.edu/fredo/PUBLI/writing.pdf) - 弗雷多杜兰德（麻省理工学院）
 * [How to Write a Bad Article](http://people.csail.mit.edu/fredo/FredoBadWriting.pdf) - 弗雷多杜兰德（麻省理工学院）
 * [How to write a good CVPR submission](http://billf.mit.edu/sites/default/files/documents/cvprPapers.pdf) - 威廉·弗里曼 (麻省理工学院)
 * [How to write a great research paper](https://www.youtube.com/watch?v=g3dkRsTqdDA) - 西蒙·佩顿·琼斯（微软研究院）
 * [How to write a SIGGRAPH paper](http://www.slideshare.net/jdily/how-to-write-a-siggraph-paper) - SIGGRAPH ASIA 2011课程
 * [Writing Research Papers](http://www.dgp.toronto.edu/~hertzman/advice/writing-technical-papers.pdf) - 亚伦赫兹曼（Adobe Research）
 * [How to Write a Paper for SIGGRAPH](http://www.computer.org/csdl/mags/cg/1987/12/mcg1987120062.pdf) ——吉姆·布林
 * [How to Get Your SIGGRAPH Paper Rejected](http://www.siggraph.org/sites/default/files/kajiya.pdf) - Jim Kajiya（微软研究院）
 * [How to write a SIGGRAPH paper](https://github.com/jbhuang0604/awesome-computer-vision/blob/master/www.liyiwei.org/courses/how-siga11/liyiwei.pptx) - Li-Yi Wei (The University of Hong Kong)
 * [How to Write a Great Paper](http://www-hagen.informatik.uni-kl.de/~bertram/talks/getpublished.pdf) - Martin Martin Hering Hering--Bertram（不来梅应用科学大学）
 * [How to have a paper get into SIGGRAPH?](http://www-ui.is.s.u-tokyo.ac.jp/~takeo/writings/siggraph.html) - Takeo Igarashi（东京大学）
 * [Good Writing](http://www.cs.cmu.edu/~pausch/Randy/Randy/raibert.htm) - Marc H. Raibert（波士顿动力公司）
 * [How to Write a Computer Vision Paper](http://web.engr.illinois.edu/~dhoiem/presentations/How%20to%20Write%20a%20Computer%20Vison%20Paper.ppt) - 德里克·霍伊姆 (UIUC)
 * [Common mistakes in technical writing](http://www.cs.dartmouth.edu/~wjarosz/writing.html) - Wojciech Jarosz（达特茅斯学院）


#### Presentation
 * [Giving a Research Talk](http://people.csail.mit.edu/fredo/TalkAdvice.pdf) - 弗雷多杜兰德（麻省理工学院）
 * [How to give a good talk](http://www.dgp.toronto.edu/~hertzman/courses/gradSkills/2010/GivingGoodTalks.pdf) - David Fleet（多伦多大学）和 Aaron Hertzmann（Adobe Research）
 * [Designing conference posters](http://colinpurrington.com/tips/poster-design) - 科林普林顿

#### Research
 * [How to do research](http://people.csail.mit.edu/billf/www/papers/doresearch.pdf) - 威廉·弗里曼 (麻省理工学院)
 * [You and Your Research](http://www.cs.virginia.edu/~robins/YouAndYourResearch.html) ——理查德·海明
 * [Warning Signs of Bogus Progress in Research in an Age of Rich Computation and Information](http://yima.csl.illinois.edu/psfile/bogus.pdf) - Yi Ma (UIUC)
 * [Seven Warning Signs of Bogus Science](http://www.quackwatch.com/01QuackeryRelatedTopics/signs.html) - 罗伯特·L·帕克
 * [Five Principles for Choosing Research Problems in Computer Graphics](https://www.youtube.com/watch?v=v2Qaf8t8I6c) - Thomas Funkhouser（康奈尔大学）
 * [How To Do Research In the MIT AI Lab](http://www.cs.indiana.edu/mit.research.how.to.html) -大卫查普曼（麻省理工学院）
 * [Recent Advances in Computer Vision](http://www.slideshare.net/antiw/recent-advances-in-computer-vision) - Ming-Hsuan Yang (UC Merced)
 * [How to Come Up with Research Ideas in Computer Vision?](http://www.slideshare.net/jbhuang/how-to-come-up-with-new-research-ideas-4005840) - Jia-Bin Huang (UIUC)
 * [How to Read Academic Papers](http://www.slideshare.net/jbhuang/how-to-read-academic-papers) - Jia-Bin Huang (UIUC)

#### Time Management
 * [Time Management](https://www.youtube.com/watch?v=oTugjssqOT0) - 兰迪·波许 (CMU)

## Blogs
 * [Learn OpenCV](http://www.learnopencv.com/) - 萨蒂亚马利克
 * [Tombone's Computer Vision Blog](http://www.computervisionblog.com/) - 托马斯·马利谢维奇
 * [Computer vision for dummies](http://www.visiondummy.com/) -Vincent Spruyt
 * [Andrej Karpathy blog](http://karpathy.github.io/) - 安德烈·卡帕西
 * [AI Shack](http://aishack.in/) - 乌特卡什·辛哈
 * [Computer Vision Talks](http://computer-vision-talks.com/) - Eugene Khvedchenya
 * [Computer Vision Basics with Python Keras and OpenCV](https://github.com/jrobchin/Computer-Vision-Basics-with-Python-Keras-and-OpenCV) - Jason Chin（西安大略大学）


## Links
* [The Computer Vision Industry](http://www.cs.ubc.ca/~lowe/vision.html) - 大卫·洛
* [German Computer Vision Research Groups & Companies](http://hci.iwr.uni-heidelberg.de/Links/German_Vision/)
* [awesome-deep-learning](https://github.com/ChristosChristofidis/awesome-deep-learning)
* [awesome-machine-learning](https://github.com/josephmisiti/awesome-machine-learning)
* [Cat Paper Collection](http://www.eecs.berkeley.edu/~junyanz/cat/cat_papers.html)
* [Computer Vision News](http://www.rsipvision.com/computer-vision-news/)
*
## Songs
* [The Fundamental Matrix Song](http://danielwedge.com/fmatrix/)
* [The RANSAC Song](http://danielwedge.com/ransac/)
* [Machine Learning A Cappella - Overfitting Thriller](https://www.youtube.com/watch?v=DQWI1kvmwRg)

## Licenses
License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Jia-Bin Huang](https://github.com/jbhuang0604/awesome-computer-vision/blob/master/www.jiabinhuang.com) 已放弃该作品的所有版权和相关或邻接权.
