<div class="github-widget" data-repo="watson/awesome-computer-history"></div>
## Awesome Computer History [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Build status](https://api.travis-ci.org/watson/awesome-computer-history.svg?branch=master)](https://travis-ci.org/watson/awesome-computer-history)

计算机历史视频、纪录片和相关民间传说的精选列表，由 [Thomas Watson](https://twitter.com/wa7son) . 灵感来自 [awesome list thing](https://github.com/sindresorhus/awesome).

[Pull Requests](https://github.com/watson/awesome-computer-history/edit/master/README.md) 受欢迎的.



## Videos

### Old recordings

- [United States Navy Training Media: Basic Mechanisms in Fire Control Computers](https://www.youtube.com/playlist?list=PLkPOzHopOIo7ii8LTjgwBT_XMTR7q54KX) (1953)
- [Timesharing: A Solution to Computer Bottlenecks](https://www.youtube.com/watch?v=Q07PhW5sCEk) (1963)
- [The Mother of All Demos](https://www.youtube.com/watch?v=yJDv-zdhzMY) (1968)
- [Xerox Parc - Office Alto Commercial](https://www.youtube.com/watch?v=M0zgj2p7Ww4) (1972)
- 计算机网络 - ARPANET (1972) - ARPANET 的开发者谈论他们的新网络：
  - [Part 1](https://www.youtube.com/watch?v=fVhwOaCwkb0)
  - [Part 2](https://www.youtube.com/watch?v=RmO4TxDCMjI)
- [A Computer Animated Hand](https://www.youtube.com/watch?v=Jjbax5HYHLQ) (1972) - 最早的电脑动画范例之一
- [The Computer Literacy Project](https://computer-literacy-project.pilots.bbcconnectedstudio.co.uk/) (1980-1989) - 在 1980 年代，BBC 在计算机扫盲项目中探索了计算世界（所有剧集）
- [KRON San Francisco: Primitive Internet report](https://www.youtube.com/watch?v=5WCTn4FljUQ) (1981) - KRON San Francisco 新闻片段，讲述早期家庭电脑用户如何在线阅读早报
- [The UNIX System: Making Computers More Productive](https://www.youtube.com/watch?v=tc4ROCJYbm0) (1982)
- [The UNIX System: Making Computers Easier to Use](https://www.youtube.com/watch?v=XvDZLjaCJuw) (1982)
- [The Computer Chronicles](https://www.youtube.com/channel/UCkJ6eQKpHZgsZBla4JgKj3A) (1983-2002) - 所有剧集[8.6/10](https://www.imdb.com/title/tt0421311/) . 一些值得注意的情节是：
  - [Simulator Software](https://www.youtube.com/watch?v=ZVZiureyV-s) (1983)
  - [Artificial Intelligence](https://www.youtube.com/watch?v=7Uz3HYfCIGc) (1985)
  - [The Internet](https://www.youtube.com/watch?v=U_o8gerare0) (1993)
- [We Are Apple](https://www.youtube.com/watch?v=nbJy0O4UFSM) (1984) - 1984 年 1 月 Macintosh 推出期间使用的公司歌曲
- [Thinking Allowed - Artificial Intelligence](https://www.youtube.com/watch?v=Ozipf13jRr4) (1989) - 采访 John McCarthy，Lisp 的创造者和人工智能学科的创始人之一
- [Erlang: The Movie](https://www.youtube.com/watch?v=xrIjfIjssLE) (1990)
- [Net Cafe](https://archive.org/details/netcafe) (1996-2002) - 所有剧集[?/10](https://www.imdb.com/title/tt1057240/) . 一些值得注意的情节是：
  - [Hackers](https://archive.org/details/nc101_hackers) (1996) - 着眼于黑客文化及其对互联网早期发展的影响
  - [Politics on the Web](https://archive.org/details/nc103_cyberpolitics) (1996) - 全球通信研究所、赛博朋克和无政府主义者出版社
- [Steve Jobs: The Crazy Ones](https://www.youtube.com/watch?v=VCz_SiPD_X0) (1997) - 史蒂夫·乔布斯 (Steve Jobs) 在 Apple 内部会议上谈论 The Crazy Ones 营销活动

### Documentaries

- [Hackers: Wizards of the Electronic Age](https://www.youtube.com/watch?v=cVCLowi4v7w) (1984) - 关于 1984 年黑客大会的纪录片[7.6/10](https://www.imdb.com/title/tt1191116/)</sup>
- [The KGB, the Computer, and Me](https://www.youtube.com/watch?v=EcKxaq1FTac) (1990) - With computer scientist Clifford Stoll <sup>[8.0/10](https://www.imdb.com/title/tt0308449/)</sup>
- [Triumph of the Nerds: The Rise of Accidental Empires](https://en.wikipedia.org/wiki/Triumph_of_the_Nerds) (1996) - 个人电脑的历史[8.5/10](https://www.imdb.com/title/tt0115398/)</sup>
- [The Internet: Behind the Web](https://www.youtube.com/watch?v=M9ebkjWU6Z4) (2000) - 关于从 1950-60 年代到 21 世纪互联网发展的纪录片.
- [Code Rush](https://www.youtube.com/watch?v=4Q7FTjhvZ7Y) (2000) - Netscape 的故事和 Mozilla 的诞生[7.3/10](https://www.imdb.com/title/tt0499004/)</sup>
- [The Code](https://www.youtube.com/watch?v=XMm0HsmOTFI) (2001) - Linux 和 FOSS 的历史[7.5/10](https://www.imdb.com/title/tt0315417/)</sup>
- [Revolution OS](https://www.youtube.com/watch?v=jw8K460vx1c) (2001) - GNU/linux 和开源运动的故事[7.3/10](https://www.imdb.com/title/tt0308808/)</sup>
- [The Secret History Of Hacking](https://www.youtube.com/watch?v=PUf1d-GuK0Q) (2001) - 早期黑客的历史[7.6/10](https://www.imdb.com/title/tt2335921/)</sup>
- [BBS The Documentary](https://www.youtube.com/playlist?list=PLgE-9Sxs2IBVgJkY-1ZMj0tIFxsJ-vOkv) (2005) - 公告板系统的历史[8.5/10](https://www.imdb.com/title/tt0460402/)</sup>
- [The Codebreakers](https://www.youtube.com/watch?v=Zc-hlV2xbSg) (2006) - 关于贫穷国家如何使用免费和开源软件 (FOSS) 进行发展的纪录片.
- [Hackers Are People Too](https://www.youtube.com/watch?v=7jciIsuEZWM) (2008) - 关于什么是黑客的纪录片[6.0/10](https://www.imdb.com/title/tt1279942/)</sup>
- [Download: The True Story of the Internet](https://en.wikipedia.org/wiki/Download_The_True_Story_of_the_Internet) (2008) - 一部关于互联网历史的纪录片电视连续剧[7.8/10](https://www.imdb.com/title/tt1684716/)</sup>
  - [Part 1: Browser Wars](https://www.youtube.com/watch?v=VANORrzKX50) – 网景的兴衰及其与微软的较量
  - [Part 2: Search](https://www.youtube.com/watch?v=Jjbh9FFW6VE) – 谷歌和雅虎的崛起
  - [Part 3: Bubble](https://www.youtube.com/watch?v=aQjnkyoNIfg) – 2000 年的互联网泡沫破灭和互联网的中流砥柱：Amazon.com 和 Ebay
  - [Part 4: People Power](https://www.youtube.com/watch?v=f42J_reRO0Q) – 点对点技术、web 2.0 和社交网络
- [Something Ventured](https://www.imdb.com/title/tt1737747/) (2011) - 早期风险投资的历史[7.0/10](https://www.imdb.com/title/tt1737747/)</sup>
- [Code 2600](https://www.youtube.com/watch?v=FAfUjqIbfXo) (2011) - 记录信息技术时代，由帮助构建和操纵它的事件和人员讲述[7.4/10](https://www.imdb.com/title/tt1830538/)</sup>
- [We Are Legion: The Story of the Hacktivists](https://www.youtube.com/watch?v=ZHl0WI32XkY) (2012) - 一部关于自称为“黑客行动主义”集体 Anonymous 的工作和信仰的纪录片[7.3/10](https://www.imdb.com/title/tt2177843/)</sup>
- [Silicon Valley](https://www.pbs.org/video/american-experience-silicon-valley/) (2013) - 一部关于硅谷开端的 PBS“美国经验”纪录片[7.9/10](https://www.imdb.com/title/tt2547530/)</sup>
- [TPB AFK: The Pirate Bay Away From Keyboard](https://www.youtube.com/watch?v=eTOKXCEwo_8) (2013) <sup>[7.6/10](https://www.imdb.com/title/tt2608732/)</sup>
- [DEFCON: The Documentary](https://www.youtube.com/watch?v=3ctQOmjQyYg) (2013) - 关于最大的黑客大会 DEFCON 的纪录片[5.8/10](https://www.imdb.com/title/tt3010462/)</sup>
- [Downloaded](https://www.youtube.com/watch?v=kSZqkn9hT5w) (2013) - The Napster Revolution，一部探索下载革命的纪录片[6.9/10](https://www.imdb.com/title/tt2033981/)</sup>
- [Birth of BASIC](https://www.youtube.com/watch?v=WYPNjSoDrqw) (2014) - 发明基本计算机语言.
- [The Internet's Own Boy: The Story of Aaron Swartz](https://www.youtube.com/watch?v=vXr-2hwTk58) (2014) - 编程神童和信息活动家 Aaron Swartz 的故事[8.1/10](https://www.imdb.com/title/tt3268458/)</sup>
- [Rise of the Hackers](https://www.youtube.com/watch?v=dQnAEiGx1-4) (2014) - 利用密码学领先网络犯罪分子一步[7.5/10](https://www.imdb.com/title/tt3979842/)</sup>
- [Silicon Cowboys](https://www.netflix.com/title/80104318) (2016) - 纪录片详细介绍了康柏及其三位创始人的故事，以及康柏如何在其 PC 主导地位的巅峰时期与 IBM 抗衡.[6.8/10](https://www.imdb.com/title/tt4938484/)</sup>

### Reflective interviews

- [Steve Jobs - The Lost Interview](https://www.youtube.com/watch?v=TRZAJY23xio) (2012) - 在史蒂夫·乔布斯 (Steve Jobs) 管理 NeXT 时与他的对话，NeXT 是他离开 Apple 后创立的公司[8.1/10](https://www.imdb.com/title/tt2104994/)</sup>
- [The Great 202 Jailbreak](https://www.youtube.com/watch?v=CVxeuwlvf8w) (2013) - 大卫·布雷尔斯福德
- [UNIX Special: Profs Kernighan & Brailsford](https://www.youtube.com/watch?v=vT_J6xc-Az0) (2015) - David Brailsford 采访 Brian Kernighan

### Talks & Lectures

- [Computers From The Inside Out](https://www.youtube.com/watch?v=EKWGGDXe5MA)  (1985) - 理查德费曼计算机启发式讲座. 不是关于计算机历史本身，而是关于计算机如何工作
- [The Origins of Linux - Linus Torvalds](https://www.youtube.com/watch?v=WVTWCPoUt8w) (2001) - Linus Torvalds 讲述了他如何从一名研究生编写代码成为开源软件的偶像.
- [The Secret History of Silicon Valley](https://www.youtube.com/watch?v=ZTC_RxWN_xo) (2008) - Steve Blank 在计算机历史博物馆的演讲
- [Crockford on JavaScript - Volume 1: The Early Years](https://www.youtube.com/watch?v=JxAXlJEmNMg) (2011) - 实际上不是关于 JavaScript，而是关于早期的计算历史
- [Bret Victor - The Future of Programming](https://www.youtube.com/watch?v=8pTEmbeENF4) (2013..ehh 1973) - 从 1973 年开始幽默地谈论编程的未来

### Movies

_真实事件的戏剧化版本_

- [Pirates of Silicon Valley](https://www.imdb.com/title/tt0168122/) (1999) - 苹果和微软的历史[7.3/10](https://www.imdb.com/title/tt0168122/)</sup>
- [Micro Men](https://www.youtube.com/watch?v=XXBxV6-zamM) (2009) - Acorn 计算机和 Sinclair Research 的历史[7.6/10](https://www.imdb.com/title/tt1459467/)</sup>
- [The Social Network](https://en.wikipedia.org/wiki/The_Social_Network) (2010) - Facebook 诞生的历史[7.7/10](https://www.imdb.com/title/tt1285016/)</sup>
- [Halt and Catch Fire](https://en.wikipedia.org/wiki/Halt_and_Catch_Fire_(TV_series)) (2014-2017) - 以 1980 年代为背景，该系列戏剧化地展现了个人计算热潮[8.4/10](https://www.imdb.com/title/tt2543312/)</sup>
- [Steve Jobs](https://www.imdb.com/title/tt2080374/) （2015 年）- 故事展示了史蒂夫·乔布斯 (Steve Jobs) 在 Apple 标志性产品发布的幕后.[7.2/10](https://www.imdb.com/title/tt2080374/)</sup>

### Commercials

- [Apple 1984 Super Bowl Commercial](https://www.youtube.com/watch?v=2zfqw8nhUwA) (1984) - Apple 1984 超级碗广告介绍 Macintosh 电脑[7.8/10](https://www.imdb.com/title/tt4227346/)</sup>

## Audio

### Podcasts

- [Internet History Podcast](http://www.internethistorypodcast.com/) ([subscribe](https://itunes.apple.com/us/podcast/internet-history-podcast/id829119009))

## Texts

### Folklore

- [The Humble Programmer](https://www.cs.utexas.edu/users/EWD/ewd03xx/EWD340.PDF) (1972) - Dijkstra 在 1972 年对编程世界的概述
- [Real Programmers Don't Use PASCAL](https://web.mit.edu/humor/Computers/real.programmers) (1982)
- [Epigrams on Programming](http://www.cs.yale.edu/homes/perlis-alan/quotes.html) (1982)
- [The Story of Mel](http://www.catb.org/jargon/html/story-of-mel.html) (1983)
- [Unix Recovery Legend](https://www.ee.ryerson.ca/~elf/hack/recovery.html) (1986)
- [The Conscience of a Hacker](http://phrack.org/issues/7/3.html) （1986 年）- 黑客宣言
- [The Jargon File](https://www.dourish.com/goodies/jargon.html) (1988)
- [The Crypto Anarchist Manifesto](https://www.activism.net/cypherpunk/crypto-anarchy.html) (1992)
- [A Cypherpunk's Manifesto](https://www.activism.net/cypherpunk/manifesto.html) (1993)
- [The Story of Getting SSH Port 22](https://www.ssh.com/ssh/port) (1995)
- [In the Beginning…Was the Command Line](http://cristal.inria.fr/~weis/info/commandline.html) (1999)
- [The case of the 500-mile email](https://www.ibiblio.org/harris/500milemail.html) (2002)
- [UTF-8 history](https://www.cl.cam.ac.uk/~mgk25/ucs/utf-8-history.txt) (2003)
- [20 Years — One Standard: The Story of TCP/IP](http://www.cbi.umn.edu/iterations/spira.html) (2003)
- [How Steve Wozniak Wrote BASIC for the Original Apple From Scratch](https://gizmodo.com/how-steve-wozniak-wrote-basic-for-the-original-apple-fr-1570573636) (2014)
- [The Story of the PING Program](http://ftp.arl.army.mil/~mike/ping.html) （未注明日期）

### Announcements and Memos

- [What would you like to see most in minix?](https://groups.google.com/forum/#!topic/comp.os.minix/dlNtH7RRrGA%5B1-25%5D) (1991) - 首次公开提及后来成为 Linux 的东西
- [The Internet Tidal Wave](http://www.lettersofnote.com/2011/07/internet-tidal-wave.html) (1995) - 比尔·盖茨致微软所有高管人员的备忘录，将互联网置于最重要的位置
- [A bike shed (any colour will do) on greener grass...](http://phk.freebsd.dk/sagas/bikeshed.html) (1999) - Poul-Henning Kamp 创造了 bikeshedding 这个词

## Source Code

- [Apollo 11 Guidance Computer](https://github.com/chrislgarry/Apollo-11) (1969) - 原始阿波罗 11 号制导计算机 (AGC) 命令和登月舱源代码
- [C compiler](https://www.bell-labs.com/usr/dmr/www/primevalC.html) (1972) - Dennis Ritchie 的第一个 C 编译器的最早已知版本 ([GitHub code mirror](https://github.com/mortdeus/legacy-cc))
- [UNIX](https://github.com/dspinellis/unix-history-repo/tree/Research-Release) (1972) - 从 1972 年到今天连续的 Unix 提交历史
- [MS-DOS](https://github.com/Microsoft/MS-DOS) (1982, 1983) - 版本 1.25 和 2.0
- [Adobe Photoshop](http://www.computerhistory.org/atchm/adobe-photoshop-source-code/) (1990) - 第一个版本的 Adob​​e Photoshop（用 Pascal 编写）

## Websites

- [First website ever made](http://info.cern.ch/) (1990) - CERN（欧洲核研究组织）网站
- [The Amazing FishCam](http://fishcam.com/) (1994) - Fishcam 是网络上第二个实时摄像头，也是现存最古老的摄像头网站

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Thomas Watson](https://github.com/watson) 已放弃该作品的所有版权和相关或邻接权.
