<div class="github-widget" data-repo="eselkin/awesome-computational-neuroscience"></div>
## Awesome Computational Neuroscience [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

To contribute, see [:pencil2: code of contribution](https://github.com/eselkin/awesome-computational-neuroscience/blob/master/contributing.md)

[Computational neuroscience](https://en.wikipedia.org/wiki/Computational_neuroscience) is a multidisciplinary science that joins biology/neuroscience, medicine, biophysics, psychology, computer science, mathematics, and statistics to study the nervous system using computational approaches.

This list of schools and researchers in computational neuroscience, theoretical neuroscience, (and systems neuroscience) aims to give a global perspective of researchers in the field, make it easier to apply to the listed institutions, and also provide a reasonable way to find an advisor.

In addition to names of PIs, excerpts of their academic biographies, and links to their publications, many of the researchers are qualified with a small scale "+/=/- computational." The metric is subjective to the editor of that material but it generally breaks down as: (+) refers to a researcher the university identifies as a computational neuroscientist, their bio consistently identifies a significant component of their research is in the field, and they have a significant body of work in the field. (=) refers to the fact that the university identifies them as practicing computational research and they have occasionally produced articles in the field. (-) means that the university identifies them as practicing computational neuroscience, their bio might also mention it, but articles could not be found that represent this material. As with ratings, this metric might change for a researcher over time as they publish more.



## Europe

### Germany

#### INI

- [Ruhr-Universität Bochum, Institut für Neuroinformatik (INI)](https://www.ini.rub.de/research/groups/computational_neuroscience/)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s) | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Research                                                                   | +/=/- computational |
| ---------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------- | ------------------- |
| Cheng, Sen | Our first approach is modeling, including mathematic models as well as computer simulation of complex networks. While all models are simplified, we aim to build biologically realistic models that capture the essence of the neural circuit mechanism underlying learning and memory. Our second approach is data-mining. We develop methods for model-based data analysis and apply such methods to experimental data. These data include electrophysiological and EEG recordings as well as behavioral data. We collaborate closely with neuroscientists on the RUB campus and at other universities in Germany and abroad. | [Lab](https://www.ini.rub.de/the_institute/people/sen-cheng/#publications) | +                   |

</div>

### Italy

#### SISSA

- [International School for Advanced Studies (SISSA), Trieste](https://phdcns.sissa.it/admission-procedure)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)         | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Research                                                                                                 | +/=/- computational |
| ------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Treves, Alessandro | [Hippocampal Processing: The aim is to understand how the hippocampus contributes to memory, focusing on modelling coding strategies within each structure of the hippocampal formation (e.g. self-organization of grid representations), as well as interactions between different structures. Neural Basis of Language: The aim is to describe network behaviour that could subserve Language production. A class of reduced Potts models of large semantic associative networks, endowed with adaptation, naturally displays Latching dynamics, i.e. hopping from one attractor to the next. Such dynamics may be associated with a network capacity for infinite recursion, which is considered as the core of several higher cognitive functions.](https://people.sissa.it/~ale/limbo.html) | [Google](https://scholar.google.com/citations?hl=en&user=I2Y8X5AAAAAJ&view_op=list_works&sortby=pubdate) | +                   |

</div>

### Norway

#### NTNU

- [Kavli Institute for Systems Neuroscience Center for Neural Computation @ Norwegian University of Science and Technology](https://www.ntnu.edu/kavli)
- [Apply to Ph.D. in Medicine and Health Sciences. Masters degree requirement. Admission is rolling. Applications to the department with the desired academic advisor.](https://www.ntnu.edu/studies/phmed)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)                     | Department                               | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Research                                                                                                 | +/=/- computational |
| ------------------------------ | ---------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Moser, Edvard Ingjald          | Kavli Institute for Systems Neuroscience | [The Moser group implements and develops tools for large-scale brain recordings using standard tetrode recording as well as recently introduced high-site-count silicon probes (meaning they can sample from a particular brain area with high-resolution). In addition, they use portable two-photon microscopes for high-resolution optical imaging of neuronal activity. This means they can record the brain signal of many neurons, while the mice are allowed to freely move through the environment.](https://www.ntnu.edu/kavli/moser-group#/view/about)                                                                                                                                                                                                                                                                                                                           | [Lab](https://www.ntnu.edu/kavli/moser-group#/view/publications)                                         | +?                  |
| Moser, May-Britt               | Kavli Institute for Systems Neuroscience | [The Moser group implements and develops tools for large-scale brain recordings using standard tetrode recording as well as recently introduced high-site-count silicon probes (meaning they can sample from a particular brain area with high-resolution). In addition, they use portable two-photon microscopes for high-resolution optical imaging of neuronal activity. This means they can record the brain signal of many neurons, while the mice are allowed to freely move through the environment.](https://www.ntnu.edu/kavli/moser-group#/view/about)                                                                                                                                                                                                                                                                                                                           | [Lab](https://www.ntnu.edu/kavli/moser-group#/view/publications)                                         | +?                  |
| Witter, Menno P.               | Kavli Institute for Systems Neuroscience | [Witter’s team uses genetically engineered animals and non-infectious viral tracers to fluorescently visualize specific cell types and connections within the entorhinal cortex. After identifying cell types and connections, the team can turn specific cells on and off with laser beams (a technique known as optogenetics) and then study the effect of this manipulation on the rest of the circuit.](https://www.ntnu.edu/kavli/witter-group#/view/about)                                                                                                                                                                                                                                                                                                                                                                                                                           | [Lab](https://www.ntnu.edu/kavli/witter-group#/view/publications)                                        | +                   |
| Kentros, Clifford              | Kavli Institute for Systems Neuroscience | [The Kentros laboratory uses mouse molecular genetic techniques to address the neural circuitry underlying learning and memory. Combining the anatomical specificity of mouse molecular genetics with in vivo recordings from awake, behaving animals gives an edge to analyzing the functional circuitry of memory.](https://www.kentroslab.com/research)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/citations?hl=en&user=YtdZeFgAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Roudi, Yasser                  | Kavli Institute for Systems Neuroscience | [Roudi’s team uses mathematical tools from the field of theoretical physics to analyse big datasets, to develop models that draw out neural mechanisms in big datasets, and to identify and describe universal principles in biological systems.](https://www.ntnu.edu/kavli/roudi-group#/view/about)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | [Lab](https://www.spinorkavli.org/)                                                                      | +                   |
| Whitlock, Jonathan             | Kavli Institute for Systems Neuroscience | [The Whitlock group uses several tools to tackle their research questions: (1) a tracking and visualization software (developed in-house), which follows and records a rat’s movement through three-dimensional space and (2) electrophysiological recordings of the rat’s brain while it moves through that three-dimensional space. These two pieces of information (behavior and neural activity) are then analyzed using statistical methods. The parallel anatomical work in mice used tracers and markers to map out the circuits of the PPC.](https://www.whitlocklab.org/)                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=OFVqZ6IAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Yakse, Emre                    | Kavli Institute for Systems Neuroscience | [The Yaksi group uses two-photon microscopy, electrophysiology, genetic and applied mathematical tools to measure and analyze neural activity across the whole brain of awake, behaving juvenile zebrafish in naturalistic and virtual reality environments.](https://yaksilab.com)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Lab](https://yaksilab.com/publications/)                                                                | +                   |
| Doeller, Christian             | Medicine and Neuroscience                | [The Doeller and Kaplan group uses neuroimaging techniques such as functional magnetic resonance imaging (fMRI) and magnetoencephalography (MEG) to investigate brain systems that support learning, memory, and decision making. The former technique boasts relatively good “spatial resolution” (the ability to detect where a signal is coming from) while the latter boasts good “temporal resolution” (the ability to detect when a signal occurs). By combining this data with electrophysiological recordings from rodents, the team is able to paint a more comprehensive picture of the link between entorhinal brain signals and general cognition. ... Our framework is concerned with the key idea that this navigation system in the brain—potentially as a result of evolution—provides a fundamental neural metric for human cognition.](https://doellerlab.com/research/) | [Lab](https://doellerlab.com/publications/)                                                              | +?                  |
| Kaplan, Raphael Samuel Matthew | Kavli Institute for Systems Neuroscience | [See Doeller lab](https://doellerlab.com/research/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Google](https://scholar.google.com/citations?hl=en&user=NHhnjsIAAAAJ&view_op=list_works&sortby=pubdate) | +?                  |

</div>

### Switzerland

#### EPFL

- [Neuroscience (EDNE)](https://www.epfl.ch/education/phd/edne-neuroscience/)
- [Computer and Communication Sciences (EDIC)](https://www.epfl.ch/education/phd/edic-computer-and-communication-sciences/)
- [Computational and Quantitative Biology (EDCB)](https://www.epfl.ch/education/phd/edcb-computational-and-quantitative-biology/)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)         | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Research                                                                                                 | +/=/- computational |
| ------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Gerstner, Wulfram | [As director of the Laboratory of Computational Neuroscience LCN at the EPFL, Wulfram Gerstner conducts research in computational neuroscience with special emphasis on models of spiking neurons, spike-timing dependent plasticity, and reward-based learning in spiking neurons. The questions on learning in spiking neurons are linked to the problem of neuronal coding in single neurons and populations. His teaching concentrates on learning in formal models and biological systems. ](https://people.epfl.ch/wulfram.gerstner) | [Google](https://scholar.google.com/citations?hl=en&user=vSd2RnEAAAAJ) | +                   |
| Mathis, Mackenzie | [The goal of the laboratory is to reverse engineer the neural circuits that drive adaptive motor behavior by studying artificial and natural intelligence. We hope that by understanding the neural basis of adaptive motor control we can open new avenues in therapeutic research for neurological disease, help build better machine learning tools, and crucially, provide fundamental insights into brain function.](https://www.epfl.ch/labs/mackenziemathis-lab/) | [Google](https://scholar.google.com/citations?user=IhqY9XgAAAAJ) | +                   |
| Mathis, Alexander | [My work strives to understand how the brain creates complex behavior. To achieve that goal, in part, I develop tools for accurate measurement of behavior and make sure that they are broadly accessible for the community. Secondly, I make models and theories to elucidate how the brain gives rise to adaptive behaviors with a specific focus on motor control and sensorimotor learning.](https://www.mathislab.org/people) | [Google](https://scholar.google.com/citations?user=Y1xCzE0AAAAJ) | +                   |
| Blanke, Olaf | [The Blanke Lab has three missions – the neuroscientific study of consciousness, the adaptation and development of technologies for human neuroscience, and the development of cognitive neuroprostheses in clinical research.](https://www.epfl.ch/labs/lnco/research/) | [Google](https://scholar.google.com/citations?user=x-VifU4AAAAJ) | +                   |
| Herzog, Michael | [In the Laboratory of Psychophysics, we investigate visual information processing in human observers with psychophysical methods, TMS, EEG, and mathematical modelling. Main topics of research are: feature integration, contextual modulation, time course of information processing, and perceptual learning. In clinical studies, deficits of visual information processing are investigated in schizophrenic patients.](https://www.epfl.ch/labs/lpsy/) | [Google](https://scholar.google.com/citations?user=2ZOV3rIAAAAJ) | +                   |
| Lacour, Stéphanie | [Bioelectronics integrates principles of electrical engineering to biology, medicine and ultimately health. My lab challenges and seeks to advance our fundamental concepts in man-made electronic systems applied to biology. Specifically, the focus is on designing and manufacturing electronic devices with mechanical properties close to those of the host biological tissue so that long-term reliability and minimal perturbation are induced in vivo and/or truly wearable systems become possible. We use fabrication methods borrowed from the MEMS and microelectronics industries and adapt them to soft substrates like elastomers. We develop novel characterization tools adapted to mechanically compliant bioelectronic circuits. We evaluate in vitro, in animal models and ultimately on humans our soft bioelectronic interfaces](https://people.epfl.ch/stephanie.lacour/) | [Google](https://scholar.google.com/citations?user=1K-jygEAAAAJ) | =                   |
| Hummel, Friedhelm | [The research focus of the Hummel Lab is on systems and translational neuroscience. The main research topics are targeted towards neuroplasticity, neuronal control of sensorimotor function, motor skill acquisition and learning, healthy aging and especially on functional reorganization and recovery after focal Brain lesions by using multimodal systems neurosciences approaches including modern neuroimaging, brain stimulation and psychophysical and clinical evaluations. We are especially interested in the understanding of underlying mechanism of healthy aging and of functional regeneration after focal brain lesions, such as after stroke or traumatic brain injury and how they can be modulated, e.g. by non-invasive brain stimulation with overarching goal to translate the knowledge from “bench” to daily life clinical "bedside". One of our main characteristics is the multimodal methodological expertise in our lab. As such we use modern neuroimaging and neurostimulation.](https://www.epfl.ch/labs/hummel-lab/research/) | [Google](https://scholar.google.com/citations?hl=en&user=7pTiJewAAAAJ) | +                   |
| Shoaran, Mahsa | [Our research at INL lies at the intersection of circuit design, machine learning, and neuroscience, and our mission is to develop new diagnostic and therapeutic devices for neurological and neuropsychiatric disorders. We use advanced circuit design techniques to build low-power and miniaturized system-on-chips (SoCs) that can record neural activity, detect brain dysfunction in real time, and respond by therapeutic intervention such as neurostimulation. We use machine learning techniques for accurate detection of neurological symptoms in closed-loop neural implants, and for motor decoding in brain-machine interface systems.](https://people.epfl.ch/mahsa.shoaran/) | [Google](https://scholar.google.com/citations?hl=en&user=9tu1zw4AAAAJ) | +                   |
| Markram, Henry | [The Laboratory of Neural Microcircuitry (LNMC), headed by Professor Henry Markram, is dedicated to understanding the structure, function and plasticity of the neural microcircuits, with emphasis on the neocortex.](https://www.epfl.ch/labs/markram-lab/) | [Google](https://scholar.google.com/citations?hl=en&user=W3lyJF8AAAAJ) | +                   |
| Fua, Pascal | [The research activities of the Computer Vision Laboratory focus on shape and motion recovery from images, object and people detection and tracking in video sequences, and analysis of brain microscopy image-stacks. CVLab also provides undergraduate and graduate teaching and performs technology transfer to both established and start up companies.](https://people.epfl.ch/pascal.fua/) | [Google](https://scholar.google.com/citations?hl=en&user=kzFmAkYAAAAJ) | +                   |
| Hess Bellwald, Kathryn | [Her research focuses on algebraic topology and its applications, primarily in the life sciences, but also in materials science.  She has published extensively on topics in pure algebraic topology including homotopy theory, operad theory, and algebraic K-theory. On the applied side, she has elaborated methods based on topological data analysis for high-throughput screening of nanoporous crystalline materials, classification and synthesis of neuron morphologies, and classification of neuronal network dynamics.  She has also developed and applied innovative topological approaches to network theory, leading to a powerful, parameter-free mathematical framework relating the activity of a neural network to its underlying structure, both locally and globally.](https://people.epfl.ch/kathryn.hess/) | [Google](https://scholar.google.com/citations?hl=en&user=pJYDrPgAAAAJ) | +                   |
| Van De Ville, Dimitri | [I want to advance our understanding of the human body, in particular of brain function in health and disorder using non-invasive imaging techniques. To that aim, I pursue the development of methodological tools in signal and image processing to probe into network organization and dynamics, at various stages of the acquisition, processing, and analysis pipeline.](https://miplab.epfl.ch/index.php/people/vandeville) | [Google](https://scholar.google.com/citations?hl=en&user=kFz4LNMAAAAJ) | +                   |
| Courtine, Grégoire | [Our mission is to design innovative interventions to restore sensorimotor functions after CNS disorders, especially spinal cord injury, and to translate our findings into effective clinical applications capable of improving the quality of life of people with neuromotor impairments.](https://people.epfl.ch/gregoire.courtine) | [Google](https://scholar.google.com/citations?hl=en&user=Jvd6Y1UAAAAJ) | =                   |
| Ramdya, Pavan P | [ We use genetics, microscopy, modeling, and quantitative behavioral analysis to understand how the brain works.](https://people.epfl.ch/pavan.ramdya) | [Google](https://scholar.google.com/citations?hl=en&user=VGOSUXMAAAAJ) | +                   |

</div>

## North America

### Canada

#### Ontario

##### University of Waterloo

- [Theoretical Neuroscience](https://uwaterloo.ca/centre-for-theoretical-neuroscience/graduate-students/apply-admissions)
- Apply: Apply to established graduate department (e.g. <a href="https://uwaterloo.ca/graduate-studies-academic-calendar/mathematics/department-applied-mathematics/doctor-philosophy-phd-applied-mathematics#admission_requirements
        ">Applied Math</a>, <a href="https://uwaterloo.ca/graduate-studies-academic-calendar/mathematics/david-r-cheriton-school-computer-science/doctor-philosophy-phd-computer-science">Computer science</a>, <a href="https://uwaterloo.ca/graduate-studies-academic-calendar/arts/department-psychology/doctor-philosophy-phd-psychology">Psychology</a>, <a href="https://uwaterloo.ca/graduate-studies-academic-calendar/mathematics/department-statistics-and-actuarial-science/doctor-philosophy-phd-statistics">Statistics</a>)
- For CS a GRE is required if you have not completed a Bachelor's degree in a North American university with English as a primary language.


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)                                                    | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Research                                                                                                 | +/=/- computational |
| ------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Anderson, Britt                                               | [Dr. Anderson combines computational and empirical approaches in the study of spatial attention and general cognitive ability.](https://uwaterloo.ca/centre-for-theoretical-neuroscience/people-profiles/britt-anderson)                                                                                                                                                                                                                                                                    | [Lab](https://brittlab.uwaterloo.ca/publications/)                                                       | +                   |
| Campbell, Sue Ann                                             | [Her main research interest is in the mathematical modelling of neural systems at the single cell and small network level.](https://uwaterloo.ca/centre-for-theoretical-neuroscience/people-profiles/sue-ann-campbell)                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=KgioDk8AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Danckert, James                                               | [Dr. Danckert’s research explores the role of parietal cortex in the control of visually guided actions and examines the consequences of injury to this part of the brain.](https://uwaterloo.ca/danckert-attention-group/)                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/citations?hl=en&user=Bb2jD2QAAAAJ&view_op=list_works&sortby=pubdate) | =                   |
| Eliasmith, Chris                                              | [With Charles Anderson, I have developed a general method for building large-scale, biologically detailed models of neural systems. I have applied this method in a variety of contexts, including rat navigation, working memory, lamprey swimming, hemineglect, and language-based reasoning.](https://uwaterloo.ca/centre-for-theoretical-neuroscience/people-profiles/chris-eliasmith)                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=KOBO-6QAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Fugelsang, Jonathan                                           | [To understand the mechanisms underlying these processes, I use both behavioural and functional brain imaging (e.g., ERP, Functional Magnetic Resonance Imaging \[fMRI\]) methodologies.](https://uwaterloo.ca/psychology/people-profiles/jonathan-fugelsang)                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=FD3P_78AAAAJ&view_op=list_works&sortby=pubdate) | -                   |
| Ingalls, Brian (More computational biology than neuroscience) | [We use mathematical models and experimental methods to investigate the behaviour of intracellular molecular networks and cell-to-cell interactions. This work ranges from fundamental studies of biology to applications in biotechnology and health](https://uwaterloo.ca/scholar/bingalls/)                                                                                                                                                                                              | [Google](https://scholar.google.com/citations?hl=en&user=Td4gEp0AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Kapre, Nachiket (CS only, unrelated)                          | [Digital systems, Embedded computing systems, Reconfigurable computing, FPGA Architecture, Applications, Compilers](https://uwaterloo.ca/electrical-computer-engineering/profile/nachiket)                                                                                                                                                                                                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=JxwwXHMAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Marriott, Paul (Applied math, some NS)                        | [His interests focus on using geometric ideas, for example differential or convex geometry in statistics. He has recently been working on geometric methods to understand mixture models.](https://uwaterloo.ca/centre-for-theoretical-neuroscience/people-profiles/paul-marriott)                                                                                                                                                                                                          | [Google](https://scholar.google.com/citations?hl=en&user=hX40SzUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Orchard, Jeff                                                 | [My research aim is to uncover mechanisms that underlie the computational and organizational aspects of the brain. For example, what function does feedback play in our brains, and how do our expectations influence our perceptions? I study these questions by modelling neural networks.](https://cs.uwaterloo.ca/~jorchard/UWaterloo/Home.html)                                                                                                                                        | [Google](https://scholar.google.com/citations?hl=en&user=cAfBytAAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Spafford, J. David                                            | [Major projects in Dr. Spafford's lab focus on the: a) cellular and molecular mechanisms underlying calcium channel expression and localization in developing synapses; b) modulation of calcium channel function by G proteins, phosphorylation and synaptic proteins; c) isolation and characterization of anti-calcium channel toxins for caveolin 1 (Cav1), Cav2 and Cav3 calcium channels.](https://uwaterloo.ca/centre-for-theoretical-neuroscience/people-profiles/j-david-spafford) |                                                                                                          | -                   |
| Tripp, Bryan                                                  | [The central goal of the lab is to develop increasingly realistic computer/robotic models of the dorsal visual pathways and the networks that control eye and limb motion.](https://uwaterloo.ca/centre-for-theoretical-neuroscience/people-profiles/bryan-tripp)                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=OUMJw3oAAAAJ&view_op=list_works&sortby=pubdate) | +                   |

</div>

### United States

#### U.S. West

##### California Institute of Technology

- [CNS](http://www.cns.caltech.edu/admissions/index.html)
- [General Graduate application, multidisciplinary program.](http://www.gradoffice.caltech.edu/admissions/applyonline)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)              | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Research                                                                                                              | +/=/- computational |
| ----------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------- | ------------------- |
| Abu-Mostafa, Yaser      | [The Learning Systems group at Caltech works on the theory, implementation, and application of automated learning, pattern recognition, and neural networks. We are an interdisciplinary group with students coming from Electrical Engineering, Computer Science, Mathematics, and Physics. We work on a variety of projects analyzing and synthesizing systems that can be trained to perform their task.](http://www.cns.caltech.edu/people/faculty/abu-mostafa.html)                                                                                                                                                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Abu-mostafa,+yasser+caltech&hl=en&as_sdt=0,5)               | +                   |
| Adolphs, Ralph          | [The Emotion and Social Cognition Lab (aka “The Adolphs Lab”) investigates the neural underpinnings of human social behavior. We are pursuing questions such as: How do we recognize emotion from facial expressions? How do we make social judgments about other people? How do we look at people’s faces (how do we move our eyes when looking at them)? How do we make decisions that are influenced by emotion? How do we remember emotional events in our lives? How do we make moral judgments about what is right and wrong?](http://emotion.caltech.edu/)                                                                                                                                                                                                                                                                                                                       | [Lab](http://emotion.caltech.edu/?page_id=12470)                                                                      | =                   |
| Allman, John            | [We are using a variety of histological methods to visualize the complex structure of these cells and will be performing computer simulations of the cells activity in living brain. We are also pursuing several lines of research investigating evolutionary pressures and scaling relationships in mammalian brains. We have performed computer-assisted imaging of living and fixed brains of modern species as well as subfossil and fossil samples of extinct species.](http://www.cns.caltech.edu/people/faculty/allman.html)                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=allman,+john+M+caltech&hl=en&as_sdt=0,5)                    | +                   |
| Ames, Aaron             | [Bipedal robotics, hybrid systems, Zeno behavior, prosthetic devices. Theoretical foundations with practical applications to human inspired bipedal walking, Hybrid mechanical systems with a special emphasis on bipedal robots;Hybrid stability theory and its relationship to Zeno behavior;Hybrid geometric mechanics with a focus on hybrid geometric reduction and geometric control; Hybrid topology, geometry and homology; Novel Applications such as Prosthetics](http://ames.caltech.edu/research.html)                                                                                                                                                                                                                                                                                                                                                                      | [Lab](http://ames.caltech.edu/publications.html)                                                                      | +                   |
| Anandkumar, Anima       | [Tensors (seminal work). Democratizing ML. Fairness. PhD students and postdoctoral candidates with strong foundation in machine learning, statistics, and algorithms.](http://tensorlab.cms.caltech.edu/users/anima/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [Lab](http://tensorlab.cms.caltech.edu/users/anima/publications.html)                                                 | =                   |
| Andersen, Richard       | [One project in the lab is to develop a cognitive-based neural prosthesis for paralyzed patients;We have been examining the coordinate frame for coordinated movements of the hand and eyes;We have been examining decision making in parietal-frontal circuits;A 4.7 Tesla vertical magnet for monkey imaging has recently been installed at Caltech. We are using this magnet, combined with neural recordings, to examine the correlation between neural activity and fMRI signals.](http://www.cns.caltech.edu/people/faculty/andersen.html)                                                                                                                                                                                                                                                                                                                                        | [Lab](http://www.vis.caltech.edu/papers)                                                                              | +                   |
| Anderson, David         | [Research in this laboratory is aimed at understanding the neurobiology of emotion. We seek to elucidate how fundamental properties common to emotional states, such as arousal, are encoded in the circuitry and chemistry of the brain and how these internal states combine with sensory stimuli to elicit specific emotional behaviors, such as fear or aggression](http://davidandersonlab.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [Lab](http://davidandersonlab.caltech.edu/publications)                                                               | +                   |
| Barr, Alan              | [A source of motivation and long term goal for the research is the creation of tools for simulation and behavioral prediction of mechanical and biophysical structures. The methods are intended to eventually be applied to simulating the behavior of cellular organelles, but also to self-assembling robotic structures as potentially needed for human colonization of space; the same modeling technology can be used for both applications.](http://www.cns.caltech.edu/people/faculty/barr.html)                                                                                                                                                                                                                                                                                                                                                                                |                                                                                                                       | +                   |
| Bruck, Jehoshua         | [We attempt to prove this conjecture by evaluating string replication systems from an information theory perspective, as well as study tandem duplication and interspersed duplication mechanisms.](http://www.paradise.caltech.edu/index.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=HgaNy9kAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Burdick, Joel W.        | [Our research group pursues both Robotics and BioEngineering related to spinal cord injury](http://robotics.caltech.edu/wiki/index.php/Robotics)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Joel+W.+Burdick&hl=en&as_sdt=0,5)                           | +                   |
| Camerer, Colin F.       | [Neuroeconomics. Psychology and economics, decision making, business administration, game theory.](http://www.cns.caltech.edu/people/faculty/camerer.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Google](https://scholar.google.com/citations?hl=en&user=8udO65kAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Dickinson, Michael      | [studies the neural and biomechanical basis of behavior in the fruit fly, Drosophila. We strive to build an integrated model of behavior that incorporates an understanding of morphology, neurobiology, muscle physiology, physics, and ecology](https://dickinsonlab.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=kc3snaQAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Elowitz, Michael        | [The Elowitz Lab is interested in how genetic circuits, composed of interacting genes and proteins, enable individual cells to make decisions, oscillate, and communicate with one another](http://www.elowitz.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [Lab](http://www.elowitz.caltech.edu/publications.html)                                                               | +                   |
| Gradinaru, Viviana      | [The Gradinaru Lab studies the mechanism of action for deep brain stimulation (DBS), a therapeutical option for motor and mood disorders such as Parkinson’s and depression. Our previous work highlighted the importance of selectively controlling axons and not local cell bodies in modulating behavior, a principle that might play a generalized role across many effective deep brain stimulation paradigms. We are now particularly interested in the long-term effects of DBS on neuronal health, function, and ultimately behavior.](http://glab.caltech.edu/)                                                                                                                                                                                                                                                                                                                | [Lab](http://glab.caltech.edu/publications.html)                                                                      | +                   |
| Hong, Betty (E.J.)      | [Our goal is to understand how molecular diversity at synapses gives rise to useful variation in synaptic physiology, and how this may reflect the specialization of synapses to perform specific useful computations in their respective circuits.](http://www.ejhonglab.org/team/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](http://www.ejhonglab.org/publications/)                                                                         | +                   |
| Konishi, Masakazu       | [Owls. Preditors. The work over the past twenty years has led to a reasonably good understanding of the algorithm for the computation of sound locations in 2 dimensions](http://www.cns.caltech.edu/people/faculty/konishi.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/scholar?as_ylo=2016&q=Konishi,+Masakazu++caltech&hl=en&as_sdt=0,5)                | +                   |
| Lester, Henry A.        | [The Lester lab uses techniques at the intersection of biophysics, single-molecule imaging, chemistry, mouse genetics, and neuroscience to understand the biophysical basis of ligand-gated ion channels including the nicotinic acetylcholine receptor.](http://henrylesterresearchgroup.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/citations?hl=en&user=8KbzXvoAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Lois, Carlos            | [Our laboratory is interested in the assembly of brain circuits and the mechanisms by which the activity of neurons in these circuits give rise to behavior. We focus on the process of neuron addition into the vertebrate brain, and seek to understand how new neurons integrate into the circuits of the adult brain, and their role in information processing and storage](http://www.cns.caltech.edu/people/faculty/lois.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=BO4a37QAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Mead, Carver (emeritus) | [Very diverse history of research spanning gravitation to analog silicon retinas...](http://www.carvermead.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [Lab](http://www.carvermead.caltech.edu/publications.html)                                                            | +                   |
| Meister, Markus         | [My goal is to understand the function of neuronal circuits. By "circuit" I mean a brain structure with many neurons that has some anatomical and functional identity, and exchanges signals with other brain circuits](http://www.cns.caltech.edu/people/faculty/meister.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=QKhjs2YAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Mobbs, Dean             | [The Mobbs Lab is inspired by insights from the fields of behavioral ecology, social, evolutionary and clinical psychology. Our lab’s main endeavor is to understand the neural and behavioral dynamics of human social and emotional experiences and consequently build new theoretical models that merge multiple fields. We employ brain imaging (e.g. fMRI) and novel behavioral techniques to examine the neurobiological systems that coordinate fear and anxiety in humans. My lab also investigates the proximate and ultimate value of social behavior.](https://www.deanmobbslab.com/)                                                                                                                                                                                                                                                                                        | [Lab](https://www.deanmobbslab.com/publications)                                                                      | +                   |
| Murray, Richard         | [Current projects include integration of control, communications, and computer science in multi-agent systems, information dynamics in networked feedback systems, analysis of insect flight control systems, and synthetic biology using genetically-encoded finite state machines.](http://www.cds.caltech.edu/~murray/wiki/Main_Page)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [Lab](http://www.cds.caltech.edu/~murray/wiki/index.php?title=Papers)                                                 | =                   |
| O'Doherty, John         | [The ability to make decisions requires neural machinery that has been honed through evolution to enable animals to learn about the structure of their environment and uncover causal links between their own behavior and the probability of obtaining rewards. A deeper understanding of how the brain does this will not only inspire new theories of decision making, it will also contribute to the development of genuine "artificial intelligence", and it will enable us to understand why some humans are better than others at making decisions, why humans with certain psychiatric disorders or brain lesions are less capable of doing so, and why under some circumstances humans systematically fail to make "rational" decisions. The goal of our research is to unravel the neural computations underlying this process in the human brain.](http://olab.caltech.edu/) | [Lab](http://olab.caltech.edu/publications.html)                                                                      | +                   |
| Oka, Yuki               | [Our goal is to understand where and how appetites are encoded in the brain... With these thirst-controlling neurons in hand, we are now exploring the downstream and upstream neural circuits to decipher how motivational signals are translated into behavioral outputs.](http://www.okalab.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [Lab](http://www.okalab.caltech.edu/Publications.html)                                                                | +                   |
| Perona, Pietro          | [We are interested in the computational foundations of vision. This knowledge helps us design machine vision systems with applications to science, consumer products, entertainment, manufacturing and defense](http://www.vision.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=j29kMCwAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Prober, David A.        | [We are using zebrafish as a new model to discover and understand genetic and neuronal circuits that regulate sleep.](https://www.proberlab.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Lab](https://www.proberlab.caltech.edu/Publications)                                                                 | +                   |
| Quartz, Steven          | [Impact of neuroscience advances for many of the traditional problems of mind, ranging from a neurally plausible theory of mental representation, the origin of knowledge, to the formal learning properties of neurally constrained developing systems.](http://www.cns.caltech.edu/people/faculty/quartz.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                                                                                                                       | =                   |
| Rangel, Antonio         | [We study the neural basis of economic decision-making using tools from cognitive neuroscience and experimental economics. The tools that we use include functional magnetic resonance imaging, transcranial magnetic stimulation, and eye tracking. The research team includes neuroscientists, psychologists, and economists.](http://www.rnl.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [Lab](http://www.rnl.caltech.edu/publications/index.html)                                                             | +                   |
| Shimojo, Shinsuke       | [We would like to understand how the brain adapts real-world constraints to resolve perceptual ambiguity and to reach ecologically valid, unique solutions](https://neuro.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Lab](http://neuro.caltech.edu/page/publications/)                                                                    | =                   |
| Siapas, Thanos          | [Our research focuses on the study of information processing across networks of neurons, with emphasis on the neuronal mechanisms that underlie learning and memory formation.](http://www.cns.caltech.edu/people/faculty/siapas.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=xDF_m1EAAAAJ&view_op=list_works&sortby=pubdate)              | +                   |
| Sternberg, Paul         | [We measure gene expression by RNA-seq and transgenic reporters; we measure behavior using automated systems and optogenetics. We focus on intercellular signals and their transduction by the responding cell into transcriptional outputs. Many of the genes we have identified are the nematode counterparts of human genes, and we expect that some of our findings will apply to human genes as well.](http://wormlab.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                | [Lab](http://wormlab.caltech.edu/Publications)                                                                        | +                   |
| Tsao, Doris             | [Segmentation (Our lab is pursuing the neural mechanisms underlying segmentation through a variety of approaches including mathematical modeling and development of new experimental models for study of visual segmentation), Recognition, Consciousness, Space, Tools such as ultrasonic neuromodulation, ultrasonic chemogenetics, and high-channel count electrophysiology.](https://www.tsaolab.caltech.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | [Lab](https://www.tsaolab.caltech.edu/publications/)                                                                  | +                   |
| Winfree, Erik           | [Biomolecular computation, DNA based computation, algorithmic self-assembly, in vitro biochemical circuits, noise and fault-tolerance, DNA and RNA folding, evolution.](http://www.dna.caltech.edu/~winfree/) [or](http://molecular-programming.org/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [Google](https://scholar.google.com/citations?hl=en&user=5GQF2FwAAAAJ&pagesize=100&view_op=list_works&sortby=pubdate) | +                   |
| Yue, Yisong             | [Yisong Yue's research interests lie primarily in the theory and application of statistical machine learning. He is more generally interested in artificial intelligence. Currently, he is particularly interested in learning with humans in the loop, interactive learning systems, and spatiotemporal reasoning](http://www.yisongyue.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [Lab](http://www.yisongyue.com/)                                                                                      | +                   |

</div>

##### Stanford University

- [MBCT](https://neuroscience.stanford.edu/mbct/home)
- [Neurosciences Ph.d., GREs no longer used.](https://med.stanford.edu/neurogradprogram/prospective_students.html)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                          | Research                                                                                     | +/=/- computational |
| ------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- | ------------------- |
| Airan, Raag              | [precisely deliver drugs to the brain, to mediate more precise control of neural activity, in addition to other therapeutic effects](http://airan-lab.stanford.edu/)                                                                                                                                                                                                                                                                    | [Lab](http://airan-lab.stanford.edu/publications/)                                           | =                   |
| Baccus, Stephen A.       | [(Brain-Machine Interfaces,Neuro-circuit interventional research consortium for understanding the brain and improving treatment) We study how the circuitry of the retina translates the visual scene into electrical impulses in the optic nerve...experimental data is used to create mathematical models to predict and explain the output of the retinal circuit.](https://baccuslab.sites.stanford.edu/)                           | [Google](https://scholar.google.com/scholar?as_ylo=2017&q=baccus+stephen+a&hl=en&as_sdt=0,5) | +                   |
| Chichilnisky, E.J.       | [The goal of our research is to understand how the neural circuitry of the retina encodes visual information, and to use this knowledge in the development of artificial retinas for treating incurable blindness](http://med.stanford.edu/neurosurgery/research/chichilnisky.html)                                                                                                                                                     | [Lab](http://med.stanford.edu/neurosurgery/research/chichilnisky/publications.html)          | +                   |
| Clandinin, Thomas        | [My lab seeks to understand how the brain computes at the cellular and molecular level](https://flyvisionlab.weebly.com/)                                                                                                                                                                                                                                                                                                               | [Lab](https://flyvisionlab.weebly.com/publications.html)                                     | +                   |
| Druckmann, Shaul         | [We seek to relate circuit dynamics to computation by understanding the unique computational style used by the brain](https://www.druckmannlab.com/)                                                                                                                                                                                                                                                                                    | [Lab](https://www.druckmannlab.com/publications.html)                                        | +                   |
| Etkin, Amit              | [we collaborate with neuroscientists, engineers, psychologists, physicians and others to establish a new intellectual, scientific and clinical paradigm for understanding and manipulating human brain circuits in healthy individuals and for treating psychiatric disease](http://www.etkinlab.stanford.edu/research-1)                                                                                                               | [Lab](http://www.etkinlab.stanford.edu/publications)                                         | +                   |
| Ganguli, Surya           | [we exploit and extend tools and ideas from a diverse array of disciplines, including statistical mechanics, dynamical systems theory, machine learning, information theory, control theory, and high-dimensional statistics, as well as collaborate with experimental neuroscience laboratories collecting physiological data from a range of model organisms, from flies to humans](http://ganguli-gang.stanford.edu/index.html)      | [Lab](http://ganguli-gang.stanford.edu/pubs.html)                                            | +                   |
| Gardner, Justin          | [Using knowledge of the visual system and decision theoretical models of how behavior is linked to cortical activity, we seek to understand the cortical computations that construct human vision](http://gru.stanford.edu/doku.php/shared/research)                                                                                                                                                                                    | [Lab](http://gru.stanford.edu/doku.php/shared/publications)                                  | +                   |
| Ghajar, Jashmid MD, FACS | [improve the diagnosis and treatment of TBI. To do this, we lead the way in cutting-edge clinical research spanning the spectrum from concussion to coma](https://www.braintrauma.org/research)                                                                                                                                                                                                                                         | [Lab](https://www.braintrauma.org/pages/publications)                                        | =                   |
| Giocomo, Lisa            | [Giocomo Lab integrates electrophysiology, behavior, imaging, gene manipulations, optogenetics and computational modeling to study how single-cell biophysics and network dynamics interact to mediate spatial memory and navigation](https://giocomolab.weebly.com/)                                                                                                                                                                   | [Lab](https://giocomolab.weebly.com/publications.html)                                       | +                   |
| Grill-Spector, Kalanit   | [Our research utilizes functional imaging (fMRI), computational techniques, and behavioral methods to investigate visual recognition and other high-level visual processes](http://vpnl.stanford.edu/)                                                                                                                                                                                                                                  | [Lab](http://vpnl.stanford.edu/publications.htm)                                             | +                   |
| Gross, James             | [(Psychology) The goal of this project is to create a computational model that will help us understand the unfolding of emotions at the group level (collective emotion) and to correlate this model with real life events](https://spl.stanford.edu/projects-0)                                                                                                                                                                        | [Lab](https://spl.stanford.edu/selected-publications)                                        | +                   |
| Holmes, Susan            | [We use computational statistics, multitable and nonparametric methods such as the bootstrap and MCMC computation of complex posterior distributions to draw inferences about complex biological phenomena](http://statweb.stanford.edu/~susan/LabIndex.html)                                                                                                                                                                           | [Lab](http://statweb.stanford.edu/~susan/papers.html)                                        | +                   |
| Huguenard, John          | [Our approach is an analysis of the discrete components that make up thalamic and cortical circuits, and reconstitution of components into both in vitro biological and in silico computational networks](https://huguenard-lab.stanford.edu/wp1/)                                                                                                                                                                                      | [Lab](https://huguenard-lab.stanford.edu/wp1/publications/)                                  | +                   |
| Knutson, Brian           | [(NeuroChoice), Neural circuit dynamics of drug action](http://stanford.edu/group/spanlab/Projects/projects.html)                                                                                                                                                                                                                                                                                                                       | [Lab](http://stanford.edu/group/spanlab/Publications/publications.html)                      | +                   |
| Lee, Jin Hyung           | [The Lee Lab uses interdisciplinary approaches from biology and engineering to analyze, debug, and manipulate systems-level brain circuits](https://neuroscience.stanford.edu/people/jin-hyung-lee)                                                                                                                                                                                                                                     | [Lab](https://profiles.stanford.edu/jin-hyung-lee?tab=publications)                          | +                   |
| Luo, Liqun               | [Organization and function of neural circuits in the mouse and Developing genetic tools to probe neural circuit assembly and organization](http://web.stanford.edu/group/luolab/Research.shtml)                                                                                                                                                                                                                                         | [Lab](http://web.stanford.edu/group/luolab/Publications.shtml)                               | +                   |
| McClelland, Jay          | [...the primary current focus is on mathematical cognition from Parallel and Distributed Processing site](https://stanford.edu/~jlmcc/)                                                                                                                                                                                                                                                                                                 | [Lab](https://stanford.edu/~jlmcc/papers/)                                                   | +                   |
| Newsome, William         | [Computer modelling techniques are then used to develop more refined hypotheses concerning the relationship of brain to behavior that are both rigorous and testable. This combination of behavioral, electrophysiological and computational techniques provides a realistic basis for neurophysiological investigation of cognitive functions such as perception, memory and motor planning](http://monkeybiz.stanford.edu/index.html) | [Lab](http://monkeybiz.stanford.edu/pubs.html)                                               | +                   |
| Norcia, Anthony          | [Brain mechanisms underlying face and text processing...methods for exploiting the temporal resolution of the EEG to study the dynamics of brain processing...](https://svndl.stanford.edu/research)                                                                                                                                                                                                                                    | [Lab](https://svndl.stanford.edu/research/publications)                                      | =                   |
| Poldrack, Russell        | [Our lab uses the tools of cognitive neuroscience to understand how decision making, executive control, and learning and memory are implemented in the human brain. We also develop neuroinformatics tools and resources to help researchers make better sense of data.](https://poldracklab.stanford.edu/)                                                                                                                             | [Google](https://scholar.google.com/citations?user=RbmLvDIAAAAJ&hl=en)                       | +                   |
| Raymond, Jennifer L.     | [The goal of our research is to understand the algorithms the brain uses to learn](http://raymondlab.weebly.com/)                                                                                                                                                                                                                                                                                                                       | [Lab](http://raymondlab.weebly.com/publications.html)                                        | +                   |
| Schnitzer, Mark J.       | [Development of high-throughput, massively parallel imaging techniques for studying brain function in large numbers of Drosophila concurrently](http://pyramidal.stanford.edu/)                                                                                                                                                                                                                                                         | [Lab](http://pyramidal.stanford.edu/publications.html)                                       | +                   |
| Shenoy, Krishna          | [(BMIs), conducts neuroscience, neuroengineering and translational research to better understand how the brain controls movement, and to design medical systems to assist people with paralysis](https://shenoy.people.stanford.edu/overview)                                                                                                                                                                                           | [Lab](https://shenoy.people.stanford.edu/journal-papers)                                     | +                   |
| Soltesz, Ivan            | [We are interested in how brain cells communicate with each other in the normal brain, and how the communication changes in epilepsy ... highly realistic large-scale supercomputational modeling approaches](http://med.stanford.edu/ivansolteszlab/front-page.html)                                                                                                                                                                   | [Lab](http://med.stanford.edu/ivansolteszlab/front-page.html#publications)                   | +                   |
| Wagner, Anthony D        | [Current research directions – which combine behavior, brain imaging, virtual reality, and computational approaches](https://memorylab.stanford.edu/)                                                                                                                                                                                                                                                                                   | [Lab](https://memorylab.stanford.edu/publications/2010-current)                              | +                   |
| Williams, Leanne         | [...Biomedical data sciences and informatics are also essential, not only because of the amount of data we generate, but also because we rely on increasingly sophisticated computational models to understand such complex phenomena as the brain and depression](http://williamspanlab.com/)                                                                                                                                          | [Lab](http://williamspanlab.com/publications)                                                | +                   |
| Yamins, Daniel           | [Our research lies at intersection of neuroscience, artificial intelligence, psychology and large-scale data analysis. We seek to "reverse engineer" the algorithms of the brain, both to learn about how our minds work and to build more effective artificial intelligence systems](http://neuroailab.stanford.edu/)                                                                                                                  | [Lab](http://neuroailab.stanford.edu/publications.html)                                      | +                   |

</div>

##### University of California, Berkeley

- [Theoretical Neuroscience](https://redwood.berkeley.edu/people/)
- [Neuroscience Ph.D., GRE: Institution: 4833, Department: 0213](http://neuroscience.berkeley.edu/ph-d-program/)
- [Vision Science Ph.D., Apply, GRE: Institution: 4833, Department: 0611](https://vision.berkeley.edu/admissions)
- [Electrical Engineering and Computer Sciences, Ph.D., GRE: Institution(4833), Department(Not required)](https://eecs.berkeley.edu/academics/graduate/research-programs/admissions)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)           | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                          | Research                                                                                                 | +/=/- computational |
| -------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Banks, Martin        | [Visual space perception and sensory combination](http://bankslab.berkeley.edu/)                                                                                                                                                                                                                                                                                                                                                        | [Lab](http://bankslab.berkeley.edu/publications/index.html)                                              | +                   |
| Bouchard, Kristofer  | [How distributed neural circuits give rise to coordinated behaviors and perception](https://redwood.berkeley.edu/people/kristofer-bouchard/)                                                                                                                                                                                                                                                                                            | [Google](https://scholar.google.com/citations?hl=en&user=mDvGOLkAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Carmena, Jose        | [Neural basis of motor skill learning. Application to neural prostheses and development of neural dust technology](https://neuroscience.berkeley.edu/faculty/)                                                                                                                                                                                                                                                                          | [Google](https://scholar.google.com/citations?user=qyF6UhQAAAAJ&hl=en&oi=ao)                             |                     |
| Collins, Anne        | [Computational modeling of human learning, decision-making, and executive functions.... Computational modeling lets us precisely and quantitatively define theories, make explicit predictions, and investigate how well different information representations work in different environments. Computational modeling may also provide a link to the mechanistic implementation of processes.](https://www.ocf.berkeley.edu/~acollins/) | [Lab](https://www.ocf.berkeley.edu/~acollins/pages/publications.html)                                    | +                   |
| Cooper, Emily        | [Computational modeling of visual perception...We study the statistics of natural images and examine their relevance for visual coding and perception](http://www.emilyacooper.org/research.html)                                                                                                                                                                                                                                       | [Lab](http://www.emilyacooper.org/publications.html)                                                     | +                   |
| Dan, Yang            | [Neural circuits controlling sleep; mechanisms of executive control...](http://mcb.berkeley.edu/faculty/NEU/dany)                                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=8dea7mQAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| DeWeese, Mike        | [experimental and theoretical neuroscience](https://redwood.berkeley.edu/people/mike-deweese/)                                                                                                                                                                                                                                                                                                                                          | [Google](https://scholar.google.com/citations?hl=en&user=DZ9-LmkAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Feinberg, David      | MRI technology development, mapping columnar and visual circuitry, modeling neurovascular coupling.                                                                                                                                                                                                                                                                                                                                     |                                                                                                          | +                   |
| Gallant, Jack        | [Identifying cortical maps to discover how the brain represents information about the world and its own mental states... To address this problem, our laboratory makes heavy use of an inductive scientific approach called system identification. System identification is a systematic approach for discovering the computational principles of an unknown system such as the brain.](http://gallantlab.org/)                         | [Google](https://scholar.google.com/citations?user=nSZG-vcAAAAJ&hl=en)                                   | +                   |
| Li, Lexin            | [Neuroimaging data analysis: brain connectivity and network analysis, imaging causal inference, imaging genetics, longitudinal imaging analysis, multi-modality analysis, tensor analysis; Statistical genetics, computational biology; Dimension reduction, variable selection, high dimensional regressions; Statistical machine learning, data mining, computational statistics](http://lexinli.biostat.berkeley.edu/)               | [Google](https://scholar.google.com/citations?hl=en&user=JTwOVhEAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Maharbiz, Michel     | [Building micro- and nano- scale machine interfaces to cells and organisms, including development of neural dust technology.](https://github.com/eselkin/awesome-computational-neuroscience/blob/master/maharbizgroup.wordpress.com)                                                                                                                                                                                                                                                                              | [Lab](https://https://github.com/eselkin/awesome-computational-neuroscience/blob/master/maharbizgroup.wordpress.com/publications/)                                                 | +                   |
| Olshausen, Bruno     | [Developing new theoretical frameworks and models of vision](https://redwood.berkeley.edu/people/bruno-olshausen/)                                                                                                                                                                                                                                                                                                                      | [Lab](http://www.rctn.org/bruno/papers/)                                                                 | +                   |
| Sommer, Friedrich    | [Theoretical principles of learning and perception.My lab investigates the theoretical principles of learning and perception and their biological bases in the circuit dynamics of the brain. To study these issues we develop computational models of the brain, as well as advanced techniques of data analysis](http://www.rctn.org/wiki/Fritz_Sommer#Research_Interests)                                                            | [Google](https://scholar.google.com/citations?hl=en&user=lA-oLkgAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Theunissen, Frédéric | [The overarching goal of our laboratory is to understand how complex natural sounds such as human speech, music and animal vocalizations are detected and recognized by the brain...We use computational methods in neuroscience to generate theories of audition, to study sounds and to analyze our neural data](http://theunissen.berkeley.edu/)                                                                                     | [Lab](http://theunissen.berkeley.edu/publications.html)                                                  | +                   |

</div>

##### University of California, Davis

- [Computational Neuroscience](https://neuroscience.ucdavis.edu/computational)
- [Neuroscience, GRE: Institution(4834), Dept(None specified), GRE Subject test encouraged (...)](https://grad.neuroscience.ucdavis.edu/apply)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Research Areas                                                                                                                                                                                                                                          | Research                                                                                                 | +/=/- computational |
| ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Antzoulatos, Evangelos   | [large-scale neural networks that implement cognitive functions](https://neuroscience.sf.ucdavis.edu/people/evangelos-antzoulatos)                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=cMIRlNwAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| DeBello, William         | [complete wiring diagram of local circuits in the barn owl auditory localization pathway](https://neuroscience.ucdavis.edu/people/william-debello)                                                                                                      |                                                                                                          | +                   |
| Ditterich, Jochen        | [bridging this gap by utilizing both behavioral and neurophysiological methods and by using mathematical models for exploring potential neural mechanisms](https://neuroscience.ucdavis.edu/people/jochen-ditterich)                                    | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Ditterich,+Jochen&hl=en&as_sdt=0,5)            | +                   |
| Goldman, Mark            | [wide variety of systems and seek to address questions ranging from cellular and network dynamics to sensory coding to memory and plasticity](https://neuroscience.ucdavis.edu/people/mark-goldman)                                                     | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Goldman,+Mark+uc+davis&hl=en&as_sdt=0,5)       | +                   |
| Hanks, Tim               | [We use the knowledge gained from these experiments to develop and constrain circuit-level descriptions of the computations that underlie decision making.](https://neuroscience.ucdavis.edu/people/tim-hanks)                                          | [Google](https://scholar.google.com/citations?hl=en&user=a2nnsrAAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Nord, Alex               | [(Brain Disease, Disorders), To that end, I perform both experimental work and computational analysis to reveal function of primary DNA sequence, epigenomic modifications, and chromatin structure](https://neuroscience.ucdavis.edu/people/alex-nord) | [Google](https://scholar.google.com/citations?hl=en&user=_FbUThYAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Usrey, W. Martin (Chair) | [Structure, Function and Development of Neural Circuits for Vision](https://neuroscience.ucdavis.edu/people/w-martin-usrey)                                                                                                                             | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Usrey+uc+davis&hl=en&as_sdt=0,5)               | +                   |

</div>

##### University of California, Irvine

- [Admission to UCI Cognitive Sciences Ph.D. program. GRE general test required to: 4859](https://www.cogsci.uci.edu/graduate/program.php#apply)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Department                                              | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Research                                                                                                     | +/=/- computational |
| ------------------------ | ------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------ | ------------------- |
| Bornstein, Aaron M.      | Cognitive Sciences                                      | [The lab's ongoing research investigates the influence of memories on behavior. Specific projects in progress examine the roles of episodic and working memory in decisions for reward, perceptual inference, drug choice and addiction, and intertemporal choice, using computational model-driven analysis of behavior and brain activity (via fMRI, but with plans for EEG and other methods).](http://aaron.bornstein.org)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Google](https://scholar.google.com/citations?hl=en&user=ltlh6LQAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Brewer, Alyssa           | Cognitive Sciences                                      | [Our primary areas of research are fundamental visual system organization, visual adaptation and plasticity, and neurodegeneration. The tools we use for our investigations include magnetic resonance imaging (MRI), functional MRI (fMRI), diffusion tensor imaging (DTI), psychophysics, genetic assays, psychopharmacology, mathematical modeling, and surveys.](http://www.socsci.uci.edu/~aabrewer)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?hl=en&user=00yn31kAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Chernyak, Nadia          | Cognitive Sciences                                      | [Our specific research topics include the development of fairness and prosocial behavior, how we learn from choice and agency, the development of prospection (future-oriented thinking), and how our social contexts and cognitive competencies shape our emerging world views. We typically conduct behavioral studies with young children and adults.](https://www.dosclab.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [Lab](https://www.dosclab.com/publications)                                                                  | -                   |
| Chubb, Charlie           | Cognitive Sciences                                      | [Research analyzing camouflage: strategies in nature, how to make it and how to break it; A technique to compare the effects of stimulus salience across sensory properties and tasks; Research exploring how and why the time to initiate a response increases with the number of possible choices; Research that explores two functions relating movement speed and accuracy, their generality, and the mechanisms that underlie them; Visual and auditory experiments aimed at figuring out what sorts of variations in physical energy are spontaneously discriminated by human observers.](https://cwlab.ss.uci.edu/research-areas/)                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?hl=en&user=OlFlu1oAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| D'Zmura, Michael         | Cognitive Sciences                                      | [The Cognitive NeuroSystems Lab at UC Irvine conducts research on vision, hearing and EEG studies of speech and attention; past work includes studies of search and navigation in 4D virtual environments.](http://cnslab.ss.uci.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=eci4MtQAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Dosher, Barbara          | Cognitive Sciences                                      | [Memory in humans, with emphasis on forgetting and retrieval in explicit and implicit memory; Attention processes and their consequences for perceptual efficiency in information processing; How training in perceptual tasks improves visual performance and its use in cognitive rehabilitation](https://www.socsci.uci.edu/maplab/index.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/scholar?as_ylo=2015&q=%22BA+Dosher%22&hl=en&as_sdt=0,5)                  | +                   |
| Grossman, Emily          | Cognitive Sciences                                      | [The VPNL uses a combination of functional magnetic resonance imaging (fMRI), transcranial magnetic stimulation (TMS), concurrent TMS and electroencephalography (EEG), and psychophysical techniques to isolate the neural correlates of visual perception.](https://vpnl.ss.uci.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Lab](https://vpnl.ss.uci.edu/publications/pubs/)                                                            | +                   |
| Hickok, Gregory          | Cognitive Sciences                                      | [Our interests include psycholinguistics, neuropsychology (aphasia, lesion, Wada, developmental disorders), MEG, and fMRI. Recent work has focused on developing an integrative neurocomputational model of speech production, drawing on constructs from (psycho) linguistics, motor control, neuropsychology, and cognitive neuroscience.](https://sites.uci.edu/alns/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?hl=en&user=wdxCzXoAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Hoffman, Donald D.       | Cognitive Sciences, Logic and Philosophy of Science     | [machine and human vision, visual recognition, artificial intelligence, virtual reality, consciousness and cognition, shape from motion](http://www.cogsci.uci.edu/~ddhoff/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [CV](http://cogsci.uci.edu/~ddhoff/publications.pdf)                                                         | +?                  |
| Krichmar, Jeffrey        | Cognitive Sciences                                      | [In the Cognitive Anteater Robotics Laboratory (CARL) at the University of California, Irvine, we are designing robotic systems whose behaviors are guided by large-scale simulations of the mammalian brain. Because these simulated nervous systems are embodied on a robot, they provide a powerful tool for studying brain function. Moreover, because these cognitive robots are embedded in the real-world, the system's behavior and function can be tested similarly to that of an animal under experimental conditions.](https://www.socsci.uci.edu/~jkrichma/CARL/)                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Lab](https://www.socsci.uci.edu/~jkrichma/publications.html)                                                | +                   |
| Lee, Michael             | Cognitive Sciences                                      | [My research involves the development, evaluation, and application of models of cognition including representation, memory, learning, and decision making, with a special focus on individual differences and collective cognition. Much of my research uses naturally occurring behavioral data, and tries to pursue a solution-oriented approach to empirical science, in which the research questions are generated from real-world problems. My methods involve probabilistic generative modeling, and Bayesian methods of computational analysis.](https://faculty.sites.uci.edu/mdlee/)                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=gbY_w1IAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Liljeholm, Mimi          | Cognitive Sciences                                      | [Our approach is multidisciplinary, drawing on a wide range of methods from psychology, neuroscience, economics, statistics and machine learning. In particular, we combine innovative experimental designs with computational cognitive modeling and functional MRI, to develop formal accounts of neural and psychological processes.](https://faculty.sites.uci.edu/LDNLab/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [Lab](https://faculty.sites.uci.edu/LDNLab/publications/)                                                    | +                   |
| Mednick, Sara            | Cognitive Sciences                                      | [We are specifically interested in translational research questions that lead to improving the lives of people with cognitive impairments. To accomplish this work, we utilize electroencephalography (EEG) and functional magnetic resonance imaging (fMRI) to measure brain activity during sleep and wake. We also use pharmacology and brain stimulation during sleep to improve waking performance. In addition, we use signal processing and computational modeling to reveal patterns in the data not available to the naked eye.](http://sleepandcognitionlab.org/)                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [Lab](http://sleepandcognitionlab.org/#publications)                                                         | +                   |
| Narens, Louis            | Cognitive Sciences, Logic and the Philosophy of Science | [measurement, logic, metacognition](http://www.imbs.uci.edu/~lnarens/narens.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/citations?hl=en&user=4wB25lAAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Neftci, Emre             | Cognitive Sciences                                      | [Bridge ML and neuroscience (Lifelong learning machines); Extracting information from unlabeled data; scalable neuromorphic learning machines; On-line, spike-based deep learning and Stochastic Spiking Neural Networks](http://www.nmi-lab.org/research-topics/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](http://www.nmi-lab.org/pubs_by_name/)                                                                  | +                   |
| Pearl, Lisa              | Language Science, Cognitive Sciences                    | [The main technique of investigation we use is empirically-grounded computational modeling, drawing on constraints from realistic examples of human language and what we know about how humans process language information. Complementary techniques include psycholinguistic methodologies to assess knowledge in children and adults, and human computation methodologies for gathering realistic samples of language use and interpretation.](https://www.socsci.uci.edu/~lpearl/CoLaLab/index.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab -- winner of most organized publications](https://www.socsci.uci.edu/~lpearl/CoLaLab/publications.html) | +                   |
| Peters, Megan            | Cognitive Sciences                                      | [we use neuroimaging and computational modeling to study how brains represent and use uncertain information and uncertainty itself](https://neurocomp.engr.ucr.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Lab](https://neurocomp.engr.ucr.edu/publications.html)                                                      | +                   |
| Pizlo, Zygmunt           | Mathematical Psychology, Cognitive Sciences             | [Our group is studying mental mechanisms (algorithms) involved in cognitive functions. More precisely, we study those cognitive functions that are computationally difficult. A cognitive function is computationally difficult if there is currently no algorithm that can perform this function equally well as the human mind does. This definition includes a lot: perception of shape, motion, color, depth, language understanding, speech recognition, reading, motor control, visuomotor coordination, learning, thinking, problem solving. By studying computationally difficult cognitive functions, we hope to contribute to both: psychology, by understanding cognitive mechanisms, and artificial intelligence, by formulating smart algorithms.](http://bigbird.psych.purdue.edu/index.html)                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=63Oe0c8AAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Richards, Virginia       | Cognitive Sciences                                      | [My research interests include human perception, cognition, and mathematical psychology as applied to the perception of complex sounds. Using psychophysical techniques, we study the rules governing low-level auditory processing and the possible mechanisms by which multiple sound sources are segregated. Recent work has been aimed at the development and testing of multiple-channel models of masking that depend on both energetic and temporal aspects of complex sounds. At present, the goal is to extend this work into the realm of perceptual organization, including "auditory streaming" and the detection of a target pattern of sounds against a background of distracter sounds. Both psychophysical experiments and the allied processing models depend on digital signal processing techniques in which acoustical features are independently varied, allowing the determination of the relative contribution of the different cues as well as the underlying combination rules.](http://hearlab.ss.uci.edu/) | [Google](https://scholar.google.com/scholar?as_ylo=2015&q=%22VM+Richards%22&hl=en&as_sdt=0,5)                | +                   |
| Rouder, Jeffrey          | Mathematical Psychology (chair), Cognitive Sciences     | [We develop new statistical methods to address long-standing questions in cognitive psychology. Our substantive interests are in attention, cognitive control, perception, intelligence, and learning; our methodological interests are in Bayesian hierarchical statistical and process models.](https://sites.uci.edu/specl/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=W5inQnkAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Saberi, Kourosh          | Cognitive Sciences                                      | [We draw from a number of scientific disciplines that include cognitive sciences, neuroscience, computer science, physics, and philosophy. This interdisciplinary approach allows us to capture converging expertise in exploring fundamental questions in the study of consciousness and the nature of reality. We use empirical, theoretical, and computational techniques in our investigations.](http://www.conscioussystemslab.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C5&as_ylo=2015&q=Kourosh+Saberi&btnG=)           | +                   |
| Sarnecka, Barbara        | Cognitive Sciences                                      | [Much of my work over the past 20 years has been about how young children acquire number concepts. But in recent years, I've branched out to work on social cognitive development, the development of judgment and decision making, adult moral psychology, and most recently, scientific writing. (Developing and testing ways to help PhD students and other scientists increase their productivity and write more clearly.)](https://sites.google.com/uci.edu/sarneckalab/people/barbara-w-sarnecka?authuser=0)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=sH0pY84AAAAJ&view_op=list_works&sortby=pubdate)     | +?                  |
| Srinivasan, Ramesh       | Cognitive Sciences                                      | [Our working hypothesis is that cognition involves the interaction between local processes in specific regions of the cortex and global brain networks. We carry out experimental studies using EEG, MEG, TMS, and fMRI on visual and auditory perception and attention, and we use volume conduction and dynamic models to elucidate the neural mechanisms underlying our findings.](http://hnl.ss.uci.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=opgkEvkAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Steyvers, Mark           | Cognitive Sciences                                      | [Learning & Memory; Cognitive Skill Acquisition; Metacognition; Hybrid human-machine algorithm systems; Wisdom of crowds; Bayesian computational modeling; Machine learning; Joint models for behavior and neuroimaging data](https://steyvers.socsci.uci.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=szUb_isAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |
| Vandekerckhove, Joachim  | Cognitive Sciences                                      | [Current projects include quantitative modeling of cognition and individual differences, Bayesian statistics, and implementation and deployment of useful computational algorithms. I am also interested in quantitative approaches of detecting and undoing some of the societal challenges currently faced by psychological science (such as publication bias, fraud detection, and closed access to scientific literature) and in new design and analysis methods.](http://www.cidlab.com/research-topics.php)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [Lab](http://www.cidlab.com/publications.php)                                                                | +                   |
| Wright, Charles E. (Ted) | Cognitive Sciences                                      | [See Chubb, Charlie](https://cwlab.ss.uci.edu/research-areas/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Google](https://scholar.google.com/citations?hl=en&user=EvHWeysAAAAJ&view_op=list_works&sortby=pubdate)     | +                   |

</div>

##### University of California, Los Angeles

- [Admission to UCLA Interdepartmental Ph.D. program in Neuroscience. GRE general test required to: R4837 Field code: 0213](http://neuroscience.ucla.edu/admissions)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Department                                               | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Research                                                                                                 | +/=/- computational |
| ------------------------ | -------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Adhikari, Avishek        | Psychology, Brain Reasearch Institute                    | [We have discovered neural circuits in mice that control specific symptoms of high anxiety states, such as avoidance of risk and increases in heart rate. We also showed how the flow of neural activity in brain circuits control anxiety.](https://adhikarilab.psych.ucla.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed/?term=avishek+adhikari)                                     | +                   |
| Basso, Michele A.        | Semel Institute for Neuroscience and Human Behavior, BRI | [Dr. Basso's work is aimed at understanding how the brain combines memory and sensory information to guide decisions and how these processes are impaired in diseases.](http://neuroscience.ucla.edu/profile/basso-michele)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=YmmvnoYAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Bisley, James            | Neurobiology, BRI                                        | [Dr. Bisley’s research interests revolve around the cognitive processing of visual information, with particular foci on understanding the neural mechanisms underlying the guidance of visual attention, the guidance of eye movements and spatial stability. His lab has also studied visual working memory and he has been involved in implementing haptic feedback for surgical robotics.](http://neuroscience.ucla.edu/profile/bisley-james)                                                                                                                                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=james+bisley&hl=en&as_sdt=0,5)                 | +                   |
| Buonomano, Dean          | Behavioral Neuroscience, Neurobiology, BRI               | [Our research focuses on how neural circuits learn and perform complex computations--such as telling time and temporal processing. Towards this goal our lab uses electrophysiological, optogenetic, computational, and psychophysical techniques.](http://www.buonomanolab.com)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Lab](http://www.buonomanolab.com/publications)                                                          | +                   |
| Golshani, Peyman         | Neurology, BRI                                           | [The mission of our laboratory is to discover how changes in the excitability and connectivity of neuronal ensembles results in autism and developmental epilepsies.](https://golshanilab.neurology.ucla.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/citations?hl=en&user=H-e-YNUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Hong, Weizhe             | Biological Chemistry, Neurobiology                       | [We aim to understand how social behavior is regulated at the molecular and circuit level and how social behavior and social experience lead to molecular and circuit level changes in the brain](http://www.hong-lab.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](http://www.hong-lab.com/publications.html)                                                         | +                   |
| Kao, Jonathan            | Electrical Engineering, BRI                              | [Our research group studies questions at the intersection of neuroscience and computation. In particular, we develop and apply statistical signal processing and machine learning techniques to elucidate how populations of neurons carry out computations in the brain. Further, we also develop experimental and algorithmic techniques for neural engineering applications, including brain-machine interfaces.](https://seas.ucla.edu/~kao/)                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](https://seas.ucla.edu/~kao/pubs.html)                                                              | +                   |
| Masmanidis, Sotiris      | Neurobiology, BRI                                        | [Key questions: What are the dynamics of neural microcircuits during reward-conditioned behavior? What role does the activity of specific microcircuits play in reward-conditioned behavior? How is neural activity and information processing disrupted in models of brain disorders?](https://masmanidislab.neurobio.ucla.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](https://masmanidislab.neurobio.ucla.edu/publications.html)                                         | +                   |
| Mehta, Mayank            | Physics and Astronomy, Neurology,Neurobiology, BRI       | [Key techniques: Develop hardware to measure and manipulate neural activity and behavior; Measure the activity of ensembles of well isolated neurons from many hippocampal and neocortical areas simultaneously during learning and during sleep; Develop data analysis tools to decipher the patterns of neural activity and field potentials, and their relationship to behavior; Develop biophysical theories of synapses, neurons and neuronal networks that can explain these experimental findings, relate them to the underlying cellular mechanisms, and make experimentally testable predictions.](http://www.physics.ucla.edu/~mayank/)                                                                                                                                                                                                                              | [Lab](http://www.physics.ucla.edu/~mayank/publications.html)                                             | +                   |
| Portera-Cailliau, Carlos | Neurology, Neurobiology, BRI                             | [Autism; How are cortical circuits assembled during typical brain development? What are the underlying circuit defects in autism and intellectual disability? What are the best ways to model neuropsychiatric symptoms?](https://porteralab.dgsom.ucla.edu/pages/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [Lab](https://porteralab.dgsom.ucla.edu/pages/publications)                                              | +                   |
| Ringach, Dario           | Psychology, Behavioral Neuroscience, Neurobiology, BRI   | [Our research focuses on visual perception and neurophysiology. In particular, we are interested in cortical dynamics, circuitry, function, and mathematical modeling of the visual system. The main methods in the laboratory include multi-electrode recordings from single neurons, as well as intrisic and voltage senstive dye imaging of visual cortex.](http://neuroscience.ucla.edu/profile/ringach-dario)                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?hl=en&user=V6xKYw4AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Sharpe, Melissa J.       | Psychology                                               | [The lab has a particular interest in how this model building goes awry in schizophrenia. People with schizophrenia are known to exhibit failures in associative learning, characteristically learning to associate events that are not really related or may be irrelevant. This is thought to contribute to the positive symptoms of the disorder, such as hallucinations and delusions, as patients attempt to cognitively rationalize their aberrant learning experience. As a lab, we want to uncover how dysfunction in particular neural circuits contribute to these associative learning deficits, which ultimately lead to positive symptoms of the disorder. The hope is that this work will provide the impetus to develop novel therapeutic compounds targeting these neural circuits to improve quality of life in patients.](https://sharpelab.psych.ucla.edu/) | [Lab](https://sharpelab.psych.ucla.edu/publications/)                                                    | +                   |
| Suthana, Nanthia         | Neurosurgery                                             | [We focus on development of invasive and non-invasive methodologies to restore cognitive functions such as learning, memory and spatial navigation. This research program utilizes methods of deep brain stimulation combined with intracranial recordings of single-unit and local field potentials to characterize and develop neuromodulatory methods of memory restoration in individuals with debilitating memory impairments.](http://mentalhealth.ucla.edu/lonn/)                                                                                                                                                                                                                                                                                                                                                                                                       | [Lab](http://lonn.semel.ucla.edu/?page_id=53)                                                            | =?                  |
| Trachtenberg, Joshua     | Neurobiology, BRI                                        | [But how do novel sensory experiences embed themselves in the fabric of the brain to form memories? This question drives the research in my laboratory, which examines the cellular and synaptic mechanisms of experience-dependent plasticity in the neocortex](https://www.neurobio.ucla.edu/people/joshua-trachtenberg-phd)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/citations?hl=en&user=7KQc7SMAAAAJ&view_op=list_works&sortby=pubdate) | =?                  |
| Wikenheiser, Andrew      | Psychology                                               | [Our lab studies how neural representations support behaviors like decision making. We approach this question by recording the electrical activity of neurons as rats perform behavioral tasks. Electrophysiological techniques are augmented with optogenetics and computational analyses.](https://wikenheiserlab.psych.ucla.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=W1fYwRMAAAAJ&view_op=list_works&sortby=pubdate) | +                   |

</div>

##### University of California San Diego

- [Neurograd program, GRE: Institution(4836) Department(0213), Specify interest in Computational Neuroscience specialization](https://medschool.ucsd.edu/education/neurograd/prospective-students/Pages/default.aspx)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)                                                                     | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Research                                                                                                 | +/=/- computational |
| ------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Abarbanel, Henry                                                               | [(physics) electrophysiological properties of neurons](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/henry-abarbanel.aspx)                                                                                                                                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/citations?hl=en&user=GutIbK0AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Albright, Thomas                                                               | [neural structures and events underlying the perception of motion, form, and color](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/thomas-albright.aspx)                                                                                                                                                                                                                                                                                                                        | [Lab](https://www.salk.edu/scientist/thomas-albright/publications/)                                      | =                   |
| Asahina, Kenta                                                                 | [... employing ... CRISPR/Cas9 genome editing, manipulation of specific neural populations, 2-photon functional imaging, and machine vision-assisted behavioral analyses](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/kenta-asahina.aspx)                                                                                                                                                                                                                                    | [Lab](https://www.salk.edu/scientist/kenta-asahina/publications/)                                        | +                   |
| Bazhenov, Maksim                                                               | [we apply a variety of methods – quantitative experimental techniques, sophisticated mathematical analysis and large-scale computer modeling – to a variety of problems to reveal common features](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/Maksim-Bazhenov.aspx)                                                                                                                                                                                                         | [Lab](https://www.bazhlab.ucsd.edu/publications/)                                                        | +                   |
| Cauwenberghs, Gert                                                             | [VLSI microsystems for adaptive neural computation](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/gert-cauwenberghs.aspx)                                                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=KZQz_7AAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Chalasani, Sreekanth                                                           | [...interested in understanding how neural circuits sense and process information to generate behaviors](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/sreekanth-chalasani.aspx)                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=chalasani+sreekanth&hl=en&as_sdt=0,5)          | +                   |
| Coleman, Todd                                                                  | [Flexible bio-electronics, systems neuroscience, quantitative approaches to understand and augment brain function.](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/todd-coleman.aspx)                                                                                                                                                                                                                                                                                           | [Lab](http://coleman.ucsd.edu/publications)                                                              | +                   |
| de Sa, Virginia                                                                | [We study the computational properties of machine learning algorithms and also investigate what physiological recordings and the constraints and limitations of human performance tell us about how our brains learn](http://www.cogsci.ucsd.edu/~desa/)                                                                                                                                                                                                                                      | [Lab](http://www.cogsci.ucsd.edu/academicPubs/desa/Publications.html)                                    | +                   |
| Gentner, Timothy                                                               | [(Acoustic) We want to know how the brain represents behaviorally important, complex, natural stimuli](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/timothy-gentner.aspx)                                                                                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/citations?hl=en&user=s9_46JoAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Gilja, Vikash                                                                  | [brain-machine interfaces](http://neuro.eng.ucsd.edu/people)                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Lab](http://neuro.eng.ucsd.edu/publications)                                                            | +                   |
| Kleinfeld, David                                                               | [network and computational issues within nervous systems](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/david-kleinfeld.aspx)                                                                                                                                                                                                                                                                                                                                                  | [Lab](http://neurophysics.ucsd.edu/journal_articles.php)                                                 | +                   |
| Komiyama, Takaki                                                               | [neuronal ensembles in behaving animals, BCI, two-photon in vivo](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/takaki-komiyama.aspx)                                                                                                                                                                                                                                                                                                                                          | [Lab](http://labs.biology.ucsd.edu/komiyama/html/publications.html)                                      | +                   |
| Kristan, William                                                               | [study vector calculations, coding/decoding, and control of gain](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/william-klristan.aspx)                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C5&as_ylo=2018&q=Kristan%2C+William&btnG=)   | +                   |
| Mishra, Jyoti                                                                  | [Neurotechnology engineering studies in humans and animals to advance experimental diagnostics and therapeutics for neuropsychiatric disorders.](http://neatlabs.ucsd.edu/index.html)                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=ZUFLEBIAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Mukamel, Eran A.                                                               | [(Epigenomics) Research in our lab uses computational modeling and analysis of large-scale data sets to understand complex biological networks, from the genome to brain circuits](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/eran-mukamel.aspx)                                                                                                                                                                                                                            | [Lab](https://brainome.ucsd.edu/publications.html)                                                       | +                   |
| Navlakha, Saket                                                                | [Algorithms in nature](http://www.algorithmsinnature.org/)                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](http://www.snl.salk.edu/~navlakha/)                                                                | +                   |
| Reinagel, Pamela                                                               | [computational models to explain reward-motivated choice behavior](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/pamela-reinagel.aspx)                                                                                                                                                                                                                                                                                                                                         | [Lab](http://www.ratrix.org/Publications.html)                                                           | +                   |
| <div style="background-color: yellow; color: black;">Sejnowski, Terrence</div> | [(One of the founders of Deep Learning)... To uncover linking principles from brain to behavior using computational models...New techniques have been developed for modeling cell signaling using Monte Carlo methods (MCell)...new methods for analyzing sources for electrical and magnetic signals... from functional brain imaging by blind separation using independent components analysis (ICA)](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/terrence-sejnowski.aspx) | [Lab](http://papers.cnl.salk.edu/index.php?SearchText=Type=Article)                                      | +                   |
| Serences, John                                                                 | [To investigate the influence of behavioral goals and previous experiences on perception and cognition, we employ a combination of psychophysics, computational modeling, and neuroimaging techniques](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/john-serences.aspx)                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=mSaemJkAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Sharpee, Tatyana                                                               | [Our approaches are often derived from methods in statistical physics, mathematics, and information theory](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/tatyana-sharpee.aspx)                                                                                                                                                                                                                                                                                                | [Lab](http://papers.cnl-t.salk.edu/index.php?SearchText=Type=Article)                                    | +                   |
| Silva, Gabriel                                                                 | [(Ophthlmology) In particular, we are interested in the mechanisms that underlie signal and information propagation in biological cellular neural networks, and the computational potential of such networks in the brain](http://www.silva.ucsd.edu/)                                                                                                                                                                                                                                        | [Lab](http://www.silva.ucsd.edu/publications)                                                            | +                   |
| Stevens, Charles F.                                                            | [mechanisms responsible for synaptic transmission](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/charles-stevens.aspx)                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/scholar?as_ylo=2017&q=Charles+stevens+salk&hl=en&as_sdt=0,5)         | +                   |
| Störmer, Viola                                                                 | [...Cognitive and neural mechanisms of human perception, selective attention, and multisensory processing...to understand the computations and processes involved to process these diverse inputs, it is important to consider the full breadth of incoming information](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/viola-stormer.aspx)                                                                                                                                     | [Lab](http://stoermerlab.ucsd.edu/publications)                                                          | +                   |
| Voytek, Bradley                                                                | [focused on combining large scale data-mining and machine-learning techniques with hypothesis-driven experimental research to understand the relationships between the human frontal lobes, cognition, and disease](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/bradley-voytek.aspx)                                                                                                                                                                                         | [Lab](https://voyteklab.com/publications/)                                                               | +                   |
| Yeo, Gene                                                                      | [leader in developing the molecular and cellular resources and robust technologies required for truly large-scale studies of hundreds of RNA binding proteins and their RNA targets](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/gene-yeo.aspx)                                                                                                                                                                                                                              | [Lab](http://yeolab.github.io/papers/)                                                                   | +                   |
| Yu, Angela J.                                                                  | [Computational modeling and psychophysics of attention, learning, and decision-making](https://medschool.ucsd.edu/education/neurograd/faculty/Pages/angela-yu.aspx)                                                                                                                                                                                                                                                                                                                           | [Lab](http://www.cogsci.ucsd.edu/~ajyu/)                                                                 | +                   |

</div>

##### University of California, Santa Barbara

- [DYNS](https://www.dyns.ucsb.edu/people)
- [Graduate School application. Regardless of degree, preference will be given to applicants with undergraduate coursework in biology, chemistry, physics, and mathematics](https://www.graddiv.ucsb.edu/eapp/Login.aspx)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)            | Department                                     | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Research                                                                                                                                                                                                                                                   | +/=/- computational |
| --------------------- | ---------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------- |
| Ashby, Greg           | Psychological & Brain Sciences                 | [Dr. Ashby's approach is to collect a wide varity of empirical data (e.g., from cognitive behavioral experiments, fMRI experiments, and studies with various neuropsychological patient groups), and use these data to develop and test neurobiologically detailed mathematical models](https://www.dyns.ucsb.edu/people/ashby)                                                                                                                                                                                                                                                                                                                                                                   | [Lab](https://labs.psych.ucsb.edu/ashby/gregory/publications)                                                                                                                                                                                              | +                   |
| Carlson, Jean         | Physics                                        | [The Complex Systems group at UCSB, headed by Physics professor Jean Carlson, investigates robustness, tradeoffs, and feedback in complex, highly connected systems, and develops multi-scale models to capture important small-scale details and predict large-scale behavior.](http://web.physics.ucsb.edu/~complex/)                                                                                                                                                                                                                                                                                                                                                                           | [Lab](http://web.physics.ucsb.edu/~complex/publications.html)                                                                                                                                                                                              | +                   |
| Chrastil, Liz         | Geography                                      | [The focus of our research is understanding how the brain supports spatial navigation. We use virtual reality, fMRI, and EEG methods to test questions about the nature of our spatial geometry, why individuals differ so much in their navigational abilities, and how we acquire and use spatial knowledge.](https://www.dyns.ucsb.edu/people/chrastil)                                                                                                                                                                                                                                                                                                                                        | [Lab](https://chrastil.geog.ucsb.edu/node/9)                                                                                                                                                                                                               | +                   |
| Eckstein, Miguel      | Psychological & Brain Sciences                 | [The Vision and Image Understanding Laboratory at the University of California, Santa Barbara pursues computational modeling of behavioral, cognitive neuroscience and physiological data with the aim of elucidating the mechanisms and neural substrates mediating perception, attention and learning.](https://labs.psych.ucsb.edu/eckstein/miguel/)                                                                                                                                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=G5dQztgAAAAJ&view_op=list_works&sortby=pubdate)                                                                                                                                                   | +                   |
| Gazzaniga, Michael    | Psychological & Brain Sciences                 | [The Center integrates a wide range of scholarly endeavors and technologies in the humanities, social sciences and the sciences. These will include, for example, the metaphysics and the philosophy of the mind; methodologies in the social and behavioral sciences; and the relatively recent tools that have been developed in the sciences such as functional neuro-imaging, genetic techniques, computational modeling and immersive virtual environment technology.](https://www.sagecenter.ucsb.edu/about)                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=jpVab-AAAAAJ&view_op=list_works&sortby=pubdate)                                                                                                                                                   | =?                  |
| Giesbrecht, Barry     | Psychological & Brain Sciences                 | [We use a combination of behavioral and neuroimaging techniques (EEG, fMRI) coupled with advanced analytical methods to systematically investigate the dynamics of the perceptual, cognitive, and neural mechanisms of selective attention.](https://www.dyns.ucsb.edu/people/giesbrecht)                                                                                                                                                                                                                                                                                                                                                                                                         | [Lab](https://labs.psych.ucsb.edu/giesbrecht/barry/Attention_Lab/Publications.html)                                                                                                                                                                        | +                   |
| Goard, Michael        | Molecular, Cellular, and Developmental Biology | [To this end, my lab employs large-scale two-photon calcium imaging, multi-unit electrophysiology, and optogenetic manipulation of neural activity in behaving mice. We then use computational approaches to analyze and interpret the data collected from large populations of neurons.](https://www.dyns.ucsb.edu/people/goard)                                                                                                                                                                                                                                                                                                                                                                 | [Lab](https://labs.mcdb.ucsb.edu/goard/michael/publications)                                                                                                                                                                                               | +                   |
| Grafton, Scott        | Psychological & Brain Sciences                 | [Our research emphasizes experiments that elucidate the underlying cognitive architecture that represents action and transforms intentions and goals into specific movements...Data modeling approaches include conventional multivariate methods, machine learning and representational similarity. We also characterize functional data using dynamic community detection algorithms.](https://www.dyns.ucsb.edu/people/grafton)                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=7yJze9oAAAAJ&view_op=list_works&sortby=pubdate)                                                                                                                                                   | +                   |
| Jacobs, Emily         | Psychological & Brain Sciences                 | [he Jacobs Lab is focused on understanding the extent to which sex steroid hormones shape the neural circuitry underlying higher order cognitive functions...](https://jacobs.psych.ucsb.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](https://jacobs.psych.ucsb.edu/publications)                                                                                                                                                                                                          | =?                  |
| Janusonis, Skirmantas | Psychological & Brain Sciences                 | [The brain serotonin matrix and its interaction with other cellular elements; Stochastic processes driving the formation of the ascending reticular activating system; The architectures of early vertebrate brains](https://www.dyns.ucsb.edu/people/janusonis)                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Lab](https://labs.psych.ucsb.edu/janusonis/skirmantas/publications.html)                                                                                                                                                                                  | +                   |
| Kosik, Kenneth        | Molecular, Cellular, and Developmental Biology | [The lab is interested in the underlying molecular basis of plasticity, particularly how protein translation at the synapse affects learning and how impairments of plasticity lead to neurodegenerative diseases.](https://ken-kosik.mcdb.ucsb.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Lab](https://ken-kosik.mcdb.ucsb.edu/publications)                                                                                                                                                                                                        | =?                  |
| Louis, Matthieu       | Molecular, Cellular, and Developmental Biology | [My lab seeks to reveal building blocks of neural computation underlying sensory perception and adaptive decision making...Combining neuronal imaging and perturbation analysis through optogenetics, we generate mechanistic hypothesis about the neural implementation of navigational decisions.](https://www.dyns.ucsb.edu/people/louis)                                                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=UX3e9O0AAAAJ&view_op=list_works&sortby=pubdate)                                                                                                                                                   | +                   |
| Madhow, Upamanyu      | Electrical and Computer Engineering            | [Examples of ongoing projects include multiGigabit millimeter wave communication networks, novel architectures and hardware prototypes for very large scale sensor networks, and target tracking using very simple sensors.](https://wcsl.ece.ucsb.edu/people/upamanyu-madhow)                                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](https://wcsl.ece.ucsb.edu/publications)                                                                                                                                                                                                              | =?                  |
| B.S. Manjunath        | Electrical and Computer Engineering            | [Current research focus is on (a) integration of human and contextual information in analyzing images and video, leading to bio-inspired methods for computer vision;](https://vision.ece.ucsb.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](https://vision.ece.ucsb.edu/publications/by-year?field_subject_tid=All&field_author_value=&field_grant_tid=All&field_project_tid=All&field_lab_value=All&field_target_value=All&nid=&field_pubid_value=&field_vrlid_value=&sortby=by-year&viewtype=) | +                   |
| Miller, Michael       | Psychological & Brain Sciences                 | [His research employs a variety of techniques, including functional magnetic resonance imaging (fMRI), event-related potentials (ERP), transcranial magnetic stimulation (TMS), split-brain studies, and signal detection analysis](https://labs.psych.ucsb.edu/miller/michael/index.html)                                                                                                                                                                                                                                                                                                                                                                                                        | [Lab](https://labs.psych.ucsb.edu/miller/michael/publications.html)                                                                                                                                                                                        | =?                  |
| Moehlis, Jeff         | Mechanical Engineering                         | [We have been developing procedures for determining an optimal electrical deep brain stimulus which desynchronizes the activity of a group of neurons by maximizing the Lyapunov exponent associated with their phase dynamics, work that could lead to an improved "brain control" method for treating Parkinson's disease...Other research interests include the applications of dynamical systems and control techniques to other neuroscience systems, cardiac dynamics, energy harvesting, and collective behavior.](https://www.dyns.ucsb.edu/people/moehlis)                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=qDFqGPQAAAAJ&view_op=list_works&sortby=pubdate)                                                                                                                                                   | +                   |
| Montell, Craig        | Molecular, Cellular, and Developmental Biology | [Using molecular genetic, optogenetic, thermogenetic, electrophysiological, biochemical and cell biological approaches in the fruit fly, Drosophila melanogaster, our laboratory is decoding the receptors, ion channels and neuronal circuits that are critically important in allowing flies to sense the outside world, and impact on decisions ranging from food selection to choosing the ideal thermal landscape, mate selection and others.](https://labs.mcdb.ucsb.edu/montell/craig/)                                                                                                                                                                                                    | [Lab](https://labs.mcdb.ucsb.edu/montell/craig/publications)                                                                                                                                                                                               | +?                  |
| Simpson, Julie        | Molecular, Cellular, and Developmental Biology | [How does the brain control behavior? We study the neural circuits that organize a flexible sequence of movements that remove dust from fruit flies.](https://labs.mcdb.ucsb.edu/simpson/julie/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Google](https://labs.mcdb.ucsb.edu/simpson/julie/publications)                                                                                                                                                                                            | +                   |
| Smith, Spencer L.     | Electrical and Computer Engineering            | [We are exploring population dynamics with single cell resolution to elucidate principles of circuit architecture, dynamics, and computation. We are currently using this technology to explore activity in primary and higher visual cortical areas in mice...To explore cellular and population activity in a context in which behaviorally relevant mechanisms are engaged, we have developed and optimized insturmentation to explore quantitative psychophysical behavior guided by complex visual stimuli...We are exploring the technological headroom in several domains for developing new tools and techniques for neuroscience and other biological applications.](http://slslab.org/) | [Lab](http://slslab.org/#publications)                                                                                                                                                                                                                     | +                   |
| Turk, Matthew         | Computer Science                               | [My primary research interests are in computer vision and imaging, human-computer interaction, machine learning, and augmented reality. I'm also interested in computation models of, and tools for, neuroscience.](http://ilab.cs.ucsb.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [Lab](http://ilab.cs.ucsb.edu/publications)                                                                                                                                                                                                                | +                   |

</div>

##### University of Oregon

- [Computational and Systems Neuroscience](http://ion.uoregon.edu/content/cognitive-computational-and-systems-neuroscience-training-program)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)         | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Research                                                                                                 | +/=/- computational |
| ------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Ahmadian, Yashar   | [(Theoretical Neuroscience)...understanding how large networks of neurons...process sensory inputs and give rise to higher-level cognitive functions through their collective dynamics on multiple time scales](http://ion.uoregon.edu/content/yashar-ahmadian)                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/citations?hl=en&user=ZDaThWgAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Doe, Chris         | [Assembly and function of neural circuits driving larval locomotion in Drosophila... interested in (1) temporal identity programs used to generate an ordered series of neural progeny from a single progenitor, (2) how spatial patterning and temporal identity are integrated to generate heritable neuronal identity, (3) how neuronal progenitors change competence to respond to intrinsic and extrinsic cues over time, and (4) the developmental mechanisms driving neural circuit assembly, with a focus on larval locomotor circuits and adult central complex circuits.](http://ion.uoregon.edu/content/chris-doe-0) | [Lab](http://www.doelab.org/recent-pubs.html)                                                            | +                   |
| Huxtable, Adrianne | [neural control of breathing (the central brainstem and spinal cord networks), with a specific focus on how inflammation ... undermines breathing](http://ion.uoregon.edu/content/adrianne-huxtable)                                                                                                                                                                                                                                                                                                                                                                                                                            | [Lab](https://huxtable.uoregon.edu/publications/)                                                        | =                   |
| Lockery, Shawn     | [nervous system controls behavior by analyzing the neural networks for decision making, focusing on spatial exploration behaviors, and food choice involving trade-offs that mimic human economic decisions](http://ion.uoregon.edu/content/shawn-lockery)                                                                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=x4paaz0AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Mazzucato, Luca    | [Computational models of cortical network function.](https://www.mazzulab.com)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Lab](https://www.mazzulab.com/publications.html)                                                        | +                   |
| Miller, Adam C.    | [Neural circuit wiring, synapse formation, and electrical synaptogenesis in zebrafish](http://ion.uoregon.edu/content/adam-miller)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](http://millerlab.brainbuild.org/publications)                                                      | +                   |
| Niell, Cris        | [Function and development of neural circuits for visual processing](http://ion.uoregon.edu/content/cris-niell)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                                                                                                          | +                   |
| Smear, Matt        | [will pursue general principles of how neural circuits generate behavior](http://ion.uoregon.edu/content/matt-smear)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [Google](https://scholar.google.com/citations?user=nU455D0AAAAJ&hl=en)                                   | +                   |
| Swann, Nicki       | [Studies the motor system in healthy people as well as patients with movement disorders (e.g. Parkinsons), using a combination of invasive and non-invasive electrophysiology.](http://ion.uoregon.edu/content/nicki-swann)                                                                                                                                                                                                                                                                                                                                                                                                     | [Lab](https://swannlab.uoregon.edu/publications/)                                                        | +                   |
| Sylwestrak, Emily  | [understand how heterogeneous, molecularly-defined neuronal populations work together to drive behavior](http://ion.uoregon.edu/content/emily-sylwestrak)                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [Lab](https://www.sylwestraklab.com/papers)                                                              | =                   |
| Washbourne, Philip | [Molecular mechanisms of synapse formation](http://ion.uoregon.edu/content/philip-washbourne)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [Lab](https://blogs.uoregon.edu/washbournelab/publications/)                                             | =                   |
| Wehr, Michael      | [How local circuits in the auditory cortex encode and transform sensory information](http://ion.uoregon.edu/content/michael-wehr)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Lab](http://uoneuro.uoregon.edu/wehr/publications.html)                                                 | +                   |

</div>

##### University of Southern California

- [USC Neuroscience Graduate Program. GRE Average: 155(Verbal), 167(Quant), Institution(4852), Department(0213)](https://ngp.usc.edu/admissions/)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)           | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Research                                                                                                 | +/=/- computational |
| -------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Brocas, Isabelle     | [I combine economic theoretical modeling (optimization based, game theoretic based), computational approaches, and a large variety of experimental methods.](https://dornsife.usc.edu/label/home/)                                                                                                                                                                                                                                                                                                                                                                                                   | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=isabelle+brocas&hl=en&as_sdt=0,5)              | +                   |
| Coricelli, Giorgio   | [Our objective is to apply robust methods and findings from behavioral decision theory to study the brain structures that contribute to forming judgments and decisions, both in an individual and a social context](https://ngp.usc.edu/faculty/?faculty-profile=159)                                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=nEVZSJUAAAAJ&view_op=list_works&sortby=pubdate) | =                   |
| Duncan, Dominique    | Epilepsy, EEG, MRI, Traumatic Brain Injury, Alzheimer's Disease, Applied Harmonic Analysis, Diffusion Geometry, Biomedical Signal Processing, Nonlinear Filtering, Analysis and Modeling of Signals, Statistical Signal Processing, Virtual Reality                                                                                                                                                                                                                                                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=zMF-ELoAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Finley, James M.     | [Dr. Finley's lab develops theoretical models and experiments based on principles of neuroscience, biomechanics, and exercise physiology to identify the factors that guide learning and rehabilitation. Ultimately, the goal of his work is to design novel and effective interventions to improve locomotor control in individuals with damage to the nervous system.](http://lcl.usc.edu/)                                                                                                                                                                                                        | [Lab](http://lcl.usc.edu/publications.html)                                                              | +                   |
| Humayun, Mark S.     | [Electrical stimulation of the retina,Retinal prosthesis, Retinal disease, Instrumentation for vitreoretinal surgery](https://ngp.usc.edu/faculty/?faculty-profile=45)                                                                                                                                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=humayun+mark+s&hl=en&as_sdt=0,5)               | =                   |
| Irimia, Andrei       | [My research involves the use of multimodal neuroimaging (MRI, MRA, PET, CT, EEG, MEG) to understand how traumatic brain injury (TBI) alters brain aging... We integrate brain mapping techniques with machine intelligence and computational biology approaches to investigate how brain connectivity alterations...](http://www.andrei-irimia.com/index.html)                                                                                                                                                                                                                                      | [Lab](http://www.andrei-irimia.com/publications.html)                                                    | +                   |
| Kalluri, Radha       | [First, we study how the hydromechanical properties of the inner ear form the place-frequency map by using non-invasive measurements of inner ear physiology combined with mechanical modeling. Second, using whole-cell patch clamping techniques combined with neuroanatomy and modeling we study the biophysical processes underlying sensory signalling at the first synapse between cochlear sensory cells and the primary auditory neuron.](https://ngp.usc.edu/faculty/?faculty-profile=156)                                                                                                  | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Radha+Kalluri&hl=en&as_sdt=0,5)                | =                   |
| Kim, Hosung          | [NIDLL's research is focused on developing an analytic platform that assesses aging of brain structures and their structural and functional networks. Our scientific mission lies in predicting the eventual long-term outcome for neurodevelopment and quantifying the progression of neurodegeneration.](https://sites.google.com/usc.edu/nidll/research?authuser=0)                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=y2YSIGgAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Kutch, Jason J       | [he AMPL performs basic science and translational research focused on the neural mechanisms for muscle activation, engineering of non-invasive systems to study human motor function, and neuromuscular chronic pain disorders. Of particular interest to the lab are adaptive and maladaptive motor adaptations in individuals with chronic pain, and the brain mechanism of these adaptations.](http://ampl.usc.edu/)                                                                                                                                                                              | [Google](https://scholar.google.com/citations?hl=en&user=QOeSn50AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Mel, Bartlett W.     | [Using computer models to study brain function at single cell and systems levels. Role of active dendritic processing in the sensory and memory-related functions of pyramidal neurons. Neuromorphic models of visual cortex; neurally-inspired approaches to image processing problems.](https://ngp.usc.edu/faculty/?faculty-profile=12)                                                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=OXkq-Z8AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Narayanan, Shrikanth | [SAIL conducts fundamental and applied research in human-centered information processing. Our emphasis is on speech, audio, language, biomedical and multi-modal signal processing, machine learning and pattern recognition.](https://sail.usc.edu/)                                                                                                                                                                                                                                                                                                                                                | [Lab](https://sail.usc.edu/publications/)                                                                | +                   |
| Quadrato, Giorgia    | [The goal of our lab is to improve emerging brain-region specific models of the human brain, including pluripotent stem cell derived 3D organoids and human chimeric mice...](https://quadratolab.usc.edu/research/)                                                                                                                                                                                                                                                                                                                                                                                 | [Lab](https://quadratolab.usc.edu/publications/)                                                         | =                   |
| Read, Stephen J.     | [Neuroscience of Decision-making; Computational models of motivated decision-making; Computational models of personality; Pavlovian Instrumental Transfer in human social behavior](https://dornsife.usc.edu/labs/sandlab/)                                                                                                                                                                                                                                                                                                                                                                          | [Lab](https://dornsife.usc.edu/labs/sandlab/publications/)                                               | +                   |
| Smith, Beth A.       | [Current projects are focused on understanding the relationship between movement experience, movement outcomes and underlying neural control. We are using Opal movement sensors (small, lightweight, synchronized accelerometer /gyroscope /magnetometers) to analyze infant movement experience and movement outcomes through full-day, in-home monitoring](https://sites.usc.edu/inclab/)                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=97mrgpYAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Song, Dong           | [My main research interests are in the fields of computational neuroscience and neural engineering. The overarching goal of my research is to develop brain-like, biomimetic devices that can mimic and restore cognitive functions](https://ngp.usc.edu/faculty/?faculty-profile=783)                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=noJkQ7wAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Swanson, Larry       | [We are interested in the organization of neural networks that control motivated behavior in mammals. The approach is mostly structural, and to display and model results we are developing computer graphics and database approaches](http://larrywswanson.com/)                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=CsQTBwsAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Tao, Huizhong W.     | [We are interested in the architecture of visual cortical circuits. To dissect the circuits that consist of excitatory and inhibitory neurons, we will apply in vivo electrophysiology, in particular two-photon imaging guided recording, to target different types of neurons in rodent visual cortex. From the response properties of individual neurons and the pattern of synaptic inputs to these neurons, we will be able to deduce the connectivity rules governing the construction of cortical circuits](https://ngp.usc.edu/faculty/?faculty-profile=84)                                  | [Lab](https://ngp.usc.edu/faculty/?faculty-profile=84)                                                   | =                   |
| Zhang, Li I          | [As a systems neuroscientist, our ultimate research goal is to decipher the brain circuits, and to understand how perception and behaviors are generated and controlled, how the brain's cortex adapts in response to changes in the dynamic external environment, and how specific changes in cortical functions result in neurological and psychiatric disorders. To address these highly challenging questions, our approach is to resolve the neural circuitry (how neurons are wired in the brain), i.e. the structural basis underlying the brain functions.](https://sites.usc.edu/zhanglab/) | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=LI+Zhang+USC&hl=en&as_sdt=0,5)                 | +                   |

</div>

##### University of Texas, Austin

- [Apply through: GRE: Institutional(6882), Mathematics (GRE: self report on application), Computer Science (No minimum, but high quant), Physics, ECE, Neuroscience, Psychology...](http://ctcn.utexas.edu/apply-students/)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)            | Research Areas                                                                                                                                                                                                                                                                      | Research                                                                                                 | +/=/- computational |
| --------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Goris, Robbe          | [He uses behavioral experiments, computational theory, and monkey electrophysiology to study representation and computation in the primate visual system](http://ctcn.utexas.edu/member/robbe-goris/)                                                                               | [Lab](http://ctcn.utexas.edu/publications/)                                                              | +                   |
| Fiete, Ila            | [uses computational and theoretical approaches to understand the nature of distributed coding, error correction, and dynamical mechanisms that underlie representation and computation in the brain](http://ctcn.utexas.edu/member/ila-fiete/)                                      | [Lab](http://clm.utexas.edu/fietelab/publications.html)                                                  | +                   |
| Geisler, Bill         | [research combines behavioral studies, neurophysiological studies, studies of natural stimuli, and mathematical analysis](http://ctcn.utexas.edu/member/bill-geisler/)                                                                                                              | [Lab](https://liberalarts.utexas.edu/cps/faculty/wsg8#publications)                                      | +                   |
| Huth, Alex            | [Our lab uses quantitative, computational methods to try to understand how the human brain processes the natural world. In particular, we are focused on understanding how the meaning of language is represented in the brain](https://www.cs.utexas.edu/~huth/)                   | [Lab](https://www.cs.utexas.edu/~huth/publications.html)                                                 | +                   |
| Soloveichik, David    | [(molecular programming), theoretical connections between distributed computing and molecular information processing. David is also interested in understanding how neural networks can execute distributed computing algorithms](http://ctcn.utexas.edu/member/david-soloveichik/) | [Google](https://scholar.google.com/citations?hl=en&user=dSPQHDoAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Taillefumier, Thibaud | [We develop novel analytical and algorithmic tools to address questions at the interface of Systems Neuroscience and Applied Mathematics](https://mathneuro.cns.utexas.edu/research)                                                                                                | [Lab](https://mathneuro.cns.utexas.edu/publications)                                                     | +                   |
| Tran, Ngoc Mai        | [probabilistic and combinatorial questions arising from tropical geometry and neuroscience](http://ctcn.utexas.edu/member/ngoc-mai-tran/)                                                                                                                                           | [Lab](https://web.ma.utexas.edu/users/ntran/publications.html)                                           | +                   |

</div>

##### University of Washington, Seattle

- [Computational Neuroscience Center](https://cneuro-web01.s.uw.edu/training-programs/graduate-training-program/)
- Apply to Computer Science and Engineering, Applied Mathematics, Neurobiology and Behavior, Psychology, Physics...


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)          | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Research                                                                                                 | +/=/- computational |
| ------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Bair, Wyeth         | [understand neural circuitry and neural coding in the cerebral cortex with a major emphasis on the primate visual system. We approach this problem by recording directly from neurons in the functioning brain in vivo and by creating and refining large scale spiking neural network models that run on parallel computers](http://depts.washington.edu/neurogrd/people/faculty/wyeth-bair/)                                                                                                                             | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C5&as_ylo=2017&q=W+bair+washington&btnG=)    | +                   |
| Brunton, Bing       | [Data-driven dynamic models of large-scale neural data; Neural computations underlying long-term, naturalistic behavior; Efficient algorithms for closed-loop neuroengineering; Sparse sensors for biological and engineered systems](https://www.bingbrunton.com/research)                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?user=UftAYPkAAAAJ&hl=en)                                   | +                   |
| Buice, Michael      | [identifying and understanding the mechanisms and principles that the nervous system uses to perform the inferences which allow us to perceive the world. I am particularly interested in neural implementations of Bayesian inference and mechanisms by which prior knowledge is encoded as well as the implications that coding efficiency has on the structure of neural circuits](https://alleninstitute.org/what-we-do/brain-science/about/team/staff-profiles/michael-buice/)                                        | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed/?term=Buice+Michael[Author])                                | +                   |
| Chizeck, Howard Jay | [(telerobotics and neural engineering). His telerobotic research includes haptic navigation and control for robotic surgery and for underwater devices, as well as security of telerobotic systems. His neural engineering work involves the design and security of brain-machine interfaces, and the development of assistive devices to restore hand and locomotion capabilities](https://www.ece.uw.edu/people/howard-jay-chizeck/)                                                                                     | [Lab](http://brl.ee.washington.edu/eprints/)                                                             | +                   |
| Koch, Christof      | [biophysical mechanisms underlying neural computation, understanding the mechanisms and purpose of visual attention, and uncovering the neural basis of consciousness and the subjective mind](https://alleninstitute.org/what-we-do/brain-science/about/team/staff-profiles/christof-koch/)                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?user=JYt9T_sAAAAJ&hl=en)                                   | +                   |
| Fairhall, Adrienne  | [theoretical approaches to understand processing in nervous systems. We collaborate closely with experimental labs to uncover algorithms of information processing in a range of systems, from single neurons to foraging mosquitoes to navigating primates](https://fairhalllab.com/)                                                                                                                                                                                                                                     | [Lab](https://fairhalllab.com/publications/)                                                             | +                   |
| Fox, Emily B.       | [large-scale Bayesian dynamic modeling and computations](https://homes.cs.washington.edu/~ebfox/)                                                                                                                                                                                                                                                                                                                                                                                                                          | [Lab](https://homes.cs.washington.edu/~ebfox/publications/)                                              | =                   |
| Kutz, Nathan        | [Theoretical Methods for Characterizing the Brain and Sensory-Motor Processing](https://faculty.washington.edu/kutz/page2/page8/)                                                                                                                                                                                                                                                                                                                                                                                          | [Google](https://scholar.google.com/citations?hl=en&user=kfT42KEAAAAJ&view_op=list_works)                | +                   |
| Mihalas, Stefan     | [he works to build a series of models of increasing complexity for both individual components, i.e., neurons, synapses, and microcircuits, as well as for large portions of the entire system](https://alleninstitute.org/what-we-do/brain-science/about/team/staff-profiles/stefan-mihalas/)                                                                                                                                                                                                                              | [NCBI](https://www.ncbi.nlm.nih.gov/pubmed/?term=Mihalas+Stefan[Author])                                 | +                   |
| Rao, Rajesh         | [Neural networks implemented on Neurochip FPGA; A dynamical systems approach to understanding cortical microcircuits, adaptation and plasticity induction](http://www.csne-erc.org/content/projects)                                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=02nHF0gAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Rokem, Ariel        | [development of data science tools, techniques and methods and their application to the analysis of neural data](https://escience.washington.edu/people/ariel-rokem/)                                                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?user=hrBeLVYAAAAJ&hl=en)                                   | +                   |
| Shea-Brown, Eric    | [nonlinear dynamics of neurons, neural networks, and neural populations](http://faculty.washington.edu/etsb/)                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](http://faculty.washington.edu/etsb/publications.html)                                              | +                   |
| Stocco, Andrea      | [research concerns how human use abstract mental representations (like, rules, instructions, and plans) to perform complex tasks. He uses computational and mathematical models, neuroimaging techniques, and brain stimulation methods determine and predict how these mental representations are encoded in the brain, how they are transformed into behavior, and how this knowledge can be used to improve learning and skill acquisition](http://ilabs.washington.edu/institute-faculty/bio/i-labs-andrea-stocco-phd) | [Lab](http://depts.washington.edu/ccdl/?page_id=63)                                                      | +                   |
| Shlizerman, Eli     | [development of generic computational approaches and modeling actual biological and physical systems](http://faculty.washington.edu/shlizee/)                                                                                                                                                                                                                                                                                                                                                                              | [Lab](http://faculty.washington.edu/shlizee/publications.html)                                           | +                   |
| Witten, Daniela     | [statistical machine learning techniques for problems in genomics and neuroscience](https://faculty.washington.edu/dwitten/research.html)                                                                                                                                                                                                                                                                                                                                                                                  | [Lab](https://faculty.washington.edu/dwitten/research.html)                                              | +                   |

</div>

#### U.S. Central

##### University of Chicago

- [Neuroscience](https://neuroscience.uchicago.edu/faculty)
- [Apply to biosciences. Optional GRE @ Institution(1832).](https://biosciences.uchicago.edu/admissions/how-to-apply)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Research                                                                                                 | +/=/- computational |
| ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Amit, Yali               | [The main focus of my research is the formulation of statistical models for objects. Although not extensively used in computer vision these emerge as a powerful tool in developing recognition algorithms which allow for proper modeling of object and data variability.](https://galton.uchicago.edu/faculty/amit.shtml)                                                                                                                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=yali+amit&hl=en&as_sdt=0,5)                    | ?+                  |
| Awh, Edward              | [We study the interactions between visual working memory and selective attention using psychophysical and electrophysiological methods.](https://awhvogellab.com/people/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Lab](https://awhvogellab.com/publications/)                                                             | ?+                  |
| Bensmaia, Sliman         | [we record neuronal responses, measure the elicited percepts, and develop mathematical models to link the neuronal representations to behavior](http://bensmaialab.org/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Lab](http://bensmaialab.org/publications/)                                                              | +                   |
| Bezanilla, Francisco     | [search for the dynamics of the molecular correlates of the function in membrane transport proteins. This is being approached with physical techniques such as temperature effects and complex capacitance measurements in the frequency domain combined with mutations of the molecule and assessed by gating currents, macroscopic currents and single molecule recordings. The correlation with structural changes are being monitored with optical techniques using real time fluorescence spectroscopy including lifetimes, changes in intensity and fluorescence resonance energy transfer from probes attached to strategic sites in the molecule of interest while being functional in the membrane.](http://nerve.bsd.uchicago.edu/FB/) | [Lab](http://nerve.bsd.uchicago.edu/FB/project.htm#Publication)                                          | +?                  |
| Cacioppo, Stephanie      | [Combining high-performance electrical neuroimaging, algorithms integrating brain source localization, noise suppression and boostrapping with high performance computing, and other methods the Brain dynamics laborator offers cutting edge tools for the study of brain dynamics in social species...Fields: High Performance Computing (HPC), Psychology, Psychiatry, Neurology, and Cognitive and Social Neuroscience.](https://braindynamics.uchicago.edu/)                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=Qm3akmwAAAAJ&pagesize=100&view_op=list_works)   | +                   |
| Carillo, Robert          | [...to understand the molecules and developmental programs that regulate neuronal development and wiring](https://www.carrillolab.com/research-1/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Lab](https://www.carrillolab.com/publications/)                                                         | ?+                  |
| Dawson, Glyn             | [...understand the role of sphingolipids in how our brains work. Our techniques include chromatography, mass-spectrometry, confocal microscropy, DNA manipulation and a range of biochemical and genetic approaches.](https://glyndawsonlab.uchicago.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed/?term=Dawson+g+AND+Chicago[ad]+not+autism+not+psychiatric)  | ?=                  |
| Decety, Jean             | [To characterize the neural underpinnings of fairness and distributive justice, and how they differ or not by cultural environment, we are conducting EEG/ERP studies in the US, France, Mexico and Taiwan.](https://voices.uchicago.edu/childneurosuite/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=fbNxH6UAAAAJ&view_op=list_works&sortby=pubdate) | ?=                  |
| Freedman, David L        | [We use sophisticated neurophysiological techniques to monitor the activity of neuronal ensembles during behavioral tasks which require visual recognition, decision making, and learning. To identify key computational mechanisms used by the brain, we also employ advanced quantitative approaches such as neural network modeling and machine learning.](https://monkeylogic.uchicago.edu/)                                                                                                                                                                                                                                                                                                                                                 | [Lab](https://monkeylogic.uchicago.edu/publications/)                                                    | +                   |
| Hatsopoulos, Nicholas G. | [Our approach has been to simultaneously record neural activity from large groups of neurons using multi-electrode arrays while performing detailed kinematic, kinetic, and muscle measurements of goal-directed, motor behaviors, and to develop mathematical models that relate neural activity with behavior. These mathematical models provide insights as to what aspects of motor behavior are being encoded in cortical neurons, but also can be used to decipher or “decode” neural activity in order to predict movement which has practical implications for brain-machine interface development.](https://pondside.uchicago.edu/oba/faculty/Hatsopoulos/lab/index.html)                                                               | [Lab](https://pondside.uchicago.edu/oba/faculty/Hatsopoulos/lab/#publications)                           | +                   |
| Maunsell, John           | [Our research is aimed at understanding how neuronal signals in visual cerebral cortex generate perceptions and guide behavior. Our approach is to record from individual neurons in trained, behaving monkeys and mice while they perform visual tasks.](https://neurobiology.uchicago.edu/page/john-maunsell)                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=4U1F6tcAAAAJ&view_op=list_works&sortby=pubdate) | =?                  |
| Palmer, Stephanie        | [I study how populations of neurons collectively encode information present in their inputs and how they perform computations on these signals. The brain performs several classes of computation including signal comparison, prediction, error correction, and learning. To investigate these phenomena, I work with experimentalists on a variety of systems: predictive coding in the retina and visual cortex of the rodent, motion coding in area MT, and temporal coding in the zebra finch song system.](https://pondside.uchicago.edu/oba/faculty/palmer_s.html)                                                                                                                                                                        | [Google](https://scholar.google.com/citations?user=0gtvj54AAAAJ&hl=en)                                   | +                   |
| Sheffield, Mark          | [The main goal of our lab is to establish an empirically well-supported unifying model of the neurobiology of complex memory formation and recall from the level of synapses and dendrites to large-scale ensembles of neurons that is based on data obtained from behaving animals engaged in memory-related tasks.](https://sheffieldlab.org/)                                                                                                                                                                                                                                                                                                                                                                                                 | [Lab](https://sheffieldlab.org/publications/)                                                            | =?                  |
| van Drongelen, Wim       | [Epilepsy is a serious neurological disease that affects a large population. To understand the mechanisms underlying this disease we apply an interdisciplinary approach that includes clinical studies from patients with epilepsy, experimental models, computer simulations and mathematical modeling.](https://epilepsylab.uchicago.edu/)                                                                                                                                                                                                                                                                                                                                                                                                    | [Lab](https://epilepsylab.uchicago.edu/page/publications)                                                | +                   |

</div>

##### University of Illinois

- [Computational Neuroscience](https://neuroscience.illinois.edu/research/research-overview/computational-neuroscience)
- [No school or department code for GRE, but GRE required for Neuroscience admission.](https://neuroscience.illinois.edu/admissions/graduate-school-application-0)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)              | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Research                                                                                                 | +/=/- computational |
| ----------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Allen, Jont             | [hearing/acoustics](?)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=sGfS_aUAAAAJ&view_op=list_works&sortby=pubdate) | =                   |
| Fuller, Rebecca (Becky) | My lab is broadly interested in ecology and evolution as it applies to fishes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [Google](https://scholar.google.com/citations?hl=en&user=Y1cDGKYAAAAJ&view_op=list_works&sortby=pubdate) | -?                  |
| Gillette, Rhanor        | [Neuronal mechanisms of decision in circuit, cell, metabolism, and genome; Directed evolution of brain circuits for cognition and sociality; Computational simulations of choice, esthetic sense, and emerging behavioral complexity; Comparative neurobiology of the predatory sea-slug Pleurobranchaea and the octopus](https://neuroscience.illinois.edu/profile/rhanor)                                                                                                                                                                                                                             | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Rhanor+Gillette&hl=en&as_sdt=0,5)              | +                   |
| Llano, Daniel           | [One specific set of issues that we address concerns the role of different cortical subnetworks in complex sound processing. For example, neurons in both cortical layer 5 and cortical layer 6 project to subcortical structures, and the neurons in these layers have very different intrinsic, integrative and synaptic properties. Our work explores the different roles that these groups of neurons play in the processing of complex sound](https://neuroscience.illinois.edu/profile/d-llano)                                                                                                   | [Google](https://scholar.google.com/citations?hl=en&user=wDfcEWIAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Lopez-Ortiz, Citlali    | [Our research is interdisciplinary and involves the areas of dance, biomechanics, mathematical modeling, motor control, motor learning, physics, body-environment interfaces, mixed media, computational neuroscience, neurophysiology, and rehabilitation](http://danceneuroscience.kch.illinois.edu/)                                                                                                                                                                                                                                                                                                 | [Lab](http://danceneuroscience.kch.illinois.edu/research)                                                | +                   |
| Nelson, Mark E.         | [Research in the lab is focused on active sensory acquisition. We seek to understand neural mechanisms and computational principles that animals use to actively acquire sensory information in complex, dynamic environments](https://mcb.illinois.edu/faculty/profile/m-nelson/)                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=wr4PHUUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Vlasov, Yurii           | [Behaviorial paradigms in virtual reality to study neural circuits in almost natural environment while mice are engaged in goal-directed behavior. Virtual reality systems allow full control over behaviorial tasks and quantitative measurements of resulting behavior. Neuroanatomy leveraging new viral, genetic, and computational tools to provide insights into brain circuits functionality. Machine learning based analytical methods to extract dynamical patterns of neural activity that are correlated with animal behavior and choice](https://neuroscience.illinois.edu/profile/yvlasov) | [Lab](https://www.integratedneurotech.com/neuro-informatics)                                             | +                   |

</div>

##### University of Iowa

- [Neuroscience Ph.D.](https://grad.admissions.uiowa.edu/academics/neuroscience-phd)
- [Apply to joint graduate program in neuroscience. No GRE requirement?](https://neuroscience.grad.uiowa.edu/prospective-students)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)             | Department                                                                                                                     | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Research                                                                                                                        | +/=/- computational          |
| ---------------------- | ------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | ---------------------------- |
| Abel, Ted              | Molecular Physiology and Biophysics                                                                                            | [The primary focus of research in the Abel lab is to understand the cellular and molecular mechanisms of long-term memory storage with a focus on the mammalian hippocampus.](https://tedabel.lab.uiowa.edu/research)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=ubOEBGYAAAAJ&view_op=list_works&sortby=pubdate)                        | =?                           |
| Baek, Stephen          | Mechanical & Industrial Engineering                                                                                            | [I’m interested in mathematical representations and algorithms for learning trends and patterns in geometric objects. For my research, I have a lot of fun with photographs, videos, depth images, 3D models/scans, and medical images.](http://user.engineering.uiowa.edu/~sbaek//about.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=dr2krBsAAAAJ&view_op=list_works&sortby=pubdate)                        | + (not so much neuroscience) |
| Boes, Aaron            | Neurology                                                                                                                      | [Our laboratory is interested in the link between brain structure and function across the lifespan, particularly network-based localization of neurological and psychiatric symptoms. We approach this topic using multi-modal neuroimaging methods that include lesion mapping, resting state functional connectivity MRI, and structural MRI.](https://boes.lab.uiowa.edu/neuroimaging-and-noninvasive-brain-stimulation-lab)                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Lab](https://boes.lab.uiowa.edu/publications)                                                                                  | +                            |
| Carmichael, Gregory    | Chemical and Biochemical Engineering                                                                                           | [Air quality and atmospheric chemistry modeling; Data assimilation; Chemical weather forecasting](https://www.engineering.uiowa.edu/faculty-staff/gregory-carmichael)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=MHbvpzAAAAAJ&view_op=list_works&sortby=pubdate)                        | =?                           |
| Casavant, Thomas       | Biomedical Engineering                                                                                                         | [Bioinformatics; Computational biology; Genome sequence analysis; Software tools for human disease mutation identification; Computer architecture; Parallel processing; Distributed computing; Software engineering](https://www.engineering.uiowa.edu/faculty-staff/thomas-casavant)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=4uiMIaEAAAAJ&view_op=list_works&sortby=pubdate)                        | +?                           |
| Chipara, Octav         | Mathematics                                                                                                                    | [Context-Sensitive Assessment of Real-World Listening Situations via Integrated Smartphones and Hearing Aids; Contents and Contexts of Cyberbullying: An Epidemiologic Study using Electronic Detection and Social Network Analysis](https://sites.google.com/site/ochipara/research)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=uBbYp8gAAAAJ&view_op=list_works&sortby=pubdate)                        | =?                           |
| Christensen, Gary E.   | Electrical and Computer Engineering                                                                                            | [My research involves developing new image registration methods for customizing electronic anatomical atlases, automatic segmentation, modeling anatomical shape for the characterization of normalcy and disease, and brain mapping.](https://www.engineering.uiowa.edu/faculty-staff/gary-e-christensen)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=7h--HFoAAAAJ&view_op=list_works&sortby=pubdate)                        | +?                           |
| Cromwell, John W.      | Surgery, Informatics                                                                                                           | [Dr. Cromwell's research group focuses on the application of artificial intelligence, machine learning, predictive analytics, and medical devices to improving the quality and safety of surgical care. Non-invasive devices for predicting postoperative ileus and for screening for delirium are currently undergoing commercialization.](https://medicine.uiowa.edu/surgery/profile/john-cromwell)                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=c4UXAk8AAAAJ&view_op=list_works&sortby=pubdate)                        | +                            |
| Darbro, Benjamin       | Pediatrics                                                                                                                     | [My research concerns the emerging field of genomic medicine. In the clinical laboratory we are interested in how new high throughput technologies can be applied in a clinically appropriate fashion. We are particularly interested in the clinical laboratory application and quality control of whole genome single nucleotide polymorphism (SNP) arrays, comparative genomic hybridization (CGH) arrays and whole genome and/or exome high throughput DNA sequencing. In the research laboratory our focus is on discovering genetic determinants of intellectual disability/cognitive developmental delay as well as recurrent genomic aberrations in both solid tumors and hematopoietic malignancies that can aid in diagnosis, prognosis, and therapeutic decision making.](https://medicine.uiowa.edu/pediatrics/profile/benjamin-darbro)                           | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0,5&q=%22benjamin+darbro%22&scisbd=1)                                  | -?                           |
| Darcy, Isabel K.       | Mathematics                                                                                                                    | Knot theory, DNA Knots, Modelling?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=isabel+k+darcy&hl=en&as_sdt=0,5)                                      | =?                           |
| Dietrich, Bryce        | Political Science                                                                                                              | [Bryce Dietrich’s research uses novel quantitative, automated, and machine learning methods to analyze non-traditional data sources such as audio (or speech) data and video data. He uses these techniques to understand the causes and consequences of elite emotional expressions in a variety of institutional settings, with a particular emphasis on non-verbal cues, such as vocal pitch](https://clas.uiowa.edu/polisci/people/bryce-dietrich)                                                                                                                                                                                                                                                                                                                                                                                                                        | [Lab](http://www.brycejdietrich.com/research.html)                                                                              | +                            |
| Freeman, John          | Psychological and Brain Sciences                                                                                               | [A major focus of our research is to identify neural circuit interactions that contribute to motor learning in rats. We are currently examining interactions between the prefrontal cortex, amygdala, and cerebellum during motor learning. Techniques used in our lab include multiple tetrode recording, multisite recording, optogenetics, DREADDs, functional imaging, various neuroanatomy methods, electrical stimulation, and localized drug infusions in the brain.](https://psychology.uiowa.edu/neuroscience-learning-lab/research)                                                                                                                                                                                                                                                                                                                                 | [Lab](https://psychology.uiowa.edu/neuroscience-learning-lab/publications)                                                      | +?                           |
| Jacob, Mathews         | Electrical and Computer Engineering                                                                                            | [Model Based Deep Learning (We introduce a model-based image reconstruction framework with a convolution neural network (CNN) based regularization prior). Continuous domain compressed sensing (In particular, we reformulate sparse recovery of continuous domain signal as a low-rank matrix completion problem in the spectral domain, thus providing the benefit of sparse recovery with performance guarantees.). Learned image representations for multidimensional imaging. Free breathing & ungated cardiac MRI using manifold models....](http://research.engineering.uiowa.edu/cbig/content/research)                                                                                                                                                                                                                                                              | [Lab](http://research.engineering.uiowa.edu/cbig/content/publications)                                                          | +                            |
| Johnson, Hans          | Electrical and Computer Engineering                                                                                            | [SINAPSE is an interdisciplinary team of computer scientists, software engineers, and medical investigators who develop computational tools for the analysis and visualization of medical image data. The purpose of the group is to provide the infrastructure and environment for the development of computational algorithms and open-source technologies, and then oversee the training and dissemination of these tools to the medical research community.](https://medicine.uiowa.edu/psychiatry/sinapse/)                                                                                                                                                                                                                                                                                                                                                              | [Google](https://scholar.google.com/citations?hl=en&user=QOjKEt0AAAAJ&view_op=list_works&sortby=pubdate)                        | +                            |
| Koylu, Caglar          | Geographical and Sustainability Sciences, Geoinformatics                                                                       | [GIScience, spatial data science, information visualization, human-computer interaction, mobility and geo-social networks](https://clas.uiowa.edu/geography/people/caglar-koylu)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Google](https://scholar.google.com/citations?hl=en&user=sYeUuDQAAAAJ&view_op=list_works&sortby=pubdate)                        | =?                           |
| Magnotta, Vincent A.   | Radiology, Psychiatry, Biomedical Engineering                                                                                  | [I am interested in the development of novel imaging approaches and analysis strategies to better understand psychiatric and neurological brain disorders. My work in image acquisition focuses on diffusion tensor imaging and chemical shift imaging. I am also working on methods to automate the analysis of brain morphology and incorporating these tools into diffusion tensor and chemical shift imaging.](https://medicine.uiowa.edu/radiology/profile/vincent-magnotta)                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?hl=en&user=EguIOioAAAAJ&view_op=list_works&sortby=pubdate)                        | +?                           |
| Michaelson, Jacob J.   | Psychiatry, Neuroscience, Computational and Molecular Psychiatry, Communication Sciences and Disorders, Biomedical Engineering | [We are interested in the use of computing to improve the understanding, diagnosis, monitoring, and treatment of neuropsychiatric and neurodevelopmental conditions. To do this, we build predictive models that draw on a wide variety of data types: including genomics, medical records, imaging, body movement, and standardized test scores, among many others. We have extramurally-supported research programs involving computational methodology, human subjects research, and animal models.](https://michaelson.lab.uiowa.edu/)                                                                                                                                                                                                                                                                                                                                    | [Lab](https://michaelson.lab.uiowa.edu/publications)                                                                            | +                            |
| Nopoulos, Peggy C.     | Psychiatry, Neurology, Pediatrics                                                                                              | [The Peg Nopoulos Laboratory conducts research that is designed to evaluate brain development and its relationship to long term behavioral, cognitive, and emotional outcome. Our studies investigate the impact of various medical conditions throughout the lifespan – from shortly after birth to mature adulthood. In particular, much of our work focuses on inherited brain disease with adult onset.](https://nopoulos.lab.uiowa.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/scholar?as_ylo=2019&q=Peggy+C.+Nopoulos&hl=en&as_sdt=0,5)                                   | -?                           |
| O'Leary, Daniel        | Psychiatry, Psychology                                                                                                         | [Current research explores the neural basis of the genetic vulnerability of children (ages 13 - 18 of alcoholics). Another project assesses the effects of marijuana on brain blood flow and cognition. Both research areas involve purely behavioral assessment of cognitive functions such as attention and memory, as well as neuroimaging studies performed during cognitive task performance. We are assessing blood flow with positron emission tomography (PET) during cognitive task performance in schizophrenic patients, normal volunteers, and marijuana users.](https://medicine.uiowa.edu/psychiatry/profile/daniel-oleary)                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/citations?hl=en&user=bVmokLUAAAAJ&view_op=list_works&sortby=pubdate)                        | -?                           |
| Parker, Krystal L.     | Psychiatry                                                                                                                     | [My long-term goal is to understand the cerebellar contribution to cognitive and affective processes. In pursuit of this goal, I combine neurophysiology, pharmacology and optogenetics in animals performing behavioral tasks to dissect cerebellar neural circuitry. I study the potential for cerebellar stimulation to rescue cognitive impairments and mood in humans using EEG but also in animals with pharmacologically- and genetically-induced phenotypes of disease. My training in psychology, systems neurophysiology, and clinical psychiatry allows me to target the cerebellum for novel treatments of diseases involving cognitive and affective dysfunction.](https://parker.lab.uiowa.edu/)                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=KlAGhpIAAAAJ&view_op=list_works&sortby=pubdate)                        | +                            |
| Paulsen, Jane          | Psychiatry, Neurology, Psychological & Brain Sciences                                                                          | [Huntington’s disease, Alzheimer’s disease, schizophrenia, dementia, psychoses, tardive dyskinesia, neuropsychological features and correlates of the above.](https://psychology.uiowa.edu/people/jane-paulsen)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=mzO_jcQAAAAJ&view_op=list_works&sortby=pubdate)                        | =?                           |
| Schnieders, Michael J. | Biomedical Engineering                                                                                                         | [My research interests are focused on the molecular biophysics theory and high performance computational algorithms that are essential to reducing the time and cost of engineering new pharmaceuticals. A complementary goal is to understand patient specific responses to pharmaceuticals by integrating genetic information and molecular phenotypes.](https://www.engineering.uiowa.edu/sites/www.engineering.uiowa.edu/files/person/cv/michael_j_schnieders_cv.pdf)                                                                                                                                                                                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/citations?hl=en&user=sXWbF2sAAAAJ&view_op=list_works&sortby=pubdate)                        | +                            |
| Shinozaki, Gen         | Psychiatry, Neurosurgery                                                                                                       | [The Shinozaki Laboratory studies the molecular influence of environmental factors such as trauma, stress, and inflammation on individual susceptibility to psychiatric conditions including major depressive disorder (MDD), post-traumatic stress disorder (PTSD), and delirium using epigenetic/genetic approaches as well as a medical engineering approach through device development and machine learning.](https://shinozaki.lab.uiowa.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                           | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed/?term=Shinozaki+G)                                                                 | +                            |
| Sonka, Milan           | Electrical and Computer Engineering                                                                                            | [Research interests include medical imaging, image segmentation, and automated knowledge-based image analysis in a variety of applications and in various image modalities.](http://user.engineering.uiowa.edu/~sonka/research.php)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [Google](https://scholar.google.co.in/citations?hl=en&user=ve3AkSIAAAAJ&view_op=list_works&sortby=pubdate)                      | +                            |
| Srinivasan, Padmini    | Computer Science                                                                                                               | [Information Retrieval & NLP - Text Mining - Web Mining - Biomedical Text Mining - Privacy/Security & Censorship - Social Media Analytics (Politics, Health Beliefs) - Crowdsourcing & Games](http://homepage.cs.uiowa.edu/~psriniva/newsite/index.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | [Lab](http://homepage.cs.uiowa.edu/~psriniva/newsite/papers-page.html)                                                          | -?                           |
| Stewart, David         | Mathematics                                                                                                                    | [Numerical Analysis, Mathematical Modeling, Scientific Computing, Optimization, Optimal Control](http://homepage.divms.uiowa.edu/~dstewart/index.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [Lab](http://homepage.divms.uiowa.edu/~dstewart/des_publns.html)                                                                | -?                           |
| Strathearn, Lane       | Behavioral Pediatrics                                                                                                          | [My lab aims to explore the neurobiology of early attachment relationships using functional MRI and other neurophysiological and endocrine measures. This includes projects examining brain and behavioral responses of drug addicted mothers, and how intranasal oxytocin may impact maternal responses. This research has been funded by the National Institute of Child Health and Human Development and the National Institute of Drug Abuse. We have also published on the effects of intranasal oxytocin on children and adolescents with autism.](https://medicine.uiowa.edu/pediatrics/profile/lane-strathearn)                                                                                                                                                                                                                                                       | [NIH](https://www.ncbi.nlm.nih.gov/sites/myncbi/lane.strathearn.1/bibliography/41163872/public/?sort=date&direction=descending) | -?                           |
| Vaidya, Jatin          | Psychiatry                                                                                                                     | [The laboratory uses state-of-the-art functional imaging tools such as functional magnetic resonance imaging (fMRI) and positron emission tomography (PET) as well as advanced structural imaging protocols (e.g., diffusion weighted imaging) in conjunction with neuropsychological tests and personality assessments.](https://cognitive-brain.lab.uiowa.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.co.in/scholar?as_ylo=2019&q=Jatin+Vaidya&hl=en&as_sdt=0,5)                                      | -?                           |
| Wemmie, John           | Psychiatry, Molecular Physiology and Biophysics, Neurosurgery                                                                  | [John Wemmie, MD, PhD, professor in the Department of Psychiatry at the University of Iowa, is interested in the role of brain pH and acid-sensing ion channels in brain function and behavior. This work has led to the discovery of critical roles for brain pH in synaptic plasticity, anxiety, and depression-related behaviors in mice. Current projects include investigating the synaptic mechanisms for acid-sensing ion channel action and also translating these discoveries to human behavior and brain function. For example, his laboratory is using non-invasive pH-sensitive magnetic resonance imaging to investigate the roles of brain pH in psychiatric illnesses such as panic disorder and bipolar affective disorder.](https://wemmie.lab.uiowa.edu/)                                                                                                   | [Google](https://scholar.google.com/citations?hl=en&user=HEr04BQAAAAJ&view_op=list_works&sortby=pubdate)                        | =?                           |
| Williams, Aislinn      | Psychiatry                                                                                                                     | [The Williams lab is interested in understanding the molecular and cellular mechanisms by which genetic risk factors contribute to psychiatric disease from a developmental perspective. Our current projects focus on voltage-gated calcium channel genes, which have been linked to the risk of developing bipolar disorder, schizophrenia, depression, and autism. We use induced pluripotent stem cells and transgenic mouse models to study how calcium channel gene SNPs alter neuronal development, neural circuit function, and affective behavior. We employ a wide range of approaches, including molecular biology, live cell imaging, neuropathology, and animal behavioral assessments, to try to unravel the developmental pathways involved in neuropsychiatric disease, in the hope of identifying novel treatment targets.](https://williams.lab.uiowa.edu/) | [Lab](https://williams.lab.uiowa.edu/publications)                                                                              | =?                           |

</div>

##### Indiana University

[Cognitive and Computational Neuroscience](https://neuroscience.indiana.edu/research/core-research-areas/cognitive-computational.html)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)                | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Research                                                                                                 | +/=/- computational |
| ------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Beer, Randall D.          | [I work on the evolution and analysis of dynamical "nervous systems" for model agents, neuromechanical modeling of animals, biologically-inspired robotics, and dynamical systems approaches to behavior and cognition. More generally, I am interested in computational and theoretical biology, including models of metabolism, gene regulation and development](http://mypage.iu.edu/~rdbeer/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=F_J8QyAAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Beggs, John M.            | [Our work focuses on understanding how groups of brain cells work together to process information. We approach this topic by using advanced arrays with hundreds of tiny wires to eavesdrop on electrical signals within small pieces of brain tissue. To try and explain how networks of interacting brain cells give rise to patterns of signals, we borrow ideas from statistical physics, where the self-organized patterns of multiple interacting particles have been well-studied.](http://www.beggslab.com/)                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?hl=en&user=y9X4_AkAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Bertenthal, Bennett I.    | [My research focuses on the origins, development, and basic processing mechanisms involved in the perception and representation of actions by social and non-social stimuli.](https://psych.indiana.edu/directory/faculty/bertenthal-bennett.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=RoPQHxEAAAAJ&view_op=list_works&sortby=pubdate) | =                   |
| Betzel, Richard           | [Our work involves analysis of network data at different spatial, temporal, and topological scales. Our goal is to understand the underlying principles that shape the organization and function of biological neural networks.](https://www.brainnetworkslab.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](https://www.brainnetworkslab.com/publications/)                                                    | +                   |
| Brown, Joshua W.          | [The mission of the Cognitive Control Lab is to identify and characterize the neural mechanisms of goal directed behavior. To this end, we focus on the frontal lobes, and especially the medial prefrontal cortex. Our research involves a tight integration of computational neural modeling, functional MRI, and cognitive psychology.](https://ccsrv1.psych.indiana.edu/cclab/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [Lab](https://ccsrv1.psych.indiana.edu/cclab/publications/)                                              | +                   |
| Busey, Thomas             | [visual perception; recognition memory; face recognition EEG analysis of face and object perception; mathematical modeling techniques applied to above domains](http://cognitrn.psych.indiana.edu/busey/HomePage/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Personal](http://cognitrn.psych.indiana.edu/busey/HomePage/pubs.htm)                                    | +                   |
| Farley, Joseph            | [cellular and molecular mechanisms of learning and memory; neurobiology of behavior; excitable membranes/ion channels; neurobiology of nicotine abuse and addiction; molecular bases of signal transduction; computational models of neuronal excitability](https://psych.indiana.edu/directory/faculty/farley-joseph.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C5&as_ylo=2018&q=Joseph+Farley&btnG=)        | +                   |
| Garyfallidis, Eleftherios | [Prof. Garyfallidis is leading a new lab for Neuroengineering at ISE specializing in the developing of new methods and intelligent algorithms for medical imaging and brain mapping with applications to research, clinic and industry.](https://grg.sice.indiana.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [Lab](https://grg.sice.indiana.edu/publications/)                                                        | +                   |
| Izquierdo, Eduardo        | [My research interest is in understanding the neural basis of behavior, as it arises from the interaction between the organism’s nervous system, its body, and its environment. I combine connectome graph analysis, neural network simulations, evolutionary algorithms for optimization, taking into account experimental observations, and mathematical analysis, including information theory and dynamical systems theory, to generate and understand complete brain-body-environment models of simple but biologically and cognitively interesting behaviors.](http://mypage.iu.edu/~edizquie/)                                                                                                                                                                                                                                                            | [Google](https://scholar.google.com/citations?hl=en&user=KWCQjl0AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| James, Thomas W.          | [Object recognition and categorization; Perceptual decision making; Functional neuroimaging; Sensory integration; Visual, somatosensory and auditory perception; Priming, adaptation, and perceptual learning](https://psych.indiana.edu/directory/faculty/james-thomas.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C5&as_ylo=2018&q=Thomas+W.+James&btnG=)      | +                   |
| Jones, Michael            | [Large-Scale Semantic Modeling; Large-Scale Automated Synthesis of Human Functional Neuroimaging Data; Integrating Linguistic and Perceptual Information in Models of Lexical Semantics; Model-Based Guided Retrieval Practice Systems; Understanding linguistic and semantic development via naturalistic child-directed data; Retrieval Operations from Episodic and Semantic Memory...](https://www.compcog.com/)                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Lab](https://www.compcog.com/publications.html)                                                         | +                   |
|                           | [I am interested in the development of statistical methods for the analysis of brain imaging data. My recent or ongoing projects include: High-dimensional outlier detection methods for artifact removal in fMRI data; Empirical Bayes shrinkage estimation of subject-level resting-state functional connectivity; Bayesian spatial modeling in task activation studies using cortical surface fMRI; Empirical Bayesian techniques to account for spatial dependence in fMRI task activation studies; Leveraging big fMRI datasets for estimation of subject-level and group-level resting-state networks through “template” independent component analysis (ICA); Synthesis of quantitative structural MR images (e.g. quantitative T1 maps, DTI, MTR) using conventional sequences (e.g. T1-weighted and FLAIR)](https://mandymejia.wordpress.com/research/) | [Google](https://scholar.google.com/citations?hl=en&user=HS9XWtAAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Newman, Ehren             | [How do neural circuits give rise to human memory? To answer this question, our group combines optogenetics, pharmacology and behavioral manipulations with high-density tetrode and depth-probe recordings of neural activity in awake behaving rats. We are most interested in areas known as the hippocampus, medial septum, and entorhinal cortex which have all been shown to play important roles in memory in humans and animals. We use computational modeling to bridge this experimental work and human memory processing. Our work suggests that neural rhythms allow the brain to code, manipulate and store information and that these dynamics are regulated by acetylcholine.](http://www.iu.edu/~memlab/)                                                                                                                                        | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed?term=Newman%20EL%5BAuthor%5D)                               | +                   |
| Pisoni, David P.          | [Our long-term goal is to provide broad interdisciplinary research training in the Communication Sciences and Disorders and to encourage novel and creative approaches to basic and clinical research problems in Speech, Hearing and Sensory Communication.](http://www.iu.edu/~srlweb/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                                                                                                          | =                   |
|                           | [Cognition and modeling of cognition; Machine learning; Computational Statistics; Learning; Memory; Sensory coding; Information retrieval; Attention and automatism; Organization and structore of memory; Control processes in memory; Decision theory; Optimal decision making; Rationality and reasoning; Vision processing and visual features; Psychological representation, mathematical and computer models of the various content areas listed above.](https://psych.indiana.edu/directory/faculty/shiffrin-richard.html)                                                                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Richard+Shiffrin&hl=en&as_sdt=0,5)             | +                   |
| Sporns, Olaf              | [To make sense of the brain as a complex system we employ a broad range of analysis and modeling techniques, particularly methods coming from computational neuroscience, graph theory, time series analysis, complexity and information theory.](http://www.indiana.edu/~cortex/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=gzPWwdIAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Swanson, William H.       | [Need detailed info](https://optometry.iu.edu/people-directory/swanson-william.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/scholar?hl=en&as_sdt=0%2C5&as_ylo=2018&q=WH+Swanson&btnG=)           | ?                   |

</div>

##### University of Minnesota

- [Computational Neuroscience](http://www.neuroscience.umn.edu/areas-research/computational-neuroscience)
- [Neuroscience graduate admission](http://www.neuroscience.umn.edu/admissions/application-and-admissions-information)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)         | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Research                                                                                                                              | +/=/- computational |
| ------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- | ------------------- |
| Amirikian, Bagrat  | [My current research interests are focused on two related issues: (i) deciphering the local cortical circuitry from the spatial structure of axonal and dendritic arbors of pre- and post-synaptic cell-pairs and their distribution across cortical layers, and (ii) understanding how these local circuits give rise to functional modules, and how they shape the underlying cortical dynamics.](http://www.neuroscience.umn.edu/people/bagrat-amirikian-phd)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed/?term=bagrat+amirikian)                                                                  | +                   |
| Kersten, Daniel    | [My lab uses behavioral and and brain imaging to investigate how the visual pathways of the brain transform image information into useful actions (Bloj et al., 1999, Murray et al., 2002). A major theoretical challenge is to discover the computational principles required to estimate object properties and determine motor output from image features. Computational vision searches for these solutions (Kersten and Yuille, 2003). The experimental challenge is to discover how our visual systems and those of other animals are built to achieve useful actions from the images received.](http://www.neuroscience.umn.edu/people/daniel-j-kersten-phd)                                                                                                                                                                                                                                                                                                            | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed?cmd=PureSearch&term=%28Kersten%20D%5BAuthor%5D%20%20AND%20%20%28%22minnesota%22%29%29)   | +                   |
| Lim, Hubert        | [The goal of my lab is to push the development and translation of brain-machine interfaces from scientific concept into clinical application with close collaboration with clinicians and industry. Brain-machine interfaces span a broad array of applications and consist of either direct connection of a device to neurons within the brain or neural communication through noninvasive techniques, such as EEG recordings and transcranial magnetic stimulation.](http://www.neuroscience.umn.edu/people/daniel-j-kersten-phd)                                                                                                                                                                                                                                                                                                                                                                                                                                           | [PubMed](http://www.neuroscience.umn.edu/people/hubert-lim-phd)                                                                       | -                   |
| Olman, Cheryl      | [Employing a combination of visual psychophysics and fMRI, I want to determine how detection of local image features interacts with scene perception. How are local features in an image selected and grouped to construct a mental representation of a scene or object? To what extent do internal templates determine feature selection and shape perception?](http://vision.psych.umn.edu/users/caolman/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [PubMed](https://www.ncbi.nlm.nih.gov/myncbi/browse/collection/45113341/)                                                             | =                   |
| Redish, David      | [I am interested in questions of how neural structures work together to create systems able to accomplish behavioral tasks. Our primary current projects are in the interaction between multiple learning systems (such as hippocampus, cortex, and striatum) in the ability to make decisions, particularly deliberative decisions.](http://www.neuroscience.umn.edu/people/david-redish-phd/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [PubMed](https://www.ncbi.nlm.nih.gov/myncbi/browse/collection/41152826/?sort=date&direction=ascending)                               | +                   |
| Schrater, Paul     | [My research interests include human and computer vision, planning and guiding reaches with and without visual information, and the integration of visual, haptic, and motor information during the perception-action cycle. My research approach treats problems in vision and motor control as problems of statistical inference, which has led to a concurrent interest in statistical methods that includes Bayesian (Belief) Networks, Dynamic Markov Decision Networks, Pattern Theory, Machine Learning, and other topics in statistics and pattern recognition.](http://www.neuroscience.umn.edu/people/paul-schrater-phd)                                                                                                                                                                                                                                                                                                                                            | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed?cmd=PureSearch&term=%28Schrater%20PR%5BAuthor%5D%20%20AND%20%20%28%22minnesota%22%29%29) | +                   |
| Vinogradov, Sophia | [Dr. Sophia Vinogradov directs a translational clinical neuroscience laboratory that focuses on cognitive dysfunction in schizophrenia. In collaboration with basic scientists, she studies neuroscience-informed computerized cognitive training exercises for patients with schizophrenia that aim to drive enduring plastic changes in cortical processing. The training programs utilize adaptive algorithms to adjust the difficulty level to maintain a 70-80% correct performance rate, allowing for a customized approach to each individual’s initial performance level and progress rate. Spanning several aspects of cognitive functioning, the exercises fine tune sensory processing speed, working memory, and attention as well as higher-order cognitive processes. In turn, this results in significant improvements in untrained cognitive skills as well as improvements in quality of life.](http://www.neuroscience.umn.edu/people/sophia-vinogradov-md) | [Google](https://scholar.google.com/citations?user=kbU8I1UAAAAJ&hl=en)                                                                | +                   |
| Wilcox, George     | [Dr. Wilcox and colleagues are engaged in research into the spinal neurotransmission of pain and mechanisms underlying hyperalgesia, analgesia and analgesic tolerance. Studies of both excitatory and inhibitory neurotransmission in the rodent spinal cord apply behavioral, lectrophysiological (both in vivo and in vitro), immunocytochemical and molecular techniques. Dr. Wilcox facilitates access for Neuroscience students to high performance computing laboratories on campus: The Laboratory for Computational Science & Engineering and The Minnesota Supercomputer Institute (MSI). High performance computers and visualization are now finding applications in biological imaging, macromolecular modeling and neuronal simulation.](http://www.neuroscience.umn.edu/people/george-l-wilcox-phd)                                                                                                                                                            | [PubMed](http://www.neuroscience.umn.edu/people/george-l-wilcox-phd)                                                                  | +                   |
| Zilverstand, Anna  | [Dr. Zilverstand is a psychologist and neuroimaging expert, faculty in the Department of Psychiatry and Behavioral Science and member of the Medical Discovery Team on Addiction. She leads an interdisciplinary team focused on investigating how individual differences contribute to human drug addiction. Her research group analyzes existing large-scale multimodal data sets, in addition to acquiring their own data by employing a variety of techniques such as interviewing, neurocognitive testing, questionnaires and multi-modal neuroimaging. Novel computational methods are employed for linking social, demographic, neurocognitive, personality and clinical measures to the neuroimaging data, to explore the existence of neurobiological subtypes within the addicted population.](http://www.neuroscience.umn.edu/people/anna-zilverstand-phd)                                                                                                         | [Google](https://scholar.google.com/citations?user=jg5A1hwAAAAJ&hl=en)                                                                | +                   |
| Zimmerman, Jan     | [The primary research goal of the Z-LAB is to better understand decision making. Making a choice, independent of it being a complex decision about your retirement allocations or which flavor of ice-cream to pick, is the normative consequence of any behavior that is observable. To understand this process, we combine a multitude of tools that allow us to study neural function of non human primates associated to decision making. We combine single cell electrophysiology, computational modeling of neural responses as well as careful behavioral analysis and ultra high field functional magnetic resonance imaging.](http://www.neuroscience.umn.edu/people/jan-zimmermann-phd)                                                                                                                                                                                                                                                                             | [Google](http://www.neuroscience.umn.edu/people/jan-zimmermann-phd)                                                                   | +                   |

</div>

#### U.S. East

##### Boston University

- [Computational Neuroscience](https://www.bu.edu/neuro/academics/graduate/curriculum/computational-neuroscience/)
- [Apply directly through the Graduate Portal for Neuroscience](https://www.bu.edu/neuro/apply/request-for-application-materials/)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)                   | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Research                                                               | +/=/- computational |
| ---------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------- | ------------------- |
| Chandrasekaran, Chandramouli | [Understanding how the primate brain makes decisions based on sensory input and guides limb movement. Extensive evidence from stroke patients and physiological/lesion studies in humans suggest that a part of the brain called the dorsal premotor cortex is involved in selecting the appropriate limb movement on the basis of the sensory input.](http://sites.bu.edu/chandlab/)                                                                                                                                   | [Google](https://scholar.google.com/citations?user=3Yeb98kAAAAJ&hl=en) | +                   |
| Eden, Uri                    | [Developing mathematical and statistical methods to analyze neueral spiking activity by developing a methodological, statistical framework and applying them to point process observations.](http://www.bu.edu/math/people/faculty/probability-and-statistics/eden/)                                                                                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?user=M8rzdnwAAAAJ&hl=en) | +                   |
| Kon, Mark                    | [Quantum probability and information, bioinformatics, machine and statistical learning, mathematical physics, mathematical and computational neuroscience, complexity theory, and wavelets.](http://math.bu.edu/people/mkon/)                                                                                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?user=wVPc21cAAAAJ&hl=en) | +                   |
| Kopell, Nancy                | [Understanding how the dynamical properties of local networks help to filter and transform the patterned input form other parts of the nervous system, to provide clues to the function of dynamics in the nervous system.](https://www.bu.edu/eng/profile/nancy-kopell-ph-d/)                                                                                                                                                                                                                                          | [Google](https://scholar.google.com/citations?user=mbDmBBsAAAAJ&hl=en) | -                   |
| Kramer, Mark                 | [His research focuses on interdisciplinary topics in mathematical neuroscience with particular emphasis on biophysical models of neural activity and data analysis techniques. He is currently interested in medical applications and networks in neuroscience.](https://www.bu.edu/math/people/faculty/mathematical-biology-and-neuroscience/kramer/)                                                                                                                                                                  | [Google](https://scholar.google.com/citations?user=gn4NeQkAAAAJ&hl=en) | +                   |
| Scott, Ben                   | [Develop and apply new technologies to study the neural basis of cognition and complex learned behavior through biomedical engineering, particularly the development of novel optical imaging and genetic methods to observe and perturb the activity of neurons in their native habitat – the intact brains of living organisms - and neuroethology, the study of brain circuits that underlie natural behaviors in order to elucidate basic principles of brain function.](https://www.bu.edu/csn/profile/ben-scott/) | [Lab](https://www.scottcognitionlab.com/publications)                  | -                   |

</div>

##### Brandeis University

- [Ph.D. GREs not required. Letters of recommendation are important.](https://www.brandeis.edu/neuroscience/graduate/apply/index.html)
- See also: [Sloan-Swartz Center for Theoretical Neuroscience](http://www.bio.brandeis.edu/sloan/index.html)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)          | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Research                                                                                                   | +/=/- computational |
| ------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------- | ------------------- |
| Epstein, Irving     | [The overall goal of our research is to understand, design and control chemical systems that exhibit complex, nonlinear, dynamic behavior in time and space. This behavior includes periodic oscillation, chaos, wave propagation and pattern formation. Such systems may have important applications to, or provide insights into, related phenomena in biology, physics, mathematics, polymer and materials science. We employ a variety of techniques, both experimental and theoretical, in our work.](http://hopf.chem.brandeis.edu/)                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=YZxj3HwAAAAJ&view_op=list_works&sortby=pubdate)   | +                   |
| Jadhav, Shantanu    | [The Jadhav Lab integrates behavior, electrophysiology, optogenetics and computational analysis to investigate the neural basis of learning, memory and decision making in the mammalian brain.](http://www.bio.brandeis.edu/jadhavlab/index.html)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Lab](http://www.bio.brandeis.edu/jadhavlab/publications.html)                                             | +                   |
| Katz, Don           | [We study the neural ensemble dynamics of sensori-motor processes in awake rodents, combining behavior, multi-neuronal electrophysiology, complex analysis and modeling, pharmacology and optogenetics to probe ongoing spiking activity in real-time](https://sites.google.com/a/brandeis.edu/katzlab/)                                                                                                                                                                                                                                                                                                                                                                                                                                           | [Google?](https://scholar.google.com/scholar?as_ylo=2018&q=Donald+B.+Katz+Brandeis&hl=en&as_sdt=0,5)       | +                   |
| Marder, Eve         | [How do neuromodulators and neuromodulatory neurons reconfigure circuits so that the same group of neurons can produce a variety of behaviorally relevant outputs? How can networks be both stable over the lifetime of the animal despite ongoing turnover of membrane proteins such as channels and receptors? How is network stability maintained over long time periods? To what extent do similar network outputs result from different underlying mechanisms or solutions?. How variable are the sets of parameters that govern circuit function across animals? How can animals with disparate sets of circuit parameters respond reliably to perturbations such as neuromodulators and temperature?](http://blogs.brandeis.edu/marderlab/) | [Lab](http://blogs.brandeis.edu/marderlab/publication/)                                                    | +                   |
| Miller, Paul        | [Quasi-stable attractor states as a framework for neural computing...Learning and Solving Associative Cognitive Tasks...Parametric Working Memory and Sequential Discrimination...Molecular basis of long-term memory](http://www.brandeis.edu/facultyguide/person.html?emplid=e155804f5e9e6a843dab5395a623718200ad54b8)                                                                                                                                                                                                                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=ZdwhFVYAAAAJ&view_op=list_works&sortby=pubdate)   | +                   |
| Touboul, Jonathan   | [My approach often involves data analysis, simplified mathematical models, computer simulations and theoretical and mathematical analysis, using dynamical systems and probability. And in this program, I enthusiastically collaborate with experimentalists, mathematicians and physicists!](https://www.brandeis.edu/facultyguide/person.html?emplid=8cb81567ab262202223ac427c8e768ea4efad6b0)                                                                                                                                                                                                                                                                                                                                                  | [Google ?](https://scholar.google.com/citations?hl=en&user=t_YFoiUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Van Hooser, Stephen | [In the Neural Circuits Lab, we apply a new generation of optical and optogenetic tools to observe both fine-scale circuit features and systems-level responses at the same time, in the living brain. We combine these optical approaches with advanced physiological and anatomical techniques to address previously inaccessible questions about neural circuitry and its development in mammalian visual cortex.](http://www.vhlab.org/)                                                                                                                                                                                                                                                                                                       | [Google](https://scholar.google.com/citations?hl=en&user=H3vXtAUAAAAJ&view_op=list_works&sortby=pubdate)   | +                   |

</div>

##### Brown University

- [Computational Neuroscience](http://neuroscience.brown.edu/graduate/faculty/computational)
- [For all departments, apply generally to Brown Graduate school. GRE @ Institution(3094). For Brown University School of Public Health @ Institution(7765). Neuroscience @ Departmnent(0213). Applied Math ?.](https://www.brown.edu/academics/gradschool/apply)
- [For NIH/Neuroscience also fill out the NIH Partnership Application](https://www2.training.nih.gov/apps/publicForms/gpp/forms/login.aspx)
- [See Behavioral Neuroscience Requirements](https://www.brown.edu/academics/cognitive-linguistic-psychological-sciences/prospective-graduate-students)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Research                                                                                                 | +/=/- computational |
| ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Bienenstock, Lucien Elie | [My research is in theoretical neuroscience, computational vision, and computational linguistics. I study the mechanisms used by brains to create and work with complex, detailed, hierarchical representations of the external world](https://vivo.brown.edu/display/lbienens#Research)                                                                                                                                                                                                                                                                                                                                                                                             |                                                                                                          | +                   |
| Connors, Barry           | [We discovered that inhibitory neurons in the cortex communicate via electrical synapses, and that electrically coupled networks of neurons can serve as pacemakers for cortical rhythms in the brain. We are also studying how neural activity leads to plasticity of cortical circuits, and how the seizure discharges of epilepsy begin and propagate through the cortex. Our methods include intracellular and extracellular recording and patch clamping, neuroanatomical techniques, isolated slice preparations, optogenetics, and computer modeling.](https://vivo.brown.edu/display/bconnors#Research)                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=whbW9AQAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Cooper, Leon             | [Leon Cooper studies neural networks, including architecture, learning rules, and real world applications; the biological basis of memory and learning; mean field theories; the foundations of quantum theory; and superconductivity.](https://vivo.brown.edu/display/lcooper#Research)                                                                                                                                                                                                                                                                                                                                                                                             |                                                                                                          | +                   |
| Donoghue, John P.        | [Our laboratory investigates how the brain turns thought into voluntary behaviors and how that knowledge can be used to help persons with paralysis. We study how populations of neurons represent and transform information as a motor plan becomes movement. This approach has required the creation of a novel recording array to study neural ensembles. With the knowledge we have gained about movement representation, we have translated our findings to a clinical application in which humans with paralysis can use their neurons directly to control devices.](https://vivo.brown.edu/display/jdonoghu#Research)                                                         | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=John+Donoghue+brain&hl=en&as_sdt=0,5)          | +                   |
| Frank, Michael           | [My research combines multiple levels of computational modeling and experimental work to understand the neural mechanisms underlying reinforcement learning, decision making and cognitive control. We develop neural circuit and algorithmic models of systems-level interactions between multiple brain areas (primarily prefrontal cortex and basal ganglia and their modulation by dopamine). We test theoretical predictions of the models using various neuropsychological, pharmacological, genetic, and imaging techniques.](https://vivo.brown.edu/display/mjfrank)                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=f-xyFpUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Geman, Stuart            | [My hypothesis is that the dual principles of re-usability and hierarchy, or what cognitive scientists call compositionality, form the foundation for efficient learning in biological systems; Statistical methods are being devised to support the systematic search for fine-temporal structure in stable multi-unit recordings; These spatio-temporal patterns, with their correlation-induced topologies, would be good candidates for the basic units of cognitive processing...](http://www.dam.brown.edu/people/geman/)                                                                                                                                                      | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=geman+stuart&hl=en&as_sdt=0,5)                 | +                   |
| Hochberg, Leigh          | [Our Laboratory for Restorative Neurotechnology focuses on developing strategies to restore communication, mobility, and independence for people with paralysis or limb loss. In addition to endeavors related to the pilot clinical trial of the BrainGate2 Neural Interface System, we are interested in understanding human intracortical neurophysiology during the planning and production of voluntary movement, and understanding neuronal ensemble function in a variety of neurologic diseases or injuries. Our lab is also engaged in stroke neurorecovery research.](https://vivo.brown.edu/display/lhochber)                                                             | [Lab](https://vivo.brown.edu/display/lhochber#Publications)                                              | +                   |
| Jones, Stephanie         | [The Jones Lab combines experimental and theoretical techniques to study human brain dynamics. Our mission is to develop biophysically principled computational models of neural circuits that bridge electrophysiological measures of brain function to the underlying cellular and network level dynamics. We aim to translate an understanding of the network mechanism underlying measured brain signals into strategies to improve disrupt function.](https://blogs.brown.edu/joneslab/)                                                                                                                                                                                        | [Google](https://scholar.google.com/citations?hl=en&user=H2lcpR0AAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Nurmikko, Arto           | [developing means to record from the brain of primates by employing implantable fully wireless, microelectronically active neural signal probes, with the goal of ‘reading out’ large numbers of individual neurons from different brain microcircuits in real time; developing novel optoelectronic devices as bidirectional brain interfaces and employing these devices in combination with so-called optogenetic methods to study brain function both in vivo and in vitro.; developing a dual-function brain implantable microscale chip which combined both “readout” (by electrical or possibly optical means) and “write-in”...](http://nurmikko.engin.brown.edu/?q=node/43) | [Lab](http://nurmikko.engin.brown.edu/?q=node/10)                                                        | +                   |
| Paradiso, Michael        | [The aims of Dr. Paradiso's research are to elucidate the encoding of visual information in cerebral cortex, the computations performed by interacting neurons, and the adaptive use of neural circuitry, with the goal of understanding the mechanisms underlying human visual perception.](https://vivo.brown.edu/display/mparadis#Research)                                                                                                                                                                                                                                                                                                                                       | [Lab](https://vivo.brown.edu/display/mparadis#Publications)                                              | +                   |
| Serre, Thomas            | [My lab seeks to understand the neural computations supporting visual perception. There is little doubt that even a partial solution to the question of which computations are carried out by the visual cortex would be a major breakthrough: It would begin to explain one of our most amazing abilities, vision; and it would open doors to other aspects of intelligence such as language, planning or reasoning.](http://serre-lab.clps.brown.edu/)                                                                                                                                                                                                                             | [Lab](http://serre-lab.clps.brown.edu/publications/)                                                     | +                   |
| Sheinberg, David         | [Research in my lab explores how we identify objects and events in the real world, where both the observer and the environment change over time.](http://charlotte.neuro.brown.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=David+Sheinberg&hl=en&as_sdt=0,5)              | +                   |
| Truccolo, Wilson         | [Collective neural dynamics in neurological disorders (epilepsy, stroke, ALS, spinal cord injury); Stochastic processes and random dynamical systems for multi-scale neural dynamics; Subsampling and spatiotemporal coarse graining of collective neural dynamics; Statistical algorithms for closed-loop neuromedical systems: Tracking, prediction & control of brain dynamics in neurological disorders](https://www.truccololab.com/)                                                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=gaKfE5MAAAAJ&view_op=list_works&sortby=pubdate) | +                   |

</div>

##### Carnegie Mellon University and University of Pittsburgh

- [Computational Neuroscience](http://www.cnbc.cmu.edu/training/graduate/computational-neuroscience/)
- [Ph.D. in Neural Computation. GRE not required but Institution(0274) and Department(0213).](http://compneuro.cmu.edu/)
- [Applications open during submission times](https://applygrad.cs.cmu.edu/apply/offline.php)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)               | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Research                                                                                                 | +/=/- computational |
| ------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Ahmari, Susanne          | [How do molecular and circuit changes in the brain cause psychiatric illness? And how can we leverage the inherent plasticity of the brain to treat psychiatric disorders?](https://pre.cnup.pitt.edu/people/ant)                                                                                                                                                                                                                                                                                                                                                                                   | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=Susanne+E.+Ahmari&hl=en&as_sdt=0,5)            | =                   |
| Anderson, John R.        | [We have taken on modeling the cognitive competences that are taught in the domains of mathematics, computer programming, and cognitive psychology.](http://act-r.psy.cmu.edu/peoplepages/ja/ja-interests.html)                                                                                                                                                                                                                                                                                                                                                                                     | [Google](https://scholar.google.com/citations?hl=en&user=PGcc-RIAAAAJ&view_op=list_works&sortby=pubdate) | +?                  |
| Barth, Alison            | [Research in the Barth Lab is focused on understanding how experience assembles and alters the properties of neural circuits in the cerebral cortex, in both normal and disease states...In addition, researchers in the lab are using electrophysiological recordings, electron microscopy, and computational modeling to understand how functional networks are constructed and optimized in the neocortex.](https://www.bio.cmu.edu/labs/barth/index.html)                                                                                                                                       | [Lab](https://www.bio.cmu.edu/labs/barth/publications.html)                                              | +                   |
| Batista, Aaron           | [Flexibility and constraints in learning and cognition. Improving brain-computer interfaces. Sensory-motor coordination.](https://smile.pitt.edu/)                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=kKE_lJUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Behrmann, Marlene        | [The major approach I use to address these questions is to study the behavior of human adults who have sustained brain damage (usually through stroke or head injury) which selectively affects their ability to carry out these processes... simulations of artificial neural networks which may be used to model these processes and their breakdown following brain-damage; and functional neuroimaging studies which examine the biological substrate of high-level vision.](https://www.cmu.edu/dietrich/behrmannlab/)                                                                         | [Lab](https://www.cmu.edu/dietrich/behrmannlab/Publications/index.html)                                  | +                   |
| Chase, Steven            | [Broadly speaking, my laboratory investigates how sensory feedback impacts the neural representation of motor intent. One of the major tools we use is the brain-computer interface (BCI)... My research has two main thrusts. First, I develop novel computational and experimental techniques that leverage BCIs as a research tool for investigating the neural mechanisms of sensorimotor adaptation and skill acquisition. Second, I design new BCI decoding algorithms to enhance the performance of these devices and hasten their clinical translation.](http://www.cnbc.cmu.edu/~schase/)  | [Lab](http://www.cnbc.cmu.edu/~schase/publications.php)                                                  | +                   |
| Cohen, Marlene           | [We are interested in how we use vision to gather information about the world and decide how to act. As primates, we perceive the world primarily through our eyes...We use a combination of single and multi-electrode electrophysiology, psychophysics, and computational techniques.](http://www.cohenlab.com/)                                                                                                                                                                                                                                                                                  | [Lab](http://www.cohenlab.com/publications.html)                                                         | +                   |
| Coutanche, Marc          | [Our lab works at the intersection of neuroscience and psychology, drawing on learning, memory consolidation, sleep, perception, and computer science.](http://thelenslab.org/)                                                                                                                                                                                                                                                                                                                                                                                                                     | [Lab](http://www.mcoutanche.com/publications.html)                                                       | +                   |
| Creswell, David          | [David’s research focuses broadly on understanding what makes people resilient under stress. Specifically, he conducts community intervention studies, laboratory studies of stress and coping, and neuroimaging studies to understand how various stress management strategies alter coping and stress resilience.](https://www.cmu.edu/dietrich/psychology/people/core-training-faculty/creswell-david.html)                                                                                                                                                                                      | [Google](https://scholar.google.com/citations?hl=en&user=UzpIzvEAAAAJ&view_op=list_works&sortby=pubdate) | -?                  |
| Danks, David             | [My research largely falls at the intersection of philosophy, cognitive science, and machine learning, using ideas and frameworks from each to inform the others. My primary research in recent years has been in computational cognitive science: developing fully-specified computational models to describe, predict, and most importantly, explain human behavior (in causal cognition, concepts and categories, and most recently, linguistics).](https://www.cmu.edu/dietrich/philosophy/people/faculty/danks.html)                                                                           | [Google](https://scholar.google.com/citations?hl=en&user=1lORpNsAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Doiron, Brent            | [Theoretical Neuroscience. Cellular and synaptic dynamics; Network dynamics and neural coding; Cognitive processing](http://www.math.pitt.edu/~bdoiron/)                                                                                                                                                                                                                                                                                                                                                                                                                                            | [Google](https://scholar.google.com/citations?hl=en&user=2o_bzEUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Eddy, William F.         | [In the last couple of years I have become keenly interested in the statistical problems associated with fMRI. A typical fMRI experiment run by a cognitive psychologist produces as much as 1 gigabyte of data per hour. The computational challenges are obvious.](http://www.stat.cmu.edu/GSS/eddy.html)                                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/scholar?as_ylo=2018&q=William+F.+Eddy&hl=en&as_sdt=0,5)              | +?                  |
| Erickson, Kirk           | [In The Brain Aging & Cognitive Health Lab we investigate how the mind and brain change with age and the factors that promote successful aging. To do this, we use a variety of neuropsychological assessments, genetic testing, physical fitness testing, magnetic resonance imaging (MRI) and positron emission tomography (PET).](http://bachlab.pitt.edu/people/kirk-erickson-phd)                                                                                                                                                                                                              | [Lab](http://bachlab.pitt.edu/publications)                                                              | =?                  |
| Ermentrout, Bard G.      | [Olfactory Navigation;Dynamics and phase resetting;Pattern formation in neural systems;Waves and persistent states in neural systems; Modeling the inflammatory response;](http://www.math.pitt.edu/~bard/pubs/lab.html)                                                                                                                                                                                                                                                                                                                                                                            | [Google](https://scholar.google.com/citations?hl=en&user=E73icgUAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| Fiez, Julie              | [Our basic research examines the neural basis of speech, language, reading, working memory, and learning in healthy and patient populations. Complementary applied research draws upon this foundation to inform studies on effective instruction and intervention in reading and math. We use behavioral measures, magnetic resonance imaging, magnetoencephalography, and neuropsychological methods to discover how the brain gives rise to the mind.](https://www.fiezlab.us/)                                                                                                                  | [Google](https://scholar.google.com/citations?hl=en&user=LQNJQjsAAAAJ&view_op=list_works&sortby=pubdate) | =?                  |
| Gandhi, Neeraj J.        | [Tricking the brain into high gear: probing the link between attention and intention; Neural coding through population dynamics; Neural Substrate Underlying Saccades to Moving Targets](http://www.pitt.edu/~neg8/)                                                                                                                                                                                                                                                                                                                                                                                | [Google](https://scholar.google.com/citations?hl=en&user=RCiia08AAAAJ&view_op=list_works&sortby=pubdate) | =?                  |
| Genovese, Christopher R. | [Currently, in neuroscience, I am working with different groups to study the remapping of human's visual representation during and after eye movements and the role of the amygdala and pre-frontal cortex in depression](http://www.stat.cmu.edu/~genovese/?p=research)                                                                                                                                                                                                                                                                                                                            |                                                                                                          | +                   |
| Ghuman, Avniel           | [Specifically, we examine the spatiotemporal dynamics of how neural activity reflects the stages of information processing and how information flow through brain networks responsible for visual perception. We are particularly interested in the dynamic neural representation of faces, bodies, objects, words, and social and affective visual images.](http://www.lcnd.pitt.edu/index.html)                                                                                                                                                                                                   | [Lab](http://www.lcnd.pitt.edu/publications.html)                                                        | =?                  |
| Gittis, Aryn             | [Our research seeks to understand how neural circuits in the basal ganglia are organized and function to shape movement in health and disease. We use optogenetics, electrophysiology, histology, and behavior to study the function of neural circuits in brain slices and in vivo.](https://www.bio.cmu.edu/labs/gittis/)                                                                                                                                                                                                                                                                         | [Google](https://scholar.google.com/citations?hl=en&user=FkS0PMEAAAAJ&view_op=list_works&sortby=pubdate) | =?                  |
| Grover, Pulkit           | [Our lab seeks to attain this understanding through a mix of thought and laboratory experiments, spanning examination of fundamental limits all the way to experiments. Current topics of interest include fundamental and practical understanding of circuits and systems for processing and communicating information; flow of information in neural systems and neural interfaces (and use of this understanding to design radically new neural interfaces); and understanding information and its use by exploring the union of control and communication.](http://users.ece.cmu.edu/~pgrover/) | [Google](https://scholar.google.com/citations?hl=en&user=hklOXvkAAAAJ&view_op=list_works&sortby=pubdate) | =?                  |

</div>

##### Columbia University

- [Center for Theoretical Neuroscience.](https://ctn.zuckermaninstitute.columbia.edu/apply)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)          | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Research                                                                                                        | +/=/- computational |
| ------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------- | ------------------- |
| Abbott, Larry       | [Collaborating with experimentalists. He works with pen and paper, or with computer simulations, to build models of systems other neuroscientists are studying in their labs. Some models are highly abstract, while others contain considerable biophysical detail.](https://zuckermaninstitute.columbia.edu/larry-f-abbott-phd)                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?user=ca_O-WQAAAAJ&hl=en)                                          | +                   |
| Miller, Ken         | [Use theoretical and computational methods to unravel the circuitry of the cerebral cortex, the rules by which this circuitry develops or "self-organizes", and the computational functions of this circuitry. Our guiding hypothesis - motivated by the stereotypical nature of cortical circuitry across sensory modalities and, with somewhat more variability, across motor and "higher-order" cortical areas as well - is that there are fundamental computations done by the cortical circuit that are invariant across highly varying input signals.](https://ctn.zuckermaninstitute.columbia.edu/Ken) | [Google](https://scholar.google.com/citations?hl=en&user=-5ZxgGsAAAAJ&view_op=list_works&sortby=pubdate)        | +                   |
| Cunningham, John    | [Machine learning and its application to science and industry, including in particular using the tools of artificial intelligence to understand biological intelligence and other complex processes.](http://stat.columbia.edu/~cunningham/)                                                                                                                                                                                                                                                                                                                                                                  | [Lab](http://stat.columbia.edu/~cunningham/)                                                                    | +                   |
| Fusi, Stefano       | [He is using math to better understand how the brain itself computes information, especially as related to problem solving, reasoning and decision-making.](https://zuckermaninstitute.columbia.edu/stefano-fusi-phd)                                                                                                                                                                                                                                                                                                                                                                                         | [PubMed](https://www.ncbi.nlm.nih.gov/pubmed?term=%28Fusi%20S%5BAuthor%5D%29%20AND%20Columbia%5BAffiliation%5D) | -                   |
| Litwin-Kumar, Ashok | [Learning algorithms and their neural implementations. How do organisms use their past experiences to adapt their current behavior? How do these neural algorithms compare to those studied in machine learning and artificial intelligence? We approach these questions by working closely with experimental collaborators and building well-constrained models of learning and synaptic plasticity.](http://lk.zuckermaninstitute.columbia.edu/)                                                                                                                                                            |                                                                                                                 | =                   |
| Paninski, Liam      | [I want to build good models of the neural code and use these models to make predictions about mechanisms, decode spike trains, predict responses to novel stimuli, etc. I'm interested in statistical analysis at various levels of the neural code, from ensembles of simultaneously-recorded spike trains down to voltage fluctuations in individual dendritic compartments.](http://kavli.columbia.edu/member/paninski)                                                                                                                                                                                   | [Lab](http://www.stat.columbia.edu/~liam/cv/)                                                                   | +                   |

</div>

##### Johns Hopkins University

- [Neuroscience at JHU](http://neuroscience.jhu.edu/research/area/3)
- [Solomon H. Snyder Department of Neuroscience.](http://neuroscience.jhu.edu/graduate/apply)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)     | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Research                                                               | +/=/- computational |
| -------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------- | ------------------- |
| Aponte, Yeka   | [Our interest is to understand how genetically-identified cell types and their projections drive behaviors essential for survival. Using the mouse as our model system, we apply optogenetics and chemogenetics to manipulate neuronal circuits in awake, behaving mice. In addition, we use a combination of electrophysiology, two-photon fluorescence endomicroscopy, and behavioral assays to elucidate the neuronal basis of survival behaviors, such as feeding, and to determine how these neuronal circuits drive the rewarding and addictive nature of food intake.](http://neuroscience.jhu.edu/research/faculty/2)                                                        |                                                                        | -                   |
| Bastian, Amy   | [My laboratory studies the movements of adults and children who have damage or disease of the central nervous system. We are interested in understanding the mechanisms of different types of movement disorders, as well as how and why different treatments improve movement. We are actively studying how new movements are "learned" and what the course of movement recovery following different types brain damage is.](http://neuroscience.jhu.edu/research/faculty/5)                                                                                                                                                                                                        | [Google](https://scholar.google.com/citations?user=XuCieIUAAAAJ&hl=en) | -                   |
| Shadmehr, Reza | [Our goal is to understand movement control in humans. Our approach stresses a close integration of the viewpoints from robotics and control theory with neuroscience to provide a unique perspective on the nature of the biological computations that underlie the control of movements. Our ultimate goal is to use the language of mathematics to describe how the various parts of the brain contribute to control of movement in humans.](http://neuroscience.jhu.edu/research/faculty/80/)                                                                                                                                                                                    | [Google](https://scholar.google.com/citations?user=UM8YeikAAAAJ&hl=en) | +                   |
| Stuphorn, Veit | [I am interested in the neurophysiological mechanisms that underlie decision-making and self-control, two essential functions of higher executive processes. To this end, in my lab we record the activity of single neurons in awake animals that are engaged in decision-making. This allows us to identify the types of signals that neurons in specific parts of the brain represent and the computations they carry out. I will also study human subjects in the same tasks with the help of fMRI. These parallel experiments will provide comparative information about decision processes in human and non-human primates.](http://neuroscience.jhu.edu/research/faculty/86/) | [Google](https://scholar.google.com/citations?user=3C3nTXwAAAAJ&hl=en) | +                   |

</div>

##### Johns Hopkins University - Janelia Joint Graduate Program

- [Janelia Labs](https://www.janelia.org/our-research)
- [Joint Ph.D. program](https://www.janelia.org/you-janelia/students-postdocs/joint-graduate-program)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s) | Research Areas | Research | +/=/- computational |
| ---------- | -------------- | -------- | ------------------- |


</div>

##### Massachussetts Institute of Technology

- [Brain + Cognitive Sciences, GRE Institution(3514),](https://bcs.mit.edu/academic-program/graduate/graduate-admissions)
- [Center for Brains, Minds and Machines](https://cbmm.mit.edu/about)


<div style="font-size: 0.5rem;">

| PI(Ph.D.s)        | Research Areas                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Research                                                                                                 | +/=/- computational |
| ----------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------- | ------------------- |
| Bear, Mark        | [Our overarching interest is in the question of how experience and deprivation modify synaptic connections in the brain. Experience-dependent synaptic plasticity is the physical substrate of memory, sculpts connections during postnatal development to determine the capabilities and limitations of brain functions, is responsible for the reorganization of the brain after damage, and is vulnerable in numerous psychiatric and neurological diseases and contributes to their symptoms.](https://picower.mit.edu/mark-bear)                                                                                                                                                                               | [Google](https://scholar.google.com/citations?hl=en&user=xobgmhgAAAAJ&view_op=list_works&sortby=pubdate) | +                   |
| DiCarlo, James    | [DiCarlo’s research goal is to reverse engineer the brain mechanisms that underlie human visual intelligence. He and his collaborators have revealed how population image transformations carried out by a deep stack of interconnected neocortical brain areas — called the primate ventral visual stream — are effortlessly able to extract object identity from visual images. His team uses a combination of large-scale neurophysiology, brain imaging, direct neural perturbation methods, and machine learning methods to build and test neurally-mechanistic computational models of the ventral visual stream and its support of cognition and behavior.](https://mcgovern.mit.edu/profile/james-dicarlo/) | [Google](https://scholar.google.com/citations?hl=en&user=qenoZwUAAAAJ)                                   | +                   |
| Fee, Michale      | [For the past six years, our laboratory has focused on studying the cellular, circuit, and mechanical underpinnings of songbird vocalizations. In one current project, we are studying nucleus RA, an area that projects directly to motor neurons of the vocal organ. During song, RA neurons each generate a distinctive and reproducible sequence of brief bursts of spikes. Using a new miniature motorized microdrive developed in this lab (see below), we have been able to record from large populations of RA neurons (~50) in the singing bird to understand how premotor activity maps to vocal output.](http://web.mit.edu/feelab/)                                                                     | [Google](https://scholar.google.com/citations?user=nelvBCQAAAAJ&hl=en)                                   | +                   |
| Jazayeri, Mehdrad | [The Jazayeri lab aims to understand the building blocks of cognition. The brain has a remarkable ability to generate complex behaviors by combining sensory evidence, prior experience, and cost-benefit considerations. Jazayeri’s research probes the neural mechanisms that allow the brain to integrate this plethora of cues, resulting in flexible, goal-directed behavior.](https://mcgovern.mit.edu/profile/mehrdad-jazayeri/)                                                                                                                                                                                                                                                                             | [Google](https://scholar.google.com/citations?user=AkJyWbAAAAAJ&hl=en)                                   | +                   |
| Sompolinsky, Haim | [Sompolinsky’s research goal is to uncover the fundamental principles of the organization, the dynamics and the function of the brain, viewing the brain through multiscale lenses, spanning the molecular, the cellular, and the circuit levels. To achieve this goal, Sompolinsky has developed new theoretical approaches to computational neuroscience based on the principles and methods of statistical physics, and physics of dynamical and stochastic systems.](http://neurophysics.huji.ac.il/)                                                                                                                                                                                                           | [Google](https://scholar.google.com/citations?user=T8o_MdkAAAAJ&hl=en)                                   | +                   |
| Sur, Mriganka     | [The Sur laboratory studies the development, plasticity and dynamics of circuits in the cerebral cortex of the brain. The developing brain requires a genetic blueprint but is also acutely sensitive to experience and the environment. The adult brain responds to external stimuli, and modulates these responses by internal states such as attention, through dynamic changes in information transmission and processing.](https://www.surlab.org/)                                                                                                                                                                                                                                                            | [Lab](https://www.surlab.org/sur-publications/)                                                          | +                   |
| Tenenbaum, Joshua | [Current research in our group explores the computational basis of many aspects of human cognition: learning concepts, judging similarity, inferring causal connections, forming perceptual representations, learning word meanings and syntactic principles in natural language, noticing coincidences and predicting the future, inferring the mental states of other people, and constructing intuitive theories of core domains, such as intuitive physics, psychology, biology, or social structure.](http://web.mit.edu/cocosci/josh.html)                                                                                                                                                                    | [Google](https://scholar.google.com/citations?hl=en&user=rRJ9wTJMUB8C&view_op=list_works&sortby=pubdate) | +                   |

</div>

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Eli Selkin](https://eliselkin.com) has waived all copyright and related or neighboring rights to this work.
