<div class="github-widget" data-repo="sellisd/awesome-complexity"></div>
## [Awesome Complexity](https://sellisd.github.io/awesome-complexity/) [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

A curated list of resources related to complex systems, the scientific field studying systems with multiple interacting parts and emergent properties.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->



<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Concepts

- [Attractor](https://en.wikipedia.org/wiki/Attractor) - A trajectory in the state space of a system in which it tends to evolve towards.
- [Autopoiesis](https://en.wikipedia.org/wiki/Autopoiesis) - The ability of a system to create and maintain itself.
- [Chaos](https://en.wikipedia.org/wiki/Chaos_theory) - Theory of chaotic systems.
- [Complexity](https://en.wikipedia.org/wiki/Complexity) - The subject of complex systems science.
- [Developmental Systems Theory](https://en.wikipedia.org/wiki/Developmental_systems_theory) - Theoretical perspective on biological development, heredity, and evolution.
- [Dissipative System](https://en.wikipedia.org/wiki/Dissipative_system) - A thermodynamically open system far from thermodynamic equilibrium.
- [Distributed Control](https://en.wikipedia.org/wiki/Distributed_control_system) - A control system without a central supervisor.
- [Edge of Chaos](https://en.wikipedia.org/wiki/Edge_of_chaos) - The transition zone between order and disorder.
- [Emergence](https://en.wikipedia.org/wiki/Emergence) - The whole is greater than the sum of the parts.
- [Fractal](https://en.wikipedia.org/wiki/Fractal) - Self-similar structure.
- [Hysteresis](https://en.wikipedia.org/wiki/Hysteresis) - Dependence of the state of a system on its history.
- [Holon](https://en.wikipedia.org/wiki/Holon_(philosophy)) - System that is both a whole and a part.
- [Network/Graph](https://en.wikipedia.org/wiki/Complex_network) - Network with non-trivial topological features.
- [Phase Transition](https://en.wikipedia.org/wiki/Phase_transition) - Transition between states of matter.
- [Robustness](https://en.wikipedia.org/wiki/Robustness) - Ability to tolerate perturbations.
- [Self-Organization](https://en.wikipedia.org/wiki/Self-organization) - The process where form arises from local interactions between parts of an initially disordered system.
- [Simulation](https://en.wikipedia.org/wiki/Simulation) - Imitation of the operation of a real-world process or system.

## Scientific Journals

- [Complexity](https://www.hindawi.com/journals/complexity/) - Cross-disciplinary journal about complex adaptive systems (open access).

## Blogs/Journals

- [The Systems Thinker](https://thesystemsthinker.com/) - Articles with a systems perspective on various topics.
- [Complexity Digest](https://comdig.unam.mx/) - News feed on complexity.
- [Fractal forums](https://fractalforums.org/) - Forum and discussion community about fractals.

## Societies/Communities

- [Complex Systems Society](https://cssociety.org/home) - Scientific society for the study of complex systems.
- [Complexity research](https://complexityresearch.slack.com/) - Informal slack community for keeping up to date with new findings in complex systems research.
- [Complexity Adventures](https://www.complexityadventures.com/) - Complexity community of practice (formerly known as Complexity Weekend).

## Organizations

- [New England Complex Systems Institute (NECSI)](http://www.necsi.edu/) - Independent academic research and educational institution.
- [The Vermont Complex Systems Center](http://vermontcomplexsystems.org/) - Research and educational center (University of Vermont).
- [Santa Fe Institute](https://www.santafe.edu/) - Independent research and education center.
- [Institut rhônalpin des systèmes complexes - IXXI](http://www.ixxi.fr/) - Research center (ENS Lyon).
- [Waterloo Institute for Complexity & Innovation (WICI)](https://uwaterloo.ca/complexity-innovation) - Research center (University of Waterloo).
- [Institut des Systèmes Complexes - Paris Ile-de-France (ISC-PIF)](https://iscpif.fr/) - An inter-institutional organization (CNRS unit) on complex systems research.

## Models

- [Boids](https://en.wikipedia.org/wiki/Boids) - Emergent flocking behavior.
  - [Craig Reynolds' Boids page](https://www.red3d.com/cwr/boids/) - The creator's webpage with lots of links to multiple implementations.
- [Cellular automata](https://en.wikipedia.org/wiki/Cellular_automaton) - Discrete compuation model.
- [Elementary cellular automaton](https://en.wikipedia.org/wiki/Elementary_cellular_automaton) - One-dimensional cellular automata.
- [Game of Life](https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life) - Two-dimensional cellular automaton with emergent life-like patterns.
  - [ConwayLife](http://www.conwaylife.com/) - Community for game-of-life and similar simulations.
  - [golly](http://golly.sourceforge.net/) - State-of-the-art simulator.
  - [Lenia](https://en.wikipedia.org/wiki/Lenia) - Continuous generalization of the game of life.
- [Double pendulum](https://en.wikipedia.org/wiki/Double_pendulum) - Chaotic motion.
- [Kuramoto model](https://en.wikipedia.org/wiki/Kuramoto_model) - Synchronization.
- [Barabási–Albert (BA) model](https://en.wikipedia.org/wiki/Barab%C3%A1si%E2%80%93Albert_model) - Algorithm for generating random graphs with preferential attachment.
- [Schelling's model](https://en.wikipedia.org/wiki/Schelling%27s_model_of_segregation) - Agent-based model for segregation.
- [Ising model](https://en.wikipedia.org/wiki/Ising_model) - Simple model that can show phase transitions.
- [Reaction-diffusion](https://en.wikipedia.org/wiki/Reaction%E2%80%93diffusion_system) - Self-organization and pattern formation model.
- [Abelian sandpile model](https://en.wikipedia.org/wiki/Abelian_sandpile_model) - Model showing self-organized criticality.

## Software

### Freely to use or open source

- [NetLogo](https://ccl.northwestern.edu/netlogo/) - Multi-agent modeling environment based on the LOGO language. It comes with a very large library of toy models.
- [Simulus](https://simulus.readthedocs.io/en/latest/) - ABM library in Python.
- [Swarm](http://www.swarm.org/wiki/Swarm_main_page) - A platform for agent-based models written in Objective-C, models are coded in Java or Objective-C.
- [Repast](https://repast.github.io/) - Agent-based modeling and simulation platforms, models coded in C++ and Java.
- [MASON](https://cs.gmu.edu/~eclab/projects/mason/) - Multiagent simulation library core in Java.
- [HASH](https://hash.ai/) - Graph and agent simulation platform.
- [Hybrid Automata Library](https://github.com/MathOnco/HAL) - Java library for hybrid modeling combining agent-based and partial-differential equation components. 

### Proprietary

- [Stella](https://www.iseesystems.com/store/products/stella-architect.aspx) - Modelling and interactive simulations.
- [Ventity/Vensim](http://www.ventanasystems.com/software/) - Simulation software.
- [Cosmo Tech platform](https://cosmotech.com) - Digital twins simulator software.

## Other Resources

- [Complexity Explorer](https://www.complexityexplorer.org/) - Educational site with news/blog.
- [Map of Complex systems History](http://www.art-sciencefactory.com/complexity-map_feb09.html) - An impressive overview of the evolution of complex systems thinking.
- [Stanford Complexity Group](https://www.youtube.com/user/StanfordComplexity/videos) - YouTube channel with videos from the group's events.
- [Awesome Network Analysis](https://github.com/briatte/awesome-network-analysis) - Resources for analysis of network data.

## Books

- [Wiener, N. (2016). Cybernetics or control and communication in the animal and the machine.](https://worldcat.org/en/title/1155181636) - The book introduced the term cybernetics to describe a self-regulation mechanism.
- [Scheffer, M. (2009). Critical transitions in nature and society. Princeton, N.J: Princeton University Press.](https://worldcat.org/en/title/1229162077) - A nicely written and accessible description of the critical transition and related concepts.
- [Nicolis, G., Basios, V., & (Firm), W. S. (2015). Chaos, information processing and paradoxical games: the legacy of John S. Nicolis. Singapore; Hackensack, N.J.: World Scientific Pub. Co.](https://worldcat.org/en/title/891718596) - An edited volume of studies honoring the legacy of John Nicolis contribution to complex systems.
- [Newman, M. E. J. (2010). Networks: an introduction. Oxford; New York: Oxford University Press.](https://worldcat.org/en/title/923343299) - A comprehensive introduction to network science.
- [Mitchell, S. D. (2013). Unsimple truths: science, complexity, and policy. Chicago: Univ. of Chicago Press.](https://worldcat.org/en/title/855547314) - The book introduces the perspective of  integrative puralism as a way of understanding and studying the world.
- [Maturana, H. R., & Varela, F. J. (2008). The tree of knowledge: the biological roots of human understanding. Boston: Shambhala.](https://worldcat.org/en/title/316152876) - The book is an exposition of the non-representational vew of knowledge.
- [Mandelbrot, B. (2006). The fractal geometry of nature. New York: W.H. Freeman and Company.](https://worldcat.org/en/title/1286107107) - Beautiful introduction to the world of fractals.
- [Kauffman, S. (2014). At Home in the Universe The Search for the Laws of Self-Organization and Complexity. Cary: Oxford University Press, USA.](https://worldcat.org/en/title/36889961) - The book introduces in an accessible way the influence of concepts such as self-organization and the edge of chaos. 
- [Gros, C. (2015). Complex and adaptive dynamical systems: a primer. Cham: Springer.](https://worldcat.org/en/title/906708597) - Technical and accessible introduction to a number of important concepts in complex systems science.
- [Downey, A. (2012). Think complexity. Needham, Massachusetts: Green Tea Press.](https://worldcat.org/en/title/1043913738) - A hands-on approach exploring complex systems models with Python.
- [Boccara, N. (2014). Modeling complex systems. Springer-Verlag New York.](https://worldcat.org/en/title/934989650) - An overview of important mathematical models of complex systems.
- [Barrat, A., Barthelemy, M., & Vespignani, A. (2013). Dynamical processes on complex networks. Cambridge: Cambridge University Press](https://worldcat.org/en/title/849822968) - Dynamic models on complex networks.
