<div class="github-widget" data-repo="seancoyne/awesome-coldfusion"></div>
## Awesome ColdFusion [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

精选的 ColdFusion 框架、库和软件列表. 灵感来自 [awesome-javascript](https://github.com/sorrycc/awesome-javascript).

拉取请求非常受欢迎.

* [Awesome ColdFusion](https://github.com/seancoyne/awesome-coldfusion)
	
----

## Engines

* [Adobe ColdFusion](http://www.adobe.com/products/coldfusion-family.html)
* [Lucee](http://lucee.org/) - 免费、开源 CFML 引擎

## Application Frameworks

* [CFWheels](https://cfwheels.org) - 受 Ruby on Rails 启发的开源 CFML 框架.
* [ColdBox](http://www.coldbox.org) - 企业级 ColdFusion MVC 开发平台
* [FW/1 - Framework One](https://github.com/framework-one/fw1) - 轻量级、约定优于配置、MVC 应用程序框架

## Testing

* [CFSelenium](https://github.com/teamcfadvance/CFSelenium) - ColdFusion 的原生 Selenium RC 绑定
* [MockBox](https://testbox.ortusbooks.com/mocking/mockbox) - ColdFusion 模拟/存根框架
* [MXUnit](https://github.com/mxunit/mxunit) - xUnit 风格的单元测试框架
* [mxunit-watch](https://github.com/atuttle/mxunit-watch) - 观察目录中的文件更改（.cfc、.cfm、.xml）以触发 mxunit 测试套件完全运行，在控制台中显示结果
* [TestBox](https://github.com/Ortus-Solutions/TestBox) - BDD风格的单元测试框架

## Dependency Injection

* [ColdSpring](https://github.com/coldspringframework/coldspring1)  - ColdSpring 使您的 CFC 的配置和依赖关系更易于管理.  ColdSpring 为 ColdFusion 带来了流行的 Java Spring 框架的强大功能.
* [DI/1 - Inject One](https://github.com/framework-one/di1) - 一个非常轻量级的、约定优于配置、依赖注入（控制反转）框架
* [Wirebox](https://wirebox.ortusbooks.com/) - 企业依赖注入框架

## CMS

* [FarCry CMS](https://github.com/farcrycore/plugin-farcrycms)
* [Mura](https://www.murasoftware.com/)
* [Preside CMS](https://github.com/pixl8/Preside-CMS) - 用于 Railo 语言的开源 CMS
* [Slatwall](https://www.slatwallcommerce.com/) - 开源商务平台

## NoSQL

* [CFArango](https://github.com/dajester2013/CFArango) - ColdFusion 的 ArangoDB 客户端
* [CFCouchbase](https://github.com/Ortus-Solutions/cfcouchbase-sdk) - Couchbase NoSQL 和 ColdFusion 的缓存客户端包装器
* [cfmongodb](https://github.com/marcesher/cfmongodb) - ColdFusion 的 MongoDB 客户端包装器

## REST

* [ColdBox REST](https://coldbox.ortusbooks.com/digging-deeper/recipes/building-rest-apis) - 本机 REST 路由和渲染功能
* [FW/1 REST](https://github.com/framework-one/fw1/wiki/Developing-Applications-Manual#controllers-for-rest-apis) - 本机 REST 路由和渲染功能
* [Taffy](http://taffy.io) - ColdFusion 和 Railo 的 REST Web 服务框架
* [CFWheels RESTful](https://guides.cfwheels.org/docs/routing) - CFWheels 鼓励传统的 RESTful 和足智多谋的请求处理风格.

## Other Libraries

* [CacheBox](https://cachebox.ortusbooks.com/) - 企业 ColdFusion 缓存引擎、聚合器和 API
* [cfbackport](https://github.com/misterdai/cfbackport) - 较新版本的 ColdFusion 中包含的向后移植功能.
* [cfpayment](https://github.com/ghidinelli/cfpayment)  - ColdFusion 支付处理库使管道电子商务应用程序变得简单. 信用卡收费从未如此简单. 灵感来自 Ruby 的 ActiveMerchant.
* [BugLogHQ](https://github.com/oarevalo/BugLogHQ) - 异常跟踪
* [JavaLoader](https://github.com/markmandel/JavaLoader) - JavaLoader 是一个库，旨在简化 Java 在 ColdFusion 应用程序中的使用、开发和集成.
* [LogBox](https://logbox.ortusbooks.com/) - 企业 ColdFusion 日志库
* [Moment.cfc](https://github.com/AlumnIQ/momentcfc) - 受 Moment.js 启发的 CFML 日期/时间操作库（不是直接端口）
* [Mustache.cfc](https://github.com/rip747/Mustache.cfc) - [{{ mustache }}](http://mustache.github.io) 对于 ColdFusion
* [UnderscoreCF](https://github.com/russplaysguitar/UnderscoreCF)  - Coldfusion 的 UnderscoreJS 端口. 函数式编程库.

## Editors

* [CFML Package for Sublime Text 3](https://github.com/jcberquist/sublimetext-cfml) - CFML 语法突出显示以及函数和标记完成 [Sublime Text 3](http://www.sublimetext.com)
* [CFML Extension for Visual Studio Code](https://marketplace.visualstudio.com/items?itemName=KamasamaK.vscode-cfml) - CFML 语言扩展 [VSCode](https://code.visualstudio.com/)
* [CFML Language for Atom](https://github.com/atuttle/atom-language-cfml) - CFML 语言插件 [Atom](https://atom.io/)
* [Adobe ColdFusion Builder 3](http://www.adobe.com/products/coldfusion-builder.html) - 来自 Adob​​e 的基于 Eclipse 的 ColdFusion IDE
* [IntelliJ Idea](http://www.jetbrains.com/idea/) - Java IDE、CFML 支持可通过 [plugin](https://github.com/JetBrains/intellij-plugins/tree/master/CFML)
* [cfbrackets](http://cfbrackets.org) - 添加对 ColdFusion 标记语言 (CFML) 的支持 [Brackets Code Editor](http://brackets.io/)
* [CFEclipse](http://cfeclipse.org) - CFML 插件 [Eclipse](http://www.eclipse.org/)
* [TextMate](https://github.com/textmate/coldfusion.tmbundle) - [TextMate](http://macromates.com) 支持 ColdFusion

## Tools

* [CommandBox](https://www.ortussolutions.com/products/commandbox) - ColdFusion (CFML) CLI、包管理器、REPL 等
* [Unofficial Updater](http://www.uu-2.info/) - 帮助安装 ColdFusion 修补程序的实用程序

## References

* [CF411](http://carehart.org/cf411/) - CF411：Charlie Arehart 的 1,800 多种 CFer 工具和资源（超过 150 个类别）
* [CFLib](http://cflib.org/) - 公共函数库项目
* [ColdFusion Koans](https://github.com/nodoherty/ColdFusion-Koans) - ColdFusion Koans 是一组单元测试，用户必须通过填写值来通过这些单元测试
* [ColdFusion UI the Right Way](https://github.com/cfjedimaster/ColdFusion-UI-the-Right-Way) - 演示如何在后端使用 ColdFusion 进行 UI 的文章列表.
* [Learn CF in a Week](http://www.learncfinaweek.com) - 社区驱动的培训计划，在一周内教授您成为 ColdFusion 开发人员所需的所有基础知识.
* [Try ColdFusion](http://trycf.com/) - CFML 实时交互式学习工具

## Resources
* [CFRepo](http://www.cfmlrepo.com/) - Gavin Pickin 创建的 ColdFusion 安装程序存储库
* [lucee5-heroku](https://github.com/mikesprague/lucee5-heroku) - Mike Sprague 将 Lucee 5 应用程序部署到 Heroku 的应用程序模板
* [Vagrant LEMTL](https://github.com/mikesprague/vagrant-lemtl) - 带有 Linux、Nginx、MariaDB（或 MySQL）、Tomcat 和 Lucee 的 Vagrant box，用于使用 Mike Sprague 的 CFML 进行本地开发
* ACF Docker 图像上 [Amazon ECR](https://gallery.ecr.aws/adobe/coldfusion) 和 [Docker Hub](https://hub.docker.com/u/adobecoldfusion) - 来自 Adob​​e 的官方 Docker 图像
* Lucee Docker 图像 [Docker Hub](https://hub.docker.com/u/lucee) - 来自 Lucee 的官方 Docker 镜像

## Documentation

* [Adobe ColdFusion Documentation](https://helpx.adobe.com/coldfusion/home.html) - 官方 Adob​​e ColdFusion 文档
* [CFDocs](http://cfdocs.org/) - UltraFast CFML 文档参考.
* [CFML Tags to CFScript Reference](https://github.com/cfchef/cfml-tag-to-script-conversions) - Tony Junkes 的 CFML 标签到脚本转换
* [CFScript Reference](https://github.com/daccfml/cfscript/blob/master/cfscript.md) - Adam Cameron 的 CFScript 文档
* [Lucee Wiki](https://bitbucket.org/lucee/lucee/wiki/Home) - 官方 Lucee 文档
* [Official Lucee Server Documentation](http://docs.lucee.org/) - 新的 Lucee 文档
* [Railo Documentation](https://github.com/getrailo/railo/wiki) - 官方 Railo 文档

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Sean Coyne](https://github.com/seancoyne/awesome-coldfusion) 已放弃该作品的所有版权和相关或邻接权.
